/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * vmciProcess.h --
 *
 *	VMCI process header.
 */

#ifndef _VMCI_PROCESS_H_
#define _VMCI_PROCESS_H_

#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

#include "vmci_kernel_defs.h"
#include "vmci_defs.h"
#include "vmci_infrastructure.h"
#include "vmci_handle_array.h"

#define MAX_QUEUED_GUESTCALLS_PER_VM  100

typedef struct VMCIProcess VMCIProcess;

int VMCIProcess_Init(void);
int VMCIProcess_Create(VMCIProcess **process, int eventHnd);
void VMCIProcess_Destroy(VMCIProcess *process);
VMCIProcess *VMCIProcess_Get(VMCIId processID);
#endif // _VMCI_PROCESS_H_

