/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * busmem_def.h -- 
 *
 *      Definitions of constants/structs used in communicating 
 *	page info. between VMKernel/VMMon and VMM.
 */

#ifndef	_BUSMEM_DEF_H
#define	_BUSMEM_DEF_H

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_VMMEXT
#define INCLUDE_ALLOW_VMKERNEL
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMNIXMOD
#define INCLUDE_ALLOW_VMCORE
#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"

#include "vm_assert.h"

/*
 * constants
 */

#define BUSMEMDEF_BATCHPAGELIST_MAX                                         \
           (PAGE_SIZE / (sizeof(BPN) + sizeof(MPN) + sizeof(Bool)))

/*
 * types
 */

/*
 * BusMemDef_BatchPageList is used for communicating sets of BPNs/MPNs
 * between the monitor and platform.  The most common use is for passing
 * sets of pages that are intended to be shared, swapped, or ballooned.
 * The "flagList" passes extra info about each corresponding page. For
 * example, with sharing, it is used to indicate whether the page is
 * marked "hintOnly".
 *
 * It is sized so that it fits in a 4KB page. Three arrays are used to
 * better pack the information into the page.
 */
typedef struct BusMemDef_BatchPageList {
   BPN     bpnList[BUSMEMDEF_BATCHPAGELIST_MAX];
   MPN     mpnList[BUSMEMDEF_BATCHPAGELIST_MAX];
   Bool    flagList[BUSMEMDEF_BATCHPAGELIST_MAX];
} BusMemDef_BatchPageList;

MY_ASSERTS(BUSMEMDEFS, 
           ASSERT_ON_COMPILE(sizeof(BusMemDef_BatchPageList) <= PAGE_SIZE);)

#endif
