#ifndef __COMPAT_SLAB_H__
#   define __COMPAT_SLAB_H__


#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 2, 0)
#   include <linux/slab.h>
#else
#   include <linux/malloc.h>
#endif

/*
 * Before 2.6.20, kmem_cache_t was the accepted way to refer to a kmem_cache
 * structure.  Prior to 2.6.15, this structure was called kmem_cache_s, and
 * afterwards it was renamed to kmem_cache.  Here we keep things simple and use
 * the accepted typedef until it became deprecated, at which point we switch
 * over to the kmem_cache name.
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 20)
#   define compat_kmem_cache struct kmem_cache
#else
#   define compat_kmem_cache kmem_cache_t
#endif

#endif /* __COMPAT_SLAB_H__ */
