/* **********************************************************
 * Copyright (C) 2004 VMware, Inc.  All Rights Reserved. -- VMware Confidential
 * **********************************************************/

/*
 * Detect whether there is 'sk_wmem_alloc' member in 'sock'
 * It got renamed from wmem_alloc sometime during 2.5.x.
 */

#include <linux/autoconf.h>
#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 0)
#include <net/sock.h>

void *sock_wmem_alloc_test(struct sock* sk) {
	return &sk->sk_wmem_alloc;
}
#endif
