/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * vmciCommonInt.h --
 *
 * Struct definitions for VMCI internal common code.
 */

#ifndef _VMCI_COMMONINT_H_
#define _VMCI_COMMONINT_H_

#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

#include "vmci_defs.h"
#include "vmci_infrastructure.h"
#include "vmci_handle_array.h"
#include "vmci_kernel_defs.h"
#include "circList.h"

typedef struct CallEntry {
   ListItem      listItem; /* For queuing. */
   VMCICall *call;    /* Pending call. */
} CallEntry;

struct VMCIProcess {
   ListItem      listItem;           /* For global process list. */
   VMCIId   pid;                /* Process id. */
   VMCIHandleArray *sharedMemHandles;  /* Process's shared memory regions. */
};

struct VMCIDatagramProcess {
   VMCILock     callLock;
   VMCIHandle          handle;
   VMCIHost     host;
   uint32            pendingCalls;
   ListItem          *callQueue;
};

struct VMCIContext {
   ListItem                listItem;          /* For global VMCI list. */
   VMCIId             cid;
   ListItem                *guestCallQueue;   /* Head of per VM queue. */
   uint32                  pendingGuestCalls;
   VMCILock           guestCallLock;
   VMCIHandleArray           *datagramArray;    /* Datagrams owned by context. */
   VMCIHandleArray           *groupArray;       /* Groups context is member of. */
   VMCIHandleArray           *sharedMemArray;   /* SM Regions created or attached to. */
   VMCIHost           hostContext;
   uint32                  numSupportedGuestCalls;
   VMCI_Vector             *supportedGuestCalls;
};

#endif /* _VMCI_COMMONINT_H_ */
