/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * vmciDatagram.h --
 *
 *	Internal functions in the VMCI Simple Datagram API.
 */

#ifndef _VMCI_DATAGRAM_H_
#define _VMCI_DATAGRAM_H_

#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

#include "vmciContext.h"

typedef struct VMCIDatagramProcess VMCIDatagramProcess;

int VMCIDatagram_Init(void);
void VMCIDatagram_Exit(void);
void VMCIDatagram_AddContext(VMCIId contextID);
void VMCIDatagram_RemoveContext(VMCIId contextID);

/* Simple datagram API for host context. */
VMCIHandle VMCIDatagram_CreateHnd(VMCIId resourceID, uint32 flags,
                                VMCIDatagramCB clientCB, void *clientData);
void VMCIDatagram_DestroyHnd(VMCIHandle handle);
int VMCIDatagram_Send(VMCIHandle dstHandle, VMCIHandle srcHandle,
                      uint32 payloadSize, void *payload);
Bool VMCIDatagram_CheckGuestCalls(VMCIContext *context);

int VMCIDatagramProcess_Create(VMCIDatagramProcess **outDgmProc,
                               const uintptr_t eventHnd);
void VMCIDatagramProcess_Destroy(VMCIDatagramProcess *dgmProc);
int VMCIDatagramProcess_ReadCall(VMCIDatagramProcess *dgmProc,
                                 void *buf, size_t bufSize);
#endif // _VMCI_DATAGRAM_H_


