/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * vmciDriver.h --
 *
 *	VMCI host driver interface.
 */

#ifndef _VMCI_DRIVER_H_
#define _VMCI_DRIVER_H_

#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

#include "vmci_defs.h"
#include "vmci_infrastructure.h"
#include "vmciContext.h"

//#define VMCI_DEBUG
#ifdef VMCI_DEBUG
#  define VMCI_LOG(_a) Log _a
#else
#  define VMCI_LOG(_a)
#endif

int VMCI_Init(void);
void VMCI_Cleanup(void);
VMCIId VMCI_GetResourceID(void);
Bool VMCI_CheckGuestCalls(VMCIContext *context);

DEBUG_ONLY(EXTERN VMCIHandle vmGroupHandle;)

void VMCIPublicGroup_AddContext(VMCIId contextID);
int VMCIPublicGroup_RemoveContext(VMCIId contextID);

#endif // _VMCI_DRIVER_H_
