#ifndef __COMPAT_WRAPPER_H__
#   define __COMPAT_WRAPPER_H__


/* The mem_map_reserve() API is modified in 2.4.0 --hpreg */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 4, 0)
#   define compat_mem_map_reserve(_page) SetPageReserved(_page)
#   define compat_mem_map_unreserve(_page) ClearPageReserved(_page)
#else
#   include "compat_page.h"
#   include <linux/wrapper.h>

#   define compat_mem_map_reserve(_page) mem_map_reserve(page_to_pfn(_page))
#   define compat_mem_map_unreserve(_page) \
   mem_map_unreserve(page_to_pfn(_page))
#endif


#endif /* __COMPAT_WRAPPER_H__ */
