/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/



#ifndef _INITBLOCK_OLD_H
#define _INITBLOCK_OLD_H

#ifndef _INITBLOCK_H
#error "You did something wrong..."
#endif

#define INIT_BLOCK_MAGIC_V5  (0x1789+12)
#define INIT_BLOCK_MAGIC_V4  (0x1789+11)
#define INIT_BLOCK_MAGIC_V3  (0x1789+1)

typedef struct VmTimeStart20 {
   uint64 count;
   uint64 time;
   uint32 mhzEstimate;
   uint32 pad;
} VmTimeStart20;

typedef struct {
   uint32 magicNumber;     /* Magic number (INIT_BLOCK_MAGIC_V5) */
   Vcpuid numVCPUs;
   VA32 crosspage[MAX_INITBLOCK_CPUS];
} __attribute__ ((packed)) InitBlockV5;

typedef struct {
   uint32 magicNumber;     /* Magic number (INIT_BLOCK_MAGIC_V4) */
   int logFD;
   Vcpuid numVCPUs;
   VA32 crosspage[MAX_INITBLOCK_CPUS];
} __attribute__ ((packed)) InitBlockV4;

typedef struct InitBlockG25 {
   uint32 magicNumber;     /* Magic number (INIT_BLOCK_MAGIC_V3) */
   uint32 flags;           /* option flags  (see below) */
   int logFD;
   VA32 sharedArea;
   Vcpuid numVCPUs;
   VA32 crosspage[MAX_INITBLOCK_CPUS];

   /*
    * output 
    */
   VmTimeStart st __attribute__((packed));

} InitBlockG25;

typedef struct InitBlock30 {
   uint32 magicNumber;     /* Magic number (INIT_BLOCK_MAGIC_V3) */
   uint32 flags;           /* option flags  (see below) */
   int logFD;
   VA32 sharedArea;
   VA32 crosspage;

   /*
    * output 
    */
   VmTimeStart st __attribute__((packed));

} InitBlock30;

typedef struct InitBlock20 {
   uint32 magicNumber;     /* Magic number (INIT_BLOCK_MAGIC_V3) */
   uint32 flags;           /* option flags  (see below) */
   int logFD;
   VA32 sharedArea;
   VA32 crosspage;

   /*
    * output 
    */
   VmTimeStart20 st __attribute__((packed));
   Bool        smpMachine;

} InitBlock20;

#endif
