#ifndef _IOCONTROLS_COMPAT_H_
#define _IOCONTROLS_COMPAT_H_

#define VMMON_VERSION_GSX1      (3 << 16 | 0)
#define VMMON_VERSION_V3        (8 << 16 | 0)
#define VMMON_VERSION_V32       (10 << 16 | 0)
#define VMMON_VERSION_GSX2      (21 << 16 | 0)
#define VMMON_VERSION_V321      (30 << 16 | 0)
#define VMMON_VERSION_GSX25     (41 << 16 | 0)
#define VMMON_VERSION_GSX251    (42 << 16 | 0)
#define VMMON_VERSION_V4        (52 << 16 | 0)
#define VMMON_VERSION_V45       (79 << 16 | 0)
#define VMMON_VERSION_V452      (81 << 16 | 0)
#define VMMON_VERSION_GSX32     (85 << 16 | 0)
#define VMMON_VERSION_V5        (116 << 16 | 0)
#define VMMON_VERSION_V55       (137 << 16 | 0)
#define VMMON_VERSION_S1B1      (138 << 16 | 0)
#define VMMON_VERSION_V6        (161 << 16 | 0)

/*
 * Limit structure for CREATE_VM
 */

#define WSLIMITS_HASH_SIZE 20
typedef struct WSLimitsInfo {
   int32   memsize;   /* Memory size of this VM in MB */
   char    hash[WSLIMITS_HASH_SIZE];
} WSLimitsInfo;


/*
 * Structure for GET_STATS and SET_STATS.
 */

typedef struct {
  uint32 userLockedPages;	/* current count of pages locked by app */
  uint32 maxUserLockedPages;	/* max over time of pages locked by app */
  uint32 monitorLockedPages;	/* current count of pages locked by monitor */
  uint32 maxMonitorLockedPages;	/* max over time of pages locked by monitor */
} VMX86StatsV4;

typedef struct VMGetPCIInfoArgs {
   int busNumber;
   int deviceNumber;
   int functionNumber;
} VMGetPCIInfoArgs;

typedef struct VMGetPCIInfoResult {
   int bus;
   int slot;
   int vendorID;
   int deviceID;
   int baseClass;
   int subClass;
   int interruptLine;
   int interruptVector;
} VMGetPCIInfoResult;

enum IOCTLCmdV2 { 
   IOCTL_VMX86_V2_INIT = 201,
   IOCTL_VMX86_V2_LATE_INIT,
   IOCTL_VMX86_V2_RUN,
   IOCTL_VMX86_V2_LOOKUPMPN,
   IOCTL_VMX86_V2_BEEP,   // 205 
   IOCTL_VMX86_V2_SETUID, // Linux and VMX86_DEVEL only
   IOCTL_VMX86_V2_LOCKPAGE, 
   IOCTL_VMX86_V2_UNLOCKPAGE, 
   IOCTL_VMX86_V2_ISMPSAFE,
   IOCTL_VMX86_V2_APICBASE, // 210
   IOCTL_VMX86_V2_IOAPICBASE,
   IOCTL_VMX86_V2_REGISTER_PASSTHROUGH_IO,
   IOCTL_VMX86_V2_REGISTER_PASSTHROUGH_IRQ,
   IOCTL_VMX86_V2_FREE_PASSTHROUGH_IO,
   IOCTL_VMX86_V2_FREE_PASSTHROUGH_IRQ, // 215
   IOCTL_VMX86_V2_START_PASSTHROUGH,
   IOCTL_VMX86_V2_STOP_PASSTHROUGH,
   IOCTL_VMX86_V2_QUERY_PASSTHROUGH,
   IOCTL_VMX86_V2_GET_NUM_VMS,
   IOCTL_VMX86_V2_DECLARE_SLAVE, // 220
   IOCTL_VMX86_V2_CHECK_MEMORY,
   IOCTL_VMX86_V2_BLUE_SCREEN,
   IOCTL_VMX86_V2_ALLOW_CORE_DUMP,
   IOCTL_VMX86_V2_GET_STATS,
   IOCTL_VMX86_V2_SET_STATS, // 225
   IOCTL_VMX86_V2_SET_HARD_LIMIT,
   IOCTL_VMX86_V2_GET_HARD_LIMIT,
   IOCTL_VMX86_V2_GET_SET_MEM_INFO,
   IOCTL_VMX86_V2_GET_MEM_INFO,
   IOCTL_VMX86_V2_SET_MEM_INFO, // 230
   IOCTL_VMX86_V2_GET_VM_LIST,
   IOCTL_VMX86_V2_GET_VM_INFO,
   IOCTL_VMX86_V2_SET_VM_INFO,
   IOCTL_VMX86_V2_BROADCAST_IPI, // Linux SMP 2.2.8+ only
   IOCTL_VMX86_V2_FREE_RESOURCES,// Linux only, 235
   IOCTL_VMX86_V2_REDUCE_HARD_LIMIT, // Windows 2000 only
   IOCTL_VMX86_V2_LAST
};

enum IOCTLCmdV3 {
   IOCTL_VMX86_V3_VERSION = 201,
   IOCTL_VMX86_V3_CREATE_VM,
   IOCTL_VMX86_V3_BIND_VM,
   IOCTL_VMX86_V3_RELEASE_VM,
   IOCTL_VMX86_V3_GET_NUM_VMS,
   IOCTL_VMX86_V3_INIT_VM,
   IOCTL_VMX86_V3_LATE_INIT_VM,
   IOCTL_VMX86_V3_RUN_VM,
   IOCTL_VMX86_V3_LOOK_UP_MPN,
   IOCTL_VMX86_V3_LOCK_PAGE,
   IOCTL_VMX86_V3_UNLOCK_PAGE,
   IOCTL_VMX86_V3_APIC_BASE,
   IOCTL_VMX86_V3_IOAPIC_BASE,
   IOCTL_VMX86_V3_GET_STATS,
   IOCTL_VMX86_V3_SET_STATS,
   IOCTL_VMX86_V3_GET_HARD_LIMIT,
   IOCTL_VMX86_V3_SET_HARD_LIMIT,
   IOCTL_VMX86_V3_GET_MEM_INFO,
   IOCTL_VMX86_V3_SET_MEM_INFO,
   IOCTL_VMX86_V3_PAE_ENABLED,
   IOCTL_VMX86_V3_GET_TOTAL_MEM_USAGE,

   /*
    * Keep host-specific calls at the end so they can be undefined
    * without renumbering the common calls.
    */

   IOCTL_VMX86_V3_SET_UID,		// VMX86_DEVEL only
   IOCTL_VMX86_V3_IS_MP_SAFE,
   IOCTL_VMX86_V3_GET_MHZ_ESTIMATE,
   IOCTL_VMX86_V3_ALLOW_CORE_DUMP,

   IOCTL_VMX86_V3_CHECK_MEMORY,

   IOCTL_VMX86_V3_BROADCAST_IPI,	// SMP 2.2.8+ only

   IOCTL_VMX86_V3_REGISTER_PASSTHROUGH_IO,
   IOCTL_VMX86_V3_REGISTER_PASSTHROUGH_IRQ,
   IOCTL_VMX86_V3_FREE_PASSTHROUGH_IO,
   IOCTL_VMX86_V3_FREE_PASSTHROUGH_IRQ,
   IOCTL_VMX86_V3_START_PASSTHROUGH,
   IOCTL_VMX86_V3_STOP_PASSTHROUGH,
   IOCTL_VMX86_V3_QUERY_PASSTHROUGH,

   IOCTL_VMX86_V3_REGISTER_PERFCTR,
   IOCTL_VMX86_V3_START_PERFCTR,
   IOCTL_VMX86_V3_STOP_PERFCTR,
   IOCTL_VMX86_V3_RELEASE_PERFCTR,

   IOCTL_VMX86_V32_ALLOC_LOW_PAGES,
   IOCTL_VMX86_V32_FREE_LOW_PAGES,

   IOCTL_VMX86_V321_ADD_WORLD_ARG,
};

enum IOCTLCmdGSX2 {
   IOCTL_VMX86_GSX2_VERSION = 201,
   IOCTL_VMX86_GSX2_CREATE_VM,
   IOCTL_VMX86_GSX2_BIND_VM,
   IOCTL_VMX86_GSX2_RELEASE_VM,
   IOCTL_VMX86_GSX2_GET_NUM_VMS,
   IOCTL_VMX86_GSX2_INIT_VM,
   IOCTL_VMX86_GSX2_LATE_INIT_VM,
   IOCTL_VMX86_GSX2_RUN_VM,
   IOCTL_VMX86_GSX2_LOOK_UP_MPN,
   IOCTL_VMX86_GSX2_LOCK_PAGE,
   IOCTL_VMX86_GSX2_UNLOCK_PAGE,
   IOCTL_VMX86_GSX2_APIC_BASE,
   IOCTL_VMX86_GSX2_IOAPIC_BASE,
   IOCTL_VMX86_GSX2_GET_STATS,
   IOCTL_VMX86_GSX2_SET_STATS,
   IOCTL_VMX86_GSX2_GET_HARD_LIMIT,
   IOCTL_VMX86_GSX2_SET_HARD_LIMIT,
   IOCTL_VMX86_GSX2_GET_MEM_INFO,
   IOCTL_VMX86_GSX2_SET_MEM_INFO,
   IOCTL_VMX86_GSX2_PAE_ENABLED,
   IOCTL_VMX86_GSX2_GET_TOTAL_MEM_USAGE,
   IOCTL_VMX86_GSX2_SET_UID,
   IOCTL_VMX86_GSX2_IS_MP_SAFE,
   IOCTL_VMX86_GSX2_GET_MHZ_ESTIMATE,
   IOCTL_VMX86_GSX2_ALLOW_CORE_DUMP,
   IOCTL_VMX86_GSX2_CHECK_MEMORY,
   IOCTL_VMX86_GSX2_BROADCAST_IPI,
   IOCTL_VMX86_GSX2_REGISTER_PASSTHROUGH_IO,
   IOCTL_VMX86_GSX2_REGISTER_PASSTHROUGH_IRQ,
   IOCTL_VMX86_GSX2_FREE_PASSTHROUGH_IO,
   IOCTL_VMX86_GSX2_FREE_PASSTHROUGH_IRQ,
   IOCTL_VMX86_GSX2_START_PASSTHROUGH,
   IOCTL_VMX86_GSX2_STOP_PASSTHROUGH,
   IOCTL_VMX86_GSX2_QUERY_PASSTHROUGH,
   IOCTL_VMX86_GSX2_REGISTER_PERFCTR,
   IOCTL_VMX86_GSX2_START_PERFCTR,
   IOCTL_VMX86_GSX2_STOP_PERFCTR,
   IOCTL_VMX86_GSX2_RELEASE_PERFCTR,
   IOCTL_VMX86_GSX2_ALLOC_LOW_PAGES,
   IOCTL_VMX86_GSX2_FREE_LOW_PAGES,
   IOCTL_VMX86_GSX2_LAST
};

enum IOCTLCmdGSX25 {
   IOCTL_VMX86_GSX25_VERSION = 201,
   IOCTL_VMX86_GSX25_CREATE_VM,
   IOCTL_VMX86_GSX25_BIND_VM,
   IOCTL_VMX86_GSX25_RELEASE_VM,
   IOCTL_VMX86_GSX25_GET_NUM_VMS,
   IOCTL_VMX86_GSX25_INIT_VM,
   IOCTL_VMX86_GSX25_LATE_INIT_VM,
   IOCTL_VMX86_GSX25_RUN_VM,
   IOCTL_VMX86_GSX25_LOOK_UP_MPN,
   IOCTL_VMX86_GSX25_LOCK_PAGE,
   IOCTL_VMX86_GSX25_UNLOCK_PAGE,
   IOCTL_VMX86_GSX25_APIC_BASE,
   IOCTL_VMX86_GSX25_IOAPIC_BASE,
   IOCTL_VMX86_GSX25_GET_STATS,
   IOCTL_VMX86_GSX25_SET_STATS,
   IOCTL_VMX86_GSX25_GET_HARD_LIMIT,
   IOCTL_VMX86_GSX25_SET_HARD_LIMIT,
   IOCTL_VMX86_GSX25_GET_MEM_INFO,
   IOCTL_VMX86_GSX25_SET_MEM_INFO,
   IOCTL_VMX86_GSX25_PAE_ENABLED,
   IOCTL_VMX86_GSX25_GET_TOTAL_MEM_USAGE,
   IOCTL_VMX86_GSX25_SYNC_GET_TSCS,
   IOCTL_VMX86_GSX25_SYNC_SET_TSCS,
   IOCTL_VMX86_GSX25_GET_KHZ_ESTIMATE,
   IOCTL_VMX86_GSX25_SET_UID,		// VMX86_DEVEL only
   IOCTL_VMX86_GSX25_IS_MP_SAFE,
   IOCTL_VMX86_GSX25_ALLOW_CORE_DUMP,
   IOCTL_VMX86_GSX25_CHECK_MEMORY,
   IOCTL_VMX86_GSX25_BROADCAST_IPI,	// SMP 2.2.8+ only
   IOCTL_VMX86_GSX25_REGISTER_PASSTHROUGH_IO,
   IOCTL_VMX86_GSX25_REGISTER_PASSTHROUGH_IRQ,
   IOCTL_VMX86_GSX25_FREE_PASSTHROUGH_IO,
   IOCTL_VMX86_GSX25_FREE_PASSTHROUGH_IRQ,
   IOCTL_VMX86_GSX25_START_PASSTHROUGH,
   IOCTL_VMX86_GSX25_STOP_PASSTHROUGH,
   IOCTL_VMX86_GSX25_QUERY_PASSTHROUGH,
   IOCTL_VMX86_GSX25_REGISTER_PERFCTR,
   IOCTL_VMX86_GSX25_START_PERFCTR,
   IOCTL_VMX86_GSX25_STOP_PERFCTR,
   IOCTL_VMX86_GSX25_RELEASE_PERFCTR,
   IOCTL_VMX86_GSX25_ALLOC_LOW_PAGES,
   IOCTL_VMX86_GSX25_FREE_LOW_PAGES,
   IOCTL_VMX86_GSX25_LAST,
   IOCTL_VMX86_GSX251_GET_ALL_CPUID = IOCTL_VMX86_GSX25_LAST,
};

enum IOCTLCmdV4 {
   IOCTL_VMX86_V4_VERSION = 201,
   IOCTL_VMX86_V4_CREATE_VM,
   IOCTL_VMX86_V4_BIND_VM,
   IOCTL_VMX86_V4_RELEASE_VM,
   IOCTL_VMX86_V4_GET_NUM_VMS,
   IOCTL_VMX86_V4_INIT_VM,
   IOCTL_VMX86_V4_LATE_INIT_VM,
   IOCTL_VMX86_V4_RUN_VM,
   IOCTL_VMX86_V4_LOOK_UP_MPN,
   IOCTL_VMX86_V4_LOCK_PAGE,
   IOCTL_VMX86_V4_UNLOCK_PAGE,
   IOCTL_VMX86_V4_APIC_BASE,
   IOCTL_VMX86_V4_IOAPIC_BASE,
   IOCTL_VMX86_V4_GET_STATS,
   IOCTL_VMX86_V4_SET_STATS,
   IOCTL_VMX86_V4_GET_HARD_LIMIT,
   IOCTL_VMX86_V4_SET_HARD_LIMIT,
   IOCTL_VMX86_V4_GET_MEM_INFO,
   IOCTL_VMX86_V4_SET_MEM_INFO,
   IOCTL_VMX86_V4_PAE_ENABLED,
   IOCTL_VMX86_V4_GET_TOTAL_MEM_USAGE,
   IOCTL_VMX86_V4_ACK_USER_CALL,
   IOCTL_VMX86_V4_COMPLETE_USER_CALL,
   IOCTL_VMX86_V4_GET_KHZ_ESTIMATE,
   IOCTL_VMX86_V4_SET_UID,		// VMX86_DEVEL only
   IOCTL_VMX86_V4_IS_MP_SAFE,
   IOCTL_VMX86_V4_ALLOW_CORE_DUMP,
   IOCTL_VMX86_V4_CHECK_MEMORY,
   IOCTL_VMX86_V4_BROADCAST_IPI,	// SMP 2.2.8+ only
   IOCTL_VMX86_V4_REGISTER_PASSTHROUGH_IO,
   IOCTL_VMX86_V4_REGISTER_PASSTHROUGH_IRQ,
   IOCTL_VMX86_V4_FREE_PASSTHROUGH_IO,
   IOCTL_VMX86_V4_FREE_PASSTHROUGH_IRQ,
   IOCTL_VMX86_V4_START_PASSTHROUGH,
   IOCTL_VMX86_V4_STOP_PASSTHROUGH,
   IOCTL_VMX86_V4_QUERY_PASSTHROUGH,
   IOCTL_VMX86_V4_REGISTER_PERFCTR,
   IOCTL_VMX86_V4_START_PERFCTR,
   IOCTL_VMX86_V4_STOP_PERFCTR,
   IOCTL_VMX86_V4_RELEASE_PERFCTR,
   IOCTL_VMX86_V4_ALLOC_LOW_PAGES,
   IOCTL_VMX86_V4_FREE_LOW_PAGES,
   IOCTL_VMX86_V4_GET_SYSTEM_CLOCK_RATE,
   IOCTL_VMX86_V4_LAST
};

enum IOCTLCmdV45 {
   IOCTL_VMX86_V45_VERSION = 2001,
   IOCTL_VMX86_V45_CREATE_VM,
   IOCTL_VMX86_V45_BIND_VM,
   IOCTL_VMX86_V45_RELEASE_VM,
   IOCTL_VMX86_V45_GET_NUM_VMS,
   IOCTL_VMX86_V45_INIT_VM,
   IOCTL_VMX86_V45_LATE_INIT_VM,
   IOCTL_VMX86_V45_RUN_VM,
   IOCTL_VMX86_V45_LOOK_UP_MPN,
   IOCTL_VMX86_V45_LOCK_PAGE,
   IOCTL_VMX86_V45_UNLOCK_PAGE,
   IOCTL_VMX86_V45_APIC_BASE,
   IOCTL_VMX86_V45_IOAPIC_BASE,
   IOCTL_VMX86_V45_GET_HARD_LIMIT,
   IOCTL_VMX86_V45_SET_HARD_LIMIT,
   IOCTL_VMX86_V45_GET_MEM_INFO,
   IOCTL_VMX86_V45_SET_MEM_INFO,
   IOCTL_VMX86_V45_SET_MEM_USAGE,
   IOCTL_VMX86_V45_PAE_ENABLED,
   IOCTL_VMX86_V45_HOST_X86_64,
   IOCTL_VMX86_V45_GET_TOTAL_MEM_USAGE,
   IOCTL_VMX86_V45_ACK_USER_CALL,
   IOCTL_VMX86_V45_COMPLETE_USER_CALL,
   IOCTL_VMX86_V45_GET_KHZ_ESTIMATE,
   IOCTL_VMX86_V45_READ_PAGE,
   IOCTL_VMX86_V45_WRITE_PAGE,
   IOCTL_VMX86_V45_LOCK_PAGE_NEW,
   IOCTL_VMX86_V45_UNLOCK_PAGE_BY_MPN,
   IOCTL_VMX86_V45_MARK_LOCKEDVARANGE_CLEAN,
   IOCTL_VMX86_V45_ALLOC_LOCKED_PAGES,
   IOCTL_VMX86_V45_FREE_LOCKED_PAGES,
   IOCTL_VMX86_V45_GET_LOCKED_PAGES_LIST,
   IOCTL_VMX86_V45_MAP_LOCKED_PAGES,
   IOCTL_VMX86_V45_UNMAP_LOCKED_PAGES,
   IOCTL_VMX86_V45_SET_UID,	// VMX86_DEVEL only
   IOCTL_VMX86_V45_IS_MP_SAFE,
   IOCTL_VMX86_V45_ALLOW_CORE_DUMP,
   IOCTL_VMX86_V45_BROADCAST_IPI,	// SMP 2.2.8+ only
   IOCTL_VMX86_V45_REGISTER_PASSTHROUGH_IO,
   IOCTL_VMX86_V45_REGISTER_PASSTHROUGH_IRQ,
   IOCTL_VMX86_V45_FREE_PASSTHROUGH_IO,
   IOCTL_VMX86_V45_FREE_PASSTHROUGH_IRQ,
   IOCTL_VMX86_V45_START_PASSTHROUGH,
   IOCTL_VMX86_V45_STOP_PASSTHROUGH,
   IOCTL_VMX86_V45_QUERY_PASSTHROUGH,
   IOCTL_VMX86_V45_REGISTER_PERFCTR,
   IOCTL_VMX86_V45_START_PERFCTR,
   IOCTL_VMX86_V45_STOP_PERFCTR,
   IOCTL_VMX86_V45_RELEASE_PERFCTR,
   IOCTL_VMX86_V45_ALLOC_LOW_PAGES,
   IOCTL_VMX86_V45_FREE_LOW_PAGES,
   IOCTL_VMX86_V45_GET_ALL_CPUID,
   IOCTL_VMX86_V45_LAST
};

enum IOCTLCmdGSX32 {
   IOCTL_VMX86_GSX32_VERSION = 2001,
   IOCTL_VMX86_GSX32_CREATE_VM,
   IOCTL_VMX86_GSX32_BIND_VM,
   IOCTL_VMX86_GSX32_RELEASE_VM,
   IOCTL_VMX86_GSX32_GET_NUM_VMS,
   IOCTL_VMX86_GSX32_INIT_VM,
   IOCTL_VMX86_GSX32_LATE_INIT_VM,
   IOCTL_VMX86_GSX32_RUN_VM,
   IOCTL_VMX86_GSX32_LOOK_UP_MPN,
   IOCTL_VMX86_GSX32_LOCK_PAGE,
   IOCTL_VMX86_GSX32_UNLOCK_PAGE,
   IOCTL_VMX86_GSX32_APIC_BASE,
   IOCTL_VMX86_GSX32_IOAPIC_BASE,
   IOCTL_VMX86_GSX32_GET_HARD_LIMIT,
   IOCTL_VMX86_GSX32_SET_HARD_LIMIT,
   IOCTL_VMX86_GSX32_GET_MEM_INFO,
   IOCTL_VMX86_GSX32_SET_MEM_INFO,
   IOCTL_VMX86_GSX32_SET_MEM_USAGE,
   IOCTL_VMX86_GSX32_PAE_ENABLED,
   IOCTL_VMX86_GSX32_HOST_X86_64,
   IOCTL_VMX86_GSX32_GET_TOTAL_MEM_USAGE,
   IOCTL_VMX86_GSX32_ACK_USER_CALL,
   IOCTL_VMX86_GSX32_COMPLETE_USER_CALL,
   IOCTL_VMX86_GSX32_GET_KHZ_ESTIMATE,
   IOCTL_VMX86_GSX32_READ_PAGE,
   IOCTL_VMX86_GSX32_WRITE_PAGE,
   IOCTL_VMX86_GSX32_LOCK_PAGE_NEW,
   IOCTL_VMX86_GSX32_UNLOCK_PAGE_BY_MPN,
   IOCTL_VMX86_GSX32_MARK_LOCKEDVARANGE_CLEAN,
   IOCTL_VMX86_GSX32_ALLOC_LOCKED_PAGES,
   IOCTL_VMX86_GSX32_FREE_LOCKED_PAGES,
   IOCTL_VMX86_GSX32_GET_LOCKED_PAGES_LIST,
   IOCTL_VMX86_GSX32_MAP_LOCKED_PAGES,
   IOCTL_VMX86_GSX32_UNMAP_LOCKED_PAGES,
   IOCTL_VMX86_GSX32_APIC_ID,
   IOCTL_VMX86_GSX32_SET_UID,
   IOCTL_VMX86_GSX32_IS_MP_SAFE,
   IOCTL_VMX86_GSX32_ALLOW_CORE_DUMP,
   IOCTL_VMX86_GSX32_BROADCAST_IPI,
   IOCTL_VMX86_GSX32_REGISTER_PASSTHROUGH_IO,
   IOCTL_VMX86_GSX32_REGISTER_PASSTHROUGH_IRQ,
   IOCTL_VMX86_GSX32_FREE_PASSTHROUGH_IO,
   IOCTL_VMX86_GSX32_FREE_PASSTHROUGH_IRQ,
   IOCTL_VMX86_GSX32_START_PASSTHROUGH,
   IOCTL_VMX86_GSX32_STOP_PASSTHROUGH,
   IOCTL_VMX86_GSX32_QUERY_PASSTHROUGH,
   IOCTL_VMX86_GSX32_REGISTER_PERFCTR,
   IOCTL_VMX86_GSX32_START_PERFCTR,
   IOCTL_VMX86_GSX32_STOP_PERFCTR,
   IOCTL_VMX86_GSX32_RELEASE_PERFCTR,
   IOCTL_VMX86_GSX32_ALLOC_LOW_PAGES,
   IOCTL_VMX86_GSX32_FREE_LOW_PAGES,
   IOCTL_VMX86_GSX32_GET_ALL_CPUID,
   IOCTL_VMX86_GSX32_SET_THREAD_AFFINITY,
   IOCTL_VMX86_GSX32_GET_THREAD_AFFINITY,
   IOCTL_VMX86_GSX32_LAST
};

enum IOCTLCmdV5 {
   IOCTL_VMX86_V5_VERSION = 2001,
   IOCTL_VMX86_V5_CREATE_VM,
   IOCTL_VMX86_V5_BIND_VM,
   IOCTL_VMX86_V5_RELEASE_VM,
   IOCTL_VMX86_V5_GET_NUM_VMS,
   IOCTL_VMX86_V5_INIT_VM,
   IOCTL_VMX86_V5_LATE_INIT_VM,
   IOCTL_VMX86_V5_RUN_VM,
   IOCTL_VMX86_V5_LOOK_UP_MPN,
   IOCTL_VMX86_V5_LOCK_PAGE,
   IOCTL_VMX86_V5_UNLOCK_PAGE,
   IOCTL_VMX86_V5_APIC_BASE,
   IOCTL_VMX86_V5_GET_HARD_LIMIT,
   IOCTL_VMX86_V5_SET_HARD_LIMIT,
   IOCTL_VMX86_V5_GET_MEM_INFO,
   IOCTL_VMX86_V5_ADMIT,
   IOCTL_VMX86_V5_SET_MEM_USAGE,
   IOCTL_VMX86_V5_READMIT,
   IOCTL_VMX86_V5_PAE_ENABLED,
   IOCTL_VMX86_V5_HOST_X86_64,
   IOCTL_VMX86_V5_GET_TOTAL_MEM_USAGE,
   IOCTL_VMX86_V5_ACK_USER_CALL,
   IOCTL_VMX86_V5_COMPLETE_USER_CALL,
   IOCTL_VMX86_V5_GET_KHZ_ESTIMATE,
   IOCTL_VMX86_V5_SET_HOST_CLOCK_RATE,
   IOCTL_VMX86_V5_READ_PAGE,
   IOCTL_VMX86_V5_WRITE_PAGE,
   IOCTL_VMX86_V5_LOCK_PAGE_NEW,
   IOCTL_VMX86_V5_UNLOCK_PAGE_BY_MPN,
   IOCTL_VMX86_V5_MARK_LOCKEDVARANGE_CLEAN,
   IOCTL_VMX86_V5_COW_SHARE,
   IOCTL_VMX86_V5_COW_CHECK,
   IOCTL_VMX86_V5_COW_UPDATE_HINT,
   IOCTL_VMX86_V5_COW_COPY_PAGE,
   IOCTL_VMX86_V5_COW_REMOVE_HINT,
   IOCTL_VMX86_V5_ALLOC_LOCKED_PAGES,
   IOCTL_VMX86_V5_FREE_LOCKED_PAGES,
   IOCTL_VMX86_V5_GET_LOCKED_PAGES_LIST,
   IOCTL_VMX86_V5_MAP_LOCKED_PAGES,
   IOCTL_VMX86_V5_UNMAP_LOCKED_PAGES,
   IOCTL_VMX86_V5_SET_UID,		// VMX86_DEVEL only
   IOCTL_VMX86_V5_IS_MP_SAFE,
   IOCTL_VMX86_V5_ALLOW_CORE_DUMP,
   IOCTL_VMX86_V5_BROADCAST_IPI,	// SMP 2.2.8+ only
   IOCTL_VMX86_V5_REGISTER_PASSTHROUGH_IO,
   IOCTL_VMX86_V5_REGISTER_PASSTHROUGH_IRQ,
   IOCTL_VMX86_V5_FREE_PASSTHROUGH_IO,
   IOCTL_VMX86_V5_FREE_PASSTHROUGH_IRQ,
   IOCTL_VMX86_V5_START_PASSTHROUGH,
   IOCTL_VMX86_V5_STOP_PASSTHROUGH,
   IOCTL_VMX86_V5_QUERY_PASSTHROUGH,
   IOCTL_VMX86_V5_REGISTER_PERFCTR,
   IOCTL_VMX86_V5_START_PERFCTR,
   IOCTL_VMX86_V5_STOP_PERFCTR,
   IOCTL_VMX86_V5_RELEASE_PERFCTR,
   IOCTL_VMX86_V5_ALLOC_LOW_PAGES,
   IOCTL_VMX86_V5_FREE_LOW_PAGES,
   IOCTL_VMX86_V5_GET_ALL_CPUID,
   IOCTL_VMX86_V5_LAST
};

enum IOCTLCmdS1B1 {
   IOCTL_VMX86_S1B1_VERSION = 2001,
   IOCTL_VMX86_S1B1_CREATE_VM,
   IOCTL_VMX86_S1B1_BIND_VM,
   IOCTL_VMX86_S1B1_RELEASE_VM,
   IOCTL_VMX86_S1B1_GET_NUM_VMS,
   IOCTL_VMX86_S1B1_INIT_VM,
   IOCTL_VMX86_S1B1_LATE_INIT_VM,
   IOCTL_VMX86_S1B1_RUN_VM,
   IOCTL_VMX86_S1B1_LOOK_UP_MPN,
   IOCTL_VMX86_S1B1_LOCK_PAGE,
   IOCTL_VMX86_S1B1_UNLOCK_PAGE,
   IOCTL_VMX86_S1B1_APIC_BASE,
   IOCTL_VMX86_S1B1_GET_HARD_LIMIT,
   IOCTL_VMX86_S1B1_SET_HARD_LIMIT,
   IOCTL_VMX86_S1B1_GET_MEM_INFO,
   IOCTL_VMX86_S1B1_ADMIT,
   IOCTL_VMX86_S1B1_SET_MEM_USAGE,
   IOCTL_VMX86_S1B1_READMIT,
   IOCTL_VMX86_S1B1_PAE_ENABLED,
   IOCTL_VMX86_S1B1_HOST_X86_64,
   IOCTL_VMX86_S1B1_GET_TOTAL_MEM_USAGE,
   IOCTL_VMX86_S1B1_ACK_USER_CALL,
   IOCTL_VMX86_S1B1_COMPLETE_USER_CALL,
   IOCTL_VMX86_S1B1_GET_KHZ_ESTIMATE,
   IOCTL_VMX86_S1B1_SET_HOST_CLOCK_RATE,
   IOCTL_VMX86_S1B1_READ_PAGE,
   IOCTL_VMX86_S1B1_WRITE_PAGE,
   IOCTL_VMX86_S1B1_LOCK_PAGE_NEW,
   IOCTL_VMX86_S1B1_UNLOCK_PAGE_BY_MPN,
   IOCTL_VMX86_S1B1_MARK_LOCKEDVARANGE_CLEAN,
   IOCTL_VMX86_S1B1_COW_SHARE,
   IOCTL_VMX86_S1B1_COW_CHECK,
   IOCTL_VMX86_S1B1_COW_UPDATE_HINT,
   IOCTL_VMX86_S1B1_COW_COPY_PAGE,
   IOCTL_VMX86_S1B1_COW_REMOVE_HINT,
   IOCTL_VMX86_S1B1_COW_GET_ZERO_MPN,
   IOCTL_VMX86_S1B1_ALLOC_LOCKED_PAGES,
   IOCTL_VMX86_S1B1_FREE_LOCKED_PAGES,
   IOCTL_VMX86_S1B1_GET_LOCKED_PAGES_LIST,
   IOCTL_VMX86_S1B1_MAP_LOCKED_PAGES,
   IOCTL_VMX86_S1B1_UNMAP_LOCKED_PAGES,
   IOCTL_VMX86_S1B1_APIC_ID,
   IOCTL_VMX86_S1B1_VT_CAPABLE_CPU,
   IOCTL_VMX86_S1B1_VT_SUPPORTED_CPU,
   IOCTL_VMX86_S1B1_SET_UID,
   IOCTL_VMX86_S1B1_IS_MP_SAFE,
   IOCTL_VMX86_S1B1_ALLOW_CORE_DUMP,
   IOCTL_VMX86_S1B1_BROADCAST_IPI,
   IOCTL_VMX86_S1B1_REGISTER_PASSTHROUGH_IO,
   IOCTL_VMX86_S1B1_REGISTER_PASSTHROUGH_IRQ,
   IOCTL_VMX86_S1B1_FREE_PASSTHROUGH_IO,
   IOCTL_VMX86_S1B1_FREE_PASSTHROUGH_IRQ,
   IOCTL_VMX86_S1B1_START_PASSTHROUGH,
   IOCTL_VMX86_S1B1_STOP_PASSTHROUGH,
   IOCTL_VMX86_S1B1_QUERY_PASSTHROUGH,
   IOCTL_VMX86_S1B1_REGISTER_PERFCTR,
   IOCTL_VMX86_S1B1_START_PERFCTR,
   IOCTL_VMX86_S1B1_STOP_PERFCTR,
   IOCTL_VMX86_S1B1_RELEASE_PERFCTR,
   IOCTL_VMX86_S1B1_ALLOC_LOW_PAGES,
   IOCTL_VMX86_S1B1_FREE_LOW_PAGES,
   IOCTL_VMX86_S1B1_GET_ALL_CPUID,
   IOCTL_VMX86_S1B1_SET_THREAD_AFFINITY,
   IOCTL_VMX86_S1B1_GET_THREAD_AFFINITY,
   IOCTL_VMX86_S1B1_SET_POLL_TIMEOUT_PTR,
   IOCTL_VMX86_S1B1_GET_KERNEL_CLOCK_RATE,
   IOCTL_VMX86_S1B1_LAST
};

enum IOCTLCmdV6 {
   IOCTL_VMX86_V6_VERSION = 2001,
   IOCTL_VMX86_V6_CREATE_VM,
   IOCTL_VMX86_V6_RELEASE_VM,
   IOCTL_VMX86_V6_GET_NUM_VMS,
   IOCTL_VMX86_V6_INIT_VM,
   IOCTL_VMX86_V6_LATE_INIT_VM,
   IOCTL_VMX86_V6_RUN_VM,
   IOCTL_VMX86_V6_LOOK_UP_MPN,
   IOCTL_VMX86_V6_LOCK_PAGE,
   IOCTL_VMX86_V6_UNLOCK_PAGE,
   IOCTL_VMX86_V6_APIC_BASE,
   IOCTL_VMX86_V6_SET_HARD_LIMIT,
   IOCTL_VMX86_V6_GET_MEM_INFO,
   IOCTL_VMX86_V6_ADMIT,
   IOCTL_VMX86_V6_SET_MEM_USAGE,
   IOCTL_VMX86_V6_READMIT,
   IOCTL_VMX86_V6_PAE_ENABLED,
   IOCTL_VMX86_V6_HOST_X86_64,
   IOCTL_VMX86_V6_GET_TOTAL_MEM_USAGE,
   IOCTL_VMX86_V6_COMPLETE_USER_CALL,
   IOCTL_VMX86_V6_GET_KHZ_ESTIMATE,
   IOCTL_VMX86_V6_SET_HOST_CLOCK_RATE,
   IOCTL_VMX86_V6_READ_PAGE,
   IOCTL_VMX86_V6_WRITE_PAGE,
   IOCTL_VMX86_V6_LOCK_PAGE_NEW,
   IOCTL_VMX86_V6_UNLOCK_PAGE_BY_MPN,
   IOCTL_VMX86_V6_MARK_LOCKEDVARANGE_CLEAN,
   IOCTL_VMX86_V6_COW_SHARE,
   IOCTL_VMX86_V6_COW_CHECK,
   IOCTL_VMX86_V6_COW_UPDATE_HINT,
   IOCTL_VMX86_V6_COW_COPY_PAGE,
   IOCTL_VMX86_V6_COW_REMOVE_HINT,
   IOCTL_VMX86_V6_COW_GET_ZERO_MPN,
   IOCTL_VMX86_V6_ALLOC_LOCKED_PAGES,
   IOCTL_VMX86_V6_FREE_LOCKED_PAGES,
   IOCTL_VMX86_V6_GET_LOCKED_PAGES_LIST,
   IOCTL_VMX86_V6_APIC_ID,
   IOCTL_VMX86_V6_SVM_ENABLED_CPU,
   IOCTL_VMX86_V6_VT_ENABLED_CPU,
   IOCTL_VMX86_V6_VT_SUPPORTED_CPU,
   IOCTL_VMX86_V6_BROKEN_CPU_HELPER,
   IOCTL_VMX86_V6_INIT_CONTEXT,
   IOCTL_VMX86_V6_CREATE_PROCESS,
   IOCTL_VMX86_V6_CREATE_DATAGRAM_PROCESS,
   IOCTL_VMX86_V6_HYPERCALL,
   IOCTL_VMX86_V6_READ_CALL,
   IOCTL_VMX86_V6_SHAREDMEM_CREATE,
   IOCTL_VMX86_V6_SHAREDMEM_ATTACH,
   IOCTL_VMX86_V6_SHAREDMEM_QUERY,
   IOCTL_VMX86_V6_SHAREDMEM_DETACH,
   IOCTL_VMX86_V6_COUNT_PRESENT_PAGES,
   IOCTL_VMX86_V6_INIT_NUMA_INFO,
   IOCTL_VMX86_V6_GET_NUMA_MEM_STATS,
   IOCTL_VMX86_V6_SET_UID,
   IOCTL_VMX86_V6_ALLOW_CORE_DUMP,
   IOCTL_VMX86_V6_BROADCAST_IPI,
   IOCTL_VMX86_V6_REGISTER_PASSTHROUGH_IO,
   IOCTL_VMX86_V6_REGISTER_PASSTHROUGH_IRQ,
   IOCTL_VMX86_V6_FREE_PASSTHROUGH_IO,
   IOCTL_VMX86_V6_FREE_PASSTHROUGH_IRQ,
   IOCTL_VMX86_V6_START_PASSTHROUGH,
   IOCTL_VMX86_V6_STOP_PASSTHROUGH,
   IOCTL_VMX86_V6_QUERY_PASSTHROUGH,
   IOCTL_VMX86_V6_REGISTER_PERFCTR,
   IOCTL_VMX86_V6_START_PERFCTR,
   IOCTL_VMX86_V6_STOP_PERFCTR,
   IOCTL_VMX86_V6_RELEASE_PERFCTR,
   IOCTL_VMX86_V6_GET_ALL_CPUID,
   IOCTL_VMX86_V6_SET_THREAD_AFFINITY,
   IOCTL_VMX86_V6_GET_THREAD_AFFINITY,
   IOCTL_VMX86_V6_GET_KERNEL_CLOCK_RATE,
   IOCTL_VMX86_V6_ACK_USER_CALL,
   IOCTL_VMX86_V6_SET_POLL_TIMEOUT_PTR,
   IOCTL_VMX86_V6_IS_MP_SAFE,
   IOCTL_VMX86_V6_FAST_MON_SWITCH_START,
   IOCTL_VMX86_V6_FAST_MON_SWITCH_IS_DONE,
   IOCTL_VMX86_V6_FAST_MON_SWITCH_TRANSFER,
   IOCTL_VMX86_V6_FAST_MON_SWITCH_END,
   IOCTL_VMX86_V6_LAST
};


#define VM_NAME_LENGTH        64
#define VM_USER_NAME_LENGTH   32

/*
 * Structure returned from GET_VM_LIST v2 ioctl.
 */
typedef struct {
   uint32   vmCount;
   uint32   vmUIDs[1];
} VMGetVMListResult;

typedef enum {
   VM_INFO_OFF,
   VM_INFO_RUNNING,
   VM_INFO_SUSPENDED,
   VM_INFO_BLOCKED,
} VMInfoState;

/*
 * Structure sent into VM_SET_INFO v2 ioctl.
 */
typedef struct {
   uint32		port;
   char			name[VM_NAME_LENGTH];
   char     		userName[VM_USER_NAME_LENGTH];
   VMInfoState 		state;
} VMSetVMInfoArgs;
/*
 * Structure returned from GET_VM_INFO v2 ioctl.
 */
typedef struct {
   uint32         vmUID;
   int32          port;
   char           name[VM_NAME_LENGTH];
   char           userName[VM_USER_NAME_LENGTH];
   VMInfoState	  state;
} VMGetVMInfoResult;

#ifdef VMX86_SERVER
#define FILE_LENGTH_ARGS_NAMELEN 256
/* Structure to get file length */
typedef struct VMFSFileLengthArgs {
   char fileName[FILE_LENGTH_ARGS_NAMELEN];
   long long length;
} VMFSFileLengthArgs;
#endif

typedef struct VMMemMgmtInfoCompat {
   int32   pageFaultRate;
   int32   lockFailRate;
   int32   maxLocked;
   int32   highWaterMark;
   int32   waitingForMemoryTime;
   int32   poweringOn;
   int32   hasFocus;
   uint32  guestmemSize;
} VMMemMgmtInfoCompat;

typedef struct VMMemMgmtInfoV4 {
   int32   pageFaultRate;
   int32   lockFailRate;
   int32   maxLocked;
   int32   currentLocked;
   int32   highWaterMark;
   int32   waitingForMemoryTime;
   int32   poweringOn;
   int32   hasFocus;
} VMMemMgmtInfoV4;

typedef struct VMMemMgmtInfoV45 {
   uint32          minAllocation;   // minimum pages for vm
   uint32          maxAllocation;   // maximum pages the vm could lock
   uint32          shares;          // proportional sharing weight
   uint32	   guestmemSize;
   uint32          nonpaged;        // overhead memory
   uint32          paged;           // nonmainMem guest memory
   uint32          locked;          // number of pages locked by this vm
   uint32          usedPct;         // % of guest memory being touched
   uint32          admitted;        // admission control
} VMMemMgmtInfoV45;

typedef struct VMSetMemInfoArgsV4 {
   VMMemMgmtInfoV4 info;
} VMSetMemInfoArgsV4;

typedef struct VMGetMemInfoArgsV4 {
   uint32           numVMs;
   uint32           numLockedPages;
   uint32           maxLockedPages;
   uint32           callerIndex;
   VMMemMgmtInfoV4  memMgmtInfo[1];
} VMGetMemInfoArgsV4;

#define VM_GET_MEM_INFO_SIZE_V4(numVMs) \
   ((numVMs - 1) * sizeof (VMMemMgmtInfoV4) + sizeof (VMGetMemInfoArgsV4))

typedef struct {
   uint32          numVMs;
   uint32          minVmMemPct;        // % of vm that must fit in maxLockedPages
   uint32          globalMinAllocation;// pages that must fit in maxLockedPages
   uint32          numLockedPages;     // total locked pages by all vms
   LockedPageLimit lockedPageLimit;    // set of locked page limits
   uint32          maxLockedPages;     // effective limit on locked pages
   uint32          callerIndex;        // this vm's index memInfo array
   VMMemMgmtInfoV45   memInfo[1];
} VMMemInfoArgsV45;

#define VM_GET_MEM_INFO_SIZE_V45(numVMs) \
   ((numVMs - 1) * sizeof (VMMemMgmtInfo) + sizeof (VMMemInfoArgsV45))

typedef struct {
   VA32     addr;
   unsigned len;
} VARangeV45;

#endif /* _IOCONTROLS_COMPAT_H_ */
