/* **********************************************************
 * Copyright 1998-2003 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 * **********************************************************/

/*
 * vm_asm.h
 *
 *	asm macros
 */

#ifndef _VM_ASM_H_
#define _VM_ASM_H_

#define INCLUDE_ALLOW_VMMEXT
#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMNIXMOD
#define INCLUDE_ALLOW_VMK_MODULE
#define INCLUDE_ALLOW_VMKERNEL
#define INCLUDE_ALLOW_DISTRIBUTE
#define INCLUDE_ALLOW_VMCORE
#define INCLUDE_ALLOW_VMMON
#include "includeCheck.h"

#include "vm_basic_asm.h"

#ifdef VM_X86_64
#include "vm_asm_x86_64.h"
#else
#include "vm_asm_x86.h"
#endif

static INLINE void SET_FS64(uint64 fs64)
{
   __SET_MSR(0xc0000100, fs64);
}

static INLINE void SET_GS64(uint64 gs64)
{
   __SET_MSR(0xc0000101, gs64);
}

static INLINE void SET_KernelGS64(uint64 kgs64)
{
   __SET_MSR(0xc0000102, kgs64);
}

static INLINE uint64 GET_FS64(void)
{
   return __GET_MSR(0xc0000100);
}

static INLINE uint64 GET_GS64(void)
{
   return __GET_MSR(0xc0000101);
}

static INLINE uint64 GET_KernelGS64(void)
{
   return __GET_MSR(0xc0000102);
}

#endif
