/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved.
 * VMware Confidential
 * **********************************************************/

/*
 * x86regname.h --
 *
 *      Enumerations for x86 register names.
 */

#ifndef _X86REGNAME_H_
#define _X86REGNAME_H_

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_VMMEXT
#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMNIXMOD
#define INCLUDE_ALLOW_VMK_MODULE
#define INCLUDE_ALLOW_VMKERNEL
#define INCLUDE_ALLOW_DISTRIBUTE
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

/*
 * General-purpose registers and segment registers 
 *
 * REG_NULL indicates the absence of a register in certain APIs. 
 * REG_ZERO denotes a special register that always contains zero.
 * In other words: 
 *    - VREG[REG_NULL] is an error
 *    - VREG[REG_ZERO] evaluates to zero.
 */
typedef enum RegisterName {
   REG_NULL = -1, // -1 so that NUM_REGS32 doesn't include REG_NULL

   REG_RAX, REG_EAX = REG_RAX,
   REG_RCX, REG_ECX = REG_RCX,
   REG_RDX, REG_EDX = REG_RDX,
   REG_RBX, REG_EBX = REG_RBX,
   REG_RSP, REG_ESP = REG_RSP,
   REG_RBP, REG_EBP = REG_RBP,
   REG_RSI, REG_ESI = REG_RSI,
   REG_RDI, REG_EDI = REG_RDI,
   REG_R8, REG_R9, REG_R10, REG_R11, REG_R12, REG_R13, REG_R14, REG_R15,

   REG_ZERO = 16,  /* Not a real register, not counted in "NUM_REGS". */
   REG_IMM  = 17,  /* Not a real register, not counted in "NUM_REGS". */
   NUM_REGS = 16,
   NUM_REGS32 = 8
} RegisterName;

typedef enum RegisterName8 {
   REG8_NULL = -1,
   REG8_AL,
   REG8_CL,
   REG8_DL,
   REG8_BL,
   REG8_AH,
   REG8_CH,
   REG8_DH,
   REG8_BH,
   NUM_REG8S
} RegisterName8;

typedef enum SegmentName {
   SEG_NULL = -1, // -1 so that NUM_SEGS doesn't include SEG_NULL
   SEG_ES,
   SEG_CS,
   SEG_SS,
   SEG_DS,
   SEG_FS,
   SEG_GS,
   SEG_LDTR,
   SEG_TR,
   NUM_SEGS
} SegmentName;


#endif /* !defined _X86REGNAME_H_ */
