#include "x86vt.h"

/*
 * Bits for exec control
 */
/*      VT_VMCS_PIN_VMEXEC_CTL_HOSTINTRMASK 0x001 */
#define VT_VMCS_PIN_VMEXEC_CTL_HOSTIF       0x002
#define VT_VMCS_PIN_VMEXEC_CTL_INITEXIT     0x004
/*      VT_VMCS_PIN_VMEXEC_CTL_NMI          0x008 */
#define VT_VMCS_PIN_VMEXEC_CTL_SIPIEXIT     0x010
#define VT_VMCS_PIN_VMEXEC_CTL_RSVD         0x020
#define VT_VMCS_PIN_VMEXEC_CTL_VMXTIMER     0x040

#define VT_VMCS_CPU_VMEXEC_CTL_INTN        0x00000001
#define VT_VMCS_CPU_VMEXEC_CTL_TRIPLEFAULT 0x00000002
/*      VT_VMCS_CPU_VMEXEC_CTL_VINTRPEND   0x00000004 */
/*      VT_VMCS_CPU_VMEXEC_CTL_TSCOFF      0x00000008 */
#define VT_VMCS_CPU_VMEXEC_CTL_TSEXIT      0x00000010
#define VT_VMCS_CPU_VMEXEC_CTL_CPUID       0x00000020
#define VT_VMCS_CPU_VMEXEC_CTL_GETSEC      0x00000040
/*      VT_VMCS_CPU_VMEXEC_CTL_HLT         0x00000080 */
#define VT_VMCS_CPU_VMEXEC_CTL_INVD        0x00000100
/*      VT_VMCS_CPU_VMEXEC_CTL_INVLPG      0x00000200 */
/*      VT_VMCS_CPU_VMEXEC_CTL_MWAIT       0x00000400 */
/*      VT_VMCS_CPU_VMEXEC_CTL_RDPMC       0x00000800 */
/*      VT_VMCS_CPU_VMEXEC_CTL_RDTSC       0x00001000 */
#define VT_VMCS_CPU_VMEXEC_CTL_RSM         0x00002000
#define VT_VMCS_CPU_VMEXEC_CTL_VMINSTR     0x00004000
#define VT_VMCS_CPU_VMEXEC_CTL_LDCR3       0x00008000
#define VT_VMCS_CPU_VMEXEC_CTL_STCR3       0x00010000
#define VT_VMCS_CPU_VMEXEC_CTL_USECR3MASK  0x00020000
#define VT_VMCS_CPU_VMEXEC_CTL_USECR3SHAD  0x00040000
/*      VT_VMCS_CPU_VMEXEC_CTL_LDCR8       0x00080000 */
/*      VT_VMCS_CPU_VMEXEC_CTL_STCR8       0x00100000 */
#define VT_VMCS_CPU_VMEXEC_CTL_USECR8MASK  0x00200000
/*      VT_VMCS_CPU_VMEXEC_CTL_USECR8SHAD  0x00400000 */
/*      VT_VMCS_CPU_VMEXEC_CTL_MOVDR       0x00800000 */
/*      VT_VMCS_CPU_VMEXEC_CTL_IO          0x01000000 */
/*      VT_VMCS_CPU_VMEXEC_CTL_IOBITMAP    0x02000000 */
#define VT_VMCS_CPU_VMEXEC_CTL_MSR         0x04000000
#define VT_VMCS_CPU_VMEXEC_CTL_RSVD        0x08000000
/*      VT_VMCS_CPU_VMEXEC_CTL_MSRBITMAP   0x10000000 */
/*      VT_VMCS_CPU_VMEXEC_CTL_MONITOR     0x20000000 */
/*      VT_VMCS_CPU_VMEXEC_CTL_PAUSE       0x40000000 */
#define VT_VMCS_CPU_VMEXEC_CTL_2ND         0x80000000

/*
 * Bits for entry control.
 */
#define VT_VMCS_VMENTRY_CTL_CR04          0x0001
#define VT_VMCS_VMENTRY_CTL_CR3           0x0002
#define VT_VMCS_VMENTRY_CTL_DBG           0x0004
#define VT_VMCS_VMENTRY_CTL_SEG           0x0008
#define VT_VMCS_VMENTRY_CTL_ESPEIPEFLAGS  0x0010
#define VT_VMCS_VMENTRY_CTL_PENDDBG       0x0020
#define VT_VMCS_VMENTRY_CTL_INTRABILITY   0x0040
#define VT_VMCS_VMENTRY_CTL_ACTSTATE      0x0080
#define VT_VMCS_VMENTRY_CTL_WORKVMCS      0x0100
/*      VT_VMCS_VMENTRY_CTL_LONGMODE      0x0200 */
/*      VT_VMCS_VMENTRY_CTL_SMM           0x0400 */
/*      VT_VMCS_VMENTRY_CTL_SMMTEARDOWN   0x0800 */
#define VT_VMCS_VMENTRY_CTL_SYSENTERMSRS  0x1000

/*
 * Bits for exit control.
 */
#define VT_VMCS_VMEXIT_CTL_CR04_SAVE	0x0001
#define VT_VMCS_VMEXIT_CTL_CR3_SAVE	0x0002
#define VT_VMCS_VMEXIT_CTL_DBG		0x0004
#define VT_VMCS_VMEXIT_CTL_SEG_SAVE	0x0008
#define VT_VMCS_VMEXIT_CTL_ESPEIPEFLAGS	0x0010
#define VT_VMCS_VMEXIT_CTL_PENDDBG	0x0020
#define VT_VMCS_VMEXIT_CTL_INTRABILITY	0x0040
#define VT_VMCS_VMEXIT_CTL_ACTSTATE	0x0080
#define VT_VMCS_VMEXIT_CTL_WORKVMCS	0x0100
/*      VT_VMCS_VMEXIT_CTL_LONGMODE     0x0200 */
#define VT_VMCS_VMEXIT_CTL_CR04_LOAD    0x0400
#define VT_VMCS_VMEXIT_CTL_CR3_LOAD     0x0800
#define VT_VMCS_VMEXIT_CTL_RSVD         0x1000
#define VT_VMCS_VMEXIT_CTL_SEG_LOAD     0x2000
#define VT_VMCS_VMEXIT_CTL_ESPEIP_LOAD  0x4000
/*      VT_VMCS_VMEXIT_CTL_INTRACK      0x8000 */
#define VT_VMCS_VMEXIT_CTL_SYSENTER_SAVE   0x10000
#define VT_VMCS_VMEXIT_CTL_SYSENTER_LOAD   0x20000


/* Required feature bits for Server 1 */

#define VT32S1B1_REQUIRED_PINBASED_CTLS                \
   (VT_VMCS_PIN_VMEXEC_CTL_HOSTINTRMASK              | \
    VT_VMCS_PIN_VMEXEC_CTL_HOSTIF                    | \
    VT_VMCS_PIN_VMEXEC_CTL_INITEXIT                  | \
    VT_VMCS_PIN_VMEXEC_CTL_NMI                       | \
    VT_VMCS_PIN_VMEXEC_CTL_SIPIEXIT)

#define VT32S1B1_REQUIRED_PROCBASED_CTLS               \
   (VT_VMCS_CPU_VMEXEC_CTL_INVD                      | \
    VT_VMCS_CPU_VMEXEC_CTL_TRIPLEFAULT               | \
    VT_VMCS_CPU_VMEXEC_CTL_GETSEC                    | \
    VT_VMCS_CPU_VMEXEC_CTL_HLT                       | \
    VT_VMCS_CPU_VMEXEC_CTL_CPUID                     | \
    VT_VMCS_CPU_VMEXEC_CTL_TSEXIT                    | \
    VT_VMCS_CPU_VMEXEC_CTL_INVLPG                    | \
    VT_VMCS_CPU_VMEXEC_CTL_RDPMC                     | \
    VT_VMCS_CPU_VMEXEC_CTL_RDTSC                     | \
    VT_VMCS_CPU_VMEXEC_CTL_IOBITMAP                  | \
    VT_VMCS_CPU_VMEXEC_CTL_RSM                       | \
    VT_VMCS_CPU_VMEXEC_CTL_VMINSTR                   | \
    VT_VMCS_CPU_VMEXEC_CTL_LDCR3                     | \
    VT_VMCS_CPU_VMEXEC_CTL_STCR3                     | \
    VT_VMCS_CPU_VMEXEC_CTL_MOVDR                     | \
    VT_VMCS_CPU_VMEXEC_CTL_MSR)

#define VT32S1B1_REQUIRED_ENTRY_CTLS                   \
   (VT_VMCS_VMENTRY_CTL_CR04                         | \
    VT_VMCS_VMENTRY_CTL_CR3                          | \
    VT_VMCS_VMENTRY_CTL_DBG                          | \
    VT_VMCS_VMENTRY_CTL_SEG                          | \
    VT_VMCS_VMENTRY_CTL_ESPEIPEFLAGS                 | \
    VT_VMCS_VMENTRY_CTL_PENDDBG                      | \
    VT_VMCS_VMENTRY_CTL_INTRABILITY                  | \
    VT_VMCS_VMENTRY_CTL_ACTSTATE                     | \
    VT_VMCS_VMENTRY_CTL_WORKVMCS                     | \
    VT_VMCS_VMENTRY_CTL_SYSENTERMSRS)

#define VT32S1B1_REQUIRED_EXIT_CTLS                    \
   (VT_VMCS_VMEXIT_CTL_CR04_SAVE                     | \
    VT_VMCS_VMEXIT_CTL_CR3_SAVE                      | \
    VT_VMCS_VMEXIT_CTL_DBG                           | \
    VT_VMCS_VMEXIT_CTL_SEG_SAVE                      | \
    VT_VMCS_VMEXIT_CTL_ESPEIPEFLAGS                  | \
    VT_VMCS_VMEXIT_CTL_PENDDBG                       | \
    VT_VMCS_VMEXIT_CTL_INTRABILITY                   | \
    VT_VMCS_VMEXIT_CTL_ACTSTATE                      | \
    VT_VMCS_VMEXIT_CTL_WORKVMCS                      | \
    VT_VMCS_VMEXIT_CTL_CR04_LOAD                     | \
    VT_VMCS_VMEXIT_CTL_CR3_LOAD                      | \
    VT_VMCS_VMEXIT_CTL_SEG_LOAD                      | \
    VT_VMCS_VMEXIT_CTL_ESPEIP_LOAD                   | \
    VT_VMCS_VMEXIT_CTL_SYSENTER_SAVE                 | \
    VT_VMCS_VMEXIT_CTL_SYSENTER_LOAD)

#define VT64S1B1_REQUIRED_PINBASED_CTLS                \
   (VT32S1B1_REQUIRED_PINBASED_CTLS)

#define VT64S1B1_REQUIRED_PROCBASED_CTLS               \
   (VT32S1B1_REQUIRED_PROCBASED_CTLS                 | \
    VT_VMCS_CPU_VMEXEC_CTL_LDCR8                     | \
    VT_VMCS_CPU_VMEXEC_CTL_STCR8                     | \
    VT_VMCS_CPU_VMEXEC_CTL_USECR8MASK)

#define VT64S1B1_REQUIRED_ENTRY_CTLS                   \
   (VT32S1B1_REQUIRED_ENTRY_CTLS                     | \
    VT_VMCS_VMENTRY_CTL_LONGMODE)

#define VT64S1B1_REQUIRED_EXIT_CTLS                    \
   (VT32S1B1_REQUIRED_EXIT_CTLS                      | \
    VT_VMCS_VMEXIT_CTL_LONGMODE)

/*
 *----------------------------------------------------------------------
 * VT_SupportedCPUS1B1 --
 * 
 *   Returns TRUE if the CPU has all of the features that we need to 
 *   run our VT monitor.  This function assumes that the processor is
 *   VT_Capable().
 *   
 *   Note that all currently shipping VT-capable processors meet these
 *   criteria, and that we do not expect any surprises in the field.
 *----------------------------------------------------------------------
 */

static INLINE Bool
VT_SupportedCPUS1B1(void)
{  
   uint64 msr;
   unsigned int memType;
   unsigned int vmcsSz;

   if ((VT64S1B1_REQUIRED_PINBASED_CTLS
       & ~VTComputeMandatoryBits(MSR_VMX_PINBASED_CTLS,
                                 VT64S1B1_REQUIRED_PINBASED_CTLS))
       || (VT64S1B1_REQUIRED_PROCBASED_CTLS
          & ~VTComputeMandatoryBits(MSR_VMX_PROCBASED_CTLS,
                                    VT64S1B1_REQUIRED_PROCBASED_CTLS))
       || (VT64S1B1_REQUIRED_ENTRY_CTLS
          & ~VTComputeMandatoryBits(MSR_VMX_ENTRY_CTLS, 
                                    VT64S1B1_REQUIRED_ENTRY_CTLS))
       || (VT64S1B1_REQUIRED_EXIT_CTLS
          & ~VTComputeMandatoryBits(MSR_VMX_EXIT_CTLS,
                                    VT64S1B1_REQUIRED_EXIT_CTLS))) {
      return FALSE;
   }

   msr = __GET_MSR(MSR_VMX_BASIC);

   memType = (unsigned) ((msr >> MSR_VMX_BASIC_MEMTYPE_SHIFT) &
                         MSR_VMX_BASIC_MEMTYPE_MASK);
   if (memType != MTRR_TYPE_WB) {
      return FALSE;
   }

   vmcsSz = (unsigned) (msr & (1ULL << 47) ? (HIDWORD(msr) & 0x1ff) * PAGE_SIZE
                        : HIDWORD(msr) & 0x1fff);
   if (vmcsSz > PAGE_SIZE) {
      return FALSE;
   }

   return TRUE;
}

