/* **********************************************************
 * Copyright (C) 2005 VMware, Inc.  All Rights Reserved. -- VMware Confidential
 * **********************************************************/

/*
 * Detect whether sk_alloc takes a struct proto * as third parameter.
 * This API change was introduced between 2.6.12-rc1 and 2.6.12-rc2.
 */

#include <linux/autoconf.h>
#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 13)
#include <net/sock.h>

static struct proto test_proto = {
   .name     = "TEST",
};

struct sock * 
vmware_sk_alloc(void)
{
   return sk_alloc(PF_NETLINK, 0, &test_proto, 1);
}
#endif
