/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

#ifndef __VMNETINT_H__
#define __VMNETINT_H__


#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"
#include "driver-config.h"


/*
 * Hide all kernel compatibility stuff in those macros
 */

/* All kernels above 2.6.23 have net namespaces. */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 24) && !defined(VMW_NETDEV_HAS_NET)
#   define VMW_NETDEV_HAS_NET
#endif

/* All kernels above 2.6.23 have skb argument in nf_hookfn. */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 24) && !defined(VMW_NFHOOK_USES_SKB)
#   define VMW_NFHOOK_USES_SKB
#endif


#ifdef KERNEL_2_4_0
#   define compat_fop_set_owner(_pFop) do { \
   (_pFop)->owner = THIS_MODULE;            \
} while (0)
#   define compat_mod_inc_refcount
#   define compat_mod_dec_refcount
#else
#   define compat_fop_set_owner(_pFop)
#   define compat_mod_inc_refcount do { \
   MOD_INC_USE_COUNT;                   \
} while (0)
#   define compat_mod_dec_refcount do { \
   MOD_DEC_USE_COUNT;                   \
} while (0)
#endif


#ifdef skb_shinfo
#  define SKB_IS_CLONE_OF(clone, skb)   (  \
      skb_shinfo(clone) == skb_shinfo(skb) \
   )
#else
#  define SKB_IS_CLONE_OF(clone, skb)   (      \
      skb_datarefp(clone) == skb_datarefp(skb) \
   )
#endif
#define DEV_QUEUE_XMIT(skb, dev, pri)   (                 \
    (skb)->dev = (dev),                                   \
    (skb)->priority = (pri),                              \
    compat_skb_reset_mac_header(skb),                     \
    compat_skb_set_network_header(skb, sizeof (struct ethhdr)),  \
    dev_queue_xmit(skb)                                   \
  )
#ifdef KERNEL_2_3_15
#   define dev_lock_list()    read_lock(&dev_base_lock)
#   define dev_unlock_list()  read_unlock(&dev_base_lock)
#   ifdef VMW_NETDEV_HAS_NET
#      define DEV_GET(x)      __dev_get_by_name((x)->internalDev->nd_net, (x)->name)
#   else
#      define DEV_GET(x)      __dev_get_by_name((x)->name)
#   endif
#else
#   define DEV_GET(x)         dev_get((x)->name)
#endif


/*
 * Various fields (including 'dead') of struct sock are replaced with the
 * 'flags' bitfield in 2.5.65 --hpreg
 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 5, 65)
#   define SET_SK_DEAD(_sk, _val) (_sk)->dead = (_val)
#else
#   define SET_SK_DEAD(_sk, _val) sock_valbool_flag(_sk, SOCK_DEAD, _val)
#endif


#ifdef VMW_NETDEV_HAS_NET
extern struct proto vmnet_proto;
#   define compat_sk_alloc(_bri, _pri) sk_alloc((_bri)->internalDev->nd_net, \
                                                PF_NETLINK, _pri, &vmnet_proto)
#elif defined(VMW_HAVE_SK_ALLOC_WITH_PROTO)
extern struct proto vmnet_proto;
#   define compat_sk_alloc(_bri, _pri) sk_alloc(PF_NETLINK, _pri, &vmnet_proto, 1)
#elif defined(KERNEL_2_5_5)
#   define compat_sk_alloc(_bri, _pri) sk_alloc(PF_NETLINK, _pri, 1, NULL)
#else
#   define compat_sk_alloc(_bri, _pri) sk_alloc(0, _pri, 1)
#endif


#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
#   define fileTraversalLock(lock) spin_lock(lock)
#   define fileTraversalUnLock(lock) spin_unlock(lock)
#elif LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#   define fileTraversalLock(lock) read_lock(lock)
#   define fileTraversalUnLock(lock) read_unlock(lock)
#else //2.2 kernels
#   define fileTraversalLock(lock) lock_kernel()
#   define fileTraversalUnLock(lock) unlock_kernel()
#endif


#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#   define taskLock(lock) task_lock(lock)
#   define taskUnLock(lock) task_unlock(lock)
#else //2.2 kernels
#   define taskLock(lock) lock_kernel()
#   define taskUnLock(lock) unlock_kernel()
#endif


/* 
 * Use CHECKSUM_HW for old kernels, if they have CHECKSUM_HW.  Use CHECKSUM_PARTIAL for 
 * new ones even if CHECKSUM_HW is defined.  We do not do decision based on kernel version
 * only as CHECKSUM_PARTIAL was in mm tree for some time already, and we do not test
 * for CHECKSUM_PARTIAL existence as it may get converted to enum in future.
 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 19) && defined(CHECKSUM_HW)
#   define VM_CHECKSUM_PARTIAL  CHECKSUM_HW
#else
#   define VM_CHECKSUM_PARTIAL  CHECKSUM_PARTIAL
#endif


/*
 * The "owner" field in nf_hook_ops got added in 2.5.69
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 5, 69)
#   define compat_nf_hook_owner  .owner = THIS_MODULE,
#else
#   define compat_nf_hook_owner
#endif


#endif /* __VMNETINT_H__ */
