/*********************************************************
 * Copyright (C) 2001 VMware, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2 and no later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *********************************************************/

/*
 * pshare_ext.h --
 *
 *	VMKernel/VMMon <-> VMM transparent page sharing info.
 */

#ifndef _PSHARE_EXT_H
#define _PSHARE_EXT_H

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_VMMEXT
#define INCLUDE_ALLOW_VMKERNEL
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMNIXMOD
#define INCLUDE_ALLOW_VMCORE
#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"

#include "busmem_def.h"
#include "vm_assert.h"

EXTERN MPN shareMPN;

/*
 * constants
 */

#define PSHARE_DEFAULT_SCAN_RATE        (32)

#define	PSHARE_BATCH_PAGES_MAX		(BUSMEMDEF_BATCHPAGELIST_MAX)
#define PSHARE_P2M_BUFFER_MPNS_MAX      (8)
#define PSHARE_P2M_BUFFER_MPNS_DEFAULT  (2)
#define	PSHARE_P2M_UPDATES_MAX		(64)
#define	PSHARE_P2M_UPDATES_OVERFLOW	(-1)
#define	PSHARE_HINT_UPDATES_MAX		(PSHARE_BATCH_PAGES_MAX)
#define PSHARE_HINT_BATCH_PAGES_MAX     (32)
#define PSHARE_P2M_BUFFER_SLOTS_PER_MPN ((PAGE_SIZE/sizeof(PShare_P2MUpdate)))

#define PSHARE_MAX_COW_CHECK_PAGES      (16) // limited by rpc block size
#define PSHARE_DEFAULT_CHECK_RATE       (16) 

#ifdef VMX86_SERVER
#define ZERO_MPN_MAX                    (8)
#else
#define ZERO_MPN_MAX                    (1)
#endif

MY_ASSERTS(PSHARE_EXT,
           ASSERT_ON_COMPILE((PSHARE_HINT_UPDATES_MAX <=
                              PSHARE_BATCH_PAGES_MAX)       &&
                             (PSHARE_BATCH_PAGES_MAX <= 
                              BUSMEMDEF_BATCHPAGELIST_MAX));)

/*
 * types
 */

typedef struct PShare_P2MUpdate {
   BPN     bpn;
   MPN     mpn;
} PShare_P2MUpdate;

typedef enum {
   PSHARE_HINT_NONE,
   PSHARE_HINT_STALE,
   PSHARE_HINT_MATCH
} PShare_HintStatus;

typedef struct PShare_HintUpdate {
   BPN               bpn;
   PShare_HintStatus status;
} PShare_HintUpdate;

typedef struct {
   uint32 nScan;	// pages scanned
   uint32 nAttempt;	// page sharing attempts
   uint32 nCOW;		// pages marked COW
   uint32 nHint;	// pages marked COW hint
   uint32 nShare;	// pages shared
   uint32 nCopy;	// pages copied

   uint32 nCheck;	// pages checked
   uint32 nCheckBad;	// page check failures
   uint32 nCheckBadKey;	// hash key check mismatches
   uint32 nCheckBadMPN;	// MPN check mismatches
   uint32 nCheckBadCOW;	// COW check mismatches
} PShare_MonitorStats;

typedef struct PShare_COWCheckInfo {
   BPN     bpn;        // bpn to check
   MPN     vmmMPN;     // mpn for this page in monitor
   MPN     hostMPN;    // mpn for this page in the host
   Bool    vmmCOW;     // cow state of this page in monitor
   Bool    hostCOW;    // cow state of this page in the host
   Bool    keyOK;
   Bool    checkOK;
} PShare_COWCheckInfo;

typedef struct PShare_ZeroMPNInfo {
   // VMK/VMX -> VMM
   uint32 numEntries;
   MPN    list[ZERO_MPN_MAX];
} PShare_ZeroMPNInfo;

typedef struct PShare_ConfigInfo {
   Bool   enable;             // config: pshare enabled?
   Bool   debug;              // config: debugging enabled?
   uint32 scanRate;           // config: scan rate  (pages/sec)
   uint32 checkRate;          // config: check rate (checks/sec)

   PShare_MonitorStats stats; // statistics
} PShare_ConfigInfo;

/*
 * Config information that is used by the platform to implement
 * dynamic scan rate distribution across multiple running VMs.
 */

typedef struct PShare_MgmtInfo {
   uint16 minScanRate;
   uint16 maxScanRate;
   uint16 curScanRate;
   Bool   adaptive;
   Bool   enable;
} PShare_MgmtInfo;


/* 
 * Classes of page contents. We divide all pages into two major groups
 * based on their contents. If contents of a page matches some simple
 * pattern then such a page is called patterned. Otherwise, page contents 
 * as well as the page itself are referred to as complex. In general, pages 
 * that contain some pattern have good temporal and spatial locality, can 
 * be efficiently recognized, tested for matching, and compressed. In 
 * comments below 'a' and 'b' are arbitrary 32-bit words, '0' is 32-bit
 * word of zeros, power notation is used to handle repetitions. E.g. 0^4
 * means four consecutive 32-bit zero words.
 */

#define DEFINE_PAGE_CLASS \
   MDEF(PC_ZERO,         "Z",      "zero page"     ) \
   MDEF(PC_WORD5_32,     "W5-32",  "0^4 a 0^1019"  ) \
   MDEF(PC_WORD5_64,     "W5-64",  "0^8 a b 0^1014") \
   MDEF(PC_LAST2,        "L2",     "0^1022 a b"    ) \
   MDEF(PC_PERIOD1,      "P1",     "a^1024"        ) \
   MDEF(PC_PERIOD2,      "P2",     "(a b)^512"     ) \
   MDEF(PC_PERIOD4_1_2,  "P4-12",  "(a b 0 0)^256" ) \
   MDEF(PC_UNKNOWN,      "U",      "unidentified"  )

typedef enum PageClass {
#define MDEF(_class, _name, _pattern) _class,
   DEFINE_PAGE_CLASS
#undef MDEF
   NUM_PAGE_CLASSES
} PageClass;

typedef uint8 PShareClassID;

#endif
