/*********************************************************
 * Copyright (C) 2007 VMware, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2 and no later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *********************************************************/

/*
 * vmciQueuePair.h --
 *
 *    VMCI QueuePair API implementation in the host driver.
 */

#ifndef _VMCI_QUEUE_PAIR_H_
#define _VMCI_QUEUE_PAIR_H_

#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#define INCLUDE_ALLOW_VMKERNEL
#include "includeCheck.h"

#include "vmci_defs.h"
#include "vmciContext.h"
#ifdef VMKERNEL
#include "shm.h"

/*
 * In vmkernel, we are planning to provide two kinds of storage for
 * the queue pairs: one is shared memory and the other is using copies
 * of the queue pair stored in private guest memory. Currently, we
 * only support shared memory.
 */

typedef struct QueuePairPageStore {
   Bool shared; // Indicates whether the pages are stored in shared memory
   union {
      Shm_ID   shmID;
   } store;
} QueuePairPageStore;
#else
typedef struct QueuePairPageStore {
   VA64 producePageFile;       // Name of the file
   VA64 consumePageFile;       // Name of the file
   uint64 producePageFileSize; // Size of the string
   uint64 consumePageFileSize; // Size of the string
} QueuePairPageStore;
#endif // VMKERNEL

int QueuePair_Init(void);
void QueuePair_Exit(void);
void QueuePairList_Lock(void);
void QueuePairList_Unlock(void);
int QueuePair_Alloc(VMCIHandle handle, VMCIId peer, uint32 flags,
                    uint64 produceSize, uint64 consumeSize,
		    QueuePairPageStore *pageStore,
                    VMCIContext *context);
int QueuePair_SetPageStore(VMCIHandle handle,
			   QueuePairPageStore *pageStore,
			   VMCIContext *context);
int QueuePair_Detach(VMCIHandle handle, VMCIContext *context, Bool detach);
int QueuePair_ResetPageStore(VMCIHandle handle, VMCIContext *context);

#endif /* !_VMCI_QUEUE_PAIR_H_ */
