/*********************************************************
 * Copyright (C) 1998 VMware, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2 and no later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *********************************************************/

/************************************************************
 *
 * memtrack.h  - Utility module for tracking memory allocated 
 *               and/or locked by the driver. 
 *
 ************************************************************/


#ifndef MEMTRACK_H
#define MEMTRACK_H

#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

#ifdef VMX86_DEBUG
#define MEMTRACK_MPN_LOOKUP   
#endif

typedef struct MemTrackEntry {
   VPN vpn;
   MPN mpn;

   struct MemTrackEntry *vpnHashChain;
#ifdef MEMTRACK_MPN_LOOKUP
   struct MemTrackEntry *mpnHashChain;
#endif
} MemTrackEntry;

extern void          *MemTrack_Init(void);
extern MemTrackEntry *MemTrack_Add(void *s, VPN vpn, MPN mpn);
extern MemTrackEntry *MemTrack_LookupVPN(void *s, VPN vpn);
#ifdef MEMTRACK_MPN_LOOKUP
extern MemTrackEntry *MemTrack_LookupMPN(void *s, MPN mpn);
#endif
extern MemTrackEntry *MemTrack_GetRecycledPage(void *s);
extern void           MemTrack_RecyclePage(void *s, MemTrackEntry *e);
extern int            MemTrack_Cleanup(void *s,
				       void (*cleanProc)(void *, MemTrackEntry *),
				       void *clientData);
extern void          *MemTrack_Scan(void *s, void *arg,
				    void *(*searchFunc)(void *, MemTrackEntry *)); 

#endif 
