/*********************************************************
 * Copyright (C) 2006 VMware, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2 and no later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *********************************************************/

/*
 * x86segdescrs.h --
 *
 *	Type definitions for the x86 segment descriptors.
 */

#ifndef _X86SEGDESCRS_H_
#define _X86SEGDESCRS_H_

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_VMMEXT
#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMNIXMOD
#define INCLUDE_ALLOW_VMK_MODULE
#define INCLUDE_ALLOW_VMKERNEL
#define INCLUDE_ALLOW_DISTRIBUTE
#define INCLUDE_ALLOW_VMCORE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMIROM
#include "includeCheck.h"

#include "vm_basic_types.h"
#include "vm_basic_defs.h"

/*
 * Segment Descriptors.
 */

typedef struct Descriptor {
   unsigned   limit_lo  : 16;
   unsigned   base_lo   : 16;
   unsigned   base_mid  : 8;
   unsigned   type      : 4;
   unsigned   S         : 1;
   unsigned   DPL       : 2;
   unsigned   present   : 1;
   unsigned   limit_hi  : 4;
   unsigned   AVL       : 1;
   unsigned   longmode  : 1;
   unsigned   DB        : 1;
   unsigned   gran      : 1;
   unsigned   base_hi   : 8;
} Descriptor;

/*
 * 16-byte system descriptors for 64-bit mode.
 */

typedef 
#include "vmware_pack_begin.h"
struct Descriptor64 {
   unsigned   limit_lo  : 16;   // Limit bits 15-0.
   unsigned   base_lo   : 24;   // Base bits  23-0.
   unsigned   type      : 4;
   unsigned   S         : 1;
   unsigned   DPL       : 2;
   unsigned   present   : 1;
   unsigned   limit_hi  : 4;    // Limit bits 19-16.
   unsigned   AVL       : 1;
   unsigned   reserved0 : 2;
   unsigned   gran      : 1;
   unsigned   base_mid  : 8;    // Base bits 31-24.
   unsigned   base_hi   : 32;   // Base bits 63-32.
   unsigned   reserved1 : 8;
   unsigned   ext_attrs : 5;
   unsigned   reserved2 : 19;
}
#include "vmware_pack_end.h"
Descriptor64;

typedef struct CallGate {
   unsigned   offset_lo : 16;
   unsigned   selector  : 16;
   unsigned   parms     : 5;
   unsigned   zero0     : 3;
   unsigned   type      : 5;
   unsigned   DPL       : 2;
   unsigned   present   : 1;
   unsigned   offset_hi : 16;
} CallGate;

typedef union {
   Descriptor desc;
   CallGate   cg;
   uint32     word[2];
} DescriptorUnion;

typedef union {
   Descriptor64 desc;
   uint32       word[4];
   uint64       qword[2];
} Descriptor64Union;


#endif // ifndef _X86SEGDESCRS_H_
