/*
 * Simple MPEG/DVB parser to achieve network/service information without initial tuning data
 *
 * Copyright (C) 2006, 2007, 2008, 2009 Winfried Koehler 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 * Or, point your browser to http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * The author can be reached at: handygewinnspiel AT gmx DOT de
 *
 * The project's page is http://wirbel.htpc-forum.de/w_scan/index2.html
 * satellite.c/h, added 20090425, version #20100116
 */



/* this file is shared between w_scan and the VDR plugin wirbelscan.
 * For details on both of them see http://wirbel.htpc-forum.de
 */



#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include "scan.h"
#include "satellites.h"
#include "extended_frontend.h"


/******************************************************************************
 * Every satellite has its own number here.
 * if adding new one simply append to enum.
 *****************************************************************************/
enum __satellite {
    S4E8 = 0,    
    S7E0,    
    S9E0,    
    S10E0,
    S13E0,
    S16E0,
    S19E2,
    S21E6,
    S23E5,
    S25E5,
    S26EX,
    S28E2,
    S28E5,
    S31E5,
    S32E9,
    S33E0,
    S35E9,
    S36E0,
    S38E0,
    S39E0,
    S40EX,
    S42E0,
    S45E0,
    S49E0,
    S53E0,
    S57E0,
    S57EX,
    S60EX,
    S62EX,
    S64E2,
    S68EX,
    S70E5,
    S72EX,
    S75EX,
    S76EX,
    S78E5,
    S80EX,
    S83EX,
    S87E5,
    S88EX,
    S90EX,
    S91E5,
    S93E5,
    S95E0,
    S96EX,
    S100EX,
    S105EX,
    S108EX,
    S140EX,
    S152E0,
    S156E0,
    S160E0,
    S166E0,
    S0W8,
    S4W0,
    S5WX,
    S7W0,
    S8W0,
    S11WX,
    S12W5,
    S14W0,
    S15W0,
    S18WX,
    S22WX,
    S24WX,
    S27WX,
    S30W0,
    S97W0,
};



/******************************************************************************
 * only definitions starting from here.
 * Data is taken from my vdr plugin wirbelscan and reformatted.
 * --20090308 wk
 *
 * data and format may change without notice.
 *****************************************************************************/
static const struct __sat_transponder SIRIUS04_8E[] = { // Sirius 4, 2008-07-10
{SYS_DVBS ,11727, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11747, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11766, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11785, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11804, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11823, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11843, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11862, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11881, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11900, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11919, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11938, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11958, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11977, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11996, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12015, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12034, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12054, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12073, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12092, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12111, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12130, POLARIZATION_VERTICAL  ,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12149, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12169, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12188, POLARIZATION_HORIZONTAL,25540, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12207, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12226, POLARIZATION_HORIZONTAL,25540, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12245, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12265, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12284, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12303, POLARIZATION_HORIZONTAL,25548, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12322, POLARIZATION_VERTICAL  ,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12341, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12360, POLARIZATION_VERTICAL  ,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12380, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12399, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12418, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12437, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12456, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12476, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12535, POLARIZATION_VERTICAL  , 3900, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12540, POLARIZATION_VERTICAL  , 4069, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12605, POLARIZATION_VERTICAL  ,29950, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12608, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12637, POLARIZATION_HORIZONTAL,14468, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12672, POLARIZATION_HORIZONTAL, 3300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12674, POLARIZATION_VERTICAL  ,10000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12678, POLARIZATION_VERTICAL  ,13333, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12680, POLARIZATION_HORIZONTAL, 9404, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12685, POLARIZATION_VERTICAL  , 4444, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12694, POLARIZATION_VERTICAL  , 3333, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12699, POLARIZATION_VERTICAL  , 7142, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12715, POLARIZATION_HORIZONTAL, 3330, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12727, POLARIZATION_VERTICAL  ,19720, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12737, POLARIZATION_HORIZONTAL, 3472, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EUTELSAT07_0E[] = { // Eutelsat W3A, 2008-07-10
{SYS_DVBS ,10880, POLARIZATION_VERTICAL  ,17360, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,10880, POLARIZATION_VERTICAL  ,17360, FEC_3_4,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,10928, POLARIZATION_HORIZONTAL,30000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS2,10928, POLARIZATION_HORIZONTAL,30000, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,10962, POLARIZATION_VERTICAL  , 3249, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS ,10976, POLARIZATION_VERTICAL  , 3333, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11063, POLARIZATION_VERTICAL  , 1150, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11105, POLARIZATION_VERTICAL  , 3800, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS ,11127, POLARIZATION_VERTICAL  , 6666, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11190, POLARIZATION_VERTICAL  , 3210, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11262, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11283, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11303, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11324, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11345, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11351, POLARIZATION_VERTICAL  , 8571, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11452, POLARIZATION_VERTICAL  ,25066, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11471, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11492, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11513, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11534, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11554, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11575, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11596, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11617, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11637, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11678, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12520, POLARIZATION_VERTICAL  ,27500, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12562, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12645, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12728, POLARIZATION_VERTICAL  ,30000, FEC_5_6,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EUROBIRD09_0E[] = { // Eurobird 9, 2009-04-28
{SYS_DVBS ,11727, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11747, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11766, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11785, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,11804, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11823, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11843, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11861, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,11881, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11919, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11938, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11958, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11977, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12015, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS2,12034, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12054, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12074, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12092, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12130, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12283, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12322, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12360, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12398, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12437, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EUTELSAT10_0E[] = { // Eutelsat W1, 2008-07-10
{SYS_DVBS ,10970, POLARIZATION_VERTICAL  , 4167, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11126, POLARIZATION_HORIZONTAL, 4340, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11144, POLARIZATION_HORIZONTAL, 2442, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11148, POLARIZATION_HORIZONTAL, 2893, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11156, POLARIZATION_HORIZONTAL, 3978, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11160, POLARIZATION_HORIZONTAL, 2170, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11163, POLARIZATION_HORIZONTAL, 2170, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11166, POLARIZATION_HORIZONTAL, 2893, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11170, POLARIZATION_HORIZONTAL, 2532, FEC_3_4,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,11175, POLARIZATION_HORIZONTAL, 2531, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11179, POLARIZATION_HORIZONTAL, 2532, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11182, POLARIZATION_HORIZONTAL, 1707, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11190, POLARIZATION_VERTICAL  , 5208, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11473, POLARIZATION_VERTICAL  ,33300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11526, POLARIZATION_VERTICAL  ,30000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11596, POLARIZATION_VERTICAL  ,20000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12568, POLARIZATION_VERTICAL  , 3617, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12611, POLARIZATION_HORIZONTAL, 9259, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12629, POLARIZATION_VERTICAL  , 5632, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder HOTBIRD13E[] = { // Hot Bird  6/7A/8, 2012-04-13
{SYS_DVBS ,10723, POLARIZATION_HORIZONTAL,29900, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,10775, POLARIZATION_HORIZONTAL,29900, FEC_3_4, ROLLOFF_35,PSK_8},
{SYS_DVBS ,10815, POLARIZATION_HORIZONTAL,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS2,10853, POLARIZATION_HORIZONTAL,29900, FEC_3_4, ROLLOFF_35,PSK_8},
{SYS_DVBS ,10892, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,10930, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,10971, POLARIZATION_HORIZONTAL,29700, FEC_2_3, ROLLOFF_35,PSK_8},
{SYS_DVBS ,11013, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11054, POLARIZATION_HORIZONTAL,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS2,11096, POLARIZATION_HORIZONTAL,29900, FEC_2_3, ROLLOFF_35,PSK_8},
{SYS_DVBS ,11137, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11179, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11219, POLARIZATION_HORIZONTAL,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS2,11258, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_20,PSK_8},
{SYS_DVBS ,11296, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,11334, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35,APSK_16},
{SYS_DVBS2,11373, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35,PSK_8},
{SYS_DVBS2,11411, POLARIZATION_HORIZONTAL,27500, FEC_5_6, ROLLOFF_35,PSK_8},
{SYS_DVBS2,11449, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_20,PSK_8},
{SYS_DVBS ,11488, POLARIZATION_HORIZONTAL,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,11526, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,11564, POLARIZATION_HORIZONTAL,27500, FEC_5_6, ROLLOFF_20, QPSK},
{SYS_DVBS ,11566, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11604, POLARIZATION_HORIZONTAL,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,11642, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,11681, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35,PSK_8}, // RollOff = ?
{SYS_DVBS ,11747, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,11785, POLARIZATION_HORIZONTAL,29900, FEC_3_4, ROLLOFF_35,PSK_8},
{SYS_DVBS ,11823, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11862, POLARIZATION_HORIZONTAL,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,11900, POLARIZATION_HORIZONTAL,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,11938, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11977, POLARIZATION_HORIZONTAL,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,12015, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12054, POLARIZATION_HORIZONTAL,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,12092, POLARIZATION_HORIZONTAL,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS2,12130, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35,PSK_8},
{SYS_DVBS ,12169, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12207, POLARIZATION_HORIZONTAL,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,12245, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12284, POLARIZATION_HORIZONTAL,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,12322, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,12360, POLARIZATION_HORIZONTAL,29900, FEC_3_4, ROLLOFF_35,PSK_8},
{SYS_DVBS ,12399, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12437, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,12476, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35,PSK_8},
{SYS_DVBS ,12539, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,12577, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, PSK_8},// RollOff = ? 
{SYS_DVBS ,12616, POLARIZATION_HORIZONTAL,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,12654, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,12692, POLARIZATION_HORIZONTAL,27500, FEC_3_4, ROLLOFF_35,PSK_8}, // RollOff = ?
{SYS_DVBS ,12731, POLARIZATION_HORIZONTAL,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10719, POLARIZATION_VERTICAL  ,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10758, POLARIZATION_VERTICAL  ,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10796, POLARIZATION_VERTICAL  ,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS2,10834, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35,PSK_8}, // RollOff = ? 
{SYS_DVBS ,10873, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,10911, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35,PSK_8},
{SYS_DVBS ,10949, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,10992, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11034, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11075, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11117, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11158, POLARIZATION_VERTICAL  ,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,11200, POLARIZATION_VERTICAL  ,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,11240, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,11278, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_20,PSK_8},
{SYS_DVBS ,11320, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11355, POLARIZATION_VERTICAL  ,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,11393, POLARIZATION_VERTICAL  ,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS2,11432, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35,APSK_16},
{SYS_DVBS ,11470, POLARIZATION_VERTICAL  ,27500, FEC_5_6, ROLLOFF_35, QPSK}, 
{SYS_DVBS ,11508, POLARIZATION_VERTICAL  ,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,11541, POLARIZATION_VERTICAL  ,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,11585, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11623, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11662, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11727, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11766, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11804, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS2,11843, POLARIZATION_VERTICAL  ,29900, FEC_3_4, ROLLOFF_35,PSK_8},
{SYS_DVBS ,11881, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11919, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11958, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,11996, POLARIZATION_VERTICAL  ,29900, FEC_3_4, ROLLOFF_35,PSK_8},
{SYS_DVBS ,12034, POLARIZATION_VERTICAL  ,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,12073, POLARIZATION_VERTICAL  ,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,12111, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12149, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12188, POLARIZATION_VERTICAL  ,27500, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,12225, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,12265, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_20,PSK_8},
{SYS_DVBS2,12303, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35,PSK_8},
{SYS_DVBS2,12341, POLARIZATION_VERTICAL  ,29900, FEC_3_4, ROLLOFF_35,PSK_8},
{SYS_DVBS ,12380, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,12418, POLARIZATION_VERTICAL  ,29900, FEC_3_4, ROLLOFF_35,PSK_8},
{SYS_DVBS ,12466, POLARIZATION_VERTICAL  ,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,12520, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12558, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12597, POLARIZATION_VERTICAL  ,27500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12635, POLARIZATION_VERTICAL  ,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,12673, POLARIZATION_VERTICAL  ,29900, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,12713, POLARIZATION_VERTICAL  ,29900, FEC_5_6, ROLLOFF_35, QPSK}};

static const struct __sat_transponder EUTELSAT16_0E[] = { // Eutelsat W2, 2008-07-11
{SYS_DVBS ,10957, POLARIZATION_HORIZONTAL, 2821, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10972, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,10975, POLARIZATION_HORIZONTAL,22500, FEC_4_5,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10995, POLARIZATION_HORIZONTAL, 4444, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11001, POLARIZATION_HORIZONTAL, 4444, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11007, POLARIZATION_HORIZONTAL, 4444, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11011, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11013, POLARIZATION_HORIZONTAL, 4444, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11019, POLARIZATION_HORIZONTAL, 4444, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11025, POLARIZATION_HORIZONTAL, 4444, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11046, POLARIZATION_HORIZONTAL,10555, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11055, POLARIZATION_VERTICAL  ,27900, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11056, POLARIZATION_HORIZONTAL, 3327, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11061, POLARIZATION_HORIZONTAL, 5722, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11094, POLARIZATION_VERTICAL  ,27900, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11095, POLARIZATION_HORIZONTAL,27300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11132, POLARIZATION_VERTICAL  ,14815, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11140, POLARIZATION_HORIZONTAL,27700, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11148, POLARIZATION_VERTICAL  , 8900, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11158, POLARIZATION_VERTICAL  , 2894, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11166, POLARIZATION_HORIZONTAL,11850, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11178, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11178, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11186, POLARIZATION_HORIZONTAL, 2667, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11192, POLARIZATION_HORIZONTAL, 2667, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11283, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11304, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11324, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11428, POLARIZATION_VERTICAL  ,30000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11449, POLARIZATION_HORIZONTAL,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11471, POLARIZATION_VERTICAL  ,29950, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11492, POLARIZATION_HORIZONTAL,29950, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11513, POLARIZATION_VERTICAL  ,29950, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11534, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11554, POLARIZATION_VERTICAL  ,30000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11575, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11596, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11617, POLARIZATION_HORIZONTAL,29950, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11658, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11682, POLARIZATION_VERTICAL  ,14468, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12509, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12513, POLARIZATION_VERTICAL  , 2156, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12517, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12520, POLARIZATION_VERTICAL  , 2156, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12524, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12532, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12534, POLARIZATION_VERTICAL  , 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12538, POLARIZATION_VERTICAL  , 4340, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12539, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12547, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12550, POLARIZATION_VERTICAL  , 3255, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12555, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12560, POLARIZATION_VERTICAL  , 2156, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12562, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12563, POLARIZATION_VERTICAL  , 2222, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12568, POLARIZATION_HORIZONTAL, 3703, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12592, POLARIZATION_VERTICAL  , 2934, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12600, POLARIZATION_VERTICAL  , 6771, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12611, POLARIZATION_VERTICAL  , 3000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12616, POLARIZATION_HORIZONTAL,13333, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12620, POLARIZATION_VERTICAL  , 2893, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12626, POLARIZATION_VERTICAL  , 4444, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12630, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12633, POLARIZATION_VERTICAL  , 4883, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12636, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12642, POLARIZATION_VERTICAL  , 3418, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12648, POLARIZATION_VERTICAL  , 5200, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12650, POLARIZATION_HORIZONTAL,15000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12656, POLARIZATION_VERTICAL  , 4883, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12676, POLARIZATION_HORIZONTAL, 4321, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12677, POLARIZATION_VERTICAL  , 6111, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12683, POLARIZATION_HORIZONTAL, 2894, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12686, POLARIZATION_VERTICAL  , 6111, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12692, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12695, POLARIZATION_VERTICAL  , 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12703, POLARIZATION_HORIZONTAL, 2748, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12704, POLARIZATION_VERTICAL  , 6111, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12712, POLARIZATION_HORIZONTAL, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12719, POLARIZATION_HORIZONTAL, 9000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12726, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12727, POLARIZATION_HORIZONTAL, 3333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12736, POLARIZATION_HORIZONTAL, 6111, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder ASTRA19E[] = {    // Astra 1F/1G/1H/1KR/1L, 2011-06-10 
{SYS_DVBS ,10714, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10729, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10744, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10759, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10773, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10788, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10803, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10817, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10832, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10847, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS2,10862, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35,PSK_8},
{SYS_DVBS ,10876, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10891, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10906, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10920, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10936, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10964, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10979, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,10994, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11009, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11023, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11038, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11053, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11068, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11082, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11097, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11112, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11127, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11141, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11156, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS2,11171, POLARIZATION_HORIZONTAL,22000, FEC_2_3 , ROLLOFF_20,PSK_8},
{SYS_DVBS ,11186, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11214, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11229, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11244, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11259, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11273, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11288, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS2,11302, POLARIZATION_HORIZONTAL,22000, FEC_2_3 , ROLLOFF_35,PSK_8},
{SYS_DVBS ,11317, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11332, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11347, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS2,11361, POLARIZATION_HORIZONTAL,22000, FEC_2_3 , ROLLOFF_35,PSK_8},
{SYS_DVBS ,11377, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11391, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11406, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11421, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS2,11435, POLARIZATION_VERTICAL  ,22000, FEC_2_3 , ROLLOFF_35,PSK_8},
{SYS_DVBS ,11464, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11479, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11494, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11508, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11523, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11538, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11553, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11567, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11582, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11597, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11612, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11627, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11641, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11656, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11670, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11685, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11719, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11739, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11758, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11778, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11797, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11817, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11836, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11856, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11875, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11895, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS2,11915, POLARIZATION_HORIZONTAL,27500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS ,11934, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11953, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11973, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,11992, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12012, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12031, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12051, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12070, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12090, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12109, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12129, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12148, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12168, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12187, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12207, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12226, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12246, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12265, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12285, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12304, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12324, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12343, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12363, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12382, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12402, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12421, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12441, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12460, POLARIZATION_HORIZONTAL,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12480, POLARIZATION_VERTICAL  ,27500, FEC_3_4 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12515, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS2,12522, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35,PSK_8},
{SYS_DVBS ,12544, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12551, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12574, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS2,12580, POLARIZATION_VERTICAL  ,22000, FEC_2_3 , ROLLOFF_35,PSK_8},
{SYS_DVBS ,12603, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12610, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12633, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12640, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12663, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS2,12669, POLARIZATION_VERTICAL  ,22000, FEC_2_3 , ROLLOFF_35,PSK_8},
{SYS_DVBS ,12692, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12699, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12721, POLARIZATION_HORIZONTAL,22000, FEC_5_6 , ROLLOFF_35, QPSK},
{SYS_DVBS ,12728, POLARIZATION_VERTICAL  ,22000, FEC_5_6 , ROLLOFF_35, QPSK}};

static const struct __sat_transponder EUTELSAT21_6E[] = { // Eutelsat W6, 2008-07-10
{SYS_DVBS ,10972, POLARIZATION_VERTICAL  , 2170, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10975, POLARIZATION_VERTICAL  , 2170, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10979, POLARIZATION_VERTICAL  , 2170, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11345, POLARIZATION_HORIZONTAL,28782, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11366, POLARIZATION_VERTICAL  ,22500, FEC_8_9,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11387, POLARIZATION_HORIZONTAL,30000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11449, POLARIZATION_VERTICAL  ,30000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11524, POLARIZATION_VERTICAL  , 2170, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11527, POLARIZATION_VERTICAL  , 2857, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11530, POLARIZATION_VERTICAL  , 2857, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11555, POLARIZATION_HORIZONTAL, 5000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11586, POLARIZATION_VERTICAL  , 6511, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11596, POLARIZATION_HORIZONTAL,26662, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11617, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11640, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35,APSK_16},
{SYS_DVBS ,11653, POLARIZATION_VERTICAL  ,15714, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS ,11669, POLARIZATION_VERTICAL  , 2480, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11671, POLARIZATION_HORIZONTAL, 7407, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12637, POLARIZATION_VERTICAL  , 2532, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder ASTRA23_5E[] = { // Astra 1E/1G/3A, 2010-05-29 kingofsat
{SYS_DVBS2,10758, POLARIZATION_VERTICAL  ,22000, FEC_8_9,  ROLLOFF_25,PSK_8},
{SYS_DVBS2,10788, POLARIZATION_VERTICAL  ,22000, FEC_8_9,  ROLLOFF_25,PSK_8},
{SYS_DVBS ,10803, POLARIZATION_HORIZONTAL,22000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS2,10817, POLARIZATION_VERTICAL  ,22000, FEC_8_9,  ROLLOFF_25,PSK_8},
{SYS_DVBS ,10862, POLARIZATION_HORIZONTAL,22000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS2,10876, POLARIZATION_VERTICAL  ,22000, FEC_8_9,  ROLLOFF_25,PSK_8},
{SYS_DVBS2,10891, POLARIZATION_HORIZONTAL,22000, FEC_3_4,  ROLLOFF_25,PSK_8},
{SYS_DVBS ,11475, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11515, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11515, POLARIZATION_VERTICAL  ,28500, FEC_9_10, ROLLOFF_25,PSK_8},
{SYS_DVBS2,11555, POLARIZATION_HORIZONTAL,28500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS2,11555, POLARIZATION_VERTICAL  ,28500, FEC_9_10, ROLLOFF_25,PSK_8},
{SYS_DVBS2,11595, POLARIZATION_VERTICAL  ,28500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS2,11595, POLARIZATION_HORIZONTAL,28500, FEC_9_10, ROLLOFF_25,PSK_8},
{SYS_DVBS2,11635, POLARIZATION_HORIZONTAL,28500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS2,11635, POLARIZATION_VERTICAL  ,28500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS ,11675, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11675, POLARIZATION_VERTICAL  ,28500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS2,11719, POLARIZATION_HORIZONTAL,27500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS2,11739, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11758, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35,PSK_8},
{SYS_DVBS2,11778, POLARIZATION_VERTICAL  ,27500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS ,11798, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11817, POLARIZATION_VERTICAL  ,27500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS ,11836, POLARIZATION_HORIZONTAL,29900, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11856, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11875, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11914, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11954, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_25,PSK_8},
{SYS_DVBS ,11973, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11992, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12012, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12032, POLARIZATION_HORIZONTAL,27500, FEC_9_10, ROLLOFF_25, QPSK},
{SYS_DVBS ,12070, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12109, POLARIZATION_HORIZONTAL,27500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS2,12129, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12148, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_25,PSK_8},
{SYS_DVBS ,12168, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12187, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12226, POLARIZATION_HORIZONTAL,27500, FEC_3_5,  ROLLOFF_25,PSK_8},
{SYS_DVBS2,12304, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_25,PSK_8},
{SYS_DVBS2,12344, POLARIZATION_HORIZONTAL,28200, FEC_5_6,  ROLLOFF_35,PSK_8},
{SYS_DVBS2,12382, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_25,PSK_8},
{SYS_DVBS ,12525, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12525, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12565, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12565, POLARIZATION_VERTICAL  ,28500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS2,12605, POLARIZATION_HORIZONTAL,28500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS2,12605, POLARIZATION_VERTICAL  ,28500, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS ,12631, POLARIZATION_HORIZONTAL, 6666, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12631, POLARIZATION_VERTICAL  , 6000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12641, POLARIZATION_HORIZONTAL, 2220, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12649, POLARIZATION_HORIZONTAL, 5600, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12658, POLARIZATION_VERTICAL  , 2277, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12661, POLARIZATION_HORIZONTAL, 2170, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12685, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12696, POLARIZATION_HORIZONTAL, 3255, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12725, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EUROBIRD25_5E[] = { // Eurobird 2, 2008-07-10
{SYS_DVBS ,11004, POLARIZATION_VERTICAL  , 6430, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11009, POLARIZATION_VERTICAL  , 1071, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11013, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11054, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11075, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11096, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11148, POLARIZATION_VERTICAL  , 2960, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11154, POLARIZATION_VERTICAL  , 2200, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11165, POLARIZATION_VERTICAL  , 2220, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11170, POLARIZATION_VERTICAL  , 1340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11175, POLARIZATION_VERTICAL  , 2220, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11585, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11604, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11623, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11632, POLARIZATION_HORIZONTAL,14465, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11662, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11681, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder BADR26_XE[] = { // Badr C/3/4/6, 2008-07-10
{SYS_DVBS ,11727, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11747, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11785, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11804, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11823, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11843, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11862, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11919, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11938, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11958, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11977, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11996, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12015, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12034, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12054, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12073, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12092, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12111, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12130, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12149, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12169, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12182, POLARIZATION_HORIZONTAL,16200, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12207, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12226, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12284, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12523, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12656, POLARIZATION_HORIZONTAL, 1800, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12726, POLARIZATION_VERTICAL  , 5000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3880, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4040, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder ASTRA28_2E[] = { // Eurobird 1 Astra 2A/2B/2C/2D, 2008-07-11
{SYS_DVBS ,10714, POLARIZATION_HORIZONTAL,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10729, POLARIZATION_VERTICAL  ,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10744, POLARIZATION_HORIZONTAL,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10759, POLARIZATION_VERTICAL  ,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10773, POLARIZATION_HORIZONTAL,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10788, POLARIZATION_VERTICAL  ,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10803, POLARIZATION_HORIZONTAL,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10818, POLARIZATION_VERTICAL  ,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10832, POLARIZATION_HORIZONTAL,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10847, POLARIZATION_VERTICAL  ,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10862, POLARIZATION_HORIZONTAL,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10876, POLARIZATION_VERTICAL  ,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10891, POLARIZATION_HORIZONTAL,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10906, POLARIZATION_VERTICAL  ,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10921, POLARIZATION_HORIZONTAL,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10936, POLARIZATION_VERTICAL  ,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,10964, POLARIZATION_HORIZONTAL,22000, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,11222, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11224, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11260, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11261, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11307, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11307, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11343, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11344, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11389, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11390, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11426, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11428, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11469, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11488, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11508, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11527, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11546, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11565, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11585, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11604, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11623, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11642, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11662, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11681, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS2,11720, POLARIZATION_HORIZONTAL,29500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11739, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11758, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11778, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS2,11798, POLARIZATION_HORIZONTAL,29500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11817, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11836, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS2,11856, POLARIZATION_VERTICAL  ,29500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,11876, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11895, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11914, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11934, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11954, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11973, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,11992, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS2,12012, POLARIZATION_VERTICAL  ,29500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12032, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12051, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12070, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12090, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12109, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12129, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12148, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS2,12168, POLARIZATION_VERTICAL  ,29500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12188, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12207, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12226, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS2,12246, POLARIZATION_VERTICAL  ,29500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12266, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12284, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12304, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS2,12324, POLARIZATION_VERTICAL  ,29500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,12344, POLARIZATION_HORIZONTAL,29500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,12363, POLARIZATION_VERTICAL  ,29500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS2,12382, POLARIZATION_HORIZONTAL,29500, FEC_3_4, ROLLOFF_35, QPSK},
{SYS_DVBS ,12402, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12422, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12441, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12460, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12480, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12523, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12523, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS2,12552, POLARIZATION_VERTICAL  ,19531, FEC_5_6, ROLLOFF_35, QPSK},
{SYS_DVBS ,12560, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12560, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12607, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12607, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12643, POLARIZATION_HORIZONTAL,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12643, POLARIZATION_VERTICAL  ,27500, FEC_2_3, ROLLOFF_35, QPSK},
{SYS_DVBS ,12729, POLARIZATION_VERTICAL  , 2725, FEC_5_6, ROLLOFF_35, QPSK}};

static const struct __sat_transponder EUROBIRD28_5E[] = { // EuroBird 1, 2008-07-11 ,
{SYS_DVBS ,11222, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11224, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11260, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11261, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11307, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11307, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11343, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11344, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11390, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11389, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11426, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11428, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11469, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11488, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11508, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11527, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11546, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11565, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11585, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11603, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11623, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11642, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11662, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11681, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12523, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12523, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12560, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12560, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12607, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12643, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder HISPASAT30_0W[] = { // Hispasat 1C/1D, 2008-07-10, update 2010-01-10
{SYS_DVBS ,11474, POLARIZATION_HORIZONTAL, 3400, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11532, POLARIZATION_HORIZONTAL, 3000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11535, POLARIZATION_VERTICAL  ,24500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11577, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11615, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11617, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11650, POLARIZATION_VERTICAL  , 1010, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11676, POLARIZATION_HORIZONTAL,16190, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11682, POLARIZATION_VERTICAL  , 3800, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11731, POLARIZATION_HORIZONTAL,28126, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11731, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11731, POLARIZATION_VERTICAL  ,29000, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS ,11771, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11771, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11811, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11811, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11851, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11851, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11884, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11891, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11891, POLARIZATION_VERTICAL  ,30000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11931, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11931, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11972, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12012, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12012, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12052, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12092, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12092, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12149, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12226, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12303, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12380, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12456, POLARIZATION_VERTICAL  ,30000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12522, POLARIZATION_VERTICAL  , 7400, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12547, POLARIZATION_VERTICAL  ,30000, FEC_5_6,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder ASTRA31_5E[] = { // Astra 5A/1D, 2008-07-10
{SYS_DVBS ,11747, POLARIZATION_VERTICAL  ,22000, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11766, POLARIZATION_HORIZONTAL,22000, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11900, POLARIZATION_VERTICAL  ,22000, FEC_1_2,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder INTELSAT32_9E[] = { // Intelsat 802, 2008-07-10
{SYS_DVBS ,11589, POLARIZATION_HORIZONTAL,8681, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EUROBIRD33_0E[] = { // Eurobird 3, 2008-07-10
{SYS_DVBS ,11027, POLARIZATION_VERTICAL  , 8681, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11085, POLARIZATION_HORIZONTAL, 1628, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11087, POLARIZATION_HORIZONTAL, 1526, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11093, POLARIZATION_HORIZONTAL, 1428, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11095, POLARIZATION_HORIZONTAL, 1500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11098, POLARIZATION_HORIZONTAL, 2441, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11100, POLARIZATION_HORIZONTAL, 1785, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11104, POLARIZATION_HORIZONTAL, 1780, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11110, POLARIZATION_HORIZONTAL, 3124, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11116, POLARIZATION_HORIZONTAL, 1016, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11118, POLARIZATION_HORIZONTAL, 1427, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11125, POLARIZATION_HORIZONTAL, 2500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11137, POLARIZATION_HORIZONTAL, 2142, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11139, POLARIZATION_VERTICAL  , 4883, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11140, POLARIZATION_HORIZONTAL, 2500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11165, POLARIZATION_VERTICAL  , 1666, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11186, POLARIZATION_HORIZONTAL, 6150, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11472, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11513, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11555, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11596, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11637, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11650, POLARIZATION_VERTICAL  ,10098, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS ,11683, POLARIZATION_HORIZONTAL,17362, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12522, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12647, POLARIZATION_VERTICAL  ,28000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12739, POLARIZATION_VERTICAL  ,12402, FEC_7_8,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EUTELSAT35_9E[] = { // Eutelsat W4, 2008-07-10
{SYS_DVBS ,11727, POLARIZATION_CIRCULAR_LEFT ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11747, POLARIZATION_HORIZONTAL    ,27500, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11900, POLARIZATION_HORIZONTAL    ,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12092, POLARIZATION_HORIZONTAL    ,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12111, POLARIZATION_CIRCULAR_LEFT ,27500, FEC_3_4,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12130, POLARIZATION_HORIZONTAL    ,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12169, POLARIZATION_HORIZONTAL    ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12175, POLARIZATION_CIRCULAR_LEFT , 4340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12190, POLARIZATION_CIRCULAR_LEFT ,20000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12207, POLARIZATION_VERTICAL      ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12207, POLARIZATION_HORIZONTAL    ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12226, POLARIZATION_CIRCULAR_LEFT ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12245, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12265, POLARIZATION_CIRCULAR_LEFT ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12284, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12284, POLARIZATION_HORIZONTAL    ,26480, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12303, POLARIZATION_CIRCULAR_LEFT ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12322, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12322, POLARIZATION_HORIZONTAL    ,26480, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12341, POLARIZATION_CIRCULAR_LEFT ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12360, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12360, POLARIZATION_HORIZONTAL    ,26480, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12380, POLARIZATION_CIRCULAR_LEFT ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12399, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12399, POLARIZATION_HORIZONTAL    ,26480, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12418, POLARIZATION_CIRCULAR_LEFT ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12437, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12437, POLARIZATION_HORIZONTAL    ,23438, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12456, POLARIZATION_CIRCULAR_LEFT ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12476, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12476, POLARIZATION_HORIZONTAL    ,26040, FEC_2_3,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EUTELSAT36_0E[] = { // Eutelsat Sesat, 2008-07-10
{SYS_DVBS ,11109, POLARIZATION_VERTICAL  , 3418, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11142, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11559, POLARIZATION_HORIZONTAL,29000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11633, POLARIZATION_VERTICAL  , 5787, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11639, POLARIZATION_VERTICAL  , 2170, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11642, POLARIZATION_VERTICAL  , 2175, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11645, POLARIZATION_VERTICAL  , 2180, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11648, POLARIZATION_VERTICAL  , 2532, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11652, POLARIZATION_VERTICAL  , 2535, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11678, POLARIZATION_HORIZONTAL, 5000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12511, POLARIZATION_HORIZONTAL, 4340, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12516, POLARIZATION_VERTICAL  ,10370, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12521, POLARIZATION_HORIZONTAL, 4340, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12525, POLARIZATION_HORIZONTAL, 1110, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12528, POLARIZATION_HORIZONTAL, 2238, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12532, POLARIZATION_HORIZONTAL, 4340, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12541, POLARIZATION_HORIZONTAL, 4340, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12545, POLARIZATION_HORIZONTAL, 2734, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12558, POLARIZATION_VERTICAL  , 8138, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12560, POLARIZATION_HORIZONTAL, 2380, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12596, POLARIZATION_VERTICAL  , 2500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12599, POLARIZATION_VERTICAL  , 1447, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12611, POLARIZATION_VERTICAL  , 5787, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12616, POLARIZATION_VERTICAL  , 1628, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12625, POLARIZATION_VERTICAL  , 2668, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12633, POLARIZATION_VERTICAL  , 1000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12635, POLARIZATION_VERTICAL  , 1331, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12652, POLARIZATION_VERTICAL  , 2480, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12656, POLARIZATION_VERTICAL  , 2963, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder PAKSAT38_0E[] = { // Paksat 1, 2008-07-10
{SYS_DVBS , 3411, POLARIZATION_HORIZONTAL,13000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3433, POLARIZATION_HORIZONTAL, 3255, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3485, POLARIZATION_HORIZONTAL, 4650, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3504, POLARIZATION_HORIZONTAL, 9301, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3795, POLARIZATION_HORIZONTAL, 7000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3815, POLARIZATION_HORIZONTAL, 4666, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3864, POLARIZATION_HORIZONTAL, 3800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3876, POLARIZATION_HORIZONTAL, 2165, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3879, POLARIZATION_HORIZONTAL, 3332, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3886, POLARIZATION_HORIZONTAL, 6200, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3911, POLARIZATION_VERTICAL  , 3255, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3917, POLARIZATION_VERTICAL  , 3333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3945, POLARIZATION_HORIZONTAL, 4700, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3951, POLARIZATION_HORIZONTAL, 3240, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3968, POLARIZATION_HORIZONTAL,11481, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4031, POLARIZATION_HORIZONTAL, 3255, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4104, POLARIZATION_HORIZONTAL, 3000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4110, POLARIZATION_HORIZONTAL, 3255, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4115, POLARIZATION_HORIZONTAL, 3333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4120, POLARIZATION_HORIZONTAL, 3358, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder HELLAS39_0E[] = { // Hellas Sat 2, 2008-07-10
{SYS_DVBS ,10956, POLARIZATION_VERTICAL  , 4123, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10969, POLARIZATION_VERTICAL  , 2893, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10984, POLARIZATION_VERTICAL  , 8050, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11078, POLARIZATION_VERTICAL  , 4070, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11099, POLARIZATION_VERTICAL  , 1478, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11140, POLARIZATION_VERTICAL  , 1425, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11188, POLARIZATION_VERTICAL  , 4070, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11460, POLARIZATION_HORIZONTAL, 4000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11512, POLARIZATION_HORIZONTAL,30000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11542, POLARIZATION_HORIZONTAL, 2933, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11603, POLARIZATION_HORIZONTAL, 2893, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11630, POLARIZATION_HORIZONTAL,20500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11678, POLARIZATION_HORIZONTAL, 9766, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12524, POLARIZATION_VERTICAL  ,30000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12524, POLARIZATION_HORIZONTAL,30000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12559, POLARIZATION_HORIZONTAL,20000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12565, POLARIZATION_VERTICAL  ,30000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12577, POLARIZATION_HORIZONTAL,10000, FEC_5_6,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12606, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12606, POLARIZATION_HORIZONTAL,30000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12647, POLARIZATION_VERTICAL  ,30000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12647, POLARIZATION_HORIZONTAL,30000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12688, POLARIZATION_VERTICAL  ,30000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12688, POLARIZATION_HORIZONTAL,30000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12717, POLARIZATION_HORIZONTAL, 7720, FEC_3_4,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12729, POLARIZATION_VERTICAL  ,30000, FEC_7_8,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EXPRESS40_XE[] = { // Express AM1, 2008-07-10 ,
{SYS_DVBS ,10967, POLARIZATION_VERTICAL      ,20000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10981, POLARIZATION_HORIZONTAL    ,26586, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10995, POLARIZATION_VERTICAL      ,20000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11059, POLARIZATION_VERTICAL      , 5000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11083, POLARIZATION_VERTICAL      , 5064, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11097, POLARIZATION_HORIZONTAL    , 4800, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11159, POLARIZATION_VERTICAL      , 3332, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11599, POLARIZATION_VERTICAL      , 1478, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11657, POLARIZATION_VERTICAL      ,20802, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11679, POLARIZATION_HORIZONTAL    , 7596, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3675, POLARIZATION_CIRCULAR_RIGHT,33483, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3737, POLARIZATION_CIRCULAR_RIGHT, 3230, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3744, POLARIZATION_CIRCULAR_RIGHT, 3603, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3771, POLARIZATION_CIRCULAR_RIGHT, 3330, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3865, POLARIZATION_CIRCULAR_RIGHT, 4000, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3873, POLARIZATION_CIRCULAR_RIGHT, 4340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3933, POLARIZATION_CIRCULAR_RIGHT, 3300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4057, POLARIZATION_CIRCULAR_RIGHT, 3230, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4062, POLARIZATION_CIRCULAR_RIGHT, 2772, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4107, POLARIZATION_CIRCULAR_RIGHT, 3215, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4112, POLARIZATION_CIRCULAR_RIGHT, 4285, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4118, POLARIZATION_CIRCULAR_RIGHT, 3300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4125, POLARIZATION_CIRCULAR_RIGHT, 3215, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4128, POLARIZATION_CIRCULAR_RIGHT, 3230, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4131, POLARIZATION_CIRCULAR_RIGHT, 3219, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4135, POLARIZATION_CIRCULAR_RIGHT, 3240, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4140, POLARIZATION_CIRCULAR_RIGHT, 3230, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4143, POLARIZATION_CIRCULAR_RIGHT, 2003, FEC_7_8,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder TURKSAT42_0E[] = { // Turksat 2A/3A, 2011-03-13
{SYS_DVBS ,10955, POLARIZATION_HORIZONTAL, 2960, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam East
{SYS_DVBS ,10959, POLARIZATION_HORIZONTAL, 2222, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat3A Beam East
{SYS_DVBS ,10968, POLARIZATION_HORIZONTAL,11200, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam East
{SYS_DVBS ,10970, POLARIZATION_VERTICAL  ,30000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,10982, POLARIZATION_HORIZONTAL, 9600, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam East
{SYS_DVBS ,11012, POLARIZATION_VERTICAL  ,30000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,11027, POLARIZATION_HORIZONTAL, 2965, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat3A Beam East
{SYS_DVBS2,11043, POLARIZATION_VERTICAL  , 6400, FEC_3_4, ROLLOFF_35, PSK_8}, // Turksat3A Beam West
{SYS_DVBS ,11047, POLARIZATION_VERTICAL  , 2400, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,11054, POLARIZATION_HORIZONTAL,30000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam East
{SYS_DVBS ,11064, POLARIZATION_VERTICAL  ,13000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,11096, POLARIZATION_HORIZONTAL,30000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam East
{SYS_DVBS ,11096, POLARIZATION_VERTICAL  ,30000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,11103, POLARIZATION_VERTICAL  ,14400, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11172, POLARIZATION_VERTICAL  , 2190, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,11194, POLARIZATION_HORIZONTAL, 7200, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS2,11462, POLARIZATION_VERTICAL  , 3200, FEC_3_4, ROLLOFF_35, PSK_8}, // Turksat3A Beam West
{SYS_DVBS2,11490, POLARIZATION_VERTICAL  , 5000, FEC_3_4, ROLLOFF_35, PSK_8}, // Turksat3A Beam West
{SYS_DVBS ,11523, POLARIZATION_VERTICAL  , 2222, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,11527, POLARIZATION_VERTICAL  , 2190, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,11554, POLARIZATION_HORIZONTAL, 2916, FEC_2_3, ROLLOFF_35, QPSK }, // Turksat3A Beam East
{SYS_DVBS ,11581, POLARIZATION_HORIZONTAL, 4444, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat3A Beam East
{SYS_DVBS ,11628, POLARIZATION_HORIZONTAL, 6666, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam East
{SYS_DVBS ,11651, POLARIZATION_HORIZONTAL, 2222, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam East
{SYS_DVBS ,11658, POLARIZATION_HORIZONTAL, 2222, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat3A Beam East
{SYS_DVBS ,11716, POLARIZATION_VERTICAL  , 2222, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11729, POLARIZATION_VERTICAL  ,15555, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11742, POLARIZATION_VERTICAL  , 3600, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11747, POLARIZATION_HORIZONTAL,27500, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11766, POLARIZATION_VERTICAL  , 2222, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11769, POLARIZATION_VERTICAL  , 2178, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11772, POLARIZATION_HORIZONTAL, 3925, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11777, POLARIZATION_HORIZONTAL, 4800, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11781, POLARIZATION_VERTICAL  , 2815, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11792, POLARIZATION_HORIZONTAL,16000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11804, POLARIZATION_VERTICAL  ,24444, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11819, POLARIZATION_HORIZONTAL, 3000, FEC_7_8, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11830, POLARIZATION_VERTICAL  , 7200, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11839, POLARIZATION_VERTICAL  , 4444, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11858, POLARIZATION_VERTICAL  , 3150, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11862, POLARIZATION_HORIZONTAL,27500, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11870, POLARIZATION_VERTICAL  , 8888, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11879, POLARIZATION_VERTICAL  , 2815, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11885, POLARIZATION_HORIZONTAL, 2960, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11887, POLARIZATION_VERTICAL  , 9200, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11891, POLARIZATION_VERTICAL  , 2222, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11894, POLARIZATION_HORIZONTAL, 2400, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11896, POLARIZATION_VERTICAL  , 2170, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11897, POLARIZATION_HORIZONTAL, 2420, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11901, POLARIZATION_HORIZONTAL, 2962, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11906, POLARIZATION_HORIZONTAL, 4800, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11912, POLARIZATION_HORIZONTAL, 3333, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11918, POLARIZATION_VERTICAL  ,24440, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS2,11935, POLARIZATION_HORIZONTAL,20000, FEC_3_4, ROLLOFF_35, PSK_8}, // Turksat2A Beam East
{SYS_DVBS ,11950, POLARIZATION_HORIZONTAL, 7500, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11952, POLARIZATION_VERTICAL  , 2980, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11957, POLARIZATION_VERTICAL  , 2960, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11962, POLARIZATION_VERTICAL  , 3333, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11964, POLARIZATION_HORIZONTAL, 5925, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11970, POLARIZATION_VERTICAL  , 5900, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,11973, POLARIZATION_HORIZONTAL, 7200, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11981, POLARIZATION_HORIZONTAL, 5200, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11988, POLARIZATION_HORIZONTAL, 2222, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,11996, POLARIZATION_VERTICAL  ,27500, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,12015, POLARIZATION_HORIZONTAL,27500, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,12130, POLARIZATION_HORIZONTAL,15000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam East
{SYS_DVBS ,12130, POLARIZATION_VERTICAL  ,27500, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,12519, POLARIZATION_HORIZONTAL, 3125, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,12525, POLARIZATION_VERTICAL  ,30000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12544, POLARIZATION_HORIZONTAL,24000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12562, POLARIZATION_VERTICAL  ,25000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12577, POLARIZATION_HORIZONTAL, 2590, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12592, POLARIZATION_HORIZONTAL, 8888, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12592, POLARIZATION_VERTICAL  , 2220, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12596, POLARIZATION_VERTICAL  , 3700, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12601, POLARIZATION_HORIZONTAL, 4400, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12601, POLARIZATION_VERTICAL  , 2960, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12607, POLARIZATION_HORIZONTAL, 2950, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12609, POLARIZATION_VERTICAL  , 3700, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12612, POLARIZATION_HORIZONTAL, 4800, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12615, POLARIZATION_VERTICAL  , 4800, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12618, POLARIZATION_HORIZONTAL, 2800, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat2A Beam Europe
{SYS_DVBS ,12620, POLARIZATION_VERTICAL  , 2400, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12629, POLARIZATION_VERTICAL  , 3740, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12634, POLARIZATION_VERTICAL  , 2222, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12640, POLARIZATION_VERTICAL  , 2400, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12643, POLARIZATION_HORIZONTAL, 4800, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12644, POLARIZATION_VERTICAL  , 2960, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12650, POLARIZATION_HORIZONTAL, 4250, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12653, POLARIZATION_VERTICAL  , 4444, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12656, POLARIZATION_HORIZONTAL, 4444, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12679, POLARIZATION_VERTICAL  , 8888, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12685, POLARIZATION_HORIZONTAL,30000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12694, POLARIZATION_VERTICAL  , 3333, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12702, POLARIZATION_VERTICAL  , 2960, FEC_3_4, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12729, POLARIZATION_HORIZONTAL,30000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
{SYS_DVBS ,12729, POLARIZATION_VERTICAL  ,30000, FEC_5_6, ROLLOFF_35, QPSK }, // Turksat3A Beam West
};

static const struct __sat_transponder INTELSAT45_0E[] = { // Intelsat 12, 2008-07-10
{SYS_DVBS ,11468, POLARIZATION_VERTICAL  ,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11500, POLARIZATION_VERTICAL  , 4340, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11511, POLARIZATION_VERTICAL  , 2894, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11550, POLARIZATION_VERTICAL  ,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11591, POLARIZATION_VERTICAL  ,30000, FEC_7_8,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder YAMAL49_0E[] = { // Yamal 202, 2008-07-10
{SYS_DVBS ,3585, POLARIZATION_CIRCULAR_LEFT , 3215, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3597, POLARIZATION_CIRCULAR_LEFT , 2895, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3706, POLARIZATION_CIRCULAR_LEFT ,15550, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3740, POLARIZATION_CIRCULAR_LEFT ,38000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3776, POLARIZATION_CIRCULAR_RIGHT, 2532, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3792, POLARIZATION_CIRCULAR_LEFT , 1800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3940, POLARIZATION_CIRCULAR_LEFT , 7500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3945, POLARIZATION_CIRCULAR_LEFT , 1555, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3948, POLARIZATION_CIRCULAR_LEFT , 2220, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3952, POLARIZATION_CIRCULAR_LEFT , 4500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3960, POLARIZATION_CIRCULAR_LEFT , 8570, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3970, POLARIZATION_CIRCULAR_LEFT , 4275, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3976, POLARIZATION_CIRCULAR_LEFT , 4285, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3982, POLARIZATION_CIRCULAR_LEFT , 4285, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3987, POLARIZATION_CIRCULAR_LEFT , 2150, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,4066, POLARIZATION_CIRCULAR_LEFT ,29763, FEC_5_6,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EXPRESS53_0E[] = { // Express AM22, 2008-07-10
{SYS_DVBS ,10974, POLARIZATION_HORIZONTAL, 8150, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10974, POLARIZATION_VERTICAL  ,32223, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11044, POLARIZATION_VERTICAL  ,44951, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11096, POLARIZATION_VERTICAL  , 6164, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11124, POLARIZATION_HORIZONTAL, 7593, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11161, POLARIZATION_VERTICAL  , 5785, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11481, POLARIZATION_HORIZONTAL,41250, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11616, POLARIZATION_VERTICAL  , 2894, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11630, POLARIZATION_VERTICAL  , 2893, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11682, POLARIZATION_VERTICAL  , 5000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11696, POLARIZATION_HORIZONTAL, 1786, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12632, POLARIZATION_HORIZONTAL, 2170, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12644, POLARIZATION_HORIZONTAL, 2170, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12648, POLARIZATION_HORIZONTAL, 2894, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12652, POLARIZATION_HORIZONTAL, 2532, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12664, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12680, POLARIZATION_HORIZONTAL, 2532, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12708, POLARIZATION_HORIZONTAL,26665, FEC_8_9,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12716, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12741, POLARIZATION_HORIZONTAL, 7086, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder BONUM56_0E[] = { // Bonum 1, 2008-07-10
{SYS_DVBS ,12226, POLARIZATION_CIRCULAR_LEFT ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12245, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12303, POLARIZATION_CIRCULAR_LEFT ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12322, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12399, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12456, POLARIZATION_CIRCULAR_LEFT ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12476, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder NSS57_XE[] = { // NSS 703, 2008-07-10
{SYS_DVBS ,12551, POLARIZATION_VERTICAL      , 9404, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3910, POLARIZATION_CIRCULAR_LEFT , 2893, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4055, POLARIZATION_CIRCULAR_RIGHT,26000, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4065, POLARIZATION_CIRCULAR_LEFT , 6600, FEC_1_2,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder INTELSAT60_XE[] = { // Intelsat 904, 2008-07-10
{SYS_DVBS ,10964, POLARIZATION_HORIZONTAL    , 3327, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10984, POLARIZATION_VERTICAL      , 3819, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10987, POLARIZATION_VERTICAL      , 1240, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11011, POLARIZATION_HORIZONTAL    , 2975, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11042, POLARIZATION_VERTICAL      , 7440, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11093, POLARIZATION_VERTICAL      , 3980, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11101, POLARIZATION_VERTICAL      , 4105, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11149, POLARIZATION_VERTICAL      ,20000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11142, POLARIZATION_HORIZONTAL    , 2963, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11466, POLARIZATION_VERTICAL      , 1000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11490, POLARIZATION_VERTICAL      , 5788, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11512, POLARIZATION_VERTICAL      , 3690, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11527, POLARIZATION_VERTICAL      , 3400, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11595, POLARIZATION_VERTICAL      ,29270, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11635, POLARIZATION_VERTICAL      ,29700, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11675, POLARIZATION_VERTICAL      ,29700, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,3719,  POLARIZATION_CIRCULAR_LEFT ,13300, FEC_1_2,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder INTELSAT62_XE[] = { // Intelsat 902, 2008-07-10
{SYS_DVBS ,10961, POLARIZATION_VERTICAL      , 5300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10973, POLARIZATION_VERTICAL      , 8150, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10980, POLARIZATION_VERTICAL      , 5300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10988, POLARIZATION_VERTICAL      , 5300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10993, POLARIZATION_VERTICAL      , 3600, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11088, POLARIZATION_VERTICAL      , 3600, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11093, POLARIZATION_VERTICAL      , 3600, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11103, POLARIZATION_VERTICAL      ,10000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11104, POLARIZATION_HORIZONTAL    , 3328, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11108, POLARIZATION_HORIZONTAL    , 2170, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11151, POLARIZATION_HORIZONTAL    , 5787, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11176, POLARIZATION_HORIZONTAL    , 3333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11187, POLARIZATION_HORIZONTAL    , 2047, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11190, POLARIZATION_HORIZONTAL    , 2480, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11555, POLARIZATION_VERTICAL      ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3814, POLARIZATION_CIRCULAR_LEFT , 3852, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3837, POLARIZATION_CIRCULAR_LEFT , 2466, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3992, POLARIZATION_CIRCULAR_LEFT ,26000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4177, POLARIZATION_CIRCULAR_LEFT ,31532, FEC_2_3,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder INTELSAT64_2E[] = { // Intelsat 906, 2008-07-10
{SYS_DVBS , 3642, POLARIZATION_CIRCULAR_RIGHT,13330, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3654, POLARIZATION_CIRCULAR_RIGHT, 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3721, POLARIZATION_CIRCULAR_RIGHT, 4882, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3778, POLARIZATION_CIRCULAR_RIGHT, 3000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3884, POLARIZATION_CIRCULAR_LEFT , 3271, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3891, POLARIZATION_CIRCULAR_LEFT , 4445, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3966, POLARIZATION_CIRCULAR_RIGHT,10166, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3998, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4094, POLARIZATION_CIRCULAR_LEFT , 3680, FEC_2_3,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder INTELSAT68_XE[] = { // Intelsat 7/10, 2008-07-10
{SYS_DVBS ,11567, POLARIZATION_VERTICAL  ,2380, FEC_9_10,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11594, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11674, POLARIZATION_VERTICAL  ,26652, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12522, POLARIZATION_HORIZONTAL,26657, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12562, POLARIZATION_HORIZONTAL,26657, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12575, POLARIZATION_VERTICAL  , 3378, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12682, POLARIZATION_HORIZONTAL,26657, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12722, POLARIZATION_HORIZONTAL,26657, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12722, POLARIZATION_VERTICAL  ,26657, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3661, POLARIZATION_VERTICAL  ,14074, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3716, POLARIZATION_HORIZONTAL,20770, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3716, POLARIZATION_VERTICAL  ,20600, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3744, POLARIZATION_HORIZONTAL,16180, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3744, POLARIZATION_VERTICAL  ,20600, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3764, POLARIZATION_VERTICAL  , 2950, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3768, POLARIZATION_HORIZONTAL, 6500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3774, POLARIZATION_HORIZONTAL, 3300, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3774, POLARIZATION_VERTICAL  , 2940, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3777, POLARIZATION_VERTICAL  , 2940, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3780, POLARIZATION_HORIZONTAL, 3000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3782, POLARIZATION_VERTICAL  , 2965, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3783, POLARIZATION_HORIZONTAL, 3250, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3787, POLARIZATION_VERTICAL  , 3617, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3803, POLARIZATION_HORIZONTAL, 5100, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3808, POLARIZATION_VERTICAL  ,10340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3810, POLARIZATION_HORIZONTAL, 3312, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3836, POLARIZATION_HORIZONTAL,19850, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3836, POLARIZATION_VERTICAL  ,20600, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3863, POLARIZATION_VERTICAL  ,20600, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3864, POLARIZATION_HORIZONTAL,19850, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3900, POLARIZATION_VERTICAL  ,12300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3913, POLARIZATION_VERTICAL  , 6510, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3920, POLARIZATION_VERTICAL  , 3000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3924, POLARIZATION_VERTICAL  , 3003, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3927, POLARIZATION_HORIZONTAL,26500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3974, POLARIZATION_HORIZONTAL,19500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3974, POLARIZATION_VERTICAL  ,19850, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4003, POLARIZATION_HORIZONTAL, 2965, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4011, POLARIZATION_VERTICAL  , 2200, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4034, POLARIZATION_HORIZONTAL,20500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4034, POLARIZATION_VERTICAL  ,19559, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4054, POLARIZATION_VERTICAL  , 4400, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4059, POLARIZATION_VERTICAL  , 3529, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4064, POLARIZATION_HORIZONTAL,19850, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4064, POLARIZATION_VERTICAL  , 4610, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4070, POLARIZATION_VERTICAL  , 3003, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4075, POLARIZATION_VERTICAL  , 4000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4085, POLARIZATION_VERTICAL  , 3428, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4087, POLARIZATION_HORIZONTAL, 9375, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4103, POLARIZATION_HORIZONTAL, 5720, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4117, POLARIZATION_HORIZONTAL, 3333, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4124, POLARIZATION_VERTICAL  ,19850, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4126, POLARIZATION_HORIZONTAL, 3255, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4132, POLARIZATION_HORIZONTAL, 2573, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4143, POLARIZATION_HORIZONTAL, 3306, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4147, POLARIZATION_HORIZONTAL, 3300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4160, POLARIZATION_HORIZONTAL, 3617, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4165, POLARIZATION_HORIZONTAL, 3255, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4173, POLARIZATION_VERTICAL  , 3000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4178, POLARIZATION_VERTICAL  , 4000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4185, POLARIZATION_HORIZONTAL,20000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4189, POLARIZATION_VERTICAL  ,12210, FEC_2_3,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EUTELSAT70_5E[] = { // Eutelsat W5, 2008-07-10
{SYS_DVBS ,11214, POLARIZATION_HORIZONTAL,13021, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11240, POLARIZATION_VERTICAL  ,27500, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11261, POLARIZATION_HORIZONTAL,27235, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11305, POLARIZATION_VERTICAL  ,17362, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11345, POLARIZATION_HORIZONTAL,24074, FEC_5_6,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder INTELSAT72_XE[] = { // Intelsat 4, 2008-07-10
{SYS_DVBS ,12506, POLARIZATION_HORIZONTAL, 2500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12518, POLARIZATION_VERTICAL  , 8232, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12544, POLARIZATION_HORIZONTAL, 1480, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12591, POLARIZATION_VERTICAL  ,39067, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12657, POLARIZATION_HORIZONTAL, 5920, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12666, POLARIZATION_HORIZONTAL, 3330, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12675, POLARIZATION_VERTICAL  , 3255, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3709, POLARIZATION_VERTICAL  , 2083, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3712, POLARIZATION_VERTICAL  , 2083, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3729, POLARIZATION_VERTICAL  ,10500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3850, POLARIZATION_VERTICAL  ,41650, FEC_5_6,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder ABS75_XE[] = { // ABS 1, *** TO BE CHECKED!! ****
{SYS_DVBS ,12505, POLARIZATION_HORIZONTAL,2500,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12518, POLARIZATION_VERTICAL  ,22000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12548, POLARIZATION_VERTICAL  ,22000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12579, POLARIZATION_VERTICAL  ,22000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12579, POLARIZATION_HORIZONTAL,22000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12610, POLARIZATION_VERTICAL  ,22000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12640, POLARIZATION_VERTICAL  ,22000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12670, POLARIZATION_VERTICAL  ,22000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12693, POLARIZATION_VERTICAL  ,11000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12704, POLARIZATION_VERTICAL  ,3900,  FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12723, POLARIZATION_VERTICAL  ,6820,  FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12740, POLARIZATION_VERTICAL  ,7247,  FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3577, POLARIZATION_HORIZONTAL,9600,  FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3652, POLARIZATION_VERTICAL  ,8889,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3659, POLARIZATION_HORIZONTAL,27500, FEC_7_8,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder TELSTAR76_XE[] = { // Telstar 10, *** TO BE CHECKED!! ****
{SYS_DVBS ,12278, POLARIZATION_VERTICAL  ,22425, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12308, POLARIZATION_VERTICAL  ,22425, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12405, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12435, POLARIZATION_VERTICAL  ,15000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12462, POLARIZATION_VERTICAL  ,22425, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12491, POLARIZATION_VERTICAL  ,22425, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12528, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12678, POLARIZATION_VERTICAL  ,15000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12700, POLARIZATION_VERTICAL  , 5660, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3646,  POLARIZATION_VERTICAL  , 5064, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3655,  POLARIZATION_HORIZONTAL, 3214, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3680,  POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3704,  POLARIZATION_VERTICAL  , 6716, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3714,  POLARIZATION_VERTICAL  , 7475, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3720,  POLARIZATION_HORIZONTAL,29268, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3760,  POLARIZATION_HORIZONTAL,28066, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3780,  POLARIZATION_VERTICAL  ,28066, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3787,  POLARIZATION_HORIZONTAL, 4600, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3793,  POLARIZATION_HORIZONTAL, 4340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3840,  POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3880,  POLARIZATION_HORIZONTAL,28125, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,3920,  POLARIZATION_HORIZONTAL,28340, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,4030,  POLARIZATION_VERTICAL  , 6312, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,4034,  POLARIZATION_HORIZONTAL, 4300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,4049,  POLARIZATION_HORIZONTAL, 3600, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,4056,  POLARIZATION_HORIZONTAL, 3214, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,4073,  POLARIZATION_HORIZONTAL,13020, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,4089,  POLARIZATION_HORIZONTAL, 4300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,4095,  POLARIZATION_HORIZONTAL, 4080, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,4105,  POLARIZATION_HORIZONTAL, 3125, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,4113,  POLARIZATION_HORIZONTAL, 2892, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,4146,  POLARIZATION_HORIZONTAL, 3600, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,4173,  POLARIZATION_HORIZONTAL, 7400, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder THAICOM78_5E[] = { // Thaicom 2/5, *** TO BE CHECKED!! ****
{SYS_DVBS , 3431, POLARIZATION_HORIZONTAL,13333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3504, POLARIZATION_HORIZONTAL, 3367, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3551, POLARIZATION_HORIZONTAL,13333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3574, POLARIZATION_HORIZONTAL, 7492, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3600, POLARIZATION_HORIZONTAL,26667, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3640, POLARIZATION_HORIZONTAL,28066, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3664, POLARIZATION_HORIZONTAL, 3704, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3670, POLARIZATION_HORIZONTAL, 3704, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3695, POLARIZATION_HORIZONTAL, 5000, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EXPRESS80_XE[] = { // Express AM2, *** TO BE CHECKED!! ****
{SYS_DVBS ,10973, POLARIZATION_VERTICAL  , 4444, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10991, POLARIZATION_VERTICAL  , 4444, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11044, POLARIZATION_HORIZONTAL,44948, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11088, POLARIZATION_VERTICAL  , 4548, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11133, POLARIZATION_VERTICAL  , 2000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11190, POLARIZATION_HORIZONTAL, 3255, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11462, POLARIZATION_HORIZONTAL, 4100, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11478, POLARIZATION_HORIZONTAL, 4400, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11606, POLARIZATION_VERTICAL  ,44948, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11650, POLARIZATION_VERTICAL  , 5700, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3525, POLARIZATION_VERTICAL  ,31106, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3675, POLARIZATION_VERTICAL  ,33483, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4147, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4175, POLARIZATION_VERTICAL  , 6510, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder INSAT83_XE[] = { // Insat 2E/3B/4A, *** TO BE CHECKED!! ****
{SYS_DVBS ,10970, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11010, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11050, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11090, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11130, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11170, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11470, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11510, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11550, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11558, POLARIZATION_VERTICAL  ,13328, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11590, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11630, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11670, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3438, POLARIZATION_VERTICAL  , 2950, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3523, POLARIZATION_VERTICAL  , 8640, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3550, POLARIZATION_VERTICAL  , 3255, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3559, POLARIZATION_VERTICAL  , 3366, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3581, POLARIZATION_VERTICAL  , 3255, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3593, POLARIZATION_VERTICAL  , 8680, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3612, POLARIZATION_VERTICAL  , 9629, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3643, POLARIZATION_VERTICAL  ,19531, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3678, POLARIZATION_VERTICAL  , 5926, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3696, POLARIZATION_VERTICAL  , 6111, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3725, POLARIZATION_HORIZONTAL,26665, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3756, POLARIZATION_HORIZONTAL,13333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3760, POLARIZATION_VERTICAL  , 6500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3774, POLARIZATION_VERTICAL  ,13021, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3777, POLARIZATION_HORIZONTAL,10900, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3805, POLARIZATION_HORIZONTAL,28500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3838, POLARIZATION_HORIZONTAL, 3333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3844, POLARIZATION_HORIZONTAL, 3333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3845, POLARIZATION_VERTICAL  ,26043, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3853, POLARIZATION_HORIZONTAL, 3265, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3857, POLARIZATION_HORIZONTAL, 3462, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3898, POLARIZATION_HORIZONTAL, 6800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3923, POLARIZATION_VERTICAL  , 3000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3923, POLARIZATION_HORIZONTAL,13000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3934, POLARIZATION_VERTICAL  ,13021, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3936, POLARIZATION_HORIZONTAL,10100, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3974, POLARIZATION_VERTICAL  ,13333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3976, POLARIZATION_HORIZONTAL, 3200, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4004, POLARIZATION_HORIZONTAL,22200, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4005, POLARIZATION_VERTICAL  ,27000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4032, POLARIZATION_VERTICAL  , 7440, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4040, POLARIZATION_HORIZONTAL, 7500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4042, POLARIZATION_VERTICAL  , 7420, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4050, POLARIZATION_VERTICAL  , 5084, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4054, POLARIZATION_HORIZONTAL,13230, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4070, POLARIZATION_VERTICAL  , 5000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4072, POLARIZATION_HORIZONTAL, 6500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4082, POLARIZATION_HORIZONTAL, 6500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4087, POLARIZATION_HORIZONTAL, 3300, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4091, POLARIZATION_HORIZONTAL, 3000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4100, POLARIZATION_HORIZONTAL, 4750, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4115, POLARIZATION_HORIZONTAL, 5555, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4134, POLARIZATION_HORIZONTAL,10600, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4151, POLARIZATION_HORIZONTAL, 6500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4161, POLARIZATION_HORIZONTAL, 6500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4170, POLARIZATION_HORIZONTAL, 4650, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4180, POLARIZATION_HORIZONTAL, 3233, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4597, POLARIZATION_HORIZONTAL, 2222, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4601, POLARIZATION_HORIZONTAL, 2222, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4608, POLARIZATION_HORIZONTAL, 2222, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4624, POLARIZATION_HORIZONTAL, 3332, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4677, POLARIZATION_HORIZONTAL, 2000, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder CHINASTAR87_5E[] = { // ChinaStar 1, *** TO BE CHECKED!! ****
{SYS_DVBS , 3734, POLARIZATION_HORIZONTAL, 5925, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder ST88_XE[] = { // ST 1, *** TO BE CHECKED!! ****
{SYS_DVBS ,11508, POLARIZATION_VERTICAL  , 6000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12515, POLARIZATION_HORIZONTAL,12500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12638, POLARIZATION_VERTICAL  , 2200, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12642, POLARIZATION_HORIZONTAL,24000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12645, POLARIZATION_VERTICAL  , 8000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12669, POLARIZATION_VERTICAL  ,12144, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12673, POLARIZATION_HORIZONTAL,17500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3550, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3632, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3671, POLARIZATION_HORIZONTAL ,9256, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3689, POLARIZATION_HORIZONTAL ,3000, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder YAMAL90_XE[] = { // Yamal 201, *** TO BE CHECKED!! ****
{SYS_DVBS ,10990, POLARIZATION_VERTICAL  ,2170,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10995, POLARIZATION_VERTICAL  ,4285,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11057, POLARIZATION_VERTICAL  ,26470, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11093, POLARIZATION_VERTICAL  ,26470, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11145, POLARIZATION_VERTICAL  ,22222, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11671, POLARIZATION_VERTICAL  ,18200, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3536, POLARIZATION_HORIZONTAL,2532,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3539, POLARIZATION_HORIZONTAL,3274,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3553, POLARIZATION_HORIZONTAL,20000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3577, POLARIZATION_HORIZONTAL,2626,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3582, POLARIZATION_HORIZONTAL,4275,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3588, POLARIZATION_HORIZONTAL,4285,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3594, POLARIZATION_HORIZONTAL,4275,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3600, POLARIZATION_HORIZONTAL,4285,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3603, POLARIZATION_VERTICAL  ,4285,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3605, POLARIZATION_HORIZONTAL,2626,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3645, POLARIZATION_HORIZONTAL,28000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3674, POLARIZATION_HORIZONTAL,17500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3725, POLARIZATION_HORIZONTAL,3200,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3730, POLARIZATION_HORIZONTAL,4285,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3900, POLARIZATION_HORIZONTAL,4285,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3907, POLARIZATION_HORIZONTAL,4265,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3912, POLARIZATION_HORIZONTAL,4295,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3918, POLARIZATION_HORIZONTAL,4275,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3922, POLARIZATION_HORIZONTAL,3570,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3925, POLARIZATION_HORIZONTAL,1116,  FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3944, POLARIZATION_HORIZONTAL,15550, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3980, POLARIZATION_HORIZONTAL,38000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4042, POLARIZATION_VERTICAL  ,8681,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4084, POLARIZATION_VERTICAL  ,2500,  FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder MEASAT91_5E[] = { // Measat 3, *** TO BE CHECKED!! ****
{SYS_DVBS , 3480, POLARIZATION_HORIZONTAL,28000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3629, POLARIZATION_VERTICAL  , 2200, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3721, POLARIZATION_VERTICAL  , 2170, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3752, POLARIZATION_VERTICAL  ,13330, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3784, POLARIZATION_VERTICAL  , 7030, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3794, POLARIZATION_VERTICAL  , 7030, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3841, POLARIZATION_VERTICAL  ,30000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3865, POLARIZATION_VERTICAL  , 3835, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3876, POLARIZATION_VERTICAL  ,12525, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3920, POLARIZATION_VERTICAL  ,28000, FEC_7_8,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder INSAT93_5E[] = { // Insat 3A/4B, *** TO BE CHECKED!! ****
{SYS_DVBS , 3725, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3750, POLARIZATION_HORIZONTAL, 4250, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3762, POLARIZATION_HORIZONTAL, 4250, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3768, POLARIZATION_HORIZONTAL, 4250, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3802, POLARIZATION_HORIZONTAL, 4250, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3808, POLARIZATION_HORIZONTAL, 4250, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3822, POLARIZATION_HORIZONTAL, 4250, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3832, POLARIZATION_HORIZONTAL, 6250, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3841, POLARIZATION_HORIZONTAL, 6250, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3885, POLARIZATION_HORIZONTAL,28000, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder NSS95_0E[] = { // NSS 6, *** TO BE CHECKED!! ****
{SYS_DVBS ,11017, POLARIZATION_VERTICAL  ,10500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11635, POLARIZATION_HORIZONTAL,27672, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12619, POLARIZATION_HORIZONTAL, 5185, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12647, POLARIZATION_HORIZONTAL,28000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12688, POLARIZATION_HORIZONTAL,28000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12729, POLARIZATION_HORIZONTAL,26400, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EXPRESS96_XE[] = { // Express AM33, *** TO BE CHECKED!! ****
{SYS_DVBS ,11463, POLARIZATION_VERTICAL  , 3200, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11500, POLARIZATION_VERTICAL  , 4400, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11527, POLARIZATION_VERTICAL  ,12000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3675, POLARIZATION_VERTICAL  ,33483, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3758, POLARIZATION_VERTICAL  , 4340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3808, POLARIZATION_VERTICAL  , 3215, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3817, POLARIZATION_VERTICAL  , 4270, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3838, POLARIZATION_VERTICAL  , 3230, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3843, POLARIZATION_VERTICAL  , 3220, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3925, POLARIZATION_VERTICAL  , 4883, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4108, POLARIZATION_VERTICAL  , 4275, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4114, POLARIZATION_VERTICAL  , 4285, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4143, POLARIZATION_VERTICAL  , 3210, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder ASIASAT100_XE[] = { // AsiaSat 2, *** TO BE CHECKED!! ****
{SYS_DVBS ,12222, POLARIZATION_VERTICAL  , 6000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12228, POLARIZATION_VERTICAL  , 3400, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12259, POLARIZATION_VERTICAL  , 7000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3660, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3706, POLARIZATION_HORIZONTAL, 4167, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3760, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3767, POLARIZATION_VERTICAL  , 6527, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3778, POLARIZATION_VERTICAL  , 3333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3786, POLARIZATION_HORIZONTAL, 6000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3790, POLARIZATION_VERTICAL  , 2444, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3799, POLARIZATION_HORIZONTAL, 5632, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3820, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3905, POLARIZATION_HORIZONTAL, 4000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3960, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3980, POLARIZATION_VERTICAL  ,28100, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4000, POLARIZATION_HORIZONTAL,28125, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4148, POLARIZATION_VERTICAL  ,11852, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder ASIASAT105_XE[] = { // AsiaSat 3S, *** TO BE CHECKED!! ****
{SYS_DVBS ,12352, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12378, POLARIZATION_VERTICAL  ,3100,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12383, POLARIZATION_VERTICAL  ,3100,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12402, POLARIZATION_HORIZONTAL,4000,  FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12424, POLARIZATION_HORIZONTAL,3000,  FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12459, POLARIZATION_VERTICAL  ,7600,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12465, POLARIZATION_VERTICAL  ,3100,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12469, POLARIZATION_VERTICAL  ,2900,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12511, POLARIZATION_HORIZONTAL,4340,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3680, POLARIZATION_HORIZONTAL,26670, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3700, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3706, POLARIZATION_HORIZONTAL,6000,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3725, POLARIZATION_VERTICAL  ,4450,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3729, POLARIZATION_HORIZONTAL,13650, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3732, POLARIZATION_VERTICAL  ,6500,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3745, POLARIZATION_VERTICAL  ,2626,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3750, POLARIZATION_VERTICAL  ,2821,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3755, POLARIZATION_VERTICAL  ,4418,  FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3760, POLARIZATION_HORIZONTAL,26000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3780, POLARIZATION_VERTICAL  ,28100, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3785, POLARIZATION_HORIZONTAL,5700,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3792, POLARIZATION_HORIZONTAL,3000,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3816, POLARIZATION_HORIZONTAL,2515,  FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3840, POLARIZATION_HORIZONTAL,26850, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3860, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3920, POLARIZATION_HORIZONTAL,26850, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3940, POLARIZATION_VERTICAL  ,28100, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3960, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3980, POLARIZATION_VERTICAL  ,28100, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4000, POLARIZATION_HORIZONTAL,26850, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4020, POLARIZATION_VERTICAL  ,27250, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4040, POLARIZATION_HORIZONTAL,20400, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4091, POLARIZATION_VERTICAL  ,13333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4095, POLARIZATION_HORIZONTAL,5554,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4102, POLARIZATION_VERTICAL  ,2894,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4106, POLARIZATION_VERTICAL  ,2894,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4111, POLARIZATION_HORIZONTAL,13650, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4114, POLARIZATION_VERTICAL  ,7000,  FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4140, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4180, POLARIZATION_VERTICAL  ,26666, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder NSS108_XE[] = { // Telkom 1 & NSS 11, *** TO BE CHECKED!! ****
{SYS_DVBS ,12315, POLARIZATION_VERTICAL  , 3680, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12411, POLARIZATION_VERTICAL  ,11110, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12531, POLARIZATION_VERTICAL  ,26667, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12611, POLARIZATION_VERTICAL  ,26667, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12691, POLARIZATION_VERTICAL  ,26667, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12704, POLARIZATION_HORIZONTAL, 3700, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3580, POLARIZATION_HORIZONTAL,28000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3620, POLARIZATION_HORIZONTAL,28000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3776, POLARIZATION_HORIZONTAL, 4285, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3806, POLARIZATION_HORIZONTAL, 4000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4005, POLARIZATION_HORIZONTAL, 6000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4015, POLARIZATION_HORIZONTAL, 6000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4075, POLARIZATION_HORIZONTAL, 6000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4084, POLARIZATION_HORIZONTAL, 6000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4092, POLARIZATION_HORIZONTAL, 3570, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4097, POLARIZATION_HORIZONTAL, 3125, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EXPRESS140_XE[] = { // Express AM3, *** TO BE CHECKED!! ****
{SYS_DVBS ,10961, POLARIZATION_HORIZONTAL, 7733, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10981, POLARIZATION_VERTICAL  ,29800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11104, POLARIZATION_VERTICAL  , 5787, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3577, POLARIZATION_VERTICAL  , 4285, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3584, POLARIZATION_VERTICAL  , 3000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3589, POLARIZATION_VERTICAL  , 4340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3609, POLARIZATION_VERTICAL  , 4340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3627, POLARIZATION_VERTICAL  , 4340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3632, POLARIZATION_VERTICAL  , 4340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3675, POLARIZATION_VERTICAL  ,33483, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3874, POLARIZATION_VERTICAL  , 3200, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4180, POLARIZATION_VERTICAL  , 4340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4184, POLARIZATION_VERTICAL  , 4340, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder OPTUS_152_0E[] = { // Optus D2, 2011-09-09
{SYS_DVBS ,12394, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12407, POLARIZATION_VERTICAL  ,30000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12425, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12519, POLARIZATION_VERTICAL  ,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12546, POLARIZATION_VERTICAL  ,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12581, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12608, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12644, POLARIZATION_VERTICAL  ,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12644, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12671, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12706, POLARIZATION_VERTICAL  ,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12734, POLARIZATION_VERTICAL  ,22500, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder OPTUS_156_0E[] = { // Optus C1/D3, 2011-09-09
{SYS_DVBS ,12305, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12358, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12369, POLARIZATION_VERTICAL  ,30000, FEC_3_5,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12398, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12407, POLARIZATION_VERTICAL  ,30000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12438, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12447, POLARIZATION_VERTICAL  ,30000, FEC_3_5,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12478, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12487, POLARIZATION_VERTICAL  ,30000, FEC_3_5,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12518, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12527, POLARIZATION_VERTICAL  ,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12558, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12567, POLARIZATION_VERTICAL  ,30000, FEC_3_5,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12598, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12607, POLARIZATION_VERTICAL  ,30000, FEC_3_5,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12638, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12647, POLARIZATION_VERTICAL  ,30000, FEC_3_5,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12689, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12728, POLARIZATION_VERTICAL  ,24450, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11720, POLARIZATION_HORIZONTAL,29455, FEC_3_5,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,11762, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11886, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11928, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11962, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12011, POLARIZATION_HORIZONTAL,29455, FEC_3_5,  ROLLOFF_35,PSK_8},
{SYS_DVBS2,12052, POLARIZATION_HORIZONTAL,29455, FEC_3_5,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12052, POLARIZATION_VERTICAL  ,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12094, POLARIZATION_VERTICAL  ,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12136, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12136, POLARIZATION_VERTICAL  ,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12177, POLARIZATION_HORIZONTAL,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12177, POLARIZATION_VERTICAL  ,27800, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder OPTUS_160_0E[] = { // Optus D1, 2011-08-09
{SYS_DVBS2,12331, POLARIZATION_HORIZONTAL,22500, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS2,12358, POLARIZATION_HORIZONTAL,22500, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12391, POLARIZATION_HORIZONTAL,12600, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12394, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12398, POLARIZATION_VERTICAL  ,11909, FEC_2_3,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12407, POLARIZATION_HORIZONTAL,12600, FEC_5_6,  ROLLOFF_35, QPSK}, 
{SYS_DVBS ,12421, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK}, 
{SYS_DVBS ,12424, POLARIZATION_HORIZONTAL,14294, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12451, POLARIZATION_HORIZONTAL,12600, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12456, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12469, POLARIZATION_HORIZONTAL,12600, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12483, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12487, POLARIZATION_HORIZONTAL,12600, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12514, POLARIZATION_HORIZONTAL,14294, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12519, POLARIZATION_VERTICAL  ,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12519, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12532, POLARIZATION_HORIZONTAL,14294, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12546, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12550, POLARIZATION_HORIZONTAL,14294, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12577, POLARIZATION_HORIZONTAL,14294, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12581, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12595, POLARIZATION_HORIZONTAL,14294, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12608, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12613, POLARIZATION_HORIZONTAL,14294, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12644, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12648, POLARIZATION_VERTICAL  ,12600, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12658, POLARIZATION_HORIZONTAL,12600, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12671, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12707, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12734, POLARIZATION_HORIZONTAL,22500, FEC_3_4,  ROLLOFF_35, QPSK}};
 
static const struct __sat_transponder INTELSAT_8_166_0E[] = { // Intelsat 8 KU Band only, 2011-09-09
{SYS_DVBS ,12286, POLARIZATION_HORIZONTAL,28800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12459, POLARIZATION_HORIZONTAL, 2083, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12462, POLARIZATION_HORIZONTAL, 2222, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12491, POLARIZATION_VERTICAL  , 4400, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12502, POLARIZATION_VERTICAL  , 3074, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12557, POLARIZATION_HORIZONTAL,13845, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12575, POLARIZATION_HORIZONTAL,13845, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12596, POLARIZATION_HORIZONTAL, 2776, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12599, POLARIZATION_HORIZONTAL, 4166, FEC_3_4,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12646, POLARIZATION_HORIZONTAL,28066, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12686, POLARIZATION_HORIZONTAL,28124, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12726, POLARIZATION_HORIZONTAL,28066, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12596, POLARIZATION_HORIZONTAL, 2776, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder THOR00_8W[] = { // Thor 3/5 & Intelsat 10-02, 2008-07-10
{SYS_DVBS ,11093, POLARIZATION_VERTICAL      ,19191, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11166, POLARIZATION_VERTICAL      , 1450, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11182, POLARIZATION_VERTICAL      , 3100, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11190, POLARIZATION_VERTICAL      , 2142, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11216, POLARIZATION_VERTICAL      ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11229, POLARIZATION_HORIZONTAL    ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11247, POLARIZATION_VERTICAL      ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11261, POLARIZATION_HORIZONTAL    ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11278, POLARIZATION_VERTICAL      ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11293, POLARIZATION_HORIZONTAL    ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11309, POLARIZATION_VERTICAL      ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11325, POLARIZATION_HORIZONTAL    ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11341, POLARIZATION_VERTICAL      ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11357, POLARIZATION_HORIZONTAL    ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11372, POLARIZATION_VERTICAL      ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11389, POLARIZATION_HORIZONTAL    ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11403, POLARIZATION_VERTICAL      ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11421, POLARIZATION_HORIZONTAL    ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11434, POLARIZATION_VERTICAL      ,24500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11502, POLARIZATION_VERTICAL      , 3200, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11727, POLARIZATION_VERTICAL      ,28000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11747, POLARIZATION_HORIZONTAL    ,28000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11785, POLARIZATION_HORIZONTAL    ,28000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11823, POLARIZATION_HORIZONTAL    ,28000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11938, POLARIZATION_HORIZONTAL    ,25000, FEC_3_4,  ROLLOFF_35,PSK_8},
{SYS_DVBS2,12015, POLARIZATION_HORIZONTAL    ,30000, FEC_3_4,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12054, POLARIZATION_HORIZONTAL    ,28000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12128, POLARIZATION_HORIZONTAL    ,30000, FEC_3_4,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12149, POLARIZATION_VERTICAL      ,28000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12169, POLARIZATION_HORIZONTAL    ,28000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12188, POLARIZATION_VERTICAL      ,25000, FEC_3_4,  ROLLOFF_35,PSK_8},
{SYS_DVBS ,12226, POLARIZATION_VERTICAL      ,28000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12246, POLARIZATION_HORIZONTAL    ,28000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12303, POLARIZATION_VERTICAL      ,28000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12322, POLARIZATION_HORIZONTAL    ,27800, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12341, POLARIZATION_VERTICAL      ,28000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12361, POLARIZATION_HORIZONTAL    ,28000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12380, POLARIZATION_VERTICAL      ,28000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12399, POLARIZATION_HORIZONTAL    ,28000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12418, POLARIZATION_VERTICAL      ,28000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12438, POLARIZATION_HORIZONTAL    ,28000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12456, POLARIZATION_VERTICAL      ,28000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12476, POLARIZATION_HORIZONTAL    ,27800, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12527, POLARIZATION_HORIZONTAL    ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12563, POLARIZATION_HORIZONTAL    ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12563, POLARIZATION_VERTICAL      ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12607, POLARIZATION_HORIZONTAL    ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12607, POLARIZATION_VERTICAL      ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12643, POLARIZATION_HORIZONTAL    ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12643, POLARIZATION_VERTICAL      ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12687, POLARIZATION_HORIZONTAL    ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12687, POLARIZATION_VERTICAL      ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12718, POLARIZATION_VERTICAL      ,18400, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12723, POLARIZATION_HORIZONTAL    ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12735, POLARIZATION_VERTICAL      , 8800, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3977, POLARIZATION_CIRCULAR_LEFT ,17777, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3985, POLARIZATION_CIRCULAR_RIGHT, 4000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4025, POLARIZATION_CIRCULAR_RIGHT, 7324, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4175, POLARIZATION_CIRCULAR_RIGHT,28000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4180, POLARIZATION_CIRCULAR_LEFT ,21050, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder AMOS04_0W[] = { // Amos 1/2/3, 2011-06-10
{SYS_DVBS ,10722, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,10723, POLARIZATION_VERTICAL  ,30000, FEC_2_3,  ROLLOFF_35, PSK_8},
{SYS_DVBS ,10759, POLARIZATION_HORIZONTAL,30000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,10759, POLARIZATION_VERTICAL  ,30000, FEC_2_3,  ROLLOFF_35, PSK_8},
{SYS_DVBS ,10806, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS2,10806, POLARIZATION_VERTICAL  ,30000, FEC_2_3,  ROLLOFF_35, PSK_8},
{SYS_DVBS ,10842, POLARIZATION_HORIZONTAL,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS2,10842, POLARIZATION_VERTICAL  ,30000, FEC_2_3,  ROLLOFF_35, PSK_8},
{SYS_DVBS2,10880, POLARIZATION_VERTICAL  ,14166, FEC_2_3,  ROLLOFF_35, PSK_8},
{SYS_DVBS ,10889, POLARIZATION_HORIZONTAL,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10924, POLARIZATION_HORIZONTAL,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11122, POLARIZATION_HORIZONTAL, 2083, FEC_2_3,  ROLLOFF_35, PSK_8},
{SYS_DVBS2,11163, POLARIZATION_HORIZONTAL,12500, FEC_5_6,  ROLLOFF_35, PSK_8},
{SYS_DVBS ,11192, POLARIZATION_HORIZONTAL, 3333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11224, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11258, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11289, POLARIZATION_HORIZONTAL, 1852, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11304, POLARIZATION_HORIZONTAL,19540, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11319, POLARIZATION_HORIZONTAL, 2750, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11323, POLARIZATION_HORIZONTAL, 3350, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11329, POLARIZATION_HORIZONTAL, 5000, FEC_3_4,  ROLLOFF_35, PSK_8},
{SYS_DVBS ,11333, POLARIZATION_HORIZONTAL, 3500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11343, POLARIZATION_HORIZONTAL, 3703, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11347, POLARIZATION_HORIZONTAL, 3350, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11351, POLARIZATION_HORIZONTAL, 3350, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11359, POLARIZATION_HORIZONTAL, 3350, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11389, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11411, POLARIZATION_HORIZONTAL, 7925, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11423, POLARIZATION_HORIZONTAL, 2894, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11428, POLARIZATION_HORIZONTAL, 5926, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11435, POLARIZATION_HORIZONTAL, 2590, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11441, POLARIZATION_HORIZONTAL, 3350, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11543, POLARIZATION_HORIZONTAL, 3700, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11554, POLARIZATION_HORIZONTAL, 7500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11562, POLARIZATION_HORIZONTAL, 6666, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11572, POLARIZATION_HORIZONTAL, 8887, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11600, POLARIZATION_HORIZONTAL,10000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11610, POLARIZATION_HORIZONTAL, 3600, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11637, POLARIZATION_HORIZONTAL, 7926, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11647, POLARIZATION_HORIZONTAL, 9167, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11654, POLARIZATION_HORIZONTAL, 2000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11671, POLARIZATION_HORIZONTAL,11850, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11679, POLARIZATION_HORIZONTAL, 2315, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11690, POLARIZATION_HORIZONTAL, 7200, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder ATLANTICBIRD05_XW[] = { // Atlantic Bird 3, 2008-07-10
{SYS_DVBS ,10975, POLARIZATION_VERTICAL      , 2894, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10979, POLARIZATION_VERTICAL      , 1953, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11064, POLARIZATION_HORIZONTAL    ,16277, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11065, POLARIZATION_VERTICAL      , 2604, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11456, POLARIZATION_VERTICAL      , 6666, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11512, POLARIZATION_VERTICAL      ,29950, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11554, POLARIZATION_VERTICAL      ,29950, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11591, POLARIZATION_VERTICAL      ,20000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11607, POLARIZATION_VERTICAL      , 6944, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11677, POLARIZATION_VERTICAL      ,27000, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12543, POLARIZATION_HORIZONTAL    ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12615, POLARIZATION_HORIZONTAL    , 8789, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12636, POLARIZATION_HORIZONTAL    , 2083, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12641, POLARIZATION_HORIZONTAL    , 2315, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12672, POLARIZATION_HORIZONTAL    ,18248, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12711, POLARIZATION_HORIZONTAL    ,30000, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3633, POLARIZATION_CIRCULAR_RIGHT, 5696, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3641, POLARIZATION_CIRCULAR_RIGHT, 2480, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3646, POLARIZATION_CIRCULAR_RIGHT, 2170, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3656, POLARIZATION_CIRCULAR_RIGHT, 2893, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3661, POLARIZATION_CIRCULAR_RIGHT, 2170, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3712, POLARIZATION_CIRCULAR_LEFT , 2785, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3727, POLARIZATION_CIRCULAR_RIGHT,29950, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4023, POLARIZATION_CIRCULAR_RIGHT, 2018, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4123, POLARIZATION_CIRCULAR_RIGHT, 8319, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4157, POLARIZATION_CIRCULAR_LEFT , 8011, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4158, POLARIZATION_CIRCULAR_RIGHT,20330, FEC_2_3,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder ATLANTICBIRD07_0W[] = { // Nilesat 101/102 & Atlantic Bird 4A, 2011-06-10
{SYS_DVBS ,10719, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10723, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10758, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10775, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10796, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10815, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,10834, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, PSK_8},
{SYS_DVBS ,10853, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10873, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10892, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10911, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10930, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10949, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10971, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10992, POLARIZATION_VERTICAL  ,27485, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11034, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11075, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11219, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11240, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11258, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11278, POLARIZATION_VERTICAL  ,27500, FEC_2_3,  ROLLOFF_35, PSK_8},
{SYS_DVBS ,11317, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11334, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11355, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11373, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11393, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11411, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11432, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS2,11449, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11470, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11488, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11508, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11585, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11727, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11747, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11766, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11785, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11804, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11823, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11843, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11862, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11881, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11900, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11919, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11938, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11958, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11977, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11996, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12015, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12034, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12054, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12073, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12092, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12111, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12130, POLARIZATION_VERTICAL  ,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12149, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12168, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12188, POLARIZATION_HORIZONTAL,27500, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12207, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12226, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12245, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS2,12265, POLARIZATION_HORIZONTAL,27500, FEC_2_3,  ROLLOFF_35, PSK_8},
{SYS_DVBS ,12284, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12303, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12341, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12360, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12380, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12399, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12418, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12437, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12456, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12476, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder ATLANTICBIRD08_0W[] = { // Atlantic Bird 2, 2008-07-10
{SYS_DVBS ,10972, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,10972, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11011, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11011, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11057, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11093, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11387, POLARIZATION_HORIZONTAL,24740, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11428, POLARIZATION_HORIZONTAL,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11554, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12539, POLARIZATION_HORIZONTAL, 3038, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12566, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12649, POLARIZATION_VERTICAL  ,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12748, POLARIZATION_HORIZONTAL, 1097, FEC_2_3,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EXPRESS11_XW[] = { // Express A3, 2008-07-10
{SYS_DVBS ,11516, POLARIZATION_VERTICAL      ,  7780, FEC_5_6,  ROLLOFF_35, QPSK}, // 11.0W 
{SYS_DVBS ,11524, POLARIZATION_VERTICAL      ,  2712, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3675, POLARIZATION_CIRCULAR_RIGHT, 29623, FEC_5_6,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder ATLANTICBIRD12_5W[] = { // Atlantic Bird 1, 2008-07-11
{SYS_DVBS ,11099, POLARIZATION_HORIZONTAL, 2000, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11132, POLARIZATION_HORIZONTAL, 3255, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11136, POLARIZATION_VERTICAL  , 3700, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11177, POLARIZATION_HORIZONTAL, 9404, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11177, POLARIZATION_HORIZONTAL, 7596, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11185, POLARIZATION_VERTICAL  ,13657, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11188, POLARIZATION_HORIZONTAL, 5722, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11331, POLARIZATION_HORIZONTAL, 6000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11337, POLARIZATION_HORIZONTAL, 1923, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11340, POLARIZATION_HORIZONTAL, 2279, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11355, POLARIZATION_HORIZONTAL,11781, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11387, POLARIZATION_HORIZONTAL,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12515, POLARIZATION_HORIZONTAL,17455, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12529, POLARIZATION_VERTICAL  , 1550, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12545, POLARIZATION_HORIZONTAL,17455, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12578, POLARIZATION_VERTICAL  , 5860, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12588, POLARIZATION_HORIZONTAL, 2250, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12591, POLARIZATION_HORIZONTAL, 1628, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12594, POLARIZATION_HORIZONTAL, 2170, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12597, POLARIZATION_HORIZONTAL, 1910, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12632, POLARIZATION_VERTICAL  , 2141, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12637, POLARIZATION_VERTICAL  , 4285, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12720, POLARIZATION_VERTICAL  , 1808, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12723, POLARIZATION_HORIZONTAL, 5787, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12730, POLARIZATION_VERTICAL  , 3254, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12733, POLARIZATION_HORIZONTAL, 5787, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12743, POLARIZATION_VERTICAL  , 3214, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder EXPRESS14_0W[] = { // Express A4, 2008-07-11 ,
{SYS_DVBS ,11514, POLARIZATION_VERTICAL  ,2960, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11524, POLARIZATION_VERTICAL  ,2970, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11528, POLARIZATION_VERTICAL  ,2960, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11532, POLARIZATION_VERTICAL  ,3003, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder TELSTAR15_0W[] = { // Telstar 12, 2008-07-11
{SYS_DVBS ,11022, POLARIZATION_VERTICAL  , 2222, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11062, POLARIZATION_HORIZONTAL,19280, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11124, POLARIZATION_HORIZONTAL,18386, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11150, POLARIZATION_HORIZONTAL,18386, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11150, POLARIZATION_VERTICAL  ,19275, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11566, POLARIZATION_HORIZONTAL, 5625, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11678, POLARIZATION_VERTICAL  , 2200, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11686, POLARIZATION_HORIZONTAL, 2965, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11691, POLARIZATION_HORIZONTAL, 3255, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12524, POLARIZATION_VERTICAL  ,26470, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12545, POLARIZATION_HORIZONTAL,11900, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12589, POLARIZATION_VERTICAL  , 4503, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12608, POLARIZATION_HORIZONTAL,19279, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12615, POLARIZATION_VERTICAL  ,11938, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12645, POLARIZATION_HORIZONTAL, 3255, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder INTELSAT18_XW[] = { // Intelsat 901, 2008-07-11
{SYS_DVBS ,10975, POLARIZATION_VERTICAL  ,14571, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11057, POLARIZATION_HORIZONTAL, 1950, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11156, POLARIZATION_HORIZONTAL, 1600, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11678, POLARIZATION_HORIZONTAL,28570, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3717, POLARIZATION_HORIZONTAL, 2480, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3792, POLARIZATION_VERTICAL  , 4340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3798, POLARIZATION_VERTICAL  , 4340, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3803, POLARIZATION_VERTICAL  , 2894, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3831, POLARIZATION_HORIZONTAL,13021, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3924, POLARIZATION_VERTICAL   ,2893, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder NSS22_XW[] = { // NSS 7, 2008-07-08
{SYS_DVBS ,11012, POLARIZATION_HORIZONTAL    , 5632, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS ,11049, POLARIZATION_HORIZONTAL    , 6111, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11099, POLARIZATION_HORIZONTAL    , 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11153, POLARIZATION_HORIZONTAL    ,13333, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11488, POLARIZATION_HORIZONTAL    , 2170, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11563, POLARIZATION_HORIZONTAL    , 6111, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11588, POLARIZATION_HORIZONTAL    , 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11605, POLARIZATION_HORIZONTAL    , 4000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11612, POLARIZATION_HORIZONTAL    , 1500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11614, POLARIZATION_HORIZONTAL    , 1612, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11616, POLARIZATION_HORIZONTAL    , 1257, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11619, POLARIZATION_HORIZONTAL    , 2000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11622, POLARIZATION_HORIZONTAL    , 2000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11627, POLARIZATION_HORIZONTAL    , 2500, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11630, POLARIZATION_HORIZONTAL    , 3000, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11634, POLARIZATION_HORIZONTAL    , 1028, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11636, POLARIZATION_HORIZONTAL    , 1695, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11648, POLARIZATION_HORIZONTAL    , 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11657, POLARIZATION_HORIZONTAL    , 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11666, POLARIZATION_HORIZONTAL    , 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11675, POLARIZATION_HORIZONTAL    , 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11684, POLARIZATION_HORIZONTAL    , 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11693, POLARIZATION_HORIZONTAL    , 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12532, POLARIZATION_HORIZONTAL    ,40000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12601, POLARIZATION_HORIZONTAL    ,40000, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12715, POLARIZATION_HORIZONTAL    , 6111, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12735, POLARIZATION_HORIZONTAL    ,16640, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3650, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3725, POLARIZATION_CIRCULAR_LEFT , 1462, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3931, POLARIZATION_CIRCULAR_LEFT ,25000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3981, POLARIZATION_CIRCULAR_LEFT , 1379, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4055, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4115, POLARIZATION_HORIZONTAL    , 3680, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4126, POLARIZATION_CIRCULAR_LEFT , 3680, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4148, POLARIZATION_CIRCULAR_RIGHT, 6111, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4157, POLARIZATION_CIRCULAR_RIGHT, 6111, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4179, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_7_8,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder INTELSAT24_XW[] = { // Intelsat 905, 2008-06-21
{SYS_DVBS ,11028, POLARIZATION_VERTICAL      , 4000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11521, POLARIZATION_VERTICAL      , 3333, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11640, POLARIZATION_VERTICAL      ,21100, FEC_9_10, ROLLOFF_35, QPSK},
{SYS_DVBS ,11675, POLARIZATION_CIRCULAR_RIGHT,27500, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3729, POLARIZATION_CIRCULAR_RIGHT,13333, FEC_7_8,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4193, POLARIZATION_CIRCULAR_RIGHT, 5179, FEC_1_2,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder INTELSAT27_XW[] = { // Intelsat 907, 2008-06-21
{SYS_DVBS ,11516, POLARIZATION_VERTICAL      , 5632, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11665, POLARIZATION_VERTICAL      ,13020, FEC_5_6,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3715, POLARIZATION_CIRCULAR_RIGHT, 8448, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3732, POLARIZATION_CIRCULAR_RIGHT,14000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3762, POLARIZATION_CIRCULAR_RIGHT,30491, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3849, POLARIZATION_CIRCULAR_RIGHT,10850, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3872, POLARIZATION_CIRCULAR_RIGHT, 5000, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3898, POLARIZATION_CIRCULAR_RIGHT, 2892, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 3936, POLARIZATION_CIRCULAR_RIGHT, 4550, FEC_1_2,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4050, POLARIZATION_CIRCULAR_RIGHT, 7000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS , 4065, POLARIZATION_CIRCULAR_LEFT , 4100, FEC_3_4,  ROLLOFF_35, QPSK}};

static const struct __sat_transponder TELSTAR97_0W[] = { // Telstar 5 / IA5 / Galaxy 19, 2010-02-28
{SYS_DVBS ,11789, POLARIZATION_VERTICAL  ,    28125, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11836, POLARIZATION_VERTICAL  ,    20765, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11867, POLARIZATION_VERTICAL  ,    22000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11874, POLARIZATION_HORIZONTAL,    22000, FEC_2_3,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11894, POLARIZATION_HORIZONTAL,     4880, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11898, POLARIZATION_VERTICAL  ,    22000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11929, POLARIZATION_VERTICAL  ,    22000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11936, POLARIZATION_HORIZONTAL,    22000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,11991, POLARIZATION_VERTICAL  ,    22000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12022, POLARIZATION_VERTICAL  ,    22000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12053, POLARIZATION_VERTICAL  ,    22000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12060, POLARIZATION_HORIZONTAL,    22000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12084, POLARIZATION_VERTICAL  ,    22000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12090, POLARIZATION_HORIZONTAL,    20000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12115, POLARIZATION_VERTICAL  ,    22425, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12122, POLARIZATION_HORIZONTAL,    20000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12146, POLARIZATION_VERTICAL  ,    22000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12152, POLARIZATION_HORIZONTAL,    20000, FEC_3_4,  ROLLOFF_35, QPSK},
{SYS_DVBS ,12177, POLARIZATION_VERTICAL  ,    23000, FEC_3_4,  ROLLOFF_35, QPSK}};


/******************************************************************************
 * position constants, east/west flag as separator, 22.0 west => S22W0
 * .X if two or more sats on nearly same position.
 * satellites sorted by position
 *****************************************************************************/

struct cSat sat_list[] = {
/** pos *** id *** long satellite name ***************************** items ******************* item_count ****************************** we_flag * orbit * rotor * vdrid */
{  "S4E8",  S4E8, "4.8 east Sirius"                             , SIRIUS04_8E,          SAT_TRANSPONDER_COUNT(SIRIUS04_8E),             EAST_FLAG,   0x48, -1, "S5E"    },
{  "S7E0",  S7E0, "7.0 east Eutelsat W3A"                       , EUTELSAT07_0E,        SAT_TRANSPONDER_COUNT(EUTELSAT07_0E),           EAST_FLAG,   0x70, -1, "S7E"    },
{  "S9E0",  S9E0, "9.0 east Eurobird 9"                         , EUROBIRD09_0E,        SAT_TRANSPONDER_COUNT(EUROBIRD09_0E),           EAST_FLAG,   0x90, -1, "S9E"    },
{ "S10E0", S10E0, "10.0 east Eutelsat W1"                       , EUTELSAT10_0E,        SAT_TRANSPONDER_COUNT(EUTELSAT10_0E),           EAST_FLAG,  0x100, -1, "S10E"   },
{ "S13E0", S13E0, "13.0 east Hotbird 6/7A/8"                    , HOTBIRD13E,           SAT_TRANSPONDER_COUNT(HOTBIRD13E),              EAST_FLAG,  0x130, -1, "S13E"   },
{ "S16E0", S16E0, "16.0 east Eutelsat W2"                       , EUTELSAT16_0E,        SAT_TRANSPONDER_COUNT(EUTELSAT16_0E),           EAST_FLAG,  0x160, -1, "S16E"   },
{ "S19E2", S19E2, "19.2 east Astra 1F/1G/1H/1KR/1L"             , ASTRA19E,             SAT_TRANSPONDER_COUNT(ASTRA19E),                EAST_FLAG,  0x192, -1, "S19.2E" },
{ "S21E6", S21E6, "21.6 east Eutelsat W6"                       , EUTELSAT21_6E,        SAT_TRANSPONDER_COUNT(EUTELSAT21_6E),           EAST_FLAG,  0x216, -1, "S21.6E" },
{ "S23E5", S23E5, "23.5 east Astra 1E/3A"                       , ASTRA23_5E,           SAT_TRANSPONDER_COUNT(ASTRA23_5E),              EAST_FLAG,  0x235, -1, "S23.5E" },
{ "S25E5", S25E5, "25.5 east Eurobird 2"                        , EUROBIRD25_5E,        SAT_TRANSPONDER_COUNT(EUROBIRD25_5E),           EAST_FLAG,  0x255, -1, "S25.5E" },
{ "S26EX", S26EX, "26.X east Badr C/3/4/6"                      , BADR26_XE,            SAT_TRANSPONDER_COUNT(BADR26_XE),               EAST_FLAG,  0x260, -1, "S26E"   },
{ "S28E2", S28E2, "28.2 east Astra 2A/2B/2C/2D"                 , ASTRA28_2E,           SAT_TRANSPONDER_COUNT(ASTRA28_2E),              EAST_FLAG,  0x282, -1, "S28.2E" },
{ "S28E5", S28E5, "28.5 east EuroBird 1"                        , EUROBIRD28_5E,        SAT_TRANSPONDER_COUNT(EUROBIRD28_5E),           EAST_FLAG,  0x285, -1, "S28.5E" },
{ "S31E5", S31E5, "31.5 east Astra 5A/1D"                       , ASTRA31_5E,           SAT_TRANSPONDER_COUNT(ASTRA31_5E),              EAST_FLAG,  0x315, -1, "S31.5E" },
{ "S32E9", S32E9, "32.9 east Intelsat 802"                      , INTELSAT32_9E,        SAT_TRANSPONDER_COUNT(INTELSAT32_9E),           EAST_FLAG,  0x329, -1, "S33E"   },
{ "S33E0", S33E0, "33.0 east Eurobird 3"                        , EUROBIRD33_0E,        SAT_TRANSPONDER_COUNT(EUROBIRD33_0E),           EAST_FLAG,  0x330, -1, "S33E"   },
{ "S35E9", S35E9, "35.9 east Eutelsat W4"                       , EUTELSAT35_9E,        SAT_TRANSPONDER_COUNT(EUTELSAT35_9E),           EAST_FLAG,  0x359, -1, "S36E"   },
{ "S36E0", S36E0, "36.0 east Eutelsat Sesat"                    , EUTELSAT36_0E,        SAT_TRANSPONDER_COUNT(EUTELSAT36_0E),           EAST_FLAG,  0x360, -1, "S36E"   },
{ "S38E0", S38E0, "38.0 east Paksat 1"                          , PAKSAT38_0E,          SAT_TRANSPONDER_COUNT(PAKSAT38_0E),             EAST_FLAG,  0x380, -1, "S38E"   },
{ "S39E0", S39E0, "39.0 east Hellas Sat 2"                      , HELLAS39_0E,          SAT_TRANSPONDER_COUNT(HELLAS39_0E),             EAST_FLAG,  0x390, -1, "S39E"   },
{ "S40EX", S40EX, "40.X east Express AM1"                       , EXPRESS40_XE,         SAT_TRANSPONDER_COUNT(EXPRESS40_XE),            EAST_FLAG,  0x400, -1, "S40E"   },
{ "S42E0", S42E0, "42.0 east Turksat 2A/3A"                     , TURKSAT42_0E,         SAT_TRANSPONDER_COUNT(TURKSAT42_0E),            EAST_FLAG,  0x420, -1, "S42E"   },
{ "S45E0", S45E0, "45.0 east Intelsat 12"                       , INTELSAT45_0E,        SAT_TRANSPONDER_COUNT(INTELSAT45_0E),           EAST_FLAG,  0x450, -1, "S45E"   },
{ "S49E0", S49E0, "49.0 east Yamal 202"                         , YAMAL49_0E,           SAT_TRANSPONDER_COUNT(YAMAL49_0E),              EAST_FLAG,  0x490, -1, "S49E"   },
{ "S53E0", S53E0, "53.0 east Express AM22"                      , EXPRESS53_0E,         SAT_TRANSPONDER_COUNT(EXPRESS53_0E),            EAST_FLAG,  0x530, -1, "S53E"   },
{ "S57E0", S57E0, "57.0 east Bonum 1"                           , BONUM56_0E,           SAT_TRANSPONDER_COUNT(BONUM56_0E),              EAST_FLAG,  0x570, -1, "S57E"   },
{ "S57EX", S57EX, "57.X east NSS 703"                           , NSS57_XE,             SAT_TRANSPONDER_COUNT(NSS57_XE),                EAST_FLAG,  0x570, -1, "S57E"   },
{ "S60EX", S60EX, "60.X east Intelsat 904"                      , INTELSAT60_XE,        SAT_TRANSPONDER_COUNT(INTELSAT60_XE),           EAST_FLAG,  0x600, -1, "S60E"   },
{ "S62EX", S62EX, "62.X east Intelsat 902"                      , INTELSAT62_XE,        SAT_TRANSPONDER_COUNT(INTELSAT62_XE),           EAST_FLAG,  0x620, -1, "S62E"   },
{ "S64E2", S64E2, "64.2 east Intelsat 906"                      , INTELSAT64_2E,        SAT_TRANSPONDER_COUNT(INTELSAT64_2E),           EAST_FLAG,  0x642, -1, "S64E"   },
{ "S68EX", S68EX, "68.X east Intelsat 7/10"                     , INTELSAT68_XE,        SAT_TRANSPONDER_COUNT(INTELSAT68_XE),           EAST_FLAG,  0x680, -1, "S68.5E" },
{ "S70E5", S70E5, "70.5 east Eutelsat W5"                       , EUTELSAT70_5E,        SAT_TRANSPONDER_COUNT(EUTELSAT70_5E),           EAST_FLAG,  0x705, -1, "S70.5E" },
{ "S72EX", S72EX, "72.X east Intelsat 4"                        , INTELSAT72_XE,        SAT_TRANSPONDER_COUNT(INTELSAT72_XE),           EAST_FLAG,  0x720, -1, "S72E"   },
{ "S75EX", S75EX, "75.X east ABS 1"                             , ABS75_XE,             SAT_TRANSPONDER_COUNT(ABS75_XE),                EAST_FLAG,  0x750, -1, "S75E"   },
{ "S76EX", S76EX, "76.X east Telstar 10"                        , TELSTAR76_XE,         SAT_TRANSPONDER_COUNT(TELSTAR76_XE),            EAST_FLAG,  0x760, -1, "S76.5E" },
{ "S78E5", S78E5, "78.5 east Thaicom 2/5"                       , THAICOM78_5E,         SAT_TRANSPONDER_COUNT(THAICOM78_5E),            EAST_FLAG,  0x785, -1, "S78.5E" },
{ "S80EX", S80EX, "80.X east Express AM2"                       , EXPRESS80_XE,         SAT_TRANSPONDER_COUNT(EXPRESS80_XE),            EAST_FLAG,  0x800, -1, "S80E"   },
{ "S83EX", S83EX, "83.X east Insat 2E/3B/4A"                    , INSAT83_XE,           SAT_TRANSPONDER_COUNT(INSAT83_XE),              EAST_FLAG,  0x830, -1, "S83E"   },
{ "S87E5", S87E5, "87.5 east ChinaStar 1"                       , CHINASTAR87_5E,       SAT_TRANSPONDER_COUNT(CHINASTAR87_5E),          EAST_FLAG,  0x875, -1, "S87.5E" },
{ "S88EX", S88EX, "88.X east ST 1"                              , ST88_XE,              SAT_TRANSPONDER_COUNT(ST88_XE),                 EAST_FLAG,  0x880, -1, "S88E"   },
{ "S90EX", S90EX, "90.X east Yamal 201"                         , YAMAL90_XE,           SAT_TRANSPONDER_COUNT(YAMAL90_XE),              EAST_FLAG,  0x900, -1, "S90E"   },
{ "S91E5", S91E5, "91.5 east Measat 3"                          , MEASAT91_5E,          SAT_TRANSPONDER_COUNT(MEASAT91_5E),             EAST_FLAG,  0x915, -1, "S91.5E" },
{ "S93E5", S93E5, "93.5 east Insat 3A/4B"                       , INSAT93_5E,           SAT_TRANSPONDER_COUNT(INSAT93_5E),              EAST_FLAG,  0x935, -1, "S93.5E" },
{ "S95E0", S95E0, "95.0 east NSS 6"                             , NSS95_0E,             SAT_TRANSPONDER_COUNT(NSS95_0E),                EAST_FLAG,  0x950, -1, "S95E"   },
{ "S96EX", S96EX, "96.X east Express AM33"                      , EXPRESS96_XE,         SAT_TRANSPONDER_COUNT(EXPRESS96_XE),            EAST_FLAG,  0x960, -1, "S96.5E" },
{"S100EX",S100EX,"100.X east AsiaSat 2"                         , ASIASAT100_XE,        SAT_TRANSPONDER_COUNT(ASIASAT100_XE),           EAST_FLAG, 0x1000, -1, "S100.5E"},
{"S105EX",S105EX,"105.X east AsiaSat 3S"                        , ASIASAT105_XE,        SAT_TRANSPONDER_COUNT(ASIASAT105_XE),           EAST_FLAG, 0x1050, -1, "S105.5E"},
{"S108EX",S108EX,"108.X east Telkom 1 & NSS 11"                 , NSS108_XE,            SAT_TRANSPONDER_COUNT(NSS108_XE),               EAST_FLAG, 0x1080, -1, "S108E"  },
{"S140EX",S140EX,"140.X east Express AM3"                       , EXPRESS140_XE,        SAT_TRANSPONDER_COUNT(EXPRESS140_XE),           EAST_FLAG, 0x1400, -1, "S140E"  },
{"S152E0",S152E0,"152.0 east Optus D2"                          , OPTUS_152_0E,         SAT_TRANSPONDER_COUNT(OPTUS_152_0E),            EAST_FLAG, 0x1520, -1, "S152E"  },
{"S156E0",S156E0,"156.0 east Optus C1/D3"                       , OPTUS_156_0E,         SAT_TRANSPONDER_COUNT(OPTUS_156_0E),            EAST_FLAG, 0x1560, -1, "S156E"  },
{"S160E0",S160E0,"160.0 east Optus D1"                          , OPTUS_160_0E,         SAT_TRANSPONDER_COUNT(OPTUS_160_0E),            EAST_FLAG, 0x1600, -1, "S160E"  },
{"S166E0",S166E0,"166.0 east Intelsat 8"                        , INTELSAT_8_166_0E,    SAT_TRANSPONDER_COUNT(INTELSAT_8_166_0E),       EAST_FLAG, 0x1660, -1, "S166E"  },
{  "S0W8",  S0W8,  "0.8 west Thor 3/5 & Intelsat 10-02"         , THOR00_8W,            SAT_TRANSPONDER_COUNT(THOR00_8W),               WEST_FLAG,    0x8, -1, "S1W"    },
{  "S4W0",  S4W0,  "4.0 west Amos 1/2/3"                        , AMOS04_0W,            SAT_TRANSPONDER_COUNT(AMOS04_0W),               WEST_FLAG,   0x40, -1, "S4W"    },
{  "S5WX",  S5WX,  "5.X west Atlantic Bird 3"                   , ATLANTICBIRD05_XW,    SAT_TRANSPONDER_COUNT(ATLANTICBIRD05_XW),       WEST_FLAG,   0x50, -1, "S5W"    },
{  "S7W0",  S7W0,  "7.0 west Nilesat 101/102 & Atlantic Bird 4" , ATLANTICBIRD07_0W,    SAT_TRANSPONDER_COUNT(ATLANTICBIRD07_0W),       WEST_FLAG,  0x700, -1, "S7W"    },
{  "S8W0",  S8W0,  "8.0 west Atlantic Bird 2"                   , ATLANTICBIRD08_0W,    SAT_TRANSPONDER_COUNT(ATLANTICBIRD08_0W),       WEST_FLAG,  0x800, -1, "S8W"    },
{ "S11WX", S11WX, "11.X west Express A3"                        , EXPRESS11_XW,         SAT_TRANSPONDER_COUNT(EXPRESS11_XW),            WEST_FLAG,  0x110, -1, "S11W"   },
{ "S12W5", S12W5, "12.5 west Atlantic Bird 1"                   , ATLANTICBIRD12_5W,    SAT_TRANSPONDER_COUNT(ATLANTICBIRD12_5W),       WEST_FLAG,  0x125, -1, "S12.5W" },
{ "S14W0", S14W0, "14.0 west Express A4"                        , EXPRESS14_0W,         SAT_TRANSPONDER_COUNT(EXPRESS14_0W),            WEST_FLAG,  0x140, -1, "S14W"   },
{ "S15W0", S15W0, "15.0 west Telstar 12"                        , TELSTAR15_0W,         SAT_TRANSPONDER_COUNT(TELSTAR15_0W),            WEST_FLAG,  0x150, -1, "S15W"   },
{ "S18WX", S18WX, "18.X west Intelsat 901"                      , INTELSAT18_XW,        SAT_TRANSPONDER_COUNT(INTELSAT18_XW),           WEST_FLAG,  0x180, -1, "S18W"   },
{ "S22WX", S22WX, "22.X west NSS 7"                             , NSS22_XW,             SAT_TRANSPONDER_COUNT(NSS22_XW),                WEST_FLAG,  0x220, -1, "S22W"   },
{ "S24WX", S24WX, "24.X west Intelsat 905"                      , INTELSAT24_XW,        SAT_TRANSPONDER_COUNT(INTELSAT24_XW),           WEST_FLAG,  0x240, -1, "S24.5W" },
{ "S27WX", S27WX, "27.X west Intelsat 907"                      , INTELSAT27_XW,        SAT_TRANSPONDER_COUNT(INTELSAT27_XW),           WEST_FLAG,  0x270, -1, "S27.5W" },
{ "S30W0", S30W0, "30.0 west Hispasat 1C/1D"                    , HISPASAT30_0W,        SAT_TRANSPONDER_COUNT(HISPASAT30_0W),           WEST_FLAG,  0x300, -1, "S30W"   },
{ "S97W0", S97W0, "97.0 west Telstar 5"                         , TELSTAR97_0W,         SAT_TRANSPONDER_COUNT(TELSTAR97_0W),            WEST_FLAG,  0x970, -1, "S97.0W" }};
/**********************************************************************************************************************************************/


/******************************************************************************
 * convert position constant
 * to index number
 *
 *****************************************************************************/

int txt_to_satellite(const char * id) {
unsigned int i;
for (i = 0; i < SAT_COUNT(sat_list); i++)
   if (! strcasecmp(id,sat_list[i].short_name))
      return sat_list[i].id;
return -1;
}

/******************************************************************************
 * return numbers of satellites defined.
 *
 *
 *****************************************************************************/

int sat_count() {
      return SAT_COUNT(sat_list);
}

/******************************************************************************
 * convert index number
 * to position constant
 *
 *****************************************************************************/

const char * satellite_to_short_name(int idx) {
unsigned int i;
for (i = 0; i < SAT_COUNT(sat_list); i++)
   if (idx == sat_list[i].id)
      return sat_list[i].short_name;
return "??";
}

/******************************************************************************
 * convert index number
 * to satellite name
 *
 *****************************************************************************/

const char * satellite_to_full_name(int idx) {
unsigned int i;
for (i = 0; i < SAT_COUNT(sat_list); i++)
   if (idx == sat_list[i].id)
      return sat_list[i].full_name;
warning("SATELLITE CODE NOT DEFINED. PLEASE RE-CHECK WETHER YOU TYPED CORRECTLY.\n");
usleep(5000000);
return "??";
}

/******************************************************************************
 * return index number
 * from rotor position
 *
 *****************************************************************************/
int rotor_position_to_sat_list_index(int rotor_position) {
unsigned int i;
for (i = 0; i < SAT_COUNT(sat_list); i++)
   if (rotor_position == sat_list[i].rotor_position)
      return i;
return 0;
}

/******************************************************************************
 * print list of
 * all satellites
 *
 *****************************************************************************/

void print_satellites(void) {
unsigned int i;
for (i = 0; i < SAT_COUNT(sat_list); i++)
    info("\t%s\t\t%s\n", sat_list[i].short_name, sat_list[i].full_name);
}

/******************************************************************************
 * get transponder data
 *
 *****************************************************************************/
int get_frontend_param(uint16_t satellite, uint16_t table_index, struct tuning_parameters * param) {
unsigned int i;

for (i = 0; i < SAT_COUNT(sat_list); i++)
    if (satellite == sat_list[i].id) {
        if (table_index >= sat_list[i].item_count)
            return 0; //error
        memset(param, 0, sizeof(struct tuning_parameters));
        param->frequency = sat_list[i].items[table_index].intermediate_frequency;
        param->inversion = INVERSION_AUTO;
        param->u.sat.modulation_system = sat_list[i].items[table_index].modulation_system;
        param->u.sat.polarization      = sat_list[i].items[table_index].polarization;
        param->u.sat.symbol_rate       = sat_list[i].items[table_index].symbol_rate;
        param->u.sat.fec_inner         = sat_list[i].items[table_index].fec_inner;
        param->u.sat.rolloff           = sat_list[i].items[table_index].rolloff;
        param->u.sat.modulation_type   = sat_list[i].items[table_index].modulation_type;    
        return 1;
        }
return 0; // error
}

int choose_satellite(const char * satellite, int * channellist) {
    int retval = 0;
    * channellist = txt_to_satellite(satellite);
    if (* channellist < 0) {
        * channellist = S19E2;
        warning("\n\nSATELLITE CODE IS NOT DEFINED. FALLING BACK TO \"S19E2\"\n\n");
        sleep(10);
        retval = -1;
        }
    info("using settings for %s\n", satellite_to_full_name(* channellist));
    return retval;
}
