/*
 * Copyright (C) 2004, 2005, 2006 Nikolas Zimmermann <zimmermann@kde.org>
 * Copyright (C) 2004, 2005, 2006, 2008 Rob Buis <buis@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#pragma once

#include "SVGPathSegWithContext.h"

namespace WebCore {

class SVGPathSegCurvetoQuadratic : public SVGPathSegWithContext { 
public:
    SVGPathSegCurvetoQuadratic(const SVGPathElement& element, SVGPathSegRole role, float x, float y, float x1, float y1)
        : SVGPathSegWithContext(element, role)
        , m_x(x)
        , m_y(y)
        , m_x1(x1)
        , m_y1(y1)
    {
    }

    float x() const { return m_x; }
    void setX(float x)
    {
        m_x = x;
        commitChange();
    }

    float y() const { return m_y; }
    void setY(float y)
    {
        m_y = y;
        commitChange();
    }

    float x1() const { return m_x1; }
    void setX1(float x1)
    {
        m_x1 = x1;
        commitChange();
    }

    float y1() const { return m_y1; }
    void setY1(float y1)
    {
        m_y1 = y1;
        commitChange();
    }

private:
    float m_x;
    float m_y;
    float m_x1;
    float m_y1;
};

} // namespace WebCore
