/*
 *
 * Alternative print_percentage() function for wget (file `retr.c')
 * Prints percentage, estimate finish time and transfer speed.
 *
 * Implemented by Jamil Djadala <jambo@biscom.net> 1999
 * Idea by Vladi Belperchinov-Shabanski <cade@biscom.net> 1999
 *
 * for further informations see README file
 *
 */

static void
print_percentage (long bytes, long expected, enum spflags flags)
{
  static unsigned long oldTime, oldBytes, oldExpected;
  unsigned long curTime, deltaTime;
  static unsigned long speed, estimate;
  int percentage;
  char buf[100];
  char* pc;

  if( flags == SP_INIT ) {
    oldTime = elapsed_time();
    oldBytes = bytes;
    oldExpected = expected;
    return;
  }

  curTime = elapsed_time(); /* time( NULL); */

  if( curTime > oldTime) {
    deltaTime = curTime - oldTime;
    oldTime = curTime;
    }
  else {
    deltaTime = 0;
    }


  if( deltaTime != 0) {
    estimate = (unsigned long)(((expected-bytes)*(((float)deltaTime)/1000)) / (bytes-oldBytes));
    speed    = (unsigned long)((bytes-oldBytes) / (((float)deltaTime)/1000));
    oldBytes = bytes;
  }
  percentage = (int)(100.0 * bytes / expected);

  pc = buf;
  *pc = 0;
  if( percentage > 99)
    pc += sprintf( pc, "100%%" );
  else
    pc += sprintf( pc, " %2d%%", percentage );

  if ( deltaTime == 0 ) { /* we are too fast :) -- print percentage only */
    logprintf( LOG_VERBOSE, "%s", buf );
    return;
    }

  pc += sprintf( pc, "%4ld:%02ld ", estimate / 60, estimate % 60 );

  if ( speed < 1000 )
    pc += sprintf( pc, "%4ldB", speed );
  else if ( speed < 1000*10 )
    pc += sprintf( pc, "%4.2fK", speed / 1000.0 );
  else if ( speed < 1000*100 )
    pc += sprintf( pc, "%4.1fK", speed / 1000.0 );
  else if ( speed < 1000*1000 )
    pc += sprintf( pc, "%4.0fK", speed / 1000.0 );
  else if ( speed < 1000*1000*10 )
    pc += sprintf( pc, "%4.2fM", speed / (1000.0*1000.0) );
  else if ( speed < 1000*1000*100 )
    pc += sprintf( pc, "%4.1fM", speed / (1000.0*1000.0) );
  else
    pc += sprintf( pc, "%4.0fM", speed / (1000.0*1000.0) );

  logprintf( LOG_VERBOSE, "%s", buf );
}

