/*
 * Copyright (C) the Wine project
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __WINE_WINERROR_H
#define __WINE_WINERROR_H

#define FACILITY_NULL                         0
#define FACILITY_RPC                          1
#define FACILITY_DISPATCH                     2
#define FACILITY_STORAGE                      3
#define FACILITY_ITF                          4
#define FACILITY_WIN32                        7
#define FACILITY_WINDOWS                      8
#define FACILITY_SSPI                         9
#define FACILITY_SECURITY                     FACILITY_SSPI
#define FACILITY_CONTROL                     10
#define FACILITY_CERT                        11
#define FACILITY_INTERNET                    12
#define FACILITY_MEDIASERVER                 13
#define FACILITY_MSMQ                        14
#define FACILITY_SETUPAPI                    15
#define FACILITY_SCARD                       16
#define FACILITY_COMPLUS                     17
#define FACILITY_AAF                         18
#define FACILITY_URT                         19
#define FACILITY_ACS                         20
#define FACILITY_DPLAY                       21
#define FACILITY_UMI                         22
#define FACILITY_SXS                         23
#define FACILITY_WINDOWS_CE                  24
#define FACILITY_HTTP                        25
#define FACILITY_COMMONLOG                   26
#define FACILITY_USERMODE_FILTER_MANAGER     31
#define FACILITY_BACKGROUNDCOPY              32
#define FACILITY_CONFIGURATION               33
#define FACILITY_STATE_MANAGEMENT            34
#define FACILITY_METADIRECTORY               35
#define FACILITY_WINDOWSUPDATE               36
#define FACILITY_DIRECTORYSERVICE            37
#define FACILITY_GRAPHICS                    38
#define FACILITY_SHELL                       39
#define FACILITY_TPM_SERVICES                40
#define FACILITY_TPM_SOFTWARE                41
#define FACILITY_PLA                         48
#define FACILITY_FVE                         49
#define FACILITY_WINDOWS_DEFENDER            80

#define SEVERITY_SUCCESS    0
#define SEVERITY_ERROR      1


#define MAKE_HRESULT(sev,fac,code) \
    ((HRESULT) (((unsigned long)(sev)<<31) | ((unsigned long)(fac)<<16) | ((unsigned long)(code))) )
#define MAKE_SCODE(sev,fac,code) \
        ((SCODE) (((unsigned long)(sev)<<31) | ((unsigned long)(fac)<<16) | ((unsigned long)(code))) )
#define SUCCEEDED(stat) ((HRESULT)(stat)>=0)
#define FAILED(stat) ((HRESULT)(stat)<0)
#define IS_ERROR(stat) (((unsigned long)(stat)>>31) == SEVERITY_ERROR)

#define HRESULT_CODE(hr) ((hr) & 0xFFFF)
#define SCODE_CODE(sc)   ((sc) & 0xFFFF)

#define HRESULT_FACILITY(hr)  (((hr) >> 16) & 0x1FFF)
#define SCODE_FACILITY(sc)  (((sc) >> 16) & 0x1FFF)

#define HRESULT_SEVERITY(hr)    (((hr) >> 31) & 0x1)
#define SCODE_SEVERITY(sc)      (((sc) >> 31) & 0x1)

#define __HRESULT_FROM_WIN32(x)   ((x) ? ((HRESULT) (((x) & 0x0000FFFF) | (FACILITY_WIN32 << 16) | 0x80000000)) : 0 )
#ifndef _HRESULT_DEFINED
#define _HRESULT_DEFINED
# ifdef _MSC_VER
typedef long            HRESULT;
# else
typedef int             HRESULT;
# endif
#endif
static inline HRESULT HRESULT_FROM_WIN32(unsigned long x)
{
    return x ? ((HRESULT) ((x & 0x0000FFFF) | (FACILITY_WIN32 << 16) | 0x80000000)) : 0;
}
#define FACILITY_NT_BIT         0x10000000
#define HRESULT_FROM_NT(x)      ((HRESULT) ((x) | FACILITY_NT_BIT))

/* SCODE <-> HRESULT functions */
/* This macros is obsolete and should not be used in new apps. */
#define GetScode(hr)         ((SCODE)(hr))
/* This macros is obsolete and should not be used in new apps. */
#define ResultFromScode(sc)  ((HRESULT)(sc))

#define NO_ERROR                                           0
#define ERROR_SUCCESS                                      0
#define ERROR_INVALID_FUNCTION                             1
#define ERROR_FILE_NOT_FOUND                               2
#define ERROR_PATH_NOT_FOUND                               3
#define ERROR_TOO_MANY_OPEN_FILES                          4
#define ERROR_ACCESS_DENIED                                5
#define ERROR_INVALID_HANDLE                               6
#define ERROR_ARENA_TRASHED                                7
#define ERROR_NOT_ENOUGH_MEMORY                            8
#define ERROR_INVALID_BLOCK                                9
#define ERROR_BAD_ENVIRONMENT                              10
#define ERROR_BAD_FORMAT                                   11
#define ERROR_INVALID_ACCESS                               12
#define ERROR_INVALID_DATA                                 13
#define ERROR_OUTOFMEMORY                                  14
#define ERROR_INVALID_DRIVE                                15
#define ERROR_CURRENT_DIRECTORY                            16
#define ERROR_NOT_SAME_DEVICE                              17
#define ERROR_NO_MORE_FILES                                18
#define ERROR_WRITE_PROTECT                                19
#define ERROR_BAD_UNIT                                     20
#define ERROR_NOT_READY                                    21
#define ERROR_BAD_COMMAND                                  22
#define ERROR_CRC                                          23
#define ERROR_BAD_LENGTH                                   24
#define ERROR_SEEK                                         25
#define ERROR_NOT_DOS_DISK                                 26
#define ERROR_SECTOR_NOT_FOUND                             27
#define ERROR_OUT_OF_PAPER                                 28
#define ERROR_WRITE_FAULT                                  29
#define ERROR_READ_FAULT                                   30
#define ERROR_GEN_FAILURE                                  31
#define ERROR_SHARING_VIOLATION                            32
#define ERROR_LOCK_VIOLATION                               33
#define ERROR_WRONG_DISK                                   34
/* FIXME: 35 gets returned for some unsuccessful DeviceIoControl calls */
#define ERROR_UNKNOWN_NAME_01                              35
#define ERROR_SHARING_BUFFER_EXCEEDED                      36
#define ERROR_HANDLE_EOF                                   38
#define ERROR_HANDLE_DISK_FULL                             39
#define ERROR_NOT_SUPPORTED                                50
#define ERROR_REM_NOT_LIST                                 51
#define ERROR_DUP_NAME                                     52
#define ERROR_BAD_NETPATH                                  53
#define ERROR_NETWORK_BUSY                                 54
#define ERROR_DEV_NOT_EXIST                                55
#define ERROR_TOO_MANY_CMDS                                56
#define ERROR_ADAP_HDW_ERR                                 57
#define ERROR_BAD_NET_RESP                                 58
#define ERROR_UNEXP_NET_ERR                                59
#define ERROR_BAD_REM_ADAP                                 60
#define ERROR_PRINTQ_FULL                                  61
#define ERROR_NO_SPOOL_SPACE                               62
#define ERROR_PRINT_CANCELLED                              63
#define ERROR_NETNAME_DELETED                              64
#define ERROR_NETWORK_ACCESS_DENIED                        65
#define ERROR_BAD_DEV_TYPE                                 66
#define ERROR_BAD_NET_NAME                                 67
#define ERROR_TOO_MANY_NAMES                               68
#define ERROR_TOO_MANY_SESS                                69
#define ERROR_SHARING_PAUSED                               70
#define ERROR_REQ_NOT_ACCEP                                71
#define ERROR_REDIR_PAUSED                                 72
#define ERROR_FILE_EXISTS                                  80
#define ERROR_CANNOT_MAKE                                  82
#define ERROR_FAIL_I24                                     83
#define ERROR_OUT_OF_STRUCTURES                            84
#define ERROR_ALREADY_ASSIGNED                             85
#define ERROR_INVALID_PASSWORD                             86
#define ERROR_INVALID_PARAMETER                            87
#define ERROR_NET_WRITE_FAULT                              88
#define ERROR_NO_PROC_SLOTS                                89
#define ERROR_TOO_MANY_SEMAPHORES                          100
#define ERROR_EXCL_SEM_ALREADY_OWNED                       101
#define ERROR_SEM_IS_SET                                   102
#define ERROR_TOO_MANY_SEM_REQUESTS                        103
#define ERROR_INVALID_AT_INTERRUPT_TIME                    104
#define ERROR_SEM_OWNER_DIED                               105
#define ERROR_SEM_USER_LIMIT                               106
#define ERROR_DISK_CHANGE                                  107
#define ERROR_DRIVE_LOCKED                                 108
#define ERROR_BROKEN_PIPE                                  109
#define ERROR_OPEN_FAILED                                  110
#define ERROR_BUFFER_OVERFLOW                              111
#define ERROR_DISK_FULL                                    112
#define ERROR_NO_MORE_SEARCH_HANDLES                       113
#define ERROR_INVALID_TARGET_HANDLE                        114
#define ERROR_INVALID_CATEGORY                             117
#define ERROR_INVALID_VERIFY_SWITCH                        118
#define ERROR_BAD_DRIVER_LEVEL                             119
#define ERROR_CALL_NOT_IMPLEMENTED                         120
#define ERROR_SEM_TIMEOUT                                  121
#define ERROR_INSUFFICIENT_BUFFER                          122
#define ERROR_INVALID_NAME                                 123
#define ERROR_INVALID_LEVEL                                124
#define ERROR_NO_VOLUME_LABEL                              125
#define ERROR_MOD_NOT_FOUND                                126
#define ERROR_PROC_NOT_FOUND                               127
#define ERROR_WAIT_NO_CHILDREN                             128
#define ERROR_CHILD_NOT_COMPLETE                           129
#define ERROR_DIRECT_ACCESS_HANDLE                         130
#define ERROR_NEGATIVE_SEEK                                131
#define ERROR_SEEK_ON_DEVICE                               132
#define ERROR_IS_JOIN_TARGET                               133
#define ERROR_IS_JOINED                                    134
#define ERROR_IS_SUBSTED                                   135
#define ERROR_NOT_JOINED                                   136
#define ERROR_NOT_SUBSTED                                  137
#define ERROR_JOIN_TO_JOIN                                 138
#define ERROR_SUBST_TO_SUBST                               139
#define ERROR_JOIN_TO_SUBST                                140
#define ERROR_SUBST_TO_JOIN                                141
#define ERROR_BUSY_DRIVE                                   142
#define ERROR_SAME_DRIVE                                   143
#define ERROR_DIR_NOT_ROOT                                 144
#define ERROR_DIR_NOT_EMPTY                                145
#define ERROR_IS_SUBST_PATH                                146
#define ERROR_IS_JOIN_PATH                                 147
#define ERROR_PATH_BUSY                                    148
#define ERROR_IS_SUBST_TARGET                              149
#define ERROR_SYSTEM_TRACE                                 150
#define ERROR_INVALID_EVENT_COUNT                          151
#define ERROR_TOO_MANY_MUXWAITERS                          152
#define ERROR_INVALID_LIST_FORMAT                          153
#define ERROR_LABEL_TOO_LONG                               154
#define ERROR_TOO_MANY_TCBS                                155
#define ERROR_SIGNAL_REFUSED                               156
#define ERROR_DISCARDED                                    157
#define ERROR_NOT_LOCKED                                   158
#define ERROR_BAD_THREADID_ADDR                            159
#define ERROR_BAD_ARGUMENTS                                160
#define ERROR_BAD_PATHNAME                                 161
#define ERROR_SIGNAL_PENDING                               162
#define ERROR_MAX_THRDS_REACHED                            164
#define ERROR_LOCK_FAILED                                  167
#define ERROR_BUSY                                         170
#define ERROR_CANCEL_VIOLATION                             173
#define ERROR_ATOMIC_LOCKS_NOT_SUPPORTED                   174
#define ERROR_INVALID_SEGMENT_NUMBER                       180
#define ERROR_INVALID_ORDINAL                              182
#define ERROR_ALREADY_EXISTS                               183
#define ERROR_INVALID_FLAG_NUMBER                          186
#define ERROR_SEM_NOT_FOUND                                187
#define ERROR_INVALID_STARTING_CODESEG                     188
#define ERROR_INVALID_STACKSEG                             189
#define ERROR_INVALID_MODULETYPE                           190
#define ERROR_INVALID_EXE_SIGNATURE                        191
#define ERROR_EXE_MARKED_INVALID                           192
#define ERROR_BAD_EXE_FORMAT                               193
#define ERROR_ITERATED_DATA_EXCEEDS_64k                    194
#define ERROR_INVALID_MINALLOCSIZE                         195
#define ERROR_DYNLINK_FROM_INVALID_RING                    196
#define ERROR_IOPL_NOT_ENABLED                             197
#define ERROR_INVALID_SEGDPL                               198
#define ERROR_AUTODATASEG_EXCEEDS_64k                      199
#define ERROR_RING2SEG_MUST_BE_MOVABLE                     200
#define ERROR_RELOC_CHAIN_XEEDS_SEGLIM                     201
#define ERROR_INFLOOP_IN_RELOC_CHAIN                       202
#define ERROR_ENVVAR_NOT_FOUND                             203
#define ERROR_NO_SIGNAL_SENT                               205
#define ERROR_FILENAME_EXCED_RANGE                         206
#define ERROR_RING2_STACK_IN_USE                           207
#define ERROR_META_EXPANSION_TOO_LONG                      208
#define ERROR_INVALID_SIGNAL_NUMBER                        209
#define ERROR_THREAD_1_INACTIVE                            210
#define ERROR_LOCKED                                       212
#define ERROR_TOO_MANY_MODULES                             214
#define ERROR_NESTING_NOT_ALLOWED                          215
#define ERROR_EXE_MACHINE_TYPE_MISMATCH                    216
#define ERROR_BAD_PIPE                                     230
#define ERROR_PIPE_BUSY                                    231
#define ERROR_NO_DATA                                      232
#define ERROR_PIPE_NOT_CONNECTED                           233
#define ERROR_MORE_DATA                                    234
#define ERROR_VC_DISCONNECTED                              240
#define ERROR_INVALID_EA_NAME                              254
#define ERROR_EA_LIST_INCONSISTENT                         255
#define ERROR_NO_MORE_ITEMS                                259
#define ERROR_CANNOT_COPY                                  266
#define ERROR_DIRECTORY                                    267
#define ERROR_EAS_DIDNT_FIT                                275
#define ERROR_EA_FILE_CORRUPT                              276
#define ERROR_EA_TABLE_FULL                                277
#define ERROR_INVALID_EA_HANDLE                            278
#define ERROR_EAS_NOT_SUPPORTED                            282
#define ERROR_NOT_OWNER                                    288
#define ERROR_TOO_MANY_POSTS                               298
#define ERROR_PARTIAL_COPY                                 299
#define ERROR_OPLOCK_NOT_GRANTED                           300
#define ERROR_INVALID_OPLOCK_PROTOCOL                      301
#define ERROR_DISK_TOO_FRAGMENTED                          302
#define ERROR_MR_MID_NOT_FOUND                             317
#define ERROR_SCOPE_NOT_FOUND                              318
#define ERROR_FAIL_NOACTION_REBOOT                         350
#define ERROR_FAIL_SHUTDOWN                                351
#define ERROR_FAIL_RESTART                                 352
#define ERROR_MAX_SESSIONS_REACHED                         353
#define ERROR_INVALID_ADDRESS                              487
#define ERROR_USER_PROFILE_LOAD                            500
#define ERROR_ARITHMETIC_OVERFLOW                          534
#define ERROR_PIPE_CONNECTED                               535
#define ERROR_PIPE_LISTENING                               536
#define ERROR_EA_ACCESS_DENIED                             994
#define ERROR_OPERATION_ABORTED                            995
#define ERROR_IO_INCOMPLETE                                996
#define ERROR_IO_PENDING                                   997
#define ERROR_NOACCESS                                     998
#define ERROR_SWAPERROR                                    999
#define ERROR_STACK_OVERFLOW                               1001
#define ERROR_INVALID_MESSAGE                              1002
#define ERROR_CAN_NOT_COMPLETE                             1003
#define ERROR_INVALID_FLAGS                                1004
#define ERROR_UNRECOGNIZED_VOLUME                          1005
#define ERROR_FILE_INVALID                                 1006
#define ERROR_FULLSCREEN_MODE                              1007
#define ERROR_NO_TOKEN                                     1008
#define ERROR_BADDB                                        1009
#define ERROR_BADKEY                                       1010
#define ERROR_CANTOPEN                                     1011
#define ERROR_CANTREAD                                     1012
#define ERROR_CANTWRITE                                    1013
#define ERROR_REGISTRY_RECOVERED                           1014
#define ERROR_REGISTRY_CORRUPT                             1015
#define ERROR_REGISTRY_IO_FAILED                           1016
#define ERROR_NOT_REGISTRY_FILE                            1017
#define ERROR_KEY_DELETED                                  1018
#define ERROR_NO_LOG_SPACE                                 1019
#define ERROR_KEY_HAS_CHILDREN                             1020
#define ERROR_CHILD_MUST_BE_VOLATILE                       1021
#define ERROR_NOTIFY_ENUM_DIR                              1022
#define ERROR_DEPENDENT_SERVICES_RUNNING                   1051
#define ERROR_INVALID_SERVICE_CONTROL                      1052
#define ERROR_SERVICE_REQUEST_TIMEOUT                      1053
#define ERROR_SERVICE_NO_THREAD                            1054
#define ERROR_SERVICE_DATABASE_LOCKED                      1055
#define ERROR_SERVICE_ALREADY_RUNNING                      1056
#define ERROR_INVALID_SERVICE_ACCOUNT                      1057
#define ERROR_SERVICE_DISABLED                             1058
#define ERROR_CIRCULAR_DEPENDENCY                          1059
#define ERROR_SERVICE_DOES_NOT_EXIST                       1060
#define ERROR_SERVICE_CANNOT_ACCEPT_CTRL                   1061
#define ERROR_SERVICE_NOT_ACTIVE                           1062
#define ERROR_FAILED_SERVICE_CONTROLLER_CONNECT            1063
#define ERROR_EXCEPTION_IN_SERVICE                         1064
#define ERROR_DATABASE_DOES_NOT_EXIST                      1065
#define ERROR_SERVICE_SPECIFIC_ERROR                       1066
#define ERROR_PROCESS_ABORTED                              1067
#define ERROR_SERVICE_DEPENDENCY_FAIL                      1068
#define ERROR_SERVICE_LOGON_FAILED                         1069
#define ERROR_SERVICE_START_HANG                           1070
#define ERROR_INVALID_SERVICE_LOCK                         1071
#define ERROR_SERVICE_MARKED_FOR_DELETE                    1072
#define ERROR_SERVICE_EXISTS                               1073
#define ERROR_ALREADY_RUNNING_LKG                          1074
#define ERROR_SERVICE_DEPENDENCY_DELETED                   1075
#define ERROR_BOOT_ALREADY_ACCEPTED                        1076
#define ERROR_SERVICE_NEVER_STARTED                        1077
#define ERROR_DUPLICATE_SERVICE_NAME                       1078
#define ERROR_DIFFERENT_SERVICE_ACCOUNT                    1079
#define ERROR_CANNOT_DETECT_DRIVER_FAILURE                 1080
#define ERROR_CANNOT_DETECT_PROCESS_ABORT                  1081
#define ERROR_NO_RECOVERY_PROGRAM                          1082
#define ERROR_SERVICE_NOT_IN_EXE                           1083
#define ERROR_END_OF_MEDIA                                 1100
#define ERROR_FILEMARK_DETECTED                            1101
#define ERROR_BEGINNING_OF_MEDIA                           1102
#define ERROR_SETMARK_DETECTED                             1103
#define ERROR_NO_DATA_DETECTED                             1104
#define ERROR_PARTITION_FAILURE                            1105
#define ERROR_INVALID_BLOCK_LENGTH                         1106
#define ERROR_DEVICE_NOT_PARTITIONED                       1107
#define ERROR_UNABLE_TO_LOCK_MEDIA                         1108
#define ERROR_UNABLE_TO_UNLOAD_MEDIA                       1109
#define ERROR_MEDIA_CHANGED                                1110
#define ERROR_BUS_RESET                                    1111
#define ERROR_NO_MEDIA_IN_DRIVE                            1112
#define ERROR_NO_UNICODE_TRANSLATION                       1113
#define ERROR_DLL_INIT_FAILED                              1114
#define ERROR_SHUTDOWN_IN_PROGRESS                         1115
#define ERROR_NO_SHUTDOWN_IN_PROGRESS                      1116
#define ERROR_IO_DEVICE                                    1117
#define ERROR_SERIAL_NO_DEVICE                             1118
#define ERROR_IRQ_BUSY                                     1119
#define ERROR_MORE_WRITES                                  1120
#define ERROR_COUNTER_TIMEOUT                              1121
#define ERROR_FLOPPY_ID_MARK_NOT_FOUND                     1122
#define ERROR_FLOPPY_WRONG_CYLINDER                        1123
#define ERROR_FLOPPY_UNKNOWN_ERROR                         1124
#define ERROR_FLOPPY_BAD_REGISTERS                         1125
#define ERROR_DISK_RECALIBRATE_FAILED                      1126
#define ERROR_DISK_OPERATION_FAILED                        1127
#define ERROR_DISK_RESET_FAILED                            1128
#define ERROR_EOM_OVERFLOW                                 1129
#define ERROR_NOT_ENOUGH_SERVER_MEMORY                     1130
#define ERROR_POSSIBLE_DEADLOCK                            1131
#define ERROR_MAPPED_ALIGNMENT                             1132
#define ERROR_SET_POWER_STATE_VETOED                       1140
#define ERROR_SET_POWER_STATE_FAILED                       1141
#define ERROR_TOO_MANY_LINKS                               1142
#define ERROR_OLD_WIN_VERSION                              1150
#define ERROR_APP_WRONG_OS                                 1151
#define ERROR_SINGLE_INSTANCE_APP                          1152
#define ERROR_RMODE_APP                                    1153
#define ERROR_INVALID_DLL                                  1154
#define ERROR_NO_ASSOCIATION                               1155
#define ERROR_DDE_FAIL                                     1156
#define ERROR_DLL_NOT_FOUND                                1157
#define ERROR_NO_MORE_USER_HANDLES                         1158
#define ERROR_MESSAGE_SYNC_ONLY                            1159
#define ERROR_SOURCE_ELEMENT_EMPTY                         1160
#define ERROR_DESTINATION_ELEMENT_FULL                     1161
#define ERROR_ILLEGAL_ELEMENT_ADDRESS                      1162
#define ERROR_MAGAZINE_NOT_PRESENT                         1163
#define ERROR_DEVICE_REINITIALIZATION_NEEDED               1164
#define ERROR_DEVICE_REQUIRES_CLEANING                     1165
#define ERROR_DEVICE_DOOR_OPEN                             1166
#define ERROR_DEVICE_NOT_CONNECTED                         1167
#define ERROR_NOT_FOUND                                    1168
#define ERROR_NO_MATCH                                     1169
#define ERROR_SET_NOT_FOUND                                1170
#define ERROR_POINT_NOT_FOUND                              1171
#define ERROR_NO_TRACKING_SERVICE                          1172
#define ERROR_NO_VOLUME_ID                                 1173
#define ERROR_UNABLE_TO_REMOVE_REPLACED                    1175
#define ERROR_UNABLE_TO_MOVE_REPLACEMENT                   1176
#define ERROR_UNABLE_TO_MOVE_REPLACEMENT_2                 1177
#define ERROR_JOURNAL_DELETE_IN_PROGRESS                   1178
#define ERROR_JOURNAL_NOT_ACTIVE                           1179
#define ERROR_POTENTIAL_FILE_FOUND                         1180
#define ERROR_JOURNAL_ENTRY_DELETED                        1181
#define ERROR_BAD_DEVICE                                   1200
#define ERROR_CONNECTION_UNAVAIL                           1201
#define ERROR_DEVICE_ALREADY_REMEMBERED                    1202
#define ERROR_NO_NET_OR_BAD_PATH                           1203
#define ERROR_BAD_PROVIDER                                 1204
#define ERROR_CANNOT_OPEN_PROFILE                          1205
#define ERROR_BAD_PROFILE                                  1206
#define ERROR_NOT_CONTAINER                                1207
#define ERROR_EXTENDED_ERROR                               1208
#define ERROR_INVALID_GROUPNAME                            1209
#define ERROR_INVALID_COMPUTERNAME                         1210
#define ERROR_INVALID_EVENTNAME                            1211
#define ERROR_INVALID_DOMAINNAME                           1212
#define ERROR_INVALID_SERVICENAME                          1213
#define ERROR_INVALID_NETNAME                              1214
#define ERROR_INVALID_SHARENAME                            1215
#define ERROR_INVALID_PASSWORDNAME                         1216
#define ERROR_INVALID_MESSAGENAME                          1217
#define ERROR_INVALID_MESSAGEDEST                          1218
#define ERROR_SESSION_CREDENTIAL_CONFLICT                  1219
#define ERROR_REMOTE_SESSION_LIMIT_EXCEEDED                1220
#define ERROR_DUP_DOMAINNAME                               1221
#define ERROR_NO_NETWORK                                   1222
#define ERROR_CANCELLED                                    1223
#define ERROR_USER_MAPPED_FILE                             1224
#define ERROR_CONNECTION_REFUSED                           1225
#define ERROR_GRACEFUL_DISCONNECT                          1226
#define ERROR_ADDRESS_ALREADY_ASSOCIATED                   1227
#define ERROR_ADDRESS_NOT_ASSOCIATED                       1228
#define ERROR_CONNECTION_INVALID                           1229
#define ERROR_CONNECTION_ACTIVE                            1230
#define ERROR_NETWORK_UNREACHABLE                          1231
#define ERROR_HOST_UNREACHABLE                             1232
#define ERROR_PROTOCOL_UNREACHABLE                         1233
#define ERROR_PORT_UNREACHABLE                             1234
#define ERROR_REQUEST_ABORTED                              1235
#define ERROR_CONNECTION_ABORTED                           1236
#define ERROR_RETRY                                        1237
#define ERROR_CONNECTION_COUNT_LIMIT                       1238
#define ERROR_LOGIN_TIME_RESTRICTION                       1239
#define ERROR_LOGIN_WKSTA_RESTRICTION                      1240
#define ERROR_INCORRECT_ADDRESS                            1241
#define ERROR_ALREADY_REGISTERED                           1242
#define ERROR_SERVICE_NOT_FOUND                            1243
#define ERROR_NOT_AUTHENTICATED                            1244
#define ERROR_NOT_LOGGED_ON                                1245
#define ERROR_CONTINUE                                     1246
#define ERROR_ALREADY_INITIALIZED                          1247
#define ERROR_NO_MORE_DEVICES                              1248
#define ERROR_NO_SUCH_SITE                                 1249
#define ERROR_DOMAIN_CONTROLLER_EXISTS                     1250
#define ERROR_ONLY_IF_CONNECTED                            1251
#define ERROR_OVERRIDE_NOCHANGES                           1252
#define ERROR_BAD_USER_PROFILE                             1253
#define ERROR_NOT_SUPPORTED_ON_SBS                         1254
#define ERROR_SERVER_SHUTDOWN_IN_PROGRESS                  1255
#define ERROR_HOST_DOWN                                    1256
#define ERROR_ACCESS_DISABLED_BY_POLICY                    1260
#define ERROR_REG_NAT_CONSUMPTION                          1261
#define ERROR_PKINIT_FAILURE                               1263
#define ERROR_SMARTCARD_SUBSYSTEM_FAILURE                  1264
#define ERROR_DOWNGRADE_DETECTED                           1265
#define ERROR_MACHINE_LOCKED                               1271
#define ERROR_CALLBACK_SUPPLIED_INVALID_DATA               1273
#define ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED             1274
#define ERROR_DRIVER_BLOCKED                               1275
#define ERROR_INVALID_IMPORT_OF_NON_DLL                    1276
#define ERROR_NOT_ALL_ASSIGNED                             1300
#define ERROR_SOME_NOT_MAPPED                              1301
#define ERROR_NO_QUOTAS_FOR_ACCOUNT                        1302
#define ERROR_LOCAL_USER_SESSION_KEY                       1303
#define ERROR_NULL_LM_PASSWORD                             1304
#define ERROR_UNKNOWN_REVISION                             1305
#define ERROR_REVISION_MISMATCH                            1306
#define ERROR_INVALID_OWNER                                1307
#define ERROR_INVALID_PRIMARY_GROUP                        1308
#define ERROR_NO_IMPERSONATION_TOKEN                       1309
#define ERROR_CANT_DISABLE_MANDATORY                       1310
#define ERROR_NO_LOGON_SERVERS                             1311
#define ERROR_NO_SUCH_LOGON_SESSION                        1312
#define ERROR_NO_SUCH_PRIVILEGE                            1313
#define ERROR_PRIVILEGE_NOT_HELD                           1314
#define ERROR_INVALID_ACCOUNT_NAME                         1315
#define ERROR_USER_EXISTS                                  1316
#define ERROR_NO_SUCH_USER                                 1317
#define ERROR_GROUP_EXISTS                                 1318
#define ERROR_NO_SUCH_GROUP                                1319
#define ERROR_MEMBER_IN_GROUP                              1320
#define ERROR_MEMBER_NOT_IN_GROUP                          1321
#define ERROR_LAST_ADMIN                                   1322
#define ERROR_WRONG_PASSWORD                               1323
#define ERROR_ILL_FORMED_PASSWORD                          1324
#define ERROR_PASSWORD_RESTRICTION                         1325
#define ERROR_LOGON_FAILURE                                1326
#define ERROR_ACCOUNT_RESTRICTION                          1327
#define ERROR_INVALID_LOGON_HOURS                          1328
#define ERROR_INVALID_WORKSTATION                          1329
#define ERROR_PASSWORD_EXPIRED                             1330
#define ERROR_ACCOUNT_DISABLED                             1331
#define ERROR_NONE_MAPPED                                  1332
#define ERROR_TOO_MANY_LUIDS_REQUESTED                     1333
#define ERROR_LUIDS_EXHAUSTED                              1334
#define ERROR_INVALID_SUB_AUTHORITY                        1335
#define ERROR_INVALID_ACL                                  1336
#define ERROR_INVALID_SID                                  1337
#define ERROR_INVALID_SECURITY_DESCR                       1338
#define ERROR_BAD_INHERITANCE_ACL                          1340
#define ERROR_SERVER_DISABLED                              1341
#define ERROR_SERVER_NOT_DISABLED                          1342
#define ERROR_INVALID_ID_AUTHORITY                         1343
#define ERROR_ALLOTTED_SPACE_EXCEEDED                      1344
#define ERROR_INVALID_GROUP_ATTRIBUTES                     1345
#define ERROR_BAD_IMPERSONATION_LEVEL                      1346
#define ERROR_CANT_OPEN_ANONYMOUS                          1347
#define ERROR_BAD_VALIDATION_CLASS                         1348
#define ERROR_BAD_TOKEN_TYPE                               1349
#define ERROR_NO_SECURITY_ON_OBJECT                        1350
#define ERROR_CANT_ACCESS_DOMAIN_INFO                      1351
#define ERROR_INVALID_SERVER_STATE                         1352
#define ERROR_INVALID_DOMAIN_STATE                         1353
#define ERROR_INVALID_DOMAIN_ROLE                          1354
#define ERROR_NO_SUCH_DOMAIN                               1355
#define ERROR_DOMAIN_EXISTS                                1356
#define ERROR_DOMAIN_LIMIT_EXCEEDED                        1357
#define ERROR_INTERNAL_DB_CORRUPTION                       1358
#define ERROR_INTERNAL_ERROR                               1359
#define ERROR_GENERIC_NOT_MAPPED                           1360
#define ERROR_BAD_DESCRIPTOR_FORMAT                        1361
#define ERROR_NOT_LOGON_PROCESS                            1362
#define ERROR_LOGON_SESSION_EXISTS                         1363
#define ERROR_NO_SUCH_PACKAGE                              1364
#define ERROR_BAD_LOGON_SESSION_STATE                      1365
#define ERROR_LOGON_SESSION_COLLISION                      1366
#define ERROR_INVALID_LOGON_TYPE                           1367
#define ERROR_CANNOT_IMPERSONATE                           1368
#define ERROR_RXACT_INVALID_STATE                          1369
#define ERROR_RXACT_COMMIT_FAILURE                         1370
#define ERROR_SPECIAL_ACCOUNT                              1371
#define ERROR_SPECIAL_GROUP                                1372
#define ERROR_SPECIAL_USER                                 1373
#define ERROR_MEMBERS_PRIMARY_GROUP                        1374
#define ERROR_TOKEN_ALREADY_IN_USE                         1375
#define ERROR_NO_SUCH_ALIAS                                1376
#define ERROR_MEMBER_NOT_IN_ALIAS                          1377
#define ERROR_MEMBER_IN_ALIAS                              1378
#define ERROR_ALIAS_EXISTS                                 1379
#define ERROR_LOGON_NOT_GRANTED                            1380
#define ERROR_TOO_MANY_SECRETS                             1381
#define ERROR_SECRET_TOO_LONG                              1382
#define ERROR_INTERNAL_DB_ERROR                            1383
#define ERROR_TOO_MANY_CONTEXT_IDS                         1384
#define ERROR_LOGON_TYPE_NOT_GRANTED                       1385
#define ERROR_NT_CROSS_ENCRYPTION_REQUIRED                 1386
#define ERROR_NO_SUCH_MEMBER                               1387
#define ERROR_INVALID_MEMBER                               1388
#define ERROR_TOO_MANY_SIDS                                1389
#define ERROR_LM_CROSS_ENCRYPTION_REQUIRED                 1390
#define ERROR_NO_INHERITANCE                               1391
#define ERROR_FILE_CORRUPT                                 1392
#define ERROR_DISK_CORRUPT                                 1393
#define ERROR_NO_USER_SESSION_KEY                          1394
#define ERROR_LICENSE_QUOTA_EXCEEDED                       1395
#define ERROR_WRONG_TARGET_NAME                            1396
#define ERROR_MUTUAL_AUTH_FAILED                           1397
#define ERROR_TIME_SKEW                                    1398
#define ERROR_CURRENT_DOMAIN_NOT_ALLOWED                   1399
#define ERROR_INVALID_WINDOW_HANDLE                        1400
#define ERROR_INVALID_MENU_HANDLE                          1401
#define ERROR_INVALID_CURSOR_HANDLE                        1402
#define ERROR_INVALID_ACCEL_HANDLE                         1403
#define ERROR_INVALID_HOOK_HANDLE                          1404
#define ERROR_INVALID_DWP_HANDLE                           1405
#define ERROR_TLW_WITH_WSCHILD                             1406
#define ERROR_CANNOT_FIND_WND_CLASS                        1407
#define ERROR_WINDOW_OF_OTHER_THREAD                       1408
#define ERROR_HOTKEY_ALREADY_REGISTERED                    1409
#define ERROR_CLASS_ALREADY_EXISTS                         1410
#define ERROR_CLASS_DOES_NOT_EXIST                         1411
#define ERROR_CLASS_HAS_WINDOWS                            1412
#define ERROR_INVALID_INDEX                                1413
#define ERROR_INVALID_ICON_HANDLE                          1414
#define ERROR_PRIVATE_DIALOG_INDEX                         1415
#define ERROR_LISTBOX_ID_NOT_FOUND                         1416
#define ERROR_NO_WILDCARD_CHARACTERS                       1417
#define ERROR_CLIPBOARD_NOT_OPEN                           1418
#define ERROR_HOTKEY_NOT_REGISTERED                        1419
#define ERROR_WINDOW_NOT_DIALOG                            1420
#define ERROR_CONTROL_ID_NOT_FOUND                         1421
#define ERROR_INVALID_COMBOBOX_MESSAGE                     1422
#define ERROR_WINDOW_NOT_COMBOBOX                          1423
#define ERROR_INVALID_EDIT_HEIGHT                          1424
#define ERROR_DC_NOT_FOUND                                 1425
#define ERROR_INVALID_HOOK_FILTER                          1426
#define ERROR_INVALID_FILTER_PROC                          1427
#define ERROR_HOOK_NEEDS_HMOD                              1428
#define ERROR_GLOBAL_ONLY_HOOK                             1429
#define ERROR_JOURNAL_HOOK_SET                             1430
#define ERROR_HOOK_NOT_INSTALLED                           1431
#define ERROR_INVALID_LB_MESSAGE                           1432
#define ERROR_SETCOUNT_ON_BAD_LB                           1433
#define ERROR_LB_WITHOUT_TABSTOPS                          1434
#define ERROR_DESTROY_OBJECT_OF_OTHER_THREAD               1435
#define ERROR_CHILD_WINDOW_MENU                            1436
#define ERROR_NO_SYSTEM_MENU                               1437
#define ERROR_INVALID_MSGBOX_STYLE                         1438
#define ERROR_INVALID_SPI_VALUE                            1439
#define ERROR_SCREEN_ALREADY_LOCKED                        1440
#define ERROR_HWNDS_HAVE_DIFF_PARENT                       1441
#define ERROR_NOT_CHILD_WINDOW                             1442
#define ERROR_INVALID_GW_COMMAND                           1443
#define ERROR_INVALID_THREAD_ID                            1444
#define ERROR_NON_MDICHILD_WINDOW                          1445
#define ERROR_POPUP_ALREADY_ACTIVE                         1446
#define ERROR_NO_SCROLLBARS                                1447
#define ERROR_INVALID_SCROLLBAR_RANGE                      1448
#define ERROR_INVALID_SHOWWIN_COMMAND                      1449
#define ERROR_NO_SYSTEM_RESOURCES                          1450
#define ERROR_NONPAGED_SYSTEM_RESOURCES                    1451
#define ERROR_PAGED_SYSTEM_RESOURCES                       1452
#define ERROR_WORKING_SET_QUOTA                            1453
#define ERROR_PAGEFILE_QUOTA                               1454
#define ERROR_COMMITMENT_LIMIT                             1455
#define ERROR_MENU_ITEM_NOT_FOUND                          1456
#define ERROR_INVALID_KEYBOARD_HANDLE                      1457
#define ERROR_HOOK_TYPE_NOT_ALLOWED                        1458
#define ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION           1459
#define ERROR_TIMEOUT                                      1460
#define ERROR_INVALID_MONITOR_HANDLE                       1461
#define ERROR_EVENTLOG_FILE_CORRUPT                        1500
#define ERROR_EVENTLOG_CANT_START                          1501
#define ERROR_LOG_FILE_FULL                                1502
#define ERROR_EVENTLOG_FILE_CHANGED                        1503
#define ERROR_INSTALL_SERVICE_FAILURE                      1601
#define ERROR_INSTALL_USEREXIT                             1602
#define ERROR_INSTALL_FAILURE                              1603
#define ERROR_INSTALL_SUSPEND                              1604
#define ERROR_UNKNOWN_PRODUCT                              1605
#define ERROR_UNKNOWN_FEATURE                              1606
#define ERROR_UNKNOWN_COMPONENT                            1607
#define ERROR_UNKNOWN_PROPERTY                             1608
#define ERROR_INVALID_HANDLE_STATE                         1609
#define ERROR_BAD_CONFIGURATION                            1610
#define ERROR_INDEX_ABSENT                                 1611
#define ERROR_INSTALL_SOURCE_ABSENT                        1612
#define ERROR_INSTALL_PACKAGE_VERSION                      1613
#define ERROR_PRODUCT_UNINSTALLED                          1614
#define ERROR_BAD_QUERY_SYNTAX                             1615
#define ERROR_INVALID_FIELD                                1616
#define ERROR_DEVICE_REMOVED                               1617
#define ERROR_INSTALL_ALREADY_RUNNING                      1618
#define ERROR_INSTALL_PACKAGE_OPEN_FAILED                  1619
#define ERROR_INSTALL_PACKAGE_INVALID                      1620
#define ERROR_INSTALL_UI_FAILURE                           1621
#define ERROR_INSTALL_LOG_FAILURE                          1622
#define ERROR_INSTALL_LANGUAGE_UNSUPPORTED                 1623
#define ERROR_INSTALL_TRANSFORM_FAILURE                    1624
#define ERROR_INSTALL_PACKAGE_REJECTED                     1625
#define ERROR_FUNCTION_NOT_CALLED                          1626
#define ERROR_FUNCTION_FAILED                              1627
#define ERROR_INVALID_TABLE                                1628
#define ERROR_DATATYPE_MISMATCH                            1629
#define ERROR_UNSUPPORTED_TYPE                             1630
#define ERROR_CREATE_FAILED                                1631
#define ERROR_INSTALL_TEMP_UNWRITABLE                      1632
#define ERROR_INSTALL_PLATFORM_UNSUPPORTED                 1633
#define ERROR_INSTALL_NOTUSED                              1634
#define ERROR_PATCH_PACKAGE_OPEN_FAILED                    1635
#define ERROR_PATCH_PACKAGE_INVALID                        1636
#define ERROR_PATCH_PACKAGE_UNSUPPORTED                    1637
#define ERROR_PRODUCT_VERSION                              1638
#define ERROR_INVALID_COMMAND_LINE                         1639
#define ERROR_INSTALL_REMOTE_DISALLOWED                    1640
#define ERROR_SUCCESS_REBOOT_INITIATED                     1641
#define RPC_S_INVALID_STRING_BINDING                       1700
#define RPC_S_WRONG_KIND_OF_BINDING                        1701
#define RPC_S_INVALID_BINDING                              1702
#define RPC_S_PROTSEQ_NOT_SUPPORTED                        1703
#define RPC_S_INVALID_RPC_PROTSEQ                          1704
#define RPC_S_INVALID_STRING_UUID                          1705
#define RPC_S_INVALID_ENDPOINT_FORMAT                      1706
#define RPC_S_INVALID_NET_ADDR                             1707
#define RPC_S_NO_ENDPOINT_FOUND                            1708
#define RPC_S_INVALID_TIMEOUT                              1709
#define RPC_S_OBJECT_NOT_FOUND                             1710
#define RPC_S_ALREADY_REGISTERED                           1711
#define RPC_S_TYPE_ALREADY_REGISTERED                      1712
#define RPC_S_ALREADY_LISTENING                            1713
#define RPC_S_NO_PROTSEQS_REGISTERED                       1714
#define RPC_S_NOT_LISTENING                                1715
#define RPC_S_UNKNOWN_MGR_TYPE                             1716
#define RPC_S_UNKNOWN_IF                                   1717
#define RPC_S_NO_BINDINGS                                  1718
#define RPC_S_NO_PROTSEQS                                  1719
#define RPC_S_CANT_CREATE_ENDPOINT                         1720
#define RPC_S_OUT_OF_RESOURCES                             1721
#define RPC_S_SERVER_UNAVAILABLE                           1722
#define RPC_S_SERVER_TOO_BUSY                              1723
#define RPC_S_INVALID_NETWORK_OPTIONS                      1724
#define RPC_S_NO_CALL_ACTIVE                               1725
#define RPC_S_CALL_FAILED                                  1726
#define RPC_S_CALL_FAILED_DNE                              1727
#define RPC_S_PROTOCOL_ERROR                               1728
#define RPC_S_UNSUPPORTED_TRANS_SYN                        1730
#define RPC_S_UNSUPPORTED_TYPE                             1732
#define RPC_S_INVALID_TAG                                  1733
#define RPC_S_INVALID_BOUND                                1734
#define RPC_S_NO_ENTRY_NAME                                1735
#define RPC_S_INVALID_NAME_SYNTAX                          1736
#define RPC_S_UNSUPPORTED_NAME_SYNTAX                      1737
#define RPC_S_UUID_NO_ADDRESS                              1739
#define RPC_S_DUPLICATE_ENDPOINT                           1740
#define RPC_S_UNKNOWN_AUTHN_TYPE                           1741
#define RPC_S_MAX_CALLS_TOO_SMALL                          1742
#define RPC_S_STRING_TOO_LONG                              1743
#define RPC_S_PROTSEQ_NOT_FOUND                            1744
#define RPC_S_PROCNUM_OUT_OF_RANGE                         1745
#define RPC_S_BINDING_HAS_NO_AUTH                          1746
#define RPC_S_UNKNOWN_AUTHN_SERVICE                        1747
#define RPC_S_UNKNOWN_AUTHN_LEVEL                          1748
#define RPC_S_INVALID_AUTH_IDENTITY                        1749
#define RPC_S_UNKNOWN_AUTHZ_SERVICE                        1750
#define EPT_S_INVALID_ENTRY                                1751
#define EPT_S_CANT_PERFORM_OP                              1752
#define EPT_S_NOT_REGISTERED                               1753
#define RPC_S_NOTHING_TO_EXPORT                            1754
#define RPC_S_INCOMPLETE_NAME                              1755
#define RPC_S_INVALID_VERS_OPTION                          1756
#define RPC_S_NO_MORE_MEMBERS                              1757
#define RPC_S_NOT_ALL_OBJS_UNEXPORTED                      1758
#define RPC_S_INTERFACE_NOT_FOUND                          1759
#define RPC_S_ENTRY_ALREADY_EXISTS                         1760
#define RPC_S_ENTRY_NOT_FOUND                              1761
#define RPC_S_NAME_SERVICE_UNAVAILABLE                     1762
#define RPC_S_INVALID_NAF_ID                               1763
#define RPC_S_CANNOT_SUPPORT                               1764
#define RPC_S_NO_CONTEXT_AVAILABLE                         1765
#define RPC_S_INTERNAL_ERROR                               1766
#define RPC_S_ZERO_DIVIDE                                  1767
#define RPC_S_ADDRESS_ERROR                                1768
#define RPC_S_FP_DIV_ZERO                                  1769
#define RPC_S_FP_UNDERFLOW                                 1770
#define RPC_S_FP_OVERFLOW                                  1771
#define RPC_X_NO_MORE_ENTRIES                              1772
#define RPC_X_SS_CHAR_TRANS_OPEN_FAIL                      1773
#define RPC_X_SS_CHAR_TRANS_SHORT_FILE                     1774
#define RPC_X_SS_IN_NULL_CONTEXT                           1775
#define RPC_X_SS_CONTEXT_DAMAGED                           1777
#define RPC_X_SS_HANDLES_MISMATCH                          1778
#define RPC_X_SS_CANNOT_GET_CALL_HANDLE                    1779
#define RPC_X_NULL_REF_POINTER                             1780
#define RPC_X_ENUM_VALUE_OUT_OF_RANGE                      1781
#define RPC_X_BYTE_COUNT_TOO_SMALL                         1782
#define RPC_X_BAD_STUB_DATA                                1783
#define ERROR_INVALID_USER_BUFFER                          1784
#define ERROR_UNRECOGNIZED_MEDIA                           1785
#define ERROR_NO_TRUST_LSA_SECRET                          1786
#define ERROR_NO_TRUST_SAM_ACCOUNT                         1787
#define ERROR_TRUSTED_DOMAIN_FAILURE                       1788
#define ERROR_TRUSTED_RELATIONSHIP_FAILURE                 1789
#define ERROR_TRUST_FAILURE                                1790
#define RPC_S_CALL_IN_PROGRESS                             1791
#define ERROR_NETLOGON_NOT_STARTED                         1792
#define ERROR_ACCOUNT_EXPIRED                              1793
#define ERROR_REDIRECTOR_HAS_OPEN_HANDLES                  1794
#define ERROR_PRINTER_DRIVER_ALREADY_INSTALLED             1795
#define ERROR_UNKNOWN_PORT                                 1796
#define ERROR_UNKNOWN_PRINTER_DRIVER                       1797
#define ERROR_UNKNOWN_PRINTPROCESSOR                       1798
#define ERROR_INVALID_SEPARATOR_FILE                       1799
#define ERROR_INVALID_PRIORITY                             1800
#define ERROR_INVALID_PRINTER_NAME                         1801
#define ERROR_PRINTER_ALREADY_EXISTS                       1802
#define ERROR_INVALID_PRINTER_COMMAND                      1803
#define ERROR_INVALID_DATATYPE                             1804
#define ERROR_INVALID_ENVIRONMENT                          1805
#define RPC_S_NO_MORE_BINDINGS                             1806
#define ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT            1807
#define ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT            1808
#define ERROR_NOLOGON_SERVER_TRUST_ACCOUNT                 1809
#define ERROR_DOMAIN_TRUST_INCONSISTENT                    1810
#define ERROR_SERVER_HAS_OPEN_HANDLES                      1811
#define ERROR_RESOURCE_DATA_NOT_FOUND                      1812
#define ERROR_RESOURCE_TYPE_NOT_FOUND                      1813
#define ERROR_RESOURCE_NAME_NOT_FOUND                      1814
#define ERROR_RESOURCE_LANG_NOT_FOUND                      1815
#define ERROR_NOT_ENOUGH_QUOTA                             1816
#define RPC_S_NO_INTERFACES                                1817
#define RPC_S_CALL_CANCELLED                               1818
#define RPC_S_BINDING_INCOMPLETE                           1819
#define RPC_S_COMM_FAILURE                                 1820
#define RPC_S_UNSUPPORTED_AUTHN_LEVEL                      1821
#define RPC_S_NO_PRINC_NAME                                1822
#define RPC_S_NOT_RPC_ERROR                                1823
#define RPC_S_UUID_LOCAL_ONLY                              1824
#define RPC_S_SEC_PKG_ERROR                                1825
#define RPC_S_NOT_CANCELLED                                1826
#define RPC_X_INVALID_ES_ACTION                            1827
#define RPC_X_WRONG_ES_VERSION                             1828
#define RPC_X_WRONG_STUB_VERSION                           1829
#define RPC_X_INVALID_PIPE_OBJECT                          1830
#define RPC_X_WRONG_PIPE_ORDER                             1831
#define RPC_X_WRONG_PIPE_VERSION                           1832
#define RPC_S_GROUP_MEMBER_NOT_FOUND                       1898
#define EPT_S_CANT_CREATE                                  1899
#define RPC_S_INVALID_OBJECT                               1900
#define ERROR_INVALID_TIME                                 1901
#define ERROR_INVALID_FORM_NAME                            1902
#define ERROR_INVALID_FORM_SIZE                            1903
#define ERROR_ALREADY_WAITING                              1904
#define ERROR_PRINTER_DELETED                              1905
#define ERROR_INVALID_PRINTER_STATE                        1906
#define ERROR_PASSWORD_MUST_CHANGE                         1907
#define ERROR_DOMAIN_CONTROLLER_NOT_FOUND                  1908
#define ERROR_ACCOUNT_LOCKED_OUT                           1909
#define OR_INVALID_OXID                                    1910
#define OR_INVALID_OID                                     1911
#define OR_INVALID_SET                                     1912
#define RPC_S_SEND_INCOMPLETE                              1913
#define RPC_S_INVALID_ASYNC_HANDLE                         1914
#define RPC_S_INVALID_ASYNC_CALL                           1915
#define RPC_X_PIPE_CLOSED                                  1916
#define RPC_X_PIPE_DISCIPLINE_ERROR                        1917
#define RPC_X_PIPE_EMPTY                                   1918
#define ERROR_NO_SITENAME                                  1919
#define ERROR_CANT_ACCESS_FILE                             1920
#define ERROR_CANT_RESOLVE_FILENAME                        1921
#define RPC_S_ENTRY_TYPE_MISMATCH                          1922
#define RPC_S_NOT_ALL_OBJS_EXPORTED                        1923
#define RPC_S_INTERFACE_NOT_EXPORTED                       1924
#define RPC_S_PROFILE_NOT_ADDED                            1925
#define RPC_S_PRF_ELT_NOT_ADDED                            1926
#define RPC_S_PRF_ELT_NOT_REMOVED                          1927
#define RPC_S_GRP_ELT_NOT_ADDED                            1928
#define RPC_S_GRP_ELT_NOT_REMOVED                          1929
#define ERROR_KM_DRIVER_BLOCKED                            1930
#define ERROR_CONTEXT_EXPIRED                              1931
#define ERROR_PER_USER_TRUST_QUOTA_EXCEEDED                1932
#define ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED                1933
#define ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED             1934
#define ERROR_AUTHENTICATION_FIREWALL_FAILED               1935
#define ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED             1936
#define ERROR_INVALID_PIXEL_FORMAT                         2000
#define ERROR_BAD_DRIVER                                   2001
#define ERROR_INVALID_WINDOW_STYLE                         2002
#define ERROR_METAFILE_NOT_SUPPORTED                       2003
#define ERROR_TRANSFORM_NOT_SUPPORTED                      2004
#define ERROR_CLIPPING_NOT_SUPPORTED                       2005
#define ERROR_INVALID_CMM                                  2010
#define ERROR_INVALID_PROFILE                              2011
#define ERROR_TAG_NOT_FOUND                                2012
#define ERROR_TAG_NOT_PRESENT                              2013
#define ERROR_DUPLICATE_TAG                                2014
#define ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE           2015
#define ERROR_PROFILE_NOT_FOUND                            2016
#define ERROR_INVALID_COLORSPACE                           2017
#define ERROR_ICM_NOT_ENABLED                              2018
#define ERROR_DELETING_ICM_XFORM                           2019
#define ERROR_INVALID_TRANSFORM                            2020
#define ERROR_COLORSPACE_MISMATCH                          2021
#define ERROR_INVALID_COLORINDEX                           2022
#define ERROR_CONNECTED_OTHER_PASSWORD                     2108
#define ERROR_BAD_USERNAME                                 2202
#define ERROR_NOT_CONNECTED                                2250
#define ERROR_OPEN_FILES                                   2401
#define ERROR_ACTIVE_CONNECTIONS                           2402
#define ERROR_DEVICE_IN_USE                                2404
#define ERROR_UNKNOWN_PRINT_MONITOR                        3000
#define ERROR_PRINTER_DRIVER_IN_USE                        3001
#define ERROR_SPOOL_FILE_NOT_FOUND                         3002
#define ERROR_SPL_NO_STARTDOC                              3003
#define ERROR_SPL_NO_ADDJOB                                3004
#define ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED            3005
#define ERROR_PRINT_MONITOR_ALREADY_INSTALLED              3006
#define ERROR_INVALID_PRINT_MONITOR                        3007
#define ERROR_PRINT_MONITOR_IN_USE                         3008
#define ERROR_PRINTER_HAS_JOBS_QUEUED                      3009
#define ERROR_SUCCESS_REBOOT_REQUIRED                      3010
#define ERROR_SUCCESS_RESTART_REQUIRED                     3011
#define ERROR_PRINTER_NOT_FOUND                            3012
#define ERROR_PRINTER_DRIVER_WARNED                        3013
#define ERROR_PRINTER_DRIVER_BLOCKED                       3014
#define ERROR_WINS_INTERNAL                                4000
#define ERROR_CAN_NOT_DEL_LOCAL_WINS                       4001
#define ERROR_STATIC_INIT                                  4002
#define ERROR_INC_BACKUP                                   4003
#define ERROR_FULL_BACKUP                                  4004
#define ERROR_REC_NON_EXISTENT                             4005
#define ERROR_RPL_NOT_ALLOWED                              4006
#define ERROR_DHCP_ADDRESS_CONFLICT                        4100
#define ERROR_WMI_GUID_NOT_FOUND                           4200
#define ERROR_WMI_INSTANCE_NOT_FOUND                       4201
#define ERROR_WMI_ITEMID_NOT_FOUND                         4202
#define ERROR_WMI_TRY_AGAIN                                4203
#define ERROR_WMI_DP_NOT_FOUND                             4204
#define ERROR_WMI_UNRESOLVED_INSTANCE_REF                  4205
#define ERROR_WMI_ALREADY_ENABLED                          4206
#define ERROR_WMI_GUID_DISCONNECTED                        4207
#define ERROR_WMI_SERVER_UNAVAILABLE                       4208
#define ERROR_WMI_DP_FAILED                                4209
#define ERROR_WMI_INVALID_MOF                              4210
#define ERROR_WMI_INVALID_REGINFO                          4211
#define ERROR_WMI_ALREADY_DISABLED                         4212
#define ERROR_WMI_READ_ONLY                                4213
#define ERROR_WMI_SET_FAILURE                              4214
#define ERROR_INVALID_MEDIA                                4300
#define ERROR_INVALID_LIBRARY                              4301
#define ERROR_INVALID_MEDIA_POOL                           4302
#define ERROR_DRIVE_MEDIA_MISMATCH                         4303
#define ERROR_MEDIA_OFFLINE                                4304
#define ERROR_LIBRARY_OFFLINE                              4305
#define ERROR_EMPTY                                        4306
#define ERROR_NOT_EMPTY                                    4307
#define ERROR_MEDIA_UNAVAILABLE                            4308
#define ERROR_RESOURCE_DISABLED                            4309
#define ERROR_INVALID_CLEANER                              4310
#define ERROR_UNABLE_TO_CLEAN                              4311
#define ERROR_OBJECT_NOT_FOUND                             4312
#define ERROR_DATABASE_FAILURE                             4313
#define ERROR_DATABASE_FULL                                4314
#define ERROR_MEDIA_INCOMPATIBLE                           4315
#define ERROR_RESOURCE_NOT_PRESENT                         4316
#define ERROR_INVALID_OPERATION                            4317
#define ERROR_MEDIA_NOT_AVAILABLE                          4318
#define ERROR_DEVICE_NOT_AVAILABLE                         4319
#define ERROR_REQUEST_REFUSED                              4320
#define ERROR_INVALID_DRIVE_OBJECT                         4321
#define ERROR_LIBRARY_FULL                                 4322
#define ERROR_MEDIUM_NOT_ACCESSIBLE                        4323
#define ERROR_UNABLE_TO_LOAD_MEDIUM                        4324
#define ERROR_UNABLE_TO_INVENTORY_DRIVE                    4325
#define ERROR_UNABLE_TO_INVENTORY_SLOT                     4326
#define ERROR_UNABLE_TO_INVENTORY_TRANSPORT                4327
#define ERROR_TRANSPORT_FULL                               4328
#define ERROR_CONTROLLING_IEPORT                           4329
#define ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA                4330
#define ERROR_CLEANER_SLOT_SET                             4331
#define ERROR_CLEANER_SLOT_NOT_SET                         4332
#define ERROR_CLEANER_CARTRIDGE_SPENT                      4333
#define ERROR_UNEXPECTED_OMID                              4334
#define ERROR_CANT_DELETE_LAST_ITEM                        4335
#define ERROR_MESSAGE_EXCEEDS_MAX_SIZE                     4336
#define ERROR_VOLUME_CONTAINS_SYS_FILES                    4337
#define ERROR_INDIGENOUS_TYPE                              4338
#define ERROR_NO_SUPPORTING_DRIVES                         4339
#define ERROR_CLEANER_CARTRIDGE_INSTALLED                  4340
#define ERROR_FILE_OFFLINE                                 4350
#define ERROR_REMOTE_STORAGE_NOT_ACTIVE                    4351
#define ERROR_REMOTE_STORAGE_MEDIA_ERROR                   4352
#define ERROR_NOT_A_REPARSE_POINT                          4390
#define ERROR_REPARSE_ATTRIBUTE_CONFLICT                   4391
#define ERROR_INVALID_REPARSE_DATA                         4392
#define ERROR_REPARSE_TAG_INVALID                          4393
#define ERROR_REPARSE_TAG_MISMATCH                         4394
#define ERROR_VOLUME_NOT_SIS_ENABLED                       4500
#define ERROR_DEPENDENT_RESOURCE_EXISTS                    5001
#define ERROR_DEPENDENCY_NOT_FOUND                         5002
#define ERROR_DEPENDENCY_ALREADY_EXISTS                    5003
#define ERROR_RESOURCE_NOT_ONLINE                          5004
#define ERROR_HOST_NODE_NOT_AVAILABLE                      5005
#define ERROR_RESOURCE_NOT_AVAILABLE                       5006
#define ERROR_RESOURCE_NOT_FOUND                           5007
#define ERROR_SHUTDOWN_CLUSTER                             5008
#define ERROR_CANT_EVICT_ACTIVE_NODE                       5009
#define ERROR_OBJECT_ALREADY_EXISTS                        5010
#define ERROR_OBJECT_IN_LIST                               5011
#define ERROR_GROUP_NOT_AVAILABLE                          5012
#define ERROR_GROUP_NOT_FOUND                              5013
#define ERROR_GROUP_NOT_ONLINE                             5014
#define ERROR_HOST_NODE_NOT_RESOURCE_OWNER                 5015
#define ERROR_HOST_NODE_NOT_GROUP_OWNER                    5016
#define ERROR_RESMON_CREATE_FAILED                         5017
#define ERROR_RESMON_ONLINE_FAILED                         5018
#define ERROR_RESOURCE_ONLINE                              5019
#define ERROR_QUORUM_RESOURCE                              5020
#define ERROR_NOT_QUORUM_CAPABLE                           5021
#define ERROR_CLUSTER_SHUTTING_DOWN                        5022
#define ERROR_INVALID_STATE                                5023
#define ERROR_RESOURCE_PROPERTIES_STORED                   5024
#define ERROR_NOT_QUORUM_CLASS                             5025
#define ERROR_CORE_RESOURCE                                5026
#define ERROR_QUORUM_RESOURCE_ONLINE_FAILED                5027
#define ERROR_QUORUMLOG_OPEN_FAILED                        5028
#define ERROR_CLUSTERLOG_CORRUPT                           5029
#define ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE            5030
#define ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE                   5031
#define ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND                5032
#define ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE                  5033
#define ERROR_QUORUM_OWNER_ALIVE                           5034
#define ERROR_NETWORK_NOT_AVAILABLE                        5035
#define ERROR_NODE_NOT_AVAILABLE                           5036
#define ERROR_ALL_NODES_NOT_AVAILABLE                      5037
#define ERROR_RESOURCE_FAILED                              5038
#define ERROR_CLUSTER_INVALID_NODE                         5039
#define ERROR_CLUSTER_NODE_EXISTS                          5040
#define ERROR_CLUSTER_JOIN_IN_PROGRESS                     5041
#define ERROR_CLUSTER_NODE_NOT_FOUND                       5042
#define ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND                 5043
#define ERROR_CLUSTER_NETWORK_EXISTS                       5044
#define ERROR_CLUSTER_NETWORK_NOT_FOUND                    5045
#define ERROR_CLUSTER_NETINTERFACE_EXISTS                  5046
#define ERROR_CLUSTER_NETINTERFACE_NOT_FOUND               5047
#define ERROR_CLUSTER_INVALID_REQUEST                      5048
#define ERROR_CLUSTER_INVALID_NETWORK_PROVIDER             5049
#define ERROR_CLUSTER_NODE_DOWN                            5050
#define ERROR_CLUSTER_NODE_UNREACHABLE                     5051
#define ERROR_CLUSTER_NODE_NOT_MEMBER                      5052
#define ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS                 5053
#define ERROR_CLUSTER_INVALID_NETWORK                      5054
#define ERROR_CLUSTER_NODE_UP                              5056
#define ERROR_CLUSTER_IPADDR_IN_USE                        5057
#define ERROR_CLUSTER_NODE_NOT_PAUSED                      5058
#define ERROR_CLUSTER_NO_SECURITY_CONTEXT                  5059
#define ERROR_CLUSTER_NETWORK_NOT_INTERNAL                 5060
#define ERROR_CLUSTER_NODE_ALREADY_UP                      5061
#define ERROR_CLUSTER_NODE_ALREADY_DOWN                    5062
#define ERROR_CLUSTER_NETWORK_ALREADY_ONLINE               5063
#define ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE              5064
#define ERROR_CLUSTER_NODE_ALREADY_MEMBER                  5065
#define ERROR_CLUSTER_LAST_INTERNAL_NETWORK                5066
#define ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS               5067
#define ERROR_INVALID_OPERATION_ON_QUORUM                  5068
#define ERROR_DEPENDENCY_NOT_ALLOWED                       5069
#define ERROR_CLUSTER_NODE_PAUSED                          5070
#define ERROR_NODE_CANT_HOST_RESOURCE                      5071
#define ERROR_CLUSTER_NODE_NOT_READY                       5072
#define ERROR_CLUSTER_NODE_SHUTTING_DOWN                   5073
#define ERROR_CLUSTER_JOIN_ABORTED                         5074
#define ERROR_CLUSTER_INCOMPATIBLE_VERSIONS                5075
#define ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED         5076
#define ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED                5077
#define ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND              5078
#define ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED                5079
#define ERROR_CLUSTER_RESNAME_NOT_FOUND                    5080
#define ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED           5081
#define ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST                5082
#define ERROR_CLUSTER_DATABASE_SEQMISMATCH                 5083
#define ERROR_RESMON_INVALID_STATE                         5084
#define ERROR_CLUSTER_GUM_NOT_LOCKER                       5085
#define ERROR_QUORUM_DISK_NOT_FOUND                        5086
#define ERROR_DATABASE_BACKUP_CORRUPT                      5087
#define ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT            5088
#define ERROR_RESOURCE_PROPERTY_UNCHANGEABLE               5089
#define ERROR_ENCRYPTION_FAILED                            6000
#define ERROR_DECRYPTION_FAILED                            6001
#define ERROR_FILE_ENCRYPTED                               6002
#define ERROR_NO_RECOVERY_POLICY                           6003
#define ERROR_NO_EFS                                       6004
#define ERROR_WRONG_EFS                                    6005
#define ERROR_NO_USER_KEYS                                 6006
#define ERROR_FILE_NOT_ENCRYPTED                           6007
#define ERROR_NOT_EXPORT_FORMAT                            6008
#define ERROR_FILE_READ_ONLY                               6009
#define ERROR_DIR_EFS_DISALLOWED                           6010
#define ERROR_EFS_SERVER_NOT_TRUSTED                       6011
#define ERROR_EFS_ALG_BLOB_TOO_BIG                         6013
#define ERROR_NO_BROWSER_SERVERS_FOUND                     6118
#define SCHED_E_SERVICE_NOT_LOCALSYSTEM                    6200
#define ERROR_CTX_WINSTATION_NAME_INVALID                  7001
#define ERROR_CTX_INVALID_PD                               7002
#define ERROR_CTX_PD_NOT_FOUND                             7003
#define ERROR_CTX_WD_NOT_FOUND                             7004
#define ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY               7005
#define ERROR_CTX_SERVICE_NAME_COLLISION                   7006
#define ERROR_CTX_CLOSE_PENDING                            7007
#define ERROR_CTX_NO_OUTBUF                                7008
#define ERROR_CTX_MODEM_INF_NOT_FOUND                      7009
#define ERROR_CTX_INVALID_MODEMNAME                        7010
#define ERROR_CTX_MODEM_RESPONSE_ERROR                     7011
#define ERROR_CTX_MODEM_RESPONSE_TIMEOUT                   7012
#define ERROR_CTX_MODEM_RESPONSE_NO_CARRIER                7013
#define ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE               7014
#define ERROR_CTX_MODEM_RESPONSE_BUSY                      7015
#define ERROR_CTX_MODEM_RESPONSE_VOICE                     7016
#define ERROR_CTX_TD_ERROR                                 7017
#define ERROR_CTX_WINSTATION_NOT_FOUND                     7022
#define ERROR_CTX_WINSTATION_ALREADY_EXISTS                7023
#define ERROR_CTX_WINSTATION_BUSY                          7024
#define ERROR_CTX_BAD_VIDEO_MODE                           7025
#define ERROR_CTX_GRAPHICS_INVALID                         7035
#define ERROR_CTX_LOGON_DISABLED                           7037
#define ERROR_CTX_NOT_CONSOLE                              7038
#define ERROR_CTX_CLIENT_QUERY_TIMEOUT                     7040
#define ERROR_CTX_CONSOLE_DISCONNECT                       7041
#define ERROR_CTX_CONSOLE_CONNECT                          7042
#define ERROR_CTX_SHADOW_DENIED                            7044
#define ERROR_CTX_WINSTATION_ACCESS_DENIED                 7045
#define ERROR_CTX_INVALID_WD                               7049
#define ERROR_CTX_SHADOW_INVALID                           7050
#define ERROR_CTX_SHADOW_DISABLED                          7051
#define ERROR_CTX_CLIENT_LICENSE_IN_USE                    7052
#define ERROR_CTX_CLIENT_LICENSE_NOT_SET                   7053
#define ERROR_CTX_LICENSE_NOT_AVAILABLE                    7054
#define ERROR_CTX_LICENSE_CLIENT_INVALID                   7055
#define ERROR_CTX_LICENSE_EXPIRED                          7056
#define ERROR_CTX_SHADOW_NOT_RUNNING                       7057
#define ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE              7058
#define FRS_ERR_INVALID_API_SEQUENCE                       8001
#define FRS_ERR_STARTING_SERVICE                           8002
#define FRS_ERR_STOPPING_SERVICE                           8003
#define FRS_ERR_INTERNAL_API                               8004
#define FRS_ERR_INTERNAL                                   8005
#define FRS_ERR_SERVICE_COMM                               8006
#define FRS_ERR_INSUFFICIENT_PRIV                          8007
#define FRS_ERR_AUTHENTICATION                             8008
#define FRS_ERR_PARENT_INSUFFICIENT_PRIV                   8009
#define FRS_ERR_PARENT_AUTHENTICATION                      8010
#define FRS_ERR_CHILD_TO_PARENT_COMM                       8011
#define FRS_ERR_PARENT_TO_CHILD_COMM                       8012
#define FRS_ERR_SYSVOL_POPULATE                            8013
#define FRS_ERR_SYSVOL_POPULATE_TIMEOUT                    8014
#define FRS_ERR_SYSVOL_IS_BUSY                             8015
#define FRS_ERR_SYSVOL_DEMOTE                              8016
#define FRS_ERR_INVALID_SERVICE_PARAMETER                  8017
#define ERROR_DS_NOT_INSTALLED                             8200
#define ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY              8201
#define ERROR_DS_NO_ATTRIBUTE_OR_VALUE                     8202
#define ERROR_DS_INVALID_ATTRIBUTE_SYNTAX                  8203
#define ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED                  8204
#define ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS                 8205
#define ERROR_DS_BUSY                                      8206
#define ERROR_DS_UNAVAILABLE                               8207
#define ERROR_DS_NO_RIDS_ALLOCATED                         8208
#define ERROR_DS_NO_MORE_RIDS                              8209
#define ERROR_DS_INCORRECT_ROLE_OWNER                      8210
#define ERROR_DS_RIDMGR_INIT_ERROR                         8211
#define ERROR_DS_OBJ_CLASS_VIOLATION                       8212
#define ERROR_DS_CANT_ON_NON_LEAF                          8213
#define ERROR_DS_CANT_ON_RDN                               8214
#define ERROR_DS_CANT_MOD_OBJ_CLASS                        8215
#define ERROR_DS_CROSS_DOM_MOVE_ERROR                      8216
#define ERROR_DS_GC_NOT_AVAILABLE                          8217
#define ERROR_SHARED_POLICY                                8218
#define ERROR_POLICY_OBJECT_NOT_FOUND                      8219
#define ERROR_POLICY_ONLY_IN_DS                            8220
#define ERROR_PROMOTION_ACTIVE                             8221
#define ERROR_NO_PROMOTION_ACTIVE                          8222
#define ERROR_DS_OPERATIONS_ERROR                          8224
#define ERROR_DS_PROTOCOL_ERROR                            8225
#define ERROR_DS_TIMELIMIT_EXCEEDED                        8226
#define ERROR_DS_SIZELIMIT_EXCEEDED                        8227
#define ERROR_DS_ADMIN_LIMIT_EXCEEDED                      8228
#define ERROR_DS_COMPARE_FALSE                             8229
#define ERROR_DS_COMPARE_TRUE                              8230
#define ERROR_DS_AUTH_METHOD_NOT_SUPPORTED                 8231
#define ERROR_DS_STRONG_AUTH_REQUIRED                      8232
#define ERROR_DS_INAPPROPRIATE_AUTH                        8233
#define ERROR_DS_AUTH_UNKNOWN                              8234
#define ERROR_DS_REFERRAL                                  8235
#define ERROR_DS_UNAVAILABLE_CRIT_EXTENSION                8236
#define ERROR_DS_CONFIDENTIALITY_REQUIRED                  8237
#define ERROR_DS_INAPPROPRIATE_MATCHING                    8238
#define ERROR_DS_CONSTRAINT_VIOLATION                      8239
#define ERROR_DS_NO_SUCH_OBJECT                            8240
#define ERROR_DS_ALIAS_PROBLEM                             8241
#define ERROR_DS_INVALID_DN_SYNTAX                         8242
#define ERROR_DS_IS_LEAF                                   8243
#define ERROR_DS_ALIAS_DEREF_PROBLEM                       8244
#define ERROR_DS_UNWILLING_TO_PERFORM                      8245
#define ERROR_DS_LOOP_DETECT                               8246
#define ERROR_DS_NAMING_VIOLATION                          8247
#define ERROR_DS_OBJECT_RESULTS_TOO_LARGE                  8248
#define ERROR_DS_AFFECTS_MULTIPLE_DSAS                     8249
#define ERROR_DS_SERVER_DOWN                               8250
#define ERROR_DS_LOCAL_ERROR                               8251
#define ERROR_DS_ENCODING_ERROR                            8252
#define ERROR_DS_DECODING_ERROR                            8253
#define ERROR_DS_FILTER_UNKNOWN                            8254
#define ERROR_DS_PARAM_ERROR                               8255
#define ERROR_DS_NOT_SUPPORTED                             8256
#define ERROR_DS_NO_RESULTS_RETURNED                       8257
#define ERROR_DS_CONTROL_NOT_FOUND                         8258
#define ERROR_DS_CLIENT_LOOP                               8259
#define ERROR_DS_REFERRAL_LIMIT_EXCEEDED                   8260
#define ERROR_DS_ROOT_MUST_BE_NC                           8301
#define ERROR_DS_ADD_REPLICA_INHIBITED                     8302
#define ERROR_DS_ATT_NOT_DEF_IN_SCHEMA                     8303
#define ERROR_DS_MAX_OBJ_SIZE_EXCEEDED                     8304
#define ERROR_DS_OBJ_STRING_NAME_EXISTS                    8305
#define ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA                  8306
#define ERROR_DS_RDN_DOESNT_MATCH_SCHEMA                   8307
#define ERROR_DS_NO_REQUESTED_ATTS_FOUND                   8308
#define ERROR_DS_USER_BUFFER_TO_SMALL                      8309
#define ERROR_DS_ATT_IS_NOT_ON_OBJ                         8310
#define ERROR_DS_ILLEGAL_MOD_OPERATION                     8311
#define ERROR_DS_OBJ_TOO_LARGE                             8312
#define ERROR_DS_BAD_INSTANCE_TYPE                         8313
#define ERROR_DS_MASTERDSA_REQUIRED                        8314
#define ERROR_DS_OBJECT_CLASS_REQUIRED                     8315
#define ERROR_DS_MISSING_REQUIRED_ATT                      8316
#define ERROR_DS_ATT_NOT_DEF_FOR_CLASS                     8317
#define ERROR_DS_ATT_ALREADY_EXISTS                        8318
#define ERROR_DS_CANT_ADD_ATT_VALUES                       8320
#define ERROR_DS_SINGLE_VALUE_CONSTRAINT                   8321
#define ERROR_DS_RANGE_CONSTRAINT                          8322
#define ERROR_DS_ATT_VAL_ALREADY_EXISTS                    8323
#define ERROR_DS_CANT_REM_MISSING_ATT                      8324
#define ERROR_DS_CANT_REM_MISSING_ATT_VAL                  8325
#define ERROR_DS_ROOT_CANT_BE_SUBREF                       8326
#define ERROR_DS_NO_CHAINING                               8327
#define ERROR_DS_NO_CHAINED_EVAL                           8328
#define ERROR_DS_NO_PARENT_OBJECT                          8329
#define ERROR_DS_PARENT_IS_AN_ALIAS                        8330
#define ERROR_DS_CANT_MIX_MASTER_AND_REPS                  8331
#define ERROR_DS_CHILDREN_EXIST                            8332
#define ERROR_DS_OBJ_NOT_FOUND                             8333
#define ERROR_DS_ALIASED_OBJ_MISSING                       8334
#define ERROR_DS_BAD_NAME_SYNTAX                           8335
#define ERROR_DS_ALIAS_POINTS_TO_ALIAS                     8336
#define ERROR_DS_CANT_DEREF_ALIAS                          8337
#define ERROR_DS_OUT_OF_SCOPE                              8338
#define ERROR_DS_CANT_DELETE_DSA_OBJ                       8340
#define ERROR_DS_GENERIC_ERROR                             8341
#define ERROR_DS_DSA_MUST_BE_INT_MASTER                    8342
#define ERROR_DS_CLASS_NOT_DSA                             8343
#define ERROR_DS_INSUFF_ACCESS_RIGHTS                      8344
#define ERROR_DS_ILLEGAL_SUPERIOR                          8345
#define ERROR_DS_ATTRIBUTE_OWNED_BY_SAM                    8346
#define ERROR_DS_NAME_TOO_MANY_PARTS                       8347
#define ERROR_DS_NAME_TOO_LONG                             8348
#define ERROR_DS_NAME_VALUE_TOO_LONG                       8349
#define ERROR_DS_NAME_UNPARSEABLE                          8350
#define ERROR_DS_NAME_TYPE_UNKNOWN                         8351
#define ERROR_DS_NOT_AN_OBJECT                             8352
#define ERROR_DS_SEC_DESC_TOO_SHORT                        8353
#define ERROR_DS_SEC_DESC_INVALID                          8354
#define ERROR_DS_NO_DELETED_NAME                           8355
#define ERROR_DS_SUBREF_MUST_HAVE_PARENT                   8356
#define ERROR_DS_NCNAME_MUST_BE_NC                         8357
#define ERROR_DS_CANT_ADD_SYSTEM_ONLY                      8358
#define ERROR_DS_CLASS_MUST_BE_CONCRETE                    8359
#define ERROR_DS_INVALID_DMD                               8360
#define ERROR_DS_OBJ_GUID_EXISTS                           8361
#define ERROR_DS_NOT_ON_BACKLINK                           8362
#define ERROR_DS_NO_CROSSREF_FOR_NC                        8363
#define ERROR_DS_SHUTTING_DOWN                             8364
#define ERROR_DS_UNKNOWN_OPERATION                         8365
#define ERROR_DS_INVALID_ROLE_OWNER                        8366
#define ERROR_DS_COULDNT_CONTACT_FSMO                      8367
#define ERROR_DS_CROSS_NC_DN_RENAME                        8368
#define ERROR_DS_CANT_MOD_SYSTEM_ONLY                      8369
#define ERROR_DS_REPLICATOR_ONLY                           8370
#define ERROR_DS_OBJ_CLASS_NOT_DEFINED                     8371
#define ERROR_DS_OBJ_CLASS_NOT_SUBCLASS                    8372
#define ERROR_DS_NAME_REFERENCE_INVALID                    8373
#define ERROR_DS_CROSS_REF_EXISTS                          8374
#define ERROR_DS_CANT_DEL_MASTER_CROSSREF                  8375
#define ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD                8376
#define ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX                 8377
#define ERROR_DS_DUP_RDN                                   8378
#define ERROR_DS_DUP_OID                                   8379
#define ERROR_DS_DUP_MAPI_ID                               8380
#define ERROR_DS_DUP_SCHEMA_ID_GUID                        8381
#define ERROR_DS_DUP_LDAP_DISPLAY_NAME                     8382
#define ERROR_DS_SEMANTIC_ATT_TEST                         8383
#define ERROR_DS_SYNTAX_MISMATCH                           8384
#define ERROR_DS_EXISTS_IN_MUST_HAVE                       8385
#define ERROR_DS_EXISTS_IN_MAY_HAVE                        8386
#define ERROR_DS_NONEXISTENT_MAY_HAVE                      8387
#define ERROR_DS_NONEXISTENT_MUST_HAVE                     8388
#define ERROR_DS_AUX_CLS_TEST_FAIL                         8389
#define ERROR_DS_NONEXISTENT_POSS_SUP                      8390
#define ERROR_DS_SUB_CLS_TEST_FAIL                         8391
#define ERROR_DS_BAD_RDN_ATT_ID_SYNTAX                     8392
#define ERROR_DS_EXISTS_IN_AUX_CLS                         8393
#define ERROR_DS_EXISTS_IN_SUB_CLS                         8394
#define ERROR_DS_EXISTS_IN_POSS_SUP                        8395
#define ERROR_DS_RECALCSCHEMA_FAILED                       8396
#define ERROR_DS_TREE_DELETE_NOT_FINISHED                  8397
#define ERROR_DS_CANT_DELETE                               8398
#define ERROR_DS_ATT_SCHEMA_REQ_ID                         8399
#define ERROR_DS_BAD_ATT_SCHEMA_SYNTAX                     8400
#define ERROR_DS_CANT_CACHE_ATT                            8401
#define ERROR_DS_CANT_CACHE_CLASS                          8402
#define ERROR_DS_CANT_REMOVE_ATT_CACHE                     8403
#define ERROR_DS_CANT_REMOVE_CLASS_CACHE                   8404
#define ERROR_DS_CANT_RETRIEVE_DN                          8405
#define ERROR_DS_MISSING_SUPREF                            8406
#define ERROR_DS_CANT_RETRIEVE_INSTANCE                    8407
#define ERROR_DS_CODE_INCONSISTENCY                        8408
#define ERROR_DS_DATABASE_ERROR                            8409
#define ERROR_DS_GOVERNSID_MISSING                         8410
#define ERROR_DS_MISSING_EXPECTED_ATT                      8411
#define ERROR_DS_NCNAME_MISSING_CR_REF                     8412
#define ERROR_DS_SECURITY_CHECKING_ERROR                   8413
#define ERROR_DS_SCHEMA_NOT_LOADED                         8414
#define ERROR_DS_SCHEMA_ALLOC_FAILED                       8415
#define ERROR_DS_ATT_SCHEMA_REQ_SYNTAX                     8416
#define ERROR_DS_GCVERIFY_ERROR                            8417
#define ERROR_DS_DRA_SCHEMA_MISMATCH                       8418
#define ERROR_DS_CANT_FIND_DSA_OBJ                         8419
#define ERROR_DS_CANT_FIND_EXPECTED_NC                     8420
#define ERROR_DS_CANT_FIND_NC_IN_CACHE                     8421
#define ERROR_DS_CANT_RETRIEVE_CHILD                       8422
#define ERROR_DS_SECURITY_ILLEGAL_MODIFY                   8423
#define ERROR_DS_CANT_REPLACE_HIDDEN_REC                   8424
#define ERROR_DS_BAD_HIERARCHY_FILE                        8425
#define ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED              8426
#define ERROR_DS_CONFIG_PARAM_MISSING                      8427
#define ERROR_DS_COUNTING_AB_INDICES_FAILED                8428
#define ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED             8429
#define ERROR_DS_INTERNAL_FAILURE                          8430
#define ERROR_DS_UNKNOWN_ERROR                             8431
#define ERROR_DS_ROOT_REQUIRES_CLASS_TOP                   8432
#define ERROR_DS_REFUSING_FSMO_ROLES                       8433
#define ERROR_DS_MISSING_FSMO_SETTINGS                     8434
#define ERROR_DS_UNABLE_TO_SURRENDER_ROLES                 8435
#define ERROR_DS_DRA_GENERIC                               8436
#define ERROR_DS_DRA_INVALID_PARAMETER                     8437
#define ERROR_DS_DRA_BUSY                                  8438
#define ERROR_DS_DRA_BAD_DN                                8439
#define ERROR_DS_DRA_BAD_NC                                8440
#define ERROR_DS_DRA_DN_EXISTS                             8441
#define ERROR_DS_DRA_INTERNAL_ERROR                        8442
#define ERROR_DS_DRA_INCONSISTENT_DIT                      8443
#define ERROR_DS_DRA_CONNECTION_FAILED                     8444
#define ERROR_DS_DRA_BAD_INSTANCE_TYPE                     8445
#define ERROR_DS_DRA_OUT_OF_MEM                            8446
#define ERROR_DS_DRA_MAIL_PROBLEM                          8447
#define ERROR_DS_DRA_REF_ALREADY_EXISTS                    8448
#define ERROR_DS_DRA_REF_NOT_FOUND                         8449
#define ERROR_DS_DRA_OBJ_IS_REP_SOURCE                     8450
#define ERROR_DS_DRA_DB_ERROR                              8451
#define ERROR_DS_DRA_NO_REPLICA                            8452
#define ERROR_DS_DRA_ACCESS_DENIED                         8453
#define ERROR_DS_DRA_NOT_SUPPORTED                         8454
#define ERROR_DS_DRA_RPC_CANCELLED                         8455
#define ERROR_DS_DRA_SOURCE_DISABLED                       8456
#define ERROR_DS_DRA_SINK_DISABLED                         8457
#define ERROR_DS_DRA_NAME_COLLISION                        8458
#define ERROR_DS_DRA_SOURCE_REINSTALLED                    8459
#define ERROR_DS_DRA_MISSING_PARENT                        8460
#define ERROR_DS_DRA_PREEMPTED                             8461
#define ERROR_DS_DRA_ABANDON_SYNC                          8462
#define ERROR_DS_DRA_SHUTDOWN                              8463
#define ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET              8464
#define ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA             8465
#define ERROR_DS_DRA_EXTN_CONNECTION_FAILED                8466
#define ERROR_DS_INSTALL_SCHEMA_MISMATCH                   8467
#define ERROR_DS_DUP_LINK_ID                               8468
#define ERROR_DS_NAME_ERROR_RESOLVING                      8469
#define ERROR_DS_NAME_ERROR_NOT_FOUND                      8470
#define ERROR_DS_NAME_ERROR_NOT_UNIQUE                     8471
#define ERROR_DS_NAME_ERROR_NO_MAPPING                     8472
#define ERROR_DS_NAME_ERROR_DOMAIN_ONLY                    8473
#define ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING         8474
#define ERROR_DS_CONSTRUCTED_ATT_MOD                       8475
#define ERROR_DS_WRONG_OM_OBJ_CLASS                        8476
#define ERROR_DS_DRA_REPL_PENDING                          8477
#define ERROR_DS_DS_REQUIRED                               8478
#define ERROR_DS_INVALID_LDAP_DISPLAY_NAME                 8479
#define ERROR_DS_NON_BASE_SEARCH                           8480
#define ERROR_DS_CANT_RETRIEVE_ATTS                        8481
#define ERROR_DS_BACKLINK_WITHOUT_LINK                     8482
#define ERROR_DS_EPOCH_MISMATCH                            8483
#define ERROR_DS_SRC_NAME_MISMATCH                         8484
#define ERROR_DS_SRC_AND_DST_NC_IDENTICAL                  8485
#define ERROR_DS_DST_NC_MISMATCH                           8486
#define ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC                8487
#define ERROR_DS_SRC_GUID_MISMATCH                         8488
#define ERROR_DS_CANT_MOVE_DELETED_OBJECT                  8489
#define ERROR_DS_PDC_OPERATION_IN_PROGRESS                 8490
#define ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD                 8491
#define ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION               8492
#define ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS           8493
#define ERROR_DS_NC_MUST_HAVE_NC_PARENT                    8494
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE                 8495
#define ERROR_DS_DST_DOMAIN_NOT_NATIVE                     8496
#define ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER          8497
#define ERROR_DS_CANT_MOVE_ACCOUNT_GROUP                   8498
#define ERROR_DS_CANT_MOVE_RESOURCE_GROUP                  8499
#define ERROR_DS_INVALID_SEARCH_FLAG                       8500
#define ERROR_DS_NO_TREE_DELETE_ABOVE_NC                   8501
#define ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE              8502
#define ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE  8503
#define ERROR_DS_SAM_INIT_FAILURE                          8504
#define ERROR_DS_SENSITIVE_GROUP_VIOLATION                 8505
#define ERROR_DS_CANT_MOD_PRIMARYGROUPID                   8506
#define ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD                   8507
#define ERROR_DS_NONSAFE_SCHEMA_CHANGE                     8508
#define ERROR_DS_SCHEMA_UPDATE_DISALLOWED                  8509
#define ERROR_DS_CANT_CREATE_UNDER_SCHEMA                  8510
#define ERROR_DS_INSTALL_NO_SRC_SCH_VERSION                8511
#define ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE         8512
#define ERROR_DS_INVALID_GROUP_TYPE                        8513
#define ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN        8514
#define ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN         8515
#define ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER             8516
#define ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER         8517
#define ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER          8518
#define ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER       8519
#define ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER  8520
#define ERROR_DS_HAVE_PRIMARY_MEMBERS                      8521
#define ERROR_DS_STRING_SD_CONVERSION_FAILED               8522
#define ERROR_DS_NAMING_MASTER_GC                          8523
#define ERROR_DS_LOOKUP_FAILURE                            8524
#define ERROR_DS_COULDNT_UPDATE_SPNS                       8525
#define ERROR_DS_CANT_RETRIEVE_SD                          8526
#define ERROR_DS_KEY_NOT_UNIQUE                            8527
#define ERROR_DS_WRONG_LINKED_ATT_SYNTAX                   8528
#define ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD                 8529
#define ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY                   8530
#define ERROR_DS_CANT_START                                8531
#define ERROR_DS_INIT_FAILURE                              8532
#define ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION              8533
#define ERROR_DS_SOURCE_DOMAIN_IN_FOREST                   8534
#define ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST          8535
#define ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED          8536
#define ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN               8537
#define ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER                 8538
#define ERROR_DS_SRC_SID_EXISTS_IN_FOREST                  8539
#define ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH         8540
#define ERROR_SAM_INIT_FAILURE                             8541
#define ERROR_DS_DRA_SCHEMA_INFO_SHIP                      8542
#define ERROR_DS_DRA_SCHEMA_CONFLICT                       8543
#define ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT                8544
#define ERROR_DS_DRA_OBJ_NC_MISMATCH                       8545
#define ERROR_DS_NC_STILL_HAS_DSAS                         8546
#define ERROR_DS_GC_REQUIRED                               8547
#define ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY                8548
#define ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS                8549
#define ERROR_DS_CANT_ADD_TO_GC                            8550
#define ERROR_DS_NO_CHECKPOINT_WITH_PDC                    8551
#define ERROR_DS_SOURCE_AUDITING_NOT_ENABLED               8552
#define ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC               8553
#define ERROR_DS_INVALID_NAME_FOR_SPN                      8554
#define ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS              8555
#define ERROR_DS_UNICODEPWD_NOT_IN_QUOTES                  8556
#define ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED            8557
#define ERROR_DS_MUST_BE_RUN_ON_DST_DC                     8558
#define ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER             8559
#define ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ             8560
#define ERROR_DS_INIT_FAILURE_CONSOLE                      8561
#define ERROR_DS_SAM_INIT_FAILURE_CONSOLE                  8562
#define ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4            8572
#define ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER             8578
#define DNS_ERROR_RCODE_FORMAT_ERROR                       9001
#define DNS_ERROR_RCODE_SERVER_FAILURE                     9002
#define DNS_ERROR_RCODE_NAME_ERROR                         9003
#define DNS_ERROR_RCODE_NOT_IMPLEMENTED                    9004
#define DNS_ERROR_RCODE_REFUSED                            9005
#define DNS_ERROR_RCODE_YXDOMAIN                           9006
#define DNS_ERROR_RCODE_YXRRSET                            9007
#define DNS_ERROR_RCODE_NXRRSET                            9008
#define DNS_ERROR_RCODE_NOTAUTH                            9009
#define DNS_ERROR_RCODE_NOTZONE                            9010
#define DNS_ERROR_RCODE_BADSIG                             9016
#define DNS_ERROR_RCODE_BADKEY                             9017
#define DNS_ERROR_RCODE_BADTIME                            9018
#define DNS_INFO_NO_RECORDS                                9501
#define DNS_ERROR_BAD_PACKET                               9502
#define DNS_ERROR_NO_PACKET                                9503
#define DNS_ERROR_RCODE                                    9504
#define DNS_ERROR_UNSECURE_PACKET                          9505
#define DNS_ERROR_INVALID_TYPE                             9551
#define DNS_ERROR_INVALID_IP_ADDRESS                       9552
#define DNS_ERROR_INVALID_PROPERTY                         9553
#define DNS_ERROR_TRY_AGAIN_LATER                          9554
#define DNS_ERROR_NOT_UNIQUE                               9555
#define DNS_ERROR_NON_RFC_NAME                             9556
#define DNS_STATUS_FQDN                                    9557
#define DNS_STATUS_DOTTED_NAME                             9558
#define DNS_STATUS_SINGLE_PART_NAME                        9559
#define DNS_ERROR_INVALID_NAME_CHAR                        9560
#define DNS_ERROR_NUMERIC_NAME                             9561
#define DNS_ERROR_ZONE_DOES_NOT_EXIST                      9601
#define DNS_ERROR_NO_ZONE_INFO                             9602
#define DNS_ERROR_INVALID_ZONE_OPERATION                   9603
#define DNS_ERROR_ZONE_CONFIGURATION_ERROR                 9604
#define DNS_ERROR_ZONE_HAS_NO_SOA_RECORD                   9605
#define DNS_ERROR_ZONE_HAS_NO_NS_RECORDS                   9606
#define DNS_ERROR_ZONE_LOCKED                              9607
#define DNS_ERROR_ZONE_CREATION_FAILED                     9608
#define DNS_ERROR_ZONE_ALREADY_EXISTS                      9609
#define DNS_ERROR_AUTOZONE_ALREADY_EXISTS                  9610
#define DNS_ERROR_INVALID_ZONE_TYPE                        9611
#define DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP             9612
#define DNS_ERROR_ZONE_NOT_SECONDARY                       9613
#define DNS_ERROR_NEED_SECONDARY_ADDRESSES                 9614
#define DNS_ERROR_WINS_INIT_FAILED                         9615
#define DNS_ERROR_NEED_WINS_SERVERS                        9616
#define DNS_ERROR_NBSTAT_INIT_FAILED                       9617
#define DNS_ERROR_SOA_DELETE_INVALID                       9618
#define DNS_ERROR_PRIMARY_REQUIRES_DATAFILE                9651
#define DNS_ERROR_INVALID_DATAFILE_NAME                    9652
#define DNS_ERROR_DATAFILE_OPEN_FAILURE                    9653
#define DNS_ERROR_FILE_WRITEBACK_FAILED                    9654
#define DNS_ERROR_DATAFILE_PARSING                         9655
#define DNS_ERROR_RECORD_DOES_NOT_EXIST                    9701
#define DNS_ERROR_RECORD_FORMAT                            9702
#define DNS_ERROR_NODE_CREATION_FAILED                     9703
#define DNS_ERROR_UNKNOWN_RECORD_TYPE                      9704
#define DNS_ERROR_RECORD_TIMED_OUT                         9705
#define DNS_ERROR_NAME_NOT_IN_ZONE                         9706
#define DNS_ERROR_CNAME_LOOP                               9707
#define DNS_ERROR_NODE_IS_CNAME                            9708
#define DNS_ERROR_CNAME_COLLISION                          9709
#define DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT                 9710
#define DNS_ERROR_RECORD_ALREADY_EXISTS                    9711
#define DNS_ERROR_SECONDARY_DATA                           9712
#define DNS_ERROR_NO_CREATE_CACHE_DATA                     9713
#define DNS_ERROR_NAME_DOES_NOT_EXIST                      9714
#define DNS_WARNING_PTR_CREATE_FAILED                      9715
#define DNS_WARNING_DOMAIN_UNDELETED                       9716
#define DNS_ERROR_DS_UNAVAILABLE                           9717
#define DNS_ERROR_DS_ZONE_ALREADY_EXISTS                   9718
#define DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE                   9719
#define DNS_INFO_AXFR_COMPLETE                             9751
#define DNS_ERROR_AXFR                                     9752
#define DNS_INFO_ADDED_LOCAL_WINS                          9753
#define DNS_STATUS_CONTINUE_NEEDED                         9801
#define DNS_ERROR_NO_TCPIP                                 9851
#define DNS_ERROR_NO_DNS_SERVERS                           9852
#define ERROR_SXS_SECTION_NOT_FOUND                        14000
#define ERROR_SXS_CANT_GEN_ACTCTX                          14001
#define ERROR_SXS_INVALID_ACTCTXDATA_FORMAT                14002
#define ERROR_SXS_ASSEMBLY_NOT_FOUND                       14003
#define ERROR_SXS_MANIFEST_FORMAT_ERROR                    14004
#define ERROR_SXS_MANIFEST_PARSE_ERROR                     14005
#define ERROR_SXS_ACTIVATION_CONTEXT_DISABLED              14006
#define ERROR_SXS_KEY_NOT_FOUND                            14007
#define ERROR_SXS_WRONG_SECTION_TYPE                       14009
#define ERROR_SXS_THREAD_QUERIES_DISABLED                  14010
#define ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET              14011

/* HRESULT values for OLE, SHELL and other Interface stuff */
/* the codes 4000-40ff are reserved for OLE */
#undef NOERROR  /* arpa/nameser_compat.h defines this */

#ifdef RC_INVOKED
#define _HRESULT_TYPEDEF_(x) (x)
#else
#define _HRESULT_TYPEDEF_(x) ((HRESULT)x)
#endif

#define NOERROR                                            _HRESULT_TYPEDEF_(0L)
#define S_OK                                               _HRESULT_TYPEDEF_(0L)
#define SEC_E_OK                                           _HRESULT_TYPEDEF_(0L)
#define S_FALSE                                            _HRESULT_TYPEDEF_(1L)

#define E_PENDING                                          _HRESULT_TYPEDEF_(0x8000000AL)


#define E_NOTIMPL                                          _HRESULT_TYPEDEF_(0x80004001L)
#define E_NOINTERFACE                                      _HRESULT_TYPEDEF_(0x80004002L)
#define E_POINTER                                          _HRESULT_TYPEDEF_(0x80004003L)
#define E_ABORT                                            _HRESULT_TYPEDEF_(0x80004004L)
#define E_FAIL                                             _HRESULT_TYPEDEF_(0x80004005L)


#define CO_E_INIT_TLS                                      _HRESULT_TYPEDEF_(0x80004006L)
#define CO_E_INIT_SHARED_ALLOCATOR                         _HRESULT_TYPEDEF_(0x80004007L)
#define CO_E_INIT_MEMORY_ALLOCATOR                         _HRESULT_TYPEDEF_(0x80004008L)
#define CO_E_INIT_CLASS_CACHE                              _HRESULT_TYPEDEF_(0x80004009L)
#define CO_E_INIT_RPC_CHANNEL                              _HRESULT_TYPEDEF_(0x8000400AL)
#define CO_E_INIT_TLS_SET_CHANNEL_CONTROL                  _HRESULT_TYPEDEF_(0x8000400BL)
#define CO_E_INIT_TLS_CHANNEL_CONTROL                      _HRESULT_TYPEDEF_(0x8000400CL)
#define CO_E_INIT_UNACCEPTED_USER_ALLOCATOR                _HRESULT_TYPEDEF_(0x8000400DL)
#define CO_E_INIT_SCM_MUTEX_EXISTS                         _HRESULT_TYPEDEF_(0x8000400EL)
#define CO_E_INIT_SCM_FILE_MAPPING_EXISTS                  _HRESULT_TYPEDEF_(0x8000400FL)
#define CO_E_INIT_SCM_MAP_VIEW_OF_FILE                     _HRESULT_TYPEDEF_(0x80004010L)
#define CO_E_INIT_SCM_EXEC_FAILURE                         _HRESULT_TYPEDEF_(0x80004011L)
#define CO_E_INIT_ONLY_SINGLE_THREADED                     _HRESULT_TYPEDEF_(0x80004012L)
#define CO_E_CANT_REMOTE                                   _HRESULT_TYPEDEF_(0x80004013L)
#define CO_E_BAD_SERVER_NAME                               _HRESULT_TYPEDEF_(0x80004014L)
#define CO_E_WRONG_SERVER_IDENTITY                         _HRESULT_TYPEDEF_(0x80004015L)
#define CO_E_OLE1DDE_DISABLED                              _HRESULT_TYPEDEF_(0x80004016L)
#define CO_E_RUNAS_SYNTAX                                  _HRESULT_TYPEDEF_(0x80004017L)
#define CO_E_CREATEPROCESS_FAILURE                         _HRESULT_TYPEDEF_(0x80004018L)
#define CO_E_RUNAS_CREATEPROCESS_FAILURE                   _HRESULT_TYPEDEF_(0x80004019L)
#define CO_E_RUNAS_LOGON_FAILURE                           _HRESULT_TYPEDEF_(0x8000401AL)
#define CO_E_LAUNCH_PERMISSION_DENIED                      _HRESULT_TYPEDEF_(0x8000401BL)
#define CO_E_START_SERVICE_FAILURE                         _HRESULT_TYPEDEF_(0x8000401CL)
#define CO_E_REMOTE_COMMUNICATION_FAILURE                  _HRESULT_TYPEDEF_(0x8000401DL)
#define CO_E_SERVER_START_TIMEOUT                          _HRESULT_TYPEDEF_(0x8000401EL)
#define CO_E_CLSREG_INCONSISTENT                           _HRESULT_TYPEDEF_(0x8000401FL)
#define CO_E_IIDREG_INCONSISTENT                           _HRESULT_TYPEDEF_(0x80004020L)
#define CO_E_NOT_SUPPORTED                                 _HRESULT_TYPEDEF_(0x80004021L)
#define CO_E_RELOAD_DLL                                    _HRESULT_TYPEDEF_(0x80004022L)
#define CO_E_MSI_ERROR                                     _HRESULT_TYPEDEF_(0x80004023L)
#define CO_E_ATTEMPT_TO_CREATE_OUTSIDE_CLIENT_CONTEXT      _HRESULT_TYPEDEF_(0x80004024L)
#define CO_E_SERVER_PAUSED                                 _HRESULT_TYPEDEF_(0x80004025L)
#define CO_E_SERVER_NOT_PAUSED                             _HRESULT_TYPEDEF_(0x80004026L)
#define CO_E_CLASS_DISABLED                                _HRESULT_TYPEDEF_(0x80004027L)
#define CO_E_CLRNOTAVAILABLE                               _HRESULT_TYPEDEF_(0x80004028L)
#define CO_E_ASYNC_WORK_REJECTED                           _HRESULT_TYPEDEF_(0x80004029L)
#define CO_E_SERVER_INIT_TIMEOUT                           _HRESULT_TYPEDEF_(0x8000402AL)
#define CO_E_NO_SECCTX_IN_ACTIVATE                         _HRESULT_TYPEDEF_(0x8000402BL)
#define CO_E_TRACKER_CONFIG                                _HRESULT_TYPEDEF_(0x80004030L)
#define CO_E_THREADPOOL_CONFIG                             _HRESULT_TYPEDEF_(0x80004031L)
#define CO_E_SXS_CONFIG                                    _HRESULT_TYPEDEF_(0x80004032L)
#define CO_E_MALFORMED_SPN                                 _HRESULT_TYPEDEF_(0x80004033L)

#define E_UNEXPECTED                                       _HRESULT_TYPEDEF_(0x8000FFFFL)

#define RPC_E_CALL_REJECTED                                _HRESULT_TYPEDEF_(0x80010001L)
#define RPC_E_CALL_CANCELED                                _HRESULT_TYPEDEF_(0x80010002L)
#define RPC_E_CANTPOST_INSENDCALL                          _HRESULT_TYPEDEF_(0x80010003L)
#define RPC_E_CANTCALLOUT_INASYNCCALL                      _HRESULT_TYPEDEF_(0x80010004L)
#define RPC_E_CANTCALLOUT_INEXTERNALCALL                   _HRESULT_TYPEDEF_(0x80010005L)
#define RPC_E_CONNECTION_TERMINATED                        _HRESULT_TYPEDEF_(0x80010006L)
#define RPC_E_SERVER_DIED                                  _HRESULT_TYPEDEF_(0x80010007L)
#define RPC_E_CLIENT_DIED                                  _HRESULT_TYPEDEF_(0x80010008L)
#define RPC_E_INVALID_DATAPACKET                           _HRESULT_TYPEDEF_(0x80010009L)
#define RPC_E_CANTTRANSMIT_CALL                            _HRESULT_TYPEDEF_(0x8001000AL)
#define RPC_E_CLIENT_CANTMARSHAL_DATA                      _HRESULT_TYPEDEF_(0x8001000BL)
#define RPC_E_CLIENT_CANTUNMARSHAL_DATA                    _HRESULT_TYPEDEF_(0x8001000CL)
#define RPC_E_SERVER_CANTMARSHAL_DATA                      _HRESULT_TYPEDEF_(0x8001000DL)
#define RPC_E_SERVER_CANTUNMARSHAL_DATA                    _HRESULT_TYPEDEF_(0x8001000EL)
#define RPC_E_INVALID_DATA                                 _HRESULT_TYPEDEF_(0x8001000FL)
#define RPC_E_INVALID_PARAMETER                            _HRESULT_TYPEDEF_(0x80010010L)
#define RPC_E_CANTCALLOUT_AGAIN                            _HRESULT_TYPEDEF_(0x80010011L)
#define RPC_E_SERVER_DIED_DNE                              _HRESULT_TYPEDEF_(0x80010012L)
#define RPC_E_SYS_CALL_FAILED                              _HRESULT_TYPEDEF_(0x80010100L)
#define RPC_E_OUT_OF_RESOURCES                             _HRESULT_TYPEDEF_(0x80010101L)
#define RPC_E_ATTEMPTED_MULTITHREAD                        _HRESULT_TYPEDEF_(0x80010102L)
#define RPC_E_NOT_REGISTERED                               _HRESULT_TYPEDEF_(0x80010103L)
#define RPC_E_FAULT                                        _HRESULT_TYPEDEF_(0x80010104L)
#define RPC_E_SERVERFAULT                                  _HRESULT_TYPEDEF_(0x80010105L)
#define RPC_E_CHANGED_MODE                                 _HRESULT_TYPEDEF_(0x80010106L)
#define RPC_E_INVALIDMETHOD                                _HRESULT_TYPEDEF_(0x80010107L)
#define RPC_E_DISCONNECTED                                 _HRESULT_TYPEDEF_(0x80010108L)
#define RPC_E_RETRY                                        _HRESULT_TYPEDEF_(0x80010109L)
#define RPC_E_SERVERCALL_RETRYLATER                        _HRESULT_TYPEDEF_(0x8001010AL)
#define RPC_E_SERVERCALL_REJECTED                          _HRESULT_TYPEDEF_(0x8001010BL)
#define RPC_E_INVALID_CALLDATA                             _HRESULT_TYPEDEF_(0x8001010CL)
#define RPC_E_CANTCALLOUT_ININPUTSYNCCALL                  _HRESULT_TYPEDEF_(0x8001010DL)
#define RPC_E_WRONG_THREAD                                 _HRESULT_TYPEDEF_(0x8001010EL)
#define RPC_E_THREAD_NOT_INIT                              _HRESULT_TYPEDEF_(0x8001010FL)
#define RPC_E_VERSION_MISMATCH                             _HRESULT_TYPEDEF_(0x80010110L)
#define RPC_E_INVALID_HEADER                               _HRESULT_TYPEDEF_(0x80010111L)
#define RPC_E_INVALID_EXTENSION                            _HRESULT_TYPEDEF_(0x80010112L)
#define RPC_E_INVALID_IPID                                 _HRESULT_TYPEDEF_(0x80010113L)
#define RPC_E_INVALID_OBJECT                               _HRESULT_TYPEDEF_(0x80010114L)
#define RPC_S_CALLPENDING                                  _HRESULT_TYPEDEF_(0x80010115L)
#define RPC_S_WAITONTIMER                                  _HRESULT_TYPEDEF_(0x80010116L)
#define RPC_E_CALL_COMPLETE                                _HRESULT_TYPEDEF_(0x80010117L)
#define RPC_E_UNSECURE_CALL                                _HRESULT_TYPEDEF_(0x80010118L)
#define RPC_E_TOO_LATE                                     _HRESULT_TYPEDEF_(0x80010119L)
#define RPC_E_NO_GOOD_SECURITY_PACKAGES                    _HRESULT_TYPEDEF_(0x8001011AL)
#define RPC_E_ACCESS_DENIED                                _HRESULT_TYPEDEF_(0x8001011BL)
#define RPC_E_REMOTE_DISABLED                              _HRESULT_TYPEDEF_(0x8001011CL)
#define RPC_E_INVALID_OBJREF                               _HRESULT_TYPEDEF_(0x8001011DL)
#define RPC_E_NO_CONTEXT                                   _HRESULT_TYPEDEF_(0x8001011EL)
#define RPC_E_TIMEOUT                                      _HRESULT_TYPEDEF_(0x8001011FL)
#define RPC_E_NO_SYNC                                      _HRESULT_TYPEDEF_(0x80010120L)
#define RPC_E_UNEXPECTED                                   _HRESULT_TYPEDEF_(0x8001FFFFL)

#define DISP_E_UNKNOWNINTERFACE                            _HRESULT_TYPEDEF_(0x80020001L)
#define DISP_E_MEMBERNOTFOUND                              _HRESULT_TYPEDEF_(0x80020003L)
#define DISP_E_PARAMNOTFOUND                               _HRESULT_TYPEDEF_(0x80020004L)
#define DISP_E_TYPEMISMATCH                                _HRESULT_TYPEDEF_(0x80020005L)
#define DISP_E_UNKNOWNNAME                                 _HRESULT_TYPEDEF_(0x80020006L)
#define DISP_E_NONAMEDARGS                                 _HRESULT_TYPEDEF_(0x80020007L)
#define DISP_E_BADVARTYPE                                  _HRESULT_TYPEDEF_(0x80020008L)
#define DISP_E_EXCEPTION                                   _HRESULT_TYPEDEF_(0x80020009L)
#define DISP_E_OVERFLOW                                    _HRESULT_TYPEDEF_(0x8002000AL)
#define DISP_E_BADINDEX                                    _HRESULT_TYPEDEF_(0x8002000BL)
#define DISP_E_UNKNOWNLCID                                 _HRESULT_TYPEDEF_(0x8002000CL)
#define DISP_E_ARRAYISLOCKED                               _HRESULT_TYPEDEF_(0x8002000DL)
#define DISP_E_BADPARAMCOUNT                               _HRESULT_TYPEDEF_(0x8002000EL)
#define DISP_E_PARAMNOTOPTIONAL                            _HRESULT_TYPEDEF_(0x8002000FL)
#define DISP_E_BADCALLEE                                   _HRESULT_TYPEDEF_(0x80020010L)
#define DISP_E_NOTACOLLECTION                              _HRESULT_TYPEDEF_(0x80020011L)
#define DISP_E_DIVBYZERO                                   _HRESULT_TYPEDEF_(0x80020012L)

#define TYPE_E_BUFFERTOOSMALL                              _HRESULT_TYPEDEF_(0x80028016L)
#define TYPE_E_FIELDNOTFOUND                               _HRESULT_TYPEDEF_(0x80028017L)
#define TYPE_E_INVDATAREAD                                 _HRESULT_TYPEDEF_(0x80028018L)
#define TYPE_E_UNSUPFORMAT                                 _HRESULT_TYPEDEF_(0x80028019L)
#define TYPE_E_REGISTRYACCESS                              _HRESULT_TYPEDEF_(0x8002801CL)
#define TYPE_E_LIBNOTREGISTERED                            _HRESULT_TYPEDEF_(0x8002801DL)
#define TYPE_E_UNDEFINEDTYPE                               _HRESULT_TYPEDEF_(0x80028027L)
#define TYPE_E_QUALIFIEDNAMEDISALLOWED                     _HRESULT_TYPEDEF_(0x80028028L)
#define TYPE_E_INVALIDSTATE                                _HRESULT_TYPEDEF_(0x80028029L)
#define TYPE_E_WRONGTYPEKIND                               _HRESULT_TYPEDEF_(0x8002802AL)
#define TYPE_E_ELEMENTNOTFOUND                             _HRESULT_TYPEDEF_(0x8002802BL)
#define TYPE_E_AMBIGUOUSNAME                               _HRESULT_TYPEDEF_(0x8002802CL)
#define TYPE_E_NAMECONFLICT                                _HRESULT_TYPEDEF_(0x8002802DL)
#define TYPE_E_UNKNOWNLCID                                 _HRESULT_TYPEDEF_(0x8002802EL)
#define TYPE_E_DLLFUNCTIONNOTFOUND                         _HRESULT_TYPEDEF_(0x8002802FL)
#define TYPE_E_BADMODULEKIND                               _HRESULT_TYPEDEF_(0x800288BDL)
#define TYPE_E_SIZETOOBIG                                  _HRESULT_TYPEDEF_(0x800288C5L)
#define TYPE_E_DUPLICATEID                                 _HRESULT_TYPEDEF_(0x800288C6L)
#define TYPE_E_INVALIDID                                   _HRESULT_TYPEDEF_(0x800288CFL)
#define TYPE_E_TYPEMISMATCH                                _HRESULT_TYPEDEF_(0x80028CA0L)
#define TYPE_E_OUTOFBOUNDS                                 _HRESULT_TYPEDEF_(0x80028CA1L)
#define TYPE_E_IOERROR                                     _HRESULT_TYPEDEF_(0x80028CA2L)
#define TYPE_E_CANTCREATETMPFILE                           _HRESULT_TYPEDEF_(0x80028CA3L)
#define TYPE_E_CANTLOADLIBRARY                             _HRESULT_TYPEDEF_(0x80029C4AL)
#define TYPE_E_INCONSISTENTPROPFUNCS                       _HRESULT_TYPEDEF_(0x80029C83L)
#define TYPE_E_CIRCULARTYPE                                _HRESULT_TYPEDEF_(0x80029C84L)

#define STG_S_CONVERTED                                    _HRESULT_TYPEDEF_(0x00030200L)
#define STG_S_BLOCK                                        _HRESULT_TYPEDEF_(0x00030201L)
#define STG_S_RETRYNOW                                     _HRESULT_TYPEDEF_(0x00030202L)
#define STG_S_MONITORING                                   _HRESULT_TYPEDEF_(0x00030203L)
#define STG_S_MULTIPLEOPENS                                _HRESULT_TYPEDEF_(0x00030204L)
#define STG_S_CONSOLIDATIONFAILED                          _HRESULT_TYPEDEF_(0x00030205L)
#define STG_S_CANNOTCONSOLIDATE                            _HRESULT_TYPEDEF_(0x00030206L)

#define STG_E_INVALIDFUNCTION                              _HRESULT_TYPEDEF_(0x80030001L)
#define STG_E_FILENOTFOUND                                 _HRESULT_TYPEDEF_(0x80030002L)
#define STG_E_PATHNOTFOUND                                 _HRESULT_TYPEDEF_(0x80030003L)
#define STG_E_TOOMANYOPENFILES                             _HRESULT_TYPEDEF_(0x80030004L)
#define STG_E_ACCESSDENIED                                 _HRESULT_TYPEDEF_(0x80030005L)
#define STG_E_INVALIDHANDLE                                _HRESULT_TYPEDEF_(0x80030006L)
#define STG_E_INSUFFICIENTMEMORY                           _HRESULT_TYPEDEF_(0x80030008L)
#define STG_E_INVALIDPOINTER                               _HRESULT_TYPEDEF_(0x80030009L)
#define STG_E_NOMOREFILES                                  _HRESULT_TYPEDEF_(0x80030012L)
#define STG_E_DISKISWRITEPROTECTED                         _HRESULT_TYPEDEF_(0x80030013L)
#define STG_E_SEEKERROR                                    _HRESULT_TYPEDEF_(0x80030019L)
#define STG_E_WRITEFAULT                                   _HRESULT_TYPEDEF_(0x8003001DL)
#define STG_E_READFAULT                                    _HRESULT_TYPEDEF_(0x8003001EL)
#define STG_E_SHAREVIOLATION                               _HRESULT_TYPEDEF_(0x80030020L)
#define STG_E_LOCKVIOLATION                                _HRESULT_TYPEDEF_(0x80030021L)
#define STG_E_FILEALREADYEXISTS                            _HRESULT_TYPEDEF_(0x80030050L)
#define STG_E_INVALIDPARAMETER                             _HRESULT_TYPEDEF_(0x80030057L)
#define STG_E_MEDIUMFULL                                   _HRESULT_TYPEDEF_(0x80030070L)
#define STG_E_ABNORMALAPIEXIT                              _HRESULT_TYPEDEF_(0x800300FAL)
#define STG_E_INVALIDHEADER                                _HRESULT_TYPEDEF_(0x800300FBL)
#define STG_E_INVALIDNAME                                  _HRESULT_TYPEDEF_(0x800300FCL)
#define STG_E_UNKNOWN                                      _HRESULT_TYPEDEF_(0x800300FDL)
#define STG_E_UNIMPLEMENTEDFUNCTION                        _HRESULT_TYPEDEF_(0x800300FEL)
#define STG_E_INVALIDFLAG                                  _HRESULT_TYPEDEF_(0x800300FFL)
#define STG_E_INUSE                                        _HRESULT_TYPEDEF_(0x80030100L)
#define STG_E_NOTCURRENT                                   _HRESULT_TYPEDEF_(0x80030101L)
#define STG_E_REVERTED                                     _HRESULT_TYPEDEF_(0x80030102L)
#define STG_E_CANTSAVE                                     _HRESULT_TYPEDEF_(0x80030103L)
#define STG_E_OLDFORMAT                                    _HRESULT_TYPEDEF_(0x80030104L)
#define STG_E_OLDDLL                                       _HRESULT_TYPEDEF_(0x80030105L)
#define STG_E_SHAREREQUIRED                                _HRESULT_TYPEDEF_(0x80030106L)
#define STG_E_NOTFILEBASEDSTORAGE                          _HRESULT_TYPEDEF_(0x80030107L)
#define STG_E_EXTANTMARSHALLINGS                           _HRESULT_TYPEDEF_(0x80030108L)
#define STG_E_DOCFILECORRUPT                               _HRESULT_TYPEDEF_(0x80030109L)

#define STG_E_STATUS_COPY_PROTECTION_FAILURE               _HRESULT_TYPEDEF_(0x80030305L)
#define STG_E_CSS_AUTHENTICATION_FAILURE                   _HRESULT_TYPEDEF_(0x80030306L)
#define STG_E_CSS_KEY_NOT_PRESENT                          _HRESULT_TYPEDEF_(0x80030307L)
#define STG_E_CSS_KEY_NOT_ESTABLISHED                      _HRESULT_TYPEDEF_(0x80030308L)
#define STG_E_CSS_SCRAMBLED_SECTOR                         _HRESULT_TYPEDEF_(0x80030309L)
#define STG_E_CSS_REGION_MISMATCH                          _HRESULT_TYPEDEF_(0x8003030AL)
#define STG_E_RESETS_EXHAUSTED                             _HRESULT_TYPEDEF_(0x8003030BL)

#define OLE_S_FIRST                                        _HRESULT_TYPEDEF_(0x00040000L)
#define OLE_S_USEREG                                       _HRESULT_TYPEDEF_(0x00040000L)
#define OLE_S_STATIC                                       _HRESULT_TYPEDEF_(0x00040001L)
#define OLE_S_MAC_CLIPFORMAT                               _HRESULT_TYPEDEF_(0x00040002L)
#define OLE_S_LAST                                         _HRESULT_TYPEDEF_(0x000400FFL)

#define OLE_E_FIRST                                        _HRESULT_TYPEDEF_(0x80040000L)
#define OLE_E_OLEVERB                                      _HRESULT_TYPEDEF_(0x80040000L)
#define OLE_E_ADVF                                         _HRESULT_TYPEDEF_(0x80040001L)
#define OLE_E_ENUM_NOMORE                                  _HRESULT_TYPEDEF_(0x80040002L)
#define OLE_E_ADVISENOTSUPPORTED                           _HRESULT_TYPEDEF_(0x80040003L)
#define OLE_E_NOCONNECTION                                 _HRESULT_TYPEDEF_(0x80040004L)
#define OLE_E_NOTRUNNING                                   _HRESULT_TYPEDEF_(0x80040005L)
#define OLE_E_NOCACHE                                      _HRESULT_TYPEDEF_(0x80040006L)
#define OLE_E_BLANK                                        _HRESULT_TYPEDEF_(0x80040007L)
#define OLE_E_CLASSDIFF                                    _HRESULT_TYPEDEF_(0x80040008L)
#define OLE_E_CANT_GETMONIKER                              _HRESULT_TYPEDEF_(0x80040009L)
#define OLE_E_CANT_BINDTOSOURCE                            _HRESULT_TYPEDEF_(0x8004000AL)
#define OLE_E_STATIC                                       _HRESULT_TYPEDEF_(0x8004000BL)
#define OLE_E_PROMPTSAVECANCELLED                          _HRESULT_TYPEDEF_(0x8004000CL)
#define OLE_E_INVALIDRECT                                  _HRESULT_TYPEDEF_(0x8004000DL)
#define OLE_E_WRONGCOMPOBJ                                 _HRESULT_TYPEDEF_(0x8004000EL)
#define OLE_E_INVALIDHWND                                  _HRESULT_TYPEDEF_(0x8004000FL)
#define OLE_E_NOT_INPLACEACTIVE                            _HRESULT_TYPEDEF_(0x80040010L)
#define OLE_E_CANTCONVERT                                  _HRESULT_TYPEDEF_(0x80040011L)
#define OLE_E_NOSTORAGE                                    _HRESULT_TYPEDEF_(0x80040012L)
#define DV_E_FORMATETC                                     _HRESULT_TYPEDEF_(0x80040064L)
#define DV_E_DVTARGETDEVICE                                _HRESULT_TYPEDEF_(0x80040065L)
#define DV_E_STGMEDIUM                                     _HRESULT_TYPEDEF_(0x80040066L)
#define DV_E_STATDATA                                      _HRESULT_TYPEDEF_(0x80040067L)
#define DV_E_LINDEX                                        _HRESULT_TYPEDEF_(0x80040068L)
#define DV_E_TYMED                                         _HRESULT_TYPEDEF_(0x80040069L)
#define DV_E_CLIPFORMAT                                    _HRESULT_TYPEDEF_(0x8004006AL)
#define DV_E_DVASPECT                                      _HRESULT_TYPEDEF_(0x8004006BL)
#define DV_E_DVTARGETDEVICE_SIZE                           _HRESULT_TYPEDEF_(0x8004006CL)
#define DV_E_NOIVIEWOBJECT                                 _HRESULT_TYPEDEF_(0x8004006DL)
#define OLE_E_LAST                                         _HRESULT_TYPEDEF_(0x800400FFL)

#define DRAGDROP_S_FIRST                                   _HRESULT_TYPEDEF_(0x00040100L)
#define DRAGDROP_S_DROP                                    _HRESULT_TYPEDEF_(0x00040100L)
#define DRAGDROP_S_CANCEL                                  _HRESULT_TYPEDEF_(0x00040101L)
#define DRAGDROP_S_USEDEFAULTCURSORS                       _HRESULT_TYPEDEF_(0x00040102L)
#define DRAGDROP_S_LAST                                    _HRESULT_TYPEDEF_(0x0004010FL)

#define DRAGDROP_E_FIRST                                   _HRESULT_TYPEDEF_(0x80040100L)
#define DRAGDROP_E_NOTREGISTERED                           _HRESULT_TYPEDEF_(0x80040100L)
#define DRAGDROP_E_ALREADYREGISTERED                       _HRESULT_TYPEDEF_(0x80040101L)
#define DRAGDROP_E_INVALIDHWND                             _HRESULT_TYPEDEF_(0x80040102L)
#define DRAGDROP_E_LAST                                    _HRESULT_TYPEDEF_(0x8004010FL)


#define CLASSFACTORY_S_FIRST                               _HRESULT_TYPEDEF_(0x00040110L)
#define CLASSFACTORY_S_LAST                                _HRESULT_TYPEDEF_(0x0004011FL)

#define CLASSFACTORY_E_FIRST                               _HRESULT_TYPEDEF_(0x80040110L)
#define CLASS_E_NOAGGREGATION                              _HRESULT_TYPEDEF_(0x80040110L)
#define CLASS_E_CLASSNOTAVAILABLE                          _HRESULT_TYPEDEF_(0x80040111L)
#define CLASS_E_NOTLICENSED                                _HRESULT_TYPEDEF_(0x80040112L)
#define CLASSFACTORY_E_LAST                                _HRESULT_TYPEDEF_(0x8004011FL)

#define MARSHAL_S_FIRST                                    _HRESULT_TYPEDEF_(0x00040120L)
#define MARSHAL_S_LAST                                     _HRESULT_TYPEDEF_(0x0004012FL)

#define MARSHAL_E_FIRST                                    _HRESULT_TYPEDEF_(0x80040120L)
#define MARSHAL_E_LAST                                     _HRESULT_TYPEDEF_(0x8004012FL)

#define DATA_S_FIRST                                       _HRESULT_TYPEDEF_(0x00040130L)
#define DATA_S_SAMEFORMATETC                               _HRESULT_TYPEDEF_(0x00040130L)
#define DATA_S_LAST                                        _HRESULT_TYPEDEF_(0x0004013FL)

#define DATA_E_FIRST                                       _HRESULT_TYPEDEF_(0x80040130L)
#define DATA_E_LAST                                        _HRESULT_TYPEDEF_(0x8004013FL)

#define VIEW_S_FIRST                                       _HRESULT_TYPEDEF_(0x00040140L)
#define VIEW_S_ALREADY_FROZEN                              _HRESULT_TYPEDEF_(0x00040140L)
#define VIEW_S_LAST                                        _HRESULT_TYPEDEF_(0x0004014FL)

#define VIEW_E_FIRST                                       _HRESULT_TYPEDEF_(0x80040140L)
#define VIEW_E_DRAW                                        _HRESULT_TYPEDEF_(0x80040140L)
#define VIEW_E_LAST                                        _HRESULT_TYPEDEF_(0x8004014FL)

#define REGDB_S_FIRST                                      _HRESULT_TYPEDEF_(0x00040150L)
#define REGDB_S_LAST                                       _HRESULT_TYPEDEF_(0x0004015FL)

#define REGDB_E_FIRST                                      _HRESULT_TYPEDEF_(0x80040150L)
#define REGDB_E_READREGDB                                  _HRESULT_TYPEDEF_(0x80040150L)
#define REGDB_E_WRITEREGDB                                 _HRESULT_TYPEDEF_(0x80040151L)
#define REGDB_E_KEYMISSING                                 _HRESULT_TYPEDEF_(0x80040152L)
#define REGDB_E_INVALIDVALUE                               _HRESULT_TYPEDEF_(0x80040153L)
#define REGDB_E_CLASSNOTREG                                _HRESULT_TYPEDEF_(0x80040154L)
#define REGDB_E_IIDNOTREG                                  _HRESULT_TYPEDEF_(0x80040155L)
#define REGDB_E_LAST                                       _HRESULT_TYPEDEF_(0x8004015FL)

#define CAT_E_FIRST                                        _HRESULT_TYPEDEF_(0x80040160L)
#define CAT_E_CATIDNOEXIST                                 _HRESULT_TYPEDEF_(0x80040160L)
#define CAT_E_NODESCRIPTION                                _HRESULT_TYPEDEF_(0x80040161L)
#define CAT_E_LAST                                         _HRESULT_TYPEDEF_(0x80040161L)

#define CACHE_S_FIRST                                      _HRESULT_TYPEDEF_(0x00040170L)
#define CACHE_S_FORMATETC_NOTSUPPORTED                     _HRESULT_TYPEDEF_(0x00040170L)
#define CACHE_S_SAMECACHE                                  _HRESULT_TYPEDEF_(0x00040171L)
#define CACHE_S_SOMECACHES_NOTUPDATED                      _HRESULT_TYPEDEF_(0x00040172L)
#define CACHE_S_LAST                                       _HRESULT_TYPEDEF_(0x0004017FL)

#define CACHE_E_FIRST                                      _HRESULT_TYPEDEF_(0x80040170L)
#define CACHE_E_NOCACHE_UPDATED                            _HRESULT_TYPEDEF_(0x80040170L)
#define CACHE_E_LAST                                       _HRESULT_TYPEDEF_(0x8004017FL)

#define OLEOBJ_S_FIRST                                     _HRESULT_TYPEDEF_(0x00040180L)
#define OLEOBJ_S_INVALIDVERB                               _HRESULT_TYPEDEF_(0x00040180L)
#define OLEOBJ_S_CANNOT_DOVERB_NOW                         _HRESULT_TYPEDEF_(0x00040181L)
#define OLEOBJ_S_INVALIDHWND                               _HRESULT_TYPEDEF_(0x00040182L)
#define OLEOBJ_S_LAST                                      _HRESULT_TYPEDEF_(0x0004018FL)

#define OLEOBJ_E_FIRST                                     _HRESULT_TYPEDEF_(0x80040180L)
#define OLEOBJ_E_NOVERBS                                   _HRESULT_TYPEDEF_(0x80040180L)
#define OLEOBJ_E_INVALIDVERB                               _HRESULT_TYPEDEF_(0x80040181L)
#define OLEOBJ_E_LAST                                      _HRESULT_TYPEDEF_(0x8004018FL)

#define CLIENTSITE_S_FIRST                                 _HRESULT_TYPEDEF_(0x00040190L)
#define CLIENTSITE_S_LAST                                  _HRESULT_TYPEDEF_(0x0004019FL)

#define CLIENTSITE_E_FIRST                                 _HRESULT_TYPEDEF_(0x80040190L)
#define CLIENTSITE_E_LAST                                  _HRESULT_TYPEDEF_(0x8004019FL)

#define INPLACE_S_FIRST                                    _HRESULT_TYPEDEF_(0x000401A0L)
#define INPLACE_S_TRUNCATED                                _HRESULT_TYPEDEF_(0x000401A0L)
#define INPLACE_S_LAST                                     _HRESULT_TYPEDEF_(0x000401AFL)

#define INPLACE_E_FIRST                                    _HRESULT_TYPEDEF_(0x800401A0L)
#define INPLACE_E_NOTUNDOABLE                              _HRESULT_TYPEDEF_(0x800401A0L)
#define INPLACE_E_NOTOOLSPACE                              _HRESULT_TYPEDEF_(0x800401A1L)
#define INPLACE_E_LAST                                     _HRESULT_TYPEDEF_(0x800401AFL)

#define ENUM_S_FIRST                                       _HRESULT_TYPEDEF_(0x000401B0L)
#define ENUM_S_LAST                                        _HRESULT_TYPEDEF_(0x000401BFL)

#define ENUM_E_FIRST                                       _HRESULT_TYPEDEF_(0x800401B0L)
#define ENUM_E_LAST                                        _HRESULT_TYPEDEF_(0x800401BFL)

#define CONVERT10_S_FIRST                                  _HRESULT_TYPEDEF_(0x000401C0L)
#define CONVERT10_S_NO_PRESENTATION                        _HRESULT_TYPEDEF_(0x000401C0L)
#define CONVERT10_S_LAST                                   _HRESULT_TYPEDEF_(0x000401CFL)

#define CONVERT10_E_FIRST                                  _HRESULT_TYPEDEF_(0x800401C0L)
#define CONVERT10_E_OLESTREAM_GET                          _HRESULT_TYPEDEF_(0x800401C0L)
#define CONVERT10_E_OLESTREAM_PUT                          _HRESULT_TYPEDEF_(0x800401C1L)
#define CONVERT10_E_OLESTREAM_FMT                          _HRESULT_TYPEDEF_(0x800401C2L)
#define CONVERT10_E_OLESTREAM_BITMAP_TO_DIB                _HRESULT_TYPEDEF_(0x800401C3L)
#define CONVERT10_E_STG_FMT                                _HRESULT_TYPEDEF_(0x800401C4L)
#define CONVERT10_E_STG_NO_STD_STREAM                      _HRESULT_TYPEDEF_(0x800401C5L)
#define CONVERT10_E_STG_DIB_TO_BITMAP                      _HRESULT_TYPEDEF_(0x800401C6L)
#define CONVERT10_E_LAST                                   _HRESULT_TYPEDEF_(0x800401CFL)

#define CLIPBRD_S_FIRST                                    _HRESULT_TYPEDEF_(0x000401D0L)
#define CLIPBRD_S_LAST                                     _HRESULT_TYPEDEF_(0x000401DFL)

#define CLIPBRD_E_FIRST                                    _HRESULT_TYPEDEF_(0x800401D0L)
#define CLIPBRD_E_LAST                                     _HRESULT_TYPEDEF_(0x800401DFL)
#define CLIPBRD_E_CANT_OPEN                                _HRESULT_TYPEDEF_(0x800401D0L)
#define CLIPBRD_E_CANT_EMPTY                               _HRESULT_TYPEDEF_(0x800401D1L)
#define CLIPBRD_E_CANT_SET                                 _HRESULT_TYPEDEF_(0x800401D2L)
#define CLIPBRD_E_BAD_DATA                                 _HRESULT_TYPEDEF_(0x800401D3L)
#define CLIPBRD_E_CANT_CLOSE                               _HRESULT_TYPEDEF_(0x800401D4L)

#define MK_S_FIRST                                         _HRESULT_TYPEDEF_(0x000401E0L)
#define MK_S_REDUCED_TO_SELF                               _HRESULT_TYPEDEF_(0x000401E2L)
#define MK_S_ME                                            _HRESULT_TYPEDEF_(0x000401E4L)
#define MK_S_HIM                                           _HRESULT_TYPEDEF_(0x000401E5L)
#define MK_S_US                                            _HRESULT_TYPEDEF_(0x000401E6L)
#define MK_S_MONIKERALREADYREGISTERED                      _HRESULT_TYPEDEF_(0x000401E7L)
#define MK_S_LAST                                          _HRESULT_TYPEDEF_(0x000401EFL)

#define MK_E_FIRST                                         _HRESULT_TYPEDEF_(0x800401E0L)
#define MK_E_CONNECTMANUALLY                               _HRESULT_TYPEDEF_(0x800401E0L)
#define MK_E_EXCEEDEDDEADLINE                              _HRESULT_TYPEDEF_(0x800401E1L)
#define MK_E_NEEDGENERIC                                   _HRESULT_TYPEDEF_(0x800401E2L)
#define MK_E_UNAVAILABLE                                   _HRESULT_TYPEDEF_(0x800401E3L)
#define MK_E_SYNTAX                                        _HRESULT_TYPEDEF_(0x800401E4L)
#define MK_E_NOOBJECT                                      _HRESULT_TYPEDEF_(0x800401E5L)
#define MK_E_INVALIDEXTENSION                              _HRESULT_TYPEDEF_(0x800401E6L)
#define MK_E_INTERMEDIATEINTERFACENOTSUPPORTED             _HRESULT_TYPEDEF_(0x800401E7L)
#define MK_E_NOTBINDABLE                                   _HRESULT_TYPEDEF_(0x800401E8L)
#define MK_E_NOTBOUND                                      _HRESULT_TYPEDEF_(0x800401E9L)
#define MK_E_CANTOPENFILE                                  _HRESULT_TYPEDEF_(0x800401EAL)
#define MK_E_MUSTBOTHERUSER                                _HRESULT_TYPEDEF_(0x800401EBL)
#define MK_E_NOINVERSE                                     _HRESULT_TYPEDEF_(0x800401ECL)
#define MK_E_NOSTORAGE                                     _HRESULT_TYPEDEF_(0x800401EDL)
#define MK_E_NOPREFIX                                      _HRESULT_TYPEDEF_(0x800401EEL)
#define MK_E_ENUMERATION_FAILED                            _HRESULT_TYPEDEF_(0x800401EFL)
#define MK_E_LAST                                          _HRESULT_TYPEDEF_(0x800401EFL)

#define CO_S_FIRST                                         _HRESULT_TYPEDEF_(0x000401F0L)
#define CO_S_LAST                                          _HRESULT_TYPEDEF_(0x000401FFL)

#define CO_E_FIRST                                         _HRESULT_TYPEDEF_(0x800401F0L)
#define CO_E_NOTINITIALIZED                                _HRESULT_TYPEDEF_(0x800401F0L)
#define CO_E_ALREADYINITIALIZED                            _HRESULT_TYPEDEF_(0x800401F1L)
#define CO_E_CANTDETERMINECLASS                            _HRESULT_TYPEDEF_(0x800401F2L)
#define CO_E_CLASSSTRING                                   _HRESULT_TYPEDEF_(0x800401F3L)
#define CO_E_IIDSTRING                                     _HRESULT_TYPEDEF_(0x800401F4L)
#define CO_E_APPNOTFOUND                                   _HRESULT_TYPEDEF_(0x800401F5L)
#define CO_E_APPSINGLEUSE                                  _HRESULT_TYPEDEF_(0x800401F6L)
#define CO_E_ERRORINAPP                                    _HRESULT_TYPEDEF_(0x800401F7L)
#define CO_E_DLLNOTFOUND                                   _HRESULT_TYPEDEF_(0x800401F8L)
#define CO_E_ERRORINDLL                                    _HRESULT_TYPEDEF_(0x800401F9L)
#define CO_E_WRONGOSFORAPP                                 _HRESULT_TYPEDEF_(0x800401FAL)
#define CO_E_OBJNOTREG                                     _HRESULT_TYPEDEF_(0x800401FBL)
#define CO_E_OBJISREG                                      _HRESULT_TYPEDEF_(0x800401FCL)
#define CO_E_OBJNOTCONNECTED                               _HRESULT_TYPEDEF_(0x800401FDL)
#define CO_E_APPDIDNTREG                                   _HRESULT_TYPEDEF_(0x800401FEL)
#define CO_E_RELEASED                                      _HRESULT_TYPEDEF_(0x800401FFL)
#define CO_E_LAST                                          _HRESULT_TYPEDEF_(0x800401FFL)
#define CO_E_FAILEDTOIMPERSONATE                           _HRESULT_TYPEDEF_(0x80040200L)
#define CO_E_FAILEDTOGETSECCTX                             _HRESULT_TYPEDEF_(0x80040201L)
#define CO_E_FAILEDTOOPENTHREADTOKEN                       _HRESULT_TYPEDEF_(0x80040202L)
#define CO_E_FAILEDTOGETTOKENINFO                          _HRESULT_TYPEDEF_(0x80040203L)
#define CO_E_TRUSTEEDOESNTMATCHCLIENT                      _HRESULT_TYPEDEF_(0x80040204L)
#define CO_E_FAILEDTOQUERYCLIENTBLANKET                    _HRESULT_TYPEDEF_(0x80040205L)
#define CO_E_FAILEDTOSETDACL                               _HRESULT_TYPEDEF_(0x80040206L)
#define CO_E_ACCESSCHECKFAILED                             _HRESULT_TYPEDEF_(0x80040207L)
#define CO_E_NETACCESSAPIFAILED                            _HRESULT_TYPEDEF_(0x80040208L)
#define CO_E_WRONGTRUSTEENAMESYNTAX                        _HRESULT_TYPEDEF_(0x80040209L)
#define CO_E_INVALIDSID                                    _HRESULT_TYPEDEF_(0x8004020AL)
#define CO_E_CONVERSIONFAILED                              _HRESULT_TYPEDEF_(0x8004020BL)
#define CO_E_NOMATCHINGSIDFOUND                            _HRESULT_TYPEDEF_(0x8004020CL)
#define CO_E_LOOKUPACCSIDFAILED                            _HRESULT_TYPEDEF_(0x8004020DL)
#define CO_E_NOMATCHINGNAMEFOUND                           _HRESULT_TYPEDEF_(0x8004020EL)
#define CO_E_LOOKUPACCNAMEFAILED                           _HRESULT_TYPEDEF_(0x8004020FL)
#define CO_E_SETSERLHNDLFAILED                             _HRESULT_TYPEDEF_(0x80040210L)
#define CO_E_FAILEDTOGETWINDIR                             _HRESULT_TYPEDEF_(0x80040211L)
#define CO_E_PATHTOOLONG                                   _HRESULT_TYPEDEF_(0x80040212L)
#define CO_E_FAILEDTOGENUUID                               _HRESULT_TYPEDEF_(0x80040213L)
#define CO_E_FAILEDTOCREATEFILE                            _HRESULT_TYPEDEF_(0x80040214L)
#define CO_E_FAILEDTOCLOSEHANDLE                           _HRESULT_TYPEDEF_(0x80040215L)
#define CO_E_EXCEEDSYSACLLIMIT                             _HRESULT_TYPEDEF_(0x80040216L)
#define CO_E_ACESINWRONGORDER                              _HRESULT_TYPEDEF_(0x80040217L)
#define CO_E_INCOMPATIBLESTREAMVERSION                     _HRESULT_TYPEDEF_(0x80040218L)
#define CO_E_FAILEDTOOPENPROCESSTOKEN                      _HRESULT_TYPEDEF_(0x80040219L)
#define CO_E_DECODEFAILED                                  _HRESULT_TYPEDEF_(0x8004021AL)
#define CO_E_ACNOTINITIALIZED                              _HRESULT_TYPEDEF_(0x8004021BL)

#define E_ACCESSDENIED                                     _HRESULT_TYPEDEF_(0x80070005L)
#define E_HANDLE                                           _HRESULT_TYPEDEF_(0x80070006L)
#define E_OUTOFMEMORY                                      _HRESULT_TYPEDEF_(0x8007000EL)
#define E_INVALIDARG                                       _HRESULT_TYPEDEF_(0x80070057L)

#define CO_S_NOTALLINTERFACES                              _HRESULT_TYPEDEF_(0x00080012L)

#define CO_E_CLASS_CREATE_FAILED                           _HRESULT_TYPEDEF_(0x80080001L)
#define CO_E_SCM_ERROR                                     _HRESULT_TYPEDEF_(0x80080002L)
#define CO_E_SCM_RPC_FAILURE                               _HRESULT_TYPEDEF_(0x80080003L)
#define CO_E_BAD_PATH                                      _HRESULT_TYPEDEF_(0x80080004L)
#define CO_E_SERVER_EXEC_FAILURE                           _HRESULT_TYPEDEF_(0x80080005L)
#define CO_E_OBJSRV_RPC_FAILURE                            _HRESULT_TYPEDEF_(0x80080006L)
#define MK_E_NO_NORMALIZED                                 _HRESULT_TYPEDEF_(0x80080007L)
#define CO_E_SERVER_STOPPING                               _HRESULT_TYPEDEF_(0x80080008L)
#define MEM_E_INVALID_ROOT                                 _HRESULT_TYPEDEF_(0x80080009L)
#define MEM_E_INVALID_LINK                                 _HRESULT_TYPEDEF_(0x80080010L)
#define MEM_E_INVALID_SIZE                                 _HRESULT_TYPEDEF_(0x80080011L)

/*Cryptographic Error Codes */
#define NTE_BAD_UID                                        _HRESULT_TYPEDEF_(0x80090001L)
#define NTE_BAD_HASH                                       _HRESULT_TYPEDEF_(0x80090002L)
#define NTE_BAD_KEY                                        _HRESULT_TYPEDEF_(0x80090003L)
#define NTE_BAD_LEN                                        _HRESULT_TYPEDEF_(0x80090004L)
#define NTE_BAD_DATA                                       _HRESULT_TYPEDEF_(0x80090005L)
#define NTE_BAD_SIGNATURE                                  _HRESULT_TYPEDEF_(0x80090006L)
#define NTE_BAD_VER                                        _HRESULT_TYPEDEF_(0x80090007L)
#define NTE_BAD_ALGID                                      _HRESULT_TYPEDEF_(0x80090008L)
#define NTE_BAD_FLAGS                                      _HRESULT_TYPEDEF_(0x80090009L)
#define NTE_BAD_TYPE                                       _HRESULT_TYPEDEF_(0x8009000AL)
#define NTE_BAD_KEY_STATE                                  _HRESULT_TYPEDEF_(0x8009000BL)
#define NTE_BAD_HASH_STATE                                 _HRESULT_TYPEDEF_(0x8009000CL)
#define NTE_NO_KEY                                         _HRESULT_TYPEDEF_(0x8009000DL)
#define NTE_NO_MEMORY                                      _HRESULT_TYPEDEF_(0x8009000EL)
#define NTE_EXISTS                                         _HRESULT_TYPEDEF_(0x8009000FL)
#define NTE_PERM                                           _HRESULT_TYPEDEF_(0x80090010L)
#define NTE_NOT_FOUND                                      _HRESULT_TYPEDEF_(0x80090011L)
#define NTE_DOUBLE_ENCRYPT                                 _HRESULT_TYPEDEF_(0x80090012L)
#define NTE_BAD_PROVIDER                                   _HRESULT_TYPEDEF_(0x80090013L)
#define NTE_BAD_PROV_TYPE                                  _HRESULT_TYPEDEF_(0x80090014L)
#define NTE_BAD_PUBLIC_KEY                                 _HRESULT_TYPEDEF_(0x80090015L)
#define NTE_BAD_KEYSET                                     _HRESULT_TYPEDEF_(0x80090016L)
#define NTE_PROV_TYPE_NOT_DEF                              _HRESULT_TYPEDEF_(0x80090017L)
#define NTE_PROV_TYPE_ENTRY_BAD                            _HRESULT_TYPEDEF_(0x80090018L)
#define NTE_KEYSET_NOT_DEF                                 _HRESULT_TYPEDEF_(0x80090019L)
#define NTE_KEYSET_ENTRY_BAD                               _HRESULT_TYPEDEF_(0x8009001AL)
#define NTE_PROV_TYPE_NO_MATCH                             _HRESULT_TYPEDEF_(0x8009001BL)
#define NTE_SIGNATURE_FILE_BAD                             _HRESULT_TYPEDEF_(0x8009001CL)
#define NTE_PROVIDER_DLL_FAIL                              _HRESULT_TYPEDEF_(0x8009001DL)
#define NTE_PROV_DLL_NOT_FOUND                             _HRESULT_TYPEDEF_(0x8009001EL)
#define NTE_BAD_KEYSET_PARAM                               _HRESULT_TYPEDEF_(0x8009001FL)
#define NTE_FAIL                                           _HRESULT_TYPEDEF_(0x80090020L)
#define NTE_SYS_ERR                                        _HRESULT_TYPEDEF_(0x80090021L)
#define NTE_OP_OK                                          _HRESULT_TYPEDEF_(0)

#define SEC_E_INSUFFICIENT_MEMORY                          _HRESULT_TYPEDEF_(0x80090300L)
#define SEC_E_INVALID_HANDLE                               _HRESULT_TYPEDEF_(0x80090301L)
#define SEC_E_UNSUPPORTED_FUNCTION                         _HRESULT_TYPEDEF_(0x80090302L)
#define SEC_E_TARGET_UNKNOWN                               _HRESULT_TYPEDEF_(0x80090303L)
#define SEC_E_INTERNAL_ERROR                               _HRESULT_TYPEDEF_(0x80090304L)
#define SEC_E_SECPKG_NOT_FOUND                             _HRESULT_TYPEDEF_(0x80090305L)
#define SEC_E_NOT_OWNER                                    _HRESULT_TYPEDEF_(0x80090306L)
#define SEC_E_CANNOT_INSTALL                               _HRESULT_TYPEDEF_(0x80090307L)
#define SEC_E_INVALID_TOKEN                                _HRESULT_TYPEDEF_(0x80090308L)
#define SEC_E_CANNOT_PACK                                  _HRESULT_TYPEDEF_(0x80090309L)
#define SEC_E_QOP_NOT_SUPPORTED                            _HRESULT_TYPEDEF_(0x8009030AL)
#define SEC_E_NO_IMPERSONATION                             _HRESULT_TYPEDEF_(0x8009030BL)
#define SEC_E_LOGON_DENIED                                 _HRESULT_TYPEDEF_(0x8009030CL)
#define SEC_E_UNKNOWN_CREDENTIALS                          _HRESULT_TYPEDEF_(0x8009030DL)
#define SEC_E_NO_CREDENTIALS                               _HRESULT_TYPEDEF_(0x8009030EL)
#define SEC_E_MESSAGE_ALTERED                              _HRESULT_TYPEDEF_(0x8009030FL)
#define SEC_E_OUT_OF_SEQUENCE                              _HRESULT_TYPEDEF_(0x80090310L)
#define SEC_E_NO_AUTHENTICATING_AUTHORITY                  _HRESULT_TYPEDEF_(0x80090311L)
#define SEC_I_CONTINUE_NEEDED                              _HRESULT_TYPEDEF_(0x00090312L)
#define SEC_I_COMPLETE_NEEDED                              _HRESULT_TYPEDEF_(0x00090313L)
#define SEC_I_COMPLETE_AND_CONTINUE                        _HRESULT_TYPEDEF_(0x00090314L) 
#define SEC_E_BAD_PKGID                                    _HRESULT_TYPEDEF_(0x80090316L)
#define SEC_E_CONTEXT_EXPIRED                              _HRESULT_TYPEDEF_(0x80090317L)
#define SEC_E_INCOMPLETE_MESSAGE                           _HRESULT_TYPEDEF_(0x80090318L)
#define SEC_E_INCOMPLETE_CREDENTIALS                       _HRESULT_TYPEDEF_(0x80090320L)
#define SEC_E_BUFFER_TOO_SMALL                             _HRESULT_TYPEDEF_(0x80090321L)
#define SEC_E_WRONG_PRINCIPAL                              _HRESULT_TYPEDEF_(0x80090322L)
#define SEC_E_TIME_SKEW                                    _HRESULT_TYPEDEF_(0x80090324L)
#define SEC_E_UNTRUSTED_ROOT                               _HRESULT_TYPEDEF_(0x80090325L)
#define SEC_E_ILLEGAL_MESSAGE                              _HRESULT_TYPEDEF_(0x80090326L)
#define SEC_E_CERT_UNKNOWN                                 _HRESULT_TYPEDEF_(0x80090327L)
#define SEC_E_CERT_EXPIRED                                 _HRESULT_TYPEDEF_(0x80090328L)
#define SEC_E_ENCRYPT_FAILURE                              _HRESULT_TYPEDEF_(0x80090329L)
#define SEC_E_DECRYPT_FAILURE                              _HRESULT_TYPEDEF_(0x80090330L)
#define SEC_E_ALGORITHM_MISMATCH                           _HRESULT_TYPEDEF_(0x80090331L)
#define SEC_E_SECURITY_QOS_FAILED                          _HRESULT_TYPEDEF_(0x80090332L)
#define SEC_E_UNFINISHED_CONTEXT_DELETED                   _HRESULT_TYPEDEF_(0x80090333L)
#define SEC_E_NO_TGT_REPLY                                 _HRESULT_TYPEDEF_(0x80090334L)
#define SEC_E_NO_IP_ADDRESSES                              _HRESULT_TYPEDEF_(0x80090335L)
#define SEC_E_WRONG_CREDENTIAL_HANDLE                      _HRESULT_TYPEDEF_(0x80090336L)
#define SEC_E_CRYPTO_SYSTEM_INVALID                        _HRESULT_TYPEDEF_(0x80090337L)
#define SEC_E_MAX_REFERRALS_EXCEEDED                       _HRESULT_TYPEDEF_(0x80090338L)
#define SEC_E_MUST_BE_KDC                                  _HRESULT_TYPEDEF_(0x80090339L)
#define SEC_E_STRONG_CRYPTO_NOT_SUPPORTED                  _HRESULT_TYPEDEF_(0x8009033AL)
#define SEC_E_TOO_MANY_PRINCIPALS                          _HRESULT_TYPEDEF_(0x8009033BL)
#define SEC_E_NO_PA_DATA                                   _HRESULT_TYPEDEF_(0x8009033CL)
#define SEC_E_PKINIT_NAME_MISMATCH                         _HRESULT_TYPEDEF_(0x8009033DL)
#define SEC_E_SMARTCARD_LOGON_REQUIRED                     _HRESULT_TYPEDEF_(0x8009033EL)
#define SEC_E_SHUTDOWN_IN_PROGRESS                         _HRESULT_TYPEDEF_(0x8009033FL)
#define SEC_E_KDC_INVALID_REQUEST                          _HRESULT_TYPEDEF_(0x80090340L)
#define SEC_E_KDC_UNABLE_TO_REFER                          _HRESULT_TYPEDEF_(0x80090341L)
#define SEC_E_KDC_UNKNOWN_ETYPE                            _HRESULT_TYPEDEF_(0x80090342L)
#define SEC_E_UNSUPPORTED_PREAUTH                          _HRESULT_TYPEDEF_(0x80090343L)
#define SEC_E_DELEGATION_REQUIRED                          _HRESULT_TYPEDEF_(0x80090345L)
#define SEC_E_BAD_BINDINGS                                 _HRESULT_TYPEDEF_(0x80090346L)
#define SEC_E_MULTIPLE_ACCOUNTS                            _HRESULT_TYPEDEF_(0x80090347L)
#define SEC_E_NO_KERB_KEY                                  _HRESULT_TYPEDEF_(0x80090348L)
#define SEC_E_CERT_WRONG_USAGE                             _HRESULT_TYPEDEF_(0x80090349L)
#define SEC_E_DOWNGRADE_DETECTED                           _HRESULT_TYPEDEF_(0x80090350L)
#define SEC_E_SMARTCARD_CERT_REVOKED                       _HRESULT_TYPEDEF_(0x80090351L)
#define SEC_E_ISSUING_CA_UNTRUSTED                         _HRESULT_TYPEDEF_(0x80090352L)
#define SEC_E_REVOCATION_OFFLINE_C                         _HRESULT_TYPEDEF_(0x80090353L)
#define SEC_E_PKINIT_CLIENT_FAILURE                        _HRESULT_TYPEDEF_(0x80090354L)
#define SEC_E_SMARTCARD_CERT_EXPIRED                       _HRESULT_TYPEDEF_(0x80090355L)
#define SEC_E_NO_S4U_PROT_SUPPORT                          _HRESULT_TYPEDEF_(0x80090356L)
#define SEC_E_CROSSREALM_DELEGATION_FAILURE                _HRESULT_TYPEDEF_(0x80090357L)
#define SEC_E_REVOCATION_OFFLINE_KDC                       _HRESULT_TYPEDEF_(0x80090358L)
#define SEC_E_ISSUING_CA_UNTRUSTED_KDC                     _HRESULT_TYPEDEF_(0x80090359L)
#define SEC_E_KDC_CERT_EXPIRED                             _HRESULT_TYPEDEF_(0x8009035AL)
#define SEC_E_KDC_CERT_REVOKED                             _HRESULT_TYPEDEF_(0x8009035BL)

#define CRYPT_E_MSG_ERROR                                  _HRESULT_TYPEDEF_(0x80091001L)
#define CRYPT_E_UNKNOWN_ALGO                               _HRESULT_TYPEDEF_(0x80091002L)
#define CRYPT_E_OID_FORMAT                                 _HRESULT_TYPEDEF_(0x80091003L)
#define CRYPT_E_INVALID_MSG_TYPE                           _HRESULT_TYPEDEF_(0x80091004L)
#define CRYPT_E_UNEXPECTED_ENCODING                        _HRESULT_TYPEDEF_(0x80091005L)
#define CRYPT_E_AUTH_ATTR_MISSING                          _HRESULT_TYPEDEF_(0x80091006L)
#define CRYPT_E_HASH_VALUE                                 _HRESULT_TYPEDEF_(0x80091007L)
#define CRYPT_E_INVALID_INDEX                              _HRESULT_TYPEDEF_(0x80091008L)
#define CRYPT_E_ALREADY_DECRYPTED                          _HRESULT_TYPEDEF_(0x80091009L)
#define CRYPT_E_NOT_DECRYPTED                              _HRESULT_TYPEDEF_(0x8009100AL)
#define CRYPT_E_RECIPIENT_NOT_FOUND                        _HRESULT_TYPEDEF_(0x8009100BL)
#define CRYPT_E_CONTROL_TYPE                               _HRESULT_TYPEDEF_(0x8009100CL)
#define CRYPT_E_ISSUER_SERIALNUMBER                        _HRESULT_TYPEDEF_(0x8009100DL)
#define CRYPT_E_SIGNER_NOT_FOUND                           _HRESULT_TYPEDEF_(0x8009100EL)
#define CRYPT_E_ATTRIBUTES_MISSING                         _HRESULT_TYPEDEF_(0x8009100FL)
#define CRYPT_E_STREAM_MSG_NOT_READY                       _HRESULT_TYPEDEF_(0x80091010L)
#define CRYPT_E_STREAM_INSUFFICIENT_DATA                   _HRESULT_TYPEDEF_(0x80091011L)
#define CRYPT_I_NEW_PROTECTION_REQUIRED                    _HRESULT_TYPEDEF_(0x80091012L)

#define CRYPT_E_BAD_LEN                                    _HRESULT_TYPEDEF_(0x80092001L)
#define CRYPT_E_BAD_ENCODE                                 _HRESULT_TYPEDEF_(0x80092002L)
#define CRYPT_E_FILE_ERROR                                 _HRESULT_TYPEDEF_(0x80092003L)
#define CRYPT_E_NOT_FOUND                                  _HRESULT_TYPEDEF_(0x80092004L)
#define CRYPT_E_EXISTS                                     _HRESULT_TYPEDEF_(0x80092005L)
#define CRYPT_E_NO_PROVIDER                                _HRESULT_TYPEDEF_(0x80092006L)
#define CRYPT_E_SELF_SIGNED                                _HRESULT_TYPEDEF_(0x80092007L)
#define CRYPT_E_DELETED_PREV                               _HRESULT_TYPEDEF_(0x80092008L)
#define CRYPT_E_NO_MATCH                                   _HRESULT_TYPEDEF_(0x80092009L)
#define CRYPT_E_UNEXPECTED_MSG_TYPE                        _HRESULT_TYPEDEF_(0x8009200AL)
#define CRYPT_E_NO_KEY_PROPERTY                            _HRESULT_TYPEDEF_(0x8009200BL)
#define CRYPT_E_NO_DECRYPT_CERT                            _HRESULT_TYPEDEF_(0x8009200CL)
#define CRYPT_E_BAD_MSG                                    _HRESULT_TYPEDEF_(0x8009200DL)
#define CRYPT_E_NO_SIGNER                                  _HRESULT_TYPEDEF_(0x8009200EL)
#define CRYPT_E_PENDING_CLOSE                              _HRESULT_TYPEDEF_(0x8009200FL)
#define CRYPT_E_REVOKED                                    _HRESULT_TYPEDEF_(0x80092010L)
#define CRYPT_E_NO_REVOCATION_DLL                          _HRESULT_TYPEDEF_(0x80092011L)
#define CRYPT_E_NO_REVOCATION_CHECK                        _HRESULT_TYPEDEF_(0x80092012L)
#define CRYPT_E_REVOCATION_OFFLINE                         _HRESULT_TYPEDEF_(0x80092013L)
#define CRYPT_E_NOT_IN_REVOCATION_DATABASE                 _HRESULT_TYPEDEF_(0x80092014L)
#define CRYPT_E_INVALID_NUMERIC_STRING                     _HRESULT_TYPEDEF_(0x80092020L)
#define CRYPT_E_INVALID_PRINTABLE_STRING                   _HRESULT_TYPEDEF_(0x80092021L)
#define CRYPT_E_INVALID_IA5_STRING                         _HRESULT_TYPEDEF_(0x80092022L)
#define CRYPT_E_INVALID_X500_STRING                        _HRESULT_TYPEDEF_(0x80092023L)
#define CRYPT_E_NOT_CHAR_STRING                            _HRESULT_TYPEDEF_(0x80092024L)
#define CRYPT_E_FILERESIZED                                _HRESULT_TYPEDEF_(0x80092025L)
#define CRYPT_E_SECURITY_SETTINGS                          _HRESULT_TYPEDEF_(0x80092026L)
#define CRYPT_E_NO_VERIFY_USAGE_DLL                        _HRESULT_TYPEDEF_(0x80092027L)
#define CRYPT_E_NO_VERIFY_USAGE_CHECK                      _HRESULT_TYPEDEF_(0x80092028L)
#define CRYPT_E_VERIFY_USAGE_OFFLINE                       _HRESULT_TYPEDEF_(0x80092029L)
#define CRYPT_E_NOT_IN_CTL                                 _HRESULT_TYPEDEF_(0x8009202AL)
#define CRYPT_E_NO_TRUSTED_SIGNER                          _HRESULT_TYPEDEF_(0x8009202BL)
#define CRYPT_E_MISSING_PUBKEY_PARA                        _HRESULT_TYPEDEF_(0x8009202CL)
#define CRYPT_E_OSS_ERROR                                  _HRESULT_TYPEDEF_(0x80093000L)
#define OSS_MORE_BUF                                       _HRESULT_TYPEDEF_(0x80093001L)
#define OSS_NEGATIVE_UINTEGER                              _HRESULT_TYPEDEF_(0x80093002L)
#define OSS_PDU_RANGE                                      _HRESULT_TYPEDEF_(0x80093003L)
#define OSS_MORE_INPUT                                     _HRESULT_TYPEDEF_(0x80093004L)
#define OSS_DATA_ERROR                                     _HRESULT_TYPEDEF_(0x80093005L)
#define OSS_BAD_ARG                                        _HRESULT_TYPEDEF_(0x80093006L)
#define OSS_BAD_VERSION                                    _HRESULT_TYPEDEF_(0x80093007L)
#define OSS_OUT_MEMORY                                     _HRESULT_TYPEDEF_(0x80093008L)
#define OSS_PDU_MISMATCH                                   _HRESULT_TYPEDEF_(0x80093009L)
#define OSS_LIMITED                                        _HRESULT_TYPEDEF_(0x8009300AL)
#define OSS_BAD_PTR                                        _HRESULT_TYPEDEF_(0x8009300BL)
#define OSS_BAD_TIME                                       _HRESULT_TYPEDEF_(0x8009300CL)
#define OSS_INDEFINITE_NOT_SUPPORTED                       _HRESULT_TYPEDEF_(0x8009300DL)
#define OSS_MEM_ERROR                                      _HRESULT_TYPEDEF_(0x8009300EL)
#define OSS_BAD_TABLE                                      _HRESULT_TYPEDEF_(0x8009300FL)
#define OSS_TOO_LONG                                       _HRESULT_TYPEDEF_(0x80093010L)
#define OSS_CONSTRAINT_VIOLATED                            _HRESULT_TYPEDEF_(0x80093011L)
#define OSS_FATAL_ERROR                                    _HRESULT_TYPEDEF_(0x80093012L)
#define OSS_ACCESS_SERIALIZATION_ERROR                     _HRESULT_TYPEDEF_(0x80093013L)
#define OSS_NULL_TBL                                       _HRESULT_TYPEDEF_(0x80093014L)
#define OSS_NULL_FCN                                       _HRESULT_TYPEDEF_(0x80093015L)
#define OSS_BAD_ENCRULES                                   _HRESULT_TYPEDEF_(0x80093016L)
#define OSS_UNAVAIL_ENCRULES                               _HRESULT_TYPEDEF_(0x80093017L)
#define OSS_CANT_OPEN_TRACE_WINDOW                         _HRESULT_TYPEDEF_(0x80093018L)
#define OSS_UNIMPLEMENTED                                  _HRESULT_TYPEDEF_(0x80093019L)
#define OSS_OID_DLL_NOT_LINKED                             _HRESULT_TYPEDEF_(0x8009301AL)
#define OSS_CANT_OPEN_TRACE_FILE                           _HRESULT_TYPEDEF_(0x8009301BL)
#define OSS_TRACE_FILE_ALREADY_OPEN                        _HRESULT_TYPEDEF_(0x8009301CL)
#define OSS_TABLE_MISMATCH                                 _HRESULT_TYPEDEF_(0x8009301DL)
#define OSS_TYPE_NOT_SUPPORTED                             _HRESULT_TYPEDEF_(0x8009301EL)
#define OSS_REAL_DLL_NOT_LINKED                            _HRESULT_TYPEDEF_(0x8009301FL)
#define OSS_REAL_CODE_NOT_LINKED                           _HRESULT_TYPEDEF_(0x80093020L)
#define OSS_OUT_OF_RANGE                                   _HRESULT_TYPEDEF_(0x80093021L)
#define OSS_COPIER_DLL_NOT_LINKED                          _HRESULT_TYPEDEF_(0x80093022L)
#define OSS_CONSTRAINT_DLL_NOT_LINKED                      _HRESULT_TYPEDEF_(0x80093023L)
#define OSS_COMPARATOR_DLL_NOT_LINKED                      _HRESULT_TYPEDEF_(0x80093024L)
#define OSS_COMPARATOR_CODE_NOT_LINKED                     _HRESULT_TYPEDEF_(0x80093025L)
#define OSS_MEM_MGR_DLL_NOT_LINKED                         _HRESULT_TYPEDEF_(0x80093026L)
#define OSS_PDV_DLL_NOT_LINKED                             _HRESULT_TYPEDEF_(0x80093027L)
#define OSS_PDV_CODE_NOT_LINKED                            _HRESULT_TYPEDEF_(0x80093028L)
#define OSS_API_DLL_NOT_LINKED                             _HRESULT_TYPEDEF_(0x80093029L)
#define OSS_BERDER_DLL_NOT_LINKED                          _HRESULT_TYPEDEF_(0x8009302AL)
#define OSS_PER_DLL_NOT_LINKED                             _HRESULT_TYPEDEF_(0x8009302BL)
#define OSS_OPEN_TYPE_ERROR                                _HRESULT_TYPEDEF_(0x8009302CL)
#define OSS_MUTEX_NOT_CREATED                              _HRESULT_TYPEDEF_(0x8009302DL)
#define OSS_CANT_CLOSE_TRACE_FILE                          _HRESULT_TYPEDEF_(0x8009302EL)
#define CRYPT_E_ASN1_ERROR                                 _HRESULT_TYPEDEF_(0x80093100L)
#define CRYPT_E_ASN1_INTERNAL                              _HRESULT_TYPEDEF_(0x80093101L)
#define CRYPT_E_ASN1_EOD                                   _HRESULT_TYPEDEF_(0x80093102L)
#define CRYPT_E_ASN1_CORRUPT                               _HRESULT_TYPEDEF_(0x80093103L)
#define CRYPT_E_ASN1_LARGE                                 _HRESULT_TYPEDEF_(0x80093104L)
#define CRYPT_E_ASN1_CONSTRAINT                            _HRESULT_TYPEDEF_(0x80093105L)
#define CRYPT_E_ASN1_MEMORY                                _HRESULT_TYPEDEF_(0x80093106L)
#define CRYPT_E_ASN1_OVERFLOW                              _HRESULT_TYPEDEF_(0x80093107L)
#define CRYPT_E_ASN1_BADPDU                                _HRESULT_TYPEDEF_(0x80093108L)
#define CRYPT_E_ASN1_BADARGS                               _HRESULT_TYPEDEF_(0x80093109L)
#define CRYPT_E_ASN1_BADREAL                               _HRESULT_TYPEDEF_(0x8009310AL)
#define CRYPT_E_ASN1_BADTAG                                _HRESULT_TYPEDEF_(0x8009310BL)
#define CRYPT_E_ASN1_CHOICE                                _HRESULT_TYPEDEF_(0x8009310CL)
#define CRYPT_E_ASN1_RULE                                  _HRESULT_TYPEDEF_(0x8009310DL)
#define CRYPT_E_ASN1_UTF8                                  _HRESULT_TYPEDEF_(0x8009310EL)
#define CRYPT_E_ASN1_PDU_TYPE                              _HRESULT_TYPEDEF_(0x80093133L)
#define CRYPT_E_ASN1_NYI                                   _HRESULT_TYPEDEF_(0x80093134L)
#define CRYPT_E_ASN1_EXTENDED                              _HRESULT_TYPEDEF_(0x80093201L)
#define CRYPT_E_ASN1_NOEOD                                 _HRESULT_TYPEDEF_(0x80093202L)

#define TRUST_E_SYSTEM_ERROR                               _HRESULT_TYPEDEF_(0x80096001L)
#define TRUST_E_NO_SIGNER_CERT                             _HRESULT_TYPEDEF_(0x80096002L)
#define TRUST_E_COUNTER_SIGNER                             _HRESULT_TYPEDEF_(0x80096003L)
#define TRUST_E_CERT_SIGNATURE                             _HRESULT_TYPEDEF_(0x80096004L)
#define TRUST_E_TIME_STAMP                                 _HRESULT_TYPEDEF_(0x80096005L)
#define TRUST_E_BAD_DIGEST                                 _HRESULT_TYPEDEF_(0x80096010L)
#define TRUST_E_BASIC_CONSTRAINTS                          _HRESULT_TYPEDEF_(0x80096019L)
#define TRUST_E_FINANCIAL_CRITERIA                         _HRESULT_TYPEDEF_(0x8009601EL)
#define TRUST_E_PROVIDER_UNKNOWN                           _HRESULT_TYPEDEF_(0x800B0001L)
#define TRUST_E_ACTION_UNKNOWN                             _HRESULT_TYPEDEF_(0x800B0002L)
#define TRUST_E_SUBJECT_FORM_UNKNOWN                       _HRESULT_TYPEDEF_(0x800B0003L)
#define TRUST_E_SUBJECT_NOT_TRUSTED                        _HRESULT_TYPEDEF_(0x800B0004L)
#define TRUST_E_NOSIGNATURE                                _HRESULT_TYPEDEF_(0x800B0100L)

#define SPAPI_E_EXPECTED_SECTION_NAME                      _HRESULT_TYPEDEF_(0x800F0000L)
#define SPAPI_E_BAD_SECTION_NAME_LINE                      _HRESULT_TYPEDEF_(0x800F0001L)
#define SPAPI_E_SECTION_NAME_TOO_LONG                      _HRESULT_TYPEDEF_(0x800F0002L)
#define SPAPI_E_GENERAL_SYNTAX                             _HRESULT_TYPEDEF_(0x800F0003L)
#define SPAPI_E_WRONG_INF_STYLE                            _HRESULT_TYPEDEF_(0x800F0100L)
#define SPAPI_E_SECTION_NOT_FOUND                          _HRESULT_TYPEDEF_(0x800F0101L)
#define SPAPI_E_LINE_NOT_FOUND                             _HRESULT_TYPEDEF_(0x800F0102L)
#define SPAPI_E_NO_BACKUP                                  _HRESULT_TYPEDEF_(0x800F0103L)
#define SPAPI_E_NO_ASSOCIATED_CLASS                        _HRESULT_TYPEDEF_(0x800F0200L)
#define SPAPI_E_CLASS_MISMATCH                             _HRESULT_TYPEDEF_(0x800F0201L)
#define SPAPI_E_DUPLICATE_FOUND                            _HRESULT_TYPEDEF_(0x800F0202L)
#define SPAPI_E_NO_DRIVER_SELECTED                         _HRESULT_TYPEDEF_(0x800F0203L)
#define SPAPI_E_KEY_DOES_NOT_EXIST                         _HRESULT_TYPEDEF_(0x800F0204L)
#define SPAPI_E_INVALID_DEVINST_NAME                       _HRESULT_TYPEDEF_(0x800F0205L)
#define SPAPI_E_INVALID_CLASS                              _HRESULT_TYPEDEF_(0x800F0206L)
#define SPAPI_E_DEVINST_ALREADY_EXISTS                     _HRESULT_TYPEDEF_(0x800F0207L)
#define SPAPI_E_DEVINFO_NOT_REGISTERED                     _HRESULT_TYPEDEF_(0x800F0208L)
#define SPAPI_E_INVALID_REG_PROPERTY                       _HRESULT_TYPEDEF_(0x800F0209L)
#define SPAPI_E_NO_INF                                     _HRESULT_TYPEDEF_(0x800F020AL)
#define SPAPI_E_NO_SUCH_DEVINST                            _HRESULT_TYPEDEF_(0x800F020BL)
#define SPAPI_E_CANT_LOAD_CLASS_ICON                       _HRESULT_TYPEDEF_(0x800F020CL)
#define SPAPI_E_INVALID_CLASS_INSTALLER                    _HRESULT_TYPEDEF_(0x800F020DL)
#define SPAPI_E_DI_DO_DEFAULT                              _HRESULT_TYPEDEF_(0x800F020EL)
#define SPAPI_E_DI_NOFILECOPY                              _HRESULT_TYPEDEF_(0x800F020FL)
#define SPAPI_E_INVALID_HWPROFILE                          _HRESULT_TYPEDEF_(0x800F0210L)
#define SPAPI_E_NO_DEVICE_SELECTED                         _HRESULT_TYPEDEF_(0x800F0211L)
#define SPAPI_E_DEVINFO_LIST_LOCKED                        _HRESULT_TYPEDEF_(0x800F0212L)
#define SPAPI_E_DEVINFO_DATA_LOCKED                        _HRESULT_TYPEDEF_(0x800F0213L)
#define SPAPI_E_DI_BAD_PATH                                _HRESULT_TYPEDEF_(0x800F0214L)
#define SPAPI_E_NO_CLASSINSTALL_PARAMS                     _HRESULT_TYPEDEF_(0x800F0215L)
#define SPAPI_E_FILEQUEUE_LOCKED                           _HRESULT_TYPEDEF_(0x800F0216L)
#define SPAPI_E_BAD_SERVICE_INSTALLSECT                    _HRESULT_TYPEDEF_(0x800F0217L)
#define SPAPI_E_NO_CLASS_DRIVER_LIST                       _HRESULT_TYPEDEF_(0x800F0218L)
#define SPAPI_E_NO_ASSOCIATED_SERVICE                      _HRESULT_TYPEDEF_(0x800F0219L)
#define SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE                _HRESULT_TYPEDEF_(0x800F021AL)
#define SPAPI_E_DEVICE_INTERFACE_ACTIVE                    _HRESULT_TYPEDEF_(0x800F021BL)
#define SPAPI_E_DEVICE_INTERFACE_REMOVED                   _HRESULT_TYPEDEF_(0x800F021CL)
#define SPAPI_E_BAD_INTERFACE_INSTALLSECT                  _HRESULT_TYPEDEF_(0x800F021DL)
#define SPAPI_E_NO_SUCH_INTERFACE_CLASS                    _HRESULT_TYPEDEF_(0x800F021EL)
#define SPAPI_E_INVALID_REFERENCE_STRING                   _HRESULT_TYPEDEF_(0x800F021FL)
#define SPAPI_E_INVALID_MACHINENAME                        _HRESULT_TYPEDEF_(0x800F0220L)
#define SPAPI_E_REMOTE_COMM_FAILURE                        _HRESULT_TYPEDEF_(0x800F0221L)
#define SPAPI_E_MACHINE_UNAVAILABLE                        _HRESULT_TYPEDEF_(0x800F0222L)
#define SPAPI_E_NO_CONFIGMGR_SERVICES                      _HRESULT_TYPEDEF_(0x800F0223L)
#define SPAPI_E_INVALID_PROPPAGE_PROVIDER                  _HRESULT_TYPEDEF_(0x800F0224L)
#define SPAPI_E_NO_SUCH_DEVICE_INTERFACE                   _HRESULT_TYPEDEF_(0x800F0225L)
#define SPAPI_E_DI_POSTPROCESSING_REQUIRED                 _HRESULT_TYPEDEF_(0x800F0226L)
#define SPAPI_E_INVALID_COINSTALLER                        _HRESULT_TYPEDEF_(0x800F0227L)
#define SPAPI_E_NO_COMPAT_DRIVERS                          _HRESULT_TYPEDEF_(0x800F0228L)
#define SPAPI_E_NO_DEVICE_ICON                             _HRESULT_TYPEDEF_(0x800F0229L)
#define SPAPI_E_INVALID_INF_LOGCONFIG                      _HRESULT_TYPEDEF_(0x800F022AL)
#define SPAPI_E_DI_DONT_INSTALL                            _HRESULT_TYPEDEF_(0x800F022BL)
#define SPAPI_E_INVALID_FILTER_DRIVER                      _HRESULT_TYPEDEF_(0x800F022CL)
#define SPAPI_E_NON_WINDOWS_NT_DRIVER                      _HRESULT_TYPEDEF_(0x800F022DL)
#define SPAPI_E_NON_WINDOWS_DRIVER                         _HRESULT_TYPEDEF_(0x800F022EL)
#define SPAPI_E_NO_CATALOG_FOR_OEM_INF                     _HRESULT_TYPEDEF_(0x800F022FL)
#define SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE                 _HRESULT_TYPEDEF_(0x800F0230L)
#define SPAPI_E_NOT_DISABLEABLE                            _HRESULT_TYPEDEF_(0x800F0231L)
#define SPAPI_E_CANT_REMOVE_DEVINST                        _HRESULT_TYPEDEF_(0x800F0232L)
#define SPAPI_E_INVALID_TARGET                             _HRESULT_TYPEDEF_(0x800F0233L)
#define SPAPI_E_DRIVER_NONNATIVE                           _HRESULT_TYPEDEF_(0x800F0234L)
#define SPAPI_E_IN_WOW64                                   _HRESULT_TYPEDEF_(0x800F0235L)
#define SPAPI_E_SET_SYSTEM_RESTORE_POINT                   _HRESULT_TYPEDEF_(0x800F0236L)
#define SPAPI_E_INCORRECTLY_COPIED_INF                     _HRESULT_TYPEDEF_(0x800F0237L)
#define SPAPI_E_SCE_DISABLED                               _HRESULT_TYPEDEF_(0x800F0238L)
#define SPAPI_E_ERROR_NOT_INSTALLED                        _HRESULT_TYPEDEF_(0x800F1000L)

/* Smart card management error codes */
#define SCARD_S_SUCCESS                                    NO_ERROR
#define SCARD_F_INTERNAL_ERROR                             _HRESULT_TYPEDEF_(0x80100001L)
#define SCARD_E_CANCELLED                                  _HRESULT_TYPEDEF_(0x80100002L)
#define SCARD_E_INVALID_HANDLE                             _HRESULT_TYPEDEF_(0x80100003L)
#define SCARD_E_INVALID_PARAMETER                          _HRESULT_TYPEDEF_(0x80100004L)
#define SCARD_E_INVALID_TARGET                             _HRESULT_TYPEDEF_(0x80100005L)
#define SCARD_E_NO_MEMORY                                  _HRESULT_TYPEDEF_(0x80100006L)
#define SCARD_F_WAITED_TOO_LONG                            _HRESULT_TYPEDEF_(0x80100007L)
#define SCARD_E_INSUFFICIENT_BUFFER                        _HRESULT_TYPEDEF_(0x80100008L)
#define SCARD_E_UNKNOWN_READER                             _HRESULT_TYPEDEF_(0x80100009L)
#define SCARD_E_TIMEOUT                                    _HRESULT_TYPEDEF_(0x8010000AL)
#define SCARD_E_SHARING_VIOLATION                          _HRESULT_TYPEDEF_(0x8010000BL)
#define SCARD_E_NO_SMARTCARD                               _HRESULT_TYPEDEF_(0x8010000CL)
#define SCARD_E_UNKNOWN_CARD                               _HRESULT_TYPEDEF_(0x8010000DL)
#define SCARD_E_CANT_DISPOSE                               _HRESULT_TYPEDEF_(0x8010000EL)
#define SCARD_E_PROTO_MISMATCH                             _HRESULT_TYPEDEF_(0x8010000FL)
#define SCARD_E_NOT_READY                                  _HRESULT_TYPEDEF_(0x80100010L)
#define SCARD_E_INVALID_VALUE                              _HRESULT_TYPEDEF_(0x80100011L)
#define SCARD_E_SYSTEM_CANCELLED                           _HRESULT_TYPEDEF_(0x80100012L)
#define SCARD_F_COMM_ERROR                                 _HRESULT_TYPEDEF_(0x80100013L)
#define SCARD_F_UNKNOWN_ERROR                              _HRESULT_TYPEDEF_(0x80100014L)
#define SCARD_E_INVALID_ATR                                _HRESULT_TYPEDEF_(0x80100015L)
#define SCARD_E_NOT_TRANSACTED                             _HRESULT_TYPEDEF_(0x80100016L)
#define SCARD_E_READER_UNAVAILABLE                         _HRESULT_TYPEDEF_(0x80100017L)
#define SCARD_P_SHUTDOWN                                   _HRESULT_TYPEDEF_(0x80100018L)
#define SCARD_E_PCI_TOO_SMALL                              _HRESULT_TYPEDEF_(0x80100019L)
#define SCARD_E_READER_UNSUPPORTED                         _HRESULT_TYPEDEF_(0x8010001AL)
#define SCARD_E_DUPLICATE_READER                           _HRESULT_TYPEDEF_(0x8010001BL)
#define SCARD_E_CARD_UNSUPPORTED                           _HRESULT_TYPEDEF_(0x8010001CL)
#define SCARD_E_NO_SERVICE                                 _HRESULT_TYPEDEF_(0x8010001DL)
#define SCARD_E_SERVICE_STOPPED                            _HRESULT_TYPEDEF_(0x8010001EL)
#define SCARD_E_UNEXPECTED                                 _HRESULT_TYPEDEF_(0x8010001FL)
#define SCARD_E_ICC_INSTALLATION                           _HRESULT_TYPEDEF_(0x80100020L)
#define SCARD_E_ICC_CREATEORDER                            _HRESULT_TYPEDEF_(0x80100021L)
#define SCARD_E_UNSUPPORTED_FEATURE                        _HRESULT_TYPEDEF_(0x80100022L)
#define SCARD_E_DIR_NOT_FOUND                              _HRESULT_TYPEDEF_(0x80100023L)
#define SCARD_E_FILE_NOT_FOUND                             _HRESULT_TYPEDEF_(0x80100024L)
#define SCARD_E_NO_DIR                                     _HRESULT_TYPEDEF_(0x80100025L)
#define SCARD_E_NO_FILE                                    _HRESULT_TYPEDEF_(0x80100026L)
#define SCARD_E_NO_ACCESS                                  _HRESULT_TYPEDEF_(0x80100027L)
#define SCARD_E_WRITE_TOO_MANY                             _HRESULT_TYPEDEF_(0x80100028L)
#define SCARD_E_BAD_SEEK                                   _HRESULT_TYPEDEF_(0x80100029L)
#define SCARD_E_INVALID_CHV                                _HRESULT_TYPEDEF_(0x8010002AL)
#define SCARD_E_UNKNOWN_RES_MNG                            _HRESULT_TYPEDEF_(0x8010002BL)
#define SCARD_E_NO_SUCH_CERTIFICATE                        _HRESULT_TYPEDEF_(0x8010002CL)
#define SCARD_E_CERTIFICATE_UNAVAILABLE                    _HRESULT_TYPEDEF_(0x8010002DL)
#define SCARD_E_NO_READERS_AVAILABLE                       _HRESULT_TYPEDEF_(0x8010002EL)
#define SCARD_E_COMM_DATA_LOST                             _HRESULT_TYPEDEF_(0x8010002FL)
#define SCARD_E_NO_KEY_CONTAINER                           _HRESULT_TYPEDEF_(0x80100030L)
#define SCARD_E_SERVER_TOO_BUSY                            _HRESULT_TYPEDEF_(0x80100031L)
#define SCARD_W_UNSUPPORTED_CARD                           _HRESULT_TYPEDEF_(0x80100065L)
#define SCARD_W_UNRESPONSIVE_CARD                          _HRESULT_TYPEDEF_(0x80100066L)
#define SCARD_W_UNPOWERED_CARD                             _HRESULT_TYPEDEF_(0x80100067L)
#define SCARD_W_RESET_CARD                                 _HRESULT_TYPEDEF_(0x80100068L)
#define SCARD_W_REMOVED_CARD                               _HRESULT_TYPEDEF_(0x80100069L)
#define SCARD_W_SECURITY_VIOLATION                         _HRESULT_TYPEDEF_(0x8010006AL)
#define SCARD_W_WRONG_CHV                                  _HRESULT_TYPEDEF_(0x8010006BL)
#define SCARD_W_CHV_BLOCKED                                _HRESULT_TYPEDEF_(0x8010006CL)
#define SCARD_W_EOF                                        _HRESULT_TYPEDEF_(0x8010006DL)
#define SCARD_W_CANCELLED_BY_USER                          _HRESULT_TYPEDEF_(0x8010006EL)
#define SCARD_W_CARD_NOT_AUTHENTICATED                     _HRESULT_TYPEDEF_(0x8010006FL)
#define SCARD_W_CACHE_ITEM_NOT_FOUND                       _HRESULT_TYPEDEF_(0x80100070L)
#define SCARD_W_CACHE_ITEM_STALE                           _HRESULT_TYPEDEF_(0x80100071L)
#define SCARD_W_CACHE_ITEM_TOO_BIG                         _HRESULT_TYPEDEF_(0x80100072L)

#define ERROR_AUDITING_DISABLED                            _HRESULT_TYPEDEF_(0xC0090001L)
#define ERROR_ALL_SIDS_FILTERED                            _HRESULT_TYPEDEF_(0xC0090002L)

#endif  /* __WINE_WINERROR_H */
