/*
 * Copyright 2008 Henri Verbeet for CodeWeavers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __WINE_DXGI_PRIVATE_H
#define __WINE_DXGI_PRIVATE_H

#include "wine/debug.h"

#define COBJMACROS
#include "winbase.h"
#include "winuser.h"
#include "objbase.h"

#include "dxgi.h"

/* TRACE helper functions */
const char *debug_dxgi_format(DXGI_FORMAT format);

/* IDXGIFactory */
extern const struct IDXGIFactoryVtbl dxgi_factory_vtbl;
struct dxgi_factory
{
    const struct IDXGIFactoryVtbl *vtbl;
    LONG refcount;
};

/* IDXGIDevice */
extern const struct IDXGIDeviceVtbl dxgi_device_vtbl;
struct dxgi_device
{
    const struct IDXGIDeviceVtbl *vtbl;
    LONG refcount;
};

/* IDXGIAdapter */
extern const struct IDXGIAdapterVtbl dxgi_adapter_vtbl;
struct dxgi_adapter
{
    const struct IDXGIAdapterVtbl *vtbl;
    LONG refcount;
};

/* IDXGISwapChain */
extern const struct IDXGISwapChainVtbl dxgi_swapchain_vtbl;
struct dxgi_swapchain
{
    const struct IDXGISwapChainVtbl *vtbl;
    LONG refcount;
};

#endif /* __WINE_DXGI_PRIVATE_H */
