/*
 * Copyright 2007 Henri Verbeet
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __WINE_WINED3D_CAPS_H
#define __WINE_WINED3D_CAPS_H

#define WINED3DCAPS3_ALPHA_FULLSCREEN_FLIP_OR_DISCARD       0x00000020L
#define WINED3DCAPS3_LINEAR_TO_SRGB_PRESENTATION            0x00000080L
#define WINED3DCAPS3_COPY_TO_VIDMEM                         0x00000100L
#define WINED3DCAPS3_COPY_TO_SYSTEMMEM                      0x00000200L
#define WINED3DCAPS3_RESERVED                               0x8000001FL

#define WINED3DDEVCAPS2_STREAMOFFSET                        0x00000001
#define WINED3DDEVCAPS2_DMAPNPATCH                          0x00000002
#define WINED3DDEVCAPS2_ADAPTIVETESSRTPATCH                 0x00000004
#define WINED3DDEVCAPS2_ADAPTIVETESSNPATCH                  0x00000008
#define WINED3DDEVCAPS2_CAN_STRETCHRECT_FROM_TEXTURES       0x00000010
#define WINED3DDEVCAPS2_PRESAMPLEDDMAPNPATCH                0x00000020
#define WINED3DDEVCAPS2_VERTEXELEMENTSCANSHARESTREAMOFFSET  0x00000040

#define WINED3DDTCAPS_UBYTE4                                0x00000001
#define WINED3DDTCAPS_UBYTE4N                               0x00000002
#define WINED3DDTCAPS_SHORT2N                               0x00000004
#define WINED3DDTCAPS_SHORT4N                               0x00000008
#define WINED3DDTCAPS_USHORT2N                              0x00000010
#define WINED3DDTCAPS_USHORT4N                              0x00000020
#define WINED3DDTCAPS_UDEC3                                 0x00000040
#define WINED3DDTCAPS_DEC3N                                 0x00000080
#define WINED3DDTCAPS_FLOAT16_2                             0x00000100
#define WINED3DDTCAPS_FLOAT16_4                             0x00000200

#define WINED3DFVFCAPS_TEXCOORDCOUNTMASK                    0x0000FFFF
#define WINED3DFVFCAPS_DONOTSTRIPELEMENTS                   0x00080000
#define WINED3DFVFCAPS_PSIZE                                0x00100000

#define WINED3DLINECAPS_TEXTURE                             0x00000001
#define WINED3DLINECAPS_ZTEST                               0x00000002
#define WINED3DLINECAPS_BLEND                               0x00000004
#define WINED3DLINECAPS_ALPHACMP                            0x00000008
#define WINED3DLINECAPS_FOG                                 0x00000010
#define WINED3DLINECAPS_ANTIALIAS                           0x00000020

#define WINED3DMAX30SHADERINSTRUCTIONS                      32768
#define WINED3DMIN30SHADERINSTRUCTIONS                      512

#define WINED3DPBLENDCAPS_ZERO                              0x00000001
#define WINED3DPBLENDCAPS_ONE                               0x00000002
#define WINED3DPBLENDCAPS_SRCCOLOR                          0x00000004
#define WINED3DPBLENDCAPS_INVSRCCOLOR                       0x00000008
#define WINED3DPBLENDCAPS_SRCALPHA                          0x00000010
#define WINED3DPBLENDCAPS_INVSRCALPHA                       0x00000020
#define WINED3DPBLENDCAPS_DESTALPHA                         0x00000040
#define WINED3DPBLENDCAPS_INVDESTALPHA                      0x00000080
#define WINED3DPBLENDCAPS_DESTCOLOR                         0x00000100
#define WINED3DPBLENDCAPS_INVDESTCOLOR                      0x00000200
#define WINED3DPBLENDCAPS_SRCALPHASAT                       0x00000400
#define WINED3DPBLENDCAPS_BOTHSRCALPHA                      0x00000800
#define WINED3DPBLENDCAPS_BOTHINVSRCALPHA                   0x00001000
#define WINED3DPBLENDCAPS_BLENDFACTOR                       0x00002000

#define WINED3DPCMPCAPS_NEVER                               0x00000001
#define WINED3DPCMPCAPS_LESS                                0x00000002
#define WINED3DPCMPCAPS_EQUAL                               0x00000004
#define WINED3DPCMPCAPS_LESSEQUAL                           0x00000008
#define WINED3DPCMPCAPS_GREATER                             0x00000010
#define WINED3DPCMPCAPS_NOTEQUAL                            0x00000020
#define WINED3DPCMPCAPS_GREATEREQUAL                        0x00000040
#define WINED3DPCMPCAPS_ALWAYS                              0x00000080

#define WINED3DPMISCCAPS_MASKZ                              0x00000002
#define WINED3DPMISCCAPS_LINEPATTERNREP                     0x00000004
#define WINED3DPMISCCAPS_CULLNONE                           0x00000010
#define WINED3DPMISCCAPS_CULLCW                             0x00000020
#define WINED3DPMISCCAPS_CULLCCW                            0x00000040
#define WINED3DPMISCCAPS_COLORWRITEENABLE                   0x00000080
#define WINED3DPMISCCAPS_CLIPPLANESCALEDPOINTS              0x00000100
#define WINED3DPMISCCAPS_CLIPTLVERTS                        0x00000200
#define WINED3DPMISCCAPS_TSSARGTEMP                         0x00000400
#define WINED3DPMISCCAPS_BLENDOP                            0x00000800
#define WINED3DPMISCCAPS_NULLREFERENCE                      0x00001000
#define WINED3DPMISCCAPS_INDEPENDENTWRITEMASKS              0x00004000
#define WINED3DPMISCCAPS_PERSTAGECONSTANT                   0x00008000
#define WINED3DPMISCCAPS_FOGANDSPECULARALPHA                0x00010000
#define WINED3DPMISCCAPS_SEPARATEALPHABLEND                 0x00020000
#define WINED3DPMISCCAPS_MRTINDEPENDENTBITDEPTHS            0x00040000
#define WINED3DPMISCCAPS_MRTPOSTPIXELSHADERBLENDING         0x00080000
#define WINED3DPMISCCAPS_FOGVERTEXCLAMPED                   0x00100000

#define WINED3DPS20_MAX_DYNAMICFLOWCONTROLDEPTH             24
#define WINED3DPS20_MIN_DYNAMICFLOWCONTROLDEPTH             0
#define WINED3DPS20_MAX_NUMTEMPS                            32
#define WINED3DPS20_MIN_NUMTEMPS                            12
#define WINED3DPS20_MAX_STATICFLOWCONTROLDEPTH              4
#define WINED3DPS20_MIN_STATICFLOWCONTROLDEPTH              0
#define WINED3DPS20_MAX_NUMINSTRUCTIONSLOTS                 512
#define WINED3DPS20_MIN_NUMINSTRUCTIONSLOTS                 96

#define WINED3DPS20CAPS_ARBITRARYSWIZZLE                    0x00000001
#define WINED3DPS20CAPS_GRADIENTINSTRUCTIONS                0x00000002
#define WINED3DPS20CAPS_PREDICATION                         0x00000004
#define WINED3DPS20CAPS_NODEPENDENTREADLIMIT                0x00000008
#define WINED3DPS20CAPS_NOTEXINSTRUCTIONLIMIT               0x00000010

#define WINED3DPTADDRESSCAPS_WRAP                           0x00000001
#define WINED3DPTADDRESSCAPS_MIRROR                         0x00000002
#define WINED3DPTADDRESSCAPS_CLAMP                          0x00000004
#define WINED3DPTADDRESSCAPS_BORDER                         0x00000008
#define WINED3DPTADDRESSCAPS_INDEPENDENTUV                  0x00000010
#define WINED3DPTADDRESSCAPS_MIRRORONCE                     0x00000020

#define WINED3DSTENCILCAPS_KEEP                             0x00000001
#define WINED3DSTENCILCAPS_ZERO                             0x00000002
#define WINED3DSTENCILCAPS_REPLACE                          0x00000004
#define WINED3DSTENCILCAPS_INCRSAT                          0x00000008
#define WINED3DSTENCILCAPS_DECRSAT                          0x00000010
#define WINED3DSTENCILCAPS_INVERT                           0x00000020
#define WINED3DSTENCILCAPS_INCR                             0x00000040
#define WINED3DSTENCILCAPS_DECR                             0x00000080
#define WINED3DSTENCILCAPS_TWOSIDED                         0x00000100

#define WINED3DTEXOPCAPS_DISABLE                            0x00000001
#define WINED3DTEXOPCAPS_SELECTARG1                         0x00000002
#define WINED3DTEXOPCAPS_SELECTARG2                         0x00000004
#define WINED3DTEXOPCAPS_MODULATE                           0x00000008
#define WINED3DTEXOPCAPS_MODULATE2X                         0x00000010
#define WINED3DTEXOPCAPS_MODULATE4X                         0x00000020
#define WINED3DTEXOPCAPS_ADD                                0x00000040
#define WINED3DTEXOPCAPS_ADDSIGNED                          0x00000080
#define WINED3DTEXOPCAPS_ADDSIGNED2X                        0x00000100
#define WINED3DTEXOPCAPS_SUBTRACT                           0x00000200
#define WINED3DTEXOPCAPS_ADDSMOOTH                          0x00000400
#define WINED3DTEXOPCAPS_BLENDDIFFUSEALPHA                  0x00000800
#define WINED3DTEXOPCAPS_BLENDTEXTUREALPHA                  0x00001000
#define WINED3DTEXOPCAPS_BLENDFACTORALPHA                   0x00002000
#define WINED3DTEXOPCAPS_BLENDTEXTUREALPHAPM                0x00004000
#define WINED3DTEXOPCAPS_BLENDCURRENTALPHA                  0x00008000
#define WINED3DTEXOPCAPS_PREMODULATE                        0x00010000
#define WINED3DTEXOPCAPS_MODULATEALPHA_ADDCOLOR             0x00020000
#define WINED3DTEXOPCAPS_MODULATECOLOR_ADDALPHA             0x00040000
#define WINED3DTEXOPCAPS_MODULATEINVALPHA_ADDCOLOR          0x00080000
#define WINED3DTEXOPCAPS_MODULATEINVCOLOR_ADDALPHA          0x00100000
#define WINED3DTEXOPCAPS_BUMPENVMAP                         0x00200000
#define WINED3DTEXOPCAPS_BUMPENVMAPLUMINANCE                0x00400000
#define WINED3DTEXOPCAPS_DOTPRODUCT3                        0x00800000
#define WINED3DTEXOPCAPS_MULTIPLYADD                        0x01000000
#define WINED3DTEXOPCAPS_LERP                               0x02000000

#define WINED3DVS20_MAX_DYNAMICFLOWCONTROLDEPTH             24
#define WINED3DVS20_MIN_DYNAMICFLOWCONTROLDEPTH             0
#define WINED3DVS20_MAX_NUMTEMPS                            32
#define WINED3DVS20_MIN_NUMTEMPS                            12
#define WINED3DVS20_MAX_STATICFLOWCONTROLDEPTH              4
#define WINED3DVS20_MIN_STATICFLOWCONTROLDEPTH              1

#define WINED3DVS20CAPS_PREDICATION                         0x00000001

/* DirectDraw Caps */
#define WINEDDSCAPS_RESERVED1               0x00000001
#define WINEDDSCAPS_ALPHA                   0x00000002
#define WINEDDSCAPS_BACKBUFFER              0x00000004
#define WINEDDSCAPS_COMPLEX                 0x00000008
#define WINEDDSCAPS_FLIP                    0x00000010
#define WINEDDSCAPS_FRONTBUFFER             0x00000020
#define WINEDDSCAPS_OFFSCREENPLAIN          0x00000040
#define WINEDDSCAPS_OVERLAY                 0x00000080
#define WINEDDSCAPS_PALETTE                 0x00000100
#define WINEDDSCAPS_PRIMARYSURFACE          0x00000200
#define WINEDDSCAPS_PRIMARYSURFACELEFT      0x00000400
#define WINEDDSCAPS_SYSTEMMEMORY            0x00000800
#define WINEDDSCAPS_TEXTURE                 0x00001000
#define WINEDDSCAPS_3DDEVICE                0x00002000
#define WINEDDSCAPS_VIDEOMEMORY             0x00004000
#define WINEDDSCAPS_VISIBLE                 0x00008000
#define WINEDDSCAPS_WRITEONLY               0x00010000
#define WINEDDSCAPS_ZBUFFER                 0x00020000
#define WINEDDSCAPS_OWNDC                   0x00040000
#define WINEDDSCAPS_LIVEVIDEO               0x00080000
#define WINEDDSCAPS_HWCODEC                 0x00100000
#define WINEDDSCAPS_MODEX                   0x00200000
#define WINEDDSCAPS_MIPMAP                  0x00400000
#define WINEDDSCAPS_RESERVED2               0x00800000
#define WINEDDSCAPS_ALLOCONLOAD             0x04000000
#define WINEDDSCAPS_VIDEOPORT               0x08000000
#define WINEDDSCAPS_LOCALVIDMEM             0x10000000
#define WINEDDSCAPS_NONLOCALVIDMEM          0x20000000
#define WINEDDSCAPS_STANDARDVGAMODE         0x40000000
#define WINEDDSCAPS_OPTIMIZED               0x80000000

#define WINEDDCKEYCAPS_DESTBLT                      0x00000001
#define WINEDDCKEYCAPS_DESTBLTCLRSPACE              0x00000002
#define WINEDDCKEYCAPS_DESTBLTCLRSPACEYUV           0x00000004
#define WINEDDCKEYCAPS_DESTBLTYUV                   0x00000008
#define WINEDDCKEYCAPS_DESTOVERLAY                  0x00000010
#define WINEDDCKEYCAPS_DESTOVERLAYCLRSPACE          0x00000020
#define WINEDDCKEYCAPS_DESTOVERLAYCLRSPACEYUV       0x00000040
#define WINEDDCKEYCAPS_DESTOVERLAYONEACTIVE         0x00000080
#define WINEDDCKEYCAPS_DESTOVERLAYYUV               0x00000100
#define WINEDDCKEYCAPS_SRCBLT                       0x00000200
#define WINEDDCKEYCAPS_SRCBLTCLRSPACE               0x00000400
#define WINEDDCKEYCAPS_SRCBLTCLRSPACEYUV            0x00000800
#define WINEDDCKEYCAPS_SRCBLTYUV                    0x00001000
#define WINEDDCKEYCAPS_SRCOVERLAY                   0x00002000
#define WINEDDCKEYCAPS_SRCOVERLAYCLRSPACE           0x00004000
#define WINEDDCKEYCAPS_SRCOVERLAYCLRSPACEYUV        0x00008000
#define WINEDDCKEYCAPS_SRCOVERLAYONEACTIVE          0x00010000
#define WINEDDCKEYCAPS_SRCOVERLAYYUV                0x00020000
#define WINEDDCKEYCAPS_NOCOSTOVERLAY                0x00040000

#define WINEDDFXCAPS_BLTALPHA               0x00000001
#define WINEDDFXCAPS_OVERLAYALPHA           0x00000004
#define WINEDDFXCAPS_BLTARITHSTRETCHYN      0x00000010
#define WINEDDFXCAPS_BLTARITHSTRETCHY       0x00000020
#define WINEDDFXCAPS_BLTMIRRORLEFTRIGHT     0x00000040
#define WINEDDFXCAPS_BLTMIRRORUPDOWN        0x00000080
#define WINEDDFXCAPS_BLTROTATION            0x00000100
#define WINEDDFXCAPS_BLTROTATION90          0x00000200
#define WINEDDFXCAPS_BLTSHRINKX             0x00000400
#define WINEDDFXCAPS_BLTSHRINKXN            0x00000800
#define WINEDDFXCAPS_BLTSHRINKY             0x00001000
#define WINEDDFXCAPS_BLTSHRINKYN            0x00002000
#define WINEDDFXCAPS_BLTSTRETCHX            0x00004000
#define WINEDDFXCAPS_BLTSTRETCHXN           0x00008000
#define WINEDDFXCAPS_BLTSTRETCHY            0x00010000
#define WINEDDFXCAPS_BLTSTRETCHYN           0x00020000
#define WINEDDFXCAPS_OVERLAYARITHSTRETCHY   0x00040000
#define WINEDDFXCAPS_OVERLAYARITHSTRETCHYN  0x00000008
#define WINEDDFXCAPS_OVERLAYSHRINKX         0x00080000
#define WINEDDFXCAPS_OVERLAYSHRINKXN        0x00100000
#define WINEDDFXCAPS_OVERLAYSHRINKY         0x00200000
#define WINEDDFXCAPS_OVERLAYSHRINKYN        0x00400000
#define WINEDDFXCAPS_OVERLAYSTRETCHX        0x00800000
#define WINEDDFXCAPS_OVERLAYSTRETCHXN       0x01000000
#define WINEDDFXCAPS_OVERLAYSTRETCHY        0x02000000
#define WINEDDFXCAPS_OVERLAYSTRETCHYN       0x04000000
#define WINEDDFXCAPS_OVERLAYMIRRORLEFTRIGHT 0x08000000
#define WINEDDFXCAPS_OVERLAYMIRRORUPDOWN    0x10000000

#define WINEDDCAPS_3D                       0x00000001
#define WINEDDCAPS_ALIGNBOUNDARYDEST        0x00000002
#define WINEDDCAPS_ALIGNSIZEDEST            0x00000004
#define WINEDDCAPS_ALIGNBOUNDARYSRC         0x00000008
#define WINEDDCAPS_ALIGNSIZESRC             0x00000010
#define WINEDDCAPS_ALIGNSTRIDE              0x00000020
#define WINEDDCAPS_BLT                      0x00000040
#define WINEDDCAPS_BLTQUEUE                 0x00000080
#define WINEDDCAPS_BLTFOURCC                0x00000100
#define WINEDDCAPS_BLTSTRETCH               0x00000200
#define WINEDDCAPS_GDI                      0x00000400
#define WINEDDCAPS_OVERLAY                  0x00000800
#define WINEDDCAPS_OVERLAYCANTCLIP          0x00001000
#define WINEDDCAPS_OVERLAYFOURCC            0x00002000
#define WINEDDCAPS_OVERLAYSTRETCH           0x00004000
#define WINEDDCAPS_PALETTE                  0x00008000
#define WINEDDCAPS_PALETTEVSYNC             0x00010000
#define WINEDDCAPS_READSCANLINE             0x00020000
#define WINEDDCAPS_STEREOVIEW               0x00040000
#define WINEDDCAPS_VBI                      0x00080000
#define WINEDDCAPS_ZBLTS                    0x00100000
#define WINEDDCAPS_ZOVERLAYS                0x00200000
#define WINEDDCAPS_COLORKEY                 0x00400000
#define WINEDDCAPS_ALPHA                    0x00800000
#define WINEDDCAPS_COLORKEYHWASSIST         0x01000000
#define WINEDDCAPS_NOHARDWARE               0x02000000
#define WINEDDCAPS_BLTCOLORFILL             0x04000000
#define WINEDDCAPS_BANKSWITCHED             0x08000000
#define WINEDDCAPS_BLTDEPTHFILL             0x10000000
#define WINEDDCAPS_CANCLIP                  0x20000000
#define WINEDDCAPS_CANCLIPSTRETCHED         0x40000000
#define WINEDDCAPS_CANBLTSYSMEM             0x80000000

#define WINEDDCAPS2_CERTIFIED               0x00000001
#define WINEDDCAPS2_NO2DDURING3DSCENE       0x00000002
#define WINEDDCAPS2_VIDEOPORT               0x00000004
#define WINEDDCAPS2_AUTOFLIPOVERLAY         0x00000008
#define WINEDDCAPS2_CANBOBINTERLEAVED       0x00000010
#define WINEDDCAPS2_CANBOBNONINTERLEAVED    0x00000020
#define WINEDDCAPS2_COLORCONTROLOVERLAY     0x00000040
#define WINEDDCAPS2_COLORCONTROLPRIMARY     0x00000080
#define WINEDDCAPS2_CANDROPZ16BIT           0x00000100
#define WINEDDCAPS2_NONLOCALVIDMEM          0x00000200
#define WINEDDCAPS2_NONLOCALVIDMEMCAPS      0x00000400
#define WINEDDCAPS2_NOPAGELOCKREQUIRED      0x00000800
#define WINEDDCAPS2_WIDESURFACES            0x00001000
#define WINEDDCAPS2_CANFLIPODDEVEN          0x00002000
#define WINEDDCAPS2_CANBOBHARDWARE          0x00004000
#define WINEDDCAPS2_COPYFOURCC              0x00008000
#define WINEDDCAPS2_PRIMARYGAMMA            0x00020000
#define WINEDDCAPS2_CANRENDERWINDOWED       0x00080000
#define WINEDDCAPS2_CANCALIBRATEGAMMA       0x00100000
#define WINEDDCAPS2_FLIPINTERVAL            0x00200000
#define WINEDDCAPS2_FLIPNOVSYNC             0x00400000
#define WINEDDCAPS2_CANMANAGETEXTURE        0x00800000
#define WINEDDCAPS2_TEXMANINNONLOCALVIDMEM  0x01000000
#define WINEDDCAPS2_STEREO                  0x02000000
#define WINEDDCAPS2_SYSTONONLOCAL_AS_SYSTOLOCAL   0x04000000

#endif /* __WINE_WINED3D_CAPS_H */
