/*
 * Windows Error Reporing definitions
 *
 * Copyright (C) 2010 Louis Lenders
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __WINE_WERAPI_H
#define __WINE_WERAPI_H

#ifdef __cplusplus
extern "C" {
#endif


typedef HANDLE HREPORT;

typedef enum _WER_REGISTER_FILE_TYPE
{
    WerRegFileTypeUserDocument = 1,
    WerRegFileTypeOther = 2,
    WerRegFileTypeMax
} WER_REGISTER_FILE_TYPE;

typedef struct _WER_REPORT_INFORMATION
{
    DWORD   dwSize;
    HANDLE  hProcess;
    WCHAR   wzConsentKey[64];
    WCHAR   wzFriendlyEventName[128];
    WCHAR   wzApplicationName[128];
    WCHAR   wzApplicationPath[MAX_PATH];
    WCHAR   wzDescription[512];
    HWND    hwndParent;
} WER_REPORT_INFORMATION, *PWER_REPORT_INFORMATION;


typedef enum _WER_REPORT_TYPE
{
    WerReportNonCritical = 0,
    WerReportCritical,
    WerReportApplicationCrash,
    WerReportApplicationHang,
    WerReportKernel,
    WerReportInvalid
} WER_REPORT_TYPE;

HRESULT WINAPI WerAddExcludedApplication(PCWSTR, BOOL);
HRESULT WINAPI WerRegisterFile(PCWSTR file, WER_REGISTER_FILE_TYPE regfiletype, DWORD flags);
HRESULT WINAPI WerRemoveExcludedApplication(PCWSTR, BOOL);
HRESULT WINAPI WerReportCloseHandle(HREPORT);
HRESULT WINAPI WerReportCreate(PCWSTR, WER_REPORT_TYPE, PWER_REPORT_INFORMATION, HREPORT*);

#ifdef __cplusplus
}
#endif

#endif /* __WINE_WERAPI_H */
