#!/bin/sh
PATCH_DATA=$(cat);
PATCH_LINES=$(echo "${PATCH_DATA}" | wc -l);
PATCH_LINES=$((${PATCH_LINES}+20));

cat <<EOF
From: "FDS-Team" <webmaster@fds-team.de>
Subject: Autogenerated patch list.

---
diff --git a/libs/wine/config.c b/libs/wine/config.c
index a273502..5fa0cd5 100644
--- a/libs/wine/config.c
+++ b/libs/wine/config.c
@@ -478,6 +478,${PATCH_LINES} @@ const char *wine_get_version(void)
     return PACKAGE_VERSION;
 }
 
+struct wine_patch {
+    const char *name;
+    const char *author;
+    const char *title;
+} wine_patch_data[] = {
${PATCH_DATA}
+    { NULL, NULL, NULL }
+};
+
+/* return the applied non-standard patches */
+const void * wine_get_patches(void)
+{
+    return &wine_patch_data[0];
+}
+
 /* return the build id string */
 const char *wine_get_build_id(void)
 {
diff --git a/libs/wine/wine.def b/libs/wine/wine.def
index ed315bd..5b42029 100644
--- a/libs/wine/wine.def
+++ b/libs/wine/wine.def
@@ -83,6 +83,7 @@ EXPORTS
     wine_get_sortkey
     wine_get_user_name
     wine_get_version
+    wine_get_patches
     wine_init
     wine_init_argv0_path
     wine_is_dbcs_leadbyte
diff --git a/libs/wine/wine.map b/libs/wine/wine.map
index 2159fac..7cb2918 100644
--- a/libs/wine/wine.map
+++ b/libs/wine/wine.map
@@ -90,6 +90,7 @@ WINE_1.0
     wine_get_ss;
     wine_get_user_name;
     wine_get_version;
+    wine_get_patches;
     wine_init;
     wine_init_argv0_path;
     wine_is_dbcs_leadbyte;
diff --git a/include/wine/library.h b/include/wine/library.h
index 242bb69..aa9e585 100644
--- a/include/wine/library.h
+++ b/include/wine/library.h
@@ -43,6 +43,7 @@ extern const char *wine_get_data_dir(void);
 extern const char *wine_get_server_dir(void);
 extern const char *wine_get_user_name(void);
 extern const char *wine_get_version(void);
+extern const void *wine_get_patches(void);
 extern const char *wine_get_build_id(void);
 extern void wine_init_argv0_path( const char *argv0 );
 extern void wine_exec_wine_binary( const char *name, char **argv, const char *env_var );
EOF
