#!/bin/bash
# Installation: ln -s ../../precommit-hook.sh .git/hooks/pre-commit

warning()
{
	echo ""
	echo "*** $1 ***"
	echo ""
}

if git status --porcelain "debian" | grep "^.[^ ]" &> /dev/null; then
	warning "PLEASE ADD OR STASH YOUR CHANGES IN debian"
	exit 1
fi

if git status --porcelain "patches" | grep -v "^.\\?.*\\.py$" | grep "^.[^ ]" &> /dev/null; then
	warning "PLEASE ADD OR STASH YOUR CHANGES IN patches"
	exit 1
fi

git diff --cached --name-status | while read status file; do
	if [[ "$file" =~ ^patches/ ]] || [[ "$file" =~ ^debian/tools/ ]] || [[ "$file" =~ ^debian/changelog ]]; then
		warning "UPDATING AUTOGENERATED FILES"
		debian/tools/patchupdate.py || exit 1
		break;
	fi
done
