#!/bin/sh
#
# Script to automatically install all Wine Staging patches
#
# Copyright (C) 2015-2016 Sebastian Lackner
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#

# Show usage information
usage()
{
	echo ""
	echo "Usage: ./patchinstall.sh [DESTDIR=path] [--all] [-W patchset] [patchset ...]"
	echo ""
	echo "Autogenerated script to apply all Wine Staging patches on your Wine"
	echo "source tree."
	echo ""
	echo "Configuration:"
	echo "  DESTDIR=path         Specify the path to the wine source tree"
	echo "  --all                Select all patches"
	echo "  --force-autoconf     Run autoreconf and tools/make_requests after each patch"
	echo "  --help               Display this help and exit"
	echo "  --no-autoconf        Do not run autoreconf and tools/make_requests"
	echo "  --no-patchlist       Do not apply patchlist (needed for 'wine --patches')"
	echo "  --upstream-commit    Print the upstream Wine commit SHA1 and exit"
	echo "  --version            Show version information and exit"
	echo "  -W patchset          Exclude a specific patchset"
	echo ""
	echo "Backends:"
	echo "  --backend=patch      Use regular 'patch' utility to apply patches (default)"
	echo "  --backend=epatch     Use 'epatch' to apply patches (Gentoo only)"
	echo "  --backend=git-am     Use 'git am' to apply patches"
	echo "  --backend=git-apply  Use 'git apply' to apply patches"
	echo "  --backend=stg        Import the patches using stacked git"
	echo ""
}

# Get the upstream commit sha
upstream_commit()
{
	echo "442e60b7e4c010e6622d524f47a2dd0d26ba19d4"
}

# Show version information
version()
{
	echo "Wine Staging 1.9.7"
	echo "Copyright (C) 2014-2016 the Wine Staging project authors."
	echo ""
	echo "Patchset to be applied on upstream Wine:"
	echo "  commit $(upstream_commit)"
	echo ""
}

# Critical error, abort
abort()
{
	echo "ERROR: $1" >&2
	exit 1
}

# Show a warning
warning()
{
	echo "WARNING: $1" >&2
}

# Enable or disable all patchsets
patch_enable_all ()
{
	enable_Compiler_Warnings="$1"
	enable_Coverity="$1"
	enable_Pipelight="$1"
	enable_Staging="$1"
	enable_advapi32_LsaLookupSids="$1"
	enable_advapi32_RegNotifyChangeKeyValue="$1"
	enable_advapi32_SetSecurityInfo="$1"
	enable_amstream_GetMultiMediaStream="$1"
	enable_api_ms_win_Stub_DLLs="$1"
	enable_avifil32_AVIFile_Proxies="$1"
	enable_avifil32_IGetFrame_fnSetFormat="$1"
	enable_avifile_dll16_AVIStreamGetFrame="$1"
	enable_browseui_Progress_Dialog="$1"
	enable_combase_RoApi="$1"
	enable_comctl32_Button_Theming="$1"
	enable_comctl32_PROPSHEET_InsertPage="$1"
	enable_comctl32_TTM_ADDTOOLW="$1"
	enable_compobj_dll16_StringFromGUID2="$1"
	enable_configure_Absolute_RPATH="$1"
	enable_configure_Crosscompiling="$1"
	enable_crypt32_CMS_Certificates="$1"
	enable_crypt32_CryptUnprotectMemory="$1"
	enable_d3d9_DesktopWindow="$1"
	enable_d3d9_Skip_Tests="$1"
	enable_d3d9_Surface_Refcount="$1"
	enable_d3dx9_24_ID3DXEffect="$1"
	enable_d3dx9_25_ID3DXEffect="$1"
	enable_d3dx9_26_ID3DXEffect="$1"
	enable_d3dx9_33_Share_Source="$1"
	enable_d3dx9_36_CloneEffect="$1"
	enable_d3dx9_36_D3DXCreateTeapot="$1"
	enable_d3dx9_36_D3DXDisassembleShader="$1"
	enable_d3dx9_36_D3DXStubs="$1"
	enable_d3dx9_36_DDS="$1"
	enable_d3dx9_36_DXTn="$1"
	enable_d3dx9_36_DrawText="$1"
	enable_d3dx9_36_Dummy_Skininfo="$1"
	enable_d3dx9_36_Filter_Warnings="$1"
	enable_d3dx9_36_FindNextValidTechnique="$1"
	enable_d3dx9_36_GetShaderSemantics="$1"
	enable_d3dx9_36_Optimize_Inplace="$1"
	enable_d3dx9_36_Texture_Align="$1"
	enable_d3dx9_36_UpdateSkinnedMesh="$1"
	enable_dbghelp_Debug_Symbols="$1"
	enable_ddraw_D3DFINDDEVICERESULT="$1"
	enable_ddraw_Device_Caps="$1"
	enable_ddraw_EnumSurfaces="$1"
	enable_ddraw_Fix_Typos="$1"
	enable_ddraw_IDirect3DTexture2_Load="$1"
	enable_ddraw_Rendering_Targets="$1"
	enable_ddraw_Write_Vtable="$1"
	enable_ddraw_d3d_execute_buffer="$1"
	enable_dinput_Initialize="$1"
	enable_dsound_DSCAPS_CERTIFIED="$1"
	enable_dsound_EAX="$1"
	enable_dsound_Fast_Mixer="$1"
	enable_dsound_Revert_Cleanup="$1"
	enable_dwmapi_DwmSetWindowAttribute="$1"
	enable_dxdiagn_Display_Information="$1"
	enable_dxdiagn_Enumerate_DirectSound="$1"
	enable_dxdiagn_GetChildContainer_Leaf_Nodes="$1"
	enable_dxgi_MakeWindowAssociation="$1"
	enable_dxva2_Video_Decoder="$1"
	enable_explorer_Video_Registry_Key="$1"
	enable_fonts_Missing_Fonts="$1"
	enable_fsutil_Stub_Program="$1"
	enable_gdi32_Lazy_Font_Initialization="$1"
	enable_gdi32_MultiMonitor="$1"
	enable_gdi32_Path_Metafile="$1"
	enable_gdi32_Symbol_Truetype_Font="$1"
	enable_gdiplus_GdipCreateMetafileFromStream="$1"
	enable_hal_KeQueryPerformanceCounter="$1"
	enable_hid_HidP_TranslateUsagesToI8042ScanCodes="$1"
	enable_hnetcfg_INetFwAuthorizedApplication="$1"
	enable_ieframe_IViewObject_Draw="$1"
	enable_iexplore_Revert_ProductVersion="$1"
	enable_imagehlp_BindImageEx="$1"
	enable_imagehlp_Cleanup="$1"
	enable_imagehlp_ImageLoad="$1"
	enable_imm32_IMMDisableLegacyIME="$1"
	enable_iphlpapi_System_Ping="$1"
	enable_iphlpapi_TCP_Table="$1"
	enable_kernel32_COMSPEC="$1"
	enable_kernel32_CopyFileEx="$1"
	enable_kernel32_Cwd_Startup_Info="$1"
	enable_kernel32_FindFirstFile="$1"
	enable_kernel32_FreeUserPhysicalPages="$1"
	enable_kernel32_GetCurrentPackageFamilyName="$1"
	enable_kernel32_GetFinalPathNameByHandle="$1"
	enable_kernel32_LocaleNameToLCID="$1"
	enable_kernel32_Named_Pipe="$1"
	enable_kernel32_NeedCurrentDirectoryForExePath="$1"
	enable_kernel32_Profile="$1"
	enable_kernel32_SetFileCompletionNotificationModes="$1"
	enable_kernel32_SetFileInformationByHandle="$1"
	enable_kernel32_TimezoneInformation_Registry="$1"
	enable_kernel32_VerifyVersionInfo="$1"
	enable_krnl386_exe16_GDT_LDT_Emulation="$1"
	enable_krnl386_exe16_Invalid_Console_Handles="$1"
	enable_krnl386_exe16__lclose16="$1"
	enable_libs_Debug_Channel="$1"
	enable_libs_Unicode_Collation="$1"
	enable_makedep_PARENTSPEC="$1"
	enable_mfplat_MFTRegister="$1"
	enable_mmsystem_dll16_MIDIHDR_Refcount="$1"
	enable_mountmgr_DosDevices="$1"
	enable_mpr_WNetGetUniversalNameW="$1"
	enable_mscoree_CorValidateImage="$1"
	enable_mshtml_HTMLLocation_put_hash="$1"
	enable_msi_Fix_Stack_Alignment="$1"
	enable_msidb_Implementation="$1"
	enable_msvcr120__SetWinRTOutOfMemoryExceptionCallback="$1"
	enable_msvcrt_Math_Precision="$1"
	enable_msvfw32_ICGetDisplayFormat="$1"
	enable_msvidc32_Convert_Bitness="$1"
	enable_ntdll_APC_Performance="$1"
	enable_ntdll_APC_Start_Process="$1"
	enable_ntdll_Activation_Context="$1"
	enable_ntdll_ApiSetQueryApiSetPresence="$1"
	enable_ntdll_CLI_Images="$1"
	enable_ntdll_DOS_Attributes="$1"
	enable_ntdll_Dealloc_Thread_Stack="$1"
	enable_ntdll_DeviceType_Systemroot="$1"
	enable_ntdll_DllOverrides_WOW64="$1"
	enable_ntdll_DllRedirects="$1"
	enable_ntdll_EtwRegisterTraceGuids="$1"
	enable_ntdll_Exception="$1"
	enable_ntdll_FSCTL_PIPE_LISTEN="$1"
	enable_ntdll_FileDispositionInformation="$1"
	enable_ntdll_FileFsFullSizeInformation="$1"
	enable_ntdll_FileFsVolumeInformation="$1"
	enable_ntdll_FileNamesInformation="$1"
	enable_ntdll_Fix_Alignment="$1"
	enable_ntdll_Fix_Free="$1"
	enable_ntdll_FreeBSD_Directory="$1"
	enable_ntdll_Heap_FreeLists="$1"
	enable_ntdll_Hide_Wine_Exports="$1"
	enable_ntdll_Junction_Points="$1"
	enable_ntdll_Loader_Machine_Type="$1"
	enable_ntdll_NtAccessCheck="$1"
	enable_ntdll_NtQueryEaFile="$1"
	enable_ntdll_NtQuerySection="$1"
	enable_ntdll_NtSetLdtEntries="$1"
	enable_ntdll_Pipe_SpecialCharacters="$1"
	enable_ntdll_ProcessQuotaLimits="$1"
	enable_ntdll_Purist_Mode="$1"
	enable_ntdll_RtlIpStringToAddress_Stubs="$1"
	enable_ntdll_RtlIpStringToAddress_Tests="$1"
	enable_ntdll_RtlQueryPackageIdentity="$1"
	enable_ntdll_Serial_Port_Detection="$1"
	enable_ntdll_Stack_Guard_Pages="$1"
	enable_ntdll_Status_Mapping="$1"
	enable_ntdll_Syscall_Wrappers="$1"
	enable_ntdll_SystemInterruptInformation="$1"
	enable_ntdll_SystemRecommendedSharedDataAlignment="$1"
	enable_ntdll_SystemRoot_Symlink="$1"
	enable_ntdll_ThreadTime="$1"
	enable_ntdll_Threading="$1"
	enable_ntdll_User_Shared_Data="$1"
	enable_ntdll_WRITECOPY="$1"
	enable_ntdll_Wait_User_APC="$1"
	enable_ntdll_WinSqm="$1"
	enable_ntdll_WriteWatches="$1"
	enable_ntdll_Zero_mod_name="$1"
	enable_ntdll_call_thread_func_wrapper="$1"
	enable_ntoskrnl_DriverTest="$1"
	enable_ntoskrnl_Stubs="$1"
	enable_nvapi_Stub_DLL="$1"
	enable_nvcuda_CUDA_Support="$1"
	enable_nvcuvid_CUDA_Video_Support="$1"
	enable_nvencodeapi_Video_Encoder="$1"
	enable_ole32_HGLOBALStream="$1"
	enable_oleaut32_CreateTypeLib="$1"
	enable_oleaut32_OLEPictureImpl_SaveAsFile="$1"
	enable_oleaut32_OleLoadPictureFile="$1"
	enable_oleaut32_TKIND_COCLASS="$1"
	enable_oleaut32_x86_64_Marshaller="$1"
	enable_openal32_EFX_Extension="$1"
	enable_opengl32_Revert_Disable_Ext="$1"
	enable_opengl32_glDebugMessageCallback="$1"
	enable_quartz_AsyncReader="$1"
	enable_quartz_MediaSeeking_Positions="$1"
	enable_quartz_Silence_FIXMEs="$1"
	enable_rasapi32_RasEnumDevicesA="$1"
	enable_reg_Implement_Query="$1"
	enable_riched20_IText_Interface="$1"
	enable_rpcrt4_Pipe_Transport="$1"
	enable_rpcrt4_RpcBindingServerFromClient="$1"
	enable_secur32_ANSI_NTLM_Credentials="$1"
	enable_server_ClipCursor="$1"
	enable_server_CreateProcess_ACLs="$1"
	enable_server_Desktop_Refcount="$1"
	enable_server_FileEndOfFileInformation="$1"
	enable_server_File_Permissions="$1"
	enable_server_Inherited_ACLs="$1"
	enable_server_Key_State="$1"
	enable_server_Map_EXDEV_Error="$1"
	enable_server_Misc_ACL="$1"
	enable_server_Parent_Process="$1"
	enable_server_PeekMessage="$1"
	enable_server_Pipe_ObjectName="$1"
	enable_server_Realtime_Priority="$1"
	enable_server_Registry_Notifications="$1"
	enable_server_Shared_Memory="$1"
	enable_server_Signal_Thread="$1"
	enable_server_Stored_ACLs="$1"
	enable_server_Timestamp_Compat="$1"
	enable_setupapi_DelReg="$1"
	enable_setupapi_DiskSpaceList="$1"
	enable_setupapi_Display_Device="$1"
	enable_setupapi_HSPFILEQ_Check_Type="$1"
	enable_setupapi_SetupPromptForDisk="$1"
	enable_sfc_SfcGetNextProtectedFile="$1"
	enable_shdocvw_ParseURLFromOutsideSource_Tests="$1"
	enable_shell32_Context_Menu="$1"
	enable_shell32_Default_Path="$1"
	enable_shell32_File_Property_Dialog="$1"
	enable_shell32_FolderItems_Stub_Iface="$1"
	enable_shell32_IDragSourceHelper="$1"
	enable_shell32_Icons="$1"
	enable_shell32_Microsoft_Windows_Themes="$1"
	enable_shell32_NewMenu_Interface="$1"
	enable_shell32_Placeholder_Icons="$1"
	enable_shell32_Progress_Dialog="$1"
	enable_shell32_RunDLL_CallEntry16="$1"
	enable_shell32_Run_Dialog="$1"
	enable_shell32_SFGAO_HASSUBFOLDER="$1"
	enable_shell32_SHCreateSessionKey="$1"
	enable_shell32_SHFileOperation_Move="$1"
	enable_shell32_SHFileOperation_Win9x="$1"
	enable_shell32_Toolbar_Bitmaps="$1"
	enable_shell32_UNIXFS_get_unix_path="$1"
	enable_shell32_UnixFS="$1"
	enable_shlwapi_AssocGetPerceivedType="$1"
	enable_shlwapi_IStream_fnRead="$1"
	enable_shlwapi_SHMapHandle="$1"
	enable_shlwapi_UrlCombine="$1"
	enable_stdole32_idl_Typelib="$1"
	enable_stdole32_tlb_SLTG_Typelib="$1"
	enable_taskmgr_Memory_Usage="$1"
	enable_ucrtbase_Functions="$1"
	enable_user_exe16_CONTAINING_RECORD="$1"
	enable_user_exe16_DlgDirList="$1"
	enable_user32_DeferWindowPos="$1"
	enable_user32_Dialog_Owner="$1"
	enable_user32_Dialog_Paint_Event="$1"
	enable_user32_DrawTextExW="$1"
	enable_user32_FlashWindowEx="$1"
	enable_user32_GetSystemMetrics="$1"
	enable_user32_Invalidate_Key_State="$1"
	enable_user32_ListBox_Size="$1"
	enable_user32_MessageBox_WS_EX_TOPMOST="$1"
	enable_user32_Mouse_Message_Hwnd="$1"
	enable_user32_Refresh_MDI_Menus="$1"
	enable_user32_ScrollWindowEx="$1"
	enable_user32_SetCoalescableTimer="$1"
	enable_user32_WM_CTLCOLORBTN="$1"
	enable_user32_WM_MDICALCCHILDSCROLL="$1"
	enable_user32_WM_NOTIFY="$1"
	enable_user32_WndProc="$1"
	enable_user32_lpCreateParams="$1"
	enable_uxtheme_GTK_Theming="$1"
	enable_version_GetFileVersionInfoSizeExW="$1"
	enable_version_VerFindFileA="$1"
	enable_version_VerQueryValue="$1"
	enable_vulkan_Vulkan_Implementation="$1"
	enable_wbemdisp_ISWbemSecurity="$1"
	enable_widl_SLTG_Typelib_Support="$1"
	enable_windowscodecs_32bppGrayFloat="$1"
	enable_windowscodecs_IMILBitmapSource="$1"
	enable_windowscodecs_WICCreateBitmapFromSection="$1"
	enable_wine_inf_Directory_ContextMenuHandlers="$1"
	enable_wine_inf_Dummy_CA_Certificate="$1"
	enable_wine_inf_Performance="$1"
	enable_wine_inf_ProfileList_UserSID="$1"
	enable_wine_inf_WMP_12="$1"
	enable_wineboot_DriveSerial="$1"
	enable_wineboot_HKEY_DYN_DATA="$1"
	enable_wineboot_drivers_etc_Stubs="$1"
	enable_winecfg_Libraries="$1"
	enable_winecfg_Staging="$1"
	enable_winecfg_Unmounted_Devices="$1"
	enable_wined3d_Accounting="$1"
	enable_wined3d_CSMT_Helper="$1"
	enable_wined3d_DXTn="$1"
	enable_wined3d_Geforce_425M="$1"
	enable_wined3d_Limit_Vram="$1"
	enable_wined3d_Revert_PixelFormat="$1"
	enable_wined3d_Silence_FIXMEs="$1"
	enable_wined3d_resource_map="$1"
	enable_winedevice_Fix_Relocation="$1"
	enable_winemenubuilder_Desktop_Icon_Path="$1"
	enable_winepulse_PulseAudio_Support="$1"
	enable_winex11_CandidateWindowPos="$1"
	enable_winex11_Clipboard_HTML="$1"
	enable_winex11_DefaultDisplayFrequency="$1"
	enable_winex11_Desktop_Resolution="$1"
	enable_winex11_Window_Groups="$1"
	enable_winex11_Window_Style="$1"
	enable_winex11_XEMBED="$1"
	enable_winex11__NET_ACTIVE_WINDOW="$1"
	enable_winex11_wglShareLists="$1"
	enable_winhttp_System_Proxy_Autoconfig="$1"
	enable_wininet_Cleanup="$1"
	enable_wininet_HttpOpenRequestW="$1"
	enable_wininet_Internet_Settings="$1"
	enable_wininet_ParseX509EncodedCertificateForListBoxEntry="$1"
	enable_winmm_Delay_Import_Depends="$1"
	enable_winmm_mciSendCommandA="$1"
	enable_winspool_drv_SetPrinterW="$1"
	enable_winsta_WinStationEnumerateW="$1"
	enable_wintrust_WinVerifyTrust="$1"
	enable_wpcap_Dynamic_Linking="$1"
	enable_wpcap_Several_Fixes="$1"
	enable_ws2_32_APC_Performance="$1"
	enable_ws2_32_Connect_Time="$1"
	enable_ws2_32_DisconnectEx="$1"
	enable_ws2_32_Sort_default_route="$1"
	enable_ws2_32_TransmitFile="$1"
	enable_ws2_32_WSACleanup="$1"
	enable_ws2_32_WriteWatches="$1"
	enable_ws2_32_getaddrinfo="$1"
	enable_ws2_32_getsockopt="$1"
	enable_wtsapi32_EnumerateProcesses="$1"
	enable_wtsapi32_WTSQueryUserToken="$1"
	enable_wuauserv_Dummy_Service="$1"
	enable_wusa_MSU_Package_Installer="$1"
}

# Enable or disable all categories
category_enable_all ()
{
	enable_category_stable="$1"
}

# Enable or disable a specific patchset/category
patch_enable ()
{
	case "$1" in
		Compiler_Warnings)
			enable_Compiler_Warnings="$2"
			;;
		Coverity)
			enable_Coverity="$2"
			;;
		Pipelight)
			enable_Pipelight="$2"
			;;
		Staging)
			enable_Staging="$2"
			;;
		advapi32-LsaLookupSids)
			enable_advapi32_LsaLookupSids="$2"
			;;
		advapi32-RegNotifyChangeKeyValue)
			enable_advapi32_RegNotifyChangeKeyValue="$2"
			;;
		advapi32-SetSecurityInfo)
			enable_advapi32_SetSecurityInfo="$2"
			;;
		amstream-GetMultiMediaStream)
			enable_amstream_GetMultiMediaStream="$2"
			;;
		api-ms-win-Stub_DLLs)
			enable_api_ms_win_Stub_DLLs="$2"
			;;
		avifil32-AVIFile_Proxies)
			enable_avifil32_AVIFile_Proxies="$2"
			;;
		avifil32-IGetFrame_fnSetFormat)
			enable_avifil32_IGetFrame_fnSetFormat="$2"
			;;
		avifile.dll16-AVIStreamGetFrame)
			enable_avifile_dll16_AVIStreamGetFrame="$2"
			;;
		browseui-Progress_Dialog)
			enable_browseui_Progress_Dialog="$2"
			;;
		category-stable)
			enable_category_stable="$2"
			;;
		combase-RoApi)
			enable_combase_RoApi="$2"
			;;
		comctl32-Button_Theming)
			enable_comctl32_Button_Theming="$2"
			;;
		comctl32-PROPSHEET_InsertPage)
			enable_comctl32_PROPSHEET_InsertPage="$2"
			;;
		comctl32-TTM_ADDTOOLW)
			enable_comctl32_TTM_ADDTOOLW="$2"
			;;
		compobj.dll16-StringFromGUID2)
			enable_compobj_dll16_StringFromGUID2="$2"
			;;
		configure-Absolute_RPATH)
			enable_configure_Absolute_RPATH="$2"
			;;
		configure-Crosscompiling)
			enable_configure_Crosscompiling="$2"
			;;
		crypt32-CMS_Certificates)
			enable_crypt32_CMS_Certificates="$2"
			;;
		crypt32-CryptUnprotectMemory)
			enable_crypt32_CryptUnprotectMemory="$2"
			;;
		d3d9-DesktopWindow)
			enable_d3d9_DesktopWindow="$2"
			;;
		d3d9-Skip_Tests)
			enable_d3d9_Skip_Tests="$2"
			;;
		d3d9-Surface_Refcount)
			enable_d3d9_Surface_Refcount="$2"
			;;
		d3dx9_24-ID3DXEffect)
			enable_d3dx9_24_ID3DXEffect="$2"
			;;
		d3dx9_25-ID3DXEffect)
			enable_d3dx9_25_ID3DXEffect="$2"
			;;
		d3dx9_26-ID3DXEffect)
			enable_d3dx9_26_ID3DXEffect="$2"
			;;
		d3dx9_33-Share_Source)
			enable_d3dx9_33_Share_Source="$2"
			;;
		d3dx9_36-CloneEffect)
			enable_d3dx9_36_CloneEffect="$2"
			;;
		d3dx9_36-D3DXCreateTeapot)
			enable_d3dx9_36_D3DXCreateTeapot="$2"
			;;
		d3dx9_36-D3DXDisassembleShader)
			enable_d3dx9_36_D3DXDisassembleShader="$2"
			;;
		d3dx9_36-D3DXStubs)
			enable_d3dx9_36_D3DXStubs="$2"
			;;
		d3dx9_36-DDS)
			enable_d3dx9_36_DDS="$2"
			;;
		d3dx9_36-DXTn)
			enable_d3dx9_36_DXTn="$2"
			;;
		d3dx9_36-DrawText)
			enable_d3dx9_36_DrawText="$2"
			;;
		d3dx9_36-Dummy_Skininfo)
			enable_d3dx9_36_Dummy_Skininfo="$2"
			;;
		d3dx9_36-Filter_Warnings)
			enable_d3dx9_36_Filter_Warnings="$2"
			;;
		d3dx9_36-FindNextValidTechnique)
			enable_d3dx9_36_FindNextValidTechnique="$2"
			;;
		d3dx9_36-GetShaderSemantics)
			enable_d3dx9_36_GetShaderSemantics="$2"
			;;
		d3dx9_36-Optimize_Inplace)
			enable_d3dx9_36_Optimize_Inplace="$2"
			;;
		d3dx9_36-Texture_Align)
			enable_d3dx9_36_Texture_Align="$2"
			;;
		d3dx9_36-UpdateSkinnedMesh)
			enable_d3dx9_36_UpdateSkinnedMesh="$2"
			;;
		dbghelp-Debug_Symbols)
			enable_dbghelp_Debug_Symbols="$2"
			;;
		ddraw-D3DFINDDEVICERESULT)
			enable_ddraw_D3DFINDDEVICERESULT="$2"
			;;
		ddraw-Device_Caps)
			enable_ddraw_Device_Caps="$2"
			;;
		ddraw-EnumSurfaces)
			enable_ddraw_EnumSurfaces="$2"
			;;
		ddraw-Fix_Typos)
			enable_ddraw_Fix_Typos="$2"
			;;
		ddraw-IDirect3DTexture2_Load)
			enable_ddraw_IDirect3DTexture2_Load="$2"
			;;
		ddraw-Rendering_Targets)
			enable_ddraw_Rendering_Targets="$2"
			;;
		ddraw-Write_Vtable)
			enable_ddraw_Write_Vtable="$2"
			;;
		ddraw-d3d_execute_buffer)
			enable_ddraw_d3d_execute_buffer="$2"
			;;
		dinput-Initialize)
			enable_dinput_Initialize="$2"
			;;
		dsound-DSCAPS_CERTIFIED)
			enable_dsound_DSCAPS_CERTIFIED="$2"
			;;
		dsound-EAX)
			enable_dsound_EAX="$2"
			;;
		dsound-Fast_Mixer)
			enable_dsound_Fast_Mixer="$2"
			;;
		dsound-Revert_Cleanup)
			enable_dsound_Revert_Cleanup="$2"
			;;
		dwmapi-DwmSetWindowAttribute)
			enable_dwmapi_DwmSetWindowAttribute="$2"
			;;
		dxdiagn-Display_Information)
			enable_dxdiagn_Display_Information="$2"
			;;
		dxdiagn-Enumerate_DirectSound)
			enable_dxdiagn_Enumerate_DirectSound="$2"
			;;
		dxdiagn-GetChildContainer_Leaf_Nodes)
			enable_dxdiagn_GetChildContainer_Leaf_Nodes="$2"
			;;
		dxgi-MakeWindowAssociation)
			enable_dxgi_MakeWindowAssociation="$2"
			;;
		dxva2-Video_Decoder)
			enable_dxva2_Video_Decoder="$2"
			;;
		explorer-Video_Registry_Key)
			enable_explorer_Video_Registry_Key="$2"
			;;
		fonts-Missing_Fonts)
			enable_fonts_Missing_Fonts="$2"
			;;
		fsutil-Stub_Program)
			enable_fsutil_Stub_Program="$2"
			;;
		gdi32-Lazy_Font_Initialization)
			enable_gdi32_Lazy_Font_Initialization="$2"
			;;
		gdi32-MultiMonitor)
			enable_gdi32_MultiMonitor="$2"
			;;
		gdi32-Path_Metafile)
			enable_gdi32_Path_Metafile="$2"
			;;
		gdi32-Symbol_Truetype_Font)
			enable_gdi32_Symbol_Truetype_Font="$2"
			;;
		gdiplus-GdipCreateMetafileFromStream)
			enable_gdiplus_GdipCreateMetafileFromStream="$2"
			;;
		hal-KeQueryPerformanceCounter)
			enable_hal_KeQueryPerformanceCounter="$2"
			;;
		hid-HidP_TranslateUsagesToI8042ScanCodes)
			enable_hid_HidP_TranslateUsagesToI8042ScanCodes="$2"
			;;
		hnetcfg-INetFwAuthorizedApplication)
			enable_hnetcfg_INetFwAuthorizedApplication="$2"
			;;
		ieframe-IViewObject-Draw)
			enable_ieframe_IViewObject_Draw="$2"
			;;
		iexplore-Revert_ProductVersion)
			enable_iexplore_Revert_ProductVersion="$2"
			;;
		imagehlp-BindImageEx)
			enable_imagehlp_BindImageEx="$2"
			;;
		imagehlp-Cleanup)
			enable_imagehlp_Cleanup="$2"
			;;
		imagehlp-ImageLoad)
			enable_imagehlp_ImageLoad="$2"
			;;
		imm32-IMMDisableLegacyIME)
			enable_imm32_IMMDisableLegacyIME="$2"
			;;
		iphlpapi-System_Ping)
			enable_iphlpapi_System_Ping="$2"
			;;
		iphlpapi-TCP_Table)
			enable_iphlpapi_TCP_Table="$2"
			;;
		kernel32-COMSPEC)
			enable_kernel32_COMSPEC="$2"
			;;
		kernel32-CopyFileEx)
			enable_kernel32_CopyFileEx="$2"
			;;
		kernel32-Cwd_Startup_Info)
			enable_kernel32_Cwd_Startup_Info="$2"
			;;
		kernel32-FindFirstFile)
			enable_kernel32_FindFirstFile="$2"
			;;
		kernel32-FreeUserPhysicalPages)
			enable_kernel32_FreeUserPhysicalPages="$2"
			;;
		kernel32-GetCurrentPackageFamilyName)
			enable_kernel32_GetCurrentPackageFamilyName="$2"
			;;
		kernel32-GetFinalPathNameByHandle)
			enable_kernel32_GetFinalPathNameByHandle="$2"
			;;
		kernel32-LocaleNameToLCID)
			enable_kernel32_LocaleNameToLCID="$2"
			;;
		kernel32-Named_Pipe)
			enable_kernel32_Named_Pipe="$2"
			;;
		kernel32-NeedCurrentDirectoryForExePath)
			enable_kernel32_NeedCurrentDirectoryForExePath="$2"
			;;
		kernel32-Profile)
			enable_kernel32_Profile="$2"
			;;
		kernel32-SetFileCompletionNotificationModes)
			enable_kernel32_SetFileCompletionNotificationModes="$2"
			;;
		kernel32-SetFileInformationByHandle)
			enable_kernel32_SetFileInformationByHandle="$2"
			;;
		kernel32-TimezoneInformation_Registry)
			enable_kernel32_TimezoneInformation_Registry="$2"
			;;
		kernel32-VerifyVersionInfo)
			enable_kernel32_VerifyVersionInfo="$2"
			;;
		krnl386.exe16-GDT_LDT_Emulation)
			enable_krnl386_exe16_GDT_LDT_Emulation="$2"
			;;
		krnl386.exe16-Invalid_Console_Handles)
			enable_krnl386_exe16_Invalid_Console_Handles="$2"
			;;
		krnl386.exe16-_lclose16)
			enable_krnl386_exe16__lclose16="$2"
			;;
		libs-Debug_Channel)
			enable_libs_Debug_Channel="$2"
			;;
		libs-Unicode_Collation)
			enable_libs_Unicode_Collation="$2"
			;;
		makedep-PARENTSPEC)
			enable_makedep_PARENTSPEC="$2"
			;;
		mfplat-MFTRegister)
			enable_mfplat_MFTRegister="$2"
			;;
		mmsystem.dll16-MIDIHDR_Refcount)
			enable_mmsystem_dll16_MIDIHDR_Refcount="$2"
			;;
		mountmgr-DosDevices)
			enable_mountmgr_DosDevices="$2"
			;;
		mpr-WNetGetUniversalNameW)
			enable_mpr_WNetGetUniversalNameW="$2"
			;;
		mscoree-CorValidateImage)
			enable_mscoree_CorValidateImage="$2"
			;;
		mshtml-HTMLLocation_put_hash)
			enable_mshtml_HTMLLocation_put_hash="$2"
			;;
		msi-Fix_Stack_Alignment)
			enable_msi_Fix_Stack_Alignment="$2"
			;;
		msidb-Implementation)
			enable_msidb_Implementation="$2"
			;;
		msvcr120-_SetWinRTOutOfMemoryExceptionCallback)
			enable_msvcr120__SetWinRTOutOfMemoryExceptionCallback="$2"
			;;
		msvcrt-Math_Precision)
			enable_msvcrt_Math_Precision="$2"
			;;
		msvfw32-ICGetDisplayFormat)
			enable_msvfw32_ICGetDisplayFormat="$2"
			;;
		msvidc32-Convert_Bitness)
			enable_msvidc32_Convert_Bitness="$2"
			;;
		ntdll-APC_Performance)
			enable_ntdll_APC_Performance="$2"
			;;
		ntdll-APC_Start_Process)
			enable_ntdll_APC_Start_Process="$2"
			;;
		ntdll-Activation_Context)
			enable_ntdll_Activation_Context="$2"
			;;
		ntdll-ApiSetQueryApiSetPresence)
			enable_ntdll_ApiSetQueryApiSetPresence="$2"
			;;
		ntdll-CLI_Images)
			enable_ntdll_CLI_Images="$2"
			;;
		ntdll-DOS_Attributes)
			enable_ntdll_DOS_Attributes="$2"
			;;
		ntdll-Dealloc_Thread_Stack)
			enable_ntdll_Dealloc_Thread_Stack="$2"
			;;
		ntdll-DeviceType_Systemroot)
			enable_ntdll_DeviceType_Systemroot="$2"
			;;
		ntdll-DllOverrides_WOW64)
			enable_ntdll_DllOverrides_WOW64="$2"
			;;
		ntdll-DllRedirects)
			enable_ntdll_DllRedirects="$2"
			;;
		ntdll-EtwRegisterTraceGuids)
			enable_ntdll_EtwRegisterTraceGuids="$2"
			;;
		ntdll-Exception)
			enable_ntdll_Exception="$2"
			;;
		ntdll-FSCTL_PIPE_LISTEN)
			enable_ntdll_FSCTL_PIPE_LISTEN="$2"
			;;
		ntdll-FileDispositionInformation)
			enable_ntdll_FileDispositionInformation="$2"
			;;
		ntdll-FileFsFullSizeInformation)
			enable_ntdll_FileFsFullSizeInformation="$2"
			;;
		ntdll-FileFsVolumeInformation)
			enable_ntdll_FileFsVolumeInformation="$2"
			;;
		ntdll-FileNamesInformation)
			enable_ntdll_FileNamesInformation="$2"
			;;
		ntdll-Fix_Alignment)
			enable_ntdll_Fix_Alignment="$2"
			;;
		ntdll-Fix_Free)
			enable_ntdll_Fix_Free="$2"
			;;
		ntdll-FreeBSD_Directory)
			enable_ntdll_FreeBSD_Directory="$2"
			;;
		ntdll-Heap_FreeLists)
			enable_ntdll_Heap_FreeLists="$2"
			;;
		ntdll-Hide_Wine_Exports)
			enable_ntdll_Hide_Wine_Exports="$2"
			;;
		ntdll-Junction_Points)
			enable_ntdll_Junction_Points="$2"
			;;
		ntdll-Loader_Machine_Type)
			enable_ntdll_Loader_Machine_Type="$2"
			;;
		ntdll-NtAccessCheck)
			enable_ntdll_NtAccessCheck="$2"
			;;
		ntdll-NtQueryEaFile)
			enable_ntdll_NtQueryEaFile="$2"
			;;
		ntdll-NtQuerySection)
			enable_ntdll_NtQuerySection="$2"
			;;
		ntdll-NtSetLdtEntries)
			enable_ntdll_NtSetLdtEntries="$2"
			;;
		ntdll-Pipe_SpecialCharacters)
			enable_ntdll_Pipe_SpecialCharacters="$2"
			;;
		ntdll-ProcessQuotaLimits)
			enable_ntdll_ProcessQuotaLimits="$2"
			;;
		ntdll-Purist_Mode)
			enable_ntdll_Purist_Mode="$2"
			;;
		ntdll-RtlIpStringToAddress_Stubs)
			enable_ntdll_RtlIpStringToAddress_Stubs="$2"
			;;
		ntdll-RtlIpStringToAddress_Tests)
			enable_ntdll_RtlIpStringToAddress_Tests="$2"
			;;
		ntdll-RtlQueryPackageIdentity)
			enable_ntdll_RtlQueryPackageIdentity="$2"
			;;
		ntdll-Serial_Port_Detection)
			enable_ntdll_Serial_Port_Detection="$2"
			;;
		ntdll-Stack_Guard_Pages)
			enable_ntdll_Stack_Guard_Pages="$2"
			;;
		ntdll-Status_Mapping)
			enable_ntdll_Status_Mapping="$2"
			;;
		ntdll-Syscall_Wrappers)
			enable_ntdll_Syscall_Wrappers="$2"
			;;
		ntdll-SystemInterruptInformation)
			enable_ntdll_SystemInterruptInformation="$2"
			;;
		ntdll-SystemRecommendedSharedDataAlignment)
			enable_ntdll_SystemRecommendedSharedDataAlignment="$2"
			;;
		ntdll-SystemRoot_Symlink)
			enable_ntdll_SystemRoot_Symlink="$2"
			;;
		ntdll-ThreadTime)
			enable_ntdll_ThreadTime="$2"
			;;
		ntdll-Threading)
			enable_ntdll_Threading="$2"
			;;
		ntdll-User_Shared_Data)
			enable_ntdll_User_Shared_Data="$2"
			;;
		ntdll-WRITECOPY)
			enable_ntdll_WRITECOPY="$2"
			;;
		ntdll-Wait_User_APC)
			enable_ntdll_Wait_User_APC="$2"
			;;
		ntdll-WinSqm)
			enable_ntdll_WinSqm="$2"
			;;
		ntdll-WriteWatches)
			enable_ntdll_WriteWatches="$2"
			;;
		ntdll-Zero_mod_name)
			enable_ntdll_Zero_mod_name="$2"
			;;
		ntdll-call_thread_func_wrapper)
			enable_ntdll_call_thread_func_wrapper="$2"
			;;
		ntoskrnl-DriverTest)
			enable_ntoskrnl_DriverTest="$2"
			;;
		ntoskrnl-Stubs)
			enable_ntoskrnl_Stubs="$2"
			;;
		nvapi-Stub_DLL)
			enable_nvapi_Stub_DLL="$2"
			;;
		nvcuda-CUDA_Support)
			enable_nvcuda_CUDA_Support="$2"
			;;
		nvcuvid-CUDA_Video_Support)
			enable_nvcuvid_CUDA_Video_Support="$2"
			;;
		nvencodeapi-Video_Encoder)
			enable_nvencodeapi_Video_Encoder="$2"
			;;
		ole32-HGLOBALStream)
			enable_ole32_HGLOBALStream="$2"
			;;
		oleaut32-CreateTypeLib)
			enable_oleaut32_CreateTypeLib="$2"
			;;
		oleaut32-OLEPictureImpl_SaveAsFile)
			enable_oleaut32_OLEPictureImpl_SaveAsFile="$2"
			;;
		oleaut32-OleLoadPictureFile)
			enable_oleaut32_OleLoadPictureFile="$2"
			;;
		oleaut32-TKIND_COCLASS)
			enable_oleaut32_TKIND_COCLASS="$2"
			;;
		oleaut32-x86_64_Marshaller)
			enable_oleaut32_x86_64_Marshaller="$2"
			;;
		openal32-EFX_Extension)
			enable_openal32_EFX_Extension="$2"
			;;
		opengl32-Revert_Disable_Ext)
			enable_opengl32_Revert_Disable_Ext="$2"
			;;
		opengl32-glDebugMessageCallback)
			enable_opengl32_glDebugMessageCallback="$2"
			;;
		quartz-AsyncReader)
			enable_quartz_AsyncReader="$2"
			;;
		quartz-MediaSeeking_Positions)
			enable_quartz_MediaSeeking_Positions="$2"
			;;
		quartz-Silence_FIXMEs)
			enable_quartz_Silence_FIXMEs="$2"
			;;
		rasapi32-RasEnumDevicesA)
			enable_rasapi32_RasEnumDevicesA="$2"
			;;
		reg-Implement_Query)
			enable_reg_Implement_Query="$2"
			;;
		riched20-IText_Interface)
			enable_riched20_IText_Interface="$2"
			;;
		rpcrt4-Pipe_Transport)
			enable_rpcrt4_Pipe_Transport="$2"
			;;
		rpcrt4-RpcBindingServerFromClient)
			enable_rpcrt4_RpcBindingServerFromClient="$2"
			;;
		secur32-ANSI_NTLM_Credentials)
			enable_secur32_ANSI_NTLM_Credentials="$2"
			;;
		server-ClipCursor)
			enable_server_ClipCursor="$2"
			;;
		server-CreateProcess_ACLs)
			enable_server_CreateProcess_ACLs="$2"
			;;
		server-Desktop_Refcount)
			enable_server_Desktop_Refcount="$2"
			;;
		server-FileEndOfFileInformation)
			enable_server_FileEndOfFileInformation="$2"
			;;
		server-File_Permissions)
			enable_server_File_Permissions="$2"
			;;
		server-Inherited_ACLs)
			enable_server_Inherited_ACLs="$2"
			;;
		server-Key_State)
			enable_server_Key_State="$2"
			;;
		server-Map_EXDEV_Error)
			enable_server_Map_EXDEV_Error="$2"
			;;
		server-Misc_ACL)
			enable_server_Misc_ACL="$2"
			;;
		server-Parent_Process)
			enable_server_Parent_Process="$2"
			;;
		server-PeekMessage)
			enable_server_PeekMessage="$2"
			;;
		server-Pipe_ObjectName)
			enable_server_Pipe_ObjectName="$2"
			;;
		server-Realtime_Priority)
			enable_server_Realtime_Priority="$2"
			;;
		server-Registry_Notifications)
			enable_server_Registry_Notifications="$2"
			;;
		server-Shared_Memory)
			enable_server_Shared_Memory="$2"
			;;
		server-Signal_Thread)
			enable_server_Signal_Thread="$2"
			;;
		server-Stored_ACLs)
			enable_server_Stored_ACLs="$2"
			;;
		server-Timestamp_Compat)
			enable_server_Timestamp_Compat="$2"
			;;
		setupapi-DelReg)
			enable_setupapi_DelReg="$2"
			;;
		setupapi-DiskSpaceList)
			enable_setupapi_DiskSpaceList="$2"
			;;
		setupapi-Display_Device)
			enable_setupapi_Display_Device="$2"
			;;
		setupapi-HSPFILEQ_Check_Type)
			enable_setupapi_HSPFILEQ_Check_Type="$2"
			;;
		setupapi-SetupPromptForDisk)
			enable_setupapi_SetupPromptForDisk="$2"
			;;
		sfc-SfcGetNextProtectedFile)
			enable_sfc_SfcGetNextProtectedFile="$2"
			;;
		shdocvw-ParseURLFromOutsideSource_Tests)
			enable_shdocvw_ParseURLFromOutsideSource_Tests="$2"
			;;
		shell32-Context_Menu)
			enable_shell32_Context_Menu="$2"
			;;
		shell32-Default_Path)
			enable_shell32_Default_Path="$2"
			;;
		shell32-File_Property_Dialog)
			enable_shell32_File_Property_Dialog="$2"
			;;
		shell32-FolderItems_Stub_Iface)
			enable_shell32_FolderItems_Stub_Iface="$2"
			;;
		shell32-IDragSourceHelper)
			enable_shell32_IDragSourceHelper="$2"
			;;
		shell32-Icons)
			enable_shell32_Icons="$2"
			;;
		shell32-Microsoft_Windows_Themes)
			enable_shell32_Microsoft_Windows_Themes="$2"
			;;
		shell32-NewMenu_Interface)
			enable_shell32_NewMenu_Interface="$2"
			;;
		shell32-Placeholder_Icons)
			enable_shell32_Placeholder_Icons="$2"
			;;
		shell32-Progress_Dialog)
			enable_shell32_Progress_Dialog="$2"
			;;
		shell32-RunDLL_CallEntry16)
			enable_shell32_RunDLL_CallEntry16="$2"
			;;
		shell32-Run_Dialog)
			enable_shell32_Run_Dialog="$2"
			;;
		shell32-SFGAO_HASSUBFOLDER)
			enable_shell32_SFGAO_HASSUBFOLDER="$2"
			;;
		shell32-SHCreateSessionKey)
			enable_shell32_SHCreateSessionKey="$2"
			;;
		shell32-SHFileOperation_Move)
			enable_shell32_SHFileOperation_Move="$2"
			;;
		shell32-SHFileOperation_Win9x)
			enable_shell32_SHFileOperation_Win9x="$2"
			;;
		shell32-Toolbar_Bitmaps)
			enable_shell32_Toolbar_Bitmaps="$2"
			;;
		shell32-UNIXFS_get_unix_path)
			enable_shell32_UNIXFS_get_unix_path="$2"
			;;
		shell32-UnixFS)
			enable_shell32_UnixFS="$2"
			;;
		shlwapi-AssocGetPerceivedType)
			enable_shlwapi_AssocGetPerceivedType="$2"
			;;
		shlwapi-IStream_fnRead)
			enable_shlwapi_IStream_fnRead="$2"
			;;
		shlwapi-SHMapHandle)
			enable_shlwapi_SHMapHandle="$2"
			;;
		shlwapi-UrlCombine)
			enable_shlwapi_UrlCombine="$2"
			;;
		stdole32.idl-Typelib)
			enable_stdole32_idl_Typelib="$2"
			;;
		stdole32.tlb-SLTG_Typelib)
			enable_stdole32_tlb_SLTG_Typelib="$2"
			;;
		taskmgr-Memory_Usage)
			enable_taskmgr_Memory_Usage="$2"
			;;
		ucrtbase-Functions)
			enable_ucrtbase_Functions="$2"
			;;
		user.exe16-CONTAINING_RECORD)
			enable_user_exe16_CONTAINING_RECORD="$2"
			;;
		user.exe16-DlgDirList)
			enable_user_exe16_DlgDirList="$2"
			;;
		user32-DeferWindowPos)
			enable_user32_DeferWindowPos="$2"
			;;
		user32-Dialog_Owner)
			enable_user32_Dialog_Owner="$2"
			;;
		user32-Dialog_Paint_Event)
			enable_user32_Dialog_Paint_Event="$2"
			;;
		user32-DrawTextExW)
			enable_user32_DrawTextExW="$2"
			;;
		user32-FlashWindowEx)
			enable_user32_FlashWindowEx="$2"
			;;
		user32-GetSystemMetrics)
			enable_user32_GetSystemMetrics="$2"
			;;
		user32-Invalidate_Key_State)
			enable_user32_Invalidate_Key_State="$2"
			;;
		user32-ListBox_Size)
			enable_user32_ListBox_Size="$2"
			;;
		user32-MessageBox_WS_EX_TOPMOST)
			enable_user32_MessageBox_WS_EX_TOPMOST="$2"
			;;
		user32-Mouse_Message_Hwnd)
			enable_user32_Mouse_Message_Hwnd="$2"
			;;
		user32-Refresh_MDI_Menus)
			enable_user32_Refresh_MDI_Menus="$2"
			;;
		user32-ScrollWindowEx)
			enable_user32_ScrollWindowEx="$2"
			;;
		user32-SetCoalescableTimer)
			enable_user32_SetCoalescableTimer="$2"
			;;
		user32-WM_CTLCOLORBTN)
			enable_user32_WM_CTLCOLORBTN="$2"
			;;
		user32-WM_MDICALCCHILDSCROLL)
			enable_user32_WM_MDICALCCHILDSCROLL="$2"
			;;
		user32-WM_NOTIFY)
			enable_user32_WM_NOTIFY="$2"
			;;
		user32-WndProc)
			enable_user32_WndProc="$2"
			;;
		user32-lpCreateParams)
			enable_user32_lpCreateParams="$2"
			;;
		uxtheme-GTK_Theming)
			enable_uxtheme_GTK_Theming="$2"
			;;
		version-GetFileVersionInfoSizeExW)
			enable_version_GetFileVersionInfoSizeExW="$2"
			;;
		version-VerFindFileA)
			enable_version_VerFindFileA="$2"
			;;
		version-VerQueryValue)
			enable_version_VerQueryValue="$2"
			;;
		vulkan-Vulkan_Implementation)
			enable_vulkan_Vulkan_Implementation="$2"
			;;
		wbemdisp-ISWbemSecurity)
			enable_wbemdisp_ISWbemSecurity="$2"
			;;
		widl-SLTG_Typelib_Support)
			enable_widl_SLTG_Typelib_Support="$2"
			;;
		windowscodecs-32bppGrayFloat)
			enable_windowscodecs_32bppGrayFloat="$2"
			;;
		windowscodecs-IMILBitmapSource)
			enable_windowscodecs_IMILBitmapSource="$2"
			;;
		windowscodecs-WICCreateBitmapFromSection)
			enable_windowscodecs_WICCreateBitmapFromSection="$2"
			;;
		wine.inf-Directory_ContextMenuHandlers)
			enable_wine_inf_Directory_ContextMenuHandlers="$2"
			;;
		wine.inf-Dummy_CA_Certificate)
			enable_wine_inf_Dummy_CA_Certificate="$2"
			;;
		wine.inf-Performance)
			enable_wine_inf_Performance="$2"
			;;
		wine.inf-ProfileList_UserSID)
			enable_wine_inf_ProfileList_UserSID="$2"
			;;
		wine.inf-WMP_12)
			enable_wine_inf_WMP_12="$2"
			;;
		wineboot-DriveSerial)
			enable_wineboot_DriveSerial="$2"
			;;
		wineboot-HKEY_DYN_DATA)
			enable_wineboot_HKEY_DYN_DATA="$2"
			;;
		wineboot-drivers_etc_Stubs)
			enable_wineboot_drivers_etc_Stubs="$2"
			;;
		winecfg-Libraries)
			enable_winecfg_Libraries="$2"
			;;
		winecfg-Staging)
			enable_winecfg_Staging="$2"
			;;
		winecfg-Unmounted_Devices)
			enable_winecfg_Unmounted_Devices="$2"
			;;
		wined3d-Accounting)
			enable_wined3d_Accounting="$2"
			;;
		wined3d-CSMT_Helper)
			enable_wined3d_CSMT_Helper="$2"
			;;
		wined3d-DXTn)
			enable_wined3d_DXTn="$2"
			;;
		wined3d-Geforce_425M)
			enable_wined3d_Geforce_425M="$2"
			;;
		wined3d-Limit_Vram)
			enable_wined3d_Limit_Vram="$2"
			;;
		wined3d-Revert_PixelFormat)
			enable_wined3d_Revert_PixelFormat="$2"
			;;
		wined3d-Silence_FIXMEs)
			enable_wined3d_Silence_FIXMEs="$2"
			;;
		wined3d-resource_map)
			enable_wined3d_resource_map="$2"
			;;
		winedevice-Fix_Relocation)
			enable_winedevice_Fix_Relocation="$2"
			;;
		winemenubuilder-Desktop_Icon_Path)
			enable_winemenubuilder_Desktop_Icon_Path="$2"
			;;
		winepulse-PulseAudio_Support)
			enable_winepulse_PulseAudio_Support="$2"
			;;
		winex11-CandidateWindowPos)
			enable_winex11_CandidateWindowPos="$2"
			;;
		winex11-Clipboard_HTML)
			enable_winex11_Clipboard_HTML="$2"
			;;
		winex11-DefaultDisplayFrequency)
			enable_winex11_DefaultDisplayFrequency="$2"
			;;
		winex11-Desktop_Resolution)
			enable_winex11_Desktop_Resolution="$2"
			;;
		winex11-Window_Groups)
			enable_winex11_Window_Groups="$2"
			;;
		winex11-Window_Style)
			enable_winex11_Window_Style="$2"
			;;
		winex11-XEMBED)
			enable_winex11_XEMBED="$2"
			;;
		winex11-_NET_ACTIVE_WINDOW)
			enable_winex11__NET_ACTIVE_WINDOW="$2"
			;;
		winex11-wglShareLists)
			enable_winex11_wglShareLists="$2"
			;;
		winhttp-System_Proxy_Autoconfig)
			enable_winhttp_System_Proxy_Autoconfig="$2"
			;;
		wininet-Cleanup)
			enable_wininet_Cleanup="$2"
			;;
		wininet-HttpOpenRequestW)
			enable_wininet_HttpOpenRequestW="$2"
			;;
		wininet-Internet_Settings)
			enable_wininet_Internet_Settings="$2"
			;;
		wininet-ParseX509EncodedCertificateForListBoxEntry)
			enable_wininet_ParseX509EncodedCertificateForListBoxEntry="$2"
			;;
		winmm-Delay_Import_Depends)
			enable_winmm_Delay_Import_Depends="$2"
			;;
		winmm-mciSendCommandA)
			enable_winmm_mciSendCommandA="$2"
			;;
		winspool.drv-SetPrinterW)
			enable_winspool_drv_SetPrinterW="$2"
			;;
		winsta-WinStationEnumerateW)
			enable_winsta_WinStationEnumerateW="$2"
			;;
		wintrust-WinVerifyTrust)
			enable_wintrust_WinVerifyTrust="$2"
			;;
		wpcap-Dynamic_Linking)
			enable_wpcap_Dynamic_Linking="$2"
			;;
		wpcap-Several_Fixes)
			enable_wpcap_Several_Fixes="$2"
			;;
		ws2_32-APC_Performance)
			enable_ws2_32_APC_Performance="$2"
			;;
		ws2_32-Connect_Time)
			enable_ws2_32_Connect_Time="$2"
			;;
		ws2_32-DisconnectEx)
			enable_ws2_32_DisconnectEx="$2"
			;;
		ws2_32-Sort_default_route)
			enable_ws2_32_Sort_default_route="$2"
			;;
		ws2_32-TransmitFile)
			enable_ws2_32_TransmitFile="$2"
			;;
		ws2_32-WSACleanup)
			enable_ws2_32_WSACleanup="$2"
			;;
		ws2_32-WriteWatches)
			enable_ws2_32_WriteWatches="$2"
			;;
		ws2_32-getaddrinfo)
			enable_ws2_32_getaddrinfo="$2"
			;;
		ws2_32-getsockopt)
			enable_ws2_32_getsockopt="$2"
			;;
		wtsapi32-EnumerateProcesses)
			enable_wtsapi32_EnumerateProcesses="$2"
			;;
		wtsapi32-WTSQueryUserToken)
			enable_wtsapi32_WTSQueryUserToken="$2"
			;;
		wuauserv-Dummy_Service)
			enable_wuauserv_Dummy_Service="$2"
			;;
		wusa-MSU_Package_Installer)
			enable_wusa_MSU_Package_Installer="$2"
			;;
		*)
			return 1
			;;
	esac
	return 0
}

# Default settings
patch_enable_all 0
category_enable_all 0
enable_patchlist=1
enable_autoconf=1
patchlist="/dev/null"
backend="patch"

# Find location of patches
patchdir="$(dirname "$(readlink -f "$0")")"
if test ! -f "$patchdir/patchinstall.sh"; then
	if test -f ./patchinstall.sh; then
		patchdir="$(pwd)"
	else
		abort "Failed to find patch directory."
	fi
fi

# Parse commandline arguments
if test "$#" -eq 0; then
	abort "No commandline arguments given, don't know what to do."
fi

while test "$#" -gt 0; do
	case "$1" in
		DESTDIR=*)
			DESTDIR="${1#*=}"
			shift
			;;

		--all)
			patch_enable_all 1
			shift
			;;

		--backend=*)
			backend="${1#*=}"
			shift
			;;

		--force-autoconf)
			enable_autoconf=2
			shift
			;;

		--help)
			usage
			exit 0
			;;

		--no-patchlist)
			enable_patchlist=0
			shift
			;;

		--no-autoconf)
			enable_autoconf=0
			shift
			;;

		--upstream-commit)
			upstream_commit
			exit 0
			;;

		--version)
			version
			exit 0
			;;

		-W)
			# Disable patchset
			if ! patch_enable "$2" 2; then
				abort "Wrong usage of -W commandline argument, expected patchname."
			fi
			shift
			shift
			;;

		*)
			# Enable patchset
			if ! patch_enable "$1" 1; then
				abort "Unknown commandline argument $1."
			fi
			shift
			;;
	esac
done

# Determine DESTDIR if not explicitly specified
if test -z "$DESTDIR" -a -f ./tools/make_requests; then
	DESTDIR="$(pwd)"

elif test ! -f "$DESTDIR/tools/make_requests"; then
	abort "DESTDIR does not point to the Wine source tree."
fi

# Change directory to DESTDIR, epatch depends on that
if ! cd "$DESTDIR"; then
	abort "Unable to change directory to $DESTDIR."
fi

# Helper to update configure / the wineserver protocol if required
if ! command -v diff >/dev/null 2>&1 ||
   ! command -v grep >/dev/null 2>&1 ||
   ! command -v cmp >/dev/null 2>&1; then

	update_configure()
	{
		autoreconf -f
	}

	update_protocol()
	{
		./tools/make_requests
	}

else

	update_configure()
	{
		_file="./configure"

		if ! cp -a "$_file" "$_file.old"; then
			abort "failed to create $_file.old"
		fi

		if ! autoreconf -f; then
			rm "$_file.old"
			unset _file
			return 1
		fi

		# Shifting by 62 bits is undefined behaviour when off_t is 32-bit, see also
		# https://launchpad.net/ubuntu/+source/autoconf/2.69-6 - the bug is still
		# present in some other distros (including Archlinux).
		_large_off_old="^#define LARGE_OFF_T (((off_t) 1 << 62) - 1 + ((off_t) 1 << 62))$"
		_large_off_new="#define LARGE_OFF_T ((((off_t) 1 << 31) << 31) - 1 + (((off_t) 1 << 31) << 31))"
		sed -i'' -e "s|$_large_off_old|$_large_off_new|g" "$_file"
		unset _large_off_old _large_off_new

		# Restore original timestamp when nothing changed
		if ! cmp "$_file.old" "$_file" >/dev/null; then
			rm "$_file.old"
		else
			mv "$_file.old" "$_file"
		fi

		unset _file
		return 0
	}

	update_protocol()
	{
		_file="./include/wine/server_protocol.h"

		if ! cp -a "$_file" "$_file.old"; then
			abort "failed to create $_file.old"
		fi

		if ! ./tools/make_requests; then
			rm "$_file.old"
			unset _file
			return 1
		fi

		# Restore original timestamp when nothing changed
		if diff -u "$_file.old" "$_file" |
		   grep -v "^[+-]#define SERVER_PROTOCOL_VERSION" |
		   grep -v "^\(+++\|---\)" | grep -q "^[+-]"; then
			rm "$_file.old"
		else
			mv "$_file.old" "$_file"
		fi

		unset _file
		return 0
	}
fi


# Most backends will try to use git, either directly or indirectly.
# Unfortunately this does not work when "$DESTDIR" points to a
# subdirectory of a git tree, which has the effect that no patches
# are applied, but the exitcode is zero. To avoid broken builds we
# will workaround this issue or abort. For more information see
# https://github.com/wine-compholio/wine-staging/issues/7
test ! -d ".git" && git rev-parse --git-dir >/dev/null 2>&1
workaround_git_bug="$?"

# Apply the patches using gitapply.sh, a small wrapper around 'patch'
if test "$backend" = "patch"; then

	if test "$workaround_git_bug" -eq 0; then
		gitapply_args="--nogit"
	else
		gitapply_args=""
	fi

	if test "$enable_autoconf" -gt 1; then
		warning "Ignoring commandline argument --force-autoconf."
		enable_autoconf=1
	fi

	patch_apply_file()
	{
		echo "Applying $1"
		if ! "$patchdir/gitapply.sh" $gitapply_args < "$1"; then
			abort "Failed to apply patch, aborting!"
		fi
	}

# 'epatch' backend - used on Gentoo
elif test "$backend" = "epatch"; then

	if test "$workaround_git_bug" -eq 0; then
		gitapply_args="--nogit"
	else
		gitapply_args=""
	fi

	if ! command -v epatch >/dev/null 2>&1 || \
	   ! command -v ebegin >/dev/null 2>&1 || \
	   ! command -v eend   >/dev/null 2>&1 || \
	   ! command -v die    >/dev/null 2>&1; then
		abort "Shell functions epatch/ebegin/eend not found. You have to source this script from your ebuild."
	fi

	if test "$enable_autoconf" -gt 1; then
		warning "Ignoring commandline argument --force-autoconf."
		enable_autoconf=1
	fi

	patch_apply_file()
	{
		_shortname="$(basename "$1")"
		if grep -q "^GIT binary patch" "$1"; then
			ebegin "Applying $_shortname"
			if ! "$patchdir/gitapply.sh" $gitapply_args < "$1"; then
				die "Failed Patch: $1!"
			fi
			eend

		else
			epatch "$1" # epatch calls die upon failure
		fi
		unset _shortname
	}

# GIT backend - apply patches using 'git am'
elif test "$backend" = "git" -o "$backend" = "git-am"; then

	if test "$workaround_git_bug" -eq 0; then
		abort "Backend 'git-am' not possible when DESTDIR points to a git subdirectory."
	fi

	patch_apply_file()
	{
		echo "Applying $1"
		if ! git am "$1"; then
			abort "Failed to apply patch, aborting!"
		fi
		if test "$enable_autoconf" -gt 1; then
			_do_commit=0

			# Run 'autoreconf -f' if required
			if git show --pretty=format: --name-only | grep -q "^\(configure.ac\|aclocal.m4\)$"; then
				if ! update_configure; then
					abort "'autoreconf -f' failed."
				fi
				git add ./configure
				git add ./include/config.h.in
				_do_commit=1
			fi

			# Run './tools/make_requests' if required
			if git show --pretty=format: --name-only | grep -q "^server/"; then
				if ! update_protocol; then
					abort "'./tools/make_requests' failed."
				fi
				git add ./include/wine/server_protocol.h
				git add ./server/trace.c
				git add ./server/request.h
				_do_commit=1
			fi

			if test "$_do_commit" -ne 0; then
				if ! git commit --amend --reuse-message HEAD; then
					abort "Failed to include autogenerated changes in commit."
				fi
			fi

			unset _do_commit
		fi
	}

# Git apply backend
elif test "$backend" = "git-apply"; then

	if test "$workaround_git_bug" -eq 0; then
		abort "Backend 'git-apply' not possible when DESTDIR points to a git subdirectory."
	fi

	if test "$enable_autoconf" -gt 1; then
		warning "Ignoring commandline argument --force-autoconf."
		enable_autoconf=1
	fi

	patch_apply_file()
	{
		echo "Applying $1"
		if ! git apply "$1"; then
			abort "Failed to apply patch, aborting!"
		fi
	}

# Stacked GIT backend - import the patches (mainly for developers)
elif test "$backend" = "stg"; then

	if test "$workaround_git_bug" -eq 0; then
		abort "Backend 'stg' not possible when DESTDIR points to a git subdirectory."
	fi

	# Only import the regular patches, no autogenerated ones -
	# moreover, don't run autoreconf or ./tools/make_requests.
	enable_patchlist=0
	enable_autoconf=0

	patch_apply_file()
	{
		echo "Applying $1"
		_shortname="$(basename "$1")"
		if ! echo "staging/$_shortname" | cat - "$1" | stg import; then
			abort "Failed to apply patch, aborting!"
		fi
		unset _shortname
	}

else
	abort "Selected backend $backend not supported."
fi

patch_apply()
{
	patch_apply_file "$patchdir/$1"
}


if test "$enable_category_stable" -eq 1; then
	if test "$enable_Compiler_Warnings" -gt 1; then
		abort "Patchset Compiler_Warnings disabled, but category-stable depends on that."
	fi
	if test "$enable_Staging" -gt 1; then
		abort "Patchset Staging disabled, but category-stable depends on that."
	fi
	if test "$enable_configure_Absolute_RPATH" -gt 1; then
		abort "Patchset configure-Absolute_RPATH disabled, but category-stable depends on that."
	fi
	if test "$enable_d3d9_Skip_Tests" -gt 1; then
		abort "Patchset d3d9-Skip_Tests disabled, but category-stable depends on that."
	fi
	if test "$enable_d3d9_Surface_Refcount" -gt 1; then
		abort "Patchset d3d9-Surface_Refcount disabled, but category-stable depends on that."
	fi
	if test "$enable_d3dx9_24_ID3DXEffect" -gt 1; then
		abort "Patchset d3dx9_24-ID3DXEffect disabled, but category-stable depends on that."
	fi
	if test "$enable_d3dx9_25_ID3DXEffect" -gt 1; then
		abort "Patchset d3dx9_25-ID3DXEffect disabled, but category-stable depends on that."
	fi
	if test "$enable_d3dx9_26_ID3DXEffect" -gt 1; then
		abort "Patchset d3dx9_26-ID3DXEffect disabled, but category-stable depends on that."
	fi
	if test "$enable_d3dx9_36_D3DXStubs" -gt 1; then
		abort "Patchset d3dx9_36-D3DXStubs disabled, but category-stable depends on that."
	fi
	if test "$enable_d3dx9_36_FindNextValidTechnique" -gt 1; then
		abort "Patchset d3dx9_36-FindNextValidTechnique disabled, but category-stable depends on that."
	fi
	if test "$enable_d3dx9_36_Optimize_Inplace" -gt 1; then
		abort "Patchset d3dx9_36-Optimize_Inplace disabled, but category-stable depends on that."
	fi
	if test "$enable_d3dx9_36_Texture_Align" -gt 1; then
		abort "Patchset d3dx9_36-Texture_Align disabled, but category-stable depends on that."
	fi
	if test "$enable_d3dx9_36_UpdateSkinnedMesh" -gt 1; then
		abort "Patchset d3dx9_36-UpdateSkinnedMesh disabled, but category-stable depends on that."
	fi
	if test "$enable_dbghelp_Debug_Symbols" -gt 1; then
		abort "Patchset dbghelp-Debug_Symbols disabled, but category-stable depends on that."
	fi
	if test "$enable_ddraw_EnumSurfaces" -gt 1; then
		abort "Patchset ddraw-EnumSurfaces disabled, but category-stable depends on that."
	fi
	if test "$enable_fonts_Missing_Fonts" -gt 1; then
		abort "Patchset fonts-Missing_Fonts disabled, but category-stable depends on that."
	fi
	if test "$enable_kernel32_Named_Pipe" -gt 1; then
		abort "Patchset kernel32-Named_Pipe disabled, but category-stable depends on that."
	fi
	if test "$enable_libs_Debug_Channel" -gt 1; then
		abort "Patchset libs-Debug_Channel disabled, but category-stable depends on that."
	fi
	if test "$enable_libs_Unicode_Collation" -gt 1; then
		abort "Patchset libs-Unicode_Collation disabled, but category-stable depends on that."
	fi
	if test "$enable_makedep_PARENTSPEC" -gt 1; then
		abort "Patchset makedep-PARENTSPEC disabled, but category-stable depends on that."
	fi
	if test "$enable_mfplat_MFTRegister" -gt 1; then
		abort "Patchset mfplat-MFTRegister disabled, but category-stable depends on that."
	fi
	if test "$enable_mountmgr_DosDevices" -gt 1; then
		abort "Patchset mountmgr-DosDevices disabled, but category-stable depends on that."
	fi
	if test "$enable_mscoree_CorValidateImage" -gt 1; then
		abort "Patchset mscoree-CorValidateImage disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_APC_Start_Process" -gt 1; then
		abort "Patchset ntdll-APC_Start_Process disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_CLI_Images" -gt 1; then
		abort "Patchset ntdll-CLI_Images disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_DOS_Attributes" -gt 1; then
		abort "Patchset ntdll-DOS_Attributes disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_DllRedirects" -gt 1; then
		abort "Patchset ntdll-DllRedirects disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_FileFsFullSizeInformation" -gt 1; then
		abort "Patchset ntdll-FileFsFullSizeInformation disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_Fix_Alignment" -gt 1; then
		abort "Patchset ntdll-Fix_Alignment disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_FreeBSD_Directory" -gt 1; then
		abort "Patchset ntdll-FreeBSD_Directory disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_Heap_FreeLists" -gt 1; then
		abort "Patchset ntdll-Heap_FreeLists disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_NtSetLdtEntries" -gt 1; then
		abort "Patchset ntdll-NtSetLdtEntries disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_Pipe_SpecialCharacters" -gt 1; then
		abort "Patchset ntdll-Pipe_SpecialCharacters disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_RtlIpStringToAddress_Tests" -gt 1; then
		abort "Patchset ntdll-RtlIpStringToAddress_Tests disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_Threading" -gt 1; then
		abort "Patchset ntdll-Threading disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_User_Shared_Data" -gt 1; then
		abort "Patchset ntdll-User_Shared_Data disabled, but category-stable depends on that."
	fi
	if test "$enable_ntdll_WriteWatches" -gt 1; then
		abort "Patchset ntdll-WriteWatches disabled, but category-stable depends on that."
	fi
	if test "$enable_opengl32_Revert_Disable_Ext" -gt 1; then
		abort "Patchset opengl32-Revert_Disable_Ext disabled, but category-stable depends on that."
	fi
	if test "$enable_server_ClipCursor" -gt 1; then
		abort "Patchset server-ClipCursor disabled, but category-stable depends on that."
	fi
	if test "$enable_server_CreateProcess_ACLs" -gt 1; then
		abort "Patchset server-CreateProcess_ACLs disabled, but category-stable depends on that."
	fi
	if test "$enable_shell32_RunDLL_CallEntry16" -gt 1; then
		abort "Patchset shell32-RunDLL_CallEntry16 disabled, but category-stable depends on that."
	fi
	if test "$enable_shell32_SHFileOperation_Win9x" -gt 1; then
		abort "Patchset shell32-SHFileOperation_Win9x disabled, but category-stable depends on that."
	fi
	if test "$enable_user32_DrawTextExW" -gt 1; then
		abort "Patchset user32-DrawTextExW disabled, but category-stable depends on that."
	fi
	if test "$enable_user32_WndProc" -gt 1; then
		abort "Patchset user32-WndProc disabled, but category-stable depends on that."
	fi
	if test "$enable_wine_inf_Performance" -gt 1; then
		abort "Patchset wine.inf-Performance disabled, but category-stable depends on that."
	fi
	if test "$enable_wine_inf_ProfileList_UserSID" -gt 1; then
		abort "Patchset wine.inf-ProfileList_UserSID disabled, but category-stable depends on that."
	fi
	if test "$enable_wineboot_HKEY_DYN_DATA" -gt 1; then
		abort "Patchset wineboot-HKEY_DYN_DATA disabled, but category-stable depends on that."
	fi
	if test "$enable_winecfg_Libraries" -gt 1; then
		abort "Patchset winecfg-Libraries disabled, but category-stable depends on that."
	fi
	if test "$enable_wined3d_Revert_PixelFormat" -gt 1; then
		abort "Patchset wined3d-Revert_PixelFormat disabled, but category-stable depends on that."
	fi
	if test "$enable_wined3d_Silence_FIXMEs" -gt 1; then
		abort "Patchset wined3d-Silence_FIXMEs disabled, but category-stable depends on that."
	fi
	if test "$enable_winemenubuilder_Desktop_Icon_Path" -gt 1; then
		abort "Patchset winemenubuilder-Desktop_Icon_Path disabled, but category-stable depends on that."
	fi
	if test "$enable_winepulse_PulseAudio_Support" -gt 1; then
		abort "Patchset winepulse-PulseAudio_Support disabled, but category-stable depends on that."
	fi
	if test "$enable_winex11_Window_Style" -gt 1; then
		abort "Patchset winex11-Window_Style disabled, but category-stable depends on that."
	fi
	if test "$enable_winex11_XEMBED" -gt 1; then
		abort "Patchset winex11-XEMBED disabled, but category-stable depends on that."
	fi
	if test "$enable_winex11_wglShareLists" -gt 1; then
		abort "Patchset winex11-wglShareLists disabled, but category-stable depends on that."
	fi
	if test "$enable_wininet_ParseX509EncodedCertificateForListBoxEntry" -gt 1; then
		abort "Patchset wininet-ParseX509EncodedCertificateForListBoxEntry disabled, but category-stable depends on that."
	fi
	if test "$enable_winmm_Delay_Import_Depends" -gt 1; then
		abort "Patchset winmm-Delay_Import_Depends disabled, but category-stable depends on that."
	fi
	if test "$enable_ws2_32_Connect_Time" -gt 1; then
		abort "Patchset ws2_32-Connect_Time disabled, but category-stable depends on that."
	fi
	if test "$enable_ws2_32_WriteWatches" -gt 1; then
		abort "Patchset ws2_32-WriteWatches disabled, but category-stable depends on that."
	fi
	enable_Compiler_Warnings=1
	enable_Staging=1
	enable_configure_Absolute_RPATH=1
	enable_d3d9_Skip_Tests=1
	enable_d3d9_Surface_Refcount=1
	enable_d3dx9_24_ID3DXEffect=1
	enable_d3dx9_25_ID3DXEffect=1
	enable_d3dx9_26_ID3DXEffect=1
	enable_d3dx9_36_D3DXStubs=1
	enable_d3dx9_36_FindNextValidTechnique=1
	enable_d3dx9_36_Optimize_Inplace=1
	enable_d3dx9_36_Texture_Align=1
	enable_d3dx9_36_UpdateSkinnedMesh=1
	enable_dbghelp_Debug_Symbols=1
	enable_ddraw_EnumSurfaces=1
	enable_fonts_Missing_Fonts=1
	enable_kernel32_Named_Pipe=1
	enable_libs_Debug_Channel=1
	enable_libs_Unicode_Collation=1
	enable_makedep_PARENTSPEC=1
	enable_mfplat_MFTRegister=1
	enable_mountmgr_DosDevices=1
	enable_mscoree_CorValidateImage=1
	enable_ntdll_APC_Start_Process=1
	enable_ntdll_CLI_Images=1
	enable_ntdll_DOS_Attributes=1
	enable_ntdll_DllRedirects=1
	enable_ntdll_FileFsFullSizeInformation=1
	enable_ntdll_Fix_Alignment=1
	enable_ntdll_FreeBSD_Directory=1
	enable_ntdll_Heap_FreeLists=1
	enable_ntdll_NtSetLdtEntries=1
	enable_ntdll_Pipe_SpecialCharacters=1
	enable_ntdll_RtlIpStringToAddress_Tests=1
	enable_ntdll_Threading=1
	enable_ntdll_User_Shared_Data=1
	enable_ntdll_WriteWatches=1
	enable_opengl32_Revert_Disable_Ext=1
	enable_server_ClipCursor=1
	enable_server_CreateProcess_ACLs=1
	enable_shell32_RunDLL_CallEntry16=1
	enable_shell32_SHFileOperation_Win9x=1
	enable_user32_DrawTextExW=1
	enable_user32_WndProc=1
	enable_wine_inf_Performance=1
	enable_wine_inf_ProfileList_UserSID=1
	enable_wineboot_HKEY_DYN_DATA=1
	enable_winecfg_Libraries=1
	enable_wined3d_Revert_PixelFormat=1
	enable_wined3d_Silence_FIXMEs=1
	enable_winemenubuilder_Desktop_Icon_Path=1
	enable_winepulse_PulseAudio_Support=1
	enable_winex11_Window_Style=1
	enable_winex11_XEMBED=1
	enable_winex11_wglShareLists=1
	enable_wininet_ParseX509EncodedCertificateForListBoxEntry=1
	enable_winmm_Delay_Import_Depends=1
	enable_ws2_32_Connect_Time=1
	enable_ws2_32_WriteWatches=1
fi

if test "$enable_ws2_32_WSACleanup" -eq 1; then
	if test "$enable_server_Desktop_Refcount" -gt 1; then
		abort "Patchset server-Desktop_Refcount disabled, but ws2_32-WSACleanup depends on that."
	fi
	enable_server_Desktop_Refcount=1
fi

if test "$enable_ws2_32_TransmitFile" -eq 1; then
	if test "$enable_server_Desktop_Refcount" -gt 1; then
		abort "Patchset server-Desktop_Refcount disabled, but ws2_32-TransmitFile depends on that."
	fi
	enable_server_Desktop_Refcount=1
fi

if test "$enable_wpcap_Dynamic_Linking" -eq 1; then
	if test "$enable_wpcap_Several_Fixes" -gt 1; then
		abort "Patchset wpcap-Several_Fixes disabled, but wpcap-Dynamic_Linking depends on that."
	fi
	enable_wpcap_Several_Fixes=1
fi

if test "$enable_wined3d_CSMT_Helper" -eq 1; then
	if test "$enable_makedep_PARENTSPEC" -gt 1; then
		abort "Patchset makedep-PARENTSPEC disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_ntdll_DllRedirects" -gt 1; then
		abort "Patchset ntdll-DllRedirects disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_wined3d_DXTn" -gt 1; then
		abort "Patchset wined3d-DXTn disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_wined3d_resource_map" -gt 1; then
		abort "Patchset wined3d-resource_map disabled, but wined3d-CSMT_Helper depends on that."
	fi
	enable_makedep_PARENTSPEC=1
	enable_ntdll_DllRedirects=1
	enable_wined3d_DXTn=1
	enable_wined3d_resource_map=1
fi

if test "$enable_uxtheme_GTK_Theming" -eq 1; then
	if test "$enable_ntdll_DllRedirects" -gt 1; then
		abort "Patchset ntdll-DllRedirects disabled, but uxtheme-GTK_Theming depends on that."
	fi
	enable_ntdll_DllRedirects=1
fi

if test "$enable_user32_MessageBox_WS_EX_TOPMOST" -eq 1; then
	if test "$enable_user32_lpCreateParams" -gt 1; then
		abort "Patchset user32-lpCreateParams disabled, but user32-MessageBox_WS_EX_TOPMOST depends on that."
	fi
	enable_user32_lpCreateParams=1
fi

if test "$enable_stdole32_tlb_SLTG_Typelib" -eq 1; then
	if test "$enable_widl_SLTG_Typelib_Support" -gt 1; then
		abort "Patchset widl-SLTG_Typelib_Support disabled, but stdole32.tlb-SLTG_Typelib depends on that."
	fi
	enable_widl_SLTG_Typelib_Support=1
fi

if test "$enable_shell32_SHFileOperation_Win9x" -eq 1; then
	if test "$enable_shell32_Progress_Dialog" -gt 1; then
		abort "Patchset shell32-Progress_Dialog disabled, but shell32-SHFileOperation_Win9x depends on that."
	fi
	enable_shell32_Progress_Dialog=1
fi

if test "$enable_shell32_Progress_Dialog" -eq 1; then
	if test "$enable_kernel32_CopyFileEx" -gt 1; then
		abort "Patchset kernel32-CopyFileEx disabled, but shell32-Progress_Dialog depends on that."
	fi
	if test "$enable_shell32_SHFileOperation_Move" -gt 1; then
		abort "Patchset shell32-SHFileOperation_Move disabled, but shell32-Progress_Dialog depends on that."
	fi
	enable_kernel32_CopyFileEx=1
	enable_shell32_SHFileOperation_Move=1
fi

if test "$enable_server_Shared_Memory" -eq 1; then
	if test "$enable_ntdll_Threading" -gt 1; then
		abort "Patchset ntdll-Threading disabled, but server-Shared_Memory depends on that."
	fi
	if test "$enable_server_ClipCursor" -gt 1; then
		abort "Patchset server-ClipCursor disabled, but server-Shared_Memory depends on that."
	fi
	if test "$enable_server_Key_State" -gt 1; then
		abort "Patchset server-Key_State disabled, but server-Shared_Memory depends on that."
	fi
	if test "$enable_server_PeekMessage" -gt 1; then
		abort "Patchset server-PeekMessage disabled, but server-Shared_Memory depends on that."
	fi
	if test "$enable_server_Signal_Thread" -gt 1; then
		abort "Patchset server-Signal_Thread disabled, but server-Shared_Memory depends on that."
	fi
	enable_ntdll_Threading=1
	enable_server_ClipCursor=1
	enable_server_Key_State=1
	enable_server_PeekMessage=1
	enable_server_Signal_Thread=1
fi

if test "$enable_server_Pipe_ObjectName" -eq 1; then
	if test "$enable_kernel32_Named_Pipe" -gt 1; then
		abort "Patchset kernel32-Named_Pipe disabled, but server-Pipe_ObjectName depends on that."
	fi
	enable_kernel32_Named_Pipe=1
fi

if test "$enable_server_Inherited_ACLs" -eq 1; then
	if test "$enable_server_Stored_ACLs" -gt 1; then
		abort "Patchset server-Stored_ACLs disabled, but server-Inherited_ACLs depends on that."
	fi
	enable_server_Stored_ACLs=1
fi

if test "$enable_server_Stored_ACLs" -eq 1; then
	if test "$enable_ntdll_DOS_Attributes" -gt 1; then
		abort "Patchset ntdll-DOS_Attributes disabled, but server-Stored_ACLs depends on that."
	fi
	if test "$enable_server_File_Permissions" -gt 1; then
		abort "Patchset server-File_Permissions disabled, but server-Stored_ACLs depends on that."
	fi
	enable_ntdll_DOS_Attributes=1
	enable_server_File_Permissions=1
fi

if test "$enable_nvencodeapi_Video_Encoder" -eq 1; then
	if test "$enable_nvcuvid_CUDA_Video_Support" -gt 1; then
		abort "Patchset nvcuvid-CUDA_Video_Support disabled, but nvencodeapi-Video_Encoder depends on that."
	fi
	enable_nvcuvid_CUDA_Video_Support=1
fi

if test "$enable_nvcuvid_CUDA_Video_Support" -eq 1; then
	if test "$enable_nvapi_Stub_DLL" -gt 1; then
		abort "Patchset nvapi-Stub_DLL disabled, but nvcuvid-CUDA_Video_Support depends on that."
	fi
	enable_nvapi_Stub_DLL=1
fi

if test "$enable_nvapi_Stub_DLL" -eq 1; then
	if test "$enable_nvcuda_CUDA_Support" -gt 1; then
		abort "Patchset nvcuda-CUDA_Support disabled, but nvapi-Stub_DLL depends on that."
	fi
	enable_nvcuda_CUDA_Support=1
fi

if test "$enable_ntdll_WriteWatches" -eq 1; then
	if test "$enable_kernel32_Named_Pipe" -gt 1; then
		abort "Patchset kernel32-Named_Pipe disabled, but ntdll-WriteWatches depends on that."
	fi
	if test "$enable_ws2_32_WriteWatches" -gt 1; then
		abort "Patchset ws2_32-WriteWatches disabled, but ntdll-WriteWatches depends on that."
	fi
	enable_kernel32_Named_Pipe=1
	enable_ws2_32_WriteWatches=1
fi

if test "$enable_ntdll_WinSqm" -eq 1; then
	if test "$enable_ntdll_EtwRegisterTraceGuids" -gt 1; then
		abort "Patchset ntdll-EtwRegisterTraceGuids disabled, but ntdll-WinSqm depends on that."
	fi
	enable_ntdll_EtwRegisterTraceGuids=1
fi

if test "$enable_ntdll_WRITECOPY" -eq 1; then
	if test "$enable_ws2_32_WriteWatches" -gt 1; then
		abort "Patchset ws2_32-WriteWatches disabled, but ntdll-WRITECOPY depends on that."
	fi
	enable_ws2_32_WriteWatches=1
fi

if test "$enable_ntdll_SystemRoot_Symlink" -eq 1; then
	if test "$enable_ntdll_Exception" -gt 1; then
		abort "Patchset ntdll-Exception disabled, but ntdll-SystemRoot_Symlink depends on that."
	fi
	if test "$enable_ntdll_Syscall_Wrappers" -gt 1; then
		abort "Patchset ntdll-Syscall_Wrappers disabled, but ntdll-SystemRoot_Symlink depends on that."
	fi
	enable_ntdll_Exception=1
	enable_ntdll_Syscall_Wrappers=1
fi

if test "$enable_ntdll_RtlIpStringToAddress_Tests" -eq 1; then
	if test "$enable_ntdll_RtlQueryPackageIdentity" -gt 1; then
		abort "Patchset ntdll-RtlQueryPackageIdentity disabled, but ntdll-RtlIpStringToAddress_Tests depends on that."
	fi
	enable_ntdll_RtlQueryPackageIdentity=1
fi

if test "$enable_ntdll_Purist_Mode" -eq 1; then
	if test "$enable_ntdll_DllRedirects" -gt 1; then
		abort "Patchset ntdll-DllRedirects disabled, but ntdll-Purist_Mode depends on that."
	fi
	enable_ntdll_DllRedirects=1
fi

if test "$enable_ntdll_NtQuerySection" -eq 1; then
	if test "$enable_ntdll_Syscall_Wrappers" -gt 1; then
		abort "Patchset ntdll-Syscall_Wrappers disabled, but ntdll-NtQuerySection depends on that."
	fi
	enable_ntdll_Syscall_Wrappers=1
fi

if test "$enable_ntdll_Junction_Points" -eq 1; then
	if test "$enable_ntdll_Fix_Free" -gt 1; then
		abort "Patchset ntdll-Fix_Free disabled, but ntdll-Junction_Points depends on that."
	fi
	if test "$enable_ntdll_NtQueryEaFile" -gt 1; then
		abort "Patchset ntdll-NtQueryEaFile disabled, but ntdll-Junction_Points depends on that."
	fi
	enable_ntdll_Fix_Free=1
	enable_ntdll_NtQueryEaFile=1
fi

if test "$enable_ntdll_NtQueryEaFile" -eq 1; then
	if test "$enable_ntdll_Syscall_Wrappers" -gt 1; then
		abort "Patchset ntdll-Syscall_Wrappers disabled, but ntdll-NtQueryEaFile depends on that."
	fi
	enable_ntdll_Syscall_Wrappers=1
fi

if test "$enable_ntdll_DllRedirects" -eq 1; then
	if test "$enable_ntdll_DllOverrides_WOW64" -gt 1; then
		abort "Patchset ntdll-DllOverrides_WOW64 disabled, but ntdll-DllRedirects depends on that."
	fi
	if test "$enable_ntdll_Loader_Machine_Type" -gt 1; then
		abort "Patchset ntdll-Loader_Machine_Type disabled, but ntdll-DllRedirects depends on that."
	fi
	enable_ntdll_DllOverrides_WOW64=1
	enable_ntdll_Loader_Machine_Type=1
fi

if test "$enable_ntdll_DOS_Attributes" -eq 1; then
	if test "$enable_ntdll_Syscall_Wrappers" -gt 1; then
		abort "Patchset ntdll-Syscall_Wrappers disabled, but ntdll-DOS_Attributes depends on that."
	fi
	enable_ntdll_Syscall_Wrappers=1
fi

if test "$enable_ntdll_CLI_Images" -eq 1; then
	if test "$enable_mscoree_CorValidateImage" -gt 1; then
		abort "Patchset mscoree-CorValidateImage disabled, but ntdll-CLI_Images depends on that."
	fi
	enable_mscoree_CorValidateImage=1
fi

if test "$enable_ntdll_ApiSetQueryApiSetPresence" -eq 1; then
	if test "$enable_ntdll_EtwRegisterTraceGuids" -gt 1; then
		abort "Patchset ntdll-EtwRegisterTraceGuids disabled, but ntdll-ApiSetQueryApiSetPresence depends on that."
	fi
	enable_ntdll_EtwRegisterTraceGuids=1
fi

if test "$enable_kernel32_Named_Pipe" -eq 1; then
	if test "$enable_ntdll_FSCTL_PIPE_LISTEN" -gt 1; then
		abort "Patchset ntdll-FSCTL_PIPE_LISTEN disabled, but kernel32-Named_Pipe depends on that."
	fi
	if test "$enable_rpcrt4_Pipe_Transport" -gt 1; then
		abort "Patchset rpcrt4-Pipe_Transport disabled, but kernel32-Named_Pipe depends on that."
	fi
	if test "$enable_server_Desktop_Refcount" -gt 1; then
		abort "Patchset server-Desktop_Refcount disabled, but kernel32-Named_Pipe depends on that."
	fi
	enable_ntdll_FSCTL_PIPE_LISTEN=1
	enable_rpcrt4_Pipe_Transport=1
	enable_server_Desktop_Refcount=1
fi

if test "$enable_kernel32_CopyFileEx" -eq 1; then
	if test "$enable_kernel32_SetFileInformationByHandle" -gt 1; then
		abort "Patchset kernel32-SetFileInformationByHandle disabled, but kernel32-CopyFileEx depends on that."
	fi
	if test "$enable_ntdll_FileDispositionInformation" -gt 1; then
		abort "Patchset ntdll-FileDispositionInformation disabled, but kernel32-CopyFileEx depends on that."
	fi
	enable_kernel32_SetFileInformationByHandle=1
	enable_ntdll_FileDispositionInformation=1
fi

if test "$enable_ntdll_FileDispositionInformation" -eq 1; then
	if test "$enable_server_File_Permissions" -gt 1; then
		abort "Patchset server-File_Permissions disabled, but ntdll-FileDispositionInformation depends on that."
	fi
	enable_server_File_Permissions=1
fi

if test "$enable_dxva2_Video_Decoder" -eq 1; then
	if test "$enable_winecfg_Staging" -gt 1; then
		abort "Patchset winecfg-Staging disabled, but dxva2-Video_Decoder depends on that."
	fi
	enable_winecfg_Staging=1
fi

if test "$enable_dxdiagn_GetChildContainer_Leaf_Nodes" -eq 1; then
	if test "$enable_dxdiagn_Enumerate_DirectSound" -gt 1; then
		abort "Patchset dxdiagn-Enumerate_DirectSound disabled, but dxdiagn-GetChildContainer_Leaf_Nodes depends on that."
	fi
	enable_dxdiagn_Enumerate_DirectSound=1
fi

if test "$enable_dsound_EAX" -eq 1; then
	if test "$enable_dsound_Fast_Mixer" -gt 1; then
		abort "Patchset dsound-Fast_Mixer disabled, but dsound-EAX depends on that."
	fi
	if test "$enable_dsound_Revert_Cleanup" -gt 1; then
		abort "Patchset dsound-Revert_Cleanup disabled, but dsound-EAX depends on that."
	fi
	enable_dsound_Fast_Mixer=1
	enable_dsound_Revert_Cleanup=1
fi

if test "$enable_ddraw_IDirect3DTexture2_Load" -eq 1; then
	if test "$enable_wined3d_resource_map" -gt 1; then
		abort "Patchset wined3d-resource_map disabled, but ddraw-IDirect3DTexture2_Load depends on that."
	fi
	enable_wined3d_resource_map=1
fi

if test "$enable_d3dx9_36_D3DXDisassembleShader" -eq 1; then
	if test "$enable_d3dx9_36_GetShaderSemantics" -gt 1; then
		abort "Patchset d3dx9_36-GetShaderSemantics disabled, but d3dx9_36-D3DXDisassembleShader depends on that."
	fi
	enable_d3dx9_36_GetShaderSemantics=1
fi

if test "$enable_d3dx9_33_Share_Source" -eq 1; then
	if test "$enable_d3dx9_36_D3DXStubs" -gt 1; then
		abort "Patchset d3dx9_36-D3DXStubs disabled, but d3dx9_33-Share_Source depends on that."
	fi
	if test "$enable_d3dx9_36_DXTn" -gt 1; then
		abort "Patchset d3dx9_36-DXTn disabled, but d3dx9_33-Share_Source depends on that."
	fi
	enable_d3dx9_36_D3DXStubs=1
	enable_d3dx9_36_DXTn=1
fi

if test "$enable_d3dx9_36_DXTn" -eq 1; then
	if test "$enable_wined3d_DXTn" -gt 1; then
		abort "Patchset wined3d-DXTn disabled, but d3dx9_36-DXTn depends on that."
	fi
	enable_wined3d_DXTn=1
fi

if test "$enable_d3dx9_24_ID3DXEffect" -eq 1; then
	if test "$enable_d3dx9_25_ID3DXEffect" -gt 1; then
		abort "Patchset d3dx9_25-ID3DXEffect disabled, but d3dx9_24-ID3DXEffect depends on that."
	fi
	enable_d3dx9_25_ID3DXEffect=1
fi

if test "$enable_api_ms_win_Stub_DLLs" -eq 1; then
	if test "$enable_combase_RoApi" -gt 1; then
		abort "Patchset combase-RoApi disabled, but api-ms-win-Stub_DLLs depends on that."
	fi
	if test "$enable_kernel32_FreeUserPhysicalPages" -gt 1; then
		abort "Patchset kernel32-FreeUserPhysicalPages disabled, but api-ms-win-Stub_DLLs depends on that."
	fi
	if test "$enable_kernel32_GetCurrentPackageFamilyName" -gt 1; then
		abort "Patchset kernel32-GetCurrentPackageFamilyName disabled, but api-ms-win-Stub_DLLs depends on that."
	fi
	if test "$enable_kernel32_GetFinalPathNameByHandle" -gt 1; then
		abort "Patchset kernel32-GetFinalPathNameByHandle disabled, but api-ms-win-Stub_DLLs depends on that."
	fi
	enable_combase_RoApi=1
	enable_kernel32_FreeUserPhysicalPages=1
	enable_kernel32_GetCurrentPackageFamilyName=1
	enable_kernel32_GetFinalPathNameByHandle=1
fi

if test "$enable_advapi32_LsaLookupSids" -eq 1; then
	if test "$enable_server_CreateProcess_ACLs" -gt 1; then
		abort "Patchset server-CreateProcess_ACLs disabled, but advapi32-LsaLookupSids depends on that."
	fi
	if test "$enable_server_Misc_ACL" -gt 1; then
		abort "Patchset server-Misc_ACL disabled, but advapi32-LsaLookupSids depends on that."
	fi
	enable_server_CreateProcess_ACLs=1
	enable_server_Misc_ACL=1
fi


# If autoupdate is enabled then create a tempfile to keep track of all patches
if test "$enable_patchlist" -eq 1; then
	if test "$enable_Staging" -eq 1; then
		patchlist=$(mktemp)
		if test ! -f "$patchlist"; then
			abort "Unable to create temporary file for patchlist."
		fi
	else
		warning "Skipping generation of patchlist because 'Staging' patchset is disabled."
		enable_patchlist=0
	fi
fi


# Patchset Compiler_Warnings
# |
# | Modified files:
# |   *	dlls/amstream/mediastreamfilter.c, dlls/d2d1/brush.c, dlls/d2d1/geometry.c, dlls/d3d11/view.c, dlls/d3d8/texture.c,
# | 	dlls/d3d9/tests/visual.c, dlls/d3d9/texture.c, dlls/ddraw/viewport.c, dlls/dsound/primary.c, dlls/dwrite/layout.c,
# | 	dlls/msxml3/schema.c, dlls/netapi32/netapi32.c, dlls/oleaut32/oleaut.c, dlls/rpcrt4/cstub.c, dlls/vbscript/vbdisp.c,
# | 	dlls/winealsa.drv/mmdevdrv.c, dlls/wined3d/glsl_shader.c, include/wine/list.h, include/wine/rbtree.h, include/winnt.h,
# | 	tools/makedep.c
# |
if test "$enable_Compiler_Warnings" -eq 1; then
	patch_apply Compiler_Warnings/0001-Appease-the-blessed-version-of-gcc-4.5-when-Werror-i.patch
	patch_apply Compiler_Warnings/0002-dsound-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0003-amstream-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0004-d2d1-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0005-d3d11-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0006-d3d8-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0007-d3d9-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0008-ddraw-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0009-dwrite-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0010-msxml3-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0011-oleaut32-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0012-rpcrt4-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0013-vbscript-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0014-include-Check-element-type-in-CONTAINING_RECORD-and-.patch
	(
		echo '+    { "Erich E. Hoover", "Appease the blessed version of gcc (4.5) when -Werror is enabled.", 1 },';
		echo '+    { "Sebastian Lackner", "dsound: Avoid implicit cast of interface pointer.", 1 },';
		echo '+    { "Sebastian Lackner", "amstream: Avoid implicit cast of interface pointer.", 1 },';
		echo '+    { "Sebastian Lackner", "d2d1: Avoid implicit cast of interface pointer.", 1 },';
		echo '+    { "Sebastian Lackner", "d3d11: Avoid implicit cast of interface pointer.", 1 },';
		echo '+    { "Sebastian Lackner", "d3d8: Avoid implicit cast of interface pointer.", 1 },';
		echo '+    { "Sebastian Lackner", "d3d9: Avoid implicit cast of interface pointer.", 1 },';
		echo '+    { "Sebastian Lackner", "ddraw: Avoid implicit cast of interface pointer.", 1 },';
		echo '+    { "Sebastian Lackner", "dwrite: Avoid implicit cast of interface pointer.", 1 },';
		echo '+    { "Sebastian Lackner", "msxml3: Avoid implicit cast of interface pointer.", 1 },';
		echo '+    { "Sebastian Lackner", "oleaut32: Avoid implicit cast of interface pointer.", 1 },';
		echo '+    { "Sebastian Lackner", "rpcrt4: Avoid implicit cast of interface pointer.", 1 },';
		echo '+    { "Sebastian Lackner", "vbscript: Avoid implicit cast of interface pointer.", 1 },';
		echo '+    { "Sebastian Lackner", "include: Check element type in CONTAINING_RECORD and similar macros.", 1 },';
	) >> "$patchlist"
fi

# Patchset Coverity
# |
# | Modified files:
# |   *	tools/sfnt2fon/sfnt2fon.c, tools/winedump/msc.c
# |
if test "$enable_Coverity" -eq 1; then
	patch_apply Coverity/0001-sfnt2fon-Don-t-leak-output-name-if-specified-multipl.patch
	patch_apply Coverity/0002-winedump-Free-debug-string-in-case-it-was-not-freed-.patch
	(
		echo '+    { "André Hentschel", "sfnt2fon: Don'\''t leak output name if specified multiple times (Coverity).", 1 },';
		echo '+    { "André Hentschel", "winedump: Free debug string in case it was not freed in for-loop (Coverity).", 1 },';
	) >> "$patchlist"
fi

# Patchset Pipelight
# |
# | Modified files:
# |   *	dlls/user32/message.c, dlls/user32/tests/msg.c, dlls/wined3d/wined3d.spec, dlls/wined3d/wined3d_main.c,
# | 	dlls/winex11.drv/init.c, dlls/winex11.drv/opengl.c, dlls/winex11.drv/x11drv.h
# |
if test "$enable_Pipelight" -eq 1; then
	patch_apply Pipelight/0001-winex11-Implement-X11DRV_FLUSH_GDI_DISPLAY-ExtEscape-c.patch
	patch_apply Pipelight/0002-user32-Decrease-minimum-SetTimer-interval-to-5-ms.patch
	patch_apply Pipelight/0003-wined3d-allow-changing-strict-drawing-through-an-exp.patch
	patch_apply Pipelight/0004-winex11.drv-Indicate-direct-rendering-through-OpenGL.patch
	(
		echo '+    { "Sebastian Lackner", "winex11: Implement X11DRV_FLUSH_GDI_DISPLAY ExtEscape command.", 1 },';
		echo '+    { "Michael Müller", "user32: Decrease minimum SetTimer interval to 5 ms.", 2 },';
		echo '+    { "Michael Müller", "wined3d: Allow changing strict drawing through an exported function.", 1 },';
		echo '+    { "Michael Müller", "winex11.drv: Indicate direct rendering through OpenGL extension.", 1 },';
	) >> "$patchlist"
fi

# Patchset Staging
# |
# | Modified files:
# |   *	dlls/kernel32/process.c, dlls/ntdll/misc.c, dlls/ntdll/ntdll.spec, include/wine/library.h, libs/wine/Makefile.in,
# | 	libs/wine/config.c, libs/wine/loader.c, libs/wine/wine.def, libs/wine/wine.map, loader/main.c
# |
if test "$enable_Staging" -eq 1; then
	patch_apply Staging/0001-kernel32-Add-winediag-message-to-show-warning-that-t.patch
	patch_apply Staging/0002-winelib-Append-Staging-at-the-end-of-the-version-s.patch
	patch_apply Staging/0003-loader-Add-commandline-option-patches-to-show-the-pa.patch
	patch_apply Staging/0004-loader-Add-commandline-option-check-libs.patch
	patch_apply Staging/0005-loader-Print-library-paths-for-check-libs-on-Mac-OS-.patch
	(
		echo '+    { "Sebastian Lackner", "kernel32: Add winediag message to show warning, that this isn'\''t vanilla wine.", 1 },';
		echo '+    { "Sebastian Lackner", "winelib: Append '\''(Staging)'\'' at the end of the version string.", 1 },';
		echo '+    { "Sebastian Lackner", "loader: Add commandline option --patches to show the patch list.", 1 },';
		echo '+    { "Michael Müller", "loader: Add commandline option --check-libs.", 1 },';
		echo '+    { "Michael Müller", "loader: Print library paths for --check-libs on Mac OS X.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-CreateProcess_ACLs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22006] Support for process ACLs
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, dlls/kernel32/process.c, server/process.c, server/protocol.def
# |
if test "$enable_server_CreateProcess_ACLs" -eq 1; then
	patch_apply server-CreateProcess_ACLs/0001-server-Support-for-thread-and-process-security-descr.patch
	patch_apply server-CreateProcess_ACLs/0002-kernel32-Implement-passing-security-descriptors-from.patch
	patch_apply server-CreateProcess_ACLs/0003-advapi32-tests-Add-additional-tests-for-passing-a-th.patch
	(
		echo '+    { "Sebastian Lackner", "server: Support for thread and process security descriptors in new_process wineserver call.", 2 },';
		echo '+    { "Sebastian Lackner", "kernel32: Implement passing security descriptors from CreateProcess to the wineserver.", 2 },';
		echo '+    { "Joris van der Wel", "advapi32/tests: Add additional tests for passing a thread sd to CreateProcess.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Misc_ACL
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#15980] GetSecurityInfo returns NULL DACL for process object
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, server/process.c, server/security.h, server/token.c
# |
if test "$enable_server_Misc_ACL" -eq 1; then
	patch_apply server-Misc_ACL/0001-server-Add-default-security-descriptor-ownership-for.patch
	patch_apply server-Misc_ACL/0002-server-Add-default-security-descriptor-DACL-for-proc.patch
	(
		echo '+    { "Erich E. Hoover", "server: Add default security descriptor ownership for processes.", 1 },';
		echo '+    { "Erich E. Hoover", "server: Add default security descriptor DACL for processes.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-LsaLookupSids
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-CreateProcess_ACLs, server-Misc_ACL
# |
# | Modified files:
# |   *	dlls/advapi32/lsa.c, dlls/advapi32/security.c, dlls/advapi32/tests/security.c, server/token.c
# |
if test "$enable_advapi32_LsaLookupSids" -eq 1; then
	patch_apply advapi32-LsaLookupSids/0001-advapi32-Initialize-buffer-length-to-zero-in-LsaLook.patch
	patch_apply advapi32-LsaLookupSids/0002-advapi32-Prepend-a-hidden-LSA_TRUST_INFORMATION-in-L.patch
	patch_apply advapi32-LsaLookupSids/0003-advapi32-Prepend-a-hidden-LSA_TRUST_INFORMATION-in-L.patch
	patch_apply advapi32-LsaLookupSids/0004-advapi32-Fallback-to-Sid-string-when-LookupAccountSi.patch
	patch_apply advapi32-LsaLookupSids/0005-advapi32-tests-Test-prefix-and-use-of-TokenPrimaryGr.patch
	patch_apply advapi32-LsaLookupSids/0006-server-Create-primary-group-using-DOMAIN_GROUP_RID_U.patch
	patch_apply advapi32-LsaLookupSids/0007-advapi32-Fix-name-and-use-of-DOMAIN_GROUP_RID_USERS.patch
	(
		echo '+    { "Qian Hong", "advapi32: Initialize buffer length to zero in LsaLookupSids to prevent crash.", 2 },';
		echo '+    { "Qian Hong", "advapi32: Prepend a hidden LSA_TRUST_INFORMATION in LsaLookupSids to avoid crash when Domains[-1] incorrectly accessed by application.", 2 },';
		echo '+    { "Qian Hong", "advapi32: Prepend a hidden LSA_TRUST_INFORMATION in LsaLookupNames2 to avoid crash when Domains[-1] incorrectly accessed by application.", 2 },';
		echo '+    { "Qian Hong", "advapi32: Fallback to Sid string when LookupAccountSid fails.", 1 },';
		echo '+    { "Qian Hong", "advapi32/tests: Test prefix and use of TokenPrimaryGroup Sid.", 1 },';
		echo '+    { "Qian Hong", "server: Create primary group using DOMAIN_GROUP_RID_USERS.", 1 },';
		echo '+    { "Qian Hong", "advapi32: Fix name and use of DOMAIN_GROUP_RID_USERS.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-RegNotifyChangeKeyValue
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39863] Fix return value of RegNotifyChangeKeyValue for pending events
# |
# | Modified files:
# |   *	dlls/advapi32/registry.c, dlls/advapi32/tests/registry.c
# |
if test "$enable_advapi32_RegNotifyChangeKeyValue" -eq 1; then
	patch_apply advapi32-RegNotifyChangeKeyValue/0001-advapi32-Fix-return-value-of-RegNotifyChangeKeyValue.patch
	(
		echo '+    { "Sebastian Lackner", "advapi32: Fix return value of RegNotifyChangeKeyValue for pending events.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-SetSecurityInfo
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38423] Fix the initialization of combined DACLs when the new DACL is empty
# |
# | Modified files:
# |   *	dlls/advapi32/security.c
# |
if test "$enable_advapi32_SetSecurityInfo" -eq 1; then
	patch_apply advapi32-SetSecurityInfo/0001-advapi32-Move-the-DACL-combining-code-into-a-separat.patch
	patch_apply advapi32-SetSecurityInfo/0002-advapi32-Fix-the-initialization-of-combined-DACLs-wh.patch
	(
		echo '+    { "Erich E. Hoover", "advapi32: Move the DACL combining code into a separate routine.", 1 },';
		echo '+    { "Erich E. Hoover", "advapi32: Fix the initialization of combined DACLs when the new DACL is empty.", 1 },';
	) >> "$patchlist"
fi

# Patchset amstream-GetMultiMediaStream
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37090] Implement AMStream GetMultiMediaStream functions
# |
# | Modified files:
# |   *	dlls/amstream/mediastream.c
# |
if test "$enable_amstream_GetMultiMediaStream" -eq 1; then
	patch_apply amstream-GetMultiMediaStream/0001-amstream-Implement-IAMMediaStream-GetMultiMediaStrea.patch
	(
		echo '+    { "Michael Müller", "amstream: Implement IAMMediaStream::GetMultiMediaStream.", 1 },';
	) >> "$patchlist"
fi

# Patchset combase-RoApi
# |
# | Modified files:
# |   *	dlls/api-ms-win-core-winrt-l1-1-0/api-ms-win-core-winrt-l1-1-0.spec, dlls/api-ms-win-core-winrt-registration-l1-1-0/api-
# | 	ms-win-core-winrt-registration-l1-1-0.spec, dlls/combase/Makefile.in, dlls/combase/combase.spec, dlls/combase/roapi.c,
# | 	include/Makefile.in, include/activation.idl, include/objidl.idl, include/roapi.h
# |
if test "$enable_combase_RoApi" -eq 1; then
	patch_apply combase-RoApi/0001-include-Add-activation.idl-with-IActivationFactory-i.patch
	patch_apply combase-RoApi/0002-include-roapi.h-Add-further-typedefs.patch
	patch_apply combase-RoApi/0003-combase-Implement-RoGetActivationFactory.patch
	patch_apply combase-RoApi/0004-combase-Implement-RoActivateInstance.patch
	patch_apply combase-RoApi/0005-combase-Add-stub-for-RoGetApartmentIdentifier.patch
	patch_apply combase-RoApi/0006-include-objidl.idl-Add-IApartmentShutdown-interface.patch
	patch_apply combase-RoApi/0007-combase-Add-stub-for-RoRegisterForApartmentShutdown.patch
	patch_apply combase-RoApi/0008-combase-Add-stub-for-RoGetServerActivatableClasses.patch
	patch_apply combase-RoApi/0009-combase-Add-stub-for-RoRegisterActivationFactories.patch
	patch_apply combase-RoApi/0010-combase-Add-stub-for-CleanupTlsOleState.patch
	(
		echo '+    { "Michael Müller", "include: Add activation.idl with IActivationFactory interface.", 1 },';
		echo '+    { "Michael Müller", "include/roapi.h: Add further typedefs.", 1 },';
		echo '+    { "Michael Müller", "combase: Implement RoGetActivationFactory.", 1 },';
		echo '+    { "Michael Müller", "combase: Implement RoActivateInstance.", 1 },';
		echo '+    { "Michael Müller", "combase: Add stub for RoGetApartmentIdentifier.", 1 },';
		echo '+    { "Michael Müller", "include/objidl.idl: Add IApartmentShutdown interface.", 1 },';
		echo '+    { "Michael Müller", "combase: Add stub for RoRegisterForApartmentShutdown.", 1 },';
		echo '+    { "Michael Müller", "combase: Add stub for RoGetServerActivatableClasses.", 1 },';
		echo '+    { "Michael Müller", "combase: Add stub for RoRegisterActivationFactories.", 1 },';
		echo '+    { "Michael Müller", "combase: Add stub for CleanupTlsOleState.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-FreeUserPhysicalPages
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39543] Add stub kernel32.FreeUserPhysicalPages
# |
# | Modified files:
# |   *	dlls/api-ms-win-core-memory-l1-1-2/api-ms-win-core-memory-l1-1-2.spec, dlls/kernel32/heap.c, dlls/kernel32/kernel32.spec
# |
if test "$enable_kernel32_FreeUserPhysicalPages" -eq 1; then
	patch_apply kernel32-FreeUserPhysicalPages/0001-kernel32-add-FreeUserPhysicalPages-stub-try-2.patch
	(
		echo '+    { "Austin English", "kernel32: Add FreeUserPhysicalPages stub.", 2 },';
	) >> "$patchlist"
fi

# Patchset kernel32-GetCurrentPackageFamilyName
# |
# | Modified files:
# |   *	dlls/kernel32/kernel32.spec, dlls/kernel32/version.c
# |
if test "$enable_kernel32_GetCurrentPackageFamilyName" -eq 1; then
	patch_apply kernel32-GetCurrentPackageFamilyName/0001-kernel32-Add-stub-for-GetCurrentPackageFamilyName-an.patch
	(
		echo '+    { "Michael Müller", "kernel32: Add stub for GetCurrentPackageFamilyName and add related functions to spec file.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-GetFinalPathNameByHandle
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34851] Support for GetFinalPathNameByHandle
# |
# | Modified files:
# |   *	dlls/api-ms-win-core-file-l1-1-0/api-ms-win-core-file-l1-1-0.spec, dlls/api-ms-win-core-file-l1-2-0/api-ms-win-core-
# | 	file-l1-2-0.spec, dlls/api-ms-win-core-file-l1-2-1/api-ms-win-core-file-l1-2-1.spec, dlls/kernel32/file.c,
# | 	dlls/kernel32/kernel32.spec, dlls/kernelbase/kernelbase.spec
# |
if test "$enable_kernel32_GetFinalPathNameByHandle" -eq 1; then
	patch_apply kernel32-GetFinalPathNameByHandle/0001-kernel32-Implement-GetFinalPathNameByHandle.patch
	(
		echo '+    { "Michael Müller", "kernel32: Implement GetFinalPathNameByHandle.", 1 },';
	) >> "$patchlist"
fi

# Patchset api-ms-win-Stub_DLLs
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	combase-RoApi, kernel32-FreeUserPhysicalPages, kernel32-GetCurrentPackageFamilyName, kernel32-GetFinalPathNameByHandle
# |
# | Modified files:
# |   *	configure.ac, dlls/api-ms-win-appmodel-runtime-l1-1-1/Makefile.in, dlls/api-ms-win-appmodel-runtime-l1-1-1/api-ms-win-
# | 	appmodel-runtime-l1-1-1.spec, dlls/api-ms-win-core-apiquery-l1-1-0/Makefile.in, dlls/api-ms-win-core-apiquery-l1-1-0
# | 	/api-ms-win-core-apiquery-l1-1-0.spec, dlls/api-ms-win-core-heap-l2-1-0/Makefile.in, dlls/api-ms-win-core-heap-l2-1-0
# | 	/api-ms-win-core-heap-l2-1-0.spec, dlls/api-ms-win-core-quirks-l1-1-0/Makefile.in, dlls/api-ms-win-core-quirks-l1-1-0
# | 	/api-ms-win-core-quirks-l1-1-0.spec, dlls/api-ms-win-core-shlwapi-obsolete-l1-2-0/Makefile.in, dlls/api-ms-win-core-
# | 	shlwapi-obsolete-l1-2-0/api-ms-win-core-shlwapi-obsolete-l1-2-0.spec, dlls/api-ms-win-rtcore-ntuser-
# | 	draw-l1-1-0/Makefile.in, dlls/api-ms-win-rtcore-ntuser-draw-l1-1-0/api-ms-win-rtcore-ntuser-draw-l1-1-0.spec, dlls/api-
# | 	ms-win-rtcore-ntuser-window-l1-1-0/Makefile.in, dlls/api-ms-win-rtcore-ntuser-window-l1-1-0/api-ms-win-rtcore-ntuser-
# | 	window-l1-1-0.spec, dlls/api-ms-win-shcore-obsolete-l1-1-0/Makefile.in, dlls/api-ms-win-shcore-obsolete-l1-1-0/api-ms-
# | 	win-shcore-obsolete-l1-1-0.spec, dlls/api-ms-win-shcore-stream-l1-1-0/Makefile.in, dlls/api-ms-win-shcore-stream-l1-1-0
# | 	/api-ms-win-shcore-stream-l1-1-0.spec, dlls/api-ms-win-shcore-thread-l1-1-0/Makefile.in, dlls/api-ms-win-shcore-
# | 	thread-l1-1-0/api-ms-win-shcore-thread-l1-1-0.spec, dlls/ext-ms-win-appmodel-usercontext-l1-1-0/Makefile.in, dlls/ext-
# | 	ms-win-appmodel-usercontext-l1-1-0/ext-ms-win-appmodel-usercontext-l1-1-0.spec, dlls/ext-ms-win-appmodel-
# | 	usercontext-l1-1-0/main.c, dlls/ext-ms-win-kernel32-package-current-l1-1-0/Makefile.in, dlls/ext-ms-win-kernel32
# | 	-package-current-l1-1-0/ext-ms-win-kernel32-package-current-l1-1-0.spec, dlls/ext-ms-win-ntuser-
# | 	mouse-l1-1-0/Makefile.in, dlls/ext-ms-win-ntuser-mouse-l1-1-0/ext-ms-win-ntuser-mouse-l1-1-0.spec, dlls/ext-ms-win-
# | 	rtcore-ntuser-syscolors-l1-1-0/Makefile.in, dlls/ext-ms-win-rtcore-ntuser-syscolors-l1-1-0/ext-ms-win-rtcore-ntuser-
# | 	syscolors-l1-1-0.spec, dlls/ext-ms-win-rtcore-ntuser-sysparams-l1-1-0/Makefile.in, dlls/ext-ms-win-rtcore-ntuser-
# | 	sysparams-l1-1-0/ext-ms-win-rtcore-ntuser-sysparams-l1-1-0.spec, dlls/ext-ms-win-uxtheme-themes-l1-1-0/Makefile.in, dlls
# | 	/ext-ms-win-uxtheme-themes-l1-1-0/ext-ms-win-uxtheme-themes-l1-1-0.spec, dlls/ext-ms-win-xaml-pal-l1-1-0/Makefile.in,
# | 	dlls/ext-ms-win-xaml-pal-l1-1-0/ext-ms-win-xaml-pal-l1-1-0.spec, dlls/ext-ms-win-xaml-pal-l1-1-0/main.c,
# | 	dlls/iertutil/Makefile.in, dlls/iertutil/iertutil.spec, dlls/iertutil/main.c, dlls/kernelbase/Makefile.in,
# | 	dlls/kernelbase/kernelbase.spec, dlls/kernelbase/misc.c, dlls/shcore/Makefile.in, dlls/shcore/main.c,
# | 	dlls/shcore/shcore.spec, dlls/shlwapi/shlwapi.spec, include/Makefile.in, include/shellscalingapi.h, tools/make_specfiles
# |
if test "$enable_api_ms_win_Stub_DLLs" -eq 1; then
	patch_apply api-ms-win-Stub_DLLs/0001-kernelbase-Add-dll-and-add-stub-for-QuirkIsEnabled.patch
	patch_apply api-ms-win-Stub_DLLs/0002-api-ms-win-core-quirks-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0003-api-ms-win-appmodel-runtime-l1-1-1-Add-new-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0004-api-ms-win-core-apiquery-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0005-api-ms-win-core-heap-l2-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0006-iertutil-Add-dll-and-add-stub-for-ordinal-811.patch
	patch_apply api-ms-win-Stub_DLLs/0007-shcore-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0008-api-ms-win-shcore-obsolete-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0009-ext-ms-win-xaml-pal-l1-1-0-Add-dll-and-add-stub-for-.patch
	patch_apply api-ms-win-Stub_DLLs/0010-ext-ms-win-appmodel-usercontext-l1-1-0-Add-dll-and-a.patch
	patch_apply api-ms-win-Stub_DLLs/0011-api-ms-win-shcore-thread-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0012-ext-ms-win-xaml-pal-l1-1-0-Add-stub-for-GetThemeServ.patch
	patch_apply api-ms-win-Stub_DLLs/0013-api-ms-win-core-shlwapi-obsolete-l1-2-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0014-api-ms-win-shcore-stream-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0015-ext-ms-win-ntuser-mouse-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0016-ext-ms-win-uxtheme-themes-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0017-api-ms-win-rtcore-ntuser-window-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0018-ext-ms-win-rtcore-ntuser-syscolors-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0019-api-ms-win-rtcore-ntuser-draw-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0020-ext-ms-win-rtcore-ntuser-sysparams-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0021-ext-ms-win-kernel32-package-current-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0022-shcore-Add-SetProcessDpiAwareness-stub.patch
	patch_apply api-ms-win-Stub_DLLs/0023-shcore-Implement-stub-for-GetDpiForMonitor.patch
	patch_apply api-ms-win-Stub_DLLs/0024-kernelbase-Add-stub-for-QuirkIsEnabled3.patch
	patch_apply api-ms-win-Stub_DLLs/0025-shcore-Add-stub-for-GetProcessDpiAwareness.patch
	(
		echo '+    { "Michael Müller", "kernelbase: Add dll and add stub for QuirkIsEnabled.", 1 },';
		echo '+    { "Michael Müller", "api-ms-win-core-quirks-l1-1-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "api-ms-win-appmodel-runtime-l1-1-1: Add new dll.", 1 },';
		echo '+    { "Michael Müller", "api-ms-win-core-apiquery-l1-1-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "api-ms-win-core-heap-l2-1-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "iertutil: Add dll and add stub for ordinal 811.", 1 },';
		echo '+    { "Sebastian Lackner", "shcore: Add dll.", 1 },';
		echo '+    { "Michael Müller", "api-ms-win-shcore-obsolete-l1-1-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "ext-ms-win-xaml-pal-l1-1-0: Add dll and add stub for XamlBehaviorEnabled.", 1 },';
		echo '+    { "Michael Müller", "ext-ms-win-appmodel-usercontext-l1-1-0: Add dll and add stub for UserContextExtInitialize.", 1 },';
		echo '+    { "Michael Müller", "api-ms-win-shcore-thread-l1-1-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "ext-ms-win-xaml-pal-l1-1-0: Add stub for GetThemeServices.", 1 },';
		echo '+    { "Michael Müller", "api-ms-win-core-shlwapi-obsolete-l1-2-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "api-ms-win-shcore-stream-l1-1-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "ext-ms-win-ntuser-mouse-l1-1-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "ext-ms-win-uxtheme-themes-l1-1-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "api-ms-win-rtcore-ntuser-window-l1-1-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "ext-ms-win-rtcore-ntuser-syscolors-l1-1-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "api-ms-win-rtcore-ntuser-draw-l1-1-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "ext-ms-win-rtcore-ntuser-sysparams-l1-1-0: Add dll.", 1 },';
		echo '+    { "Michael Müller", "ext-ms-win-kernel32-package-current-l1-1-0: Add dll.", 1 },';
		echo '+    { "Sebastian Lackner", "shcore: Add SetProcessDpiAwareness stub.", 1 },';
		echo '+    { "Sebastian Lackner", "shcore: Implement stub for GetDpiForMonitor.", 1 },';
		echo '+    { "Michael Müller", "kernelbase: Add stub for QuirkIsEnabled3.", 1 },';
		echo '+    { "Sebastian Lackner", "shcore: Add stub for GetProcessDpiAwareness.", 1 },';
	) >> "$patchlist"
fi

# Patchset avifil32-AVIFile_Proxies
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38564] Add support for AVIFile interface proxies
# |
# | Modified files:
# |   *	dlls/avifil32/Makefile.in, dlls/avifil32/avifil32.idl, dlls/avifil32/avifile_ifaces.idl,
# | 	dlls/avifil32/avifile_private.h, dlls/avifil32/factory.c
# |
if test "$enable_avifil32_AVIFile_Proxies" -eq 1; then
	patch_apply avifil32-AVIFile_Proxies/0001-avifil32-Add-support-for-AVIFile-interface-proxies.-.patch
	(
		echo '+    { "Dmitry Timoshkov", "avifil32: Add support for AVIFile interface proxies.", 2 },';
	) >> "$patchlist"
fi

# Patchset avifil32-IGetFrame_fnSetFormat
# |
# | Modified files:
# |   *	dlls/avifil32/getframe.c
# |
if test "$enable_avifil32_IGetFrame_fnSetFormat" -eq 1; then
	patch_apply avifil32-IGetFrame_fnSetFormat/0001-avifil32-Correctly-handle-compressed-frames-when-des.patch
	(
		echo '+    { "Michael Müller", "avifil32: Correctly handle compressed frames when desired format is specified.", 1 },';
	) >> "$patchlist"
fi

# Patchset avifile.dll16-AVIStreamGetFrame
# |
# | Modified files:
# |   *	dlls/avifile.dll16/Makefile.in, dlls/avifile.dll16/avifile.dll16.spec, dlls/avifile.dll16/main.c
# |
if test "$enable_avifile_dll16_AVIStreamGetFrame" -eq 1; then
	patch_apply avifile.dll16-AVIStreamGetFrame/0001-avifile-Correctly-convert-result-of-AVIStreamGetFram.patch
	patch_apply avifile.dll16-AVIStreamGetFrame/0002-avifile-Convert-between-AVISTREAMINFO-16-bit-and-AVI.patch
	(
		echo '+    { "Michael Müller", "avifile.dll16: Correctly convert result of AVIStreamGetFrame to a segptr.", 1 },';
		echo '+    { "Michael Müller", "avifile.dll16: Convert between AVISTREAMINFO (16 bit) and AVISTREAMINFOA.", 1 },';
	) >> "$patchlist"
fi

# Patchset browseui-Progress_Dialog
# |
# | Modified files:
# |   *	dlls/browseui/browseui.rc, dlls/browseui/progressdlg.c, dlls/browseui/resids.h
# |
if test "$enable_browseui_Progress_Dialog" -eq 1; then
	patch_apply browseui-Progress_Dialog/0001-browseui-Implement-IProgressDialog-SetAnimation.patch
	patch_apply browseui-Progress_Dialog/0002-browseui-Implement-PROGDLG_AUTOTIME-flag-for-IProgre.patch
	(
		echo '+    { "Michael Müller", "browseui: Implement IProgressDialog::SetAnimation.", 1 },';
		echo '+    { "Michael Müller", "browseui: Implement PROGDLG_AUTOTIME flag for IProgressDialog.", 1 },';
	) >> "$patchlist"
fi

# Patchset comctl32-Button_Theming
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37584] Properly render themed buttons when they are pressed
# |
# | Modified files:
# |   *	dlls/comctl32/theme_button.c
# |
if test "$enable_comctl32_Button_Theming" -eq 1; then
	patch_apply comctl32-Button_Theming/0001-comctl32-fix-buttons-becoming-unthemed-when-pressed-.patch
	(
		echo '+    { "Samuel Kim", "comctl32: Fix buttons becoming unthemed when pressed/released.", 1 },';
	) >> "$patchlist"
fi

# Patchset comctl32-PROPSHEET_InsertPage
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#25625] Add implementation for comctl32.PROPSHEET_InsertPage.
# |
# | Modified files:
# |   *	dlls/comctl32/propsheet.c, dlls/comctl32/tests/propsheet.c
# |
if test "$enable_comctl32_PROPSHEET_InsertPage" -eq 1; then
	patch_apply comctl32-PROPSHEET_InsertPage/0001-comctl32-tests-Add-tests-for-PROPSHEET_InsertPage.patch
	patch_apply comctl32-PROPSHEET_InsertPage/0002-comctl32-Implement-PROPSHEET_InsertPage-based-on-PRO.patch
	(
		echo '+    { "Sebastian Lackner", "comctl32/tests: Add tests for PROPSHEET_InsertPage.", 1 },';
		echo '+    { "Peter Hater", "comctl32: Implement PROPSHEET_InsertPage based on PROPSHEET_AddPage.", 1 },';
	) >> "$patchlist"
fi

# Patchset comctl32-TTM_ADDTOOLW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#10347] Protect TTM_ADDTOOLW from invalid text pointers
# |
# | Modified files:
# |   *	dlls/comctl32/tests/tooltips.c, dlls/comctl32/tooltips.c
# |
if test "$enable_comctl32_TTM_ADDTOOLW" -eq 1; then
	patch_apply comctl32-TTM_ADDTOOLW/0001-comctl32-tooltip-Protect-TTM_ADDTOOLW-from-invalid-t.patch
	(
		echo '+    { "Alistair Leslie-Hughes", "comctl32/tooltip: Protect TTM_ADDTOOLW from invalid text pointers.", 1 },';
	) >> "$patchlist"
fi

# Patchset compobj.dll16-StringFromGUID2
# |
# | Modified files:
# |   *	dlls/compobj.dll16/compobj.c
# |
if test "$enable_compobj_dll16_StringFromGUID2" -eq 1; then
	patch_apply compobj.dll16-StringFromGUID2/0001-compobj.dll16-StringFromGUID2-must-write-a-char-stri.patch
	(
		echo '+    { "Michael Müller", "compobj.dll16: StringFromGUID2 must write a char string into the buffer.", 1 },';
	) >> "$patchlist"
fi

# Patchset configure-Absolute_RPATH
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#26256] Support for setcap on wine-preloader
# |
# | Modified files:
# |   *	configure.ac
# |
if test "$enable_configure_Absolute_RPATH" -eq 1; then
	patch_apply configure-Absolute_RPATH/0001-configure-Also-add-the-absolute-RPATH-when-linking-a.patch
	(
		echo '+    { "Sebastian Lackner", "configure: Also add the absolute RPATH when linking against libwine.", 1 },';
	) >> "$patchlist"
fi

# Patchset configure-Crosscompiling
# |
# | Modified files:
# |   *	configure.ac
# |
if test "$enable_configure_Crosscompiling" -eq 1; then
	patch_apply configure-Crosscompiling/0001-configure.ac-Fix-cross-compiling-of-32-bit-Wine-for-.patch
	(
		echo '+    { "Sebastian Lackner", "configure.ac: Fix cross-compiling of 32-bit Wine for OSX.", 1 },';
	) >> "$patchlist"
fi

# Patchset crypt32-CMS_Certificates
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34388] Skip unknown item when decoding a CMS certificate
# |
# | Modified files:
# |   *	dlls/crypt32/decode.c
# |
if test "$enable_crypt32_CMS_Certificates" -eq 1; then
	patch_apply crypt32-CMS_Certificates/0001-crypt32-Skip-unknown-item-when-decoding-a-CMS-certif.patch
	(
		echo '+    { "Charles Davis", "crypt32: Skip unknown item when decoding a CMS certificate.", 1 },';
	) >> "$patchlist"
fi

# Patchset crypt32-CryptUnprotectMemory
# |
# | Modified files:
# |   *	dlls/crypt32/main.c
# |
if test "$enable_crypt32_CryptUnprotectMemory" -eq 1; then
	patch_apply crypt32-CryptUnprotectMemory/0001-crypt32-Print-CryptUnprotectMemory-FIXME-only-once.patch
	(
		echo '+    { "Christian Costa", "crypt32: Print CryptUnprotectMemory FIXME only once.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d9-DesktopWindow
# |
# | Modified files:
# |   *	dlls/d3d9/tests/device.c, dlls/winex11.drv/opengl.c
# |
if test "$enable_d3d9_DesktopWindow" -eq 1; then
	patch_apply d3d9-DesktopWindow/0001-winex11.drv-Allow-changing-the-opengl-pixel-format-o.patch
	(
		echo '+    { "Michael Müller", "winex11.drv: Allow changing the opengl pixel format on the desktop window.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d9-Skip_Tests
# |
# | Modified files:
# |   *	dlls/d3d9/tests/device.c
# |
if test "$enable_d3d9_Skip_Tests" -eq 1; then
	patch_apply d3d9-Skip_Tests/0001-d3d9-tests-Avoid-crash-when-surface-and-texture-crea.patch
	(
		echo '+    { "Christian Costa", "d3d9/tests: Avoid crash when surface and texture creation fails.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d9-Surface_Refcount
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#18477] Avoid crashing when broken app tries to release surface although refcount is zero
# |
# | Modified files:
# |   *	dlls/d3d9/surface.c
# |
if test "$enable_d3d9_Surface_Refcount" -eq 1; then
	patch_apply d3d9-Surface_Refcount/0001-d3d9-Don-t-decrease-surface-refcount-when-its-alread.patch
	(
		echo '+    { "Henri Verbeet", "d3d9: Don'\''t decrease surface refcount when its already zero.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_25-ID3DXEffect
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#25138] Fix wrong version of ID3DXEffect interface for d3dx9_25
# |
# | Modified files:
# |   *	dlls/d3dx9_25/Makefile.in, dlls/d3dx9_25/d3dx9_25.spec, dlls/d3dx9_25/effect.c
# |
if test "$enable_d3dx9_25_ID3DXEffect" -eq 1; then
	patch_apply d3dx9_25-ID3DXEffect/0001-d3dx9_25-Add-an-interface-wrapper-for-different-vers.patch
	(
		echo '+    { "Sebastian Lackner", "d3dx9_25: Add an interface wrapper for different version of ID3DXEffect.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_24-ID3DXEffect
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3dx9_25-ID3DXEffect
# |
# | Modified files:
# |   *	dlls/d3dx9_24/d3dx9_24.spec
# |
if test "$enable_d3dx9_24_ID3DXEffect" -eq 1; then
	patch_apply d3dx9_24-ID3DXEffect/0001-d3dx9_24-Add-an-interface-wrapper-for-different-vers.patch
	(
		echo '+    { "Sebastian Lackner", "d3dx9_24: Add an interface wrapper for different version of ID3DXEffect.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_26-ID3DXEffect
# |
# | Modified files:
# |   *	dlls/d3dx9_36/effect.c
# |
if test "$enable_d3dx9_26_ID3DXEffect" -eq 1; then
	patch_apply d3dx9_26-ID3DXEffect/0001-d3dx9_36-Allow-to-query-for-d3dx9_26-specific-ID3DXE.patch
	(
		echo '+    { "Sebastian Lackner", "d3dx9_36: Allow to query for d3dx9_26 specific ID3DXEffect interface.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-D3DXStubs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38334] Add stub for D3DXFrameFind
# |
# | Modified files:
# |   *	dlls/d3dx9_24/d3dx9_24.spec, dlls/d3dx9_25/d3dx9_25.spec, dlls/d3dx9_26/d3dx9_26.spec, dlls/d3dx9_27/d3dx9_27.spec,
# | 	dlls/d3dx9_28/d3dx9_28.spec, dlls/d3dx9_29/d3dx9_29.spec, dlls/d3dx9_30/d3dx9_30.spec, dlls/d3dx9_31/d3dx9_31.spec,
# | 	dlls/d3dx9_32/d3dx9_32.spec, dlls/d3dx9_33/d3dx9_33.spec, dlls/d3dx9_34/d3dx9_34.spec, dlls/d3dx9_35/d3dx9_35.spec,
# | 	dlls/d3dx9_36/d3dx9_36.spec, dlls/d3dx9_36/mesh.c, dlls/d3dx9_37/d3dx9_37.spec, dlls/d3dx9_38/d3dx9_38.spec,
# | 	dlls/d3dx9_39/d3dx9_39.spec, dlls/d3dx9_40/d3dx9_40.spec, dlls/d3dx9_41/d3dx9_41.spec, dlls/d3dx9_42/d3dx9_42.spec,
# | 	dlls/d3dx9_43/d3dx9_43.spec
# |
if test "$enable_d3dx9_36_D3DXStubs" -eq 1; then
	patch_apply d3dx9_36-D3DXStubs/0001-d3dx9_36-Add-stub-for-D3DXComputeNormalMap.patch
	patch_apply d3dx9_36-D3DXStubs/0002-d3dx9_36-Add-D3DXFrameFind-stub.patch
	(
		echo '+    { "Christian Costa", "d3dx9_36: Add stub for D3DXComputeNormalMap.", 1 },';
		echo '+    { "Andrey Gusev", "d3dx9_36: Add D3DXFrameFind stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-DXTn
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#25486] Lego Stunt Rally requires DXTn software de/encoding support
# |   *	[#29586] Tumblebugs 2 requires DXTn software encoding support
# |   *	[#14939] Black & White needs DXTn software decoding support
# |   *	[#17913] Port Royale doesn't display ocean correctly
# |   *	[#29598] eRacer Demo doesn't correctly display text
# |
# | Modified files:
# |   *	configure.ac, dlls/wined3d/Makefile.in, dlls/wined3d/dxtn.c, dlls/wined3d/surface.c, dlls/wined3d/wined3d.spec,
# | 	dlls/wined3d/wined3d_main.c, dlls/wined3d/wined3d_private.h, include/wine/wined3d.h
# |
if test "$enable_wined3d_DXTn" -eq 1; then
	patch_apply wined3d-DXTn/0001-wined3d-Add-support-for-DXTn-software-decoding-throu.patch
	patch_apply wined3d-DXTn/0002-wined3d-Improve-DXTn-support-and-export-conversion-f.patch
	patch_apply wined3d-DXTn/0003-wined3d-add-DXT1-to-B4G4R4A4-DXT1-to-B5G5R5A1-and-DX.patch
	patch_apply wined3d-DXTn/0004-wined3d-Load-dxtn-dylib-library-on-Mac-OS-X.patch
	(
		echo '+    { "Michael Müller", "wined3d: Add support for DXTn software decoding through libtxc_dxtn.", 3 },';
		echo '+    { "Christian Costa", "wined3d: Improve DXTn support and export conversion functions for d3dx9_36.", 1 },';
		echo '+    { "Michael Müller", "wined3d: Add DXT1 to B4G4R4A4, DXT1 to B5G5R5A1 and DXT3 to B4G4R4A4 conversion.", 1 },';
		echo '+    { "Michael Müller", "wined3d: Load dxtn dylib library on Mac OS X.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-DXTn
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	wined3d-DXTn
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33768] Fix texture corruption in CSI: Fatal Conspiracy
# |   *	[#37391] Exception during start of fr-043 caused by missing DXTn support
# |   *	[#34692] Fix wrong colors in Wolfenstein (2009)
# |   *	[#24983] Fix crash in Space Rangers2 caused by missing DXTn support
# |
# | Modified files:
# |   *	dlls/d3dx9_36/Makefile.in, dlls/d3dx9_36/surface.c, dlls/d3dx9_36/tests/surface.c
# |
if test "$enable_d3dx9_36_DXTn" -eq 1; then
	patch_apply d3dx9_36-DXTn/0001-d3dx9_36-Add-dxtn-support.patch
	(
		echo '+    { "Christian Costa", "d3dx9_36: Add dxtn support.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_33-Share_Source
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3dx9_36-D3DXStubs, wined3d-DXTn, d3dx9_36-DXTn
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#21817] Share source of d3dx9_36 with d3dx9_33 to avoid Wine DLL forwards
# |
# | Modified files:
# |   *	dlls/d3dx9_33/Makefile.in, dlls/d3dx9_33/d3dx9_33.spec, dlls/d3dx9_33/d3dx9_33_main.c, tools/make_specfiles
# |
if test "$enable_d3dx9_33_Share_Source" -eq 1; then
	patch_apply d3dx9_33-Share_Source/0001-d3dx9_33-Share-the-source-with-d3dx9_36.patch
	(
		echo '+    { "Alistair Leslie-Hughes", "d3dx9_33: Share the source with d3dx9_36.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-CloneEffect
# |
# | Modified files:
# |   *	dlls/d3dx9_36/effect.c
# |
if test "$enable_d3dx9_36_CloneEffect" -eq 1; then
	patch_apply d3dx9_36-CloneEffect/0001-d3dx9_36-Improve-stub-for-ID3DXEffectImpl_CloneEffec.patch
	(
		echo '+    { "Sebastian Lackner", "d3dx9_36: Improve stub for ID3DXEffectImpl_CloneEffect.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-D3DXCreateTeapot
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#36884] Return a valid mesh in D3DXCreateTeapot
# |
# | Modified files:
# |   *	dlls/d3dx9_36/mesh.c
# |
if test "$enable_d3dx9_36_D3DXCreateTeapot" -eq 1; then
	patch_apply d3dx9_36-D3DXCreateTeapot/0001-d3dx9_36-Return-a-mesh-in-D3DXCreateTeapot.patch
	(
		echo '+    { "Alistair Leslie-Hughes", "d3dx9_36: Return a mesh in D3DXCreateTeapot.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-GetShaderSemantics
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22682] Support for D3DXGetShaderInputSemantics
# |
# | Modified files:
# |   *	dlls/d3dx9_36/d3dx9_36.spec, dlls/d3dx9_36/shader.c, dlls/d3dx9_36/tests/shader.c, include/d3dx9shader.h
# |
if test "$enable_d3dx9_36_GetShaderSemantics" -eq 1; then
	patch_apply d3dx9_36-GetShaderSemantics/0001-d3dx9_36-Implement-D3DXGetShaderInputSemantics-tests.patch
	patch_apply d3dx9_36-GetShaderSemantics/0002-d3dx9_36-Implement-D3DXGetShaderOutputSemantics.-rev.patch
	(
		echo '+    { "Christian Costa", "d3dx9_36: Implement D3DXGetShaderInputSemantics + tests.", 3 },';
		echo '+    { "Alistair Leslie-Hughes", "d3dx9_36: Implement D3DXGetShaderOutputSemantics.", 2 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-D3DXDisassembleShader
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3dx9_36-GetShaderSemantics
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37919] Implement d3dx9_36.D3DXCreateTextureShader with stub interface
# |
# | Modified files:
# |   *	dlls/d3dx9_36/d3dx9_36.spec, dlls/d3dx9_36/shader.c, dlls/d3dx9_36/tests/shader.c, include/d3dx9tex.h
# |
if test "$enable_d3dx9_36_D3DXDisassembleShader" -eq 1; then
	patch_apply d3dx9_36-D3DXDisassembleShader/0001-d3dx9_36-Implement-D3DXCreateTextureShader-with-stub.patch
	patch_apply d3dx9_36-D3DXDisassembleShader/0002-include-Fix-prototypes-of-D3DXFillXXXTextureTx-for-d.patch
	patch_apply d3dx9_36-D3DXDisassembleShader/0003-d3dx9_36-Add-stub-for-D3DXFillCubeTextureTX.patch
	patch_apply d3dx9_36-D3DXDisassembleShader/0004-d3dx9_36-Implement-D3DXDisassembleShader.patch
	patch_apply d3dx9_36-D3DXDisassembleShader/0005-d3dx9_36-tests-Add-initial-tests-for-D3DXDisassemble.patch
	patch_apply d3dx9_36-D3DXDisassembleShader/0006-d3dx9_36-tests-Add-additional-tests-for-special-case.patch
	(
		echo '+    { "Christian Costa", "d3dx9_36: Implement D3DXCreateTextureShader with stubbed ID3DXTextureShader interface.", 1 },';
		echo '+    { "Christian Costa", "include: Fix prototypes of D3DXFillXXXTextureTx for d3dx9.", 1 },';
		echo '+    { "Christian Costa", "d3dx9_36: Add stub for D3DXFillCubeTextureTX.", 1 },';
		echo '+    { "Christian Costa", "d3dx9_36: Implement D3DXDisassembleShader.", 2 },';
		echo '+    { "Sebastian Lackner", "d3dx9_36/tests: Add initial tests for D3DXDisassembleShader.", 1 },';
		echo '+    { "Christian Costa", "d3dx9_36/tests: Add additional tests for special cases.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-DDS
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#26898] Support for DDS file format in D3DXSaveTextureToFileInMemory
# |
# | Modified files:
# |   *	dlls/d3dx9_36/d3dx9_private.h, dlls/d3dx9_36/surface.c, dlls/d3dx9_36/texture.c
# |
if test "$enable_d3dx9_36_DDS" -eq 1; then
	patch_apply d3dx9_36-DDS/0001-d3dx9_36-Add-support-for-FOURCC-surface-to-save_dds_.patch
	patch_apply d3dx9_36-DDS/0002-d3dx9_36-Improve-D3DXSaveTextureToFile-to-save-simpl.patch
	(
		echo '+    { "Christian Costa", "d3dx9_36: Add support for FOURCC surface to save_dds_surface_to_memory.", 1 },';
		echo '+    { "Christian Costa", "d3dx9_36: Improve D3DXSaveTextureToFile to save simple texture to dds file.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-DrawText
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24754] Support for ID3DXFont::DrawTextA/W
# |
# | Modified files:
# |   *	dlls/d3dx9_36/font.c, dlls/d3dx9_36/tests/core.c
# |
if test "$enable_d3dx9_36_DrawText" -eq 1; then
	patch_apply d3dx9_36-DrawText/0001-d3dx9_36-Implement-ID3DXFontImpl_DrawText.patch
	patch_apply d3dx9_36-DrawText/0002-d3dx9_36-Fix-horizontal-centering-in-ID3DXFont_DrawT.patch
	patch_apply d3dx9_36-DrawText/0003-d3dx9_36-Support-NULL-terminated-strings-in-ID3DXFon.patch
	patch_apply d3dx9_36-DrawText/0004-d3dx9_36-ID3DXFont_DrawText-calc_rect-can-be-null.patch
	(
		echo '+    { "Christian Costa", "d3dx9_36: Implement ID3DXFontImpl_DrawText.", 1 },';
		echo '+    { "Christian Costa", "d3dx9_36: Fix horizontal centering in ID3DXFont_DrawText.", 1 },';
		echo '+    { "Alistair Leslie-Hughes", "d3dx9_36: Support NULL terminated strings in ID3DXFont_DrawText.", 1 },';
		echo '+    { "Alistair Leslie-Hughes", "d3dx9_36: ID3DXFont_DrawText calc_rect can be null.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-Dummy_Skininfo
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33904] Return dummy ID3DXSkinInfo interface when skinning info not present
# |
# | Modified files:
# |   *	dlls/d3dx9_36/d3dx9_private.h, dlls/d3dx9_36/mesh.c, dlls/d3dx9_36/skin.c, dlls/d3dx9_36/tests/mesh.c
# |
if test "$enable_d3dx9_36_Dummy_Skininfo" -eq 1; then
	patch_apply d3dx9_36-Dummy_Skininfo/0001-d3dx9_36-Return-dummy-skininfo-interface-in-D3DXLoad.patch
	patch_apply d3dx9_36-Dummy_Skininfo/0002-d3dx9_36-tests-Add-initial-tests-for-dummy-skininfo-.patch
	(
		echo '+    { "Michael Müller", "d3dx9_36: Return dummy skininfo interface in D3DXLoadSkinMeshFromXof when skin information is unavailable.", 1 },';
		echo '+    { "Michael Müller", "d3dx9_36/tests: Add initial tests for dummy skininfo interface.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-Filter_Warnings
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33770] D3DCompileShader should filter specific warning messages
# |
# | Modified files:
# |   *	dlls/d3dx9_36/shader.c
# |
if test "$enable_d3dx9_36_Filter_Warnings" -eq 1; then
	patch_apply d3dx9_36-Filter_Warnings/0001-d3dx9_36-Filter-out-D3DCompile-warning-messages-that.patch
	(
		echo '+    { "Christian Costa", "d3dx9_36: Filter out D3DCompile warning messages that are not present with D3DCompileShader.", 4 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-FindNextValidTechnique
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34101] Implement ID3DXEffect::FindNextValidTechnique
# |
# | Modified files:
# |   *	dlls/d3dx9_36/effect.c, dlls/d3dx9_36/tests/effect.c
# |
if test "$enable_d3dx9_36_FindNextValidTechnique" -eq 1; then
	patch_apply d3dx9_36-FindNextValidTechnique/0001-d3dx9_36-Implement-ID3DXEffect_FindNextValidTechniqu.patch
	(
		echo '+    { "Christian Costa", "d3dx9_36: Implement ID3DXEffect_FindNextValidTechnique + add tests.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-Optimize_Inplace
# |
# | Modified files:
# |   *	dlls/d3dx9_36/mesh.c
# |
if test "$enable_d3dx9_36_Optimize_Inplace" -eq 1; then
	patch_apply d3dx9_36-Optimize_Inplace/0001-d3dx9_36-No-need-to-fail-if-we-don-t-support-vertice.patch
	(
		echo '+    { "Christian Costa", "d3dx9_36: No need to fail if we don'\''t support vertices reordering in D3DXMESHOPT_ATTRSORT.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-Texture_Align
# |
# | Modified files:
# |   *	dlls/d3dx9_36/tests/texture.c, dlls/d3dx9_36/texture.c
# |
if test "$enable_d3dx9_36_Texture_Align" -eq 1; then
	patch_apply d3dx9_36-Texture_Align/0001-d3dx9_36-Align-texture-dimensions-to-block-size-for-.patch
	(
		echo '+    { "Christian Costa", "d3dx9_36: Align texture dimensions to block size for compressed textures in D3DXCheckTextureRequirements.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-UpdateSkinnedMesh
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32572] Support for ID3DXSkinInfoImpl_UpdateSkinnedMesh
# |
# | Modified files:
# |   *	dlls/d3dx9_36/skin.c, dlls/d3dx9_36/tests/mesh.c
# |
if test "$enable_d3dx9_36_UpdateSkinnedMesh" -eq 1; then
	patch_apply d3dx9_36-UpdateSkinnedMesh/0001-d3dx9_36-Implement-ID3DXSkinInfoImpl_UpdateSkinnedMe.patch
	(
		echo '+    { "Christian Costa", "d3dx9_36: Implement ID3DXSkinInfoImpl_UpdateSkinnedMesh.", 1 },';
	) >> "$patchlist"
fi

# Patchset dbghelp-Debug_Symbols
# |
# | Modified files:
# |   *	dlls/dbghelp/Makefile.in, dlls/dbghelp/elf_module.c
# |
if test "$enable_dbghelp_Debug_Symbols" -eq 1; then
	patch_apply dbghelp-Debug_Symbols/0001-dbghelp-Always-check-for-debug-symbols-in-BINDIR.patch
	(
		echo '+    { "Sebastian Lackner", "dbghelp: Always check for debug symbols in BINDIR.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-D3DFINDDEVICERESULT
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/tests/d3d.c, include/d3dcaps.h
# |
if test "$enable_ddraw_D3DFINDDEVICERESULT" -eq 1; then
	patch_apply ddraw-D3DFINDDEVICERESULT/0001-ddraw-Accept-d3d1-and-d3d2-versions-of-D3DFINDDEVICE.patch
	(
		echo '+    { "Michael Müller", "ddraw: Accept d3d1 and d3d2 versions of D3DFINDDEVICERESULT in IDirect3D_FindDevice.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Device_Caps
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#27002] Properly initialize caps->dwZBufferBitDepths in ddraw7_GetCaps
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/tests/ddraw1.c, dlls/ddraw/tests/ddraw2.c, dlls/ddraw/tests/ddraw4.c,
# | 	dlls/ddraw/tests/ddraw7.c
# |
if test "$enable_ddraw_Device_Caps" -eq 1; then
	patch_apply ddraw-Device_Caps/0001-ddraw-Don-t-set-HWTRANSFORMANDLIGHT-flag-on-d3d7-RGB.patch
	patch_apply ddraw-Device_Caps/0002-ddraw-Set-dwZBufferBitDepth-in-ddraw7_GetCaps.patch
	patch_apply ddraw-Device_Caps/0003-ddraw-Set-ddsOldCaps-correctly-in-ddraw7_GetCaps.patch
	(
		echo '+    { "Michael Müller", "ddraw: Don'\''t set HWTRANSFORMANDLIGHT flag on d3d7 RGB device.", 1 },';
		echo '+    { "Michael Müller", "ddraw: Set dwZBufferBitDepth in ddraw7_GetCaps.", 1 },';
		echo '+    { "Michael Müller", "ddraw: Set ddsOldCaps correctly in ddraw7_GetCaps.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-EnumSurfaces
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#17233] Implement DDENUMSURFACES_CANBECREATED in IDirectDraw7::EnumSurfaces
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/main.c, dlls/ddraw/tests/d3d.c
# |
if test "$enable_ddraw_EnumSurfaces" -eq 1; then
	patch_apply ddraw-EnumSurfaces/0001-ddraw-tests-Add-more-tests-for-IDirectDraw7-EnumSurf.patch
	patch_apply ddraw-EnumSurfaces/0002-ddraw-Fix-arguments-to-IDirectDraw7-EnumSurfaces-in-.patch
	patch_apply ddraw-EnumSurfaces/0003-ddraw-Implement-DDENUMSURFACES_CANBECREATED-flag-in-.patch
	(
		echo '+    { "Michael Müller", "ddraw/tests: Add more tests for IDirectDraw7::EnumSurfaces.", 1 },';
		echo '+    { "Michael Müller", "ddraw: Fix arguments to IDirectDraw7::EnumSurfaces in DllMain.", 1 },';
		echo '+    { "Michael Müller", "ddraw: Implement DDENUMSURFACES_CANBECREATED flag in ddraw7_EnumSurfaces.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Fix_Typos
# |
# | Modified files:
# |   *	dlls/ddraw/tests/dsurface.c
# |
if test "$enable_ddraw_Fix_Typos" -eq 1; then
	patch_apply ddraw-Fix_Typos/0001-ddraw-tests-Fix-function-name-in-multiple-ok-message.patch
	(
		echo '+    { "Sebastian Lackner", "ddraw/tests: Fix function name in multiple ok() messages.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-resource_map
# |
# | Modified files:
# |   *	dlls/d3d11/device.c, dlls/d3d11/texture.c, dlls/d3d8/surface.c, dlls/d3d8/volume.c, dlls/d3d9/surface.c,
# | 	dlls/d3d9/volume.c, dlls/ddraw/surface.c, dlls/wined3d/device.c, dlls/wined3d/resource.c, dlls/wined3d/surface.c,
# | 	dlls/wined3d/wined3d.spec, include/wine/wined3d.h
# |
if test "$enable_wined3d_resource_map" -eq 1; then
	patch_apply wined3d-resource_map/0001-wined3d-Rename-wined3d_resource_-un-map-to-wined3d_r.patch
	(
		echo '+    { "Sebastian Lackner", "wined3d: Rename wined3d_resource_(un)map to wined3d_resource_sub_resource_(un)map.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-IDirect3DTexture2_Load
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	wined3d-resource_map
# |
# | Modified files:
# |   *	dlls/ddraw/surface.c, dlls/ddraw/tests/d3d.c, dlls/ddraw/tests/ddraw2.c
# |
if test "$enable_ddraw_IDirect3DTexture2_Load" -eq 1; then
	patch_apply ddraw-IDirect3DTexture2_Load/0001-ddraw-Allow-size-and-format-conversions-in-IDirect3D.patch
	patch_apply ddraw-IDirect3DTexture2_Load/0002-ddraw-tests-Add-more-tests-for-IDirect3DTexture2-Loa.patch
	(
		echo '+    { "Michael Müller", "ddraw: Allow size and format conversions in IDirect3DTexture2::Load.", 1 },';
		echo '+    { "Michael Müller", "ddraw/tests: Add more tests for IDirect3DTexture2::Load.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Rendering_Targets
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34906] Use video memory for rendering targets if possible
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/ddraw_private.h, dlls/ddraw/device.c, dlls/ddraw/surface.c
# |
if test "$enable_ddraw_Rendering_Targets" -eq 1; then
	patch_apply ddraw-Rendering_Targets/0001-ddraw-Create-rendering-targets-in-video-memory-if-po.patch
	(
		echo '+    { "Michael Müller", "ddraw: Create rendering targets in video memory if possible.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Write_Vtable
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39534] Make ddraw1 and ddraw_surface1 vtable as writable
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/surface.c
# |
if test "$enable_ddraw_Write_Vtable" -eq 1; then
	patch_apply ddraw-Write_Vtable/0001-ddraw-Remove-const-from-ddraw1_vtbl-and-ddraw_surfac.patch
	(
		echo '+    { "Michael Müller", "ddraw: Remove const from ddraw1_vtbl and ddraw_surface1_vtbl.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-d3d_execute_buffer
# |
# | Modified files:
# |   *	dlls/ddraw/executebuffer.c
# |
if test "$enable_ddraw_d3d_execute_buffer" -eq 1; then
	patch_apply ddraw-d3d_execute_buffer/0001-ddraw-Don-t-call-IDirect3DDevice7_DrawIndexedPrimiti.patch
	(
		echo '+    { "Christian Costa", "ddraw: Don'\''t call IDirect3DDevice7_DrawIndexedPrimitive if there is no primitive.", 1 },';
	) >> "$patchlist"
fi

# Patchset dinput-Initialize
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#21403] Do not wait for hook thread startup in IDirectInput8::Initialize
# |
# | Modified files:
# |   *	dlls/dinput/dinput_main.c
# |
if test "$enable_dinput_Initialize" -eq 1; then
	patch_apply dinput-Initialize/0001-dinput-Do-not-wait-for-hook-thread-startup-in-IDirec.patch
	(
		echo '+    { "Sebastian Lackner", "dinput: Do not wait for hook thread startup in IDirectInput8::Initialize.", 1 },';
	) >> "$patchlist"
fi

# Patchset dsound-DSCAPS_CERTIFIED
# |
# | Modified files:
# |   *	dlls/dsound/dsound.c, dlls/dsound/tests/dsound.c
# |
if test "$enable_dsound_DSCAPS_CERTIFIED" -eq 1; then
	patch_apply dsound-DSCAPS_CERTIFIED/0001-dsound-Pretend-that-our-driver-is-certified.patch
	(
		echo '+    { "Michael Müller", "dsound: Pretend that our driver is certified.", 1 },';
	) >> "$patchlist"
fi

# Patchset dsound-Fast_Mixer
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30639] Audio stuttering and performance drops in multiple applications
# |
# | Modified files:
# |   *	dlls/dsound/dsound_main.c, dlls/dsound/dsound_private.h, dlls/dsound/mixer.c
# |
if test "$enable_dsound_Fast_Mixer" -eq 1; then
	patch_apply dsound-Fast_Mixer/0001-dsound-Add-a-linear-resampler-for-use-with-a-large-n.patch
	(
		echo '+    { "Alexander E. Patrakov", "dsound: Add a linear resampler for use with a large number of mixing buffers.", 2 },';
	) >> "$patchlist"
fi

# Patchset dsound-Revert_Cleanup
# |
# | Modified files:
# |   *	dlls/dsound/buffer.c, dlls/dsound/dsound.c, dlls/dsound/dsound_private.h
# |
if test "$enable_dsound_Revert_Cleanup" -eq 1; then
	patch_apply dsound-Revert_Cleanup/0001-Revert-dsound-Use-a-better-name-for-IDirectSoundBuff.patch
	patch_apply dsound-Revert_Cleanup/0002-Revert-dsound-Simplify-error-handling-when-creating-.patch
	(
		echo '+    { "Sebastian Lackner", "Revert \"dsound: Use a better name for IDirectSoundBufferImpl_Create().\".", 1 },';
		echo '+    { "Sebastian Lackner", "Revert \"dsound: Simplify error handling when creating a sound buffer.\".", 1 },';
	) >> "$patchlist"
fi

# Patchset dsound-EAX
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	dsound-Fast_Mixer, dsound-Revert_Cleanup
# |
# | Modified files:
# |   *	dlls/dsound/Makefile.in, dlls/dsound/buffer.c, dlls/dsound/dsound.c, dlls/dsound/dsound_eax.h,
# | 	dlls/dsound/dsound_main.c, dlls/dsound/dsound_private.h, dlls/dsound/eax.c, dlls/dsound/mixer.c
# |
if test "$enable_dsound_EAX" -eq 1; then
	patch_apply dsound-EAX/0001-dsound-Apply-filters-before-sound-is-multiplied-to-s.patch
	patch_apply dsound-EAX/0002-dsound-Add-EAX-v1-constants-and-structs.patch
	patch_apply dsound-EAX/0003-dsound-Report-that-we-support-EAX-v1.patch
	patch_apply dsound-EAX/0004-dsound-Add-EAX-propset-stubs.patch
	patch_apply dsound-EAX/0005-dsound-Add-EAX-presets.patch
	patch_apply dsound-EAX/0006-dsound-Support-getting-and-setting-EAX-properties.patch
	patch_apply dsound-EAX/0007-dsound-Support-getting-and-setting-EAX-buffer-proper.patch
	patch_apply dsound-EAX/0008-dsound-Add-EAX-init-and-free-stubs.patch
	patch_apply dsound-EAX/0009-dsound-Feed-data-through-EAX-function.patch
	patch_apply dsound-EAX/0010-dsound-Allocate-EAX-delay-lines.patch
	patch_apply dsound-EAX/0011-dsound-Add-EAX-VerbPass-stub.patch
	patch_apply dsound-EAX/0012-dsound-Implement-EAX-lowpass-filter.patch
	patch_apply dsound-EAX/0013-dsound-Add-delay-line-EAX-functions.patch
	patch_apply dsound-EAX/0014-dsound-Implement-EAX-early-reflections.patch
	patch_apply dsound-EAX/0015-dsound-Implement-EAX-decorrelator.patch
	patch_apply dsound-EAX/0016-dsound-Implement-EAX-late-reverb.patch
	patch_apply dsound-EAX/0017-dsound-Implement-EAX-late-all-pass-filter.patch
	patch_apply dsound-EAX/0018-dsound-Various-improvements-to-EAX-support.patch
	patch_apply dsound-EAX/0019-dsound-Allow-disabling-of-EAX-support-in-the-registr.patch
	patch_apply dsound-EAX/0020-dsound-Add-stub-support-for-DSPROPSETID_EAX20_Listen.patch
	patch_apply dsound-EAX/0021-dsound-Add-stub-support-for-DSPROPSETID_EAX20_Buffer.patch
	(
		echo '+    { "Sebastian Lackner", "dsound: Apply filters before sound is multiplied to speakers.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Add EAX v1 constants and structs.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Report that we support EAX.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Add EAX propset stubs.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Add EAX presets.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Support getting and setting EAX properties.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Support getting and setting EAX buffer properties.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Add EAX init and free stubs.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Feed data through EAX function.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Allocate EAX delay lines.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Add EAX VerbPass stub.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Implement EAX lowpass filter.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Add delay line EAX functions.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Implement EAX early reflections.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Implement EAX decorrelator.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Implement EAX late reverb.", 1 },';
		echo '+    { "Mark Harmstone", "dsound: Implement EAX late all-pass filter.", 1 },';
		echo '+    { "Sebastian Lackner", "dsound: Various improvements to EAX support.", 1 },';
		echo '+    { "Sebastian Lackner", "dsound: Allow disabling of EAX support in the registry.", 1 },';
		echo '+    { "Erich E. Hoover", "dsound: Add stub support for DSPROPSETID_EAX20_ListenerProperties.", 1 },';
		echo '+    { "Erich E. Hoover", "dsound: Add stub support for DSPROPSETID_EAX20_BufferProperties.", 1 },';
	) >> "$patchlist"
fi

# Patchset dwmapi-DwmSetWindowAttribute
# |
# | Modified files:
# |   *	dlls/dwmapi/dwmapi_main.c
# |
if test "$enable_dwmapi_DwmSetWindowAttribute" -eq 1; then
	patch_apply dwmapi-DwmSetWindowAttribute/0001-dwmapi-Return-S_OK-from-DwmSetWindowAttribute-functi.patch
	(
		echo '+    { "Michael Müller", "dwmapi: Return S_OK from DwmSetWindowAttribute function.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxdiagn-Display_Information
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34686] Return additional properties for display devices in dxdiagn
# |
# | Modified files:
# |   *	dlls/dxdiagn/provider.c, dlls/dxdiagn/tests/container.c
# |
if test "$enable_dxdiagn_Display_Information" -eq 1; then
	patch_apply dxdiagn-Display_Information/0001-dxdiagn-Add-several-more-fields-for-DisplayDevices.patch
	(
		echo '+    { "Michael Müller", "dxdiagn: Add several more fields for DisplayDevices.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxdiagn-Enumerate_DirectSound
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32613] Implement enumeration of sound devices and basic properties to dxdiagn
# |
# | Modified files:
# |   *	dlls/dxdiagn/Makefile.in, dlls/dxdiagn/provider.c, dlls/dxdiagn/tests/container.c
# |
if test "$enable_dxdiagn_Enumerate_DirectSound" -eq 1; then
	patch_apply dxdiagn-Enumerate_DirectSound/0001-dxdiagn-Enumerate-DirectSound-devices-and-add-some-b.patch
	(
		echo '+    { "Michael Müller", "dxdiagn: Enumerate DirectSound devices and add some basic properties.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxdiagn-GetChildContainer_Leaf_Nodes
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	dxdiagn-Enumerate_DirectSound
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38014] Implement special handling for calling GetChildContainer with an empty string
# |
# | Modified files:
# |   *	dlls/dxdiagn/container.c, dlls/dxdiagn/tests/container.c
# |
if test "$enable_dxdiagn_GetChildContainer_Leaf_Nodes" -eq 1; then
	patch_apply dxdiagn-GetChildContainer_Leaf_Nodes/0001-dxdiagn-Calling-GetChildContainer-with-an-empty-stri.patch
	(
		echo '+    { "Michael Müller", "dxdiagn: Calling GetChildContainer with an empty string on a leaf container returns the object itself.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxgi-MakeWindowAssociation
# |
# | Modified files:
# |   *	dlls/dxgi/dxgi_private.h, dlls/dxgi/factory.c
# |
if test "$enable_dxgi_MakeWindowAssociation" -eq 1; then
	patch_apply dxgi-MakeWindowAssociation/0001-dxgi-Improve-stubs-for-MakeWindowAssociation-and-Get.patch
	(
		echo '+    { "Michael Müller", "dxgi: Improve stubs for MakeWindowAssociation and GetWindowAssociation.", 1 },';
	) >> "$patchlist"
fi

# Patchset winecfg-Staging
# |
# | Modified files:
# |   *	programs/winecfg/Makefile.in, programs/winecfg/main.c, programs/winecfg/resource.h, programs/winecfg/staging.c,
# | 	programs/winecfg/winecfg.h, programs/winecfg/winecfg.rc
# |
if test "$enable_winecfg_Staging" -eq 1; then
	patch_apply winecfg-Staging/0001-winecfg-Add-staging-tab-for-CSMT.patch
	patch_apply winecfg-Staging/0002-winecfg-Add-checkbox-to-enable-disable-vaapi-GPU-dec.patch
	patch_apply winecfg-Staging/0003-winecfg-Add-checkbox-to-enable-disable-EAX-support.patch
	patch_apply winecfg-Staging/0004-winecfg-Add-checkbox-to-enable-disable-HideWineExpor.patch
	patch_apply winecfg-Staging/0005-winecfg-Add-option-to-enable-disable-GTK3-theming.patch
	(
		echo '+    { "Michael Müller", "winecfg: Add staging tab for CSMT.", 1 },';
		echo '+    { "Sebastian Lackner", "winecfg: Add checkbox to enable/disable vaapi GPU decoder.", 1 },';
		echo '+    { "Mark Harmstone", "winecfg: Add checkbox to enable/disable EAX support.", 1 },';
		echo '+    { "Sebastian Lackner", "winecfg: Add checkbox to enable/disable HideWineExports registry key.", 1 },';
		echo '+    { "Michael Müller", "winecfg: Add option to enable/disable GTK3 theming.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxva2-Video_Decoder
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	winecfg-Staging
# |
# | Modified files:
# |   *	configure.ac, dlls/dxva2/Makefile.in, dlls/dxva2/backend.idl, dlls/dxva2/devicemanager.c, dlls/dxva2/dxva2_private.h,
# | 	dlls/dxva2/genericdecoder.c, dlls/dxva2/main.c, dlls/dxva2/softwareprocessor.c, dlls/dxva2/tests/Makefile.in,
# | 	dlls/dxva2/tests/dxva2.c, dlls/dxva2/vaapi-h264.c, dlls/dxva2/vaapi-mpeg2.c, dlls/dxva2/vaapi.c,
# | 	dlls/dxva2/videoservices.c, include/Makefile.in, include/dxva.h, include/dxva2api.idl
# |
if test "$enable_dxva2_Video_Decoder" -eq 1; then
	patch_apply dxva2-Video_Decoder/0001-dxva2-Implement-semi-stub-for-Direct3DDeviceManager9.patch
	patch_apply dxva2-Video_Decoder/0002-dxva2-Implement-stubbed-interfaces-for-IDirectXVideo.patch
	patch_apply dxva2-Video_Decoder/0003-include-Fix-an-invalid-UUID-in-dxva2api.idl.patch
	patch_apply dxva2-Video_Decoder/0004-dxva2-Implement-stubbed-DirectX-Software-VideoProces.patch
	patch_apply dxva2-Video_Decoder/0005-include-Add-dxva.h-header-file.patch
	patch_apply dxva2-Video_Decoder/0006-dxva2-tests-Add-tests-for-dxva2-decoder.patch
	patch_apply dxva2-Video_Decoder/0007-dxva2-Initial-implementation-of-MPEG2-decoder-using-.patch
	patch_apply dxva2-Video_Decoder/0008-dxva2-Implement-h264-decoder.patch
	patch_apply dxva2-Video_Decoder/0009-dxva2-Add-DRM-mode-for-vaapi.patch
	patch_apply dxva2-Video_Decoder/0010-dxva2-Fill-h264-luma-and-chroma-weights-offsets-with.patch
	patch_apply dxva2-Video_Decoder/0011-dxva2-Always-destroy-buffers-when-calling-vaRenderPi.patch
	(
		echo '+    { "Sebastian Lackner", "dxva2: Implement semi-stub for Direct3DDeviceManager9 interface.", 1 },';
		echo '+    { "Michael Müller", "dxva2: Implement stubbed interfaces for IDirectXVideo{Acceleration,Decoder,Processor}Service.", 1 },';
		echo '+    { "Michael Müller", "include: Fix an invalid UUID in dxva2api.idl.", 1 },';
		echo '+    { "Michael Müller", "dxva2: Implement stubbed DirectX Software VideoProcessor interface.", 1 },';
		echo '+    { "Michael Müller", "include: Add dxva.h header file.", 1 },';
		echo '+    { "Michael Müller", "dxva2/tests: Add tests for dxva2 decoder.", 1 },';
		echo '+    { "Michael Müller", "dxva2: Initial implementation of MPEG2 decoder using vaapi backend.", 1 },';
		echo '+    { "Michael Müller", "dxva2: Implement h264 decoder.", 1 },';
		echo '+    { "Michael Müller", "dxva2: Add DRM mode for vaapi.", 1 },';
		echo '+    { "Michael Müller", "dxva2: Fill h264 luma and chroma weights / offsets with default values in case they are not specified.", 1 },';
		echo '+    { "Michael Müller", "dxva2: Always destroy buffers when calling vaRenderPicture.", 1 },';
	) >> "$patchlist"
fi

# Patchset explorer-Video_Registry_Key
# |
# | Modified files:
# |   *	dlls/advapi32/tests/registry.c, programs/explorer/desktop.c
# |
if test "$enable_explorer_Video_Registry_Key" -eq 1; then
	patch_apply explorer-Video_Registry_Key/0001-explorer-Create-CurrentControlSet-Control-Video-regi.patch
	(
		echo '+    { "Michael Müller", "explorer: Create CurrentControlSet\\\\Control\\\\Video registry key as non-volatile.", 1 },';
	) >> "$patchlist"
fi

# Patchset fonts-Missing_Fonts
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32323] Implement an Arial replacement font
# |   *	[#32342] Implement a Times New Roman replacement font
# |   *	[#20456] Implement a Courier New replacement font
# |   *	[#13829] Implement a Microsoft Yahei replacement font
# |
# | Modified files:
# |   *	COPYING.arial, COPYING.cour, COPYING.msyh, COPYING.times, LICENSE, fonts/Makefile.in, fonts/arial.sfd, fonts/arial.ttf,
# | 	fonts/cour.sfd, fonts/cour.ttf, fonts/msyh.sfd, fonts/msyh.ttf, fonts/times.sfd, fonts/times.ttf
# |
if test "$enable_fonts_Missing_Fonts" -eq 1; then
	patch_apply fonts-Missing_Fonts/0001-fonts-Add-Liberation-Sans-as-an-Arial-replacement.patch
	patch_apply fonts-Missing_Fonts/0002-fonts-Add-Liberation-Serif-as-an-Times-New-Roman-rep.patch
	patch_apply fonts-Missing_Fonts/0003-fonts-Add-Liberation-Mono-as-an-Courier-New-replacem.patch
	patch_apply fonts-Missing_Fonts/0004-fonts-Add-WenQuanYi-Micro-Hei-as-a-Microsoft-Yahei-r.patch
	patch_apply fonts-Missing_Fonts/0005-Add-licenses-for-fonts-as-separate-files.patch
	(
		echo '+    { "Torsten Kurbad", "fonts: Add Liberation Sans as an Arial replacement.", 2 },';
		echo '+    { "Sebastian Lackner", "fonts: Add Liberation Serif as an Times New Roman replacement.", 1 },';
		echo '+    { "Sebastian Lackner", "fonts: Add Liberation Mono as an Courier New replacement.", 1 },';
		echo '+    { "Erich E. Hoover", "fonts: Add WenQuanYi Micro Hei as a Microsoft Yahei replacement.", 1 },';
		echo '+    { "Michael Müller", "Add licenses for fonts as separate files.", 1 },';
	) >> "$patchlist"
fi

# Patchset fsutil-Stub_Program
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22749] Add stub for fsutil.exe hardlink command
# |
# | Modified files:
# |   *	configure.ac, programs/fsutil/Makefile.in, programs/fsutil/fsutil.rc, programs/fsutil/main.c,
# | 	programs/fsutil/resources.h
# |
if test "$enable_fsutil_Stub_Program" -eq 1; then
	patch_apply fsutil-Stub_Program/0001-fsutil-Add-fsutil-program-with-support-for-creating-.patch
	(
		echo '+    { "Michael Müller", "fsutil: Add fsutil program with support for creating hard links.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdi32-Lazy_Font_Initialization
# |
# | Modified files:
# |   *	dlls/gdi32/dc.c, dlls/gdi32/freetype.c
# |
if test "$enable_gdi32_Lazy_Font_Initialization" -eq 1; then
	patch_apply gdi32-Lazy_Font_Initialization/0001-gdi32-Perform-lazy-initialization-of-fonts-to-improv.patch
	(
		echo '+    { "Sebastian Lackner", "gdi32: Perform lazy initialization of fonts to improve startup performance.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdi32-MultiMonitor
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34978] Multiple applications need EnumDisplayDevicesW implementation
# |   *	[#37709] GetMonitorInfo returns the same name for all monitors
# |
# | Modified files:
# |   *	dlls/gdi32/driver.c, dlls/user32/misc.c, dlls/winemac.drv/display.c, dlls/winex11.drv/xinerama.c
# |
if test "$enable_gdi32_MultiMonitor" -eq 1; then
	patch_apply gdi32-MultiMonitor/0001-gdi32-Also-accept-.-DISPLAY-n-devices-names-with-n-o.patch
	patch_apply gdi32-MultiMonitor/0002-winex11-Make-GetMonitorInfo-give-a-different-device-.patch
	patch_apply gdi32-MultiMonitor/0003-user32-Implement-EnumDisplayDevicesW-based-on-EnumDi.patch
	patch_apply gdi32-MultiMonitor/0004-winemac-Make-GetMonitorInfo-give-a-different-device-.patch
	(
		echo '+    { "Ken Thomases", "gdi32: Also accept \"\\\\\\\\.\\\\DISPLAY<n>\" devices names with <n> other than 1 as display devices.", 1 },';
		echo '+    { "Ken Thomases", "winex11: Make GetMonitorInfo() give a different device name (\\\\.\\\\DISPLAY<n>) to each monitor.", 1 },';
		echo '+    { "Ken Thomases", "user32: Implement EnumDisplayDevicesW() based on EnumDisplayMonitors() and GetMonitorInfoW().", 1 },';
		echo '+    { "Ken Thomases", "winemac: Make GetMonitorInfo() give a different device name (\\\\\\\\.\\\\DISPLAY<n>) to each monitor.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdi32-Path_Metafile
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39185] Add support for paths on a metafile HDC
# |
# | Modified files:
# |   *	dlls/gdi32/enhmfdrv/dc.c, dlls/gdi32/path.c, dlls/gdi32/tests/metafile.c
# |
if test "$enable_gdi32_Path_Metafile" -eq 1; then
	patch_apply gdi32-Path_Metafile/0001-gdi32-tests-Add-some-additional-tests-for-ExtExtOut-.patch
	patch_apply gdi32-Path_Metafile/0002-gdi32-ExtTextOut-on-a-path-with-bitmap-font-selected.patch
	patch_apply gdi32-Path_Metafile/0003-gdi32-tests-Explicitly-test-BeginPath-return-value-i.patch
	patch_apply gdi32-Path_Metafile/0004-gdi32-Add-support-for-paths-on-a-metafile-HDC.-v2.patch
	(
		echo '+    { "Dmitry Timoshkov", "gdi32/tests: Add some additional tests for ExtExtOut on a path for an EMF DC.", 1 },';
		echo '+    { "Dmitry Timoshkov", "gdi32: ExtTextOut on a path with bitmap font selected shouldn'\''t fail.", 1 },';
		echo '+    { "Dmitry Timoshkov", "gdi32/tests: Explicitly test BeginPath() return value in the metafile path tests.", 1 },';
		echo '+    { "Dmitry Timoshkov", "gdi32: Add support for paths on a metafile HDC.", 3 },';
	) >> "$patchlist"
fi

# Patchset gdi32-Symbol_Truetype_Font
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33117] Improve detection of symbol charset for old truetype fonts
# |   *	[#12377] Fix font loading in Capella
# |
# | Modified files:
# |   *	dlls/gdi32/freetype.c
# |
if test "$enable_gdi32_Symbol_Truetype_Font" -eq 1; then
	patch_apply gdi32-Symbol_Truetype_Font/0001-gdi32-Improve-detection-of-symbol-charset-for-old-tr.patch
	(
		echo '+    { "Dmitry Timoshkov", "gdi32: Improve detection of symbol charset for old truetype fonts.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdiplus-GdipCreateMetafileFromStream
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40325] Implement GdipCreateMetafileFromStream
# |
# | Modified files:
# |   *	dlls/gdiplus/metafile.c
# |
if test "$enable_gdiplus_GdipCreateMetafileFromStream" -eq 1; then
	patch_apply gdiplus-GdipCreateMetafileFromStream/0001-gdiplus-Implement-GdipCreateMetafileFromStream.patch
	(
		echo '+    { "Dmitry Timoshkov", "gdiplus: Implement GdipCreateMetafileFromStream.", 1 },';
	) >> "$patchlist"
fi

# Patchset hal-KeQueryPerformanceCounter
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39500] Implement hal.KeQueryPerformanceCounter
# |
# | Modified files:
# |   *	dlls/hal/hal.c, dlls/hal/hal.spec
# |
if test "$enable_hal_KeQueryPerformanceCounter" -eq 1; then
	patch_apply hal-KeQueryPerformanceCounter/0001-hal-Implement-KeQueryPerformanceCounter.patch
	(
		echo '+    { "Michael Müller", "hal: Implement KeQueryPerformanceCounter.", 1 },';
	) >> "$patchlist"
fi

# Patchset hid-HidP_TranslateUsagesToI8042ScanCodes
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39447] Implement stub for hid.HidP_TranslateUsagesToI8042ScanCodes
# |
# | Modified files:
# |   *	dlls/hid/hid.spec, dlls/hid/hidp.c, include/ddk/hidpi.h
# |
if test "$enable_hid_HidP_TranslateUsagesToI8042ScanCodes" -eq 1; then
	patch_apply hid-HidP_TranslateUsagesToI8042ScanCodes/0001-hid-Stub-HidP_TranslateUsagesToI8042ScanCodes.patch
	(
		echo '+    { "Aric Stewart", "hid: Stub HidP_TranslateUsagesToI8042ScanCodes.", 1 },';
	) >> "$patchlist"
fi

# Patchset hnetcfg-INetFwAuthorizedApplication
# |
# | Modified files:
# |   *	dlls/hnetcfg/apps.c
# |
if test "$enable_hnetcfg_INetFwAuthorizedApplication" -eq 1; then
	patch_apply hnetcfg-INetFwAuthorizedApplication/0001-hnetcfg-Improve-INetFwAuthorizedApplication-get_Proc.patch
	(
		echo '+    { "Michael Müller", "hnetcfg: Improve INetFwAuthorizedApplication::get_ProcessImageFileName stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset ieframe-IViewObject-Draw
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30611] Fake success in IViewObject::Draw stub
# |
# | Modified files:
# |   *	dlls/ieframe/view.c
# |
if test "$enable_ieframe_IViewObject_Draw" -eq 1; then
	patch_apply ieframe-IViewObject-Draw/0001-ieframe-Return-S_OK-in-IViewObject-Draw-stub.patch
	(
		echo '+    { "Michael Müller", "ieframe: Return S_OK in IViewObject::Draw stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset iexplore-Revert_ProductVersion
# |
# | Modified files:
# |   *	programs/iexplore/iexplore.rc
# |
if test "$enable_iexplore_Revert_ProductVersion" -eq 1; then
	patch_apply iexplore-Revert_ProductVersion/0001-Revert-iexplore-Sync-registry-and-program-resource-v.patch
	(
		echo '+    { "Sebastian Lackner", "Revert \"iexplore: Sync registry and program resource values.\".", 1 },';
	) >> "$patchlist"
fi

# Patchset imagehlp-BindImageEx
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#3591] Support for BindImageEx
# |
# | Modified files:
# |   *	dlls/imagehlp/modify.c, dlls/imagehlp/tests/image.c
# |
if test "$enable_imagehlp_BindImageEx" -eq 1; then
	patch_apply imagehlp-BindImageEx/0001-imagehlp-Implement-parts-of-BindImageEx-to-make-free.patch
	(
		echo '+    { "Bernhard Reiter", "imagehlp: Implement parts of BindImageEx to make freezing Python scripts work.", 1 },';
	) >> "$patchlist"
fi

# Patchset imagehlp-Cleanup
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#23455] Properly implement imagehlp.ImageLoad and ImageUnload
# |
# | Modified files:
# |   *	dlls/imagehlp/access.c, dlls/imagehlp/modify.c, dlls/imagehlp/tests/integrity.c
# |
if test "$enable_imagehlp_Cleanup" -eq 1; then
	patch_apply imagehlp-Cleanup/0001-imagehlp-Catch-invalid-memory-access-in-CheckSumMapp.patch
	patch_apply imagehlp-Cleanup/0002-imagehlp-Fix-checksum-calculation-for-odd-sizes.patch
	patch_apply imagehlp-Cleanup/0003-imagehlp-Implement-ImageLoad-and-cleanup-ImageUnload.patch
	(
		echo '+    { "Michael Müller", "imagehlp: Catch invalid memory access in CheckSumMappedFile and add tests.", 1 },';
		echo '+    { "Michael Müller", "imagehlp: Fix checksum calculation for odd sizes.", 1 },';
		echo '+    { "Michael Müller", "imagehlp: Implement ImageLoad and cleanup ImageUnload.", 1 },';
	) >> "$patchlist"
fi

# Patchset imagehlp-ImageLoad
# |
# | Modified files:
# |   *	dlls/imagehlp/tests/image.c
# |
if test "$enable_imagehlp_ImageLoad" -eq 1; then
	patch_apply imagehlp-ImageLoad/0001-imagehlp-tests-Add-tests-for-ImageLoad-ImageUnload-G.patch
	patch_apply imagehlp-ImageLoad/0002-imagehlp-tests-msvc-compatibility-fixes.patch
	(
		echo '+    { "Mark Jansen", "imagehlp/tests: Add tests for ImageLoad, ImageUnload, GetImageUnusedHeaderBytes.", 1 },';
		echo '+    { "Mark Jansen", "imagehlp/tests: Msvc compatibility fixes.", 1 },';
	) >> "$patchlist"
fi

# Patchset imm32-IMMDisableLegacyIME
# |
# | Modified files:
# |   *	dlls/imm32/imm.c, dlls/imm32/imm32.spec
# |
if test "$enable_imm32_IMMDisableLegacyIME" -eq 1; then
	patch_apply imm32-IMMDisableLegacyIME/0001-imm32-Add-stub-for-ImmDisableLegacyIME.patch
	(
		echo '+    { "Michael Müller", "imm32: Add stub for ImmDisableLegacyIME.", 1 },';
	) >> "$patchlist"
fi

# Patchset iphlpapi-System_Ping
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8332] Fallback to system ping command when CAP_NET_RAW is not available
# |
# | Modified files:
# |   *	dlls/iphlpapi/icmp.c
# |
if test "$enable_iphlpapi_System_Ping" -eq 1; then
	patch_apply iphlpapi-System_Ping/0001-iphlpapi-Fallback-to-system-ping-when-ICMP-permissio.patch
	(
		echo '+    { "Sebastian Lackner", "iphlpapi: Fallback to system ping when ICMP permissions are not present.", 1 },';
	) >> "$patchlist"
fi

# Patchset iphlpapi-TCP_Table
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34372] Support for AllocateAndGetTcpExTableFromStack
# |
# | Modified files:
# |   *	dlls/iphlpapi/iphlpapi.spec, dlls/iphlpapi/ipstats.c, dlls/iphlpapi/ipstats.h
# |
if test "$enable_iphlpapi_TCP_Table" -eq 1; then
	patch_apply iphlpapi-TCP_Table/0001-iphlpapi-Implement-AllocateAndGetTcpExTableFromStack.patch
	(
		echo '+    { "Erich E. Hoover", "iphlpapi: Implement AllocateAndGetTcpExTableFromStack.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-COMSPEC
# |
# | Modified files:
# |   *	dlls/kernel32/process.c, programs/cmd/wcmdmain.c
# |
if test "$enable_kernel32_COMSPEC" -eq 1; then
	patch_apply kernel32-COMSPEC/0001-kernel32-Fallback-to-default-comspec-when-COMSPEC-is.patch
	(
		echo '+    { "Qian Hong", "kernel32: Fallback to default comspec when %COMSPEC% is not set.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-SetFileInformationByHandle
# |
# | Modified files:
# |   *	include/winbase.h
# |
if test "$enable_kernel32_SetFileInformationByHandle" -eq 1; then
	patch_apply kernel32-SetFileInformationByHandle/0001-include-Declare-a-couple-more-file-information-class.patch
	(
		echo '+    { "Michael Müller", "include: Declare a couple more file information class structures.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-File_Permissions
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, dlls/ntdll/tests/file.c, server/fd.c
# |
if test "$enable_server_File_Permissions" -eq 1; then
	patch_apply server-File_Permissions/0001-server-Allow-to-open-files-without-any-permission-bi.patch
	patch_apply server-File_Permissions/0002-server-When-creating-new-directories-temporarily-giv.patch
	patch_apply server-File_Permissions/0003-advapi32-tests-Add-tests-for-ACL-inheritance-in-Crea.patch
	patch_apply server-File_Permissions/0004-advapi32-tests-Add-ACL-inheritance-tests-for-creatin.patch
	patch_apply server-File_Permissions/0005-ntdll-tests-Added-tests-for-open-behaviour-on-readon.patch
	patch_apply server-File_Permissions/0006-server-FILE_WRITE_ATTRIBUTES-should-succeed-for-read.patch
	(
		echo '+    { "Sebastian Lackner", "server: Allow to open files without any permission bits.", 2 },';
		echo '+    { "Sebastian Lackner", "server: When creating new directories temporarily give read-permissions until they are opened.", 1 },';
		echo '+    { "Sebastian Lackner", "advapi32/tests: Add tests for ACL inheritance in CreateDirectoryA.", 1 },';
		echo '+    { "Sebastian Lackner", "advapi32/tests: Add ACL inheritance tests for creating subdirectories with NtCreateFile.", 1 },';
		echo '+    { "Qian Hong", "ntdll/tests: Added tests for open behaviour on readonly files.", 1 },';
		echo '+    { "Sebastian Lackner", "server: FILE_WRITE_ATTRIBUTES should succeed for readonly files.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FileDispositionInformation
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-File_Permissions
# |
# | Modified files:
# |   *	dlls/ntdll/tests/file.c, server/fd.c
# |
if test "$enable_ntdll_FileDispositionInformation" -eq 1; then
	patch_apply ntdll-FileDispositionInformation/0001-ntdll-tests-Added-tests-to-set-disposition-on-file-w.patch
	patch_apply ntdll-FileDispositionInformation/0002-server-Do-not-allow-to-set-disposition-on-file-which.patch
	patch_apply ntdll-FileDispositionInformation/0003-server-When-combining-root-and-name-make-sure-there-.patch
	(
		echo '+    { "Qian Hong", "ntdll/tests: Added tests to set disposition on file which is mapped to memory.", 1 },';
		echo '+    { "Qian Hong", "server: Do not allow to set disposition on file which has a file mapping.", 1 },';
		echo '+    { "Sebastian Lackner", "server: When combining root and name, make sure there is only one slash.", 2 },';
	) >> "$patchlist"
fi

# Patchset kernel32-CopyFileEx
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	kernel32-SetFileInformationByHandle, server-File_Permissions, ntdll-FileDispositionInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22692] Add support for CopyFileEx progress callback
# |   *	[#22690] Allow to cancel a file operation via progress callback
# |
# | Modified files:
# |   *	dlls/kernel32/path.c, dlls/kernel32/tests/file.c
# |
if test "$enable_kernel32_CopyFileEx" -eq 1; then
	patch_apply kernel32-CopyFileEx/0001-kernel32-Add-support-for-progress-callback-in-CopyFi.patch
	(
		echo '+    { "Michael Müller", "kernel32: Add support for progress callback in CopyFileEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Cwd_Startup_Info
# |
# | Modified files:
# |   *	dlls/kernel32/process.c
# |
if test "$enable_kernel32_Cwd_Startup_Info" -eq 1; then
	patch_apply kernel32-Cwd_Startup_Info/0001-kernel32-Allow-non-nullterminated-string-as-working-.patch
	(
		echo '+    { "Sebastian Lackner", "kernel32: Allow non-nullterminated string as working directory in create_startup_info.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-FindFirstFile
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22635] Strip invalid characters from mask in FindFirstFileExW
# |
# | Modified files:
# |   *	dlls/kernel32/file.c, dlls/kernel32/tests/file.c
# |
if test "$enable_kernel32_FindFirstFile" -eq 1; then
	patch_apply kernel32-FindFirstFile/0001-kernel32-Strip-invalid-characters-from-mask-in-FindF.patch
	patch_apply kernel32-FindFirstFile/0002-kernel32-tests-Add-tests-for-FindFirstFileA-with-inv.patch
	(
		echo '+    { "Michael Müller", "kernel32: Strip invalid characters from mask in FindFirstFileExW.", 1 },';
		echo '+    { "Michael Müller", "kernel32/tests: Add tests for FindFirstFileA with invalid characters.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-LocaleNameToLCID
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30076] Silence repeated LocaleNameToLCID/LCIDToLocaleName unsupported flags FIXMEs
# |
# | Modified files:
# |   *	dlls/kernel32/locale.c
# |
if test "$enable_kernel32_LocaleNameToLCID" -eq 1; then
	patch_apply kernel32-LocaleNameToLCID/0001-kernel32-Silence-repeated-LocaleNameToLCID-unsupport.patch
	(
		echo '+    { "Jarkko Korpi", "kernel32: Silence repeated LocaleNameToLCID unsupported flags message.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FSCTL_PIPE_LISTEN
# |
# | Modified files:
# |   *	dlls/kernel32/tests/pipe.c, dlls/ntdll/file.c, dlls/ntdll/tests/pipe.c
# |
if test "$enable_ntdll_FSCTL_PIPE_LISTEN" -eq 1; then
	patch_apply ntdll-FSCTL_PIPE_LISTEN/0001-ntdll-tests-Add-tests-for-iosb.Status-value-after-pe.patch
	patch_apply ntdll-FSCTL_PIPE_LISTEN/0002-kernel32-tests-Add-additional-tests-for-overlapped-h.patch
	patch_apply ntdll-FSCTL_PIPE_LISTEN/0003-ntdll-Do-not-update-iosb.Status-after-FSCTL_PIPE_LIS.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll/tests: Add tests for iosb.Status value after pending FSCTL_PIPE_LISTEN call.", 1 },';
		echo '+    { "Michael Müller", "kernel32/tests: Add additional tests for overlapped handling of CreateNamedPipe.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Do not update iosb.Status after FSCTL_PIPE_LISTEN call.", 1 },';
	) >> "$patchlist"
fi

# Patchset rpcrt4-Pipe_Transport
# |
# | Modified files:
# |   *	dlls/rpcrt4/rpc_transport.c
# |
if test "$enable_rpcrt4_Pipe_Transport" -eq 1; then
	patch_apply rpcrt4-Pipe_Transport/0001-rpcrt4-Restore-original-error-code-when-ReadFile-fai.patch
	(
		echo '+    { "Sebastian Lackner", "rpcrt4: Restore original error code when ReadFile fails with ERROR_MORE_DATA.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Desktop_Refcount
# |
# | Modified files:
# |   *	dlls/user32/tests/winstation.c, dlls/user32/winstation.c, include/winuser.h, programs/explorer/desktop.c,
# | 	server/async.c, server/atom.c, server/change.c, server/clipboard.c, server/completion.c, server/console.c,
# | 	server/debugger.c, server/device.c, server/directory.c, server/event.c, server/fd.c, server/file.c, server/handle.c,
# | 	server/handle.h, server/hook.c, server/mailslot.c, server/mapping.c, server/mutex.c, server/named_pipe.c,
# | 	server/object.c, server/object.h, server/process.c, server/queue.c, server/registry.c, server/request.c,
# | 	server/semaphore.c, server/serial.c, server/signal.c, server/snapshot.c, server/sock.c, server/symlink.c,
# | 	server/thread.c, server/timer.c, server/token.c, server/winstation.c
# |
if test "$enable_server_Desktop_Refcount" -eq 1; then
	patch_apply server-Desktop_Refcount/0001-server-Introduce-a-new-alloc_handle-object-callback..patch
	patch_apply server-Desktop_Refcount/0002-server-Track-desktop-handle-count-more-correctly.patch
	patch_apply server-Desktop_Refcount/0003-user32-Implement-CWF_CREATE_ONLY-flag-for-CreateWind.patch
	patch_apply server-Desktop_Refcount/0004-user32-tests-Add-additional-tests-for-window-station.patch
	patch_apply server-Desktop_Refcount/0005-server-Assign-random-name-when-no-name-was-passed-to.patch
	(
		echo '+    { "Sebastian Lackner", "server: Introduce a new alloc_handle object callback.", 2 },';
		echo '+    { "Sebastian Lackner", "server: Track desktop handle count more correctly.", 1 },';
		echo '+    { "Sebastian Lackner", "user32: Implement CWF_CREATE_ONLY flag for CreateWindowStation.", 1 },';
		echo '+    { "Sebastian Lackner", "user32/tests: Add additional tests for window station name.", 1 },';
		echo '+    { "Sebastian Lackner", "server: Assign random name when no name was passed to create_winstation.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Named_Pipe
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-FSCTL_PIPE_LISTEN, rpcrt4-Pipe_Transport, server-Desktop_Refcount
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#17195] Support for named pipe message mode (Linux only)
# |
# | Modified files:
# |   *	dlls/kernel32/file.c, dlls/kernel32/sync.c, dlls/kernel32/tests/pipe.c, dlls/ntdll/file.c, include/winternl.h,
# | 	server/named_pipe.c, server/protocol.def, server/sock.c, server/sock.h
# |
if test "$enable_kernel32_Named_Pipe" -eq 1; then
	patch_apply kernel32-Named_Pipe/0001-kernel32-tests-Only-allow-one-test-result.patch
	patch_apply kernel32-Named_Pipe/0002-kernel32-tests-Add-tests-for-PeekNamedPipe-with-part.patch
	patch_apply kernel32-Named_Pipe/0003-kernel32-tests-Add-tests-for-sending-and-receiving-l.patch
	patch_apply kernel32-Named_Pipe/0004-server-Show-warning-if-message-mode-is-not-supported.patch
	patch_apply kernel32-Named_Pipe/0005-ntdll-Unify-similar-code-in-NtReadFile-and-FILE_Asyn.patch
	patch_apply kernel32-Named_Pipe/0006-ntdll-Move-logic-to-check-for-broken-pipe-into-a-sep.patch
	patch_apply kernel32-Named_Pipe/0007-ntdll-Unify-similar-code-in-NtWriteFile-and-FILE_Asy.patch
	patch_apply kernel32-Named_Pipe/0008-server-Use-SOCK_SEQPACKET-socket-in-combination-with.patch
	patch_apply kernel32-Named_Pipe/0009-ntdll-Add-handling-for-partially-received-messages-i.patch
	patch_apply kernel32-Named_Pipe/0010-kernel32-tests-Add-more-tests-with-overlapped-IO-and.patch
	patch_apply kernel32-Named_Pipe/0011-ntdll-Fix-some-tests-for-overlapped-partial-reads.patch
	patch_apply kernel32-Named_Pipe/0012-kernel32-tests-Test-sending-peeking-and-receiving-an.patch
	patch_apply kernel32-Named_Pipe/0013-ntdll-Add-support-for-nonblocking-pipes.patch
	patch_apply kernel32-Named_Pipe/0014-kernel32-tests-Add-tests-for-PIPE_NOWAIT-in-message-.patch
	patch_apply kernel32-Named_Pipe/0015-ntdll-Allow-to-set-PIPE_NOWAIT-on-byte-mode-pipes.patch
	patch_apply kernel32-Named_Pipe/0016-kernel32-tests-Add-additional-tests-for-PIPE_NOWAIT-.patch
	patch_apply kernel32-Named_Pipe/0017-ntdll-Improve-ReadDataAvailable-handling-in-FilePipe.patch
	patch_apply kernel32-Named_Pipe/0018-ntdll-Set-NamedPipeState-to-FILE_PIPE_CLOSING_STATE-.patch
	patch_apply kernel32-Named_Pipe/0019-server-Return-correct-error-codes-for-NtWriteFile-wh.patch
	patch_apply kernel32-Named_Pipe/0020-ntdll-Pre-cache-file-descriptors-after-opening-a-fil.patch
	patch_apply kernel32-Named_Pipe/0021-server-Do-not-allow-to-queue-async-operation-for-bro.patch
	(
		echo '+    { "Sebastian Lackner", "kernel32/tests: Only allow one test result.", 1 },';
		echo '+    { "Sebastian Lackner", "kernel32/tests: Add tests for PeekNamedPipe with partial received messages.", 1 },';
		echo '+    { "Sebastian Lackner", "kernel32/tests: Add tests for sending and receiving large messages.", 1 },';
		echo '+    { "Sebastian Lackner", "server: Show warning if message mode is not supported.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Unify similar code in NtReadFile and FILE_AsyncReadService.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Move logic to check for broken pipe into a separate function.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Unify similar code in NtWriteFile and FILE_AsyncWriteService.", 1 },';
		echo '+    { "Sebastian Lackner", "server: Use SOCK_SEQPACKET socket in combination with SO_PEEK_OFF to implement message mode on Unix.", 6 },';
		echo '+    { "Sebastian Lackner", "ntdll: Add handling for partially received messages in NtReadFile.", 1 },';
		echo '+    { "Sebastian Lackner", "kernel32/tests: Add more tests with overlapped IO and partial reads from named pipes.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Fix some tests for overlapped partial reads.", 1 },';
		echo '+    { "Sebastian Lackner", "kernel32/tests: Test sending, peeking and receiving an empty message.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Add support for nonblocking pipes.", 1 },';
		echo '+    { "Sebastian Lackner", "kernel32/tests: Add tests for PIPE_NOWAIT in message mode.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Allow to set PIPE_NOWAIT on byte-mode pipes.", 1 },';
		echo '+    { "Sebastian Lackner", "kernel32/tests: Add additional tests for PIPE_NOWAIT in overlapped mode.", 1 },';
		echo '+    { "Qian Hong", "ntdll: Improve ReadDataAvailable handling in FilePipeLocalInformation class support.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Set NamedPipeState to FILE_PIPE_CLOSING_STATE on broken pipe in NtQueryInformationFile.", 1 },';
		echo '+    { "Sebastian Lackner", "server: Return correct error codes for NtWriteFile when pipes are closed without disconnecting.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Pre-cache file descriptors after opening a file.", 1 },';
		echo '+    { "Sebastian Lackner", "server: Do not allow to queue async operation for broken pipes.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-NeedCurrentDirectoryForExePath
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#23934] CreateProcess does not prioritize the working directory over the system search path
# |
# | Modified files:
# |   *	dlls/kernel32/path.c, dlls/kernel32/process.c, dlls/kernel32/tests/path.c
# |
if test "$enable_kernel32_NeedCurrentDirectoryForExePath" -eq 1; then
	patch_apply kernel32-NeedCurrentDirectoryForExePath/0001-kernel32-Add-SearchPath-test-demonstrating-the-prior.patch
	patch_apply kernel32-NeedCurrentDirectoryForExePath/0002-kernel32-NeedCurrentDirectoryForExePath-does-not-use.patch
	patch_apply kernel32-NeedCurrentDirectoryForExePath/0003-kernel32-Consider-the-working-directory-first-when-l.patch
	(
		echo '+    { "Erich E. Hoover", "kernel32: Add SearchPath test demonstrating the priority of the working directory.", 1 },';
		echo '+    { "Erich E. Hoover", "kernel32: NeedCurrentDirectoryForExePath does not use the registry.", 1 },';
		echo '+    { "Erich E. Hoover", "kernel32: Consider the working directory first when launching executables with CreateProcess.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Profile
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8036] Fix handling of empty section and key name for profile files.
# |   *	[#18099] Super Mario 3: Mario Forever fails to load keyboard mapping from profile files.
# |
# | Modified files:
# |   *	dlls/kernel32/profile.c, dlls/kernel32/tests/profile.c
# |
if test "$enable_kernel32_Profile" -eq 1; then
	patch_apply kernel32-Profile/0001-kernel32-Allow-empty-profile-section-and-key-name-st.patch
	(
		echo '+    { "Claudio Fontana", "kernel32: Allow empty profile section and key name strings.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-SetFileCompletionNotificationModes
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38960] Fake success in kernel32.SetFileCompletionNotificationModes
# |
# | Modified files:
# |   *	dlls/kernel32/file.c
# |
if test "$enable_kernel32_SetFileCompletionNotificationModes" -eq 1; then
	patch_apply kernel32-SetFileCompletionNotificationModes/0001-kernel32-Fake-success-in-SetFileCompletionNotificati.patch
	(
		echo '+    { "Sebastian Lackner", "kernel32: Fake success in SetFileCompletionNotificationModes.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-TimezoneInformation_Registry
# |
# | Modified files:
# |   *	dlls/kernel32/kernel_main.c, dlls/kernel32/kernel_private.h, dlls/kernel32/time.c
# |
if test "$enable_kernel32_TimezoneInformation_Registry" -eq 1; then
	patch_apply kernel32-TimezoneInformation_Registry/0001-kernel32-Init-TimezoneInformation-registry.patch
	(
		echo '+    { "Qian Hong", "kernel32: Init TimezoneInformation registry.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-VerifyVersionInfo
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#36143] Fix condition mask handling in RtlVerifyVersionInfo
# |
# | Modified files:
# |   *	dlls/kernel32/tests/version.c, dlls/ntdll/version.c
# |
if test "$enable_kernel32_VerifyVersionInfo" -eq 1; then
	patch_apply kernel32-VerifyVersionInfo/0001-kernel32-tests-Add-additional-tests-for-condition-ma.patch
	patch_apply kernel32-VerifyVersionInfo/0002-ntdll-Fix-condition-mask-handling-in-RtlVerifyVersio.patch
	(
		echo '+    { "Sebastian Lackner", "kernel32/tests: Add additional tests for condition mask of VerifyVersionInfoA.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Fix condition mask handling in RtlVerifyVersionInfo.", 1 },';
	) >> "$patchlist"
fi

# Patchset krnl386.exe16-GDT_LDT_Emulation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30237] Implement emulation of GDT and LDT access in Win98 mode
# |
# | Modified files:
# |   *	dlls/krnl386.exe16/instr.c
# |
if test "$enable_krnl386_exe16_GDT_LDT_Emulation" -eq 1; then
	patch_apply krnl386.exe16-GDT_LDT_Emulation/0001-krnl386.exe16-Emulate-mov-Eb-Gb-instruction-on-x86-p.patch
	patch_apply krnl386.exe16-GDT_LDT_Emulation/0002-krnl386.exe16-Emulate-GDT-and-LDT-access.patch
	(
		echo '+    { "Michael Müller", "krnl386.exe16: Emulate '\''mov Eb, Gb'\'' instruction on x86 processor architecture.", 1 },';
		echo '+    { "Michael Müller", "krnl386.exe16: Emulate GDT and LDT access.", 1 },';
	) >> "$patchlist"
fi

# Patchset krnl386.exe16-Invalid_Console_Handles
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#7106] Translate all invalid console handles into usable DOS handles
# |
# | Modified files:
# |   *	dlls/krnl386.exe16/file.c
# |
if test "$enable_krnl386_exe16_Invalid_Console_Handles" -eq 1; then
	patch_apply krnl386.exe16-Invalid_Console_Handles/0001-krnl386.exe16-Really-translate-all-invalid-console-h.patch
	(
		echo '+    { "Michael Müller", "krnl386.exe16: Really translate all invalid console handles into usable DOS handles.", 1 },';
	) >> "$patchlist"
fi

# Patchset krnl386.exe16-_lclose16
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#19184] Do not reassign default handles after they got closed
# |
# | Modified files:
# |   *	dlls/krnl386.exe16/file.c
# |
if test "$enable_krnl386_exe16__lclose16" -eq 1; then
	patch_apply krnl386.exe16-_lclose16/0001-krnl386.exe16-Do-not-reassign-default-handles-after-.patch
	(
		echo '+    { "Michael Müller", "krnl386.exe16: Do not reassign default handles after they got closed.", 1 },';
	) >> "$patchlist"
fi

# Patchset libs-Debug_Channel
# |
# | Modified files:
# |   *	libs/wine/debug.c
# |
if test "$enable_libs_Debug_Channel" -eq 1; then
	patch_apply libs-Debug_Channel/0001-libwine-Add-process-specific-debug-channels.patch
	(
		echo '+    { "Michael Müller", "libwine: Add process specific debug channels.", 1 },';
	) >> "$patchlist"
fi

# Patchset libs-Unicode_Collation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#10767] Fix comparison of punctuation characters in lstrcmp
# |   *	[#32490] Graphical issues in Inquisitor
# |
# | Modified files:
# |   *	dlls/kernel32/tests/locale.c, libs/wine/collation.c
# |
if test "$enable_libs_Unicode_Collation" -eq 1; then
	patch_apply libs-Unicode_Collation/0001-libs-Fix-most-problems-with-CompareString.patch
	(
		echo '+    { "Dmitry Timoshkov", "libs: Fix most problems with CompareString.", 1 },';
	) >> "$patchlist"
fi

# Patchset makedep-PARENTSPEC
# |
# | Modified files:
# |   *	tools/makedep.c
# |
if test "$enable_makedep_PARENTSPEC" -eq 1; then
	patch_apply makedep-PARENTSPEC/0001-makedep-Add-support-for-PARENTSPEC-Makefile-variable.patch
	(
		echo '+    { "Sebastian Lackner", "makedep: Add support for PARENTSPEC Makefile variable.", 1 },';
	) >> "$patchlist"
fi

# Patchset mfplat-MFTRegister
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37811] Add implementation for mfplat.MFTRegister
# |   *	[#39309] Add implementation for mfplat.MFTEnum
# |   *	[#39367] Return stub interface from mf.MFCreateMediaSession
# |
# | Modified files:
# |   *	configure.ac, dlls/mf/Makefile.in, dlls/mf/main.c, dlls/mf/mf.spec, dlls/mf/mf_private.h, dlls/mf/session.c,
# | 	dlls/mfplat/Makefile.in, dlls/mfplat/main.c, dlls/mfplat/mfplat.spec, dlls/mfplat/tests/Makefile.in,
# | 	dlls/mfplat/tests/mfplat.c, include/Makefile.in, include/mfidl.idl, include/rpcndr.h, loader/wine.inf.in
# |
if test "$enable_mfplat_MFTRegister" -eq 1; then
	patch_apply mfplat-MFTRegister/0001-mfplat-Implement-MFTRegister.patch
	patch_apply mfplat-MFTRegister/0002-mfplat-Implement-MFTUnregister.patch
	patch_apply mfplat-MFTRegister/0003-mfplat-Implement-MFTEnum.patch
	patch_apply mfplat-MFTRegister/0004-mfplat-tests-Add-tests.patch
	patch_apply mfplat-MFTRegister/0005-include-mfidl.idl-Add-IMFMediaSession-interface-and-.patch
	patch_apply mfplat-MFTRegister/0006-mf-Add-stub-for-MFCreateMediaSession.patch
	patch_apply mfplat-MFTRegister/0007-include-rpcndr.h-Fix-definition-of-EXTERN_GUID.patch
	patch_apply mfplat-MFTRegister/0008-mf-Implement-IMFMediaSession-stub-interface.patch
	patch_apply mfplat-MFTRegister/0009-mfplat-Add-stub-for-MFCreateSourceResolver.patch
	(
		echo '+    { "Michael Müller", "mfplat: Implement MFTRegister.", 2 },';
		echo '+    { "Michael Müller", "mfplat: Implement MFTUnregister.", 1 },';
		echo '+    { "Michael Müller", "mfplat: Implement MFTEnum.", 1 },';
		echo '+    { "Michael Müller", "mfplat/tests: Add tests.", 1 },';
		echo '+    { "Michael Müller", "include/mfidl.idl: Add IMFMediaSession interface and dependencies.", 1 },';
		echo '+    { "Michael Müller", "mf: Add stub for MFCreateMediaSession.", 1 },';
		echo '+    { "Michael Müller", "include/rpcndr.h: Fix definition of EXTERN_GUID.", 1 },';
		echo '+    { "Michael Müller", "mf: Implement IMFMediaSession stub interface.", 1 },';
		echo '+    { "Michael Müller", "mfplat: Add stub for MFCreateSourceResolver.", 1 },';
	) >> "$patchlist"
fi

# Patchset mmsystem.dll16-MIDIHDR_Refcount
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40024] Fix multiple issues in mmsystem.dll16 when translating MIDI messages
# |
# | Modified files:
# |   *	dlls/mmsystem.dll16/message16.c
# |
if test "$enable_mmsystem_dll16_MIDIHDR_Refcount" -eq 1; then
	patch_apply mmsystem.dll16-MIDIHDR_Refcount/0001-mmsystem.dll16-Refcount-midihdr-to-work-around-buggy.patch
	patch_apply mmsystem.dll16-MIDIHDR_Refcount/0002-mmsystem.dll16-Translate-MidiIn-messages.patch
	(
		echo '+    { "Michael Müller", "mmsystem.dll16: Refcount midihdr to work around buggy application which unprepares buffer during a callback.", 1 },';
		echo '+    { "Michael Müller", "mmsystem.dll16: Translate MidiIn messages.", 1 },';
	) >> "$patchlist"
fi

# Patchset mountmgr-DosDevices
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38235] Fix device paths in HKLM\SYSTEM\MountedDevices
# |
# | Modified files:
# |   *	dlls/mountmgr.sys/device.c, dlls/mountmgr.sys/mountmgr.c, dlls/mountmgr.sys/mountmgr.h
# |
if test "$enable_mountmgr_DosDevices" -eq 1; then
	patch_apply mountmgr-DosDevices/0001-mountmgr.sys-Write-usable-device-paths-into-HKLM-SYS.patch
	(
		echo '+    { "Michael Müller", "mountmgr.sys: Write usable device paths into HKLM\\\\SYSTEM\\\\MountedDevices.", 1 },';
	) >> "$patchlist"
fi

# Patchset mpr-WNetGetUniversalNameW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39452] Return WN_NOT_CONNECTED from WNetGetUniversalName REMOTE_NAME_INFO_LEVEL stub
# |
# | Modified files:
# |   *	dlls/mpr/tests/mpr.c, dlls/mpr/wnet.c
# |
if test "$enable_mpr_WNetGetUniversalNameW" -eq 1; then
	patch_apply mpr-WNetGetUniversalNameW/0001-mpr-Return-correct-error-code-for-non-network-paths-.patch
	(
		echo '+    { "Michael Müller", "mpr: Return correct error code for non network paths and REMOTE_NAME_INFO_LEVEL in WNetGetUniversalName.", 1 },';
	) >> "$patchlist"
fi

# Patchset mscoree-CorValidateImage
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38662] Implement mscoree._CorValidateImage for mono runtime
# |
# | Modified files:
# |   *	dlls/mscoree/mscoree_main.c
# |
if test "$enable_mscoree_CorValidateImage" -eq 1; then
	patch_apply mscoree-CorValidateImage/0001-mscoree-Implement-_CorValidateImage.patch
	(
		echo '+    { "Michael Müller", "mscoree: Implement semi-stub for _CorValidateImage.", 1 },';
	) >> "$patchlist"
fi

# Patchset mshtml-HTMLLocation_put_hash
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32967] Add IHTMLLocation::hash property's getter implementation
# |
# | Modified files:
# |   *	dlls/mshtml/htmllocation.c, dlls/mshtml/tests/htmldoc.c
# |
if test "$enable_mshtml_HTMLLocation_put_hash" -eq 1; then
	patch_apply mshtml-HTMLLocation_put_hash/0001-mshtml-Add-IHTMLLocation-hash-property-s-getter-impl.patch
	(
		echo '+    { "Zhenbo Li", "mshtml: Add IHTMLLocation::hash property'\''s getter implementation.", 1 },';
	) >> "$patchlist"
fi

# Patchset msi-Fix_Stack_Alignment
# |
# | Modified files:
# |   *	dlls/msi/custom.c
# |
if test "$enable_msi_Fix_Stack_Alignment" -eq 1; then
	patch_apply msi-Fix_Stack_Alignment/0001-msi-Fix-stack-alignment-in-CUSTOMPROC_wrapper.patch
	(
		echo '+    { "Sebastian Lackner", "msi: Fix stack alignment in CUSTOMPROC_wrapper.", 1 },';
	) >> "$patchlist"
fi

# Patchset msidb-Implementation
# |
# | Modified files:
# |   *	configure.ac, dlls/msi/database.c, dlls/msi/msipriv.h, dlls/msi/streams.c, dlls/msi/suminfo.c,
# | 	programs/msidb/Makefile.in, programs/msidb/main.c
# |
if test "$enable_msidb_Implementation" -eq 1; then
	patch_apply msidb-Implementation/0001-msidb-Add-stub-tool-for-manipulating-MSI-databases.patch
	patch_apply msidb-Implementation/0002-msi-Return-an-error-when-MsiDatabaseImport-is-passed.patch
	patch_apply msidb-Implementation/0003-msidb-Add-support-for-importing-database-tables.patch
	patch_apply msidb-Implementation/0004-msidb-Add-support-for-adding-stream-cabinet-files-to.patch
	patch_apply msidb-Implementation/0005-msi-Add-support-for-deleting-streams-from-an-MSI-dat.patch
	patch_apply msidb-Implementation/0006-msidb-Add-support-for-removing-stream-cabinet-files-.patch
	patch_apply msidb-Implementation/0007-msidb-Add-support-for-extracting-stream-cabinet-file.patch
	patch_apply msidb-Implementation/0008-msidb-Add-support-for-exporting-database-tables.patch
	patch_apply msidb-Implementation/0009-msidb-Add-support-for-exporting-with-short-DOS-filen.patch
	patch_apply msidb-Implementation/0010-msi-Add-support-for-exporting-the-_SummaryInformatio.patch
	patch_apply msidb-Implementation/0011-msi-Break-out-field-exporting-into-a-separate-routin.patch
	patch_apply msidb-Implementation/0012-msi-Add-support-for-exporting-binary-streams-Binary-.patch
	patch_apply msidb-Implementation/0013-msidb-Add-support-for-wildcard-full-database-export.patch
	(
		echo '+    { "Erich E. Hoover", "msidb: Add stub tool for manipulating MSI databases.", 1 },';
		echo '+    { "Erich E. Hoover", "msi: Return an error when MsiDatabaseImport is passed an invalid pathname.", 1 },';
		echo '+    { "Erich E. Hoover", "msidb: Add support for importing database tables.", 1 },';
		echo '+    { "Erich E. Hoover", "msidb: Add support for adding stream/cabinet files to MSI databases.", 1 },';
		echo '+    { "Erich E. Hoover", "msi: Add support for deleting streams from an MSI database.", 1 },';
		echo '+    { "Erich E. Hoover", "msidb: Add support for removing stream/cabinet files from MSI databases.", 1 },';
		echo '+    { "Erich E. Hoover", "msidb: Add support for extracting stream/cabinet files from MSI databases.", 1 },';
		echo '+    { "Erich E. Hoover", "msidb: Add support for exporting database tables.", 1 },';
		echo '+    { "Erich E. Hoover", "msidb: Add support for exporting with short (DOS) filenames.", 1 },';
		echo '+    { "Erich E. Hoover", "msi: Add support for exporting the _SummaryInformation table.", 1 },';
		echo '+    { "Erich E. Hoover", "msi: Break out field exporting into a separate routine.", 1 },';
		echo '+    { "Erich E. Hoover", "msi: Add support for exporting binary streams (Binary/Icon tables).", 1 },';
		echo '+    { "Erich E. Hoover", "msidb: Add support for wildcard (full database) export.", 1 },';
	) >> "$patchlist"
fi

# Patchset msvcr120-_SetWinRTOutOfMemoryExceptionCallback
# |
# | Modified files:
# |   *	dlls/msvcr120/msvcr120.spec, dlls/msvcr120_app/msvcr120_app.spec, dlls/msvcrt/misc.c
# |
if test "$enable_msvcr120__SetWinRTOutOfMemoryExceptionCallback" -eq 1; then
	patch_apply msvcr120-_SetWinRTOutOfMemoryExceptionCallback/0001-msvcr120-Add-stub-for-_SetWinRTOutOfMemoryExceptionC.patch
	(
		echo '+    { "Michael Müller", "msvcr120: Add stub for _SetWinRTOutOfMemoryExceptionCallback.", 1 },';
	) >> "$patchlist"
fi

# Patchset msvcrt-Math_Precision
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37149] Calculate msvcrt exponential math operations with higher precision
# |
# | Modified files:
# |   *	dlls/msvcrt/math.c
# |
if test "$enable_msvcrt_Math_Precision" -eq 1; then
	patch_apply msvcrt-Math_Precision/0001-msvcrt-Calculate-sinh-cosh-exp-pow-with-higher-preci.patch
	(
		echo '+    { "Sebastian Lackner", "msvcrt: Calculate sinh/cosh/exp/pow with higher precision.", 2 },';
	) >> "$patchlist"
fi

# Patchset msvfw32-ICGetDisplayFormat
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#23175] Fix implementation of ICGetDisplayFormat
# |   *	[#25180] Fix rendering of Clonk Endeavour's intro video
# |
# | Modified files:
# |   *	dlls/msvfw32/msvideo_main.c, dlls/msvfw32/tests/msvfw.c
# |
if test "$enable_msvfw32_ICGetDisplayFormat" -eq 1; then
	patch_apply msvfw32-ICGetDisplayFormat/0001-msvfw32-Try-different-formarts-in-ICGetDisplayFormat.patch
	patch_apply msvfw32-ICGetDisplayFormat/0002-msvfw32-Add-test-for-negative-width-height-values-pa.patch
	patch_apply msvfw32-ICGetDisplayFormat/0003-msvfw32-Set-biSizeImage-correctly-in-ICGetDisplayFor.patch
	(
		echo '+    { "Michael Müller", "msvfw32: Try different formarts in ICGetDisplayFormat.", 1 },';
		echo '+    { "Michael Müller", "msvfw32: Add test for negative width/height values passed to ICGetDisplayFormat.", 1 },';
		echo '+    { "Michael Müller", "msvfw32: Set biSizeImage correctly in ICGetDisplayFormat.", 1 },';
	) >> "$patchlist"
fi

# Patchset msvidc32-Convert_Bitness
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#14695] Implement support for converting 16 bit depth to 24 bit in msvidc32
# |
# | Modified files:
# |   *	dlls/msvfw32/tests/msvfw.c, dlls/msvidc32/msvideo1.c
# |
if test "$enable_msvidc32_Convert_Bitness" -eq 1; then
	patch_apply msvidc32-Convert_Bitness/0001-msvidc32-Add-support-for-converting-16-bit-depth-to-.patch
	(
		echo '+    { "Michael Müller", "msvidc32: Add support for converting 16 bit depth to 24 bit.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-APC_Performance
# |
# | Modified files:
# |   *	dlls/ntdll/file.c
# |
if test "$enable_ntdll_APC_Performance" -eq 1; then
	patch_apply ntdll-APC_Performance/0001-ntdll-Reuse-old-async-fileio-structures-if-possible.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Reuse old async fileio structures if possible.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-APC_Start_Process
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c
# |
if test "$enable_ntdll_APC_Start_Process" -eq 1; then
	patch_apply ntdll-APC_Start_Process/0001-ntdll-Process-APC-calls-before-starting-process.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Process APC calls before starting process.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Activation_Context
# |
# | Modified files:
# |   *	dlls/kernel32/tests/actctx.c, dlls/ntdll/actctx.c
# |
if test "$enable_ntdll_Activation_Context" -eq 1; then
	patch_apply ntdll-Activation_Context/0001-ntdll-Fix-return-value-for-missing-ACTIVATION_CONTEX.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Fix return value for missing ACTIVATION_CONTEXT_SECTION_ASSEMBLY_INFORMATION key.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-EtwRegisterTraceGuids
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33021] Move implementation of EtwEventRegister to ntdll
# |
# | Modified files:
# |   *	dlls/advapi32/advapi32.spec, dlls/advapi32/eventlog.c, dlls/ntdll/misc.c, dlls/ntdll/ntdll.spec
# |
if test "$enable_ntdll_EtwRegisterTraceGuids" -eq 1; then
	patch_apply ntdll-EtwRegisterTraceGuids/0001-ntdll-Move-EventRegister-from-advapi32-to-ntdll.patch
	patch_apply ntdll-EtwRegisterTraceGuids/0002-ntdll-Move-EventSetInformation-from-advapi32-to-ntdl.patch
	(
		echo '+    { "Michael Müller", "ntdll: Move EventRegister from advapi32 to ntdll.", 1 },';
		echo '+    { "Michael Müller", "ntdll: Move EventSetInformation from advapi32 to ntdll.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ApiSetQueryApiSetPresence
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-EtwRegisterTraceGuids
# |
# | Modified files:
# |   *	dlls/ntdll/misc.c, dlls/ntdll/ntdll.spec
# |
if test "$enable_ntdll_ApiSetQueryApiSetPresence" -eq 1; then
	patch_apply ntdll-ApiSetQueryApiSetPresence/0001-ntdll-Add-stub-for-ApiSetQueryApiSetPresence.patch
	(
		echo '+    { "Michael Müller", "ntdll: Add stub for ApiSetQueryApiSetPresence.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-CLI_Images
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	mscoree-CorValidateImage
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38661] Implement proper handling of CLI .NET images in Wine library loader
# |
# | Modified files:
# |   *	dlls/kernel32/process.c, dlls/ntdll/loader.c
# |
if test "$enable_ntdll_CLI_Images" -eq 1; then
	patch_apply ntdll-CLI_Images/0001-ntdll-Load-CLI-.NET-images-in-the-same-way-as-Window.patch
	(
		echo '+    { "Michael Müller", "ntdll: Load CLI/.NET images in the same way as Windows XP and above.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Syscall_Wrappers
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39403] Use wrapper functions for syscalls to appease Chromium sandbox (32-bit)
# |
# | Modified files:
# |   *	dlls/ntdll/atom.c, dlls/ntdll/directory.c, dlls/ntdll/env.c, dlls/ntdll/error.c, dlls/ntdll/file.c, dlls/ntdll/loader.c,
# | 	dlls/ntdll/nt.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/om.c, dlls/ntdll/process.c, dlls/ntdll/reg.c,
# | 	dlls/ntdll/resource.c, dlls/ntdll/sec.c, dlls/ntdll/server.c, dlls/ntdll/signal_arm.c, dlls/ntdll/signal_arm64.c,
# | 	dlls/ntdll/signal_i386.c, dlls/ntdll/signal_powerpc.c, dlls/ntdll/signal_x86_64.c, dlls/ntdll/sync.c,
# | 	dlls/ntdll/thread.c, dlls/ntdll/time.c, dlls/ntdll/virtual.c, tools/winegcc/winegcc.c
# |
if test "$enable_ntdll_Syscall_Wrappers" -eq 1; then
	patch_apply ntdll-Syscall_Wrappers/0001-winegcc-Pass-read_only_relocs-suppress-to-the-linker.patch
	patch_apply ntdll-Syscall_Wrappers/0002-ntdll-Use-wrapper-functions-for-syscalls.patch
	patch_apply ntdll-Syscall_Wrappers/0003-ntdll-APCs-should-call-the-implementation-instead-of.patch
	patch_apply ntdll-Syscall_Wrappers/0004-ntdll-Syscalls-should-not-call-Nt-Ex-thunk-wrappers.patch
	patch_apply ntdll-Syscall_Wrappers/0005-ntdll-Run-directory-initialization-function-early-du.patch
	(
		echo '+    { "Sebastian Lackner", "winegcc: Pass '\''-read_only_relocs suppress'\'' to the linker on OSX.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Use wrapper functions for syscalls.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: APCs should call the implementation instead of the syscall thunk.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Syscalls should not call Nt*Ex thunk wrappers.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Run directory initialization function early during the process startup.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-DOS_Attributes
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Syscall_Wrappers
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#9158] Support for DOS hidden/system file attributes
# |
# | Modified files:
# |   *	configure.ac, dlls/ntdll/directory.c, dlls/ntdll/file.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/tests/directory.c,
# | 	dlls/ntdll/tests/file.c, include/wine/port.h, libs/port/Makefile.in, libs/port/xattr.c
# |
if test "$enable_ntdll_DOS_Attributes" -eq 1; then
	patch_apply ntdll-DOS_Attributes/0001-ntdll-Implement-retrieving-DOS-attributes-in-NtQuery.patch
	patch_apply ntdll-DOS_Attributes/0002-ntdll-Implement-retrieving-DOS-attributes-in-NtQuery.patch
	patch_apply ntdll-DOS_Attributes/0003-ntdll-Implement-storing-DOS-attributes-in-NtSetInfor.patch
	patch_apply ntdll-DOS_Attributes/0004-ntdll-Implement-storing-DOS-attributes-in-NtCreateFi.patch
	patch_apply ntdll-DOS_Attributes/0005-libport-Add-support-for-Mac-OS-X-style-extended-attr.patch
	patch_apply ntdll-DOS_Attributes/0006-libport-Add-support-for-FreeBSD-style-extended-attri.patch
	patch_apply ntdll-DOS_Attributes/0007-ntdll-Perform-the-Unix-style-hidden-file-check-withi.patch
	patch_apply ntdll-DOS_Attributes/0008-ntdll-Always-store-SAMBA_XATTR_DOS_ATTRIB-when-path-.patch
	(
		echo '+    { "Erich E. Hoover", "ntdll: Implement retrieving DOS attributes in NtQueryInformationFile.", 1 },';
		echo '+    { "Erich E. Hoover", "ntdll: Implement retrieving DOS attributes in NtQuery[Full]AttributesFile and NtQueryDirectoryFile.", 1 },';
		echo '+    { "Erich E. Hoover", "ntdll: Implement storing DOS attributes in NtSetInformationFile.", 1 },';
		echo '+    { "Erich E. Hoover", "ntdll: Implement storing DOS attributes in NtCreateFile.", 1 },';
		echo '+    { "Erich E. Hoover", "libport: Add support for Mac OS X style extended attributes.", 1 },';
		echo '+    { "Erich E. Hoover", "libport: Add support for FreeBSD style extended attributes.", 1 },';
		echo '+    { "Erich E. Hoover", "ntdll: Perform the Unix-style hidden file check within the unified file info grabbing routine.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Always store SAMBA_XATTR_DOS_ATTRIB when path could be interpreted as hidden.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Dealloc_Thread_Stack
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll_misc.h, dlls/ntdll/signal_arm.c, dlls/ntdll/signal_arm64.c, dlls/ntdll/signal_i386.c,
# | 	dlls/ntdll/signal_powerpc.c, dlls/ntdll/signal_x86_64.c, dlls/ntdll/virtual.c
# |
if test "$enable_ntdll_Dealloc_Thread_Stack" -eq 1; then
	patch_apply ntdll-Dealloc_Thread_Stack/0001-ntdll-Do-not-allow-to-allocate-thread-stack-for-curr.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Do not allow to deallocate thread stack for current thread.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-DeviceType_Systemroot
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#36546] Return fake device type when systemroot is located on virtual disk
# |
# | Modified files:
# |   *	dlls/ntdll/file.c
# |
if test "$enable_ntdll_DeviceType_Systemroot" -eq 1; then
	patch_apply ntdll-DeviceType_Systemroot/0001-ntdll-Return-fake-device-type-when-systemroot-is-loc.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Return fake device type when systemroot is located on virtual disk.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-DllOverrides_WOW64
# |
# | Modified files:
# |   *	dlls/ntdll/loadorder.c
# |
if test "$enable_ntdll_DllOverrides_WOW64" -eq 1; then
	patch_apply ntdll-DllOverrides_WOW64/0001-ntdll-Always-use-64-bit-registry-view-on-WOW64-setup.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Always use 64-bit registry view on WOW64 setups.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Loader_Machine_Type
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38021] Check architecture before trying to load libraries
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c
# |
if test "$enable_ntdll_Loader_Machine_Type" -eq 1; then
	patch_apply ntdll-Loader_Machine_Type/0001-ntdll-Check-architecture-before-loading-module.patch
	(
		echo '+    { "Michael Müller", "ntdll: Check architecture before loading module.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-DllRedirects
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-DllOverrides_WOW64, ntdll-Loader_Machine_Type
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c, dlls/ntdll/loadorder.c, dlls/ntdll/ntdll_misc.h
# |
if test "$enable_ntdll_DllRedirects" -eq 1; then
	patch_apply ntdll-DllRedirects/0001-ntdll-Move-logic-to-determine-loadorder-HKCU-app-key.patch
	patch_apply ntdll-DllRedirects/0002-ntdll-Move-logic-to-read-loadorder-registry-values-i.patch
	patch_apply ntdll-DllRedirects/0003-ntdll-Move-code-to-determine-module-basename-into-se.patch
	patch_apply ntdll-DllRedirects/0004-ntdll-Implement-get_redirect-function.patch
	patch_apply ntdll-DllRedirects/0005-ntdll-Implement-loader-redirection-scheme.patch
	(
		echo '+    { "Michael Müller", "ntdll: Move logic to determine loadorder HKCU/app key into separate functions.", 1 },';
		echo '+    { "Michael Müller", "ntdll: Move logic to read loadorder registry values into separate function.", 1 },';
		echo '+    { "Michael Müller", "ntdll: Move code to determine module basename into separate function.", 1 },';
		echo '+    { "Michael Müller", "ntdll: Implement get_redirect function.", 1 },';
		echo '+    { "Michael Müller", "ntdll: Implement loader redirection scheme.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Exception
# |
# | Modified files:
# |   *	dlls/kernel32/debugger.c, dlls/ntdll/om.c, dlls/ntdll/tests/exception.c
# |
if test "$enable_ntdll_Exception" -eq 1; then
	patch_apply ntdll-Exception/0001-ntdll-Throw-exception-if-invalid-handle-is-passed-to.patch
	patch_apply ntdll-Exception/0002-ntdll-OutputDebugString-should-throw-the-exception-a.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Throw exception if invalid handle is passed to NtClose and debugger enabled.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: OutputDebugString should throw the exception a second time, if a debugger is attached.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FileFsFullSizeInformation
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_FileFsFullSizeInformation" -eq 1; then
	patch_apply ntdll-FileFsFullSizeInformation/0001-ntdll-Add-support-for-FileFsFullSizeInformation-clas.patch
	(
		echo '+    { "Jianqiu Zhang", "ntdll: Add support for FileFsFullSizeInformation class in NtQueryVolumeInformationFile.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FileFsVolumeInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#21466] Add semi-stub for FileFsVolumeInformation information class
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_FileFsVolumeInformation" -eq 1; then
	patch_apply ntdll-FileFsVolumeInformation/0001-ntdll-Add-semi-stub-for-FileFsVolumeInformation-info.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Add semi-stub for FileFsVolumeInformation information class.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FileNamesInformation
# |
# | Modified files:
# |   *	dlls/ntdll/directory.c
# |
if test "$enable_ntdll_FileNamesInformation" -eq 1; then
	patch_apply ntdll-FileNamesInformation/0001-ntdll-Implement-FileNamesInformation-class-support.patch
	(
		echo '+    { "Qian Hong", "ntdll: Implement FileNamesInformation class support.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Fix_Alignment
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33162] Ensure NtProtectVirtualMemory and NtCreateSection are on separate pages
# |
# | Modified files:
# |   *	dlls/ntdll/virtual.c
# |
if test "$enable_ntdll_Fix_Alignment" -eq 1; then
	patch_apply ntdll-Fix_Alignment/0001-ntdll-Move-NtProtectVirtualMemory-and-NtCreateSectio.patch
	(
		echo '+    { "Michael Müller", "ntdll: Move NtProtectVirtualMemory and NtCreateSection to separate pages on x86.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Fix_Free
# |
# | Modified files:
# |   *	dlls/kernel32/path.c
# |
if test "$enable_ntdll_Fix_Free" -eq 1; then
	patch_apply ntdll-Fix_Free/0001-kernel32-Fix-leaking-directory-handle-in-RemoveDirec.patch
	(
		echo '+    { "Sebastian Lackner", "kernel32: Fix leaking directory handle in RemoveDirectoryW.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FreeBSD_Directory
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35397] Use POSIX implementation to enumerate directory content on FreeBSD
# |
# | Modified files:
# |   *	dlls/ntdll/directory.c
# |
if test "$enable_ntdll_FreeBSD_Directory" -eq 1; then
	patch_apply ntdll-FreeBSD_Directory/0001-ntdll-Use-POSIX-implementation-to-enumerate-director.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Use POSIX implementation to enumerate directory content.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Heap_FreeLists
# |
# | Modified files:
# |   *	dlls/ntdll/heap.c
# |
if test "$enable_ntdll_Heap_FreeLists" -eq 1; then
	patch_apply ntdll-Heap_FreeLists/0001-ntdll-Improve-heap-allocation-performance-by-using-m.patch
	(
		echo '+    { "Steaphan Greene", "ntdll: Improve heap allocation performance by using more fine-grained free lists.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Hide_Wine_Exports
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38656] Add support for hiding wine version information from applications
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c, dlls/ntdll/ntdll_misc.h
# |
if test "$enable_ntdll_Hide_Wine_Exports" -eq 1; then
	patch_apply ntdll-Hide_Wine_Exports/0001-ntdll-Add-support-for-hiding-wine-version-informatio.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Add support for hiding wine version information from applications.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtQueryEaFile
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Syscall_Wrappers
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_NtQueryEaFile" -eq 1; then
	patch_apply ntdll-NtQueryEaFile/0001-ntdll-Improve-stub-of-NtQueryEaFile.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Improve stub of NtQueryEaFile.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Junction_Points
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Fix_Free, ntdll-Syscall_Wrappers, ntdll-NtQueryEaFile
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#12401] Support for Junction Points
# |
# | Modified files:
# |   *	dlls/kernel32/path.c, dlls/kernel32/volume.c, dlls/ntdll/file.c, dlls/ntdll/tests/file.c, include/Makefile.in,
# | 	include/ntifs.h
# |
if test "$enable_ntdll_Junction_Points" -eq 1; then
	patch_apply ntdll-Junction_Points/0001-ntdll-Add-support-for-junction-point-creation.patch
	patch_apply ntdll-Junction_Points/0002-ntdll-Add-support-for-reading-junction-points.patch
	patch_apply ntdll-Junction_Points/0003-ntdll-Add-support-for-deleting-junction-points.patch
	patch_apply ntdll-Junction_Points/0004-ntdll-Add-a-test-for-junction-point-advertisement.patch
	patch_apply ntdll-Junction_Points/0005-kernel32-ntdll-Add-support-for-deleting-junction-poi.patch
	patch_apply ntdll-Junction_Points/0006-kernel32-Advertise-junction-point-support.patch
	patch_apply ntdll-Junction_Points/0007-ntdll-tests-Add-test-for-deleting-junction-point-tar.patch
	(
		echo '+    { "Erich E. Hoover", "ntdll: Add support for junction point creation.", 1 },';
		echo '+    { "Erich E. Hoover", "ntdll: Add support for reading junction points.", 1 },';
		echo '+    { "Erich E. Hoover", "ntdll: Add support for deleting junction points.", 1 },';
		echo '+    { "Erich E. Hoover", "ntdll: Add a test for junction point advertisement.", 1 },';
		echo '+    { "Erich E. Hoover", "kernel32,ntdll: Add support for deleting junction points with RemoveDirectory.", 1 },';
		echo '+    { "Erich E. Hoover", "kernel32: Advertise junction point support.", 1 },';
		echo '+    { "Erich E. Hoover", "ntdll/tests: Add test for deleting junction point target.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtAccessCheck
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, dlls/ntdll/sec.c
# |
if test "$enable_ntdll_NtAccessCheck" -eq 1; then
	patch_apply ntdll-NtAccessCheck/0001-ntdll-Improve-invalid-paramater-handling-in-NtAccess.patch
	(
		echo '+    { "Qian Hong", "ntdll: Improve invalid paramater handling in NtAccessCheck.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtQuerySection
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Syscall_Wrappers
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37338] Support for NtQuerySection
# |
# | Modified files:
# |   *	dlls/kernel32/tests/virtual.c, dlls/ntdll/nt.c, dlls/ntdll/ntdll.spec, dlls/ntdll/virtual.c,
# | 	dlls/ntoskrnl.exe/ntoskrnl.exe.spec, server/mapping.c, server/protocol.def
# |
if test "$enable_ntdll_NtQuerySection" -eq 1; then
	patch_apply ntdll-NtQuerySection/0001-ntdll-Implement-NtQuerySection.patch
	patch_apply ntdll-NtQuerySection/0002-kernel32-tests-Add-tests-for-NtQuerySection.patch
	patch_apply ntdll-NtQuerySection/0003-server-CreateFileMapping-should-not-fail-without-SEC.patch
	patch_apply ntdll-NtQuerySection/0004-ntdll-For-section-queries-return-real-file-size.patch
	(
		echo '+    { "Dmitry Timoshkov", "ntdll: Implement NtQuerySection.", 2 },';
		echo '+    { "Dmitry Timoshkov", "kernel32/tests: Add tests for NtQuerySection.", 2 },';
		echo '+    { "Dmitry Timoshkov", "server: CreateFileMapping should not fail without SEC_COMMIT for a named file section.", 1 },';
		echo '+    { "Dmitry Timoshkov", "ntdll: For section queries return real file size.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtSetLdtEntries
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#26268] Add stub for NtSetLdtEntries/ZwSetLdtEntries
# |
# | Modified files:
# |   *	dlls/ntdll/nt.c, dlls/ntdll/ntdll.spec, include/ddk/wdm.h, include/winternl.h
# |
if test "$enable_ntdll_NtSetLdtEntries" -eq 1; then
	patch_apply ntdll-NtSetLdtEntries/0001-ntdll-add-NtSetLdtEntries-ZwSetLdtEntries-stub-try-2.patch
	(
		echo '+    { "Austin English", "ntdll: Add NtSetLdtEntries/ZwSetLdtEntries stub.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Pipe_SpecialCharacters
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#28995] Allow special characters in pipe names
# |
# | Modified files:
# |   *	dlls/kernel32/tests/pipe.c, dlls/ntdll/directory.c
# |
if test "$enable_ntdll_Pipe_SpecialCharacters" -eq 1; then
	patch_apply ntdll-Pipe_SpecialCharacters/0001-ntdll-Allow-special-characters-in-pipe-names.patch
	(
		echo '+    { "Michael Müller", "ntdll: Allow special characters in pipe names.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ProcessQuotaLimits
# |
# | Modified files:
# |   *	dlls/ntdll/process.c
# |
if test "$enable_ntdll_ProcessQuotaLimits" -eq 1; then
	patch_apply ntdll-ProcessQuotaLimits/0001-ntdll-Add-fake-data-implementation-for-ProcessQuotaL.patch
	(
		echo '+    { "Qian Hong", "ntdll: Add fake data implementation for ProcessQuotaLimits class.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Purist_Mode
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-DllOverrides_WOW64, ntdll-Loader_Machine_Type, ntdll-DllRedirects
# |
# | Modified files:
# |   *	dlls/ntdll/loadorder.c
# |
if test "$enable_ntdll_Purist_Mode" -eq 1; then
	patch_apply ntdll-Purist_Mode/0001-ntdll-Add-dll-override-default-rule-for-purist-mode.patch
	(
		echo '+    { "Christian Costa", "ntdll: Add dll override default rule for purist mode.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RtlIpStringToAddress_Stubs
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/rtl.c, dlls/ntoskrnl.exe/ntoskrnl.exe.spec
# |
if test "$enable_ntdll_RtlIpStringToAddress_Stubs" -eq 1; then
	patch_apply ntdll-RtlIpStringToAddress_Stubs/0001-ntdll-Fix-parameters-for-RtlIpv4StringToAddressExW-s.patch
	patch_apply ntdll-RtlIpStringToAddress_Stubs/0002-ntdll-Add-stub-for-RtlIpv6StringToAddressExW.patch
	(
		echo '+    { "Michael Müller", "ntdll: Fix parameters for RtlIpv4StringToAddressExW stub.", 1 },';
		echo '+    { "Michael Müller", "ntdll: Add stub for RtlIpv6StringToAddressExW.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RtlQueryPackageIdentity
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/rtl.c, dlls/ntdll/tests/Makefile.in, dlls/ntdll/tests/rtl.c, include/shobjidl.idl
# |
if test "$enable_ntdll_RtlQueryPackageIdentity" -eq 1; then
	patch_apply ntdll-RtlQueryPackageIdentity/0001-ntdll-Add-stub-for-RtlQueryPackageIdentity.patch
	patch_apply ntdll-RtlQueryPackageIdentity/0002-include-Add-IApplicationActivationManager-interface-.patch
	patch_apply ntdll-RtlQueryPackageIdentity/0003-ntdll-tests-Add-basic-tests-for-RtlQueryPackageIdent.patch
	(
		echo '+    { "Michael Müller", "ntdll: Add stub for RtlQueryPackageIdentity.", 1 },';
		echo '+    { "Michael Müller", "include: Add IApplicationActivationManager interface declaration.", 1 },';
		echo '+    { "Michael Müller", "ntdll/tests: Add basic tests for RtlQueryPackageIdentity.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RtlIpStringToAddress_Tests
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-RtlQueryPackageIdentity
# |
# | Modified files:
# |   *	dlls/ntdll/tests/rtl.c
# |
if test "$enable_ntdll_RtlIpStringToAddress_Tests" -eq 1; then
	patch_apply ntdll-RtlIpStringToAddress_Tests/0001-ntdll-tests-Tests-for-RtlIpv6StringToAddress-try-6.patch
	patch_apply ntdll-RtlIpStringToAddress_Tests/0002-ntdll-tests-Tests-for-RtlIpv6StringToAddressEx-try-6.patch
	patch_apply ntdll-RtlIpStringToAddress_Tests/0003-ntdll-tests-Tests-for-RtlIpv4StringToAddressEx-try-5.patch
	patch_apply ntdll-RtlIpStringToAddress_Tests/0004-ntdll-tests-Add-tests-for-RtlIpv6AddressToString-and.patch
	(
		echo '+    { "Mark Jansen", "ntdll/tests: Tests for RtlIpv6StringToAddress.", 6 },';
		echo '+    { "Mark Jansen", "ntdll/tests: Tests for RtlIpv6StringToAddressEx.", 6 },';
		echo '+    { "Mark Jansen", "ntdll/tests: Tests for RtlIpv4StringToAddressEx (try 5, resend).", 1 },';
		echo '+    { "Mark Jansen", "ntdll/tests: Add tests for RtlIpv6AddressToString and RtlIpv6AddressToStringEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Serial_Port_Detection
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39793] Do a device check before returning a default serial port name
# |
# | Modified files:
# |   *	dlls/ntdll/directory.c
# |
if test "$enable_ntdll_Serial_Port_Detection" -eq 1; then
	patch_apply ntdll-Serial_Port_Detection/0001-ntdll-Do-a-device-check-before-returning-a-default-s.patch
	(
		echo '+    { "Alex Henrie", "ntdll: Do a device check before returning a default serial port name.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Stack_Guard_Pages
# |
# | Modified files:
# |   *	dlls/ntdll/signal_x86_64.c
# |
if test "$enable_ntdll_Stack_Guard_Pages" -eq 1; then
	patch_apply ntdll-Stack_Guard_Pages/0001-ntdll-Handle-stack-guard-pages-on-x86_64.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Handle stack guard pages on x86_64.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Status_Mapping
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_Status_Mapping" -eq 1; then
	patch_apply ntdll-Status_Mapping/0001-ntdll-Return-STATUS_INVALID_DEVICE_REQUEST-when-tryi.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Return STATUS_INVALID_DEVICE_REQUEST when trying to call NtReadFile on directory.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-SystemInterruptInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39123] Return buffer filled with random values from SystemInterruptInformation
# |
# | Modified files:
# |   *	dlls/ntdll/nt.c
# |
if test "$enable_ntdll_SystemInterruptInformation" -eq 1; then
	patch_apply ntdll-SystemInterruptInformation/0001-ntdll-Return-buffer-filled-with-random-values-from-S.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Return buffer filled with random values from SystemInterruptInformation.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-SystemRecommendedSharedDataAlignment
# |
# | Modified files:
# |   *	include/winternl.h
# |
if test "$enable_ntdll_SystemRecommendedSharedDataAlignment" -eq 1; then
	patch_apply ntdll-SystemRecommendedSharedDataAlignment/0001-include-Add-more-constants-to-SYSTEM_INFORMATION_CLA.patch
	(
		echo '+    { "Michael Müller", "include: Add more constants to SYSTEM_INFORMATION_CLASS.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-SystemRoot_Symlink
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Exception, ntdll-Syscall_Wrappers
# |
# | Modified files:
# |   *	dlls/ntdll/om.c
# |
if test "$enable_ntdll_SystemRoot_Symlink" -eq 1; then
	patch_apply ntdll-SystemRoot_Symlink/0001-ntdll-Add-special-handling-for-SystemRoot-to-satisfy.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Add special handling for \\\\SystemRoot to satisfy MSYS2 case-insensitive system check.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ThreadTime
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#20230] Return correct values for GetThreadTimes function
# |
# | Modified files:
# |   *	dlls/ntdll/thread.c, server/protocol.def, server/thread.c
# |
if test "$enable_ntdll_ThreadTime" -eq 1; then
	patch_apply ntdll-ThreadTime/0001-ntdll-Return-correct-values-in-GetThreadTimes-for-al.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Return correct values in GetThreadTimes() for all threads.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Threading
# |
# | Modified files:
# |   *	dlls/ntdll/thread.c
# |
if test "$enable_ntdll_Threading" -eq 1; then
	patch_apply ntdll-Threading/0001-ntdll-Fix-race-condition-when-threads-are-killed-dur.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Fix race-condition when threads are killed during shutdown.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-User_Shared_Data
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/thread.c, dlls/ntoskrnl.exe/instr.c
# |
if test "$enable_ntdll_User_Shared_Data" -eq 1; then
	patch_apply ntdll-User_Shared_Data/0001-ntdll-Move-code-to-update-user-shared-data-into-a-se.patch
	patch_apply ntdll-User_Shared_Data/0002-ntoskrnl-Update-USER_SHARED_DATA-before-accessing-me.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Move code to update user shared data into a separate function.", 1 },';
		echo '+    { "Sebastian Lackner", "ntoskrnl: Update USER_SHARED_DATA before accessing memory.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-WriteWatches
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/ntdll_misc.h, dlls/ntdll/signal_i386.c, dlls/ntdll/virtual.c, dlls/ws2_32/socket.c,
# | 	include/winternl.h
# |
if test "$enable_ws2_32_WriteWatches" -eq 1; then
	patch_apply ws2_32-WriteWatches/0001-ntdll-Expose-wine_uninterrupted_-read-write-_memory-.patch
	patch_apply ws2_32-WriteWatches/0002-ws2_32-Avoid-race-conditions-of-async-WSARecv-operat.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Expose wine_uninterrupted_[read|write]_memory as exports.", 1 },';
		echo '+    { "Sebastian Lackner", "ws2_32: Avoid race-conditions of async WSARecv() operations with write watches.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-WRITECOPY
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ws2_32-WriteWatches
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29384] Voobly expects correct handling of WRITECOPY memory protection
# |   *	[#35561] MSYS2 expects correct handling of WRITECOPY memory protection
# |
# | Modified files:
# |   *	dlls/advapi32/crypt.c, dlls/advapi32/tests/security.c, dlls/kernel32/tests/virtual.c, dlls/ntdll/ntdll_misc.h,
# | 	dlls/ntdll/server.c, dlls/ntdll/signal_arm.c, dlls/ntdll/signal_arm64.c, dlls/ntdll/signal_i386.c,
# | 	dlls/ntdll/signal_powerpc.c, dlls/ntdll/signal_x86_64.c, dlls/ntdll/thread.c, dlls/ntdll/virtual.c
# |
if test "$enable_ntdll_WRITECOPY" -eq 1; then
	patch_apply ntdll-WRITECOPY/0001-ntdll-Trigger-write-watches-before-passing-userdata-.patch
	patch_apply ntdll-WRITECOPY/0002-advapi-Trigger-write-watches-before-passing-userdata.patch
	patch_apply ntdll-WRITECOPY/0003-ntdll-Setup-a-temporary-signal-handler-during-proces.patch
	patch_apply ntdll-WRITECOPY/0004-ntdll-Properly-handle-PAGE_WRITECOPY-protection.-try.patch
	patch_apply ntdll-WRITECOPY/0005-ntdll-Only-enable-true-WRITECOPY-protection-when-a-s.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Trigger write watches before passing userdata pointer to wait_reply.", 1 },';
		echo '+    { "Sebastian Lackner", "advapi: Trigger write watches before passing userdata pointer to read syscall.", 1 },';
		echo '+    { "Michael Müller", "ntdll: Setup a temporary signal handler during process startup to handle page faults.", 2 },';
		echo '+    { "Michael Müller", "ntdll: Properly handle PAGE_WRITECOPY protection.", 5 },';
		echo '+    { "Michael Müller", "ntdll: Only enable true WRITECOPY protection when a special environment variable is set.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Wait_User_APC
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#14697] Do not allow interruption of system APC in server_select
# |
# | Modified files:
# |   *	dlls/kernel32/tests/sync.c, dlls/ntdll/server.c
# |
if test "$enable_ntdll_Wait_User_APC" -eq 1; then
	patch_apply ntdll-Wait_User_APC/0001-ntdll-Block-signals-while-executing-system-APCs.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Block signals while executing system APCs.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-WinSqm
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-EtwRegisterTraceGuids
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#31971] ntdll is missing WinSqm[Start|End]Session implementation
# |
# | Modified files:
# |   *	dlls/ntdll/misc.c, dlls/ntdll/ntdll.spec, dlls/ntdll/tests/rtl.c
# |
if test "$enable_ntdll_WinSqm" -eq 1; then
	patch_apply ntdll-WinSqm/0001-ntdll-Add-stubs-for-WinSqmStartSession-WinSqmEndSess.patch
	(
		echo '+    { "Erich E. Hoover", "ntdll: Add stubs for WinSqmStartSession / WinSqmEndSession.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-WriteWatches
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-FSCTL_PIPE_LISTEN, rpcrt4-Pipe_Transport, server-Desktop_Refcount, kernel32-Named_Pipe, ws2_32-WriteWatches
# |
# | Modified files:
# |   *	dlls/kernel32/tests/virtual.c, dlls/ntdll/file.c
# |
if test "$enable_ntdll_WriteWatches" -eq 1; then
	patch_apply ntdll-WriteWatches/0001-ntdll-Avoid-race-conditions-with-write-watches-in-Nt.patch
	(
		echo '+    { "Dmitry Timoshkov", "ntdll: Avoid race-conditions with write watches in NtReadFile.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Zero_mod_name
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c
# |
if test "$enable_ntdll_Zero_mod_name" -eq 1; then
	patch_apply ntdll-Zero_mod_name/0001-ntdll-Initialize-mod_name-to-zero.patch
	(
		echo '+    { "Qian Hong", "ntdll: Initialize mod_name to zero.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-call_thread_func_wrapper
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40068] Reserve some more stack space in call_thread_func_wrapper
# |
# | Modified files:
# |   *	dlls/ntdll/signal_i386.c
# |
if test "$enable_ntdll_call_thread_func_wrapper" -eq 1; then
	patch_apply ntdll-call_thread_func_wrapper/0001-ntdll-Reserve-some-more-stack-space-in-call_thread_f.patch
	(
		echo '+    { "Dmitry Timoshkov", "ntdll: Reserve some more stack space in call_thread_func_wrapper.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntoskrnl-DriverTest
# |
# | Modified files:
# |   *	aclocal.m4, configure.ac, dlls/ntoskrnl.exe/ntoskrnl.exe.spec, dlls/ntoskrnl.exe/tests/Makefile.in,
# | 	dlls/ntoskrnl.exe/tests/driver.sys/Makefile.in, dlls/ntoskrnl.exe/tests/driver.sys/driver.c,
# | 	dlls/ntoskrnl.exe/tests/driver.sys/driver.h, dlls/ntoskrnl.exe/tests/driver.sys/driver.sys.spec,
# | 	dlls/ntoskrnl.exe/tests/driver.sys/test.c, dlls/ntoskrnl.exe/tests/driver.sys/test.h,
# | 	dlls/ntoskrnl.exe/tests/driver.sys/util.h, dlls/ntoskrnl.exe/tests/ntoskrnl.c, include/wine/test.h,
# | 	tools/make_makefiles, tools/makedep.c
# |
if test "$enable_ntoskrnl_DriverTest" -eq 1; then
	patch_apply ntoskrnl-DriverTest/0001-ntoskrnl.exe-tests-Add-initial-driver-testing-framew.patch
	patch_apply ntoskrnl-DriverTest/0002-ntoskrnl.exe-tests-Add-kernel-compliant-test-functio.patch
	(
		echo '+    { "Sebastian Lackner", "ntoskrnl.exe/tests: Add initial driver testing framework and corresponding changes to Makefile system.", 2 },';
		echo '+    { "Michael Müller", "ntoskrnl.exe/tests: Add kernel compliant test functions.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntoskrnl-Stubs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32186] Add stub for ntoskrnl.KeWaitForMultipleObjects
# |
# | Modified files:
# |   *	dlls/ntoskrnl.exe/ntoskrnl.c, dlls/ntoskrnl.exe/ntoskrnl.exe.spec, include/ddk/wdm.h
# |
if test "$enable_ntoskrnl_Stubs" -eq 1; then
	patch_apply ntoskrnl-Stubs/0001-ntoskrnl.exe-add-KeWaitForMultipleObjects-stub.patch
	patch_apply ntoskrnl-Stubs/0002-ntoskrnl.exe-Add-stub-for-IoGetAttachedDeviceReferen.patch
	patch_apply ntoskrnl-Stubs/0003-ntoskrnl.exe-Add-stubs-for-ExAcquireFastMutexUnsafe-.patch
	patch_apply ntoskrnl-Stubs/0004-ntoskrnl.exe-Add-stubs-for-ObReferenceObjectByPointe.patch
	patch_apply ntoskrnl-Stubs/0005-ntoskrnl.exe-Add-stub-for-KeDelayExecutionThread.patch
	patch_apply ntoskrnl-Stubs/0006-ntoskrnl.exe-Improve-KeReleaseMutex-stub.patch
	patch_apply ntoskrnl-Stubs/0007-ntoskrnl.exe-Improve-KeInitializeSemaphore-stub.patch
	patch_apply ntoskrnl-Stubs/0008-ntoskrnl.exe-Improve-KeInitializeTimerEx-stub.patch
	patch_apply ntoskrnl-Stubs/0009-ntoskrnl.exe-Fix-IoReleaseCancelSpinLock-argument.patch
	patch_apply ntoskrnl-Stubs/0010-ntoskrnl.exe-Implement-MmMapLockedPages-and-MmUnmapL.patch
	patch_apply ntoskrnl-Stubs/0011-ntoskrnl.exe-Implement-KeInitializeMutex.patch
	patch_apply ntoskrnl-Stubs/0012-ntoskrnl.exe-Add-stub-for-PsRemoveLoadImageNotifyRou.patch
	patch_apply ntoskrnl-Stubs/0013-ntoskrnl.exe-Add-IoGetDeviceAttachmentBaseRef-stub.patch
	(
		echo '+    { "Austin English", "ntoskrnl.exe: Add KeWaitForMultipleObjects stub.", 1 },';
		echo '+    { "Alexander Morozov", "ntoskrnl.exe: Add stub for IoGetAttachedDeviceReference.", 1 },';
		echo '+    { "Alexander Morozov", "ntoskrnl.exe: Add stubs for ExAcquireFastMutexUnsafe and ExReleaseFastMutexUnsafe.", 1 },';
		echo '+    { "Alexander Morozov", "ntoskrnl.exe: Add stubs for ObReferenceObjectByPointer and ObDereferenceObject.", 1 },';
		echo '+    { "Alexander Morozov", "ntoskrnl.exe: Add stub for KeDelayExecutionThread.", 1 },';
		echo '+    { "Alexander Morozov", "ntoskrnl.exe: Improve KeReleaseMutex stub.", 1 },';
		echo '+    { "Alexander Morozov", "ntoskrnl.exe: Improve KeInitializeSemaphore stub.", 1 },';
		echo '+    { "Alexander Morozov", "ntoskrnl.exe: Improve KeInitializeTimerEx stub.", 1 },';
		echo '+    { "Christian Costa", "ntoskrnl.exe: Fix IoReleaseCancelSpinLock argument.", 1 },';
		echo '+    { "Christian Costa", "ntoskrnl.exe: Implement MmMapLockedPages and MmUnmapLockedPages.", 1 },';
		echo '+    { "Alexander Morozov", "ntoskrnl.exe: Implement KeInitializeMutex.", 1 },';
		echo '+    { "Michael Müller", "ntoskrnl.exe: Add stub for PsRemoveLoadImageNotifyRoutine.", 1 },';
		echo '+    { "Jarkko Korpi", "ntoskrnl.exe: Add IoGetDeviceAttachmentBaseRef stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset nvcuda-CUDA_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37664] MediaCoder needs CUDA for video encoding
# |
# | Modified files:
# |   *	configure.ac, dlls/nvcuda/Makefile.in, dlls/nvcuda/internal.c, dlls/nvcuda/nvcuda.c, dlls/nvcuda/nvcuda.h,
# | 	dlls/nvcuda/nvcuda.rc, dlls/nvcuda/nvcuda.spec, dlls/nvcuda/tests/Makefile.in, dlls/nvcuda/tests/nvcuda.c,
# | 	include/Makefile.in, include/cuda.h
# |
if test "$enable_nvcuda_CUDA_Support" -eq 1; then
	patch_apply nvcuda-CUDA_Support/0001-include-Add-cuda.h.h.patch
	patch_apply nvcuda-CUDA_Support/0002-nvcuda-Add-stub-dll.patch
	patch_apply nvcuda-CUDA_Support/0003-nvcuda-First-implementation.patch
	patch_apply nvcuda-CUDA_Support/0004-nvcuda-Implement-new-functions-added-in-CUDA-6.5.patch
	patch_apply nvcuda-CUDA_Support/0005-nvcuda-Properly-wrap-undocumented-ContextStorage-int.patch
	patch_apply nvcuda-CUDA_Support/0006-nvcuda-Emulate-two-d3d9-initialization-functions.patch
	patch_apply nvcuda-CUDA_Support/0007-nvcuda-Properly-wrap-stream-callbacks-by-forwarding-.patch
	patch_apply nvcuda-CUDA_Support/0008-nvcuda-Add-support-for-CUDA-7.0.patch
	patch_apply nvcuda-CUDA_Support/0009-nvcuda-Implement-cuModuleLoad-wrapper-function.patch
	patch_apply nvcuda-CUDA_Support/0010-nvcuda-Search-for-dylib-library-on-Mac-OS-X.patch
	(
		echo '+    { "Sebastian Lackner", "include: Add cuda.h.", 1 },';
		echo '+    { "Sebastian Lackner", "nvcuda: Add stub dll.", 1 },';
		echo '+    { "Michael Müller", "nvcuda: First implementation.", 2 },';
		echo '+    { "Sebastian Lackner", "nvcuda: Implement new functions added in CUDA 6.5.", 1 },';
		echo '+    { "Michael Müller", "nvcuda: Properly wrap undocumented '\''ContextStorage'\'' interface and add tests.", 1 },';
		echo '+    { "Michael Müller", "nvcuda: Emulate two d3d9 initialization functions.", 1 },';
		echo '+    { "Sebastian Lackner", "nvcuda: Properly wrap stream callbacks by forwarding them to a worker thread.", 1 },';
		echo '+    { "Sebastian Lackner", "nvcuda: Add support for CUDA 7.0.", 1 },';
		echo '+    { "Sebastian Lackner", "nvcuda: Implement cuModuleLoad wrapper function.", 1 },';
		echo '+    { "Michael Müller", "nvcuda: Search for dylib library on Mac OS X.", 1 },';
	) >> "$patchlist"
fi

# Patchset nvapi-Stub_DLL
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	nvcuda-CUDA_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35062] Fix graphical corruption in FarCry 3 with NVIDIA drivers
# |
# | Modified files:
# |   *	configure.ac, dlls/nvapi/Makefile.in, dlls/nvapi/nvapi.c, dlls/nvapi/nvapi.spec, dlls/nvapi/tests/Makefile.in,
# | 	dlls/nvapi/tests/nvapi.c, dlls/nvapi64/Makefile.in, dlls/nvapi64/nvapi64.spec, include/Makefile.in, include/nvapi.h
# |
if test "$enable_nvapi_Stub_DLL" -eq 1; then
	patch_apply nvapi-Stub_DLL/0001-nvapi-First-implementation.patch
	patch_apply nvapi-Stub_DLL/0002-nvapi-Add-stubs-for-NvAPI_EnumLogicalGPUs-and-undocu.patch
	patch_apply nvapi-Stub_DLL/0003-nvapi-Add-NvAPI_GetPhysicalGPUsFromLogicalGPU.patch
	patch_apply nvapi-Stub_DLL/0004-nvapi-Add-stub-for-NvAPI_EnumPhysicalGPUs.patch
	patch_apply nvapi-Stub_DLL/0005-nvapi-Add-stubs-for-NvAPI_GPU_GetFullName.patch
	patch_apply nvapi-Stub_DLL/0006-nvapi-Explicity-return-NULL-for-0x33c7358c-and-0x593.patch
	patch_apply nvapi-Stub_DLL/0007-nvapi-Add-stub-for-NvAPI_DISP_GetGDIPrimaryDisplayId.patch
	patch_apply nvapi-Stub_DLL/0008-nvapi-Add-stub-for-EnumNvidiaDisplayHandle.patch
	patch_apply nvapi-Stub_DLL/0009-nvapi-Add-stub-for-NvAPI_SYS_GetDriverAndBranchVersi.patch
	patch_apply nvapi-Stub_DLL/0010-nvapi-Add-stub-for-NvAPI_Unload.patch
	patch_apply nvapi-Stub_DLL/0011-nvapi-Add-stub-for-NvAPI_D3D_GetCurrentSLIState.patch
	patch_apply nvapi-Stub_DLL/0012-nvapi-Print-fixme-message-for-NvAPI_D3D9_StretchRect.patch
	patch_apply nvapi-Stub_DLL/0013-nvapi-tests-Use-structure-to-list-imports.patch
	patch_apply nvapi-Stub_DLL/0014-nvapi-Add-stub-for-NvAPI_GetLogicalGPUFromDisplay.patch
	patch_apply nvapi-Stub_DLL/0015-nvapi-Add-stub-for-NvAPI_D3D_GetObjectHandleForResou.patch
	patch_apply nvapi-Stub_DLL/0016-nvapi-Add-stub-for-NvAPI_D3D9_RegisterResource.patch
	(
		echo '+    { "Michael Müller", "nvapi: First implementation.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Add stubs for NvAPI_EnumLogicalGPUs and undocumented equivalent.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Add NvAPI_GetPhysicalGPUsFromLogicalGPU.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Add stub for NvAPI_EnumPhysicalGPUs.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Add stubs for NvAPI_GPU_GetFullName.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Explicity return NULL for 0x33c7358c and 0x593e8644.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Add stub for NvAPI_DISP_GetGDIPrimaryDisplayId.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Add stub for EnumNvidiaDisplayHandle.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Add stub for NvAPI_SYS_GetDriverAndBranchVersion.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Add stub for NvAPI_Unload.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Add stub for NvAPI_D3D_GetCurrentSLIState.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Print fixme message for NvAPI_D3D9_StretchRectEx.", 1 },';
		echo '+    { "Michael Müller", "nvapi/tests: Use structure to list imports.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Add stub for NvAPI_GetLogicalGPUFromDisplay.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Add stub for NvAPI_D3D_GetObjectHandleForResource.", 1 },';
		echo '+    { "Michael Müller", "nvapi: Add stub for NvAPI_D3D9_RegisterResource.", 1 },';
	) >> "$patchlist"
fi

# Patchset nvcuvid-CUDA_Video_Support
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	nvcuda-CUDA_Support, nvapi-Stub_DLL
# |
# | Modified files:
# |   *	configure.ac, dlls/nvcuvid/Makefile.in, dlls/nvcuvid/nvcuvid.c, dlls/nvcuvid/nvcuvid.spec, include/Makefile.in,
# | 	include/cuviddec.h, include/nvcuvid.h
# |
if test "$enable_nvcuvid_CUDA_Video_Support" -eq 1; then
	patch_apply nvcuvid-CUDA_Video_Support/0001-nvcuvid-First-implementation.patch
	(
		echo '+    { "Michael Müller", "nvcuvid: First implementation.", 2 },';
	) >> "$patchlist"
fi

# Patchset nvencodeapi-Video_Encoder
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	nvcuda-CUDA_Support, nvapi-Stub_DLL, nvcuvid-CUDA_Video_Support
# |
# | Modified files:
# |   *	configure.ac, dlls/nvencodeapi/Makefile.in, dlls/nvencodeapi/nvencodeapi.c, dlls/nvencodeapi/nvencodeapi.spec,
# | 	dlls/nvencodeapi64/Makefile.in, dlls/nvencodeapi64/nvencodeapi64.spec, include/Makefile.in, include/nvencodeapi.h
# |
if test "$enable_nvencodeapi_Video_Encoder" -eq 1; then
	patch_apply nvencodeapi-Video_Encoder/0001-nvencodeapi-First-implementation.patch
	patch_apply nvencodeapi-Video_Encoder/0002-nvencodeapi-Add-debian-specific-paths-to-native-libr.patch
	patch_apply nvencodeapi-Video_Encoder/0003-nvencodeapi-Add-support-for-version-6.0.patch
	(
		echo '+    { "Michael Müller", "nvencodeapi: First implementation.", 1 },';
		echo '+    { "Michael Müller", "nvencodeapi: Add debian specific paths to native library.", 1 },';
		echo '+    { "Michael Müller", "nvencodeapi: Add support for version 6.0.", 1 },';
	) >> "$patchlist"
fi

# Patchset ole32-HGLOBALStream
# |
# | Modified files:
# |   *	dlls/ole32/hglobalstream.c, dlls/ole32/tests/hglobalstream.c
# |
if test "$enable_ole32_HGLOBALStream" -eq 1; then
	patch_apply ole32-HGLOBALStream/0001-ole32-tests-Add-a-bunch-of-tests-for-HGLOBAL-based-I.patch
	patch_apply ole32-HGLOBALStream/0002-ole32-Add-a-check-for-hglobal-pointer-to-GetHGlobalF.patch
	patch_apply ole32-HGLOBALStream/0003-ole32-Add-a-wrapper-for-memory-block-managed-by-HGLO.patch
	patch_apply ole32-HGLOBALStream/0004-ole32-Set-DebugInfo-Spare-0-for-handle_wrapper-lock.patch
	patch_apply ole32-HGLOBALStream/0005-ole32-Allow-moving-a-being-reallocated-block-of-memo.patch
	patch_apply ole32-HGLOBALStream/0006-ole32-Improve-thread-safety-of-HGLOBALStreamImpl_Rea.patch
	patch_apply ole32-HGLOBALStream/0007-ole32-Improve-thread-safety-of-HGLOBALStreamImpl_Wri.patch
	(
		echo '+    { "Dmitry Timoshkov", "ole32/tests: Add a bunch of tests for HGLOBAL based IStream::Clone.", 1 },';
		echo '+    { "Dmitry Timoshkov", "ole32: Add a check for hglobal pointer to GetHGlobalFromStream.", 1 },';
		echo '+    { "Dmitry Timoshkov", "ole32: Add a wrapper for memory block managed by HGLOBAL based IStream.", 1 },';
		echo '+    { "Sebastian Lackner", "ole32: Set DebugInfo->Spare[0] for handle_wrapper lock.", 1 },';
		echo '+    { "Dmitry Timoshkov", "ole32: Allow moving a being reallocated block of memory managed by HGLOBAL based IStream.", 1 },';
		echo '+    { "Sebastian Lackner", "ole32: Improve thread-safety of HGLOBALStreamImpl_Read.", 1 },';
		echo '+    { "Sebastian Lackner", "ole32: Improve thread-safety of HGLOBALStreamImpl_Write.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-CreateTypeLib
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8780] Forward CreateTypeLib to CreateTypeLib2
# |
# | Modified files:
# |   *	dlls/oleaut32/typelib.c
# |
if test "$enable_oleaut32_CreateTypeLib" -eq 1; then
	patch_apply oleaut32-CreateTypeLib/0001-oleaut32-Implement-semi-stub-for-CreateTypeLib.patch
	(
		echo '+    { "Alistair Leslie-Hughes", "oleaut32: Implement semi-stub for CreateTypeLib.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-OLEPictureImpl_SaveAsFile
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8532] Implement a better stub for IPicture::SaveAsFile
# |
# | Modified files:
# |   *	dlls/gdiplus/Makefile.in, dlls/gdiplus/gdiplus_private.h, dlls/gdiplus/graphics.c, dlls/gdiplus/image.c,
# | 	dlls/gdiplus/metafile.c, dlls/gdiplus/tests/image.c, dlls/oleaut32/olepicture.c, dlls/oleaut32/tests/olepicture.c
# |
if test "$enable_oleaut32_OLEPictureImpl_SaveAsFile" -eq 1; then
	patch_apply oleaut32-OLEPictureImpl_SaveAsFile/0001-gdiplus-Reimplement-metafile-loading-using-gdi32-ins.patch
	patch_apply oleaut32-OLEPictureImpl_SaveAsFile/0002-oleaut32-Implement-a-better-stub-for-IPicture-SaveAs.patch
	(
		echo '+    { "Dmitry Timoshkov", "gdiplus: Reimplement metafile loading using gdi32 instead of IPicture.", 2 },';
		echo '+    { "Dmitry Timoshkov", "oleaut32: Implement a better stub for IPicture::SaveAsFile.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-OleLoadPictureFile
# |
# | Modified files:
# |   *	dlls/oleaut32/olepicture.c, dlls/oleaut32/tests/olepicture.c
# |
if test "$enable_oleaut32_OleLoadPictureFile" -eq 1; then
	patch_apply oleaut32-OleLoadPictureFile/0001-oleaut32-Do-not-reimplement-OleLoadPicture-in-OleLoa.patch
	patch_apply oleaut32-OleLoadPictureFile/0002-oleaut32-Factor-out-stream-creation-from-OleLoadPict.patch
	patch_apply oleaut32-OleLoadPictureFile/0003-oleaut32-Implement-OleLoadPictureFile.patch
	(
		echo '+    { "Dmitry Timoshkov", "oleaut32: Do not reimplement OleLoadPicture in OleLoadPicturePath.", 1 },';
		echo '+    { "Dmitry Timoshkov", "oleaut32: Factor out stream creation from OleLoadPicturePath.", 1 },';
		echo '+    { "Dmitry Timoshkov", "oleaut32: Implement OleLoadPictureFile.", 2 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-TKIND_COCLASS
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#19016] Implement marshalling for TKIND_COCLASS
# |
# | Modified files:
# |   *	dlls/oleaut32/tests/tmarshal.c, dlls/oleaut32/tmarshal.c, dlls/oleaut32/typelib.c
# |
if test "$enable_oleaut32_TKIND_COCLASS" -eq 1; then
	patch_apply oleaut32-TKIND_COCLASS/0001-oleaut32-Pass-a-HREFTYPE-to-get_iface_guid.patch
	patch_apply oleaut32-TKIND_COCLASS/0002-oleaut32-Implement-ITypeInfo_fnInvoke-for-TKIND_COCL.patch
	patch_apply oleaut32-TKIND_COCLASS/0003-oleaut32-Handle-TKIND_COCLASS-in-proxy-stub-marshall.patch
	patch_apply oleaut32-TKIND_COCLASS/0004-oleaut32-tests-Add-a-test-for-TKIND_COCLASS-in-proxy.patch
	(
		echo '+    { "Sebastian Lackner", "oleaut32: Pass a HREFTYPE to get_iface_guid.", 1 },';
		echo '+    { "Sebastian Lackner", "oleaut32: Implement ITypeInfo_fnInvoke for TKIND_COCLASS in arguments.", 1 },';
		echo '+    { "Sebastian Lackner", "oleaut32: Handle TKIND_COCLASS in proxy/stub marshalling.", 1 },';
		echo '+    { "Sebastian Lackner", "oleaut32/tests: Add a test for TKIND_COCLASS in proxy/stub marshalling.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-x86_64_Marshaller
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#26768] Implement stubless proxies on x86_64
# |
# | Modified files:
# |   *	dlls/oleaut32/tmarshal.c, dlls/oleaut32/typelib.c, dlls/oleaut32/typelib.h
# |
if test "$enable_oleaut32_x86_64_Marshaller" -eq 1; then
	patch_apply oleaut32-x86_64_Marshaller/0001-oleaut32-Initial-preparation-to-make-marshalling-com.patch
	patch_apply oleaut32-x86_64_Marshaller/0002-oleaut32-Implement-TMStubImpl_Invoke-on-x86_64.patch
	patch_apply oleaut32-x86_64_Marshaller/0003-oleaut32-Implement-asm-proxys-for-x86_64.patch
	(
		echo '+    { "Sebastian Lackner", "oleaut32: Initial preparation to make marshalling compatible with x86_64.", 1 },';
		echo '+    { "Sebastian Lackner", "oleaut32: Implement TMStubImpl_Invoke on x86_64.", 1 },';
		echo '+    { "Sebastian Lackner", "oleaut32: Implement asm proxys for x86_64.", 1 },';
	) >> "$patchlist"
fi

# Patchset openal32-EFX_Extension
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38972] Export additional OpenAL32 functions
# |
# | Modified files:
# |   *	dlls/openal32/openal.c, dlls/openal32/openal32.spec
# |
if test "$enable_openal32_EFX_Extension" -eq 1; then
	patch_apply openal32-EFX_Extension/0001-openal32-Export-EFX-extension-functions.patch
	(
		echo '+    { "Michael Müller", "openal32: Export EFX extension functions.", 1 },';
	) >> "$patchlist"
fi

# Patchset opengl32-Revert_Disable_Ext
# |
# | Modified files:
# |   *	dlls/opengl32/wgl.c
# |
if test "$enable_opengl32_Revert_Disable_Ext" -eq 1; then
	patch_apply opengl32-Revert_Disable_Ext/0001-Revert-opengl32-Return-a-NULL-pointer-for-functions-.patch
	(
		echo '+    { "Sebastian Lackner", "Revert \"opengl32: Return a NULL pointer for functions requiring unsupported or disabled extensions.\".", 1 },';
	) >> "$patchlist"
fi

# Patchset opengl32-glDebugMessageCallback
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38402] Fix calling convention of glDebugMessageCallback callback function
# |
# | Modified files:
# |   *	dlls/opengl32/make_opengl, dlls/opengl32/opengl_ext.c, dlls/opengl32/opengl_ext.h, dlls/opengl32/tests/opengl.c,
# | 	dlls/opengl32/wgl.c
# |
if test "$enable_opengl32_glDebugMessageCallback" -eq 1; then
	patch_apply opengl32-glDebugMessageCallback/0001-opengl32-tests-Include-wgl.h-and-remove-duplicate-de.patch
	patch_apply opengl32-glDebugMessageCallback/0002-opengl32-Add-wrappers-for-glDebugMessageCallback-to-.patch
	(
		echo '+    { "Sebastian Lackner", "opengl32/tests: Include wgl.h and remove duplicate declarations.", 1 },';
		echo '+    { "Sebastian Lackner", "opengl32: Add wrappers for glDebugMessageCallback to handle calling convention differences.", 1 },';
	) >> "$patchlist"
fi

# Patchset quartz-AsyncReader
# |
# | Modified files:
# |   *	dlls/quartz/filesource.c, dlls/quartz/regsvr.c
# |
if test "$enable_quartz_AsyncReader" -eq 1; then
	patch_apply quartz-AsyncReader/0001-quartz-AsyncReader-should-return-NULL-as-media-subty.patch
	patch_apply quartz-AsyncReader/0002-quartz-Recognize-mpeg2-program-streams.patch
	(
		echo '+    { "Michael Müller", "quartz: AsyncReader should return NULL as media subtype for unknown formats instead of failing.", 1 },';
		echo '+    { "Michael Müller", "quartz: Recognize mpeg2 program streams.", 1 },';
	) >> "$patchlist"
fi

# Patchset quartz-MediaSeeking_Positions
# |
# | Modified files:
# |   *	dlls/quartz/filtergraph.c, dlls/strmbase/pospass.c
# |
if test "$enable_quartz_MediaSeeking_Positions" -eq 1; then
	patch_apply quartz-MediaSeeking_Positions/0001-strmbase-Fix-MediaSeekingPassThru_GetPositions-retur.patch
	patch_apply quartz-MediaSeeking_Positions/0002-quartz-Include-the-stream-position-in-addition-to-th.patch
	patch_apply quartz-MediaSeeking_Positions/0003-quartz-Implement-MediaSeeking_GetCurrentPosition-on-.patch
	patch_apply quartz-MediaSeeking_Positions/0004-quartz-Implement-MediaSeeking_GetStopPosition-on-top.patch
	patch_apply quartz-MediaSeeking_Positions/0005-quartz-Remove-unused-cache-of-MediaSeeking-stop-posi.patch
	(
		echo '+    { "Erich E. Hoover", "strmbase: Fix MediaSeekingPassThru_GetPositions return when the pins are unconnected.", 1 },';
		echo '+    { "Erich E. Hoover", "quartz: Include the stream position in addition to the reference clock offset in the time returned by MediaSeeking_GetPositions.", 1 },';
		echo '+    { "Erich E. Hoover", "quartz: Implement MediaSeeking_GetCurrentPosition on top of MediaSeeking_GetPositions.", 1 },';
		echo '+    { "Erich E. Hoover", "quartz: Implement MediaSeeking_GetStopPosition on top of MediaSeeking_GetPositions.", 1 },';
		echo '+    { "Erich E. Hoover", "quartz: Remove unused cache of MediaSeeking stop position.", 1 },';
	) >> "$patchlist"
fi

# Patchset quartz-Silence_FIXMEs
# |
# | Modified files:
# |   *	dlls/quartz/parser.c
# |
if test "$enable_quartz_Silence_FIXMEs" -eq 1; then
	patch_apply quartz-Silence_FIXMEs/0001-quartz-Don-t-print-FIXME-for-IAMFilterMiscFlags-in-p.patch
	(
		echo '+    { "Christian Costa", "quartz: Don'\''t print FIXME for IAMFilterMiscFlags in parsers.", 1 },';
	) >> "$patchlist"
fi

# Patchset rasapi32-RasEnumDevicesA
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30378] Initialize *lpcDevices in RasEnumDevicesA
# |
# | Modified files:
# |   *	dlls/rasapi32/rasapi.c, dlls/rasapi32/tests/rasapi.c
# |
if test "$enable_rasapi32_RasEnumDevicesA" -eq 1; then
	patch_apply rasapi32-RasEnumDevicesA/0001-rasapi32-Set-lpcDevices-in-RasEnumDevicesA.patch
	(
		echo '+    { "Sebastian Lackner", "rasapi32: Set *lpcDevices in RasEnumDevicesA.", 1 },';
	) >> "$patchlist"
fi

# Patchset reg-Implement_Query
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24017] Implement query operation in reg.exe
# |
# | Modified files:
# |   *	programs/reg/reg.c
# |
if test "$enable_reg_Implement_Query" -eq 1; then
	patch_apply reg-Implement_Query/0001-reg-Query-all-values-and-subkeys-in-a-specified-key.patch
	patch_apply reg-Implement_Query/0002-reg-Add-support-for-querying-the-registry-with-the-v.patch
	(
		echo '+    { "Hugh McMaster", "reg: Query all values and subkeys in a specified key.", 2 },';
		echo '+    { "Hugh McMaster", "reg: Add support for querying the registry with the /v and /ve switches.", 2 },';
	) >> "$patchlist"
fi

# Patchset riched20-IText_Interface
# |
# | Modified files:
# |   *	dlls/riched20/richole.c, dlls/riched20/run.c, dlls/riched20/tests/richole.c
# |
if test "$enable_riched20_IText_Interface" -eq 1; then
	patch_apply riched20-IText_Interface/0001-riched20-Implement-IText-Selection-Range-Set-Start-E.patch
	patch_apply riched20-IText_Interface/0002-riched20-Stub-for-ITextFont-interface-and-implement-.patch
	patch_apply riched20-IText_Interface/0003-riched20-Stub-for-ITextPara-interface-and-implement-.patch
	patch_apply riched20-IText_Interface/0004-riched20-Fix-ME_RunOfsFromCharOfs-when-nCharOfs-strl.patch
	patch_apply riched20-IText_Interface/0005-riched20-Implement-ITextRange-GetText.patch
	patch_apply riched20-IText_Interface/0006-riched20-Implement-ITextRange-SetRange.patch
	patch_apply riched20-IText_Interface/0007-riched20-Implement-ITextRange-IsEqual.patch
	patch_apply riched20-IText_Interface/0008-riched20-Implement-ITextRange-GetStoryLength.patch
	patch_apply riched20-IText_Interface/0009-riched20-Implement-ITextSelection-GetStoryLength.patch
	patch_apply riched20-IText_Interface/0010-riched20-Silence-repeated-FIXMEs-triggered-by-Adobe-.patch
	(
		echo '+    { "Jactry Zeng", "riched20: Implement IText{Selection, Range}::Set{Start, End}.", 1 },';
		echo '+    { "Jactry Zeng", "riched20: Stub for ITextFont interface and implement ITextRange::GetFont and ITextSelection::GetFont.", 1 },';
		echo '+    { "Jactry Zeng", "riched20: Stub for ITextPara interface and implement ITextRange::GetPara.", 1 },';
		echo '+    { "Jactry Zeng", "riched20: Fix ME_RunOfsFromCharOfs() when nCharOfs > strlen().", 1 },';
		echo '+    { "Jactry Zeng", "riched20: Implement ITextRange::GetText.", 1 },';
		echo '+    { "Jactry Zeng", "riched20: Implement ITextRange::SetRange.", 1 },';
		echo '+    { "Jactry Zeng", "riched20: Implement ITextRange::IsEqual.", 1 },';
		echo '+    { "Jactry Zeng", "riched20: Implement ITextRange::GetStoryLength.", 1 },';
		echo '+    { "Jactry Zeng", "riched20: Implement ITextSelection::GetStoryLength.", 1 },';
		echo '+    { "Sebastian Lackner", "riched20: Silence repeated FIXMEs triggered by Adobe Reader.", 1 },';
	) >> "$patchlist"
fi

# Patchset rpcrt4-RpcBindingServerFromClient
# |
# | Modified files:
# |   *	dlls/rpcrt4/rpc_binding.c
# |
if test "$enable_rpcrt4_RpcBindingServerFromClient" -eq 1; then
	patch_apply rpcrt4-RpcBindingServerFromClient/0001-rpcrt4-Fix-prototype-of-RpcBindingServerFromClient.patch
	(
		echo '+    { "Sebastian Lackner", "rpcrt4: Fix prototype of RpcBindingServerFromClient.", 1 },';
	) >> "$patchlist"
fi

# Patchset secur32-ANSI_NTLM_Credentials
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37063] Fix handling of ANSI NTLM credentials
# |
# | Modified files:
# |   *	dlls/secur32/ntlm.c
# |
if test "$enable_secur32_ANSI_NTLM_Credentials" -eq 1; then
	patch_apply secur32-ANSI_NTLM_Credentials/0001-secur32-Fix-handling-of-ANSI-NTLM-credentials.patch
	(
		echo '+    { "David Woodhouse", "secur32: Fix handling of ANSI NTLM credentials.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-ClipCursor
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38087] Fix multithreading issues with fullscreen clipping
# |
# | Modified files:
# |   *	dlls/winex11.drv/mouse.c
# |
if test "$enable_server_ClipCursor" -eq 1; then
	patch_apply server-ClipCursor/0001-winex11-Forward-all-clipping-requests-to-the-right-t.patch
	(
		echo '+    { "Sebastian Lackner", "winex11: Forward all clipping requests to the right thread (including fullscreen clipping).", 1 },';
	) >> "$patchlist"
fi

# Patchset server-FileEndOfFileInformation
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, server/fd.c, server/protocol.def
# |
if test "$enable_server_FileEndOfFileInformation" -eq 1; then
	patch_apply server-FileEndOfFileInformation/0001-ntdll-Set-EOF-on-file-which-has-a-memory-mapping-sho.patch
	patch_apply server-FileEndOfFileInformation/0002-server-Growing-files-which-are-mapped-to-memory-shou.patch
	(
		echo '+    { "Qian Hong", "ntdll: Set EOF on file which has a memory mapping should fail.", 1 },';
		echo '+    { "Sebastian Lackner", "server: Growing files which are mapped to memory should still work.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Stored_ACLs
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Syscall_Wrappers, ntdll-DOS_Attributes, server-File_Permissions
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33576] Support for stored file ACLs
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, include/wine/port.h, server/change.c, server/file.c, server/file.h, server/object.c,
# | 	server/object.h
# |
if test "$enable_server_Stored_ACLs" -eq 1; then
	patch_apply server-Stored_ACLs/0001-server-Unify-the-storage-of-security-attributes-for-.patch
	patch_apply server-Stored_ACLs/0002-server-Unify-the-retrieval-of-security-attributes-fo.patch
	patch_apply server-Stored_ACLs/0003-server-Add-a-helper-function-set_sd_from_token_inter.patch
	patch_apply server-Stored_ACLs/0004-server-Temporarily-store-the-full-security-descripto.patch
	patch_apply server-Stored_ACLs/0005-server-Store-file-security-attributes-with-extended-.patch
	patch_apply server-Stored_ACLs/0006-server-Convert-return-of-file-security-masks-with-ge.patch
	patch_apply server-Stored_ACLs/0007-server-Retrieve-file-security-attributes-with-extend.patch
	(
		echo '+    { "Erich E. Hoover", "server: Unify the storage of security attributes for files and directories.", 7 },';
		echo '+    { "Erich E. Hoover", "server: Unify the retrieval of security attributes for files and directories.", 7 },';
		echo '+    { "Sebastian Lackner", "server: Add a helper function set_sd_from_token_internal to merge two security descriptors.", 1 },';
		echo '+    { "Sebastian Lackner", "server: Temporarily store the full security descriptor for file objects.", 1 },';
		echo '+    { "Erich E. Hoover", "server: Store file security attributes with extended file attributes.", 8 },';
		echo '+    { "Erich E. Hoover", "server: Convert return of file security masks with generic access mappings.", 7 },';
		echo '+    { "Erich E. Hoover", "server: Retrieve file security attributes with extended file attributes.", 7 },';
	) >> "$patchlist"
fi

# Patchset server-Inherited_ACLs
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Syscall_Wrappers, ntdll-DOS_Attributes, server-File_Permissions, server-Stored_ACLs
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, server/file.c
# |
if test "$enable_server_Inherited_ACLs" -eq 1; then
	patch_apply server-Inherited_ACLs/0001-server-Inherit-security-attributes-from-parent-direc.patch
	(
		echo '+    { "Erich E. Hoover", "server: Inherit security attributes from parent directories on creation.", 7 },';
	) >> "$patchlist"
fi

# Patchset server-Key_State
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#31899] Implement locking and synchronization of key states
# |   *	[#35907] Fix caps lock state issues with multiple processes
# |
# | Modified files:
# |   *	server/queue.c
# |
if test "$enable_server_Key_State" -eq 1; then
	patch_apply server-Key_State/0001-server-Introduce-a-helper-function-to-update-the-thr.patch
	patch_apply server-Key_State/0002-server-Implement-locking-and-synchronization-of-keys.patch
	(
		echo '+    { "Sebastian Lackner", "server: Introduce a helper function to update the thread_input key state.", 1 },';
		echo '+    { "Sebastian Lackner", "server: Implement locking and synchronization of keystate buffer.", 3 },';
	) >> "$patchlist"
fi

# Patchset server-Map_EXDEV_Error
# |
# | Modified files:
# |   *	server/file.c
# |
if test "$enable_server_Map_EXDEV_Error" -eq 1; then
	patch_apply server-Map_EXDEV_Error/0001-server-Map-EXDEV-to-STATUS_NOT_SAME_DEVICE.patch
	(
		echo '+    { "Qian Hong", "server: Map EXDEV to STATUS_NOT_SAME_DEVICE.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Parent_Process
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37087] Do not hold reference on parent process in wineserver
# |
# | Modified files:
# |   *	dlls/kernel32/tests/process.c, server/console.c, server/process.c, server/process.h, server/snapshot.c, server/thread.c
# |
if test "$enable_server_Parent_Process" -eq 1; then
	patch_apply server-Parent_Process/0001-server-Increase-size-of-PID-table-to-512-to-reduce-r.patch
	patch_apply server-Parent_Process/0002-server-Do-not-hold-reference-on-parent-process.patch
	(
		echo '+    { "Sebastian Lackner", "server: Increase size of PID table to 512 to reduce risk of collisions.", 1 },';
		echo '+    { "Sebastian Lackner", "server: Do not hold reference on parent process.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-PeekMessage
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#28884] GetMessage should remove already seen messages with higher priority
# |
# | Modified files:
# |   *	dlls/user32/tests/msg.c, server/queue.c
# |
if test "$enable_server_PeekMessage" -eq 1; then
	patch_apply server-PeekMessage/0001-server-Fix-handling-of-GetMessage-after-previous-Pee.patch
	(
		echo '+    { "Sebastian Lackner", "server: Fix handling of GetMessage after previous PeekMessage call.", 2 },';
	) >> "$patchlist"
fi

# Patchset server-Pipe_ObjectName
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-FSCTL_PIPE_LISTEN, rpcrt4-Pipe_Transport, server-Desktop_Refcount, kernel32-Named_Pipe
# |
# | Modified files:
# |   *	dlls/ntdll/tests/om.c, server/named_pipe.c, server/object.c, server/object.h
# |
if test "$enable_server_Pipe_ObjectName" -eq 1; then
	patch_apply server-Pipe_ObjectName/0001-server-Store-a-reference-to-the-parent-object-for-pi.patch
	(
		echo '+    { "Sebastian Lackner", "server: Store a reference to the parent object for pipe servers.", 2 },';
	) >> "$patchlist"
fi

# Patchset server-Realtime_Priority
# |
# | Modified files:
# |   *	server/Makefile.in, server/main.c, server/scheduler.c, server/thread.c, server/thread.h
# |
if test "$enable_server_Realtime_Priority" -eq 1; then
	patch_apply server-Realtime_Priority/0001-wineserver-Draft-to-implement-priority-levels-throug.patch
	(
		echo '+    { "Joakim Hernberg", "wineserver: Draft to implement priority levels through POSIX scheduling policies on linux.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Registry_Notifications
# |
# | Modified files:
# |   *	dlls/ntdll/tests/reg.c, server/registry.c
# |
if test "$enable_server_Registry_Notifications" -eq 1; then
	patch_apply server-Registry_Notifications/0001-server-Allow-multiple-registry-notifications-for-the.patch
	patch_apply server-Registry_Notifications/0002-server-Introduce-refcounting-for-registry-notificati.patch
	(
		echo '+    { "Sebastian Lackner", "server: Allow multiple registry notifications for the same key.", 1 },';
		echo '+    { "Sebastian Lackner", "server: Introduce refcounting for registry notifications.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Signal_Thread
# |
# | Modified files:
# |   *	server/thread.c, server/thread.h
# |
if test "$enable_server_Signal_Thread" -eq 1; then
	patch_apply server-Signal_Thread/0001-server-Do-not-signal-thread-until-it-is-really-gone.patch
	(
		echo '+    { "Sebastian Lackner", "server: Do not signal thread until it is really gone.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Shared_Memory
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Threading, server-ClipCursor, server-Key_State, server-PeekMessage, server-Signal_Thread
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll_misc.h, dlls/ntdll/server.c, dlls/ntdll/thread.c, dlls/ntdll/virtual.c, dlls/user32/focus.c,
# | 	dlls/user32/input.c, dlls/user32/message.c, dlls/user32/user_private.h, include/wine/server.h, include/winternl.h,
# | 	server/fd.c, server/file.h, server/main.c, server/mapping.c, server/protocol.def, server/queue.c, server/thread.c,
# | 	server/thread.h
# |
if test "$enable_server_Shared_Memory" -eq 1; then
	patch_apply server-Shared_Memory/0001-ntdll-Implement-virtual_map_shared_memory.patch
	patch_apply server-Shared_Memory/0002-server-Implement-support-for-global-and-local-shared.patch
	patch_apply server-Shared_Memory/0003-user32-Get-rid-of-wineserver-call-for-GetInputState.patch
	patch_apply server-Shared_Memory/0004-user32-Avoid-unnecessary-wineserver-calls-in-PeekMes.patch
	patch_apply server-Shared_Memory/0005-user32-Get-rid-of-wineserver-call-for-GetLastInputIn.patch
	patch_apply server-Shared_Memory/0006-ntdll-Only-enable-wineserver-shared-memory-communica.patch
	patch_apply server-Shared_Memory/0007-server-Store-a-list-of-associated-queues-for-each-th.patch
	patch_apply server-Shared_Memory/0008-user32-Get-rid-of-wineserver-call-for-GetActiveWindo.patch
	patch_apply server-Shared_Memory/0009-user32-Cache-the-result-of-GetForegroundWindow.patch
	(
		echo '+    { "Sebastian Lackner", "ntdll: Implement virtual_map_shared_memory.", 1 },';
		echo '+    { "Michael Müller", "server: Implement support for global and local shared memory blocks based on memfd.", 1 },';
		echo '+    { "Sebastian Lackner", "user32: Get rid of wineserver call for GetInputState.", 1 },';
		echo '+    { "Sebastian Lackner", "user32: Avoid unnecessary wineserver calls in PeekMessage/GetMessage.", 1 },';
		echo '+    { "Michael Müller", "user32: Get rid of wineserver call for GetLastInputInfo.", 1 },';
		echo '+    { "Sebastian Lackner", "ntdll: Only enable wineserver shared memory communication when a special environment variable is set.", 1 },';
		echo '+    { "Sebastian Lackner", "server: Store a list of associated queues for each thread input.", 1 },';
		echo '+    { "Sebastian Lackner", "user32: Get rid of wineserver call for GetActiveWindow, GetFocus, GetCapture.", 1 },';
		echo '+    { "Sebastian Lackner", "user32: Cache the result of GetForegroundWindow.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Timestamp_Compat
# |
# | Modified files:
# |   *	server/registry.c
# |
if test "$enable_server_Timestamp_Compat" -eq 1; then
	patch_apply server-Timestamp_Compat/0001-server-Compatibility-with-Wine-Staging-format-for-hi.patch
	(
		echo '+    { "Michael Müller", "server: Compatibility with Wine Staging format for high precision registry timestamps.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-DelReg
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#13548] setupapi DelReg should recursively delete registry keys
# |
# | Modified files:
# |   *	dlls/setupapi/install.c, dlls/setupapi/tests/install.c
# |
if test "$enable_setupapi_DelReg" -eq 1; then
	patch_apply setupapi-DelReg/0001-setupapi-DelReg-should-recursively-delete-registry-k.patch
	(
		echo '+    { "Sebastian Lackner", "setupapi: DelReg should recursively delete registry keys.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-DiskSpaceList
# |
# | Modified files:
# |   *	dlls/setupapi/diskspace.c, dlls/setupapi/queue.c, dlls/setupapi/setupapi.spec, dlls/setupapi/setupapi_private.h,
# | 	dlls/setupapi/stubs.c, dlls/setupapi/tests/diskspace.c, include/setupapi.h
# |
if test "$enable_setupapi_DiskSpaceList" -eq 1; then
	patch_apply setupapi-DiskSpaceList/0001-setupapi-Rewrite-DiskSpaceList-logic-using-lists.patch
	patch_apply setupapi-DiskSpaceList/0002-setupapi-Implement-SetupAddToDiskSpaceList.patch
	patch_apply setupapi-DiskSpaceList/0003-setupapi-Implement-SetupQueryDrivesInDiskSpaceList.patch
	patch_apply setupapi-DiskSpaceList/0004-setupapi-Ignore-deletion-of-added-files-in-SetupAddT.patch
	patch_apply setupapi-DiskSpaceList/0005-setupapi-ImplementSetupAddSectionToDiskSpaceList.patch
	patch_apply setupapi-DiskSpaceList/0006-setupapi-Implement-SetupAddInstallSectionToDiskSpace.patch
	(
		echo '+    { "Michael Müller", "setupapi: Rewrite DiskSpaceList logic using lists.", 1 },';
		echo '+    { "Michael Müller", "setupapi: Implement SetupAddToDiskSpaceList.", 1 },';
		echo '+    { "Michael Müller", "setupapi: Implement SetupQueryDrivesInDiskSpaceList.", 1 },';
		echo '+    { "Michael Müller", "setupapi: Ignore deletion of added files in SetupAddToDiskSpaceList.", 1 },';
		echo '+    { "Michael Müller", "setupapi: ImplementSetupAddSectionToDiskSpaceList.", 1 },';
		echo '+    { "Michael Müller", "setupapi: Implement SetupAddInstallSectionToDiskSpaceList.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-Display_Device
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35345] Fix enumeration of display driver properties using setupapi
# |
# | Modified files:
# |   *	dlls/setupapi/devinst.c, dlls/setupapi/tests/devinst.c, loader/wine.inf.in
# |
if test "$enable_setupapi_Display_Device" -eq 1; then
	patch_apply setupapi-Display_Device/0001-setupapi-Create-registry-keys-for-display-devices-an.patch
	patch_apply setupapi-Display_Device/0002-setupapi-Handle-the-case-that-a-full-driver-path-is-.patch
	(
		echo '+    { "Michael Müller", "setupapi: Create registry keys for display devices and display drivers.", 1 },';
		echo '+    { "Michael Müller", "setupapi: Handle the case that a full driver path is passed to SetupDiGetClassDevs.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-HSPFILEQ_Check_Type
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#12332] Check handle type for HSPFILEQ handles
# |
# | Modified files:
# |   *	dlls/setupapi/queue.c
# |
if test "$enable_setupapi_HSPFILEQ_Check_Type" -eq 1; then
	patch_apply setupapi-HSPFILEQ_Check_Type/0001-setupapi-Check-handle-type-for-HSPFILEQ-handles.patch
	(
		echo '+    { "Michael Müller", "setupapi: Check handle type for HSPFILEQ handles.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-SetupPromptForDisk
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#20465] Wine ignores IDF_CHECKFIRST flag in SetupPromptForDisk
# |
# | Modified files:
# |   *	dlls/setupapi/dialog.c, dlls/setupapi/tests/Makefile.in, dlls/setupapi/tests/dialog.c
# |
if test "$enable_setupapi_SetupPromptForDisk" -eq 1; then
	patch_apply setupapi-SetupPromptForDisk/0001-setupapi-Add-support-for-IDF_CHECKFIRST-flag-in-Setu.patch
	patch_apply setupapi-SetupPromptForDisk/0002-setupapi-tests-Add-test-for-IDF_CHECKFIRST-and-Setup.patch
	(
		echo '+    { "Michael Müller", "setupapi: Add support for IDF_CHECKFIRST flag in SetupPromptForDiskW.", 1 },';
		echo '+    { "Michael Müller", "setupapi/tests: Add test for IDF_CHECKFIRST and SetupPromptForDiskA/W.", 1 },';
	) >> "$patchlist"
fi

# Patchset sfc-SfcGetNextProtectedFile
# |
# | Modified files:
# |   *	dlls/sfc_os/sfc_os.c
# |
if test "$enable_sfc_SfcGetNextProtectedFile" -eq 1; then
	patch_apply sfc-SfcGetNextProtectedFile/0001-sfc_os-Set-an-error-code-in-SfcGetNextProtectedFile-.patch
	(
		echo '+    { "Michael Müller", "sfc_os: Set an error code in SfcGetNextProtectedFile stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset shdocvw-ParseURLFromOutsideSource_Tests
# |
# | Modified files:
# |   *	dlls/shdocvw/shdocvw_main.c, dlls/shdocvw/tests/shdocvw.c
# |
if test "$enable_shdocvw_ParseURLFromOutsideSource_Tests" -eq 1; then
	patch_apply shdocvw-ParseURLFromOutsideSource_Tests/0001-shdocvw-Check-precisely-ParseURLFromOutsideSourceX-r.patch
	(
		echo '+    { "Christian Costa", "shdocvw: Check precisely ParseURLFromOutsideSourceX returned values in tests and make code clearer about that.", 3 },';
	) >> "$patchlist"
fi

# Patchset shell32-Context_Menu
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34319] Add support for Paste in context menu
# |   *	[#34322] Fix implementation of Cut file operation
# |   *	[#34321] Fix Cut/Copy/Paste keyboard shortcuts in Total Commander
# |
# | Modified files:
# |   *	dlls/shell32/clipboard.c, dlls/shell32/dataobject.c, dlls/shell32/recyclebin.c, dlls/shell32/shell32.rc,
# | 	dlls/shell32/shell32_main.h, dlls/shell32/shellfolder.h, dlls/shell32/shfldr_fs.c, dlls/shell32/shfldr_unixfs.c,
# | 	dlls/shell32/shlview.c, dlls/shell32/shlview_cmenu.c
# |
if test "$enable_shell32_Context_Menu" -eq 1; then
	patch_apply shell32-Context_Menu/0001-shell32-Fix-copying-of-files-when-using-a-context-me.patch
	patch_apply shell32-Context_Menu/0002-shell32-Set-return-value-correctly-in-DoPaste.patch
	patch_apply shell32-Context_Menu/0003-shell32-Implement-insert-paste-for-item-context-menu.patch
	patch_apply shell32-Context_Menu/0004-shell32-Correctly-interpret-result-of-SHFileOperatio.patch
	patch_apply shell32-Context_Menu/0005-shell32-Add-support-for-setting-getting-PREFERREDDRO.patch
	patch_apply shell32-Context_Menu/0006-shell32-Add-parameter-to-ISFHelper-DeleteItems-to-al.patch
	patch_apply shell32-Context_Menu/0007-shell32-Remove-source-files-when-using-cut-in-the-co.patch
	patch_apply shell32-Context_Menu/0008-shell32-Recognize-cut-copy-paste-string-verbs-in-ite.patch
	(
		echo '+    { "Michael Müller", "shell32: Fix copying of files when using a context menu.", 1 },';
		echo '+    { "Michael Müller", "shell32: Set return value correctly in DoPaste.", 1 },';
		echo '+    { "Michael Müller", "shell32: Implement insert/paste for item context menus.", 1 },';
		echo '+    { "Michael Müller", "shell32: Correctly interpret result of SHFileOperation in UNIXFS copy and delete.", 1 },';
		echo '+    { "Michael Müller", "shell32: Add support for setting/getting PREFERREDDROPEFFECT in IDataObject.", 1 },';
		echo '+    { "Michael Müller", "shell32: Add parameter to ISFHelper::DeleteItems to allow deleting files without confirmation.", 1 },';
		echo '+    { "Michael Müller", "shell32: Remove source files when using cut in the context menu.", 1 },';
		echo '+    { "Michael Müller", "shell32: Recognize cut/copy/paste string verbs in item menu context menu.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Default_Path
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30385] Support for KF_FLAG_DEFAULT_PATH in SHGetKnownFolderPath
# |
# | Modified files:
# |   *	dlls/shell32/shellpath.c, dlls/shell32/tests/shellpath.c
# |
if test "$enable_shell32_Default_Path" -eq 1; then
	patch_apply shell32-Default_Path/0001-shell32-Implement-KF_FLAG_DEFAULT_PATH-flag-for-SHGe.patch
	(
		echo '+    { "Sebastian Lackner", "shell32: Implement KF_FLAG_DEFAULT_PATH flag for SHGetKnownFolderPath.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-File_Property_Dialog
# |
# | Modified files:
# |   *	dlls/shell32/shell32.rc, dlls/shell32/shlview_cmenu.c, dlls/shell32/shresdef.h
# |
if test "$enable_shell32_File_Property_Dialog" -eq 1; then
	patch_apply shell32-File_Property_Dialog/0001-shell32-Add-general-tab-in-file-property-dialog.patch
	(
		echo '+    { "Michael Müller", "shell32: Add general tab in file property dialog.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-FolderItems_Stub_Iface
# |
# | Modified files:
# |   *	dlls/shell32/shell32_main.h, dlls/shell32/shelldispatch.c
# |
if test "$enable_shell32_FolderItems_Stub_Iface" -eq 1; then
	patch_apply shell32-FolderItems_Stub_Iface/0001-shell32-Implement-FolterImpl_Items-and-stubbed-Folde.patch
	(
		echo '+    { "Christian Costa", "shell32: Implement FolderImpl_Items and stubbed FolderItems interface.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-IDragSourceHelper
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24699] Add IDragSourceHelper stub interface
# |
# | Modified files:
# |   *	dlls/shell32/dragdrophelper.c
# |
if test "$enable_shell32_IDragSourceHelper" -eq 1; then
	patch_apply shell32-IDragSourceHelper/0001-shell32-Cleanup-IDropTargetHelper-and-preparation-fo.patch
	patch_apply shell32-IDragSourceHelper/0002-shell32-Add-IDragSourceHelper-stub-interface.patch
	(
		echo '+    { "Michael Müller", "shell32: Cleanup IDropTargetHelper and preparation for IDragSourceHelper.", 1 },';
		echo '+    { "Michael Müller", "shell32: Add IDragSourceHelper stub interface.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Icons
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24721] Support for extra large and jumbo icon lists in shell32
# |
# | Modified files:
# |   *	dlls/shell32/iconcache.c, dlls/shell32/shell32_main.h, dlls/shell32/shellord.c
# |
if test "$enable_shell32_Icons" -eq 1; then
	patch_apply shell32-Icons/0001-shell32-Add-support-for-extra-large-and-jumbo-icon-l.patch
	(
		echo '+    { "Michael Müller", "shell32: Add support for extra large and jumbo icon lists.", 2 },';
	) >> "$patchlist"
fi

# Patchset shell32-Microsoft_Windows_Themes
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34910] Create Microsoft\Windows\Themes directory during Wineprefix creation
# |
# | Modified files:
# |   *	dlls/shell32/shellpath.c
# |
if test "$enable_shell32_Microsoft_Windows_Themes" -eq 1; then
	patch_apply shell32-Microsoft_Windows_Themes/0001-shell32-Create-Microsoft-Windows-Themes-directory-du.patch
	(
		echo '+    { "Sebastian Lackner", "shell32: Create Microsoft\\\\Windows\\\\Themes directory during Wineprefix creation.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-NewMenu_Interface
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24812] Implement shell32 NewMenu class with new folder item
# |
# | Modified files:
# |   *	dlls/shell32/Makefile.in, dlls/shell32/shell32_classes.idl, dlls/shell32/shell32_main.h, dlls/shell32/shellnew.c,
# | 	dlls/shell32/shellole.c, include/shlguid.h
# |
if test "$enable_shell32_NewMenu_Interface" -eq 1; then
	patch_apply shell32-NewMenu_Interface/0001-shell32-Implement-NewMenu-with-new-folder-item.patch
	(
		echo '+    { "Michael Müller", "shell32: Implement NewMenu with new folder item.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Placeholder_Icons
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30185] Add shell32 placeholder icons to match offsets with Windows
# |
# | Modified files:
# |   *	dlls/shell32/placeholder.ico, dlls/shell32/shell32.rc, dlls/shell32/shresdef.h
# |
if test "$enable_shell32_Placeholder_Icons" -eq 1; then
	patch_apply shell32-Placeholder_Icons/0001-shell32-Add-placeholder-icons-to-match-icon-offset-w.patch
	(
		echo '+    { "Michael Müller", "shell32: Add placeholder icons to match icon offset with XP.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-SHFileOperation_Move
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#25207] SHFileOperation with FO_MOVE should create new directory on Vista+
# |
# | Modified files:
# |   *	dlls/shell32/shlfileop.c, dlls/shell32/tests/shlfileop.c
# |
if test "$enable_shell32_SHFileOperation_Move" -eq 1; then
	patch_apply shell32-SHFileOperation_Move/0001-shell32-Fix-SHFileOperation-FO_MOVE-for-creating-sub.patch
	(
		echo '+    { "Zhenbo Li", "shell32: Fix SHFileOperation(FO_MOVE) for creating subdirectories.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Progress_Dialog
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	kernel32-SetFileInformationByHandle, server-File_Permissions, ntdll-FileDispositionInformation, kernel32-CopyFileEx,
# | 	shell32-SHFileOperation_Move
# |
# | Modified files:
# |   *	dlls/shell32/shell32.rc, dlls/shell32/shlfileop.c, dlls/shell32/shresdef.h
# |
if test "$enable_shell32_Progress_Dialog" -eq 1; then
	patch_apply shell32-Progress_Dialog/0001-shell32-Correct-indentation-in-shfileop.c.patch
	patch_apply shell32-Progress_Dialog/0002-shell32-Pass-FILE_INFORMATION-into-SHNotify-function.patch
	patch_apply shell32-Progress_Dialog/0003-shell32-Implement-file-operation-progress-dialog.patch
	patch_apply shell32-Progress_Dialog/0004-shell32-Show-animation-during-SHFileOperation.patch
	(
		echo '+    { "Michael Müller", "shell32: Correct indentation in shfileop.c.", 1 },';
		echo '+    { "Michael Müller", "shell32: Pass FILE_INFORMATION into SHNotify* functions.", 1 },';
		echo '+    { "Michael Müller", "shell32: Implement file operation progress dialog.", 1 },';
		echo '+    { "Michael Müller", "shell32: Show animation during SHFileOperation.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-RunDLL_CallEntry16
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#23033] Use manual relay for RunDLL_CallEntry16 in shell32
# |
# | Modified files:
# |   *	dlls/shell32/control.c, dlls/shell32/shell32.spec
# |
if test "$enable_shell32_RunDLL_CallEntry16" -eq 1; then
	patch_apply shell32-RunDLL_CallEntry16/0001-shell32-Use-manual-redirection-for-RunDLL_CallEntry1.patch
	(
		echo '+    { "Michael Müller", "shell32: Use manual redirection for RunDLL_CallEntry16.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Run_Dialog
# |
# | Modified files:
# |   *	dlls/shell32/shell32.rc
# |
if test "$enable_shell32_Run_Dialog" -eq 1; then
	patch_apply shell32-Run_Dialog/0001-shell32-Add-caption-to-Run-dialog.patch
	(
		echo '+    { "Jared Smudde", "shell32: Add caption to Run dialog.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-SFGAO_HASSUBFOLDER
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24851] Only set SFGAO_HASSUBFOLDER when there are really subfolders
# |
# | Modified files:
# |   *	dlls/shell32/shfldr_unixfs.c, dlls/shell32/shlfolder.c
# |
if test "$enable_shell32_SFGAO_HASSUBFOLDER" -eq 1; then
	patch_apply shell32-SFGAO_HASSUBFOLDER/0001-shell32-Set-SFGAO_HASSUBFOLDER-correctly-for-unixfs.patch
	patch_apply shell32-SFGAO_HASSUBFOLDER/0002-shell32-Set-SFGAO_HASSUBFOLDER-correctly-for-normal-.patch
	(
		echo '+    { "Michael Müller", "shell32: Set SFGAO_HASSUBFOLDER correctly for unixfs.", 1 },';
		echo '+    { "Michael Müller", "shell32: Set SFGAO_HASSUBFOLDER correctly for normal shellfolders.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-SHCreateSessionKey
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35630] Support for SHCreateSessionKey
# |
# | Modified files:
# |   *	dlls/shell32/shell32.spec, dlls/shell32/shellreg.c, dlls/shell32/tests/shellole.c
# |
if test "$enable_shell32_SHCreateSessionKey" -eq 1; then
	patch_apply shell32-SHCreateSessionKey/0001-shell32-Implement-SHCreateSessionKey.patch
	(
		echo '+    { "Dmitry Timoshkov", "shell32: Implement SHCreateSessionKey.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-SHFileOperation_Win9x
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	kernel32-SetFileInformationByHandle, server-File_Permissions, ntdll-FileDispositionInformation, kernel32-CopyFileEx,
# | 	shell32-SHFileOperation_Move, shell32-Progress_Dialog
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37916] Anno 1602 installer depends on Windows 98 behavior of SHFileOperationW
# |
# | Modified files:
# |   *	dlls/shell32/shlfileop.c
# |
if test "$enable_shell32_SHFileOperation_Win9x" -eq 1; then
	patch_apply shell32-SHFileOperation_Win9x/0001-shell32-Choose-return-value-for-SHFileOperationW-dep.patch
	(
		echo '+    { "Michael Müller", "shell32: Choose return value for SHFileOperationW depending on windows version.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Toolbar_Bitmaps
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40236] Add missing resources for IE6 buttons
# |
# | Modified files:
# |   *	dlls/shell32/Makefile.in, dlls/shell32/ietoolbar.bmp, dlls/shell32/ietoolbar.svg, dlls/shell32/ietoolbar_small.bmp,
# | 	dlls/shell32/ietoolbar_small.svg, dlls/shell32/shell32.rc
# |
if test "$enable_shell32_Toolbar_Bitmaps" -eq 1; then
	patch_apply shell32-Toolbar_Bitmaps/0001-shell32-Add-toolbar-bitmaps-compatible-with-IE6.patch
	patch_apply shell32-Toolbar_Bitmaps/0002-shell32-Add-more-Tango-icons-to-the-IE-toolbar.patch
	(
		echo '+    { "Dmitry Timoshkov", "shell32: Add toolbar bitmaps compatible with IE6.", 1 },';
		echo '+    { "Dmitry Timoshkov", "shell32: Add more Tango icons to the IE toolbar.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-UNIXFS_get_unix_path
# |
# | Modified files:
# |   *	dlls/shell32/shfldr_unixfs.c
# |
if test "$enable_shell32_UNIXFS_get_unix_path" -eq 1; then
	patch_apply shell32-UNIXFS_get_unix_path/0001-shell32-Check-IsWoW64Process-before-calling-Wow64-fu.patch
	(
		echo '+    { "Olivier F. R. Dierick", "shell32: Check IsWoW64Process before calling Wow64 functions.", 2 },';
	) >> "$patchlist"
fi

# Patchset shell32-UnixFS
# |
# | Modified files:
# |   *	dlls/shell32/shfldr_desktop.c, dlls/shell32/tests/shlfolder.c
# |
if test "$enable_shell32_UnixFS" -eq 1; then
	patch_apply shell32-UnixFS/0001-shell32-Do-not-use-unixfs-for-devices-without-mountp.patch
	(
		echo '+    { "Michael Müller", "shell32: Do not use unixfs for devices without mountpoint.", 1 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-AssocGetPerceivedType
# |
# | Modified files:
# |   *	dlls/shlwapi/assoc.c, dlls/shlwapi/tests/assoc.c
# |
if test "$enable_shlwapi_AssocGetPerceivedType" -eq 1; then
	patch_apply shlwapi-AssocGetPerceivedType/0001-shlwapi-tests-Add-tests-for-AssocGetPerceivedType.patch
	patch_apply shlwapi-AssocGetPerceivedType/0002-shlwapi-Implement-AssocGetPerceivedType.patch
	(
		echo '+    { "Mark Jansen", "shlwapi/tests: Add tests for AssocGetPerceivedType.", 1 },';
		echo '+    { "Mark Jansen", "shlwapi: Implement AssocGetPerceivedType.", 2 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-IStream_fnRead
# |
# | Modified files:
# |   *	dlls/shlwapi/istream.c, dlls/shlwapi/tests/istream.c
# |
if test "$enable_shlwapi_IStream_fnRead" -eq 1; then
	patch_apply shlwapi-IStream_fnRead/0001-shlwapi-Fix-IStream-Read-return-value-for-partial-re.patch
	(
		echo '+    { "Dmitry Timoshkov", "shlwapi: Fix IStream::Read() return value for partial reads.", 1 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-SHMapHandle
# |
# | Modified files:
# |   *	dlls/shlwapi/ordinal.c, dlls/shlwapi/tests/ordinal.c
# |
if test "$enable_shlwapi_SHMapHandle" -eq 1; then
	patch_apply shlwapi-SHMapHandle/0001-shlwapi-tests-Test-NULL-handle-duplication-in-SHMapH.patch
	patch_apply shlwapi-SHMapHandle/0002-shlwapi-SHMapHandle-should-not-set-error-when-NULL-i.patch
	(
		echo '+    { "Bruno Jesus", "shlwapi/tests: Test NULL handle duplication in SHMapHandle().", 1 },';
		echo '+    { "Sebastian Lackner", "shlwapi: SHMapHandle should not set error when NULL is passed as hShared.", 1 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-UrlCombine
# |
# | Modified files:
# |   *	dlls/shlwapi/tests/url.c, dlls/shlwapi/url.c
# |
if test "$enable_shlwapi_UrlCombine" -eq 1; then
	patch_apply shlwapi-UrlCombine/0001-shlwapi-tests-Add-additional-tests-for-UrlCombine-and-.patch
	patch_apply shlwapi-UrlCombine/0002-shlwapi-UrlCombineW-workaround-for-relative-paths.patch
	(
		echo '+    { "Sebastian Lackner", "shlwapi/tests: Add additional tests for UrlCombine and UrlCanonicalize.", 1 },';
		echo '+    { "Sebastian Lackner", "shlwapi: UrlCombineW workaround for relative paths.", 1 },';
	) >> "$patchlist"
fi

# Patchset stdole32.idl-Typelib
# |
# | Modified files:
# |   *	dlls/stdole32.tlb/std_ole_v1.idl, include/Makefile.in, include/stdole32.idl
# |
if test "$enable_stdole32_idl_Typelib" -eq 1; then
	patch_apply stdole32.idl-Typelib/0001-include-Make-stdole32.idl-a-public-component.patch
	(
		echo '+    { "Dmitry Timoshkov", "include: Make stdole32.idl a public component.", 1 },';
	) >> "$patchlist"
fi

# Patchset widl-SLTG_Typelib_Support
# |
# | Modified files:
# |   *	dlls/oleaut32/typelib.c, dlls/oleaut32/typelib.h, tools/widl/Makefile.in, tools/widl/typelib.c, tools/widl/typelib.h,
# | 	tools/widl/widl.c, tools/widl/widl.h, tools/widl/write_sltg.c
# |
if test "$enable_widl_SLTG_Typelib_Support" -eq 1; then
	patch_apply widl-SLTG_Typelib_Support/0001-widl-Add-initial-implementation-of-SLTG-typelib-gene.patch
	patch_apply widl-SLTG_Typelib_Support/0002-widl-Add-support-for-structures.patch
	patch_apply widl-SLTG_Typelib_Support/0003-widl-Properly-align-name-table-entries.patch
	patch_apply widl-SLTG_Typelib_Support/0004-widl-More-accurately-report-variable-descriptions-da.patch
	patch_apply widl-SLTG_Typelib_Support/0005-widl-Calculate-size-of-instance-for-structures.patch
	patch_apply widl-SLTG_Typelib_Support/0006-widl-Write-correct-typekind-to-the-SLTG-typeinfo-blo.patch
	patch_apply widl-SLTG_Typelib_Support/0007-widl-Write-SLTG-blocks-according-to-the-index-order.patch
	patch_apply widl-SLTG_Typelib_Support/0008-widl-Write-correct-syskind-by-SLTG-typelib-generator.patch
	patch_apply widl-SLTG_Typelib_Support/0009-widl-Add-support-for-VT_VOID-and-VT_VARIANT-to-SLTG-.patch
	patch_apply widl-SLTG_Typelib_Support/0010-widl-Add-support-for-VT_USERDEFINED-to-SLTG-typelib-.patch
	patch_apply widl-SLTG_Typelib_Support/0011-widl-Factor-out-SLTG-tail-initialization.patch
	patch_apply widl-SLTG_Typelib_Support/0012-widl-Add-support-for-recursive-type-references-to-SL.patch
	patch_apply widl-SLTG_Typelib_Support/0013-widl-Add-support-for-interfaces-to-SLTG-typelib-gene.patch
	patch_apply widl-SLTG_Typelib_Support/0014-widl-Add-support-for-inherited-interfaces-to-SLTG-ty.patch
	patch_apply widl-SLTG_Typelib_Support/0015-widl-Make-automatic-dispid-generation-scheme-better-.patch
	patch_apply widl-SLTG_Typelib_Support/0016-widl-Create-library-block-index-right-after-the-Comp.patch
	patch_apply widl-SLTG_Typelib_Support/0017-widl-Fix-generation-of-resources-containing-an-old-t.patch
	patch_apply widl-SLTG_Typelib_Support/0018-widl-Add-oldtlb-switch-in-usage-message.patch
	patch_apply widl-SLTG_Typelib_Support/0019-widl-Avoid-relying-on-side-effects-when-marking-func.patch
	patch_apply widl-SLTG_Typelib_Support/0020-widl-Set-the-lowest-bit-in-the-param-name-to-indicat.patch
	patch_apply widl-SLTG_Typelib_Support/0021-oleaut32-Fix-logic-for-deciding-whether-type-descrip.patch
	patch_apply widl-SLTG_Typelib_Support/0022-widl-Add-support-for-function-parameter-flags-to-SLT.patch
	patch_apply widl-SLTG_Typelib_Support/0023-oleaut32-Implement-decoding-of-SLTG-help-strings.patch
	patch_apply widl-SLTG_Typelib_Support/0024-oleaut32-Add-support-for-decoding-SLTG-function-help.patch
	patch_apply widl-SLTG_Typelib_Support/0025-oleaut32-Add-support-for-decoding-SLTG-variable-help.patch
	patch_apply widl-SLTG_Typelib_Support/0026-widl-Minor-cosmetic-clean-up.patch
	(
		echo '+    { "Dmitry Timoshkov", "widl: Add initial implementation of SLTG typelib generator.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Add support for structures.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Properly align name table entries.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: More accurately report variable descriptions data size.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Calculate size of instance for structures.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Write correct typekind to the SLTG typeinfo block.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Write SLTG blocks according to the index order.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Write correct syskind by SLTG typelib generator.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Add support for VT_VOID and VT_VARIANT to SLTG typelib generator.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Add support for VT_USERDEFINED to SLTG typelib generator.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Factor out SLTG tail initialization.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Add support for recursive type references to SLTG typelib generator.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Add support for interfaces to SLTG typelib generator.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Add support for inherited interfaces to SLTG typelib generator.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Make automatic dispid generation scheme better match what midl does.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Create library block index right after the CompObj one.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Fix generation of resources containing an old typelib.", 1 },';
		echo '+    { "Sebastian Lackner", "widl: Add --oldtlb switch in usage message.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Avoid relying on side effects when marking function index as the last one.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Set the lowest bit in the param name to indicate whether type description follows the name.", 1 },';
		echo '+    { "Dmitry Timoshkov", "oleaut32: Fix logic for deciding whether type description follows the name.", 2 },';
		echo '+    { "Dmitry Timoshkov", "widl: Add support for function parameter flags to SLTG typelib generator.", 1 },';
		echo '+    { "Dmitry Timoshkov", "oleaut32: Implement decoding of SLTG help strings.", 1 },';
		echo '+    { "Dmitry Timoshkov", "oleaut32: Add support for decoding SLTG function help strings.", 1 },';
		echo '+    { "Dmitry Timoshkov", "oleaut32: Add support for decoding SLTG variable help strings.", 1 },';
		echo '+    { "Dmitry Timoshkov", "widl: Minor/cosmetic clean up.", 1 },';
	) >> "$patchlist"
fi

# Patchset stdole32.tlb-SLTG_Typelib
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	widl-SLTG_Typelib_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#3689] Compile stdole32.tlb in SLTG typelib format
# |
# | Modified files:
# |   *	dlls/stdole32.tlb/Makefile.in
# |
if test "$enable_stdole32_tlb_SLTG_Typelib" -eq 1; then
	patch_apply stdole32.tlb-SLTG_Typelib/0020-stdole32.tlb-Compile-typelib-with-oldtlb.patch
	(
		echo '+    { "Sebastian Lackner", "stdole32.tlb: Compile typelib with --oldtlb.", 1 },';
	) >> "$patchlist"
fi

# Patchset taskmgr-Memory_Usage
# |
# | Modified files:
# |   *	configure.ac, dlls/ntdll/nt.c, dlls/ntdll/virtual.c, programs/taskmgr/font.bmp, programs/taskmgr/graph.c,
# | 	programs/taskmgr/resource.h, programs/taskmgr/taskmgr.c, programs/taskmgr/taskmgr.rc
# |
if test "$enable_taskmgr_Memory_Usage" -eq 1; then
	patch_apply taskmgr-Memory_Usage/0001-ntdll-Use-sysinfo-to-report-correct-number-of-physic.patch
	patch_apply taskmgr-Memory_Usage/0002-ntdll-Report-system-information-SystemPerformanceInf.patch
	patch_apply taskmgr-Memory_Usage/0003-taskmgr-Use-system-font-instead-of-special-bitmap-fo.patch
	patch_apply taskmgr-Memory_Usage/0004-taskmgr-Use-different-units-depending-on-memory-usag.patch
	(
		echo '+    { "Michael Müller", "ntdll: Use sysinfo to report correct number of physical pages.", 1 },';
		echo '+    { "Michael Müller", "ntdll: Report system information SystemPerformanceInformation info class.", 1 },';
		echo '+    { "Michael Müller", "taskmgr: Use system font instead of special bitmap font.", 1 },';
		echo '+    { "Michael Müller", "taskmgr: Use different units depending on memory usage.", 1 },';
	) >> "$patchlist"
fi

# Patchset ucrtbase-Functions
# |
# | Modified files:
# |   *	dlls/api-ms-win-crt-heap-l1-1-0/api-ms-win-crt-heap-l1-1-0.spec, dlls/ucrtbase/ucrtbase.spec
# |
if test "$enable_ucrtbase_Functions" -eq 1; then
	patch_apply ucrtbase-Functions/0001-ucrtbase-Hook-up-some-functions-with-new-names-to-ex.patch
	(
		echo '+    { "Martin Storsjo", "ucrtbase: Hook up some functions with new names to existing implementations.", 1 },';
	) >> "$patchlist"
fi

# Patchset user.exe16-CONTAINING_RECORD
# |
# | Modified files:
# |   *	dlls/user.exe16/user.c
# |
if test "$enable_user_exe16_CONTAINING_RECORD" -eq 1; then
	patch_apply user.exe16-CONTAINING_RECORD/0001-user.exe16-Don-t-open-code-CONTAINING_RECORD.patch
	(
		echo '+    { "Sebastian Lackner", "user.exe16: Don'\''t open code CONTAINING_RECORD.", 1 },';
	) >> "$patchlist"
fi

# Patchset user.exe16-DlgDirList
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#18734] Fix handling of DDL_DRIVES flag in user.exe16.DlgDirList
# |
# | Modified files:
# |   *	dlls/user.exe16/dialog.c
# |
if test "$enable_user_exe16_DlgDirList" -eq 1; then
	patch_apply user.exe16-DlgDirList/0001-user.exe16-Fix-handling-of-DDL_DRIVES-flag-in-DlgDir.patch
	(
		echo '+    { "Alex Villacís Lasso", "user.exe16: Fix handling of DDL_DRIVES flag in DlgDirList.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-DeferWindowPos
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#23187] Fix error handling in DeferWindowPos when passing an invalid HWND
# |
# | Modified files:
# |   *	dlls/user32/winpos.c
# |
if test "$enable_user32_DeferWindowPos" -eq 1; then
	patch_apply user32-DeferWindowPos/0001-user32-Fix-error-handling-in-Begin-End-DeferWindowPo.patch
	(
		echo '+    { "Rodrigo Rivas", "user32: Fix error handling in {Begin,End,}DeferWindowPos() to match Windows behavior.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Dialog_Owner
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40282] Enable the correct dialog owner in DIALOG_DoDialogBox
# |
# | Modified files:
# |   *	dlls/user.exe16/dialog.c, dlls/user.exe16/user_private.h, dlls/user32/controls.h, dlls/user32/dialog.c,
# | 	dlls/user32/tests/win.c
# |
if test "$enable_user32_Dialog_Owner" -eq 1; then
	patch_apply user32-Dialog_Owner/0001-user32-tests-Add-some-tests-for-dialog-owner-disable.patch
	patch_apply user32-Dialog_Owner/0002-user32-Enable-the-specified-dialog-owner.patch
	patch_apply user32-Dialog_Owner/0003-user32-Enable-correct-dialog-owner.patch
	patch_apply user32-Dialog_Owner/0004-user32-Unconditionally-enable-dialog-owner.patch
	(
		echo '+    { "Dmitry Timoshkov", "user32/tests: Add some tests for dialog owner disabled state.", 3 },';
		echo '+    { "Dmitry Timoshkov", "user32: Enable the specified dialog owner.", 1 },';
		echo '+    { "Dmitry Timoshkov", "user32: Enable correct dialog owner.", 1 },';
		echo '+    { "Dmitry Timoshkov", "user32: Unconditionally enable dialog owner.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Dialog_Paint_Event
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35652] Send WM_PAINT event during dialog creation
# |
# | Modified files:
# |   *	dlls/user32/dialog.c
# |
if test "$enable_user32_Dialog_Paint_Event" -eq 1; then
	patch_apply user32-Dialog_Paint_Event/0001-user32-Call-UpdateWindow-during-DIALOG_CreateIndirec.patch
	(
		echo '+    { "Sebastian Lackner", "user32: Call UpdateWindow() during DIALOG_CreateIndirect.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-DrawTextExW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22109] Fix handling of invert_y in DrawTextExW
# |
# | Modified files:
# |   *	dlls/user32/text.c
# |
if test "$enable_user32_DrawTextExW" -eq 1; then
	patch_apply user32-DrawTextExW/0001-user32-Fix-handling-of-invert_y-in-DrawTextExW.patch
	(
		echo '+    { "Sebastian Lackner", "user32: Fix handling of invert_y in DrawTextExW.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-FlashWindowEx
# |
# | Modified files:
# |   *	dlls/user32/win.c
# |
if test "$enable_user32_FlashWindowEx" -eq 1; then
	patch_apply user32-FlashWindowEx/0001-user32-Avoid-dereferencing-NULL-pointer-in-a-trace.patch
	(
		echo '+    { "Dmitry Timoshkov", "user32: Avoid dereferencing NULL pointer in a trace.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-GetSystemMetrics
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#18732] Make it possible to change media center / tablet pc status
# |
# | Modified files:
# |   *	dlls/user32/sysparams.c
# |
if test "$enable_user32_GetSystemMetrics" -eq 1; then
	patch_apply user32-GetSystemMetrics/0001-user32-Allow-changing-the-tablet-media-center-status.patch
	(
		echo '+    { "Michael Müller", "user32: Allow changing the tablet / media center status via wine registry key.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Invalidate_Key_State
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29871] Globally invalidate key state on changes in other threads
# |
# | Modified files:
# |   *	dlls/user32/input.c
# |
if test "$enable_user32_Invalidate_Key_State" -eq 1; then
	patch_apply user32-Invalidate_Key_State/0001-user32-Globally-invalidate-key-state-on-changes-in-o.patch
	(
		echo '+    { "Sebastian Lackner", "user32: Globally invalidate key state on changes in other threads.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-ListBox_Size
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38142] Fix calculation of listbox size when horizontal scrollbar is present
# |
# | Modified files:
# |   *	dlls/user32/listbox.c
# |
if test "$enable_user32_ListBox_Size" -eq 1; then
	patch_apply user32-ListBox_Size/0001-user32-Fix-calculation-of-listbox-size-when-horizont.patch
	(
		echo '+    { "Michael Müller", "user32: Fix calculation of listbox size when horizontal scrollbar is present.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-lpCreateParams
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40303] Fix pointer to custom dialog control data
# |
# | Modified files:
# |   *	dlls/user32/dialog.c, dlls/user32/tests/dialog.c, dlls/user32/tests/resource.rc, tools/wrc/genres.c
# |
if test "$enable_user32_lpCreateParams" -eq 1; then
	patch_apply user32-lpCreateParams/0001-user32-tests-Add-a-test-for-custom-dialog-control-da.patch
	patch_apply user32-lpCreateParams/0002-tools-wrc-Fix-generation-of-custom-dialog-control-da.patch
	patch_apply user32-lpCreateParams/0003-user32-Fix-the-pointer-to-custom-dialog-control-data.patch
	(
		echo '+    { "Dmitry Timoshkov", "user32/tests: Add a test for custom dialog control data.", 1 },';
		echo '+    { "Dmitry Timoshkov", "tools/wrc: Fix generation of custom dialog control data.", 1 },';
		echo '+    { "Dmitry Timoshkov", "user32: Fix the pointer to custom dialog control data.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-MessageBox_WS_EX_TOPMOST
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	user32-lpCreateParams
# |
# | Modified files:
# |   *	dlls/user32/msgbox.c, dlls/user32/tests/dialog.c
# |
if test "$enable_user32_MessageBox_WS_EX_TOPMOST" -eq 1; then
	patch_apply user32-MessageBox_WS_EX_TOPMOST/0001-user32-tests-Add-some-tests-to-see-when-MessageBox-g.patch
	patch_apply user32-MessageBox_WS_EX_TOPMOST/0002-user32-MessageBox-should-be-topmost-when-MB_SYSTEMMO.patch
	(
		echo '+    { "Dmitry Timoshkov", "user32/tests: Add some tests to see when MessageBox gains WS_EX_TOPMOST style.", 1 },';
		echo '+    { "Dmitry Timoshkov", "user32: MessageBox should be topmost when MB_SYSTEMMODAL style is set.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Mouse_Message_Hwnd
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#12007] Fix issues with dragging layers between images in Adobe Photoshop 7.0
# |   *	[#9512] Make sure popups don't block access to objects underneath in DVDPro
# |
# | Modified files:
# |   *	dlls/user32/message.c, dlls/user32/tests/input.c
# |
if test "$enable_user32_Mouse_Message_Hwnd" -eq 1; then
	patch_apply user32-Mouse_Message_Hwnd/0001-user32-Try-harder-to-find-a-target-for-mouse-message.patch
	(
		echo '+    { "Dmitry Timoshkov", "user32: Try harder to find a target for mouse messages.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Refresh_MDI_Menus
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#21855] Refresh MDI menus when DefMDIChildProc(WM_SETTEXT) is called
# |
# | Modified files:
# |   *	dlls/user32/mdi.c
# |
if test "$enable_user32_Refresh_MDI_Menus" -eq 1; then
	patch_apply user32-Refresh_MDI_Menus/0001-user32-Refresh-MDI-menus-when-DefMDIChildProcW-WM_SE.patch
	(
		echo '+    { "Sebastian Lackner", "user32: Refresh MDI menus when DefMDIChildProc(WM_SETTEXT) is called.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-ScrollWindowEx
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37706] Fix return value of ScrollWindowEx for invisible windows
# |
# | Modified files:
# |   *	dlls/user32/painting.c
# |
if test "$enable_user32_ScrollWindowEx" -eq 1; then
	patch_apply user32-ScrollWindowEx/0001-user32-Fix-return-value-of-ScrollWindowEx-for-invisi.patch
	(
		echo '+    { "Dmitry Timoshkov", "user32: Fix return value of ScrollWindowEx for invisible windows.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-SetCoalescableTimer
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39509] Add stub for SetCoalescableTimer
# |
# | Modified files:
# |   *	dlls/user32/message.c, dlls/user32/user32.spec
# |
if test "$enable_user32_SetCoalescableTimer" -eq 1; then
	patch_apply user32-SetCoalescableTimer/0001-user32-add-SetCoalescableTimer-stub.patch
	(
		echo '+    { "Austin English", "user32: Add SetCoalescableTimer stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-WM_CTLCOLORBTN
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#25790] Replicate Windows behavior of WM_SETTEXT handler regarding WM_CTLCOLOR* messages
# |
# | Modified files:
# |   *	dlls/user32/button.c, dlls/user32/tests/msg.c
# |
if test "$enable_user32_WM_CTLCOLORBTN" -eq 1; then
	patch_apply user32-WM_CTLCOLORBTN/0001-user32-Replicate-Windows-behavior-of-WM_SETTEXT-hand.patch
	patch_apply user32-WM_CTLCOLORBTN/0002-user32-tests-Add-tests-for-button-WM_CTLCOLOR-messag.patch
	(
		echo '+    { "Alexander Law", "user32: Replicate Windows behavior of WM_SETTEXT handler regarding WM_CTLCOLOR*.", 1 },';
		echo '+    { "Sebastian Lackner", "user32/tests: Add tests for button WM_CTLCOLOR* messages.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-WM_MDICALCCHILDSCROLL
# |
# | Modified files:
# |   *	dlls/user32/mdi.c, dlls/user32/tests/win.c
# |
if test "$enable_user32_WM_MDICALCCHILDSCROLL" -eq 1; then
	patch_apply user32-WM_MDICALCCHILDSCROLL/0001-user32-Change-value-for-WM_MDICALCCHILDSCROLL-to-0x0.patch
	(
		echo '+    { "Dmitry Timoshkov", "user32: Change value for WM_MDICALCCHILDSCROLL to 0x003f.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-WM_NOTIFY
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40244] Fix handling of WM_NOTIFY messages in PostThreadMessage
# |
# | Modified files:
# |   *	dlls/user32/message.c, dlls/user32/tests/msg.c
# |
if test "$enable_user32_WM_NOTIFY" -eq 1; then
	patch_apply user32-WM_NOTIFY/0001-user32-Allow-to-send-post-intra-process-WM_NOTIFY-me.patch
	(
		echo '+    { "Sebastian Lackner", "user32: Do not block sending/posting WM_NOTIFY messages.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-WndProc
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32451] Fix for programs leaking wndproc slots
# |
# | Modified files:
# |   *	dlls/user.exe16/message.c, dlls/user32/winproc.c
# |
if test "$enable_user32_WndProc" -eq 1; then
	patch_apply user32-WndProc/0001-user32-Increase-MAX_WINPROCS-to-16384.patch
	(
		echo '+    { "Sebastian Lackner", "user32: Increase MAX_WINPROCS to 16384.", 2 },';
	) >> "$patchlist"
fi

# Patchset uxtheme-GTK_Theming
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-DllOverrides_WOW64, ntdll-Loader_Machine_Type, ntdll-DllRedirects
# |
# | Modified files:
# |   *	aclocal.m4, configure.ac, dlls/uxtheme-gtk/Makefile.in, dlls/uxtheme-gtk/button.c, dlls/uxtheme-gtk/combobox.c, dlls
# | 	/uxtheme-gtk/edit.c, dlls/uxtheme-gtk/header.c, dlls/uxtheme-gtk/listbox.c, dlls/uxtheme-gtk/listview.c, dlls/uxtheme-
# | 	gtk/menu.c, dlls/uxtheme-gtk/rebar.c, dlls/uxtheme-gtk/status.c, dlls/uxtheme-gtk/tab.c, dlls/uxtheme-gtk/toolbar.c,
# | 	dlls/uxtheme-gtk/trackbar.c, dlls/uxtheme-gtk/uxtheme-gtk.spec, dlls/uxtheme-gtk/uxtheme.c, dlls/uxtheme-
# | 	gtk/uxthemegtk.h, dlls/uxtheme-gtk/version.rc, dlls/uxtheme-gtk/window.c
# |
if test "$enable_uxtheme_GTK_Theming" -eq 1; then
	patch_apply uxtheme-GTK_Theming/0001-uxthemegtk-Add-configure-check-and-stub-dll.patch
	patch_apply uxtheme-GTK_Theming/0002-uxthemegtk-Initial-implementation.patch
	patch_apply uxtheme-GTK_Theming/0003-uxthemegtk-Implement-enumeration-of-themes-color-and.patch
	patch_apply uxtheme-GTK_Theming/0004-uxthemegtk-Correctly-render-buttons-with-GTK-3.14.0.patch
	patch_apply uxtheme-GTK_Theming/0005-uxthemegtk-Print-class-name-before-calling-vtable-fu.patch
	patch_apply uxtheme-GTK_Theming/0006-uxthemegtk-Reset-FPU-flags-before-calling-GTK3-funct.patch
	patch_apply uxtheme-GTK_Theming/0007-uxthemegtk-Add-export-for-OpenThemeDataEx.patch
	patch_apply uxtheme-GTK_Theming/0008-uxthemegtk-Fix-some-incorrect-error-codes.patch
	patch_apply uxtheme-GTK_Theming/0009-uxthemegtk-Validate-theme-handles-before-accessing-p.patch
	(
		echo '+    { "Michael Müller", "uxthemegtk: Add configure check and stub dll.", 1 },';
		echo '+    { "Ivan Akulinchev", "uxthemegtk: Initial implementation.", 1 },';
		echo '+    { "Michael Müller", "uxthemegtk: Implement enumeration of themes, color and sizes.", 1 },';
		echo '+    { "Sebastian Lackner", "uxthemegtk: Correctly render buttons with GTK >= 3.14.0.", 1 },';
		echo '+    { "Michael Müller", "uxthemegtk: Print class name before calling vtable functions.", 1 },';
		echo '+    { "Michael Müller", "uxthemegtk: Reset FPU flags before calling GTK3 functions.", 1 },';
		echo '+    { "Sebastian Lackner", "uxthemegtk: Add export for OpenThemeDataEx.", 1 },';
		echo '+    { "Sebastian Lackner", "uxthemegtk: Fix some incorrect error codes.", 1 },';
		echo '+    { "Sebastian Lackner", "uxthemegtk: Validate theme handles before accessing private data.", 1 },';
	) >> "$patchlist"
fi

# Patchset version-GetFileVersionInfoSizeExW
# |
# | Modified files:
# |   *	dlls/version/version.c
# |
if test "$enable_version_GetFileVersionInfoSizeExW" -eq 1; then
	patch_apply version-GetFileVersionInfoSizeExW/0001-version-Return-ERROR_FILE_NOT_FOUND-for-Win-9X-when-.patch
	(
		echo '+    { "Michael Müller", "version: Return ERROR_FILE_NOT_FOUND for Win 9X when a file was not found in GetFileVersionInfoSizeEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset version-VerFindFileA
# |
# | Modified files:
# |   *	dlls/version/tests/Makefile.in, dlls/version/tests/install.c, dlls/version/version.c
# |
if test "$enable_version_VerFindFileA" -eq 1; then
	patch_apply version-VerFindFileA/0001-version-Correctly-return-VFF_CURNEDEST-in-VerFindFil.patch
	(
		echo '+    { "Michael Müller", "version: Correctly return VFF_CURNEDEST in VerFindFileA.", 1 },';
	) >> "$patchlist"
fi

# Patchset version-VerQueryValue
# |
# | Modified files:
# |   *	dlls/version/tests/info.c
# |
if test "$enable_version_VerQueryValue" -eq 1; then
	patch_apply version-VerQueryValue/0001-version-Test-for-VerQueryValueA-try-2.patch
	(
		echo '+    { "Mark Jansen", "version: Test for VerQueryValueA.", 2 },';
	) >> "$patchlist"
fi

# Patchset vulkan-Vulkan_Implementation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40164] Implement support for Vulkan
# |
# | Modified files:
# |   *	configure.ac, dlls/vulkan-1/Makefile.in, dlls/vulkan-1/vulkan-1.spec, dlls/vulkan/Makefile.in, dlls/vulkan/vulkan.spec,
# | 	dlls/vulkan/vulkan_main.c, dlls/vulkan/vulkan_private.h, dlls/vulkan/vulkan_thunks.c
# |
if test "$enable_vulkan_Vulkan_Implementation" -eq 1; then
	patch_apply vulkan-Vulkan_Implementation/0001-vulkan-Initial-implementation.patch
	patch_apply vulkan-Vulkan_Implementation/0002-vulkan-Implement-vkGetPhysicalDeviceWin32Presentatio.patch
	patch_apply vulkan-Vulkan_Implementation/0003-vulkan-Use-binary-search-to-lookup-function-in-is_nu.patch
	patch_apply vulkan-Vulkan_Implementation/0004-vulkan-Try-to-load-libvulkan.so.1.patch
	(
		echo '+    { "Sebastian Lackner", "vulkan: Initial implementation.", 2 },';
		echo '+    { "Michael Müller", "vulkan: Implement vkGetPhysicalDeviceWin32PresentationSupportKHR.", 1 },';
		echo '+    { "Sebastian Lackner", "vulkan: Use binary search to lookup function in is_null_func.", 1 },';
		echo '+    { "Michael Müller", "vulkan: Try to load libvulkan.so.1.", 1 },';
	) >> "$patchlist"
fi

# Patchset wbemdisp-ISWbemSecurity
# |
# | Modified files:
# |   *	dlls/wbemdisp/locator.c
# |
if test "$enable_wbemdisp_ISWbemSecurity" -eq 1; then
	patch_apply wbemdisp-ISWbemSecurity/0001-wbemdisp-Add-ISWbemSecurity-stub-interface.patch
	(
		echo '+    { "Michael Müller", "wbemdisp: Add ISWbemSecurity stub interface.", 1 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-32bppGrayFloat
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#36517] Implement support for WICPixelFormat32bppGrayFloat
# |
# | Modified files:
# |   *	dlls/windowscodecs/converter.c, dlls/windowscodecs/regsvr.c, dlls/windowscodecs/tests/converter.c, include/wincodec.idl
# |
if test "$enable_windowscodecs_32bppGrayFloat" -eq 1; then
	patch_apply windowscodecs-32bppGrayFloat/0001-windowscodecs-Add-support-for-32bppGrayFloat-format.patch
	patch_apply windowscodecs-32bppGrayFloat/0002-windowscodecs-Add-support-for-converting-to-8bpp-gra.patch
	patch_apply windowscodecs-32bppGrayFloat/0003-windowscodecs-Add-support-for-converting-32bpp-grays.patch
	patch_apply windowscodecs-32bppGrayFloat/0004-windowscodecs-Fix-32bppGrayFloat-to-8bppGray-convers.patch
	(
		echo '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 32bppGrayFloat format.", 1 },';
		echo '+    { "Dmitry Timoshkov", "windowscodecs: Add support for converting to 8bpp grayscale format.", 1 },';
		echo '+    { "Dmitry Timoshkov", "windowscodecs: Add support for converting 32bpp grayscale float to 24bpp BGR format.", 1 },';
		echo '+    { "Dmitry Timoshkov", "windowscodecs: Fix 32bppGrayFloat to 8bppGray conversion.", 1 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-IMILBitmapSource
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34764] Improve compatibility of IMILBitmapSource interface
# |
# | Modified files:
# |   *	dlls/windowscodecs/bitmap.c, dlls/windowscodecs/scaler.c, dlls/windowscodecs/wincodecs_private.h
# |
if test "$enable_windowscodecs_IMILBitmapSource" -eq 1; then
	patch_apply windowscodecs-IMILBitmapSource/0001-windowscodecs-Improve-compatibility-of-IMILBitmapSou.patch
	patch_apply windowscodecs-IMILBitmapSource/0002-windowscodecs-Add-support-for-IMILBitmapScaler-inter.patch
	(
		echo '+    { "Dmitry Timoshkov", "windowscodecs: Improve compatibility of IMILBitmapSource interface.", 3 },';
		echo '+    { "Dmitry Timoshkov", "windowscodecs: Add support for IMILBitmapScaler interface.", 2 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-WICCreateBitmapFromSection
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40273] Implement windowscodecs.WICCreateBitmapFromSection(Ex)
# |
# | Modified files:
# |   *	dlls/windowscodecs/bitmap.c, dlls/windowscodecs/imgfactory.c, dlls/windowscodecs/windowscodecs.spec,
# | 	include/wincodec.idl
# |
if test "$enable_windowscodecs_WICCreateBitmapFromSection" -eq 1; then
	patch_apply windowscodecs-WICCreateBitmapFromSection/0001-windowscodecs-Implement-WICCreateBitmapFromSection-E.patch
	(
		echo '+    { "Dmitry Timoshkov", "windowscodecs: Implement WICCreateBitmapFromSection(Ex).", 2 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-Directory_ContextMenuHandlers
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29523] Add 'New' context menu handler entry for directories
# |
# | Modified files:
# |   *	loader/wine.inf.in
# |
if test "$enable_wine_inf_Directory_ContextMenuHandlers" -eq 1; then
	patch_apply wine.inf-Directory_ContextMenuHandlers/0001-wine.inf-Add-New-context-menu-handler-entry-for-dire.patch
	(
		echo '+    { "Michael Müller", "wine.inf: Add '\''New'\'' context menu handler entry for directories.", 1 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-Dummy_CA_Certificate
# |
# | Modified files:
# |   *	loader/wine.inf.in
# |
if test "$enable_wine_inf_Dummy_CA_Certificate" -eq 1; then
	patch_apply wine.inf-Dummy_CA_Certificate/0001-wine.inf.in-Add-invalid-dummy-certificate-to-CA-cert.patch
	(
		echo '+    { "Michael Müller", "wine.inf.in: Add invalid dummy certificate to CA certificate store.", 1 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-Performance
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33661] Add performance library registry keys needed by MS SQL Server Management Studio Express 2008 R2
# |
# | Modified files:
# |   *	loader/wine.inf.in
# |
if test "$enable_wine_inf_Performance" -eq 1; then
	patch_apply wine.inf-Performance/0001-wine.inf-Add-registry-keys-for-Windows-Performance-L.patch
	(
		echo '+    { "Daniel Jelinski", "wine.inf: Add registry keys for Windows Performance Library.", 1 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-ProfileList_UserSID
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#15670] Add a ProfileList\<UserSID> registry subkey
# |
# | Modified files:
# |   *	loader/wine.inf.in
# |
if test "$enable_wine_inf_ProfileList_UserSID" -eq 1; then
	patch_apply wine.inf-ProfileList_UserSID/0001-wine.inf-Add-a-ProfileList-UserSID-registry-subkey.patch
	(
		echo '+    { "Sebastian Lackner", "wine.inf: Add a ProfileList\\\\<UserSID> registry subkey.", 1 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-WMP_12
# |
# | Modified files:
# |   *	loader/wine.inf.in
# |
if test "$enable_wine_inf_WMP_12" -eq 1; then
	patch_apply wine.inf-WMP_12/0001-wine.inf-Add-WMP-12-as-installed-windows-feature.patch
	(
		echo '+    { "Michael Müller", "wine.inf: Add WMP 12 as installed windows feature.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineboot-DriveSerial
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#17823] Assign a drive serial number during prefix creation/update
# |
# | Modified files:
# |   *	programs/wineboot/wineboot.c
# |
if test "$enable_wineboot_DriveSerial" -eq 1; then
	patch_apply wineboot-DriveSerial/0001-wineboot-Assign-a-drive-serial-number-during-prefix-.patch
	(
		echo '+    { "Sebastian Lackner", "wineboot: Assign a drive serial number during prefix creation/update.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineboot-HKEY_DYN_DATA
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#7115] Need for Speed 3 installer requires devices in HKEY_DYN_DATA
# |
# | Modified files:
# |   *	programs/wineboot/wineboot.c
# |
if test "$enable_wineboot_HKEY_DYN_DATA" -eq 1; then
	patch_apply wineboot-HKEY_DYN_DATA/0001-wineboot-Add-some-generic-hardware-in-HKEY_DYN_DATA-.patch
	(
		echo '+    { "Michael Müller", "wineboot: Add some generic hardware in HKEY_DYN_DATA\\\\Config Manager\\\\Enum.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineboot-drivers_etc_Stubs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#12076] Create stub files for system32/drivers/etc/{services,hosts,networks,protocol}
# |
# | Modified files:
# |   *	programs/wineboot/wineboot.c
# |
if test "$enable_wineboot_drivers_etc_Stubs" -eq 1; then
	patch_apply wineboot-drivers_etc_Stubs/0001-wineboot-Init-system32-drivers-etc-host-networks-pro.patch
	(
		echo '+    { "Sebastian Lackner", "wineboot: Init system32/drivers/etc/{host,networks,protocol,services}.", 1 },';
	) >> "$patchlist"
fi

# Patchset winecfg-Libraries
# |
# | Modified files:
# |   *	programs/winecfg/libraries.c
# |
if test "$enable_winecfg_Libraries" -eq 1; then
	patch_apply winecfg-Libraries/0001-winecfg-Double-click-in-dlls-list-to-edit-item-s-ove.patch
	(
		echo '+    { "Hao Peng", "winecfg: Double click in dlls list to edit item'\''s overides.", 3 },';
	) >> "$patchlist"
fi

# Patchset winecfg-Unmounted_Devices
# |
# | Modified files:
# |   *	programs/winecfg/drive.c, programs/winecfg/driveui.c
# |
if test "$enable_winecfg_Unmounted_Devices" -eq 1; then
	patch_apply winecfg-Unmounted_Devices/0001-winecfg-Show-unmounted-devices-and-allow-changing-th.patch
	(
		echo '+    { "Michael Müller", "winecfg: Show unmounted devices and allow changing the device value.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Accounting
# |
# | Modified files:
# |   *	dlls/wined3d/device.c, dlls/wined3d/directx.c, dlls/wined3d/wined3d_gl.h
# |
if test "$enable_wined3d_Accounting" -eq 1; then
	patch_apply wined3d-Accounting/0001-wined3d-Use-real-values-for-memory-accounting-on-NVI.patch
	(
		echo '+    { "Michael Müller", "wined3d: Use real values for memory accounting on NVIDIA cards.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-CSMT_Helper
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	makedep-PARENTSPEC, ntdll-DllOverrides_WOW64, ntdll-Loader_Machine_Type, ntdll-DllRedirects, wined3d-DXTn, wined3d-
# | 	resource_map
# |
# | Modified files:
# |   *	configure.ac, dlls/wined3d-csmt/Makefile.in, dlls/wined3d-csmt/version.rc, dlls/wined3d/wined3d_main.c
# |
if test "$enable_wined3d_CSMT_Helper" -eq 1; then
	patch_apply wined3d-CSMT_Helper/0001-wined3d-Add-second-dll-with-STAGING_CSMT-definition-.patch
	patch_apply wined3d-CSMT_Helper/0002-wined3d-Add-warning-that-CSMT-patchset-is-disabled.patch
	(
		echo '+    { "Sebastian Lackner", "wined3d: Add second dll with STAGING_CSMT definition set.", 1 },';
		echo '+    { "Sebastian Lackner", "wined3d: Add warning that CSMT patchset is disabled.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Geforce_425M
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35054] Add wined3d detection for GeForce GT 425M
# |
# | Modified files:
# |   *	dlls/wined3d/directx.c, dlls/wined3d/wined3d_private.h
# |
if test "$enable_wined3d_Geforce_425M" -eq 1; then
	patch_apply wined3d-Geforce_425M/0001-wined3d-Add-detection-for-NVIDIA-GeForce-425M.patch
	(
		echo '+    { "Jarkko Korpi", "wined3d: Add detection for NVIDIA GeForce 425M.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Limit_Vram
# |
# | Modified files:
# |   *	dlls/wined3d/directx.c
# |
if test "$enable_wined3d_Limit_Vram" -eq 1; then
	patch_apply wined3d-Limit_Vram/0001-wined3d-Limit-the-vram-memory-to-LONG_MAX-only-on-32.patch
	(
		echo '+    { "Michael Müller", "wined3d: Limit the vram memory to LONG_MAX only on 32 bit.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Revert_PixelFormat
# |
# | Modified files:
# |   *	dlls/d3d8/tests/device.c, dlls/d3d9/tests/device.c, dlls/ddraw/tests/ddraw1.c, dlls/ddraw/tests/ddraw2.c,
# | 	dlls/ddraw/tests/ddraw4.c, dlls/ddraw/tests/ddraw7.c, dlls/wined3d/context.c, dlls/wined3d/wined3d_private.h
# |
if test "$enable_wined3d_Revert_PixelFormat" -eq 1; then
	patch_apply wined3d-Revert_PixelFormat/0001-Revert-wined3d-Call-wglGetPixelFormat-through-the-gl.patch
	patch_apply wined3d-Revert_PixelFormat/0002-Revert-wined3d-Track-if-a-context-s-private-hdc-has-.patch
	patch_apply wined3d-Revert_PixelFormat/0003-Revert-wined3d-Track-if-a-context-s-hdc-is-private-s.patch
	patch_apply wined3d-Revert_PixelFormat/0004-Revert-wined3d-When-restoring-pixel-format-in-contex.patch
	patch_apply wined3d-Revert_PixelFormat/0005-Revert-wined3d-Don-t-call-GetPixelFormat-to-set-a-fl.patch
	patch_apply wined3d-Revert_PixelFormat/0006-Revert-wined3d-Restore-the-pixel-format-of-the-windo.patch
	patch_apply wined3d-Revert_PixelFormat/0007-d3d8-Mark-tests-which-no-longer-pass-due-to-reverts-.patch
	patch_apply wined3d-Revert_PixelFormat/0008-d3d9-Mark-tests-which-no-longer-pass-due-to-reverts-.patch
	patch_apply wined3d-Revert_PixelFormat/0009-ddraw-Mark-tests-which-no-longer-pass-due-to-reverts.patch
	(
		echo '+    { "Sebastian Lackner", "Revert \"wined3d: Call wglGetPixelFormat() through the gl_ops table.\".", 1 },';
		echo '+    { "Ken Thomases", "Revert \"wined3d: Track if a context'\''s private hdc has had its pixel format set, so we don'\''t need to check it.\".", 1 },';
		echo '+    { "Ken Thomases", "Revert \"wined3d: Track if a context'\''s hdc is private so we never need to restore its pixel format.\".", 1 },';
		echo '+    { "Ken Thomases", "Revert \"wined3d: When restoring pixel format in context_release(), mark the context as needing to be set on the next context_acquire().\".", 1 },';
		echo '+    { "Ken Thomases", "Revert \"wined3d: Don'\''t call GetPixelFormat() to set a flag that'\''s already set.\".", 1 },';
		echo '+    { "Ken Thomases", "Revert \"wined3d: Restore the pixel format of the window whose pixel format was actually changed.\".", 1 },';
		echo '+    { "Ken Thomases", "d3d8: Mark tests which no longer pass due to reverts as todo_wine.", 1 },';
		echo '+    { "Ken Thomases", "d3d9: Mark tests which no longer pass due to reverts as todo_wine.", 1 },';
		echo '+    { "Ken Thomases", "ddraw: Mark tests which no longer pass due to reverts as todo_wine.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Silence_FIXMEs
# |
# | Modified files:
# |   *	dlls/wined3d/resource.c, dlls/wined3d/state.c, dlls/wined3d/surface.c, dlls/wined3d/swapchain.c, dlls/wined3d/texture.c
# |
if test "$enable_wined3d_Silence_FIXMEs" -eq 1; then
	patch_apply wined3d-Silence_FIXMEs/0001-wined3d-Silence-repeated-Unhandled-blend-factor-0-me.patch
	patch_apply wined3d-Silence_FIXMEs/0002-wined3d-Display-FIXME-for-cmp-function-0-only-once.patch
	patch_apply wined3d-Silence_FIXMEs/0003-wined3d-Silence-repeated-resource_check_usage-FIXME.patch
	patch_apply wined3d-Silence_FIXMEs/0004-wined3d-Print-FIXME-only-once-in-surface_cpu_blt.patch
	patch_apply wined3d-Silence_FIXMEs/0005-wined3d-Silence-repeated-wined3d_swapchain_present-F.patch
	patch_apply wined3d-Silence_FIXMEs/0006-wined3d-Silence-extremely-noisy-FIXME-in-wined3d_tex.patch
	(
		echo '+    { "Sebastian Lackner", "wined3d: Silence repeated '\''Unhandled blend factor 0'\'' messages.", 1 },';
		echo '+    { "Christian Costa", "wined3d: Display FIXME for cmp function 0 only once.", 1 },';
		echo '+    { "Erich E. Hoover", "wined3d: Silence repeated resource_check_usage FIXME.", 2 },';
		echo '+    { "Christian Costa", "wined3d: Print FIXME only once in surface_cpu_blt.", 1 },';
		echo '+    { "Sebastian Lackner", "wined3d: Silence repeated wined3d_swapchain_present FIXME.", 1 },';
		echo '+    { "Sebastian Lackner", "wined3d: Silence extremely noisy FIXME in wined3d_texture_add_dirty_region.", 1 },';
	) >> "$patchlist"
fi

# Patchset winedevice-Fix_Relocation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#28254] Fix crash of winedevice when relocation entry crosses page boundary
# |
# | Modified files:
# |   *	programs/winedevice/device.c
# |
if test "$enable_winedevice_Fix_Relocation" -eq 1; then
	patch_apply winedevice-Fix_Relocation/0001-winedevice-Avoid-invalid-memory-access-when-relocati.patch
	(
		echo '+    { "Sebastian Lackner", "winedevice: Avoid invalid memory access when relocation block addresses memory outside of the current page.", 1 },';
	) >> "$patchlist"
fi

# Patchset winemenubuilder-Desktop_Icon_Path
# |
# | Modified files:
# |   *	programs/winemenubuilder/Makefile.in, programs/winemenubuilder/winemenubuilder.c
# |
if test "$enable_winemenubuilder_Desktop_Icon_Path" -eq 1; then
	patch_apply winemenubuilder-Desktop_Icon_Path/0001-winemenubuilder-Create-desktop-shortcuts-with-absolu.patch
	(
		echo '+    { "Sebastian Lackner", "winemenubuilder: Create desktop shortcuts with absolute wine path.", 1 },';
	) >> "$patchlist"
fi

# Patchset winepulse-PulseAudio_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37042] Implement exclusive mode in PulseAudio backend
# |
# | Modified files:
# |   *	dlls/winepulse.drv/Makefile.in, dlls/winepulse.drv/mmdevdrv.c
# |
if test "$enable_winepulse_PulseAudio_Support" -eq 1; then
	patch_apply winepulse-PulseAudio_Support/0001-winepulse.drv-Use-a-separate-mainloop-and-ctx-for-pu.patch
	patch_apply winepulse-PulseAudio_Support/0002-winepulse-expose-audio-devices-directly-to-programs.patch
	patch_apply winepulse-PulseAudio_Support/0003-winepulse-implement-exclusive-mode.patch
	patch_apply winepulse-PulseAudio_Support/0004-winepulse-fix-segfault-in-pulse_rd_loop.patch
	patch_apply winepulse-PulseAudio_Support/0005-winepulse-implement-GetPropValue.patch
	patch_apply winepulse-PulseAudio_Support/0006-winepulse-fetch-actual-program-name-if-possible.patch
	patch_apply winepulse-PulseAudio_Support/0007-winepulse-return-PKEY_AudioEndpoint_PhysicalSpeakers.patch
	(
		echo '+    { "Sebastian Lackner", "winepulse.drv: Use a separate mainloop and ctx for pulse_test_connect.", 1 },';
		echo '+    { "Mark Harmstone", "winepulse: Expose audio devices directly to programs.", 1 },';
		echo '+    { "Mark Harmstone", "winepulse: Implement exclusive mode.", 1 },';
		echo '+    { "Mark Harmstone", "winepulse: Fix segfault in pulse_rd_loop.", 1 },';
		echo '+    { "Mark Harmstone", "winepulse: Implement GetPropValue.", 1 },';
		echo '+    { "Mark Harmstone", "winepulse: Fetch actual program name if possible.", 1 },';
		echo '+    { "Mark Harmstone", "winepulse: Return PKEY_AudioEndpoint_PhysicalSpeakers device prop.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-CandidateWindowPos
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30938] Update a XIM candidate position when cursor location changes
# |
# | Modified files:
# |   *	dlls/user32/caret.c, dlls/user32/driver.c, dlls/user32/user_private.h, dlls/winex11.drv/winex11.drv.spec,
# | 	dlls/winex11.drv/xim.c
# |
if test "$enable_winex11_CandidateWindowPos" -eq 1; then
	patch_apply winex11-CandidateWindowPos/0001-winex11.drv-Update-a-candidate-window-s-position-wit.patch
	(
		echo '+    { "Felix Yan", "winex11.drv: Update a candidate window'\''s position with over-the-spot style.", 2 },';
	) >> "$patchlist"
fi

# Patchset winex11-Clipboard_HTML
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#7372] Support for pasting HTML from Unix applications
# |
# | Modified files:
# |   *	dlls/winex11.drv/clipboard.c
# |
if test "$enable_winex11_Clipboard_HTML" -eq 1; then
	patch_apply winex11-Clipboard_HTML/0001-winex11.drv-Import-X11-s-text-html-as-HTML-Format.patch
	(
		echo '+    { "Damjan Jovanovic", "winex11.drv: Import X11'\''s \"text/html\" as \"HTML Format\".", 3 },';
	) >> "$patchlist"
fi

# Patchset winex11-DefaultDisplayFrequency
# |
# | Modified files:
# |   *	dlls/winex11.drv/settings.c, dlls/winex11.drv/x11drv.h, dlls/winex11.drv/x11drv_main.c
# |
if test "$enable_winex11_DefaultDisplayFrequency" -eq 1; then
	patch_apply winex11-DefaultDisplayFrequency/0001-winex11.drv-Allow-to-select-default-display-frequenc.patch
	(
		echo '+    { "Michael Müller", "winex11.drv: Allow to select default display frequency in registry key.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-Desktop_Resolution
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32979] Allow 320x240 as supported resolution in desktop mode
# |
# | Modified files:
# |   *	dlls/winex11.drv/desktop.c
# |
if test "$enable_winex11_Desktop_Resolution" -eq 1; then
	patch_apply winex11-Desktop_Resolution/0001-winex11-Add-320x240-as-supported-resolution-in-deskt.patch
	(
		echo '+    { "Michael Müller", "winex11: Add 320x240 as supported resolution in desktop mode.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-Window_Groups
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32699] Prevent window managers from grouping all wine programs together
# |
# | Modified files:
# |   *	dlls/winex11.drv/window.c
# |
if test "$enable_winex11_Window_Groups" -eq 1; then
	patch_apply winex11-Window_Groups/0001-winex11-Prevent-window-managers-from-grouping-all-wi.patch
	(
		echo '+    { "Michael Müller", "winex11: Prevent window managers from grouping all wine programs together.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-Window_Style
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37876] Fix handling of window attributes for WS_EX_LAYERED | WS_EX_COMPOSITED
# |
# | Modified files:
# |   *	dlls/winex11.drv/window.c
# |
if test "$enable_winex11_Window_Style" -eq 1; then
	patch_apply winex11-Window_Style/0001-winex11-Fix-handling-of-window-attributes-for-WS_EX_.patch
	(
		echo '+    { "Dmitry Timoshkov", "winex11: Fix handling of window attributes for WS_EX_LAYERED | WS_EX_COMPOSITED.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-XEMBED
# |
# | Modified files:
# |   *	dlls/winex11.drv/event.c
# |
if test "$enable_winex11_XEMBED" -eq 1; then
	patch_apply winex11-XEMBED/0001-winex11-Enable-disable-windows-when-they-are-un-mapped.patch
	(
		echo '+    { "Sebastian Lackner", "winex11: Enable/disable windows when they are (un)mapped by foreign applications.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-_NET_ACTIVE_WINDOW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#2155] Forward activate window requests to WM using _NET_ACTIVE_WINDOW
# |
# | Modified files:
# |   *	dlls/user32/driver.c, dlls/user32/focus.c, dlls/user32/user_private.h, dlls/winex11.drv/event.c,
# | 	dlls/winex11.drv/window.c, dlls/winex11.drv/winex11.drv.spec, dlls/winex11.drv/x11drv.h, dlls/winex11.drv/x11drv_main.c
# |
if test "$enable_winex11__NET_ACTIVE_WINDOW" -eq 1; then
	patch_apply winex11-_NET_ACTIVE_WINDOW/0001-winex11.drv-Add-support-for-_NET_ACTIVE_WINDOW.patch
	(
		echo '+    { "Dmitry Timoshkov", "winex11.drv: Add support for _NET_ACTIVE_WINDOW.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-wglShareLists
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#11436] Do not fail when a used context is passed to wglShareLists
# |   *	[#25419] Fix broken textures in XIII Century: Death or Glory
# |
# | Modified files:
# |   *	dlls/winex11.drv/opengl.c
# |
if test "$enable_winex11_wglShareLists" -eq 1; then
	patch_apply winex11-wglShareLists/0001-winex11.drv-Only-warn-about-used-contexts-in-wglShar.patch
	(
		echo '+    { "Michael Müller", "winex11.drv: Only warn about used contexts in wglShareLists.", 1 },';
	) >> "$patchlist"
fi

# Patchset winhttp-System_Proxy_Autoconfig
# |
# | Modified files:
# |   *	dlls/winhttp/session.c, dlls/wininet/internet.c
# |
if test "$enable_winhttp_System_Proxy_Autoconfig" -eq 1; then
	patch_apply winhttp-System_Proxy_Autoconfig/0001-winhttp-Silence-repeated-no-support-on-this-platform.patch
	patch_apply winhttp-System_Proxy_Autoconfig/0002-wininet-Silence-wininet-no-support-on-this-platform-.patch
	(
		echo '+    { "Jarkko Korpi", "winhttp: Silence repeated \"no support on this platform\" message.", 1 },';
		echo '+    { "Jarkko Korpi", "wininet: Silence wininet no support on this platform message.", 1 },';
	) >> "$patchlist"
fi

# Patchset wininet-Cleanup
# |
# | Modified files:
# |   *	dlls/wininet/http.c, dlls/wininet/tests/http.c
# |
if test "$enable_wininet_Cleanup" -eq 1; then
	patch_apply wininet-Cleanup/0001-wininet-tests-Add-more-tests-for-cookies.patch
	patch_apply wininet-Cleanup/0002-wininet-tests-Test-auth-credential-reusage-with-host.patch
	patch_apply wininet-Cleanup/0003-wininet-tests-Check-cookie-behaviour-when-overriding.patch
	patch_apply wininet-Cleanup/0004-wininet-Strip-filename-if-no-path-is-set-in-cookie.patch
	patch_apply wininet-Cleanup/0005-wininet-Replacing-header-fields-should-fail-if-they-.patch
	(
		echo '+    { "Michael Müller", "wininet/tests: Add more tests for cookies.", 1 },';
		echo '+    { "Michael Müller", "wininet/tests: Test auth credential reusage with host override.", 1 },';
		echo '+    { "Michael Müller", "wininet/tests: Check cookie behaviour when overriding host.", 1 },';
		echo '+    { "Michael Müller", "wininet: Strip filename if no path is set in cookie.", 1 },';
		echo '+    { "Michael Müller", "wininet: Replacing header fields should fail if they do not exist yet.", 1 },';
	) >> "$patchlist"
fi

# Patchset wininet-HttpOpenRequestW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40169] Fix handling of INTERNET_INVALID_PORT_NUMBER in HttpOpenRequestW
# |
# | Modified files:
# |   *	dlls/wininet/http.c, dlls/wininet/tests/http.c
# |
if test "$enable_wininet_HttpOpenRequestW" -eq 1; then
	patch_apply wininet-HttpOpenRequestW/0001-wininet-Set-default-HTTP-port-correctly-when-passing.patch
	(
		echo '+    { "Michael Müller", "wininet: Set default HTTP port correctly when passing INTERNET_FLAG_SECURE to InternetConnect.", 1 },';
	) >> "$patchlist"
fi

# Patchset wininet-Internet_Settings
# |
# | Modified files:
# |   *	dlls/wininet/internet.c, dlls/wininet/tests/internet.c
# |
if test "$enable_wininet_Internet_Settings" -eq 1; then
	patch_apply wininet-Internet_Settings/0001-wininet-Allow-INTERNET_OPTION_SETTINGS_CHANGED-on-co.patch
	patch_apply wininet-Internet_Settings/0002-wininet-Add-support-for-INTERNET_OPTION_SETTINGS_CHA.patch
	(
		echo '+    { "Michael Müller", "wininet: Allow INTERNET_OPTION_SETTINGS_CHANGED on connections.", 1 },';
		echo '+    { "Michael Müller", "wininet: Add support for INTERNET_OPTION_SETTINGS_CHANGED in InternetSetOption.", 1 },';
	) >> "$patchlist"
fi

# Patchset wininet-ParseX509EncodedCertificateForListBoxEntry
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29842] Add stub for wininet.ParseX509EncodedCertificateForListBoxEntry
# |
# | Modified files:
# |   *	dlls/wininet/dialogs.c, dlls/wininet/wininet.spec, include/winineti.h
# |
if test "$enable_wininet_ParseX509EncodedCertificateForListBoxEntry" -eq 1; then
	patch_apply wininet-ParseX509EncodedCertificateForListBoxEntry/0001-wininet-add-ParseX509EncodedCertificateForListBoxEnt.patch
	(
		echo '+    { "Austin English", "wininet: Add ParseX509EncodedCertificateForListBoxEntry stub.", 2 },';
	) >> "$patchlist"
fi

# Patchset winmm-Delay_Import_Depends
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37983] Jedi Knight: Dark Forces II crashes with winmm set to native
# |
# | Modified files:
# |   *	dlls/winmm/Makefile.in
# |
if test "$enable_winmm_Delay_Import_Depends" -eq 1; then
	patch_apply winmm-Delay_Import_Depends/0001-winmm-Delay-import-ole32-msacm32-to-workaround-bug-w.patch
	(
		echo '+    { "Michael Müller", "winmm: Delay import ole32 msacm32 to workaround bug when loading multiple winmm versions.", 1 },';
	) >> "$patchlist"
fi

# Patchset winmm-mciSendCommandA
# |
# | Modified files:
# |   *	dlls/winmm/mci.c
# |
if test "$enable_winmm_mciSendCommandA" -eq 1; then
	patch_apply winmm-mciSendCommandA/0001-winmm-Do-not-crash-in-Win-9X-mode-when-an-invalid-de.patch
	(
		echo '+    { "Michael Müller", "winmm: Do not crash in Win 9X mode when an invalid device ptr is passed to MCI_OPEN.", 1 },';
	) >> "$patchlist"
fi

# Patchset winspool.drv-SetPrinterW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24645] Add stub for winspool.SetPrinterW level 8
# |
# | Modified files:
# |   *	dlls/winspool.drv/info.c
# |
if test "$enable_winspool_drv_SetPrinterW" -eq 1; then
	patch_apply winspool.drv-SetPrinterW/0001-winspool.drv-Add-case-8-for-SetPrinterW.patch
	(
		echo '+    { "Jarkko Korpi", "winspool.drv Add case 8 for SetPrinterW.", 1 },';
	) >> "$patchlist"
fi

# Patchset winsta-WinStationEnumerateW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38102] Add stub for winsta.WinStationEnumerateW
# |
# | Modified files:
# |   *	dlls/winsta/main.c, dlls/winsta/winsta.spec
# |
if test "$enable_winsta_WinStationEnumerateW" -eq 1; then
	patch_apply winsta-WinStationEnumerateW/0001-winsta-Add-stub-for-WinStationEnumerateW.patch
	(
		echo '+    { "Austin English", "winsta: Add stub for WinStationEnumerateW.", 2 },';
	) >> "$patchlist"
fi

# Patchset wintrust-WinVerifyTrust
# |
# | Modified files:
# |   *	dlls/wintrust/softpub.c, dlls/wintrust/tests/softpub.c
# |
if test "$enable_wintrust_WinVerifyTrust" -eq 1; then
	patch_apply wintrust-WinVerifyTrust/0001-wintrust-tests-Add-tests-for-WinVerifyTrust.-v2.patch
	patch_apply wintrust-WinVerifyTrust/0002-wintrust-tests-Add-some-additional-tests.patch
	patch_apply wintrust-WinVerifyTrust/0003-wintrust-Verify-image-hash-in-WinVerifyTrust.patch
	(
		echo '+    { "Mark Jansen", "wintrust/tests: Add tests for WinVerifyTrust.", 2 },';
		echo '+    { "Sebastian Lackner", "wintrust/tests: Add some additional tests.", 1 },';
		echo '+    { "Mark Jansen", "wintrust: Verify image hash in WinVerifyTrust.", 1 },';
	) >> "$patchlist"
fi

# Patchset wpcap-Several_Fixes
# |
# | Modified files:
# |   *	dlls/wpcap/wpcap.c, dlls/wpcap/wpcap.spec
# |
if test "$enable_wpcap_Several_Fixes" -eq 1; then
	patch_apply wpcap-Several_Fixes/0001-wpcap-Implement-pcap_dump_open-and-pcap_dump.patch
	(
		echo '+    { "Jianqiu Zhang", "wpcap: Implement pcap_dump_open and pcap_dump.", 1 },';
	) >> "$patchlist"
fi

# Patchset wpcap-Dynamic_Linking
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	wpcap-Several_Fixes
# |
# | Modified files:
# |   *	configure.ac, dlls/wpcap/Makefile.in, dlls/wpcap/wpcap.c
# |
if test "$enable_wpcap_Dynamic_Linking" -eq 1; then
	patch_apply wpcap-Dynamic_Linking/0001-wpcap-Load-libpcap-dynamically.patch
	(
		echo '+    { "André Hentschel", "wpcap: Load libpcap dynamically.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-APC_Performance
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c
# |
if test "$enable_ws2_32_APC_Performance" -eq 1; then
	patch_apply ws2_32-APC_Performance/0001-ws2_32-Reuse-old-async-ws2_async_io-structures-if-po.patch
	(
		echo '+    { "Sebastian Lackner", "ws2_32: Reuse old async ws2_async_io structures if possible.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-Connect_Time
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c, server/protocol.def, server/sock.c
# |
if test "$enable_ws2_32_Connect_Time" -eq 1; then
	patch_apply ws2_32-Connect_Time/0001-ws2_32-Implement-returning-the-proper-time-with-SO_C.patch
	(
		echo '+    { "Sebastian Lackner", "ws2_32: Implement returning the proper time with SO_CONNECT_TIME.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-DisconnectEx
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c
# |
if test "$enable_ws2_32_DisconnectEx" -eq 1; then
	patch_apply ws2_32-DisconnectEx/0001-ws2_32-tests-Add-tests-for-DisconnectEx.patch
	patch_apply ws2_32-DisconnectEx/0002-ws2_32-Add-semi-stub-for-DisconnectEx.patch
	(
		echo '+    { "Michael Müller", "ws2_32/tests: Add tests for DisconnectEx.", 1 },';
		echo '+    { "Michael Müller", "ws2_32: Add semi-stub for DisconnectEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-Sort_default_route
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22819] Ensure default route IP addresses are returned first in gethostbyname
# |   *	[#37271] Fix issue causing applications to report magic loopback address instead of real IP
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c
# |
if test "$enable_ws2_32_Sort_default_route" -eq 1; then
	patch_apply ws2_32-Sort_default_route/0001-ws2_32-Ensure-default-route-IP-addresses-are-returne.patch
	(
		echo '+    { "Bruno Jesus", "ws2_32: Ensure default route IP addresses are returned first in gethostbyname.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-TransmitFile
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-Desktop_Refcount
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c, include/winsock.h, server/protocol.def, server/sock.c
# |
if test "$enable_ws2_32_TransmitFile" -eq 1; then
	patch_apply ws2_32-TransmitFile/0001-ws2_32-Add-support-for-TF_DISCONNECT-to-TransmitFile.patch
	patch_apply ws2_32-TransmitFile/0002-ws2_32-Add-support-for-TF_REUSE_SOCKET-to-TransmitFi.patch
	(
		echo '+    { "Erich E. Hoover", "ws2_32: Add support for TF_DISCONNECT to TransmitFile.", 1 },';
		echo '+    { "Erich E. Hoover", "ws2_32: Add support for TF_REUSE_SOCKET to TransmitFile.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-WSACleanup
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-Desktop_Refcount
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#18670] Properly close sockets when WSACleanup is called
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/server.c, dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c, include/wine/server.h,
# | 	server/protocol.def, server/sock.c
# |
if test "$enable_ws2_32_WSACleanup" -eq 1; then
	patch_apply ws2_32-WSACleanup/0001-ws2_32-Proper-WSACleanup-implementation-using-winese.patch
	patch_apply ws2_32-WSACleanup/0002-ws2_32-Invalidate-client-side-file-descriptor-cache-.patch
	(
		echo '+    { "Matt Durgavich", "ws2_32: Proper WSACleanup implementation using wineserver function.", 2 },';
		echo '+    { "Sebastian Lackner", "ws2_32: Invalidate client-side file descriptor cache in WSACleanup.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-getaddrinfo
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c
# |
if test "$enable_ws2_32_getaddrinfo" -eq 1; then
	patch_apply ws2_32-getaddrinfo/0001-ws2_32-Ignore-socket-type-for-protocol-IPPROTO_IPV6-.patch
	(
		echo '+    { "Michael Müller", "ws2_32: Ignore socket type for protocol IPPROTO_IPV6 in getaddrinfo.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-getsockopt
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8606] Divide values returned by SO_RCVBUF and SO_SNDBUF getsockopt options by two
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c
# |
if test "$enable_ws2_32_getsockopt" -eq 1; then
	patch_apply ws2_32-getsockopt/0001-ws2_32-Divide-values-returned-by-SO_RCVBUF-and-SO_SN.patch
	(
		echo '+    { "Sebastian Lackner", "ws2_32: Divide values returned by SO_RCVBUF and SO_SNDBUF getsockopt options by two.", 1 },';
	) >> "$patchlist"
fi

# Patchset wtsapi32-EnumerateProcesses
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29903] Support for WTSEnumerateProcessesW
# |
# | Modified files:
# |   *	dlls/wtsapi32/tests/wtsapi.c, dlls/wtsapi32/wtsapi32.c
# |
if test "$enable_wtsapi32_EnumerateProcesses" -eq 1; then
	patch_apply wtsapi32-EnumerateProcesses/0001-wtsapi32-Partial-implementation-of-WTSEnumerateProce.patch
	(
		echo '+    { "Sebastian Lackner", "wtsapi32: Partial implementation of WTSEnumerateProcessesW.", 1 },';
	) >> "$patchlist"
fi

# Patchset wtsapi32-WTSQueryUserToken
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39663] Improve WTSQueryUserToken stub to make GOG Galaxy happy
# |
# | Modified files:
# |   *	dlls/wtsapi32/wtsapi32.c
# |
if test "$enable_wtsapi32_WTSQueryUserToken" -eq 1; then
	patch_apply wtsapi32-WTSQueryUserToken/0001-wtsapi32-Improve-WTSQueryUserToken-stub.patch
	(
		echo '+    { "Sebastian Lackner", "wtsapi32: Improve WTSQueryUserToken stub.", 2 },';
	) >> "$patchlist"
fi

# Patchset wuauserv-Dummy_Service
# |
# | Modified files:
# |   *	configure.ac, loader/wine.inf.in, programs/wuauserv/Makefile.in, programs/wuauserv/main.c
# |
if test "$enable_wuauserv_Dummy_Service" -eq 1; then
	patch_apply wuauserv-Dummy_Service/0001-wuauserv-Add-dummy-service.patch
	(
		echo '+    { "Michael Müller", "wuauserv: Add dummy service.", 1 },';
	) >> "$patchlist"
fi

# Patchset wusa-MSU_Package_Installer
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#26757] Initial implementation of wusa.exe (MSU package installer)
# |
# | Modified files:
# |   *	programs/wusa/Makefile.in, programs/wusa/main.c, programs/wusa/manifest.c, programs/wusa/wusa.h
# |
if test "$enable_wusa_MSU_Package_Installer" -eq 1; then
	patch_apply wusa-MSU_Package_Installer/0001-wusa-Implement-basic-installation-logic.patch
	patch_apply wusa-MSU_Package_Installer/0002-wusa-Ignore-systemProtection-subkey-of-registry-key.patch
	patch_apply wusa-MSU_Package_Installer/0003-wusa-Treat-empty-update-list-as-error.patch
	patch_apply wusa-MSU_Package_Installer/0004-wusa-Implement-WOW64-support.patch
	patch_apply wusa-MSU_Package_Installer/0005-wusa-Add-workaround-to-be-compatible-with-Vista-pack.patch
	patch_apply wusa-MSU_Package_Installer/0006-wusa-Improve-tracing-of-installation-process.patch
	patch_apply wusa-MSU_Package_Installer/0007-wusa-Print-warning-when-encountering-msdelta-compres.patch
	(
		echo '+    { "Michael Müller", "wusa: Implement basic installation logic.", 1 },';
		echo '+    { "Michael Müller", "wusa: Ignore systemProtection subkey of registry key.", 1 },';
		echo '+    { "Michael Müller", "wusa: Treat empty update list as error.", 1 },';
		echo '+    { "Michael Müller", "wusa: Implement WOW64 support.", 1 },';
		echo '+    { "Sebastian Lackner", "wusa: Add workaround to be compatible with Vista packages.", 1 },';
		echo '+    { "Sebastian Lackner", "wusa: Improve tracing of installation process.", 1 },';
		echo '+    { "Michael Müller", "wusa: Print warning when encountering msdelta compressed files.", 1 },';
	) >> "$patchlist"
fi


if test "$enable_patchlist" -eq 1; then

	# Generate a temporary patch containing the patchlist and apply it
	patch_data=$(cat "$patchlist" | sort)
	if test ! -z "$patch_data"; then
		patch_lines=$(echo "$patch_data" | wc -l)
		patch_lines=$((${patch_lines}+21))
		cat > "$patchlist" <<EOF
From: Wine Staging Team <webmaster@fds-team.de>
Subject: Autogenerated patch list.

diff --git a/libs/wine/config.c b/libs/wine/config.c
index 5262c76..0a3182f 100644
--- a/libs/wine/config.c
+++ b/libs/wine/config.c
@@ -478,10 +478,${patch_lines} @@ const char *wine_get_version(void)
     return PACKAGE_VERSION;
 }
 
+static const struct
+{
+    const char *author;
+    const char *subject;
+    int revision;
+}
+wine_patch_data[] =
+{
${patch_data}
+    { NULL, NULL, 0 }
+};
+
 /* return the applied non-standard patches */
 const void *wine_get_patches(void)
 {
-    return NULL;
+    return &wine_patch_data[0];
 }
 
 /* return the build id string */
EOF
		patch_apply_file "$patchlist"
	fi
	rm "$patchlist"
fi

if test "$enable_autoconf" -eq 1; then
	if ! update_configure; then
		abort "'autoreconf -f' failed."
	fi
	if ! update_protocol; then
		abort "'./tools/make_requests' failed."
	fi
fi
# Success
exit 0
