#!/bin/sh
#
# Script to automatically install all Wine Staging patches
#
# Copyright (C) 2015-2017 Sebastian Lackner
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#

# Show usage information
usage()
{
	echo ""
	echo "Usage: ./patchinstall.sh [DESTDIR=path] [--all] [-W patchset] [patchset ...]"
	echo ""
	echo "Autogenerated script to apply all Wine Staging patches on your Wine"
	echo "source tree."
	echo ""
	echo "Configuration:"
	echo "  DESTDIR=path         Specify the path to the wine source tree"
	echo "  --all                Select all patches"
	echo "  --force-autoconf     Run autoreconf and tools/make_requests after each patch"
	echo "  --help               Display this help and exit"
	echo "  --no-autoconf        Do not run autoreconf and tools/make_requests"
	echo "  --no-patchlist       Do not apply patchlist (needed for 'wine --patches')"
	echo "  --upstream-commit    Print the upstream Wine commit SHA1 and exit"
	echo "  --version            Show version information and exit"
	echo "  -W patchset          Exclude a specific patchset"
	echo ""
	echo "Backends:"
	echo "  --backend=patch      Use regular 'patch' utility to apply patches (default)"
	echo "  --backend=eapply     Use 'eapply' to apply patches (Gentoo only)"
	echo "  --backend=epatch     Use 'epatch' to apply patches (Gentoo only, deprecated)"
	echo "  --backend=git-am     Use 'git am' to apply patches"
	echo "  --backend=git-apply  Use 'git apply' to apply patches"
	echo "  --backend=stg        Import the patches using stacked git"
	echo ""
}

# Get the upstream commit sha
upstream_commit()
{
	echo "53290d2ec483006656987352d53842ffc1852c91"
}

# Show version information
version()
{
	echo "Wine Staging 2.21"
	echo "Copyright (C) 2014-2017 the Wine Staging project authors."
	echo ""
	echo "Patchset to be applied on upstream Wine:"
	echo "  commit $(upstream_commit)"
	echo ""
}

# Critical error, abort
abort()
{
	printf '%s\n' "ERROR: $1" >&2
	exit 1
}

# Show a warning
warning()
{
	printf '%s\n' "WARNING: $1" >&2
}

# Enable or disable all patchsets
patch_enable_all ()
{
	enable_Compiler_Warnings="$1"
	enable_Coverity="$1"
	enable_Pipelight="$1"
	enable_Staging="$1"
	enable_advapi_LsaLookupPrivilegeName="$1"
	enable_advapi32_BuildSecurityDescriptor="$1"
	enable_advapi32_CreateRestrictedToken="$1"
	enable_advapi32_GetExplicitEntriesFromAclW="$1"
	enable_advapi32_LsaLookupSids="$1"
	enable_advapi32_Performance_Counters="$1"
	enable_advapi32_SetSecurityInfo="$1"
	enable_advapi32_Token_Integrity_Level="$1"
	enable_advapi32_WinBuiltinAnyPackageSid="$1"
	enable_api_ms_win_Stub_DLLs="$1"
	enable_avifil32_AVIFile_Proxies="$1"
	enable_avifil32_IGetFrame_fnSetFormat="$1"
	enable_avifile_dll16_AVIStreamGetFrame="$1"
	enable_bcrypt_Improvements="$1"
	enable_browseui_Progress_Dialog="$1"
	enable_combase_RoApi="$1"
	enable_comctl32_Button_Theming="$1"
	enable_comctl32_Listview_DrawItem="$1"
	enable_comctl32_TTM_ADDTOOLW="$1"
	enable_comctl32_Tests="$1"
	enable_comdlg32_lpstrFileTitle="$1"
	enable_configure_Absolute_RPATH="$1"
	enable_crypt32_CMS_Certificates="$1"
	enable_crypt32_Certificate_Check="$1"
	enable_crypt32_CryptUnprotectMemory="$1"
	enable_crypt32_ECDSA_Cert_Chains="$1"
	enable_crypt32_MS_Root_Certs="$1"
	enable_crypt32_SHA_OIDs="$1"
	enable_d3d10_1_Forwards="$1"
	enable_d3d11_Deferred_Context="$1"
	enable_d3d11_Depth_Bias="$1"
	enable_d3d11_ID3D11Texture1D="$1"
	enable_d3d11_ResolveSubresource="$1"
	enable_d3d11_Silence_FIXMEs="$1"
	enable_d3d8_ValidateShader="$1"
	enable_d3d9_DesktopWindow="$1"
	enable_d3d9_Tests="$1"
	enable_d3dx9_25_ID3DXEffect="$1"
	enable_d3dx9_36_32bpp_Alpha_Channel="$1"
	enable_d3dx9_36_BumpLuminance="$1"
	enable_d3dx9_36_CloneEffect="$1"
	enable_d3dx9_36_D3DXCreateTeapot="$1"
	enable_d3dx9_36_D3DXDisassembleShader="$1"
	enable_d3dx9_36_D3DXOptimizeVertices="$1"
	enable_d3dx9_36_D3DXStubs="$1"
	enable_d3dx9_36_DDS="$1"
	enable_d3dx9_36_DXTn="$1"
	enable_d3dx9_36_DrawText="$1"
	enable_d3dx9_36_Dummy_Skininfo="$1"
	enable_d3dx9_36_Filter_Warnings="$1"
	enable_d3dx9_36_FindNextValidTechnique="$1"
	enable_d3dx9_36_GetShaderSemantics="$1"
	enable_d3dx9_36_Optimize_Inplace="$1"
	enable_d3dx9_36_Tests="$1"
	enable_d3dx9_36_Texture_Align="$1"
	enable_d3dx9_36_UpdateSkinnedMesh="$1"
	enable_dbghelp_Debug_Symbols="$1"
	enable_ddraw_D3DFINDDEVICERESULT="$1"
	enable_ddraw_Device_Caps="$1"
	enable_ddraw_EnumSurfaces="$1"
	enable_ddraw_Fix_Typos="$1"
	enable_ddraw_FlipToGDISurface="$1"
	enable_ddraw_IDirect3DTexture2_Load="$1"
	enable_ddraw_Rendering_Targets="$1"
	enable_ddraw_Silence_FIXMEs="$1"
	enable_ddraw_Write_Vtable="$1"
	enable_devenum_AudioCompressorCategory="$1"
	enable_dinput_Deadlock="$1"
	enable_dinput_Initialize="$1"
	enable_dsound_EAX="$1"
	enable_dsound_Fast_Mixer="$1"
	enable_dsound_Revert_Cleanup="$1"
	enable_dwmapi_DwmSetIcon="$1"
	enable_dxdiag_dontskip="$1"
	enable_dxdiagn_Display_Information="$1"
	enable_dxdiagn_Enumerate_DirectSound="$1"
	enable_dxdiagn_GetChildContainer_Leaf_Nodes="$1"
	enable_dxgi_DXGI_PRESENT_TEST="$1"
	enable_dxgi_GammaRamp="$1"
	enable_dxgi_MakeWindowAssociation="$1"
	enable_dxva2_Video_Decoder="$1"
	enable_explorer_Video_Registry_Key="$1"
	enable_fonts_Missing_Fonts="$1"
	enable_fonts_Tahoma="$1"
	enable_fsutil_Stub_Program="$1"
	enable_gdi32_GetCharacterPlacement="$1"
	enable_gdi32_Lazy_Font_Initialization="$1"
	enable_gdi32_MultiMonitor="$1"
	enable_gdi32_Path_Metafile="$1"
	enable_gdi32_Symbol_Truetype_Font="$1"
	enable_gdiplus_Performance_Improvements="$1"
	enable_hal_KeQueryPerformanceCounter="$1"
	enable_hnetcfg_INetFwAuthorizedApplication="$1"
	enable_ieframe_IViewObject_Draw="$1"
	enable_imagehlp_BindImageEx="$1"
	enable_imagehlp_Cleanup="$1"
	enable_imagehlp_ImageLoad="$1"
	enable_imm32_IMMDisableLegacyIME="$1"
	enable_include_winsock="$1"
	enable_inseng_Implementation="$1"
	enable_iphlpapi_System_Ping="$1"
	enable_iphlpapi_TCP_Table="$1"
	enable_kernel32_COMSPEC="$1"
	enable_kernel32_CopyFileEx="$1"
	enable_kernel32_Cwd_Startup_Info="$1"
	enable_kernel32_Debugger="$1"
	enable_kernel32_FindFirstFile="$1"
	enable_kernel32_GetShortPathName="$1"
	enable_kernel32_Job_Tests="$1"
	enable_kernel32_K32GetPerformanceInfo="$1"
	enable_kernel32_LocaleNameToLCID="$1"
	enable_kernel32_MODULE_get_binary_info="$1"
	enable_kernel32_Misalign_Workaround="$1"
	enable_kernel32_MoveFile="$1"
	enable_kernel32_NeedCurrentDirectoryForExePath="$1"
	enable_kernel32_PE_Loader_Fixes="$1"
	enable_kernel32_Processor_Group="$1"
	enable_kernel32_Profile="$1"
	enable_kernel32_SCSI_Sysfs="$1"
	enable_kernel32_SetFileCompletionNotificationModes="$1"
	enable_kernel32_TRUST_E_NOSIGNATURE="$1"
	enable_kernel32_Tests="$1"
	enable_kernel32_TimezoneInformation_Registry="$1"
	enable_kernel32_UmsStubs="$1"
	enable_kernel32_VerifyVersionInfo="$1"
	enable_kernelbase_PathCchCombineEx="$1"
	enable_krnl386_exe16_GDT_LDT_Emulation="$1"
	enable_krnl386_exe16_Invalid_Console_Handles="$1"
	enable_krnl386_exe16__lclose16="$1"
	enable_libs_Debug_Channel="$1"
	enable_libs_Unicode_Collation="$1"
	enable_loader_OSX_Preloader="$1"
	enable_makedep_PARENTSPEC="$1"
	enable_mmsystem_dll16_MIDIHDR_Refcount="$1"
	enable_mountmgr_DosDevices="$1"
	enable_mpr_WNetGetUniversalNameW="$1"
	enable_mscoree_CorValidateImage="$1"
	enable_mshtml_HTMLLocation_put_hash="$1"
	enable_msi_Dummy_Thread="$1"
	enable_msi_MsiGetDatabaseState="$1"
	enable_msi_msi_vcl_get_cost="$1"
	enable_msidb_Implementation="$1"
	enable_msvcr120__SetWinRTOutOfMemoryExceptionCallback="$1"
	enable_msvcrt_Math_Precision="$1"
	enable_msvfw32_ICGetDisplayFormat="$1"
	enable_msxml3_Normalize_Data="$1"
	enable_ntdll_APC_Performance="$1"
	enable_ntdll_APC_Start_Process="$1"
	enable_ntdll_Activation_Context="$1"
	enable_ntdll_ApiSetMap="$1"
	enable_ntdll_ApiSetQueryApiSetPresence="$1"
	enable_ntdll_Attach_Process_DLLs="$1"
	enable_ntdll_Builtin_Prot="$1"
	enable_ntdll_CLI_Images="$1"
	enable_ntdll_CriticalSection="$1"
	enable_ntdll_DOS_Area="$1"
	enable_ntdll_DOS_Attributes="$1"
	enable_ntdll_Dealloc_Thread_Stack="$1"
	enable_ntdll_DeviceType_Systemroot="$1"
	enable_ntdll_DllOverrides_WOW64="$1"
	enable_ntdll_DllRedirects="$1"
	enable_ntdll_Exception="$1"
	enable_ntdll_FileDispositionInformation="$1"
	enable_ntdll_FileFsFullSizeInformation="$1"
	enable_ntdll_FileFsVolumeInformation="$1"
	enable_ntdll_FileNameInformation="$1"
	enable_ntdll_Fix_Alignment="$1"
	enable_ntdll_HashLinks="$1"
	enable_ntdll_Heap_Improvements="$1"
	enable_ntdll_Hide_Wine_Exports="$1"
	enable_ntdll_Interrupt_0x2e="$1"
	enable_ntdll_Junction_Points="$1"
	enable_ntdll_LDR_MODULE="$1"
	enable_ntdll_LdrGetDllHandle="$1"
	enable_ntdll_LdrRegisterDllNotification="$1"
	enable_ntdll_Loader_Machine_Type="$1"
	enable_ntdll_NtAccessCheck="$1"
	enable_ntdll_NtAllocateUuids="$1"
	enable_ntdll_NtContinue="$1"
	enable_ntdll_NtCreateThreadEx="$1"
	enable_ntdll_NtDevicePath="$1"
	enable_ntdll_NtQueryEaFile="$1"
	enable_ntdll_NtQuerySection="$1"
	enable_ntdll_NtQueryVirtualMemory="$1"
	enable_ntdll_NtSetInformationToken="$1"
	enable_ntdll_NtSetLdtEntries="$1"
	enable_ntdll_NtSuspendProcess="$1"
	enable_ntdll_NtUnmapViewOfSection="$1"
	enable_ntdll_Pipe_SpecialCharacters="$1"
	enable_ntdll_ProcessImageFileNameWin32="$1"
	enable_ntdll_ProcessPriorityClass="$1"
	enable_ntdll_ProcessQuotaLimits="$1"
	enable_ntdll_Purist_Mode="$1"
	enable_ntdll_RtlCaptureStackBackTrace="$1"
	enable_ntdll_RtlGetUnloadEventTraceEx="$1"
	enable_ntdll_RtlIpStringToAddress_Stubs="$1"
	enable_ntdll_RtlIpStringToAddress_Tests="$1"
	enable_ntdll_RtlQueryPackageIdentity="$1"
	enable_ntdll_RunlevelInformationInActivationContext="$1"
	enable_ntdll_Serial_Port_Detection="$1"
	enable_ntdll_Signal_Handler="$1"
	enable_ntdll_Stack_Guard_Page="$1"
	enable_ntdll_Stack_Overflow="$1"
	enable_ntdll_Status_Mapping="$1"
	enable_ntdll_SystemInterruptInformation="$1"
	enable_ntdll_SystemRecommendedSharedDataAlignment="$1"
	enable_ntdll_SystemRoot_Symlink="$1"
	enable_ntdll_ThreadTime="$1"
	enable_ntdll_Threading="$1"
	enable_ntdll_TokenLogonSid="$1"
	enable_ntdll_User_Shared_Data="$1"
	enable_ntdll_WRITECOPY="$1"
	enable_ntdll_Wait_User_APC="$1"
	enable_ntdll_Zero_mod_name="$1"
	enable_ntdll__aulldvrm="$1"
	enable_ntdll_call_thread_func_wrapper="$1"
	enable_ntdll_set_full_cpu_context="$1"
	enable_ntdll_x86_64_ExceptionInformation="$1"
	enable_ntoskrnl_DriverTest="$1"
	enable_ntoskrnl_Stubs="$1"
	enable_nvapi_Stub_DLL="$1"
	enable_nvcuda_CUDA_Support="$1"
	enable_nvcuvid_CUDA_Video_Support="$1"
	enable_nvencodeapi_Video_Encoder="$1"
	enable_ole32_HGLOBALStream="$1"
	enable_ole32_STGPROP="$1"
	enable_oleaut32_CreateTypeLib="$1"
	enable_oleaut32_DispCallFunc="$1"
	enable_oleaut32_ITypeInfo_fnInvoke="$1"
	enable_oleaut32_Load_Save_EMF="$1"
	enable_oleaut32_OLEPictureImpl_SaveAsFile="$1"
	enable_oleaut32_OleLoadPicture="$1"
	enable_oleaut32_OleLoadPictureFile="$1"
	enable_oleaut32_TKIND_COCLASS="$1"
	enable_oleaut32_Vtable_Offset="$1"
	enable_oleaut32_x86_64_Marshaller="$1"
	enable_opengl32_Revert_Disable_Ext="$1"
	enable_opengl32_glDebugMessageCallback="$1"
	enable_opengl32_wglChoosePixelFormat="$1"
	enable_packager_DllMain="$1"
	enable_quartz_MediaSeeking_Positions="$1"
	enable_quartz_Silence_FIXMEs="$1"
	enable_rasapi32_RasGetConnectionStatistics="$1"
	enable_riched20_Class_Tests="$1"
	enable_riched20_IText_Interface="$1"
	enable_rpcrt4_Race_Condition="$1"
	enable_secur32_Zero_Buffer_Length="$1"
	enable_server_ClipCursor="$1"
	enable_server_CreateProcess_ACLs="$1"
	enable_server_Desktop_Refcount="$1"
	enable_server_FileEndOfFileInformation="$1"
	enable_server_File_Permissions="$1"
	enable_server_Inherited_ACLs="$1"
	enable_server_Key_State="$1"
	enable_server_Map_EXDEV_Error="$1"
	enable_server_Misc_ACL="$1"
	enable_server_Object_Types="$1"
	enable_server_PeekMessage="$1"
	enable_server_Pipe_ObjectName="$1"
	enable_server_Realtime_Priority="$1"
	enable_server_Registry_Notifications="$1"
	enable_server_Shared_Memory="$1"
	enable_server_Signal_Thread="$1"
	enable_server_Stored_ACLs="$1"
	enable_server_Timestamp_Compat="$1"
	enable_server_device_manager_destroy="$1"
	enable_server_free_async_queue="$1"
	enable_server_send_hardware_message="$1"
	enable_setupapi_CM_Get_Parent="$1"
	enable_setupapi_DiskSpaceList="$1"
	enable_setupapi_Display_Device="$1"
	enable_setupapi_HSPFILEQ_Check_Type="$1"
	enable_setupapi_SPFILENOTIFY_FILEINCABINET="$1"
	enable_setupapi_SP_COPY_IN_USE_NEEDS_REBOOT="$1"
	enable_setupapi_SetupDiGetDeviceInterfaceDetail="$1"
	enable_setupapi_SetupPromptForDisk="$1"
	enable_sfc_SfcGetNextProtectedFile="$1"
	enable_shdocvw_ParseURLFromOutsideSource_Tests="$1"
	enable_shell32_ACE_Viewer="$1"
	enable_shell32_Context_Menu="$1"
	enable_shell32_File_Property_Dialog="$1"
	enable_shell32_Icons="$1"
	enable_shell32_Microsoft_Windows_Themes="$1"
	enable_shell32_NewMenu_Interface="$1"
	enable_shell32_Placeholder_Icons="$1"
	enable_shell32_Progress_Dialog="$1"
	enable_shell32_RunDLL_CallEntry16="$1"
	enable_shell32_SFGAO_HASSUBFOLDER="$1"
	enable_shell32_SHCreateSessionKey="$1"
	enable_shell32_SHELL_execute="$1"
	enable_shell32_SHFileOperation_Move="$1"
	enable_shell32_SHFileOperation_Win9x="$1"
	enable_shell32_Toolbar_Bitmaps="$1"
	enable_shell32_UnixFS="$1"
	enable_shlwapi_AssocGetPerceivedType="$1"
	enable_shlwapi_PathUnExpandEnvStrings="$1"
	enable_shlwapi_SHAddDataBlock="$1"
	enable_shlwapi_SHMapHandle="$1"
	enable_shlwapi_UrlCombine="$1"
	enable_stdole32_idl_Typelib="$1"
	enable_stdole32_tlb_SLTG_Typelib="$1"
	enable_taskmgr_Memory_Usage="$1"
	enable_user_exe16_CONTAINING_RECORD="$1"
	enable_user_exe16_DlgDirList="$1"
	enable_user32_Auto_Radio_Button="$1"
	enable_user32_Combobox_WM_SIZE="$1"
	enable_user32_DM_SETDEFID="$1"
	enable_user32_Dialog_Focus="$1"
	enable_user32_Dialog_Paint_Event="$1"
	enable_user32_DrawMenuItem="$1"
	enable_user32_DrawTextExW="$1"
	enable_user32_FlashWindowEx="$1"
	enable_user32_GetAutoRotationState="$1"
	enable_user32_GetSystemMetrics="$1"
	enable_user32_Groupbox_Rectangle="$1"
	enable_user32_Invalidate_Key_State="$1"
	enable_user32_LR_LOADFROMFILE="$1"
	enable_user32_ListBox_Size="$1"
	enable_user32_MessageBox_WS_EX_TOPMOST="$1"
	enable_user32_Mouse_Message_Hwnd="$1"
	enable_user32_PNG_Support="$1"
	enable_user32_Refresh_MDI_Menus="$1"
	enable_user32_Revert_ListBox_Height="$1"
	enable_user32_ScrollWindowEx="$1"
	enable_user32_ShowWindow="$1"
	enable_user32_Sorted_Listbox="$1"
	enable_user32_WM_MEASUREITEM="$1"
	enable_user32_WindowDisplayAffinity="$1"
	enable_user32_lpCreateParams="$1"
	enable_uxtheme_CloseThemeClass="$1"
	enable_uxtheme_GTK_Theming="$1"
	enable_version_GetFileVersionInfoSizeExW="$1"
	enable_version_VerFindFileA="$1"
	enable_version_VerQueryValue="$1"
	enable_virtdisk_GetStorageDependencyInformation="$1"
	enable_vulkan_Vulkan_Implementation="$1"
	enable_wbemdisp_ISWbemSecurity="$1"
	enable_wbemprox_Printer="$1"
	enable_wbemprox_Win32_OperatingSystem="$1"
	enable_wbemprox_Win32_VideoController="$1"
	enable_wevtapi_EvtNext="$1"
	enable_widl_SLTG_Typelib_Support="$1"
	enable_windowscodecs_32bppPRGBA="$1"
	enable_windowscodecs_GIF_Encoder="$1"
	enable_windowscodecs_IMILBitmapSource="$1"
	enable_windowscodecs_IWICPalette_InitializeFromBitmap="$1"
	enable_windowscodecs_JPEG_Decoder="$1"
	enable_windowscodecs_Palette_Images="$1"
	enable_windowscodecs_TIFF_Support="$1"
	enable_windowscodecs_WICCreateBitmapFromSection="$1"
	enable_wine_inf_Directory_ContextMenuHandlers="$1"
	enable_wine_inf_Dummy_CA_Certificate="$1"
	enable_wine_inf_Performance="$1"
	enable_wine_inf_ProfileList_UserSID="$1"
	enable_wine_inf_WMP_12="$1"
	enable_wineboot_DriveSerial="$1"
	enable_wineboot_HKEY_DYN_DATA="$1"
	enable_wineboot_ProxySettings="$1"
	enable_wineboot_drivers_etc_Stubs="$1"
	enable_winebuild_Fake_Dlls="$1"
	enable_winecfg_Libraries="$1"
	enable_winecfg_Staging="$1"
	enable_winecfg_Unmounted_Devices="$1"
	enable_wined3d_1DTextures="$1"
	enable_wined3d_Accounting="$1"
	enable_wined3d_CSMT_Helper="$1"
	enable_wined3d_CSMT_Main="$1"
	enable_wined3d_Copy_Resource_Typeless="$1"
	enable_wined3d_Core_Context="$1"
	enable_wined3d_DXTn="$1"
	enable_wined3d_Dual_Source_Blending="$1"
	enable_wined3d_GTX_560M="$1"
	enable_wined3d_GenerateMips="$1"
	enable_wined3d_Indexed_Vertex_Blending="$1"
	enable_wined3d_Limit_Vram="$1"
	enable_wined3d_QUERY_Stubs="$1"
	enable_wined3d_Revert_Buffer_Upload="$1"
	enable_wined3d_Revert_Surface_Blt="$1"
	enable_wined3d_Silence_FIXMEs="$1"
	enable_wined3d_UAV_Counters="$1"
	enable_wined3d_Viewports="$1"
	enable_wined3d_WINED3DFMT_R32G32_UINT="$1"
	enable_wined3d_WINED3D_RS_COLORWRITEENABLE="$1"
	enable_wined3d_buffer_create="$1"
	enable_wined3d_dxgi_swapchain_Present="$1"
	enable_wined3d_sample_c_lz="$1"
	enable_wined3d_wined3d_guess_gl_vendor="$1"
	enable_winedbg_Process_Arguments="$1"
	enable_winedevice_Default_Drivers="$1"
	enable_winedevice_Fix_Relocation="$1"
	enable_winemenubuilder_Desktop_Icon_Path="$1"
	enable_winemp3_acm_MPEG3_StreamOpen="$1"
	enable_wineps_drv_PostScript_Fixes="$1"
	enable_winepulse_PulseAudio_Support="$1"
	enable_winex11_CandidateWindowPos="$1"
	enable_winex11_ClipCursor="$1"
	enable_winex11_DefaultDisplayFrequency="$1"
	enable_winex11_MWM_Decorations="$1"
	enable_winex11_SC_KEYMENU="$1"
	enable_winex11_UpdateLayeredWindow="$1"
	enable_winex11_WM_WINDOWPOSCHANGING="$1"
	enable_winex11_Window_Groups="$1"
	enable_winex11_Window_Style="$1"
	enable_winex11_XEMBED="$1"
	enable_winex11__NET_ACTIVE_WINDOW="$1"
	enable_winex11_wglShareLists="$1"
	enable_winhlp32_Flex_Workaround="$1"
	enable_winhttp_Accept_Headers="$1"
	enable_winhttp_System_Proxy_Autoconfig="$1"
	enable_wininet_Cleanup="$1"
	enable_wininet_Http_Decoding="$1"
	enable_wininet_InternetCrackUrlW="$1"
	enable_wininet_Internet_Settings="$1"
	enable_wininet_ParseX509EncodedCertificateForListBoxEntry="$1"
	enable_wininet_Redirect="$1"
	enable_winmm_Delay_Import_Depends="$1"
	enable_winmm_mciSendCommandA="$1"
	enable_wintrust_WinVerifyTrust="$1"
	enable_wpcap_Dynamic_Linking="$1"
	enable_wpcap_Several_Fixes="$1"
	enable_ws2_32_APC_Performance="$1"
	enable_ws2_32_Connect_Time="$1"
	enable_ws2_32_Tests="$1"
	enable_ws2_32_TransmitFile="$1"
	enable_ws2_32_WSACleanup="$1"
	enable_ws2_32_getaddrinfo="$1"
	enable_ws2_32_getsockopt="$1"
	enable_ws2_32_setsockopt="$1"
	enable_wtsapi32_EnumerateProcesses="$1"
	enable_wtsapi32_WTSQueryUserToken="$1"
	enable_wuauserv_Dummy_Service="$1"
	enable_wusa_MSU_Package_Installer="$1"
	enable_xaudio2_get_al_format="$1"
	enable_xaudio2_7_OnVoiceProcessingPassStart="$1"
}

# Enable or disable a specific patchset
patch_enable ()
{
	case "$1" in
		Compiler_Warnings)
			enable_Compiler_Warnings="$2"
			;;
		Coverity)
			enable_Coverity="$2"
			;;
		Pipelight)
			enable_Pipelight="$2"
			;;
		Staging)
			enable_Staging="$2"
			;;
		advapi-LsaLookupPrivilegeName)
			enable_advapi_LsaLookupPrivilegeName="$2"
			;;
		advapi32-BuildSecurityDescriptor)
			enable_advapi32_BuildSecurityDescriptor="$2"
			;;
		advapi32-CreateRestrictedToken)
			enable_advapi32_CreateRestrictedToken="$2"
			;;
		advapi32-GetExplicitEntriesFromAclW)
			enable_advapi32_GetExplicitEntriesFromAclW="$2"
			;;
		advapi32-LsaLookupSids)
			enable_advapi32_LsaLookupSids="$2"
			;;
		advapi32-Performance_Counters)
			enable_advapi32_Performance_Counters="$2"
			;;
		advapi32-SetSecurityInfo)
			enable_advapi32_SetSecurityInfo="$2"
			;;
		advapi32-Token_Integrity_Level)
			enable_advapi32_Token_Integrity_Level="$2"
			;;
		advapi32-WinBuiltinAnyPackageSid)
			enable_advapi32_WinBuiltinAnyPackageSid="$2"
			;;
		api-ms-win-Stub_DLLs)
			enable_api_ms_win_Stub_DLLs="$2"
			;;
		avifil32-AVIFile_Proxies)
			enable_avifil32_AVIFile_Proxies="$2"
			;;
		avifil32-IGetFrame_fnSetFormat)
			enable_avifil32_IGetFrame_fnSetFormat="$2"
			;;
		avifile.dll16-AVIStreamGetFrame)
			enable_avifile_dll16_AVIStreamGetFrame="$2"
			;;
		bcrypt-Improvements)
			enable_bcrypt_Improvements="$2"
			;;
		browseui-Progress_Dialog)
			enable_browseui_Progress_Dialog="$2"
			;;
		combase-RoApi)
			enable_combase_RoApi="$2"
			;;
		comctl32-Button_Theming)
			enable_comctl32_Button_Theming="$2"
			;;
		comctl32-Listview_DrawItem)
			enable_comctl32_Listview_DrawItem="$2"
			;;
		comctl32-TTM_ADDTOOLW)
			enable_comctl32_TTM_ADDTOOLW="$2"
			;;
		comctl32-Tests)
			enable_comctl32_Tests="$2"
			;;
		comdlg32-lpstrFileTitle)
			enable_comdlg32_lpstrFileTitle="$2"
			;;
		configure-Absolute_RPATH)
			enable_configure_Absolute_RPATH="$2"
			;;
		crypt32-CMS_Certificates)
			enable_crypt32_CMS_Certificates="$2"
			;;
		crypt32-Certificate_Check)
			enable_crypt32_Certificate_Check="$2"
			;;
		crypt32-CryptUnprotectMemory)
			enable_crypt32_CryptUnprotectMemory="$2"
			;;
		crypt32-ECDSA_Cert_Chains)
			enable_crypt32_ECDSA_Cert_Chains="$2"
			;;
		crypt32-MS_Root_Certs)
			enable_crypt32_MS_Root_Certs="$2"
			;;
		crypt32-SHA_OIDs)
			enable_crypt32_SHA_OIDs="$2"
			;;
		d3d10_1-Forwards)
			enable_d3d10_1_Forwards="$2"
			;;
		d3d11-Deferred_Context)
			enable_d3d11_Deferred_Context="$2"
			;;
		d3d11-Depth_Bias)
			enable_d3d11_Depth_Bias="$2"
			;;
		d3d11-ID3D11Texture1D)
			enable_d3d11_ID3D11Texture1D="$2"
			;;
		d3d11-ResolveSubresource)
			enable_d3d11_ResolveSubresource="$2"
			;;
		d3d11-Silence_FIXMEs)
			enable_d3d11_Silence_FIXMEs="$2"
			;;
		d3d8-ValidateShader)
			enable_d3d8_ValidateShader="$2"
			;;
		d3d9-DesktopWindow)
			enable_d3d9_DesktopWindow="$2"
			;;
		d3d9-Tests)
			enable_d3d9_Tests="$2"
			;;
		d3dx9_25-ID3DXEffect)
			enable_d3dx9_25_ID3DXEffect="$2"
			;;
		d3dx9_36-32bpp_Alpha_Channel)
			enable_d3dx9_36_32bpp_Alpha_Channel="$2"
			;;
		d3dx9_36-BumpLuminance)
			enable_d3dx9_36_BumpLuminance="$2"
			;;
		d3dx9_36-CloneEffect)
			enable_d3dx9_36_CloneEffect="$2"
			;;
		d3dx9_36-D3DXCreateTeapot)
			enable_d3dx9_36_D3DXCreateTeapot="$2"
			;;
		d3dx9_36-D3DXDisassembleShader)
			enable_d3dx9_36_D3DXDisassembleShader="$2"
			;;
		d3dx9_36-D3DXOptimizeVertices)
			enable_d3dx9_36_D3DXOptimizeVertices="$2"
			;;
		d3dx9_36-D3DXStubs)
			enable_d3dx9_36_D3DXStubs="$2"
			;;
		d3dx9_36-DDS)
			enable_d3dx9_36_DDS="$2"
			;;
		d3dx9_36-DXTn)
			enable_d3dx9_36_DXTn="$2"
			;;
		d3dx9_36-DrawText)
			enable_d3dx9_36_DrawText="$2"
			;;
		d3dx9_36-Dummy_Skininfo)
			enable_d3dx9_36_Dummy_Skininfo="$2"
			;;
		d3dx9_36-Filter_Warnings)
			enable_d3dx9_36_Filter_Warnings="$2"
			;;
		d3dx9_36-FindNextValidTechnique)
			enable_d3dx9_36_FindNextValidTechnique="$2"
			;;
		d3dx9_36-GetShaderSemantics)
			enable_d3dx9_36_GetShaderSemantics="$2"
			;;
		d3dx9_36-Optimize_Inplace)
			enable_d3dx9_36_Optimize_Inplace="$2"
			;;
		d3dx9_36-Tests)
			enable_d3dx9_36_Tests="$2"
			;;
		d3dx9_36-Texture_Align)
			enable_d3dx9_36_Texture_Align="$2"
			;;
		d3dx9_36-UpdateSkinnedMesh)
			enable_d3dx9_36_UpdateSkinnedMesh="$2"
			;;
		dbghelp-Debug_Symbols)
			enable_dbghelp_Debug_Symbols="$2"
			;;
		ddraw-D3DFINDDEVICERESULT)
			enable_ddraw_D3DFINDDEVICERESULT="$2"
			;;
		ddraw-Device_Caps)
			enable_ddraw_Device_Caps="$2"
			;;
		ddraw-EnumSurfaces)
			enable_ddraw_EnumSurfaces="$2"
			;;
		ddraw-Fix_Typos)
			enable_ddraw_Fix_Typos="$2"
			;;
		ddraw-FlipToGDISurface)
			enable_ddraw_FlipToGDISurface="$2"
			;;
		ddraw-IDirect3DTexture2_Load)
			enable_ddraw_IDirect3DTexture2_Load="$2"
			;;
		ddraw-Rendering_Targets)
			enable_ddraw_Rendering_Targets="$2"
			;;
		ddraw-Silence_FIXMEs)
			enable_ddraw_Silence_FIXMEs="$2"
			;;
		ddraw-Write_Vtable)
			enable_ddraw_Write_Vtable="$2"
			;;
		devenum-AudioCompressorCategory)
			enable_devenum_AudioCompressorCategory="$2"
			;;
		dinput-Deadlock)
			enable_dinput_Deadlock="$2"
			;;
		dinput-Initialize)
			enable_dinput_Initialize="$2"
			;;
		dsound-EAX)
			enable_dsound_EAX="$2"
			;;
		dsound-Fast_Mixer)
			enable_dsound_Fast_Mixer="$2"
			;;
		dsound-Revert_Cleanup)
			enable_dsound_Revert_Cleanup="$2"
			;;
		dwmapi-DwmSetIcon)
			enable_dwmapi_DwmSetIcon="$2"
			;;
		dxdiag-dontskip)
			enable_dxdiag_dontskip="$2"
			;;
		dxdiagn-Display_Information)
			enable_dxdiagn_Display_Information="$2"
			;;
		dxdiagn-Enumerate_DirectSound)
			enable_dxdiagn_Enumerate_DirectSound="$2"
			;;
		dxdiagn-GetChildContainer_Leaf_Nodes)
			enable_dxdiagn_GetChildContainer_Leaf_Nodes="$2"
			;;
		dxgi-DXGI_PRESENT_TEST)
			enable_dxgi_DXGI_PRESENT_TEST="$2"
			;;
		dxgi-GammaRamp)
			enable_dxgi_GammaRamp="$2"
			;;
		dxgi-MakeWindowAssociation)
			enable_dxgi_MakeWindowAssociation="$2"
			;;
		dxva2-Video_Decoder)
			enable_dxva2_Video_Decoder="$2"
			;;
		explorer-Video_Registry_Key)
			enable_explorer_Video_Registry_Key="$2"
			;;
		fonts-Missing_Fonts)
			enable_fonts_Missing_Fonts="$2"
			;;
		fonts-Tahoma)
			enable_fonts_Tahoma="$2"
			;;
		fsutil-Stub_Program)
			enable_fsutil_Stub_Program="$2"
			;;
		gdi32-GetCharacterPlacement)
			enable_gdi32_GetCharacterPlacement="$2"
			;;
		gdi32-Lazy_Font_Initialization)
			enable_gdi32_Lazy_Font_Initialization="$2"
			;;
		gdi32-MultiMonitor)
			enable_gdi32_MultiMonitor="$2"
			;;
		gdi32-Path_Metafile)
			enable_gdi32_Path_Metafile="$2"
			;;
		gdi32-Symbol_Truetype_Font)
			enable_gdi32_Symbol_Truetype_Font="$2"
			;;
		gdiplus-Performance-Improvements)
			enable_gdiplus_Performance_Improvements="$2"
			;;
		hal-KeQueryPerformanceCounter)
			enable_hal_KeQueryPerformanceCounter="$2"
			;;
		hnetcfg-INetFwAuthorizedApplication)
			enable_hnetcfg_INetFwAuthorizedApplication="$2"
			;;
		ieframe-IViewObject-Draw)
			enable_ieframe_IViewObject_Draw="$2"
			;;
		imagehlp-BindImageEx)
			enable_imagehlp_BindImageEx="$2"
			;;
		imagehlp-Cleanup)
			enable_imagehlp_Cleanup="$2"
			;;
		imagehlp-ImageLoad)
			enable_imagehlp_ImageLoad="$2"
			;;
		imm32-IMMDisableLegacyIME)
			enable_imm32_IMMDisableLegacyIME="$2"
			;;
		include-winsock)
			enable_include_winsock="$2"
			;;
		inseng-Implementation)
			enable_inseng_Implementation="$2"
			;;
		iphlpapi-System_Ping)
			enable_iphlpapi_System_Ping="$2"
			;;
		iphlpapi-TCP_Table)
			enable_iphlpapi_TCP_Table="$2"
			;;
		kernel32-COMSPEC)
			enable_kernel32_COMSPEC="$2"
			;;
		kernel32-CopyFileEx)
			enable_kernel32_CopyFileEx="$2"
			;;
		kernel32-Cwd_Startup_Info)
			enable_kernel32_Cwd_Startup_Info="$2"
			;;
		kernel32-Debugger)
			enable_kernel32_Debugger="$2"
			;;
		kernel32-FindFirstFile)
			enable_kernel32_FindFirstFile="$2"
			;;
		kernel32-GetShortPathName)
			enable_kernel32_GetShortPathName="$2"
			;;
		kernel32-Job_Tests)
			enable_kernel32_Job_Tests="$2"
			;;
		kernel32-K32GetPerformanceInfo)
			enable_kernel32_K32GetPerformanceInfo="$2"
			;;
		kernel32-LocaleNameToLCID)
			enable_kernel32_LocaleNameToLCID="$2"
			;;
		kernel32-MODULE_get_binary_info)
			enable_kernel32_MODULE_get_binary_info="$2"
			;;
		kernel32-Misalign_Workaround)
			enable_kernel32_Misalign_Workaround="$2"
			;;
		kernel32-MoveFile)
			enable_kernel32_MoveFile="$2"
			;;
		kernel32-NeedCurrentDirectoryForExePath)
			enable_kernel32_NeedCurrentDirectoryForExePath="$2"
			;;
		kernel32-PE_Loader_Fixes)
			enable_kernel32_PE_Loader_Fixes="$2"
			;;
		kernel32-Processor_Group)
			enable_kernel32_Processor_Group="$2"
			;;
		kernel32-Profile)
			enable_kernel32_Profile="$2"
			;;
		kernel32-SCSI_Sysfs)
			enable_kernel32_SCSI_Sysfs="$2"
			;;
		kernel32-SetFileCompletionNotificationModes)
			enable_kernel32_SetFileCompletionNotificationModes="$2"
			;;
		kernel32-TRUST_E_NOSIGNATURE)
			enable_kernel32_TRUST_E_NOSIGNATURE="$2"
			;;
		kernel32-Tests)
			enable_kernel32_Tests="$2"
			;;
		kernel32-TimezoneInformation_Registry)
			enable_kernel32_TimezoneInformation_Registry="$2"
			;;
		kernel32-UmsStubs)
			enable_kernel32_UmsStubs="$2"
			;;
		kernel32-VerifyVersionInfo)
			enable_kernel32_VerifyVersionInfo="$2"
			;;
		kernelbase-PathCchCombineEx)
			enable_kernelbase_PathCchCombineEx="$2"
			;;
		krnl386.exe16-GDT_LDT_Emulation)
			enable_krnl386_exe16_GDT_LDT_Emulation="$2"
			;;
		krnl386.exe16-Invalid_Console_Handles)
			enable_krnl386_exe16_Invalid_Console_Handles="$2"
			;;
		krnl386.exe16-_lclose16)
			enable_krnl386_exe16__lclose16="$2"
			;;
		libs-Debug_Channel)
			enable_libs_Debug_Channel="$2"
			;;
		libs-Unicode_Collation)
			enable_libs_Unicode_Collation="$2"
			;;
		loader-OSX_Preloader)
			enable_loader_OSX_Preloader="$2"
			;;
		makedep-PARENTSPEC)
			enable_makedep_PARENTSPEC="$2"
			;;
		mmsystem.dll16-MIDIHDR_Refcount)
			enable_mmsystem_dll16_MIDIHDR_Refcount="$2"
			;;
		mountmgr-DosDevices)
			enable_mountmgr_DosDevices="$2"
			;;
		mpr-WNetGetUniversalNameW)
			enable_mpr_WNetGetUniversalNameW="$2"
			;;
		mscoree-CorValidateImage)
			enable_mscoree_CorValidateImage="$2"
			;;
		mshtml-HTMLLocation_put_hash)
			enable_mshtml_HTMLLocation_put_hash="$2"
			;;
		msi-Dummy_Thread)
			enable_msi_Dummy_Thread="$2"
			;;
		msi-MsiGetDatabaseState)
			enable_msi_MsiGetDatabaseState="$2"
			;;
		msi-msi_vcl_get_cost)
			enable_msi_msi_vcl_get_cost="$2"
			;;
		msidb-Implementation)
			enable_msidb_Implementation="$2"
			;;
		msvcr120-_SetWinRTOutOfMemoryExceptionCallback)
			enable_msvcr120__SetWinRTOutOfMemoryExceptionCallback="$2"
			;;
		msvcrt-Math_Precision)
			enable_msvcrt_Math_Precision="$2"
			;;
		msvfw32-ICGetDisplayFormat)
			enable_msvfw32_ICGetDisplayFormat="$2"
			;;
		msxml3-Normalize_Data)
			enable_msxml3_Normalize_Data="$2"
			;;
		ntdll-APC_Performance)
			enable_ntdll_APC_Performance="$2"
			;;
		ntdll-APC_Start_Process)
			enable_ntdll_APC_Start_Process="$2"
			;;
		ntdll-Activation_Context)
			enable_ntdll_Activation_Context="$2"
			;;
		ntdll-ApiSetMap)
			enable_ntdll_ApiSetMap="$2"
			;;
		ntdll-ApiSetQueryApiSetPresence)
			enable_ntdll_ApiSetQueryApiSetPresence="$2"
			;;
		ntdll-Attach_Process_DLLs)
			enable_ntdll_Attach_Process_DLLs="$2"
			;;
		ntdll-Builtin_Prot)
			enable_ntdll_Builtin_Prot="$2"
			;;
		ntdll-CLI_Images)
			enable_ntdll_CLI_Images="$2"
			;;
		ntdll-CriticalSection)
			enable_ntdll_CriticalSection="$2"
			;;
		ntdll-DOS_Area)
			enable_ntdll_DOS_Area="$2"
			;;
		ntdll-DOS_Attributes)
			enable_ntdll_DOS_Attributes="$2"
			;;
		ntdll-Dealloc_Thread_Stack)
			enable_ntdll_Dealloc_Thread_Stack="$2"
			;;
		ntdll-DeviceType_Systemroot)
			enable_ntdll_DeviceType_Systemroot="$2"
			;;
		ntdll-DllOverrides_WOW64)
			enable_ntdll_DllOverrides_WOW64="$2"
			;;
		ntdll-DllRedirects)
			enable_ntdll_DllRedirects="$2"
			;;
		ntdll-Exception)
			enable_ntdll_Exception="$2"
			;;
		ntdll-FileDispositionInformation)
			enable_ntdll_FileDispositionInformation="$2"
			;;
		ntdll-FileFsFullSizeInformation)
			enable_ntdll_FileFsFullSizeInformation="$2"
			;;
		ntdll-FileFsVolumeInformation)
			enable_ntdll_FileFsVolumeInformation="$2"
			;;
		ntdll-FileNameInformation)
			enable_ntdll_FileNameInformation="$2"
			;;
		ntdll-Fix_Alignment)
			enable_ntdll_Fix_Alignment="$2"
			;;
		ntdll-HashLinks)
			enable_ntdll_HashLinks="$2"
			;;
		ntdll-Heap_Improvements)
			enable_ntdll_Heap_Improvements="$2"
			;;
		ntdll-Hide_Wine_Exports)
			enable_ntdll_Hide_Wine_Exports="$2"
			;;
		ntdll-Interrupt-0x2e)
			enable_ntdll_Interrupt_0x2e="$2"
			;;
		ntdll-Junction_Points)
			enable_ntdll_Junction_Points="$2"
			;;
		ntdll-LDR_MODULE)
			enable_ntdll_LDR_MODULE="$2"
			;;
		ntdll-LdrGetDllHandle)
			enable_ntdll_LdrGetDllHandle="$2"
			;;
		ntdll-LdrRegisterDllNotification)
			enable_ntdll_LdrRegisterDllNotification="$2"
			;;
		ntdll-Loader_Machine_Type)
			enable_ntdll_Loader_Machine_Type="$2"
			;;
		ntdll-NtAccessCheck)
			enable_ntdll_NtAccessCheck="$2"
			;;
		ntdll-NtAllocateUuids)
			enable_ntdll_NtAllocateUuids="$2"
			;;
		ntdll-NtContinue)
			enable_ntdll_NtContinue="$2"
			;;
		ntdll-NtCreateThreadEx)
			enable_ntdll_NtCreateThreadEx="$2"
			;;
		ntdll-NtDevicePath)
			enable_ntdll_NtDevicePath="$2"
			;;
		ntdll-NtQueryEaFile)
			enable_ntdll_NtQueryEaFile="$2"
			;;
		ntdll-NtQuerySection)
			enable_ntdll_NtQuerySection="$2"
			;;
		ntdll-NtQueryVirtualMemory)
			enable_ntdll_NtQueryVirtualMemory="$2"
			;;
		ntdll-NtSetInformationToken)
			enable_ntdll_NtSetInformationToken="$2"
			;;
		ntdll-NtSetLdtEntries)
			enable_ntdll_NtSetLdtEntries="$2"
			;;
		ntdll-NtSuspendProcess)
			enable_ntdll_NtSuspendProcess="$2"
			;;
		ntdll-NtUnmapViewOfSection)
			enable_ntdll_NtUnmapViewOfSection="$2"
			;;
		ntdll-Pipe_SpecialCharacters)
			enable_ntdll_Pipe_SpecialCharacters="$2"
			;;
		ntdll-ProcessImageFileNameWin32)
			enable_ntdll_ProcessImageFileNameWin32="$2"
			;;
		ntdll-ProcessPriorityClass)
			enable_ntdll_ProcessPriorityClass="$2"
			;;
		ntdll-ProcessQuotaLimits)
			enable_ntdll_ProcessQuotaLimits="$2"
			;;
		ntdll-Purist_Mode)
			enable_ntdll_Purist_Mode="$2"
			;;
		ntdll-RtlCaptureStackBackTrace)
			enable_ntdll_RtlCaptureStackBackTrace="$2"
			;;
		ntdll-RtlGetUnloadEventTraceEx)
			enable_ntdll_RtlGetUnloadEventTraceEx="$2"
			;;
		ntdll-RtlIpStringToAddress_Stubs)
			enable_ntdll_RtlIpStringToAddress_Stubs="$2"
			;;
		ntdll-RtlIpStringToAddress_Tests)
			enable_ntdll_RtlIpStringToAddress_Tests="$2"
			;;
		ntdll-RtlQueryPackageIdentity)
			enable_ntdll_RtlQueryPackageIdentity="$2"
			;;
		ntdll-RunlevelInformationInActivationContext)
			enable_ntdll_RunlevelInformationInActivationContext="$2"
			;;
		ntdll-Serial_Port_Detection)
			enable_ntdll_Serial_Port_Detection="$2"
			;;
		ntdll-Signal_Handler)
			enable_ntdll_Signal_Handler="$2"
			;;
		ntdll-Stack_Guard_Page)
			enable_ntdll_Stack_Guard_Page="$2"
			;;
		ntdll-Stack_Overflow)
			enable_ntdll_Stack_Overflow="$2"
			;;
		ntdll-Status_Mapping)
			enable_ntdll_Status_Mapping="$2"
			;;
		ntdll-SystemInterruptInformation)
			enable_ntdll_SystemInterruptInformation="$2"
			;;
		ntdll-SystemRecommendedSharedDataAlignment)
			enable_ntdll_SystemRecommendedSharedDataAlignment="$2"
			;;
		ntdll-SystemRoot_Symlink)
			enable_ntdll_SystemRoot_Symlink="$2"
			;;
		ntdll-ThreadTime)
			enable_ntdll_ThreadTime="$2"
			;;
		ntdll-Threading)
			enable_ntdll_Threading="$2"
			;;
		ntdll-TokenLogonSid)
			enable_ntdll_TokenLogonSid="$2"
			;;
		ntdll-User_Shared_Data)
			enable_ntdll_User_Shared_Data="$2"
			;;
		ntdll-WRITECOPY)
			enable_ntdll_WRITECOPY="$2"
			;;
		ntdll-Wait_User_APC)
			enable_ntdll_Wait_User_APC="$2"
			;;
		ntdll-Zero_mod_name)
			enable_ntdll_Zero_mod_name="$2"
			;;
		ntdll-_aulldvrm)
			enable_ntdll__aulldvrm="$2"
			;;
		ntdll-call_thread_func_wrapper)
			enable_ntdll_call_thread_func_wrapper="$2"
			;;
		ntdll-set_full_cpu_context)
			enable_ntdll_set_full_cpu_context="$2"
			;;
		ntdll-x86_64_ExceptionInformation)
			enable_ntdll_x86_64_ExceptionInformation="$2"
			;;
		ntoskrnl-DriverTest)
			enable_ntoskrnl_DriverTest="$2"
			;;
		ntoskrnl-Stubs)
			enable_ntoskrnl_Stubs="$2"
			;;
		nvapi-Stub_DLL)
			enable_nvapi_Stub_DLL="$2"
			;;
		nvcuda-CUDA_Support)
			enable_nvcuda_CUDA_Support="$2"
			;;
		nvcuvid-CUDA_Video_Support)
			enable_nvcuvid_CUDA_Video_Support="$2"
			;;
		nvencodeapi-Video_Encoder)
			enable_nvencodeapi_Video_Encoder="$2"
			;;
		ole32-HGLOBALStream)
			enable_ole32_HGLOBALStream="$2"
			;;
		ole32-STGPROP)
			enable_ole32_STGPROP="$2"
			;;
		oleaut32-CreateTypeLib)
			enable_oleaut32_CreateTypeLib="$2"
			;;
		oleaut32-DispCallFunc)
			enable_oleaut32_DispCallFunc="$2"
			;;
		oleaut32-ITypeInfo_fnInvoke)
			enable_oleaut32_ITypeInfo_fnInvoke="$2"
			;;
		oleaut32-Load_Save_EMF)
			enable_oleaut32_Load_Save_EMF="$2"
			;;
		oleaut32-OLEPictureImpl_SaveAsFile)
			enable_oleaut32_OLEPictureImpl_SaveAsFile="$2"
			;;
		oleaut32-OleLoadPicture)
			enable_oleaut32_OleLoadPicture="$2"
			;;
		oleaut32-OleLoadPictureFile)
			enable_oleaut32_OleLoadPictureFile="$2"
			;;
		oleaut32-TKIND_COCLASS)
			enable_oleaut32_TKIND_COCLASS="$2"
			;;
		oleaut32-Vtable_Offset)
			enable_oleaut32_Vtable_Offset="$2"
			;;
		oleaut32-x86_64_Marshaller)
			enable_oleaut32_x86_64_Marshaller="$2"
			;;
		opengl32-Revert_Disable_Ext)
			enable_opengl32_Revert_Disable_Ext="$2"
			;;
		opengl32-glDebugMessageCallback)
			enable_opengl32_glDebugMessageCallback="$2"
			;;
		opengl32-wglChoosePixelFormat)
			enable_opengl32_wglChoosePixelFormat="$2"
			;;
		packager-DllMain)
			enable_packager_DllMain="$2"
			;;
		quartz-MediaSeeking_Positions)
			enable_quartz_MediaSeeking_Positions="$2"
			;;
		quartz-Silence_FIXMEs)
			enable_quartz_Silence_FIXMEs="$2"
			;;
		rasapi32-RasGetConnectionStatistics)
			enable_rasapi32_RasGetConnectionStatistics="$2"
			;;
		riched20-Class_Tests)
			enable_riched20_Class_Tests="$2"
			;;
		riched20-IText_Interface)
			enable_riched20_IText_Interface="$2"
			;;
		rpcrt4-Race_Condition)
			enable_rpcrt4_Race_Condition="$2"
			;;
		secur32-Zero_Buffer_Length)
			enable_secur32_Zero_Buffer_Length="$2"
			;;
		server-ClipCursor)
			enable_server_ClipCursor="$2"
			;;
		server-CreateProcess_ACLs)
			enable_server_CreateProcess_ACLs="$2"
			;;
		server-Desktop_Refcount)
			enable_server_Desktop_Refcount="$2"
			;;
		server-FileEndOfFileInformation)
			enable_server_FileEndOfFileInformation="$2"
			;;
		server-File_Permissions)
			enable_server_File_Permissions="$2"
			;;
		server-Inherited_ACLs)
			enable_server_Inherited_ACLs="$2"
			;;
		server-Key_State)
			enable_server_Key_State="$2"
			;;
		server-Map_EXDEV_Error)
			enable_server_Map_EXDEV_Error="$2"
			;;
		server-Misc_ACL)
			enable_server_Misc_ACL="$2"
			;;
		server-Object_Types)
			enable_server_Object_Types="$2"
			;;
		server-PeekMessage)
			enable_server_PeekMessage="$2"
			;;
		server-Pipe_ObjectName)
			enable_server_Pipe_ObjectName="$2"
			;;
		server-Realtime_Priority)
			enable_server_Realtime_Priority="$2"
			;;
		server-Registry_Notifications)
			enable_server_Registry_Notifications="$2"
			;;
		server-Shared_Memory)
			enable_server_Shared_Memory="$2"
			;;
		server-Signal_Thread)
			enable_server_Signal_Thread="$2"
			;;
		server-Stored_ACLs)
			enable_server_Stored_ACLs="$2"
			;;
		server-Timestamp_Compat)
			enable_server_Timestamp_Compat="$2"
			;;
		server-device_manager_destroy)
			enable_server_device_manager_destroy="$2"
			;;
		server-free_async_queue)
			enable_server_free_async_queue="$2"
			;;
		server-send_hardware_message)
			enable_server_send_hardware_message="$2"
			;;
		setupapi-CM_Get_Parent)
			enable_setupapi_CM_Get_Parent="$2"
			;;
		setupapi-DiskSpaceList)
			enable_setupapi_DiskSpaceList="$2"
			;;
		setupapi-Display_Device)
			enable_setupapi_Display_Device="$2"
			;;
		setupapi-HSPFILEQ_Check_Type)
			enable_setupapi_HSPFILEQ_Check_Type="$2"
			;;
		setupapi-SPFILENOTIFY_FILEINCABINET)
			enable_setupapi_SPFILENOTIFY_FILEINCABINET="$2"
			;;
		setupapi-SP_COPY_IN_USE_NEEDS_REBOOT)
			enable_setupapi_SP_COPY_IN_USE_NEEDS_REBOOT="$2"
			;;
		setupapi-SetupDiGetDeviceInterfaceDetail)
			enable_setupapi_SetupDiGetDeviceInterfaceDetail="$2"
			;;
		setupapi-SetupPromptForDisk)
			enable_setupapi_SetupPromptForDisk="$2"
			;;
		sfc-SfcGetNextProtectedFile)
			enable_sfc_SfcGetNextProtectedFile="$2"
			;;
		shdocvw-ParseURLFromOutsideSource_Tests)
			enable_shdocvw_ParseURLFromOutsideSource_Tests="$2"
			;;
		shell32-ACE_Viewer)
			enable_shell32_ACE_Viewer="$2"
			;;
		shell32-Context_Menu)
			enable_shell32_Context_Menu="$2"
			;;
		shell32-File_Property_Dialog)
			enable_shell32_File_Property_Dialog="$2"
			;;
		shell32-Icons)
			enable_shell32_Icons="$2"
			;;
		shell32-Microsoft_Windows_Themes)
			enable_shell32_Microsoft_Windows_Themes="$2"
			;;
		shell32-NewMenu_Interface)
			enable_shell32_NewMenu_Interface="$2"
			;;
		shell32-Placeholder_Icons)
			enable_shell32_Placeholder_Icons="$2"
			;;
		shell32-Progress_Dialog)
			enable_shell32_Progress_Dialog="$2"
			;;
		shell32-RunDLL_CallEntry16)
			enable_shell32_RunDLL_CallEntry16="$2"
			;;
		shell32-SFGAO_HASSUBFOLDER)
			enable_shell32_SFGAO_HASSUBFOLDER="$2"
			;;
		shell32-SHCreateSessionKey)
			enable_shell32_SHCreateSessionKey="$2"
			;;
		shell32-SHELL_execute)
			enable_shell32_SHELL_execute="$2"
			;;
		shell32-SHFileOperation_Move)
			enable_shell32_SHFileOperation_Move="$2"
			;;
		shell32-SHFileOperation_Win9x)
			enable_shell32_SHFileOperation_Win9x="$2"
			;;
		shell32-Toolbar_Bitmaps)
			enable_shell32_Toolbar_Bitmaps="$2"
			;;
		shell32-UnixFS)
			enable_shell32_UnixFS="$2"
			;;
		shlwapi-AssocGetPerceivedType)
			enable_shlwapi_AssocGetPerceivedType="$2"
			;;
		shlwapi-PathUnExpandEnvStrings)
			enable_shlwapi_PathUnExpandEnvStrings="$2"
			;;
		shlwapi-SHAddDataBlock)
			enable_shlwapi_SHAddDataBlock="$2"
			;;
		shlwapi-SHMapHandle)
			enable_shlwapi_SHMapHandle="$2"
			;;
		shlwapi-UrlCombine)
			enable_shlwapi_UrlCombine="$2"
			;;
		stdole32.idl-Typelib)
			enable_stdole32_idl_Typelib="$2"
			;;
		stdole32.tlb-SLTG_Typelib)
			enable_stdole32_tlb_SLTG_Typelib="$2"
			;;
		taskmgr-Memory_Usage)
			enable_taskmgr_Memory_Usage="$2"
			;;
		user.exe16-CONTAINING_RECORD)
			enable_user_exe16_CONTAINING_RECORD="$2"
			;;
		user.exe16-DlgDirList)
			enable_user_exe16_DlgDirList="$2"
			;;
		user32-Auto_Radio_Button)
			enable_user32_Auto_Radio_Button="$2"
			;;
		user32-Combobox_WM_SIZE)
			enable_user32_Combobox_WM_SIZE="$2"
			;;
		user32-DM_SETDEFID)
			enable_user32_DM_SETDEFID="$2"
			;;
		user32-Dialog_Focus)
			enable_user32_Dialog_Focus="$2"
			;;
		user32-Dialog_Paint_Event)
			enable_user32_Dialog_Paint_Event="$2"
			;;
		user32-DrawMenuItem)
			enable_user32_DrawMenuItem="$2"
			;;
		user32-DrawTextExW)
			enable_user32_DrawTextExW="$2"
			;;
		user32-FlashWindowEx)
			enable_user32_FlashWindowEx="$2"
			;;
		user32-GetAutoRotationState)
			enable_user32_GetAutoRotationState="$2"
			;;
		user32-GetSystemMetrics)
			enable_user32_GetSystemMetrics="$2"
			;;
		user32-Groupbox_Rectangle)
			enable_user32_Groupbox_Rectangle="$2"
			;;
		user32-Invalidate_Key_State)
			enable_user32_Invalidate_Key_State="$2"
			;;
		user32-LR_LOADFROMFILE)
			enable_user32_LR_LOADFROMFILE="$2"
			;;
		user32-ListBox_Size)
			enable_user32_ListBox_Size="$2"
			;;
		user32-MessageBox_WS_EX_TOPMOST)
			enable_user32_MessageBox_WS_EX_TOPMOST="$2"
			;;
		user32-Mouse_Message_Hwnd)
			enable_user32_Mouse_Message_Hwnd="$2"
			;;
		user32-PNG_Support)
			enable_user32_PNG_Support="$2"
			;;
		user32-Refresh_MDI_Menus)
			enable_user32_Refresh_MDI_Menus="$2"
			;;
		user32-Revert_ListBox_Height)
			enable_user32_Revert_ListBox_Height="$2"
			;;
		user32-ScrollWindowEx)
			enable_user32_ScrollWindowEx="$2"
			;;
		user32-ShowWindow)
			enable_user32_ShowWindow="$2"
			;;
		user32-Sorted_Listbox)
			enable_user32_Sorted_Listbox="$2"
			;;
		user32-WM_MEASUREITEM)
			enable_user32_WM_MEASUREITEM="$2"
			;;
		user32-WindowDisplayAffinity)
			enable_user32_WindowDisplayAffinity="$2"
			;;
		user32-lpCreateParams)
			enable_user32_lpCreateParams="$2"
			;;
		uxtheme-CloseThemeClass)
			enable_uxtheme_CloseThemeClass="$2"
			;;
		uxtheme-GTK_Theming)
			enable_uxtheme_GTK_Theming="$2"
			;;
		version-GetFileVersionInfoSizeExW)
			enable_version_GetFileVersionInfoSizeExW="$2"
			;;
		version-VerFindFileA)
			enable_version_VerFindFileA="$2"
			;;
		version-VerQueryValue)
			enable_version_VerQueryValue="$2"
			;;
		virtdisk-GetStorageDependencyInformation)
			enable_virtdisk_GetStorageDependencyInformation="$2"
			;;
		vulkan-Vulkan_Implementation)
			enable_vulkan_Vulkan_Implementation="$2"
			;;
		wbemdisp-ISWbemSecurity)
			enable_wbemdisp_ISWbemSecurity="$2"
			;;
		wbemprox-Printer)
			enable_wbemprox_Printer="$2"
			;;
		wbemprox-Win32_OperatingSystem)
			enable_wbemprox_Win32_OperatingSystem="$2"
			;;
		wbemprox-Win32_VideoController)
			enable_wbemprox_Win32_VideoController="$2"
			;;
		wevtapi-EvtNext)
			enable_wevtapi_EvtNext="$2"
			;;
		widl-SLTG_Typelib_Support)
			enable_widl_SLTG_Typelib_Support="$2"
			;;
		windowscodecs-32bppPRGBA)
			enable_windowscodecs_32bppPRGBA="$2"
			;;
		windowscodecs-GIF_Encoder)
			enable_windowscodecs_GIF_Encoder="$2"
			;;
		windowscodecs-IMILBitmapSource)
			enable_windowscodecs_IMILBitmapSource="$2"
			;;
		windowscodecs-IWICPalette_InitializeFromBitmap)
			enable_windowscodecs_IWICPalette_InitializeFromBitmap="$2"
			;;
		windowscodecs-JPEG_Decoder)
			enable_windowscodecs_JPEG_Decoder="$2"
			;;
		windowscodecs-Palette_Images)
			enable_windowscodecs_Palette_Images="$2"
			;;
		windowscodecs-TIFF_Support)
			enable_windowscodecs_TIFF_Support="$2"
			;;
		windowscodecs-WICCreateBitmapFromSection)
			enable_windowscodecs_WICCreateBitmapFromSection="$2"
			;;
		wine.inf-Directory_ContextMenuHandlers)
			enable_wine_inf_Directory_ContextMenuHandlers="$2"
			;;
		wine.inf-Dummy_CA_Certificate)
			enable_wine_inf_Dummy_CA_Certificate="$2"
			;;
		wine.inf-Performance)
			enable_wine_inf_Performance="$2"
			;;
		wine.inf-ProfileList_UserSID)
			enable_wine_inf_ProfileList_UserSID="$2"
			;;
		wine.inf-WMP_12)
			enable_wine_inf_WMP_12="$2"
			;;
		wineboot-DriveSerial)
			enable_wineboot_DriveSerial="$2"
			;;
		wineboot-HKEY_DYN_DATA)
			enable_wineboot_HKEY_DYN_DATA="$2"
			;;
		wineboot-ProxySettings)
			enable_wineboot_ProxySettings="$2"
			;;
		wineboot-drivers_etc_Stubs)
			enable_wineboot_drivers_etc_Stubs="$2"
			;;
		winebuild-Fake_Dlls)
			enable_winebuild_Fake_Dlls="$2"
			;;
		winecfg-Libraries)
			enable_winecfg_Libraries="$2"
			;;
		winecfg-Staging)
			enable_winecfg_Staging="$2"
			;;
		winecfg-Unmounted_Devices)
			enable_winecfg_Unmounted_Devices="$2"
			;;
		wined3d-1DTextures)
			enable_wined3d_1DTextures="$2"
			;;
		wined3d-Accounting)
			enable_wined3d_Accounting="$2"
			;;
		wined3d-CSMT_Helper)
			enable_wined3d_CSMT_Helper="$2"
			;;
		wined3d-CSMT_Main)
			enable_wined3d_CSMT_Main="$2"
			;;
		wined3d-Copy_Resource_Typeless)
			enable_wined3d_Copy_Resource_Typeless="$2"
			;;
		wined3d-Core_Context)
			enable_wined3d_Core_Context="$2"
			;;
		wined3d-DXTn)
			enable_wined3d_DXTn="$2"
			;;
		wined3d-Dual_Source_Blending)
			enable_wined3d_Dual_Source_Blending="$2"
			;;
		wined3d-GTX_560M)
			enable_wined3d_GTX_560M="$2"
			;;
		wined3d-GenerateMips)
			enable_wined3d_GenerateMips="$2"
			;;
		wined3d-Indexed_Vertex_Blending)
			enable_wined3d_Indexed_Vertex_Blending="$2"
			;;
		wined3d-Limit_Vram)
			enable_wined3d_Limit_Vram="$2"
			;;
		wined3d-QUERY_Stubs)
			enable_wined3d_QUERY_Stubs="$2"
			;;
		wined3d-Revert_Buffer_Upload)
			enable_wined3d_Revert_Buffer_Upload="$2"
			;;
		wined3d-Revert_Surface_Blt)
			enable_wined3d_Revert_Surface_Blt="$2"
			;;
		wined3d-Silence_FIXMEs)
			enable_wined3d_Silence_FIXMEs="$2"
			;;
		wined3d-UAV_Counters)
			enable_wined3d_UAV_Counters="$2"
			;;
		wined3d-Viewports)
			enable_wined3d_Viewports="$2"
			;;
		wined3d-WINED3DFMT_R32G32_UINT)
			enable_wined3d_WINED3DFMT_R32G32_UINT="$2"
			;;
		wined3d-WINED3D_RS_COLORWRITEENABLE)
			enable_wined3d_WINED3D_RS_COLORWRITEENABLE="$2"
			;;
		wined3d-buffer_create)
			enable_wined3d_buffer_create="$2"
			;;
		wined3d-dxgi_swapchain_Present)
			enable_wined3d_dxgi_swapchain_Present="$2"
			;;
		wined3d-sample_c_lz)
			enable_wined3d_sample_c_lz="$2"
			;;
		wined3d-wined3d_guess_gl_vendor)
			enable_wined3d_wined3d_guess_gl_vendor="$2"
			;;
		winedbg-Process_Arguments)
			enable_winedbg_Process_Arguments="$2"
			;;
		winedevice-Default_Drivers)
			enable_winedevice_Default_Drivers="$2"
			;;
		winedevice-Fix_Relocation)
			enable_winedevice_Fix_Relocation="$2"
			;;
		winemenubuilder-Desktop_Icon_Path)
			enable_winemenubuilder_Desktop_Icon_Path="$2"
			;;
		winemp3.acm-MPEG3_StreamOpen)
			enable_winemp3_acm_MPEG3_StreamOpen="$2"
			;;
		wineps.drv-PostScript_Fixes)
			enable_wineps_drv_PostScript_Fixes="$2"
			;;
		winepulse-PulseAudio_Support)
			enable_winepulse_PulseAudio_Support="$2"
			;;
		winex11-CandidateWindowPos)
			enable_winex11_CandidateWindowPos="$2"
			;;
		winex11-ClipCursor)
			enable_winex11_ClipCursor="$2"
			;;
		winex11-DefaultDisplayFrequency)
			enable_winex11_DefaultDisplayFrequency="$2"
			;;
		winex11-MWM_Decorations)
			enable_winex11_MWM_Decorations="$2"
			;;
		winex11-SC_KEYMENU)
			enable_winex11_SC_KEYMENU="$2"
			;;
		winex11-UpdateLayeredWindow)
			enable_winex11_UpdateLayeredWindow="$2"
			;;
		winex11-WM_WINDOWPOSCHANGING)
			enable_winex11_WM_WINDOWPOSCHANGING="$2"
			;;
		winex11-Window_Groups)
			enable_winex11_Window_Groups="$2"
			;;
		winex11-Window_Style)
			enable_winex11_Window_Style="$2"
			;;
		winex11-XEMBED)
			enable_winex11_XEMBED="$2"
			;;
		winex11-_NET_ACTIVE_WINDOW)
			enable_winex11__NET_ACTIVE_WINDOW="$2"
			;;
		winex11-wglShareLists)
			enable_winex11_wglShareLists="$2"
			;;
		winhlp32-Flex_Workaround)
			enable_winhlp32_Flex_Workaround="$2"
			;;
		winhttp-Accept_Headers)
			enable_winhttp_Accept_Headers="$2"
			;;
		winhttp-System_Proxy_Autoconfig)
			enable_winhttp_System_Proxy_Autoconfig="$2"
			;;
		wininet-Cleanup)
			enable_wininet_Cleanup="$2"
			;;
		wininet-Http_Decoding)
			enable_wininet_Http_Decoding="$2"
			;;
		wininet-InternetCrackUrlW)
			enable_wininet_InternetCrackUrlW="$2"
			;;
		wininet-Internet_Settings)
			enable_wininet_Internet_Settings="$2"
			;;
		wininet-ParseX509EncodedCertificateForListBoxEntry)
			enable_wininet_ParseX509EncodedCertificateForListBoxEntry="$2"
			;;
		wininet-Redirect)
			enable_wininet_Redirect="$2"
			;;
		winmm-Delay_Import_Depends)
			enable_winmm_Delay_Import_Depends="$2"
			;;
		winmm-mciSendCommandA)
			enable_winmm_mciSendCommandA="$2"
			;;
		wintrust-WinVerifyTrust)
			enable_wintrust_WinVerifyTrust="$2"
			;;
		wpcap-Dynamic_Linking)
			enable_wpcap_Dynamic_Linking="$2"
			;;
		wpcap-Several_Fixes)
			enable_wpcap_Several_Fixes="$2"
			;;
		ws2_32-APC_Performance)
			enable_ws2_32_APC_Performance="$2"
			;;
		ws2_32-Connect_Time)
			enable_ws2_32_Connect_Time="$2"
			;;
		ws2_32-Tests)
			enable_ws2_32_Tests="$2"
			;;
		ws2_32-TransmitFile)
			enable_ws2_32_TransmitFile="$2"
			;;
		ws2_32-WSACleanup)
			enable_ws2_32_WSACleanup="$2"
			;;
		ws2_32-getaddrinfo)
			enable_ws2_32_getaddrinfo="$2"
			;;
		ws2_32-getsockopt)
			enable_ws2_32_getsockopt="$2"
			;;
		ws2_32-setsockopt)
			enable_ws2_32_setsockopt="$2"
			;;
		wtsapi32-EnumerateProcesses)
			enable_wtsapi32_EnumerateProcesses="$2"
			;;
		wtsapi32-WTSQueryUserToken)
			enable_wtsapi32_WTSQueryUserToken="$2"
			;;
		wuauserv-Dummy_Service)
			enable_wuauserv_Dummy_Service="$2"
			;;
		wusa-MSU_Package_Installer)
			enable_wusa_MSU_Package_Installer="$2"
			;;
		xaudio2-get_al_format)
			enable_xaudio2_get_al_format="$2"
			;;
		xaudio2_7-OnVoiceProcessingPassStart)
			enable_xaudio2_7_OnVoiceProcessingPassStart="$2"
			;;
		*)
			return 1
			;;
	esac
	return 0
}

# Default settings
patch_enable_all 0
enable_patchlist=1
enable_autoconf=1
patchlist="/dev/null"
backend="patch"

# Find location of patches
patchdir="$(cd "$(dirname "$0")" && pwd)"
if test ! -f "$patchdir/patchinstall.sh"; then
	if test -f ./patchinstall.sh; then
		patchdir="$(pwd)"
	else
		abort "Failed to find patch directory."
	fi
fi

# Parse commandline arguments
if test "$#" -eq 0; then
	abort "No commandline arguments given, don't know what to do."
fi

while test "$#" -gt 0; do
	case "$1" in
		DESTDIR=*)
			DESTDIR="${1#*=}"
			shift
			;;

		--all)
			patch_enable_all 1
			shift
			;;

		--backend=*)
			backend="${1#*=}"
			shift
			;;

		--force-autoconf)
			enable_autoconf=2
			shift
			;;

		--help)
			usage
			exit 0
			;;

		--no-patchlist)
			enable_patchlist=0
			shift
			;;

		--no-autoconf)
			enable_autoconf=0
			shift
			;;

		--upstream-commit)
			upstream_commit
			exit 0
			;;

		--version)
			version
			exit 0
			;;

		-W)
			# Disable patchset
			if ! patch_enable "$2" 2; then
				abort "Wrong usage of -W commandline argument, expected patchname."
			fi
			shift
			shift
			;;

		*)
			# Enable patchset
			if ! patch_enable "$1" 1; then
				abort "Unknown commandline argument $1."
			fi
			shift
			;;
	esac
done

# Determine DESTDIR if not explicitly specified
if test -z "$DESTDIR" -a -f ./tools/make_requests; then
	DESTDIR="$(pwd)"

elif test ! -f "$DESTDIR/tools/make_requests"; then
	abort "DESTDIR does not point to the Wine source tree."
fi

# Change directory to DESTDIR, eapply/epatch depends on that
if ! cd "$DESTDIR"; then
	abort "Unable to change directory to $DESTDIR."
fi

# Helper to update configure / the wineserver protocol if required
if ! command -v diff >/dev/null 2>&1 ||
   ! command -v grep >/dev/null 2>&1 ||
   ! command -v cmp >/dev/null 2>&1; then

	update_configure()
	{
		autoreconf -f
	}

	update_protocol()
	{
		./tools/make_requests
	}

else

	update_configure()
	{
		_file="./configure"

		if ! cp -a "$_file" "$_file.old"; then
			abort "failed to create $_file.old"
		fi

		if ! autoreconf -f; then
			rm "$_file.old"
			unset _file
			return 1
		fi

		# Shifting by 62 bits is undefined behaviour when off_t is 32-bit, see also
		# https://launchpad.net/ubuntu/+source/autoconf/2.69-6 - the bug is still
		# present in some other distros (including Archlinux).
		_large_off_old="^#define LARGE_OFF_T (((off_t) 1 << 62) - 1 + ((off_t) 1 << 62))\$"
		_large_off_new="#define LARGE_OFF_T ((((off_t) 1 << 31) << 31) - 1 + (((off_t) 1 << 31) << 31))"
		sed -i'' -e "s|$_large_off_old|$_large_off_new|g" "$_file"
		unset _large_off_old _large_off_new

		# Restore original timestamp when nothing changed
		if ! cmp "$_file.old" "$_file" >/dev/null; then
			rm "$_file.old"
		else
			mv "$_file.old" "$_file"
		fi

		unset _file
		return 0
	}

	update_protocol()
	{
		_file="./include/wine/server_protocol.h"

		if ! cp -a "$_file" "$_file.old"; then
			abort "failed to create $_file.old"
		fi

		if ! ./tools/make_requests; then
			rm "$_file.old"
			unset _file
			return 1
		fi

		# Restore original timestamp when nothing changed
		if diff -u "$_file.old" "$_file" |
		   grep -v "^[+-]#define SERVER_PROTOCOL_VERSION" |
		   grep -v "^\(+++\|---\)" | grep -q "^[+-]"; then
			rm "$_file.old"
		else
			mv "$_file.old" "$_file"
		fi

		unset _file
		return 0
	}
fi


# Most backends will try to use git, either directly or indirectly.
# Unfortunately this does not work when "$DESTDIR" points to a
# subdirectory of a git tree, which has the effect that no patches
# are applied, but the exitcode is zero. To avoid broken builds we
# will workaround this issue or abort.
test ! -d ".git" && git rev-parse --git-dir >/dev/null 2>&1
workaround_git_bug="$?"

# Apply the patches using gitapply.sh, a small wrapper around 'patch'
if test "$backend" = "patch"; then

	if test "$workaround_git_bug" -eq 0; then
		gitapply_args="--nogit"
	else
		gitapply_args=""
	fi

	if test "$enable_autoconf" -gt 1; then
		warning "Ignoring commandline argument --force-autoconf."
		enable_autoconf=1
	fi

	patch_apply_file()
	{
		printf '%s\n' "Applying $1"
		if ! "$patchdir/gitapply.sh" $gitapply_args < "$1"; then
			abort "Failed to apply patch, aborting!"
		fi
	}

# 'eapply/epatch' backend - used on Gentoo
elif test "$backend" = "eapply" -o "$backend" = "epatch"; then

	if test "$workaround_git_bug" -eq 0; then
		gitapply_args="--nogit"
	else
		gitapply_args=""
	fi

	if ! command -v "$backend"  >/dev/null 2>&1 || \
	   ! command -v ebegin      >/dev/null 2>&1 || \
	   ! command -v eend        >/dev/null 2>&1 || \
	   ! command -v nonfatal    >/dev/null 2>&1; then
		abort "Shell functions $backend/ebegin/eend/nonfatal not found. You have to source this script from your ebuild."
	fi

	if test "$enable_autoconf" -gt 1; then
		warning "Ignoring commandline argument --force-autoconf."
		enable_autoconf=1
	fi

	patch_apply_file()
	{
		_shortname="$(basename "$1")"
		if grep -q "^GIT binary patch" "$1"; then
			ebegin "Applying $_shortname"
			"$patchdir/gitapply.sh" $gitapply_args < "$1"
			if ! eend $?; then
				exit 1
			fi
		else
			# we are run from a subshell, so we can't call die
			if ! nonfatal "$backend" "$1"; then
				exit 1
			fi
		fi
		unset _shortname
	}

# GIT backend - apply patches using 'git am'
elif test "$backend" = "git" -o "$backend" = "git-am"; then

	if test "$workaround_git_bug" -eq 0; then
		abort "Backend 'git-am' not possible when DESTDIR points to a git subdirectory."
	fi

	patch_apply_file()
	{
		printf '%s\n' "Applying $1"
		if ! git am "$1"; then
			abort "Failed to apply patch, aborting!"
		fi
		if test "$enable_autoconf" -gt 1; then
			_do_commit=0

			# Run 'autoreconf -f' if required
			if git show --pretty=format: --name-only | grep -q "^\(configure.ac\|aclocal.m4\)$"; then
				if ! update_configure; then
					abort "'autoreconf -f' failed."
				fi
				git add ./configure
				git add ./include/config.h.in
				_do_commit=1
			fi

			# Run './tools/make_requests' if required
			if git show --pretty=format: --name-only | grep -q "^server/"; then
				if ! update_protocol; then
					abort "'./tools/make_requests' failed."
				fi
				git add ./include/wine/server_protocol.h
				git add ./server/trace.c
				git add ./server/request.h
				_do_commit=1
			fi

			if test "$_do_commit" -ne 0; then
				if ! git commit --amend --reuse-message HEAD; then
					abort "Failed to include autogenerated changes in commit."
				fi
			fi

			unset _do_commit
		fi
	}

# Git apply backend
elif test "$backend" = "git-apply"; then

	if test "$workaround_git_bug" -eq 0; then
		abort "Backend 'git-apply' not possible when DESTDIR points to a git subdirectory."
	fi

	if test "$enable_autoconf" -gt 1; then
		warning "Ignoring commandline argument --force-autoconf."
		enable_autoconf=1
	fi

	patch_apply_file()
	{
		printf '%s\n' "Applying $1"
		if ! git apply "$1"; then
			abort "Failed to apply patch, aborting!"
		fi
	}

# Stacked GIT backend - import the patches (mainly for developers)
elif test "$backend" = "stg"; then

	if test "$workaround_git_bug" -eq 0; then
		abort "Backend 'stg' not possible when DESTDIR points to a git subdirectory."
	fi

	# Only import the regular patches, no autogenerated ones -
	# moreover, don't run autoreconf or ./tools/make_requests.
	enable_patchlist=0
	enable_autoconf=0

	patch_apply_file()
	{
		printf '%s\n' "Applying $1"
		_shortname="$(basename "$1")"
		if ! printf '%s\n' "staging/$_shortname" | cat - "$1" | stg import; then
			abort "Failed to apply patch, aborting!"
		fi
		unset _shortname
	}

else
	abort "Selected backend $backend not supported."
fi

patch_apply()
{
	patch_apply_file "$patchdir/$1"
}


if test "$enable_ws2_32_WSACleanup" -eq 1; then
	if test "$enable_server_Desktop_Refcount" -gt 1; then
		abort "Patchset server-Desktop_Refcount disabled, but ws2_32-WSACleanup depends on that."
	fi
	enable_server_Desktop_Refcount=1
fi

if test "$enable_ws2_32_TransmitFile" -eq 1; then
	if test "$enable_server_Desktop_Refcount" -gt 1; then
		abort "Patchset server-Desktop_Refcount disabled, but ws2_32-TransmitFile depends on that."
	fi
	enable_server_Desktop_Refcount=1
fi

if test "$enable_wpcap_Dynamic_Linking" -eq 1; then
	if test "$enable_wpcap_Several_Fixes" -gt 1; then
		abort "Patchset wpcap-Several_Fixes disabled, but wpcap-Dynamic_Linking depends on that."
	fi
	enable_wpcap_Several_Fixes=1
fi

if test "$enable_wininet_Redirect" -eq 1; then
	if test "$enable_wininet_Cleanup" -gt 1; then
		abort "Patchset wininet-Cleanup disabled, but wininet-Redirect depends on that."
	fi
	enable_wininet_Cleanup=1
fi

if test "$enable_winex11_WM_WINDOWPOSCHANGING" -eq 1; then
	if test "$enable_winex11__NET_ACTIVE_WINDOW" -gt 1; then
		abort "Patchset winex11-_NET_ACTIVE_WINDOW disabled, but winex11-WM_WINDOWPOSCHANGING depends on that."
	fi
	enable_winex11__NET_ACTIVE_WINDOW=1
fi

if test "$enable_wined3d_CSMT_Main" -eq 1; then
	if test "$enable_wined3d_CSMT_Helper" -gt 1; then
		abort "Patchset wined3d-CSMT_Helper disabled, but wined3d-CSMT_Main depends on that."
	fi
	enable_wined3d_CSMT_Helper=1
fi

if test "$enable_wined3d_dxgi_swapchain_Present" -eq 1; then
	if test "$enable_dxgi_DXGI_PRESENT_TEST" -gt 1; then
		abort "Patchset dxgi-DXGI_PRESENT_TEST disabled, but wined3d-dxgi_swapchain_Present depends on that."
	fi
	if test "$enable_wined3d_Silence_FIXMEs" -gt 1; then
		abort "Patchset wined3d-Silence_FIXMEs disabled, but wined3d-dxgi_swapchain_Present depends on that."
	fi
	enable_dxgi_DXGI_PRESENT_TEST=1
	enable_wined3d_Silence_FIXMEs=1
fi

if test "$enable_wined3d_Indexed_Vertex_Blending" -eq 1; then
	if test "$enable_wined3d_WINED3D_RS_COLORWRITEENABLE" -gt 1; then
		abort "Patchset wined3d-WINED3D_RS_COLORWRITEENABLE disabled, but wined3d-Indexed_Vertex_Blending depends on that."
	fi
	enable_wined3d_WINED3D_RS_COLORWRITEENABLE=1
fi

if test "$enable_wined3d_WINED3D_RS_COLORWRITEENABLE" -eq 1; then
	if test "$enable_d3d11_Depth_Bias" -gt 1; then
		abort "Patchset d3d11-Depth_Bias disabled, but wined3d-WINED3D_RS_COLORWRITEENABLE depends on that."
	fi
	enable_d3d11_Depth_Bias=1
fi

if test "$enable_wined3d_CSMT_Helper" -eq 1; then
	if test "$enable_d3d11_Deferred_Context" -gt 1; then
		abort "Patchset d3d11-Deferred_Context disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_d3d9_Tests" -gt 1; then
		abort "Patchset d3d9-Tests disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_makedep_PARENTSPEC" -gt 1; then
		abort "Patchset makedep-PARENTSPEC disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_ntdll_DllRedirects" -gt 1; then
		abort "Patchset ntdll-DllRedirects disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_wined3d_1DTextures" -gt 1; then
		abort "Patchset wined3d-1DTextures disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_wined3d_Accounting" -gt 1; then
		abort "Patchset wined3d-Accounting disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_wined3d_Copy_Resource_Typeless" -gt 1; then
		abort "Patchset wined3d-Copy_Resource_Typeless disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_wined3d_DXTn" -gt 1; then
		abort "Patchset wined3d-DXTn disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_wined3d_Dual_Source_Blending" -gt 1; then
		abort "Patchset wined3d-Dual_Source_Blending disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_wined3d_GenerateMips" -gt 1; then
		abort "Patchset wined3d-GenerateMips disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_wined3d_QUERY_Stubs" -gt 1; then
		abort "Patchset wined3d-QUERY_Stubs disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_wined3d_Revert_Buffer_Upload" -gt 1; then
		abort "Patchset wined3d-Revert_Buffer_Upload disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_wined3d_Silence_FIXMEs" -gt 1; then
		abort "Patchset wined3d-Silence_FIXMEs disabled, but wined3d-CSMT_Helper depends on that."
	fi
	if test "$enable_wined3d_UAV_Counters" -gt 1; then
		abort "Patchset wined3d-UAV_Counters disabled, but wined3d-CSMT_Helper depends on that."
	fi
	enable_d3d11_Deferred_Context=1
	enable_d3d9_Tests=1
	enable_makedep_PARENTSPEC=1
	enable_ntdll_DllRedirects=1
	enable_wined3d_1DTextures=1
	enable_wined3d_Accounting=1
	enable_wined3d_Copy_Resource_Typeless=1
	enable_wined3d_DXTn=1
	enable_wined3d_Dual_Source_Blending=1
	enable_wined3d_GenerateMips=1
	enable_wined3d_QUERY_Stubs=1
	enable_wined3d_Revert_Buffer_Upload=1
	enable_wined3d_Silence_FIXMEs=1
	enable_wined3d_UAV_Counters=1
fi

if test "$enable_wined3d_GenerateMips" -eq 1; then
	if test "$enable_wined3d_Copy_Resource_Typeless" -gt 1; then
		abort "Patchset wined3d-Copy_Resource_Typeless disabled, but wined3d-GenerateMips depends on that."
	fi
	if test "$enable_wined3d_Dual_Source_Blending" -gt 1; then
		abort "Patchset wined3d-Dual_Source_Blending disabled, but wined3d-GenerateMips depends on that."
	fi
	enable_wined3d_Copy_Resource_Typeless=1
	enable_wined3d_Dual_Source_Blending=1
fi

if test "$enable_wined3d_Dual_Source_Blending" -eq 1; then
	if test "$enable_wined3d_Viewports" -gt 1; then
		abort "Patchset wined3d-Viewports disabled, but wined3d-Dual_Source_Blending depends on that."
	fi
	enable_wined3d_Viewports=1
fi

if test "$enable_wined3d_Viewports" -eq 1; then
	if test "$enable_wined3d_Core_Context" -gt 1; then
		abort "Patchset wined3d-Core_Context disabled, but wined3d-Viewports depends on that."
	fi
	enable_wined3d_Core_Context=1
fi

if test "$enable_wined3d_Core_Context" -eq 1; then
	if test "$enable_d3d11_Depth_Bias" -gt 1; then
		abort "Patchset d3d11-Depth_Bias disabled, but wined3d-Core_Context depends on that."
	fi
	enable_d3d11_Depth_Bias=1
fi

if test "$enable_wined3d_Copy_Resource_Typeless" -eq 1; then
	if test "$enable_d3d11_Depth_Bias" -gt 1; then
		abort "Patchset d3d11-Depth_Bias disabled, but wined3d-Copy_Resource_Typeless depends on that."
	fi
	if test "$enable_wined3d_1DTextures" -gt 1; then
		abort "Patchset wined3d-1DTextures disabled, but wined3d-Copy_Resource_Typeless depends on that."
	fi
	enable_d3d11_Depth_Bias=1
	enable_wined3d_1DTextures=1
fi

if test "$enable_winebuild_Fake_Dlls" -eq 1; then
	if test "$enable_ntdll_User_Shared_Data" -gt 1; then
		abort "Patchset ntdll-User_Shared_Data disabled, but winebuild-Fake_Dlls depends on that."
	fi
	enable_ntdll_User_Shared_Data=1
fi

if test "$enable_wineboot_ProxySettings" -eq 1; then
	if test "$enable_wineboot_DriveSerial" -gt 1; then
		abort "Patchset wineboot-DriveSerial disabled, but wineboot-ProxySettings depends on that."
	fi
	if test "$enable_wineboot_drivers_etc_Stubs" -gt 1; then
		abort "Patchset wineboot-drivers_etc_Stubs disabled, but wineboot-ProxySettings depends on that."
	fi
	enable_wineboot_DriveSerial=1
	enable_wineboot_drivers_etc_Stubs=1
fi

if test "$enable_windowscodecs_32bppPRGBA" -eq 1; then
	if test "$enable_windowscodecs_TIFF_Support" -gt 1; then
		abort "Patchset windowscodecs-TIFF_Support disabled, but windowscodecs-32bppPRGBA depends on that."
	fi
	enable_windowscodecs_TIFF_Support=1
fi

if test "$enable_windowscodecs_TIFF_Support" -eq 1; then
	if test "$enable_windowscodecs_GIF_Encoder" -gt 1; then
		abort "Patchset windowscodecs-GIF_Encoder disabled, but windowscodecs-TIFF_Support depends on that."
	fi
	if test "$enable_windowscodecs_IWICPalette_InitializeFromBitmap" -gt 1; then
		abort "Patchset windowscodecs-IWICPalette_InitializeFromBitmap disabled, but windowscodecs-TIFF_Support depends on that."
	fi
	enable_windowscodecs_GIF_Encoder=1
	enable_windowscodecs_IWICPalette_InitializeFromBitmap=1
fi

if test "$enable_windowscodecs_GIF_Encoder" -eq 1; then
	if test "$enable_windowscodecs_Palette_Images" -gt 1; then
		abort "Patchset windowscodecs-Palette_Images disabled, but windowscodecs-GIF_Encoder depends on that."
	fi
	enable_windowscodecs_Palette_Images=1
fi

if test "$enable_uxtheme_GTK_Theming" -eq 1; then
	if test "$enable_ntdll_DllRedirects" -gt 1; then
		abort "Patchset ntdll-DllRedirects disabled, but uxtheme-GTK_Theming depends on that."
	fi
	enable_ntdll_DllRedirects=1
fi

if test "$enable_user32_Sorted_Listbox" -eq 1; then
	if test "$enable_user32_WM_MEASUREITEM" -gt 1; then
		abort "Patchset user32-WM_MEASUREITEM disabled, but user32-Sorted_Listbox depends on that."
	fi
	enable_user32_WM_MEASUREITEM=1
fi

if test "$enable_user32_MessageBox_WS_EX_TOPMOST" -eq 1; then
	if test "$enable_user32_lpCreateParams" -gt 1; then
		abort "Patchset user32-lpCreateParams disabled, but user32-MessageBox_WS_EX_TOPMOST depends on that."
	fi
	enable_user32_lpCreateParams=1
fi

if test "$enable_stdole32_tlb_SLTG_Typelib" -eq 1; then
	if test "$enable_widl_SLTG_Typelib_Support" -gt 1; then
		abort "Patchset widl-SLTG_Typelib_Support disabled, but stdole32.tlb-SLTG_Typelib depends on that."
	fi
	enable_widl_SLTG_Typelib_Support=1
fi

if test "$enable_shell32_SHFileOperation_Win9x" -eq 1; then
	if test "$enable_shell32_Progress_Dialog" -gt 1; then
		abort "Patchset shell32-Progress_Dialog disabled, but shell32-SHFileOperation_Win9x depends on that."
	fi
	enable_shell32_Progress_Dialog=1
fi

if test "$enable_shell32_ACE_Viewer" -eq 1; then
	if test "$enable_shell32_File_Property_Dialog" -gt 1; then
		abort "Patchset shell32-File_Property_Dialog disabled, but shell32-ACE_Viewer depends on that."
	fi
	if test "$enable_shell32_Progress_Dialog" -gt 1; then
		abort "Patchset shell32-Progress_Dialog disabled, but shell32-ACE_Viewer depends on that."
	fi
	enable_shell32_File_Property_Dialog=1
	enable_shell32_Progress_Dialog=1
fi

if test "$enable_shell32_Progress_Dialog" -eq 1; then
	if test "$enable_kernel32_CopyFileEx" -gt 1; then
		abort "Patchset kernel32-CopyFileEx disabled, but shell32-Progress_Dialog depends on that."
	fi
	if test "$enable_shell32_SHFileOperation_Move" -gt 1; then
		abort "Patchset shell32-SHFileOperation_Move disabled, but shell32-Progress_Dialog depends on that."
	fi
	enable_kernel32_CopyFileEx=1
	enable_shell32_SHFileOperation_Move=1
fi

if test "$enable_server_Realtime_Priority" -eq 1; then
	if test "$enable_ntdll_ThreadTime" -gt 1; then
		abort "Patchset ntdll-ThreadTime disabled, but server-Realtime_Priority depends on that."
	fi
	enable_ntdll_ThreadTime=1
fi

if test "$enable_server_Pipe_ObjectName" -eq 1; then
	if test "$enable_server_Desktop_Refcount" -gt 1; then
		abort "Patchset server-Desktop_Refcount disabled, but server-Pipe_ObjectName depends on that."
	fi
	enable_server_Desktop_Refcount=1
fi

if test "$enable_server_Object_Types" -eq 1; then
	if test "$enable_server_Misc_ACL" -gt 1; then
		abort "Patchset server-Misc_ACL disabled, but server-Object_Types depends on that."
	fi
	if test "$enable_server_Shared_Memory" -gt 1; then
		abort "Patchset server-Shared_Memory disabled, but server-Object_Types depends on that."
	fi
	enable_server_Misc_ACL=1
	enable_server_Shared_Memory=1
fi

if test "$enable_server_Shared_Memory" -eq 1; then
	if test "$enable_ntdll_Threading" -gt 1; then
		abort "Patchset ntdll-Threading disabled, but server-Shared_Memory depends on that."
	fi
	if test "$enable_server_ClipCursor" -gt 1; then
		abort "Patchset server-ClipCursor disabled, but server-Shared_Memory depends on that."
	fi
	if test "$enable_server_Key_State" -gt 1; then
		abort "Patchset server-Key_State disabled, but server-Shared_Memory depends on that."
	fi
	if test "$enable_server_PeekMessage" -gt 1; then
		abort "Patchset server-PeekMessage disabled, but server-Shared_Memory depends on that."
	fi
	if test "$enable_server_Signal_Thread" -gt 1; then
		abort "Patchset server-Signal_Thread disabled, but server-Shared_Memory depends on that."
	fi
	enable_ntdll_Threading=1
	enable_server_ClipCursor=1
	enable_server_Key_State=1
	enable_server_PeekMessage=1
	enable_server_Signal_Thread=1
fi

if test "$enable_server_Inherited_ACLs" -eq 1; then
	if test "$enable_server_Stored_ACLs" -gt 1; then
		abort "Patchset server-Stored_ACLs disabled, but server-Inherited_ACLs depends on that."
	fi
	enable_server_Stored_ACLs=1
fi

if test "$enable_server_Stored_ACLs" -eq 1; then
	if test "$enable_ntdll_DOS_Attributes" -gt 1; then
		abort "Patchset ntdll-DOS_Attributes disabled, but server-Stored_ACLs depends on that."
	fi
	if test "$enable_server_File_Permissions" -gt 1; then
		abort "Patchset server-File_Permissions disabled, but server-Stored_ACLs depends on that."
	fi
	enable_ntdll_DOS_Attributes=1
	enable_server_File_Permissions=1
fi

if test "$enable_oleaut32_OLEPictureImpl_SaveAsFile" -eq 1; then
	if test "$enable_oleaut32_Load_Save_EMF" -gt 1; then
		abort "Patchset oleaut32-Load_Save_EMF disabled, but oleaut32-OLEPictureImpl_SaveAsFile depends on that."
	fi
	enable_oleaut32_Load_Save_EMF=1
fi

if test "$enable_nvencodeapi_Video_Encoder" -eq 1; then
	if test "$enable_nvcuvid_CUDA_Video_Support" -gt 1; then
		abort "Patchset nvcuvid-CUDA_Video_Support disabled, but nvencodeapi-Video_Encoder depends on that."
	fi
	enable_nvcuvid_CUDA_Video_Support=1
fi

if test "$enable_nvcuvid_CUDA_Video_Support" -eq 1; then
	if test "$enable_nvapi_Stub_DLL" -gt 1; then
		abort "Patchset nvapi-Stub_DLL disabled, but nvcuvid-CUDA_Video_Support depends on that."
	fi
	enable_nvapi_Stub_DLL=1
fi

if test "$enable_nvapi_Stub_DLL" -eq 1; then
	if test "$enable_nvcuda_CUDA_Support" -gt 1; then
		abort "Patchset nvcuda-CUDA_Support disabled, but nvapi-Stub_DLL depends on that."
	fi
	enable_nvcuda_CUDA_Support=1
fi

if test "$enable_ntdll_SystemRoot_Symlink" -eq 1; then
	if test "$enable_ntdll_Exception" -gt 1; then
		abort "Patchset ntdll-Exception disabled, but ntdll-SystemRoot_Symlink depends on that."
	fi
	enable_ntdll_Exception=1
fi

if test "$enable_ntdll_Signal_Handler" -eq 1; then
	if test "$enable_ntdll_WRITECOPY" -gt 1; then
		abort "Patchset ntdll-WRITECOPY disabled, but ntdll-Signal_Handler depends on that."
	fi
	enable_ntdll_WRITECOPY=1
fi

if test "$enable_ntdll_WRITECOPY" -eq 1; then
	if test "$enable_ntdll_User_Shared_Data" -gt 1; then
		abort "Patchset ntdll-User_Shared_Data disabled, but ntdll-WRITECOPY depends on that."
	fi
	enable_ntdll_User_Shared_Data=1
fi

if test "$enable_ntdll_RtlIpStringToAddress_Tests" -eq 1; then
	if test "$enable_ntdll_RtlQueryPackageIdentity" -gt 1; then
		abort "Patchset ntdll-RtlQueryPackageIdentity disabled, but ntdll-RtlIpStringToAddress_Tests depends on that."
	fi
	enable_ntdll_RtlQueryPackageIdentity=1
fi

if test "$enable_ntdll_RtlGetUnloadEventTraceEx" -eq 1; then
	if test "$enable_ntdll_RtlQueryPackageIdentity" -gt 1; then
		abort "Patchset ntdll-RtlQueryPackageIdentity disabled, but ntdll-RtlGetUnloadEventTraceEx depends on that."
	fi
	enable_ntdll_RtlQueryPackageIdentity=1
fi

if test "$enable_ntdll_Purist_Mode" -eq 1; then
	if test "$enable_ntdll_DllRedirects" -gt 1; then
		abort "Patchset ntdll-DllRedirects disabled, but ntdll-Purist_Mode depends on that."
	fi
	enable_ntdll_DllRedirects=1
fi

if test "$enable_ntdll_NtSuspendProcess" -eq 1; then
	if test "$enable_kernel32_K32GetPerformanceInfo" -gt 1; then
		abort "Patchset kernel32-K32GetPerformanceInfo disabled, but ntdll-NtSuspendProcess depends on that."
	fi
	enable_kernel32_K32GetPerformanceInfo=1
fi

if test "$enable_ntdll_NtQueryVirtualMemory" -eq 1; then
	if test "$enable_ntdll_NtDevicePath" -gt 1; then
		abort "Patchset ntdll-NtDevicePath disabled, but ntdll-NtQueryVirtualMemory depends on that."
	fi
	enable_ntdll_NtDevicePath=1
fi

if test "$enable_ntdll_NtDevicePath" -eq 1; then
	if test "$enable_ntdll_Pipe_SpecialCharacters" -gt 1; then
		abort "Patchset ntdll-Pipe_SpecialCharacters disabled, but ntdll-NtDevicePath depends on that."
	fi
	enable_ntdll_Pipe_SpecialCharacters=1
fi

if test "$enable_ntdll_LdrRegisterDllNotification" -eq 1; then
	if test "$enable_ntdll_HashLinks" -gt 1; then
		abort "Patchset ntdll-HashLinks disabled, but ntdll-LdrRegisterDllNotification depends on that."
	fi
	if test "$enable_ntdll_Hide_Wine_Exports" -gt 1; then
		abort "Patchset ntdll-Hide_Wine_Exports disabled, but ntdll-LdrRegisterDllNotification depends on that."
	fi
	if test "$enable_ntdll_RtlQueryPackageIdentity" -gt 1; then
		abort "Patchset ntdll-RtlQueryPackageIdentity disabled, but ntdll-LdrRegisterDllNotification depends on that."
	fi
	enable_ntdll_HashLinks=1
	enable_ntdll_Hide_Wine_Exports=1
	enable_ntdll_RtlQueryPackageIdentity=1
fi

if test "$enable_ntdll_Junction_Points" -eq 1; then
	if test "$enable_ntdll_NtQueryEaFile" -gt 1; then
		abort "Patchset ntdll-NtQueryEaFile disabled, but ntdll-Junction_Points depends on that."
	fi
	enable_ntdll_NtQueryEaFile=1
fi

if test "$enable_ntdll_NtQueryEaFile" -eq 1; then
	if test "$enable_kernel32_SetFileCompletionNotificationModes" -gt 1; then
		abort "Patchset kernel32-SetFileCompletionNotificationModes disabled, but ntdll-NtQueryEaFile depends on that."
	fi
	enable_kernel32_SetFileCompletionNotificationModes=1
fi

if test "$enable_ntdll_HashLinks" -eq 1; then
	if test "$enable_ntdll_CLI_Images" -gt 1; then
		abort "Patchset ntdll-CLI_Images disabled, but ntdll-HashLinks depends on that."
	fi
	if test "$enable_ntdll_LDR_MODULE" -gt 1; then
		abort "Patchset ntdll-LDR_MODULE disabled, but ntdll-HashLinks depends on that."
	fi
	enable_ntdll_CLI_Images=1
	enable_ntdll_LDR_MODULE=1
fi

if test "$enable_ntdll_DllRedirects" -eq 1; then
	if test "$enable_ntdll_Attach_Process_DLLs" -gt 1; then
		abort "Patchset ntdll-Attach_Process_DLLs disabled, but ntdll-DllRedirects depends on that."
	fi
	if test "$enable_ntdll_DllOverrides_WOW64" -gt 1; then
		abort "Patchset ntdll-DllOverrides_WOW64 disabled, but ntdll-DllRedirects depends on that."
	fi
	if test "$enable_ntdll_Loader_Machine_Type" -gt 1; then
		abort "Patchset ntdll-Loader_Machine_Type disabled, but ntdll-DllRedirects depends on that."
	fi
	enable_ntdll_Attach_Process_DLLs=1
	enable_ntdll_DllOverrides_WOW64=1
	enable_ntdll_Loader_Machine_Type=1
fi

if test "$enable_ntdll_CLI_Images" -eq 1; then
	if test "$enable_mscoree_CorValidateImage" -gt 1; then
		abort "Patchset mscoree-CorValidateImage disabled, but ntdll-CLI_Images depends on that."
	fi
	if test "$enable_ntdll_APC_Start_Process" -gt 1; then
		abort "Patchset ntdll-APC_Start_Process disabled, but ntdll-CLI_Images depends on that."
	fi
	enable_mscoree_CorValidateImage=1
	enable_ntdll_APC_Start_Process=1
fi

if test "$enable_ntdll_Builtin_Prot" -eq 1; then
	if test "$enable_ntdll_User_Shared_Data" -gt 1; then
		abort "Patchset ntdll-User_Shared_Data disabled, but ntdll-Builtin_Prot depends on that."
	fi
	if test "$enable_ntdll_x86_64_ExceptionInformation" -gt 1; then
		abort "Patchset ntdll-x86_64_ExceptionInformation disabled, but ntdll-Builtin_Prot depends on that."
	fi
	enable_ntdll_User_Shared_Data=1
	enable_ntdll_x86_64_ExceptionInformation=1
fi

if test "$enable_ntdll_User_Shared_Data" -eq 1; then
	if test "$enable_ntdll_Hide_Wine_Exports" -gt 1; then
		abort "Patchset ntdll-Hide_Wine_Exports disabled, but ntdll-User_Shared_Data depends on that."
	fi
	if test "$enable_ntdll_x86_64_ExceptionInformation" -gt 1; then
		abort "Patchset ntdll-x86_64_ExceptionInformation disabled, but ntdll-User_Shared_Data depends on that."
	fi
	enable_ntdll_Hide_Wine_Exports=1
	enable_ntdll_x86_64_ExceptionInformation=1
fi

if test "$enable_ntdll_Hide_Wine_Exports" -eq 1; then
	if test "$enable_ntdll_Attach_Process_DLLs" -gt 1; then
		abort "Patchset ntdll-Attach_Process_DLLs disabled, but ntdll-Hide_Wine_Exports depends on that."
	fi
	if test "$enable_ntdll_ThreadTime" -gt 1; then
		abort "Patchset ntdll-ThreadTime disabled, but ntdll-Hide_Wine_Exports depends on that."
	fi
	enable_ntdll_Attach_Process_DLLs=1
	enable_ntdll_ThreadTime=1
fi

if test "$enable_ntdll_ApiSetMap" -eq 1; then
	if test "$enable_ntdll_ThreadTime" -gt 1; then
		abort "Patchset ntdll-ThreadTime disabled, but ntdll-ApiSetMap depends on that."
	fi
	enable_ntdll_ThreadTime=1
fi

if test "$enable_msi_MsiGetDatabaseState" -eq 1; then
	if test "$enable_ntoskrnl_DriverTest" -gt 1; then
		abort "Patchset ntoskrnl-DriverTest disabled, but msi-MsiGetDatabaseState depends on that."
	fi
	enable_ntoskrnl_DriverTest=1
fi

if test "$enable_ntoskrnl_DriverTest" -eq 1; then
	if test "$enable_ntoskrnl_Stubs" -gt 1; then
		abort "Patchset ntoskrnl-Stubs disabled, but ntoskrnl-DriverTest depends on that."
	fi
	if test "$enable_winedevice_Default_Drivers" -gt 1; then
		abort "Patchset winedevice-Default_Drivers disabled, but ntoskrnl-DriverTest depends on that."
	fi
	enable_ntoskrnl_Stubs=1
	enable_winedevice_Default_Drivers=1
fi

if test "$enable_winedevice_Default_Drivers" -eq 1; then
	if test "$enable_dxva2_Video_Decoder" -gt 1; then
		abort "Patchset dxva2-Video_Decoder disabled, but winedevice-Default_Drivers depends on that."
	fi
	enable_dxva2_Video_Decoder=1
fi

if test "$enable_ntoskrnl_Stubs" -eq 1; then
	if test "$enable_Compiler_Warnings" -gt 1; then
		abort "Patchset Compiler_Warnings disabled, but ntoskrnl-Stubs depends on that."
	fi
	if test "$enable_ntdll_NtAllocateUuids" -gt 1; then
		abort "Patchset ntdll-NtAllocateUuids disabled, but ntoskrnl-Stubs depends on that."
	fi
	enable_Compiler_Warnings=1
	enable_ntdll_NtAllocateUuids=1
fi

if test "$enable_loader_OSX_Preloader" -eq 1; then
	if test "$enable_Staging" -gt 1; then
		abort "Patchset Staging disabled, but loader-OSX_Preloader depends on that."
	fi
	if test "$enable_configure_Absolute_RPATH" -gt 1; then
		abort "Patchset configure-Absolute_RPATH disabled, but loader-OSX_Preloader depends on that."
	fi
	enable_Staging=1
	enable_configure_Absolute_RPATH=1
fi

if test "$enable_kernel32_SetFileCompletionNotificationModes" -eq 1; then
	if test "$enable_ntdll_FileNameInformation" -gt 1; then
		abort "Patchset ntdll-FileNameInformation disabled, but kernel32-SetFileCompletionNotificationModes depends on that."
	fi
	enable_ntdll_FileNameInformation=1
fi

if test "$enable_kernel32_Processor_Group" -eq 1; then
	if test "$enable_api_ms_win_Stub_DLLs" -gt 1; then
		abort "Patchset api-ms-win-Stub_DLLs disabled, but kernel32-Processor_Group depends on that."
	fi
	enable_api_ms_win_Stub_DLLs=1
fi

if test "$enable_kernel32_PE_Loader_Fixes" -eq 1; then
	if test "$enable_kernel32_Misalign_Workaround" -gt 1; then
		abort "Patchset kernel32-Misalign_Workaround disabled, but kernel32-PE_Loader_Fixes depends on that."
	fi
	enable_kernel32_Misalign_Workaround=1
fi

if test "$enable_kernel32_CopyFileEx" -eq 1; then
	if test "$enable_ntdll_FileDispositionInformation" -gt 1; then
		abort "Patchset ntdll-FileDispositionInformation disabled, but kernel32-CopyFileEx depends on that."
	fi
	enable_ntdll_FileDispositionInformation=1
fi

if test "$enable_ntdll_FileDispositionInformation" -eq 1; then
	if test "$enable_server_File_Permissions" -gt 1; then
		abort "Patchset server-File_Permissions disabled, but ntdll-FileDispositionInformation depends on that."
	fi
	enable_server_File_Permissions=1
fi

if test "$enable_imagehlp_ImageLoad" -eq 1; then
	if test "$enable_imagehlp_Cleanup" -gt 1; then
		abort "Patchset imagehlp-Cleanup disabled, but imagehlp-ImageLoad depends on that."
	fi
	enable_imagehlp_Cleanup=1
fi

if test "$enable_dxdiagn_GetChildContainer_Leaf_Nodes" -eq 1; then
	if test "$enable_dxdiagn_Enumerate_DirectSound" -gt 1; then
		abort "Patchset dxdiagn-Enumerate_DirectSound disabled, but dxdiagn-GetChildContainer_Leaf_Nodes depends on that."
	fi
	enable_dxdiagn_Enumerate_DirectSound=1
fi

if test "$enable_dsound_EAX" -eq 1; then
	if test "$enable_dsound_Fast_Mixer" -gt 1; then
		abort "Patchset dsound-Fast_Mixer disabled, but dsound-EAX depends on that."
	fi
	if test "$enable_dsound_Revert_Cleanup" -gt 1; then
		abort "Patchset dsound-Revert_Cleanup disabled, but dsound-EAX depends on that."
	fi
	enable_dsound_Fast_Mixer=1
	enable_dsound_Revert_Cleanup=1
fi

if test "$enable_d3dx9_36_DXTn" -eq 1; then
	if test "$enable_d3dx9_25_ID3DXEffect" -gt 1; then
		abort "Patchset d3dx9_25-ID3DXEffect disabled, but d3dx9_36-DXTn depends on that."
	fi
	if test "$enable_wined3d_DXTn" -gt 1; then
		abort "Patchset wined3d-DXTn disabled, but d3dx9_36-DXTn depends on that."
	fi
	enable_d3dx9_25_ID3DXEffect=1
	enable_wined3d_DXTn=1
fi

if test "$enable_d3dx9_36_D3DXDisassembleShader" -eq 1; then
	if test "$enable_d3dx9_36_GetShaderSemantics" -gt 1; then
		abort "Patchset d3dx9_36-GetShaderSemantics disabled, but d3dx9_36-D3DXDisassembleShader depends on that."
	fi
	enable_d3dx9_36_GetShaderSemantics=1
fi

if test "$enable_d3dx9_36_CloneEffect" -eq 1; then
	if test "$enable_d3dx9_25_ID3DXEffect" -gt 1; then
		abort "Patchset d3dx9_25-ID3DXEffect disabled, but d3dx9_36-CloneEffect depends on that."
	fi
	enable_d3dx9_25_ID3DXEffect=1
fi

if test "$enable_d3d11_ID3D11Texture1D" -eq 1; then
	if test "$enable_wined3d_1DTextures" -gt 1; then
		abort "Patchset wined3d-1DTextures disabled, but d3d11-ID3D11Texture1D depends on that."
	fi
	enable_wined3d_1DTextures=1
fi

if test "$enable_d3d11_Deferred_Context" -eq 1; then
	if test "$enable_d3d11_ResolveSubresource" -gt 1; then
		abort "Patchset d3d11-ResolveSubresource disabled, but d3d11-Deferred_Context depends on that."
	fi
	if test "$enable_wined3d_1DTextures" -gt 1; then
		abort "Patchset wined3d-1DTextures disabled, but d3d11-Deferred_Context depends on that."
	fi
	enable_d3d11_ResolveSubresource=1
	enable_wined3d_1DTextures=1
fi

if test "$enable_crypt32_ECDSA_Cert_Chains" -eq 1; then
	if test "$enable_bcrypt_Improvements" -gt 1; then
		abort "Patchset bcrypt-Improvements disabled, but crypt32-ECDSA_Cert_Chains depends on that."
	fi
	enable_bcrypt_Improvements=1
fi

if test "$enable_api_ms_win_Stub_DLLs" -eq 1; then
	if test "$enable_combase_RoApi" -gt 1; then
		abort "Patchset combase-RoApi disabled, but api-ms-win-Stub_DLLs depends on that."
	fi
	if test "$enable_kernel32_UmsStubs" -gt 1; then
		abort "Patchset kernel32-UmsStubs disabled, but api-ms-win-Stub_DLLs depends on that."
	fi
	enable_combase_RoApi=1
	enable_kernel32_UmsStubs=1
fi

if test "$enable_advapi32_Token_Integrity_Level" -eq 1; then
	if test "$enable_Staging" -gt 1; then
		abort "Patchset Staging disabled, but advapi32-Token_Integrity_Level depends on that."
	fi
	if test "$enable_advapi32_CreateRestrictedToken" -gt 1; then
		abort "Patchset advapi32-CreateRestrictedToken disabled, but advapi32-Token_Integrity_Level depends on that."
	fi
	if test "$enable_advapi32_GetExplicitEntriesFromAclW" -gt 1; then
		abort "Patchset advapi32-GetExplicitEntriesFromAclW disabled, but advapi32-Token_Integrity_Level depends on that."
	fi
	if test "$enable_kernel32_COMSPEC" -gt 1; then
		abort "Patchset kernel32-COMSPEC disabled, but advapi32-Token_Integrity_Level depends on that."
	fi
	if test "$enable_kernel32_UmsStubs" -gt 1; then
		abort "Patchset kernel32-UmsStubs disabled, but advapi32-Token_Integrity_Level depends on that."
	fi
	if test "$enable_ntdll_APC_Start_Process" -gt 1; then
		abort "Patchset ntdll-APC_Start_Process disabled, but advapi32-Token_Integrity_Level depends on that."
	fi
	if test "$enable_ntdll_RunlevelInformationInActivationContext" -gt 1; then
		abort "Patchset ntdll-RunlevelInformationInActivationContext disabled, but advapi32-Token_Integrity_Level depends on that."
	fi
	if test "$enable_ntdll_TokenLogonSid" -gt 1; then
		abort "Patchset ntdll-TokenLogonSid disabled, but advapi32-Token_Integrity_Level depends on that."
	fi
	if test "$enable_server_CreateProcess_ACLs" -gt 1; then
		abort "Patchset server-CreateProcess_ACLs disabled, but advapi32-Token_Integrity_Level depends on that."
	fi
	if test "$enable_server_Misc_ACL" -gt 1; then
		abort "Patchset server-Misc_ACL disabled, but advapi32-Token_Integrity_Level depends on that."
	fi
	enable_Staging=1
	enable_advapi32_CreateRestrictedToken=1
	enable_advapi32_GetExplicitEntriesFromAclW=1
	enable_kernel32_COMSPEC=1
	enable_kernel32_UmsStubs=1
	enable_ntdll_APC_Start_Process=1
	enable_ntdll_RunlevelInformationInActivationContext=1
	enable_ntdll_TokenLogonSid=1
	enable_server_CreateProcess_ACLs=1
	enable_server_Misc_ACL=1
fi

if test "$enable_advapi32_LsaLookupSids" -eq 1; then
	if test "$enable_server_CreateProcess_ACLs" -gt 1; then
		abort "Patchset server-CreateProcess_ACLs disabled, but advapi32-LsaLookupSids depends on that."
	fi
	if test "$enable_server_Misc_ACL" -gt 1; then
		abort "Patchset server-Misc_ACL disabled, but advapi32-LsaLookupSids depends on that."
	fi
	enable_server_CreateProcess_ACLs=1
	enable_server_Misc_ACL=1
fi

if test "$enable_advapi32_BuildSecurityDescriptor" -eq 1; then
	if test "$enable_advapi32_GetExplicitEntriesFromAclW" -gt 1; then
		abort "Patchset advapi32-GetExplicitEntriesFromAclW disabled, but advapi32-BuildSecurityDescriptor depends on that."
	fi
	enable_advapi32_GetExplicitEntriesFromAclW=1
fi


# If autoupdate is enabled then create a tempfile to keep track of all patches
if test "$enable_patchlist" -eq 1; then
	if test "$enable_Staging" -eq 1; then
		# macOS 10.10 and prior do not allow mktemp with empty argument
		patchlist=$(mktemp 2>/dev/null || mktemp -t tmp)
		if test ! -f "$patchlist"; then
			abort "Unable to create temporary file for patchlist."
		fi
	else
		warning "Skipping generation of patchlist because 'Staging' patchset is disabled."
		enable_patchlist=0
	fi
fi


# Patchset Compiler_Warnings
# |
# | Modified files:
# |   *	dlls/amstream/mediastreamfilter.c, dlls/d2d1/brush.c, dlls/d2d1/geometry.c, dlls/d3d11/view.c, dlls/d3d8/texture.c,
# | 	dlls/d3d9/tests/visual.c, dlls/d3d9/texture.c, dlls/ddraw/viewport.c, dlls/dsound/primary.c, dlls/dwrite/font.c,
# | 	dlls/dwrite/layout.c, dlls/evr/evr.c, dlls/msxml3/schema.c, dlls/netapi32/netapi32.c, dlls/oleaut32/oleaut.c,
# | 	dlls/rpcrt4/cstub.c, dlls/vbscript/vbdisp.c, dlls/wined3d/glsl_shader.c, dlls/ws2_32/tests/sock.c,
# | 	dlls/wsdapi/msgparams.c, include/wine/list.h, include/wine/rbtree.h, include/winnt.h, tools/makedep.c
# |
if test "$enable_Compiler_Warnings" -eq 1; then
	patch_apply Compiler_Warnings/0009-ws2_32-tests-Work-around-an-incorrect-detection-in-G.patch
	patch_apply Compiler_Warnings/0018-Appease-the-blessed-version-of-gcc-4.5-when-Werror-i.patch
	patch_apply Compiler_Warnings/0019-dsound-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0020-amstream-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0021-d2d1-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0022-d3d11-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0023-d3d8-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0024-d3d9-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0025-ddraw-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0026-dwrite-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0027-msxml3-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0028-oleaut32-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0029-rpcrt4-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0030-vbscript-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0031-include-Check-element-type-in-CONTAINING_RECORD-and-.patch
	patch_apply Compiler_Warnings/0032-wsdapi-Avoid-implicit-cast-of-interface-pointer.patch
	patch_apply Compiler_Warnings/0033-evr-Avoid-implicit-cast-of-interface-pointer.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32/tests: Work around an incorrect detection in GCC 7.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "Appease the blessed version of gcc (4.5) when -Werror is enabled.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "dsound: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "amstream: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "d2d1: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "d3d11: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "d3d8: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "d3d9: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ddraw: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "dwrite: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "msxml3: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "oleaut32: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "rpcrt4: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "vbscript: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "include: Check element type in CONTAINING_RECORD and similar macros.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "wsdapi: Avoid implicit cast of interface pointer.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "evr: Avoid implicit cast of interface pointer.", 1 },';
	) >> "$patchlist"
fi

# Patchset Coverity
# |
# | Modified files:
# |   *	tools/sfnt2fon/sfnt2fon.c, tools/winedump/msc.c
# |
if test "$enable_Coverity" -eq 1; then
	patch_apply Coverity/0001-sfnt2fon-Don-t-leak-output-name-if-specified-multipl.patch
	patch_apply Coverity/0002-winedump-Free-debug-string-in-case-it-was-not-freed-.patch
	(
		printf '%s\n' '+    { "André Hentschel", "sfnt2fon: Don'\''t leak output name if specified multiple times (Coverity).", 1 },';
		printf '%s\n' '+    { "André Hentschel", "winedump: Free debug string in case it was not freed in for-loop (Coverity).", 1 },';
	) >> "$patchlist"
fi

# Patchset Pipelight
# |
# | Modified files:
# |   *	dlls/user32/message.c, dlls/user32/tests/msg.c, dlls/wined3d/wined3d.spec, dlls/wined3d/wined3d_main.c,
# | 	dlls/winex11.drv/init.c, dlls/winex11.drv/opengl.c, dlls/winex11.drv/x11drv.h
# |
if test "$enable_Pipelight" -eq 1; then
	patch_apply Pipelight/0001-winex11-Implement-X11DRV_FLUSH_GDI_DISPLAY-ExtEscape-c.patch
	patch_apply Pipelight/0002-user32-Decrease-minimum-SetTimer-interval-to-5-ms.patch
	patch_apply Pipelight/0003-wined3d-allow-changing-strict-drawing-through-an-exp.patch
	patch_apply Pipelight/0004-winex11.drv-Indicate-direct-rendering-through-OpenGL.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winex11: Implement X11DRV_FLUSH_GDI_DISPLAY ExtEscape command.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "user32: Decrease minimum SetTimer interval to 5 ms.", 2 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Allow changing strict drawing through an exported function.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winex11.drv: Indicate direct rendering through OpenGL extension.", 1 },';
	) >> "$patchlist"
fi

# Patchset Staging
# |
# | Modified files:
# |   *	dlls/kernel32/process.c, dlls/ntdll/misc.c, dlls/ntdll/ntdll.spec, include/wine/library.h, libs/wine/Makefile.in,
# | 	libs/wine/config.c, libs/wine/loader.c, libs/wine/wine.def, libs/wine/wine.map, loader/main.c
# |
if test "$enable_Staging" -eq 1; then
	patch_apply Staging/0001-kernel32-Add-winediag-message-to-show-warning-that-t.patch
	patch_apply Staging/0002-winelib-Append-Staging-at-the-end-of-the-version-s.patch
	patch_apply Staging/0003-loader-Add-commandline-option-patches-to-show-the-pa.patch
	patch_apply Staging/0004-loader-Add-commandline-option-check-libs.patch
	patch_apply Staging/0005-loader-Print-library-paths-for-check-libs-on-Mac-OS-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "kernel32: Add winediag message to show warning, that this isn'\''t vanilla wine.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "winelib: Append '\''(Staging)'\'' at the end of the version string.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "loader: Add commandline option --patches to show the patch list.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "loader: Add commandline option --check-libs.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "loader: Print library paths for --check-libs on Mac OS X.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi-LsaLookupPrivilegeName
# |
# | Modified files:
# |   *	dlls/advapi32/lsa.c, dlls/advapi32/tests/lsa.c
# |
if test "$enable_advapi_LsaLookupPrivilegeName" -eq 1; then
	patch_apply advapi-LsaLookupPrivilegeName/0001-advapi32-Fix-error-code-when-calling-LsaOpenPolicy-f.patch
	patch_apply advapi-LsaLookupPrivilegeName/0002-advapi32-Use-TRACE-for-LsaOpenPolicy-LsaClose.patch
	(
		printf '%s\n' '+    { "Michael Müller", "advapi32: Fix error code when calling LsaOpenPolicy for non existing remote machine.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "advapi32: Use TRACE for LsaOpenPolicy/LsaClose.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-GetExplicitEntriesFromAclW
# |
# | Modified files:
# |   *	dlls/advapi32/security.c, dlls/advapi32/tests/security.c
# |
if test "$enable_advapi32_GetExplicitEntriesFromAclW" -eq 1; then
	patch_apply advapi32-GetExplicitEntriesFromAclW/0001-advapi32-Implement-GetExplicitEntriesFromAclW.patch
	(
		printf '%s\n' '+    { "Michael Müller", "advapi32: Implement GetExplicitEntriesFromAclW.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-BuildSecurityDescriptor
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	advapi32-GetExplicitEntriesFromAclW
# |
# | Modified files:
# |   *	dlls/advapi32/security.c, dlls/advapi32/tests/security.c
# |
if test "$enable_advapi32_BuildSecurityDescriptor" -eq 1; then
	patch_apply advapi32-BuildSecurityDescriptor/0001-advapi32-Implement-BuildSecurityDescriptorW.patch
	patch_apply advapi32-BuildSecurityDescriptor/0002-advapi32-tests-Add-basic-tests-for-BuildSecurityDesc.patch
	(
		printf '%s\n' '+    { "Andrew Wesie", "advapi32: Implement BuildSecurityDescriptorW.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "advapi32/tests: Add basic tests for BuildSecurityDescriptor.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-CreateRestrictedToken
# |
# | Modified files:
# |   *	dlls/advapi32/security.c, dlls/advapi32/tests/security.c, dlls/ntdll/nt.c, dlls/ntdll/ntdll.spec, include/winnt.h,
# | 	include/winternl.h, server/process.c, server/protocol.def, server/security.h, server/token.c
# |
if test "$enable_advapi32_CreateRestrictedToken" -eq 1; then
	patch_apply advapi32-CreateRestrictedToken/0001-ntdll-Implement-NtFilterToken.patch
	patch_apply advapi32-CreateRestrictedToken/0002-advapi32-Implement-CreateRestrictedToken.patch
	patch_apply advapi32-CreateRestrictedToken/0003-server-Correctly-validate-SID-length-in-sd_is_valid.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement NtFilterToken.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "advapi32: Implement CreateRestrictedToken.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Correctly validate SID length in sd_is_valid.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-CreateProcess_ACLs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22006] Support for process ACLs
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, dlls/kernel32/process.c, server/process.c, server/protocol.def
# |
if test "$enable_server_CreateProcess_ACLs" -eq 1; then
	patch_apply server-CreateProcess_ACLs/0001-server-Support-for-thread-and-process-security-descr.patch
	patch_apply server-CreateProcess_ACLs/0002-kernel32-Implement-passing-security-descriptors-from.patch
	patch_apply server-CreateProcess_ACLs/0003-advapi32-tests-Add-additional-tests-for-passing-a-th.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Support for thread and process security descriptors in new_process wineserver call.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "kernel32: Implement passing security descriptors from CreateProcess to the wineserver.", 2 },';
		printf '%s\n' '+    { "Joris van der Wel", "advapi32/tests: Add additional tests for passing a thread sd to CreateProcess.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Misc_ACL
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#15980] GetSecurityInfo returns NULL DACL for process object
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, server/process.c, server/security.h, server/token.c
# |
if test "$enable_server_Misc_ACL" -eq 1; then
	patch_apply server-Misc_ACL/0001-server-Add-default-security-descriptor-ownership-for.patch
	patch_apply server-Misc_ACL/0002-server-Add-default-security-descriptor-DACL-for-proc.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "server: Add default security descriptor ownership for processes.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "server: Add default security descriptor DACL for processes.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-LsaLookupSids
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-CreateProcess_ACLs, server-Misc_ACL
# |
# | Modified files:
# |   *	dlls/advapi32/lsa.c, dlls/advapi32/security.c, dlls/advapi32/tests/security.c, server/token.c
# |
if test "$enable_advapi32_LsaLookupSids" -eq 1; then
	patch_apply advapi32-LsaLookupSids/0001-advapi32-Initialize-buffer-length-to-zero-in-LsaLook.patch
	patch_apply advapi32-LsaLookupSids/0002-advapi32-Prepend-a-hidden-LSA_TRUST_INFORMATION-in-L.patch
	patch_apply advapi32-LsaLookupSids/0003-advapi32-Prepend-a-hidden-LSA_TRUST_INFORMATION-in-L.patch
	patch_apply advapi32-LsaLookupSids/0004-advapi32-Fallback-to-Sid-string-when-LookupAccountSi.patch
	patch_apply advapi32-LsaLookupSids/0005-advapi32-tests-Test-prefix-and-use-of-TokenPrimaryGr.patch
	patch_apply advapi32-LsaLookupSids/0006-server-Create-primary-group-using-DOMAIN_GROUP_RID_U.patch
	patch_apply advapi32-LsaLookupSids/0007-advapi32-Fix-name-and-use-of-DOMAIN_GROUP_RID_USERS.patch
	(
		printf '%s\n' '+    { "Qian Hong", "advapi32: Initialize buffer length to zero in LsaLookupSids to prevent crash.", 2 },';
		printf '%s\n' '+    { "Qian Hong", "advapi32: Prepend a hidden LSA_TRUST_INFORMATION in LsaLookupSids to avoid crash when Domains[-1] incorrectly accessed by application.", 2 },';
		printf '%s\n' '+    { "Qian Hong", "advapi32: Prepend a hidden LSA_TRUST_INFORMATION in LsaLookupNames2 to avoid crash when Domains[-1] incorrectly accessed by application.", 2 },';
		printf '%s\n' '+    { "Qian Hong", "advapi32: Fallback to Sid string when LookupAccountSid fails.", 1 },';
		printf '%s\n' '+    { "Qian Hong", "advapi32/tests: Test prefix and use of TokenPrimaryGroup Sid.", 1 },';
		printf '%s\n' '+    { "Qian Hong", "server: Create primary group using DOMAIN_GROUP_RID_USERS.", 1 },';
		printf '%s\n' '+    { "Qian Hong", "advapi32: Fix name and use of DOMAIN_GROUP_RID_USERS.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-Performance_Counters
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33037] Add support for querying performance counters data
# |
# | Modified files:
# |   *	dlls/advapi32/registry.c, dlls/advapi32/tests/registry.c, dlls/winspool.drv/info.c, dlls/winspool.drv/winspool.drv.spec,
# | 	include/winperf.h, include/winreg.h, loader/wine.inf.in
# |
if test "$enable_advapi32_Performance_Counters" -eq 1; then
	patch_apply advapi32-Performance_Counters/0001-advapi32-tests-Add-more-tests-for-performance-counte.patch
	patch_apply advapi32-Performance_Counters/0002-include-Add-more-definitions-for-performance-counter.patch
	patch_apply advapi32-Performance_Counters/0003-advapi32-Add-initial-support-for-querying-performanc.patch
	patch_apply advapi32-Performance_Counters/0004-winspool.drv-Add-performance-counters-service-stubs.patch
	patch_apply advapi32-Performance_Counters/0005-advapi32-Performance-providers-Open-expects-to-see-t.patch
	patch_apply advapi32-Performance_Counters/0006-advapi32-If-the-query-is-not-specified-the-default-q.patch
	patch_apply advapi32-Performance_Counters/0007-advapi32-Read-the-configured-object-list-for-the-per.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "advapi32/tests: Add more tests for performance counters.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "include: Add more definitions for performance counters.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "advapi32: Add initial support for querying performance counters data.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "winspool.drv: Add performance counters service stubs.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "advapi32: Performance providers'\'' Open() expects to see the configured name as its parameter.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "advapi32: If the query is not specified the default query is \"Global\".", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "advapi32: Read the configured object list for the performance provider.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-SetSecurityInfo
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38423] Fix the initialization of combined DACLs when the new DACL is empty
# |
# | Modified files:
# |   *	dlls/advapi32/security.c
# |
if test "$enable_advapi32_SetSecurityInfo" -eq 1; then
	patch_apply advapi32-SetSecurityInfo/0001-advapi32-Move-the-DACL-combining-code-into-a-separat.patch
	patch_apply advapi32-SetSecurityInfo/0002-advapi32-Fix-the-initialization-of-combined-DACLs-wh.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "advapi32: Move the DACL combining code into a separate routine.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "advapi32: Fix the initialization of combined DACLs when the new DACL is empty.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-COMSPEC
# |
# | Modified files:
# |   *	dlls/kernel32/process.c, programs/cmd/wcmdmain.c
# |
if test "$enable_kernel32_COMSPEC" -eq 1; then
	patch_apply kernel32-COMSPEC/0001-kernel32-Fallback-to-default-comspec-when-COMSPEC-is.patch
	(
		printf '%s\n' '+    { "Qian Hong", "kernel32: Fallback to default comspec when %COMSPEC% is not set.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-UmsStubs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43351] Add semi-stub implementation for CreateRemoteThreadEx
# |
# | Modified files:
# |   *	dlls/api-ms-win-core-processthreads-l1-1-0/api-ms-win-core-processthreads-l1-1-0.spec, dlls/api-ms-win-core-
# | 	processthreads-l1-1-1/api-ms-win-core-processthreads-l1-1-1.spec, dlls/api-ms-win-core-processthreads-l1-1-2/api-ms-win-
# | 	core-processthreads-l1-1-2.spec, dlls/kernel32/kernel32.spec, dlls/kernel32/sync.c, dlls/kernel32/thread.c,
# | 	dlls/kernelbase/kernelbase.spec, include/winbase.h, include/winnt.h
# |
if test "$enable_kernel32_UmsStubs" -eq 1; then
	patch_apply kernel32-UmsStubs/0001-kernel32-Add-a-bunch-of-kernel32-stubs.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32: Add a bunch of kernel32 stubs.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-APC_Start_Process
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c
# |
if test "$enable_ntdll_APC_Start_Process" -eq 1; then
	patch_apply ntdll-APC_Start_Process/0001-ntdll-Process-APC-calls-before-starting-process.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Process APC calls before starting process.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RunlevelInformationInActivationContext
# |
# | Modified files:
# |   *	dlls/kernel32/tests/actctx.c, dlls/ntdll/actctx.c, include/winnt.h
# |
if test "$enable_ntdll_RunlevelInformationInActivationContext" -eq 1; then
	patch_apply ntdll-RunlevelInformationInActivationContext/0001-include-Add-run-level-information-enum-and-structure.patch
	patch_apply ntdll-RunlevelInformationInActivationContext/0002-ntdll-Parse-execution-level-information-in-manifest-.patch
	patch_apply ntdll-RunlevelInformationInActivationContext/0003-ntdll-Implement-RunlevelInformationInActivationConte.patch
	(
		printf '%s\n' '+    { "Michael Müller", "include: Add run level information enum and structure to winnt.h.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Parse execution level information in manifest data.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement RunlevelInformationInActivationContext in RtlQueryInformationActivationContext.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-TokenLogonSid
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, dlls/ntdll/nt.c
# |
if test "$enable_ntdll_TokenLogonSid" -eq 1; then
	patch_apply ntdll-TokenLogonSid/0001-ntdll-TokenLogonSid-stub-in-NtQueryInformationToken.patch
	(
		printf '%s\n' '+    { "Andrew Wesie", "ntdll: TokenLogonSid stub in NtQueryInformationToken.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-Token_Integrity_Level
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, advapi32-CreateRestrictedToken, advapi32-GetExplicitEntriesFromAclW, kernel32-COMSPEC, kernel32-UmsStubs,
# | 	ntdll-APC_Start_Process, ntdll-RunlevelInformationInActivationContext, ntdll-TokenLogonSid, server-CreateProcess_ACLs,
# | 	server-Misc_ACL
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40613] Basic implementation for token integrity levels and UAC handling
# |   *	[#39262] Run explorer.exe as unevaluated process
# |
# | Modified files:
# |   *	configure.ac, dlls/advapi32/security.c, dlls/advapi32/tests/Makefile.in, dlls/advapi32/tests/security.c,
# | 	dlls/kernel32/kernel32.spec, dlls/kernel32/process.c, dlls/kernelbase/kernelbase.spec, dlls/ntdll/loader.c,
# | 	dlls/ntdll/nt.c, dlls/ntdll/ntdll.spec, dlls/ntdll/ntdll_misc.h, dlls/ntdll/process.c, dlls/shell32/shlexec.c,
# | 	dlls/user32/win.c, include/winbase.h, programs/runas/Makefile.in, programs/runas/runas.c, programs/runas/runas.h,
# | 	programs/runas/runas.rc, server/process.c, server/process.h, server/protocol.def, server/request.c, server/security.h,
# | 	server/token.c
# |
if test "$enable_advapi32_Token_Integrity_Level" -eq 1; then
	patch_apply advapi32-Token_Integrity_Level/0001-advapi32-tests-Extend-security-label-token-integrity.patch
	patch_apply advapi32-Token_Integrity_Level/0002-server-Implement-token-elevation-information.patch
	patch_apply advapi32-Token_Integrity_Level/0003-server-Correctly-treat-zero-access-mask-in-duplicate.patch
	patch_apply advapi32-Token_Integrity_Level/0004-server-Implement-token-integrity-level.patch
	patch_apply advapi32-Token_Integrity_Level/0005-server-Use-all-group-attributes-in-create_token.patch
	patch_apply advapi32-Token_Integrity_Level/0006-ntdll-Add-function-to-create-new-tokens-for-elevatio.patch
	patch_apply advapi32-Token_Integrity_Level/0007-shell32-Implement-process-elevation-using-runas-verb.patch
	patch_apply advapi32-Token_Integrity_Level/0008-ntdll-Implement-process-token-elevation-through-mani.patch
	patch_apply advapi32-Token_Integrity_Level/0009-kernel32-Implement-CreateProcessInternalW.patch
	patch_apply advapi32-Token_Integrity_Level/0010-server-Implement-support-for-creating-processes-usin.patch
	patch_apply advapi32-Token_Integrity_Level/0011-advapi32-Use-token-in-CreateProcessAsUserW-and-Creat.patch
	patch_apply advapi32-Token_Integrity_Level/0012-user32-Start-explorer.exe-using-limited-rights.patch
	patch_apply advapi32-Token_Integrity_Level/0013-server-Correctly-assign-security-labels-for-tokens.patch
	patch_apply advapi32-Token_Integrity_Level/0014-programs-runas-Basic-implementation-for-starting-pro.patch
	patch_apply advapi32-Token_Integrity_Level/0015-ntdll-Add-semi-stub-for-TokenLinkedToken-info-class.patch
	(
		printf '%s\n' '+    { "Michael Müller", "advapi32/tests: Extend security label / token integrity tests.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Implement token elevation information.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Correctly treat zero access mask in duplicate_token wineserver call.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Implement token integrity level.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Use all group attributes in create_token.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Add function to create new tokens for elevation purposes.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Implement process elevation using runas verb.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement process token elevation through manifests.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "kernel32: Implement CreateProcessInternalW.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Implement support for creating processes using a token.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "advapi32: Use token in CreateProcessAsUserW and CreateProcessWithTokenW.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "user32: Start explorer.exe using limited rights.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Correctly assign security labels for tokens.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "programs/runas: Basic implementation for starting processes with a different trustlevel.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add semi-stub for TokenLinkedToken info class.", 1 },';
	) >> "$patchlist"
fi

# Patchset advapi32-WinBuiltinAnyPackageSid
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41934] Assigns the AC abbreviation to WinBuiltinAnyPackageSid
# |
# | Modified files:
# |   *	dlls/advapi32/security.c, dlls/advapi32/tests/security.c
# |
if test "$enable_advapi32_WinBuiltinAnyPackageSid" -eq 1; then
	patch_apply advapi32-WinBuiltinAnyPackageSid/0001-advapi32-SDDL-assigns-the-AC-abbreviation-to-WinBuil.patch
	patch_apply advapi32-WinBuiltinAnyPackageSid/0002-advapi32-tests-Add-a-test-that-compares-a-well-known.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "advapi32: SDDL assigns the \"AC\" abbreviation to WinBuiltinAnyPackageSid.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "advapi32/tests: Add a test that compares a well-known SID to a SID created from a SDDL abbreviation.", 1 },';
	) >> "$patchlist"
fi

# Patchset combase-RoApi
# |
# | Modified files:
# |   *	dlls/api-ms-win-core-winrt-l1-1-0/api-ms-win-core-winrt-l1-1-0.spec, dlls/api-ms-win-core-winrt-registration-l1-1-0/api-
# | 	ms-win-core-winrt-registration-l1-1-0.spec, dlls/combase/Makefile.in, dlls/combase/combase.spec, dlls/combase/roapi.c,
# | 	include/Makefile.in, include/activation.idl, include/objidl.idl, include/roapi.h
# |
if test "$enable_combase_RoApi" -eq 1; then
	patch_apply combase-RoApi/0001-include-Add-activation.idl-with-IActivationFactory-i.patch
	patch_apply combase-RoApi/0002-include-roapi.h-Add-further-typedefs.patch
	patch_apply combase-RoApi/0003-combase-Implement-RoGetActivationFactory.patch
	patch_apply combase-RoApi/0004-combase-Implement-RoActivateInstance.patch
	patch_apply combase-RoApi/0005-combase-Add-stub-for-RoGetApartmentIdentifier.patch
	patch_apply combase-RoApi/0006-include-objidl.idl-Add-IApartmentShutdown-interface.patch
	patch_apply combase-RoApi/0007-combase-Add-stub-for-RoRegisterForApartmentShutdown.patch
	patch_apply combase-RoApi/0008-combase-Add-stub-for-RoGetServerActivatableClasses.patch
	patch_apply combase-RoApi/0009-combase-Add-stub-for-RoRegisterActivationFactories.patch
	patch_apply combase-RoApi/0010-combase-Add-stub-for-CleanupTlsOleState.patch
	(
		printf '%s\n' '+    { "Michael Müller", "include: Add activation.idl with IActivationFactory interface.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "include/roapi.h: Add further typedefs.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "combase: Implement RoGetActivationFactory.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "combase: Implement RoActivateInstance.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "combase: Add stub for RoGetApartmentIdentifier.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "include/objidl.idl: Add IApartmentShutdown interface.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "combase: Add stub for RoRegisterForApartmentShutdown.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "combase: Add stub for RoGetServerActivatableClasses.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "combase: Add stub for RoRegisterActivationFactories.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "combase: Add stub for CleanupTlsOleState.", 1 },';
	) >> "$patchlist"
fi

# Patchset api-ms-win-Stub_DLLs
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	combase-RoApi, kernel32-UmsStubs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40451] Add feclient dll
# |
# | Modified files:
# |   *	configure.ac, dlls/api-ms-win-core-quirks-l1-1-0/api-ms-win-core-quirks-l1-1-0.spec, dlls/api-ms-win-rtcore-ntuser-
# | 	draw-l1-1-0/Makefile.in, dlls/api-ms-win-rtcore-ntuser-draw-l1-1-0/api-ms-win-rtcore-ntuser-draw-l1-1-0.spec, dlls/api-
# | 	ms-win-rtcore-ntuser-window-l1-1-0/Makefile.in, dlls/api-ms-win-rtcore-ntuser-window-l1-1-0/api-ms-win-rtcore-ntuser-
# | 	window-l1-1-0.spec, dlls/api-ms-win-shcore-obsolete-l1-1-0/Makefile.in, dlls/api-ms-win-shcore-obsolete-l1-1-0/api-ms-
# | 	win-shcore-obsolete-l1-1-0.spec, dlls/api-ms-win-shcore-stream-l1-1-0/Makefile.in, dlls/api-ms-win-shcore-stream-l1-1-0
# | 	/api-ms-win-shcore-stream-l1-1-0.spec, dlls/api-ms-win-shcore-thread-l1-1-0/Makefile.in, dlls/api-ms-win-shcore-
# | 	thread-l1-1-0/api-ms-win-shcore-thread-l1-1-0.spec, dlls/ext-ms-win-appmodel-usercontext-l1-1-0/Makefile.in, dlls/ext-
# | 	ms-win-appmodel-usercontext-l1-1-0/ext-ms-win-appmodel-usercontext-l1-1-0.spec, dlls/ext-ms-win-appmodel-
# | 	usercontext-l1-1-0/main.c, dlls/ext-ms-win-ntuser-mouse-l1-1-0/Makefile.in, dlls/ext-ms-win-ntuser-mouse-l1-1-0/ext-ms-
# | 	win-ntuser-mouse-l1-1-0.spec, dlls/ext-ms-win-rtcore-ntuser-syscolors-l1-1-0/Makefile.in, dlls/ext-ms-win-rtcore-ntuser-
# | 	syscolors-l1-1-0/ext-ms-win-rtcore-ntuser-syscolors-l1-1-0.spec, dlls/ext-ms-win-uxtheme-themes-l1-1-0/Makefile.in, dlls
# | 	/ext-ms-win-uxtheme-themes-l1-1-0/ext-ms-win-uxtheme-themes-l1-1-0.spec, dlls/ext-ms-win-xaml-pal-l1-1-0/Makefile.in,
# | 	dlls/ext-ms-win-xaml-pal-l1-1-0/ext-ms-win-xaml-pal-l1-1-0.spec, dlls/ext-ms-win-xaml-pal-l1-1-0/main.c,
# | 	dlls/feclient/Makefile.in, dlls/feclient/feclient.spec, dlls/feclient/main.c, dlls/iertutil/Makefile.in,
# | 	dlls/iertutil/iertutil.spec, dlls/iertutil/main.c, dlls/kernelbase/kernelbase.spec, dlls/kernelbase/main.c,
# | 	dlls/shcore/Makefile.in, dlls/shcore/main.c, dlls/shcore/shcore.spec, dlls/uiautomationcore/Makefile.in,
# | 	dlls/uiautomationcore/uia_main.c, dlls/uiautomationcore/uiautomationcore.spec, include/Makefile.in,
# | 	include/shellscalingapi.h, include/uiautomationcoreapi.h, tools/make_specfiles
# |
if test "$enable_api_ms_win_Stub_DLLs" -eq 1; then
	patch_apply api-ms-win-Stub_DLLs/0001-kernelbase-Add-dll-and-add-stub-for-QuirkIsEnabled.patch
	patch_apply api-ms-win-Stub_DLLs/0006-iertutil-Add-dll-and-add-stub-for-ordinal-811.patch
	patch_apply api-ms-win-Stub_DLLs/0007-shcore-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0008-api-ms-win-shcore-obsolete-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0009-ext-ms-win-xaml-pal-l1-1-0-Add-dll-and-add-stub-for-.patch
	patch_apply api-ms-win-Stub_DLLs/0010-ext-ms-win-appmodel-usercontext-l1-1-0-Add-dll-and-a.patch
	patch_apply api-ms-win-Stub_DLLs/0011-api-ms-win-shcore-thread-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0012-ext-ms-win-xaml-pal-l1-1-0-Add-stub-for-GetThemeServ.patch
	patch_apply api-ms-win-Stub_DLLs/0014-api-ms-win-shcore-stream-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0015-ext-ms-win-ntuser-mouse-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0016-ext-ms-win-uxtheme-themes-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0017-api-ms-win-rtcore-ntuser-window-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0018-ext-ms-win-rtcore-ntuser-syscolors-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0019-api-ms-win-rtcore-ntuser-draw-l1-1-0-Add-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0022-shcore-Add-SetProcessDpiAwareness-stub.patch
	patch_apply api-ms-win-Stub_DLLs/0023-shcore-Implement-stub-for-GetDpiForMonitor.patch
	patch_apply api-ms-win-Stub_DLLs/0025-shcore-Add-stub-for-GetProcessDpiAwareness.patch
	patch_apply api-ms-win-Stub_DLLs/0026-feclient-Add-stub-dll.patch
	patch_apply api-ms-win-Stub_DLLs/0027-uiautomationcore-Add-dll-and-stub-some-functions.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernelbase: Add dll and add stub for QuirkIsEnabled.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "iertutil: Add dll and add stub for ordinal 811.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "shcore: Add dll.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "api-ms-win-shcore-obsolete-l1-1-0: Add dll.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ext-ms-win-xaml-pal-l1-1-0: Add dll and add stub for XamlBehaviorEnabled.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ext-ms-win-appmodel-usercontext-l1-1-0: Add dll and add stub for UserContextExtInitialize.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "api-ms-win-shcore-thread-l1-1-0: Add dll.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ext-ms-win-xaml-pal-l1-1-0: Add stub for GetThemeServices.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "api-ms-win-shcore-stream-l1-1-0: Add dll.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ext-ms-win-ntuser-mouse-l1-1-0: Add dll.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ext-ms-win-uxtheme-themes-l1-1-0: Add dll.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "api-ms-win-rtcore-ntuser-window-l1-1-0: Add dll.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ext-ms-win-rtcore-ntuser-syscolors-l1-1-0: Add dll.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "api-ms-win-rtcore-ntuser-draw-l1-1-0: Add dll.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "shcore: Add SetProcessDpiAwareness stub.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "shcore: Implement stub for GetDpiForMonitor.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "shcore: Add stub for GetProcessDpiAwareness.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "feclient: Add stub dll.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "uiautomationcore: Add dll and stub some functions.", 1 },';
	) >> "$patchlist"
fi

# Patchset avifil32-AVIFile_Proxies
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38564] Add support for AVIFile interface proxies
# |
# | Modified files:
# |   *	dlls/avifil32/Makefile.in, dlls/avifil32/avifil32.idl, dlls/avifil32/avifile_ifaces.idl,
# | 	dlls/avifil32/avifile_private.h, dlls/avifil32/factory.c
# |
if test "$enable_avifil32_AVIFile_Proxies" -eq 1; then
	patch_apply avifil32-AVIFile_Proxies/0001-avifil32-Add-support-for-AVIFile-interface-proxies.-.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "avifil32: Add support for AVIFile interface proxies.", 2 },';
	) >> "$patchlist"
fi

# Patchset avifil32-IGetFrame_fnSetFormat
# |
# | Modified files:
# |   *	dlls/avifil32/getframe.c
# |
if test "$enable_avifil32_IGetFrame_fnSetFormat" -eq 1; then
	patch_apply avifil32-IGetFrame_fnSetFormat/0001-avifil32-Correctly-handle-compressed-frames-when-des.patch
	(
		printf '%s\n' '+    { "Michael Müller", "avifil32: Correctly handle compressed frames when desired format is specified.", 1 },';
	) >> "$patchlist"
fi

# Patchset avifile.dll16-AVIStreamGetFrame
# |
# | Modified files:
# |   *	dlls/avifile.dll16/Makefile.in, dlls/avifile.dll16/avifile.dll16.spec, dlls/avifile.dll16/main.c
# |
if test "$enable_avifile_dll16_AVIStreamGetFrame" -eq 1; then
	patch_apply avifile.dll16-AVIStreamGetFrame/0001-avifile-Correctly-convert-result-of-AVIStreamGetFram.patch
	patch_apply avifile.dll16-AVIStreamGetFrame/0002-avifile-Convert-between-AVISTREAMINFO-16-bit-and-AVI.patch
	(
		printf '%s\n' '+    { "Michael Müller", "avifile.dll16: Correctly convert result of AVIStreamGetFrame to a segptr.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "avifile.dll16: Convert between AVISTREAMINFO (16 bit) and AVISTREAMINFOA.", 1 },';
	) >> "$patchlist"
fi

# Patchset bcrypt-Improvements
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40418] Implement BCrypt AES provider
# |   *	[#42553] Implement BCrypt ECB chaining mode
# |   *	[#39582] Implement BCrypt RSA provider
# |
# | Modified files:
# |   *	dlls/bcrypt/bcrypt.spec, dlls/bcrypt/bcrypt_main.c, dlls/bcrypt/tests/bcrypt.c, dlls/ncrypt/ncrypt.spec,
# | 	include/bcrypt.h, include/ntstatus.h
# |
if test "$enable_bcrypt_Improvements" -eq 1; then
	patch_apply bcrypt-Improvements/0010-bcrypt-tests-Add-test-for-bugs-in-BCryptGetProperty.patch
	patch_apply bcrypt-Improvements/0011-bcrypt-tests-Add-tests-for-AES-GCM-mode.patch
	patch_apply bcrypt-Improvements/0012-bcrypt-Pass-object-to-get_-alg-hash-_property-instea.patch
	patch_apply bcrypt-Improvements/0013-bcrypt-Implement-BCryptSetProperty-for-algorithms.patch
	patch_apply bcrypt-Improvements/0014-bcrypt-Implement-BCryptGetProperty-for-BCRYPT_CHAINI.patch
	patch_apply bcrypt-Improvements/0015-bcrypt-Implement-BCryptGetProperty-for-BCRYPT_AUTH_T.patch
	patch_apply bcrypt-Improvements/0016-bcrypt-Fix-string-comparison-in-set_alg_property.patch
	patch_apply bcrypt-Improvements/0017-bcrypt-Implement-BCryptEncrypt-for-AES-GCM-mode.patch
	patch_apply bcrypt-Improvements/0018-bcrypt-Implement-BCryptDecrypt-for-AES-GCM-mode.patch
	patch_apply bcrypt-Improvements/0019-bcrypt-Add-support-for-computing-comparing-cipher-ta.patch
	patch_apply bcrypt-Improvements/0020-bcrypt-Implement-BCryptDuplicateKey.patch
	patch_apply bcrypt-Improvements/0021-bcrypt-tests-Add-tests-for-BCryptDuplicateKey.patch
	patch_apply bcrypt-Improvements/0022-bcrypt-Allow-to-call-BCryptSetProperty-on-key-object.patch
	patch_apply bcrypt-Improvements/0023-bcrypt-Add-support-for-auth-data-in-AES-GCM-mode.patch
	patch_apply bcrypt-Improvements/0024-bcrypt-tests-Add-tests-for-auth-data-in-AES-GCM-mode.patch
	patch_apply bcrypt-Improvements/0025-bcrypt-Avoid-crash-in-tests-when-compiling-without-g.patch
	patch_apply bcrypt-Improvements/0026-bcrypt-Implement-support-for-ECB-chain-mode.patch
	patch_apply bcrypt-Improvements/0027-bcrypt-Fix-BCryptEncrypt-with-AES_GCM-and-no-input-a.patch
	patch_apply bcrypt-Improvements/0028-bcrypt-Partial-implementation-of-BCryptImportKey-and.patch
	patch_apply bcrypt-Improvements/0029-bcrypt-Add-support-for-192-and-256-bit-aes-keys.patch
	patch_apply bcrypt-Improvements/0030-bcrypt-Preparation-for-asymmetric-keys.patch
	patch_apply bcrypt-Improvements/0031-include-Add-ecdsa-and-asymmetric-key-related-bcrypt-.patch
	patch_apply bcrypt-Improvements/0032-bcrypt-tests-Add-basic-test-for-ecdsa.patch
	patch_apply bcrypt-Improvements/0033-bcrypt-Implement-importing-of-ecdsa-keys.patch
	patch_apply bcrypt-Improvements/0034-bcrypt-Implement-BCryptVerifySignature-for-ecdsa-sig.patch
	patch_apply bcrypt-Improvements/0035-bcrypt-Initial-implementation-for-RSA-key-import-and.patch
	patch_apply bcrypt-Improvements/0036-bcrypt-tests-Add-simple-test-for-RSA.patch
	patch_apply bcrypt-Improvements/0037-bcrypt-Store-full-ECCKEY_BLOB-struct-in-BCryptImport.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "bcrypt/tests: Add test for bugs in BCryptGetProperty.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt/tests: Add tests for AES GCM mode.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "bcrypt: Pass object to get_{alg,hash}_property instead of alg_id.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Implement BCryptSetProperty for algorithms.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Implement BCryptGetProperty for BCRYPT_CHAINING_MODE.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Implement BCryptGetProperty for BCRYPT_AUTH_TAG_LENGTH.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "bcrypt: Fix string comparison in set_alg_property.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Implement BCryptEncrypt for AES GCM mode.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Implement BCryptDecrypt for AES GCM mode.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Add support for computing/comparing cipher tag.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Implement BCryptDuplicateKey.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "bcrypt/tests: Add tests for BCryptDuplicateKey.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Allow to call BCryptSetProperty on key objects.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Add support for auth data in AES GCM mode.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "bcrypt/tests: Add tests for auth data in AES GCM mode.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "bcrypt: Avoid crash in tests when compiling without gnutls support.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "bcrypt: Implement support for ECB chain mode.", 1 },';
		printf '%s\n' '+    { "Andrew Wesie", "bcrypt: Fix BCryptEncrypt with AES_GCM and no input and no output.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Partial implementation of BCryptImportKey and BCryptExportKey.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Add support for 192 and 256 bit aes keys.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Preparation for asymmetric keys.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "include: Add ecdsa and asymmetric key related bcrypt definitions.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt/tests: Add basic test for ecdsa.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Implement importing of ecdsa keys.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "bcrypt: Implement BCryptVerifySignature for ecdsa signatures.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "bcrypt: Initial implementation for RSA key import and signature verification.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "bcrypt/tests: Add simple test for RSA.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "bcrypt: Store full ECCKEY_BLOB struct in BCryptImportKeyPair.", 1 },';
	) >> "$patchlist"
fi

# Patchset browseui-Progress_Dialog
# |
# | Modified files:
# |   *	dlls/browseui/browseui.rc, dlls/browseui/progressdlg.c, dlls/browseui/resids.h
# |
if test "$enable_browseui_Progress_Dialog" -eq 1; then
	patch_apply browseui-Progress_Dialog/0001-browseui-Implement-IProgressDialog-SetAnimation.patch
	patch_apply browseui-Progress_Dialog/0002-browseui-Implement-PROGDLG_AUTOTIME-flag-for-IProgre.patch
	(
		printf '%s\n' '+    { "Michael Müller", "browseui: Implement IProgressDialog::SetAnimation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "browseui: Implement PROGDLG_AUTOTIME flag for IProgressDialog.", 1 },';
	) >> "$patchlist"
fi

# Patchset comctl32-Button_Theming
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37584] Properly render themed buttons when they are pressed
# |
# | Modified files:
# |   *	dlls/comctl32/theme_button.c
# |
if test "$enable_comctl32_Button_Theming" -eq 1; then
	patch_apply comctl32-Button_Theming/0001-comctl32-fix-buttons-becoming-unthemed-when-pressed-.patch
	(
		printf '%s\n' '+    { "Samuel Kim", "comctl32: Fix buttons becoming unthemed when pressed/released.", 1 },';
	) >> "$patchlist"
fi

# Patchset comctl32-Listview_DrawItem
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38941] Preserve custom colors between subitems for listview control
# |
# | Modified files:
# |   *	dlls/comctl32/listview.c, dlls/comctl32/tests/listview.c
# |
if test "$enable_comctl32_Listview_DrawItem" -eq 1; then
	patch_apply comctl32-Listview_DrawItem/0001-comctl32-Preserve-custom-colors-between-subitems.patch
	(
		printf '%s\n' '+    { "Michael Müller", "comctl32: Preserve custom colors between subitems.", 2 },';
	) >> "$patchlist"
fi

# Patchset comctl32-TTM_ADDTOOLW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#10347] Protect TTM_ADDTOOLW from invalid text pointers
# |
# | Modified files:
# |   *	dlls/comctl32/tests/tooltips.c, dlls/comctl32/tooltips.c
# |
if test "$enable_comctl32_TTM_ADDTOOLW" -eq 1; then
	patch_apply comctl32-TTM_ADDTOOLW/0001-comctl32-tooltip-Protect-TTM_ADDTOOLW-from-invalid-t.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "comctl32/tooltip: Protect TTM_ADDTOOLW from invalid text pointers.", 1 },';
	) >> "$patchlist"
fi

# Patchset comctl32-Tests
# |
# | Modified files:
# |   *	dlls/comctl32/tests/imagelist.c
# |
if test "$enable_comctl32_Tests" -eq 1; then
	patch_apply comctl32-Tests/0001-comctl32-tests-Prevent-a-possible-nullpointer-derefe.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "comctl32/tests: Prevent a possible nullpointer dereference.", 1 },';
	) >> "$patchlist"
fi

# Patchset comdlg32-lpstrFileTitle
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38400] Postpone setting lpstrFileTitle in GetSaveFileNameW
# |   *	[#35200] Postpone setting lpstrFileTitle in GetSaveFileNameA
# |
# | Modified files:
# |   *	dlls/comdlg32/filedlg.c
# |
if test "$enable_comdlg32_lpstrFileTitle" -eq 1; then
	patch_apply comdlg32-lpstrFileTitle/0001-comdlg32-Postpone-setting-ofn-lpstrFileTitle-to-work.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "comdlg32: Postpone setting ofn->lpstrFileTitle to work around an application bug.", 1 },';
	) >> "$patchlist"
fi

# Patchset configure-Absolute_RPATH
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#26256] Support for setcap on wine-preloader
# |
# | Modified files:
# |   *	configure.ac
# |
if test "$enable_configure_Absolute_RPATH" -eq 1; then
	patch_apply configure-Absolute_RPATH/0001-configure-Also-add-the-absolute-RPATH-when-linking-a.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "configure: Also add the absolute RPATH when linking against libwine.", 1 },';
	) >> "$patchlist"
fi

# Patchset crypt32-CMS_Certificates
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34388] Skip unknown item when decoding a CMS certificate
# |
# | Modified files:
# |   *	dlls/crypt32/decode.c
# |
if test "$enable_crypt32_CMS_Certificates" -eq 1; then
	patch_apply crypt32-CMS_Certificates/0001-crypt32-Skip-unknown-item-when-decoding-a-CMS-certif.patch
	(
		printf '%s\n' '+    { "Charles Davis", "crypt32: Skip unknown item when decoding a CMS certificate.", 1 },';
	) >> "$patchlist"
fi

# Patchset crypt32-Certificate_Check
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41652] Fix root certificate check in CERT_CHAIN_REVOCATION_CHECK_CHAIN
# |
# | Modified files:
# |   *	dlls/crypt32/chain.c
# |
if test "$enable_crypt32_Certificate_Check" -eq 1; then
	patch_apply crypt32-Certificate_Check/0001-crypt32-Properly-check-root-certificate-in-CERT_CHAI.patch
	(
		printf '%s\n' '+    { "Michael Müller", "crypt32: Properly check root certificate in CERT_CHAIN_REVOCATION_CHECK_CHAIN.", 1 },';
	) >> "$patchlist"
fi

# Patchset crypt32-CryptUnprotectMemory
# |
# | Modified files:
# |   *	dlls/crypt32/main.c
# |
if test "$enable_crypt32_CryptUnprotectMemory" -eq 1; then
	patch_apply crypt32-CryptUnprotectMemory/0001-crypt32-Print-CryptUnprotectMemory-FIXME-only-once.patch
	(
		printf '%s\n' '+    { "Christian Costa", "crypt32: Print CryptUnprotectMemory FIXME only once.", 1 },';
	) >> "$patchlist"
fi

# Patchset crypt32-ECDSA_Cert_Chains
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	bcrypt-Improvements
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35902] Implement support for validating ECDSA certificate chains
# |
# | Modified files:
# |   *	dlls/crypt32/Makefile.in, dlls/crypt32/cert.c, dlls/crypt32/chain.c, dlls/crypt32/crypt32_private.h,
# | 	dlls/crypt32/decode.c, dlls/crypt32/oid.c, dlls/crypt32/tests/chain.c, dlls/crypt32/tests/encode.c,
# | 	dlls/crypt32/tests/oid.c, include/wincrypt.h
# |
if test "$enable_crypt32_ECDSA_Cert_Chains" -eq 1; then
	patch_apply crypt32-ECDSA_Cert_Chains/0006-crypt32-tests-Basic-tests-for-decoding-ECDSA-signed-.patch
	patch_apply crypt32-ECDSA_Cert_Chains/0007-crypt32-Implement-decoding-of-X509_OBJECT_IDENTIFIER.patch
	patch_apply crypt32-ECDSA_Cert_Chains/0008-crypt32-Implement-decoding-of-X509_ECC_SIGNATURE.patch
	patch_apply crypt32-ECDSA_Cert_Chains/0009-crypt32-tests-Add-basic-test-for-ecdsa-oid.patch
	patch_apply crypt32-ECDSA_Cert_Chains/0010-crypt32-Add-oids-for-sha256ECDSA-and-sha384ECDSA.patch
	patch_apply crypt32-ECDSA_Cert_Chains/0011-crypt32-Correctly-return-how-the-issuer-of-a-self-si.patch
	patch_apply crypt32-ECDSA_Cert_Chains/0012-crypt32-tets-Add-test-for-verifying-an-ecdsa-chain.patch
	patch_apply crypt32-ECDSA_Cert_Chains/0013-crypt32-Implement-verification-of-ECDSA-signatures.patch
	(
		printf '%s\n' '+    { "Michael Müller", "crypt32/tests: Basic tests for decoding ECDSA signed certificate.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "crypt32: Implement decoding of X509_OBJECT_IDENTIFIER.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "crypt32: Implement decoding of X509_ECC_SIGNATURE.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "crypt32/tests: Add basic test for ecdsa oid.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "crypt32: Add oids for sha256ECDSA and sha384ECDSA.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "crypt32: Correctly return how the issuer of a self signed certificate was checked.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "crypt32/tets: Add test for verifying an ecdsa chain.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "crypt32: Implement verification of ECDSA signatures.", 1 },';
	) >> "$patchlist"
fi

# Patchset crypt32-MS_Root_Certs
# |
# | Modified files:
# |   *	dlls/crypt32/rootstore.c
# |
if test "$enable_crypt32_MS_Root_Certs" -eq 1; then
	patch_apply crypt32-MS_Root_Certs/0001-crypt32-Add-MS-root-CA-2010-2011.patch
	(
		printf '%s\n' '+    { "Michael Müller", "crypt32: Add MS root CA 2010/2011.", 1 },';
	) >> "$patchlist"
fi

# Patchset crypt32-SHA_OIDs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41356] Recognize sha256/384/512 KEY OIDs
# |
# | Modified files:
# |   *	dlls/crypt32/oid.c, include/wincrypt.h
# |
if test "$enable_crypt32_SHA_OIDs" -eq 1; then
	patch_apply crypt32-SHA_OIDs/0001-crypt32-Recognize-sha256-384-512-KEY-OIDs.patch
	(
		printf '%s\n' '+    { "Michael Müller", "crypt32: Recognize sha256/384/512 KEY OIDs.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d10_1-Forwards
# |
# | Modified files:
# |   *	dlls/d3d10_1/d3d10_1.spec, tools/make_specfiles
# |
if test "$enable_d3d10_1_Forwards" -eq 1; then
	patch_apply d3d10_1-Forwards/0001-d3d10_1-Add-missing-forwards-to-d3d10.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "d3d10_1: Add missing forwards to d3d10.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d11-ResolveSubresource
# |
# | Modified files:
# |   *	dlls/d3d11/device.c
# |
if test "$enable_d3d11_ResolveSubresource" -eq 1; then
	patch_apply d3d11-ResolveSubresource/0001-d3d11-Implement-ResolveSubresource-by-copying-sub-re.patch
	patch_apply d3d11-ResolveSubresource/0002-d3d11-Implement-d3d10_device_ResolveSubresource-in-t.patch
	(
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement ResolveSubresource by copying sub resource (there is no multisample texture support yet).", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement d3d10_device_ResolveSubresource in the same way as for d3d11.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-1DTextures
# |
# | Modified files:
# |   *	dlls/d3d10core/tests/device.c, dlls/d3d11/device.c, dlls/d3d11/tests/d3d11.c, dlls/wined3d/context.c,
# | 	dlls/wined3d/device.c, dlls/wined3d/directx.c, dlls/wined3d/glsl_shader.c, dlls/wined3d/resource.c,
# | 	dlls/wined3d/texture.c, dlls/wined3d/utils.c, dlls/wined3d/view.c, dlls/wined3d/wined3d_private.h,
# | 	include/wine/wined3d.h
# |
if test "$enable_wined3d_1DTextures" -eq 1; then
	patch_apply wined3d-1DTextures/0001-wined3d-Create-dummy-1d-textures.patch
	patch_apply wined3d-1DTextures/0002-wined3d-Add-1d-texture-resource-type.patch
	patch_apply wined3d-1DTextures/0003-wined3d-Add-is_power_of_two-helper-function.patch
	patch_apply wined3d-1DTextures/0004-wined3d-Create-dummy-1d-textures-and-surfaces.patch
	patch_apply wined3d-1DTextures/0005-wined3d-Implement-preparation-for-1d-textures.patch
	patch_apply wined3d-1DTextures/0006-wined3d-Implement-uploading-for-1d-textures.patch
	patch_apply wined3d-1DTextures/0007-wined3d-Implement-loading-from-system-memory-and-buf.patch
	patch_apply wined3d-1DTextures/0008-wined3d-Implement-downloading-from-s-rgb-1d-textures.patch
	patch_apply wined3d-1DTextures/0009-wined3d-Implement-converting-between-s-rgb-1d-textur.patch
	patch_apply wined3d-1DTextures/0010-wined3d-Check-for-1d-textures-in-wined3d_texture_upd.patch
	patch_apply wined3d-1DTextures/0011-wined3d-Check-if-1d-teture-is-still-in-use-before-re.patch
	patch_apply wined3d-1DTextures/0012-wined3d-Generate-glsl-samplers-for-1d-texture-arrays.patch
	patch_apply wined3d-1DTextures/0013-wined3d-Add-support-for-1d-textures-in-context_attac.patch
	patch_apply wined3d-1DTextures/0014-wined3d-Handle-1d-textures-in-texture_activate_dimen.patch
	patch_apply wined3d-1DTextures/0015-wined3d-Allow-creation-of-1d-shader-views.patch
	patch_apply wined3d-1DTextures/0016-d3d11-Improve-ID3D11Device_CheckFormatSupport.patch
	patch_apply wined3d-1DTextures/0017-d3d11-Allow-DXGI_FORMAT_UNKNOWN-in-CheckFormatSuppor.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Create dummy 1d textures.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Add 1d texture resource type.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Add is_power_of_two helper function.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Create dummy 1d textures and surfaces.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement preparation for 1d textures.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement uploading for 1d textures.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement loading from system memory and buffers to (s)rgb 1d textures.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement downloading from (s)rgb 1d textures to system memory.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement converting between (s)rgb 1d textures.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Check for 1d textures in wined3d_texture_update_desc.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Check if 1d teture is still in use before releasing.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Generate glsl samplers for 1d texture arrays.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Add support for 1d textures in context_attach_gl_texture_fbo.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Handle 1d textures in texture_activate_dimensions.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Allow creation of 1d shader views.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Improve ID3D11Device_CheckFormatSupport.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Allow DXGI_FORMAT_UNKNOWN in CheckFormatSupport and improve tests.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d11-Deferred_Context
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3d11-ResolveSubresource, wined3d-1DTextures
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42191] Add semi-stub for D3D11 deferred context implementation
# |
# | Modified files:
# |   *	dlls/d3d11/device.c, dlls/wined3d/buffer.c, dlls/wined3d/resource.c, dlls/wined3d/texture.c, dlls/wined3d/wined3d.spec,
# | 	dlls/wined3d/wined3d_private.h, include/wine/wined3d.h
# |
if test "$enable_d3d11_Deferred_Context" -eq 1; then
	patch_apply d3d11-Deferred_Context/0001-d3d11-Add-stub-deferred-rendering-context.patch
	patch_apply d3d11-Deferred_Context/0002-wined3d-Add-wined3d_resource_map_info-function.patch
	patch_apply d3d11-Deferred_Context/0003-d3d11-Initial-implementation-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0004-d3d11-Implement-CSSetShader-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0005-d3d11-Implement-CSSetConstantBuffers-for-deferred-co.patch
	patch_apply d3d11-Deferred_Context/0006-d3d11-Implement-Dispatch-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0007-d3d11-Implement-CSSetUnorderedAccessViews-for-deferr.patch
	patch_apply d3d11-Deferred_Context/0008-d3d11-Implement-ClearRenderTargetView-for-deferred-c.patch
	patch_apply d3d11-Deferred_Context/0009-d3d11-Implement-Draw-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0010-d3d11-Implement-ClearDepthStencilView-for-deferred-c.patch
	patch_apply d3d11-Deferred_Context/0011-d3d11-Implement-GSSetShader-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0012-d3d11-Implement-GSSetConstantBuffers-for-deferred-co.patch
	patch_apply d3d11-Deferred_Context/0013-d3d11-Implement-CSSetShaderResources-for-deferred-co.patch
	patch_apply d3d11-Deferred_Context/0014-d3d11-Implement-GSSetShaderResources-for-deferred-co.patch
	patch_apply d3d11-Deferred_Context/0015-d3d11-Implement-HSSetShaderResources-for-deferred-co.patch
	patch_apply d3d11-Deferred_Context/0016-d3d11-Implement-VSSetShaderResources-for-deferred-co.patch
	patch_apply d3d11-Deferred_Context/0017-d3d11-Implement-CSSetSamplers-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0018-d3d11-Implement-GSSetSamplers-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0019-d3d11-Implement-HSSetSamplers-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0020-d3d11-Implement-VSSetSamplers-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0021-d3d11-Implement-Begin-and-End-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0022-d3d11-Implement-CopyResource-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0023-d3d11-Implement-SetResourceMinLOD-for-deferred-conte.patch
	patch_apply d3d11-Deferred_Context/0024-d3d11-Implement-CopySubresourceRegion-for-deferred-c.patch
	patch_apply d3d11-Deferred_Context/0025-d3d11-Implement-ResolveSubresource-for-deferred-cont.patch
	patch_apply d3d11-Deferred_Context/0026-d3d11-Implement-CopyStructureCount-for-deferred-cont.patch
	patch_apply d3d11-Deferred_Context/0027-d3d11-Implement-DrawAuto-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0028-d3d11-Implement-DrawInstanced-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0029-d3d11-Implement-DrawInstancedIndirect-for-deferred-c.patch
	patch_apply d3d11-Deferred_Context/0030-d3d11-Implement-DrawIndexedInstancedIndirect-for-def.patch
	patch_apply d3d11-Deferred_Context/0031-d3d11-Implement-ClearUnorderedAccessViewUint-for-def.patch
	patch_apply d3d11-Deferred_Context/0032-d3d11-Implement-ClearUnorderedAccessViewFloat-for-de.patch
	patch_apply d3d11-Deferred_Context/0033-d3d11-Implement-RsSetScissorRects-for-deferred-conte.patch
	patch_apply d3d11-Deferred_Context/0034-d3d11-Implement-OMSetRenderTargetsAndUnorderedAccess.patch
	patch_apply d3d11-Deferred_Context/0035-d3d11-Implement-SOSetTargets-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0036-d3d11-Implement-GenerateMips-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0037-d3d11-Implement-DispatchIndirect-for-deferred-contex.patch
	patch_apply d3d11-Deferred_Context/0038-d3d11-Implement-SetPredication-for-deferred-contexts.patch
	patch_apply d3d11-Deferred_Context/0039-d3d11-Implement-d3d11_deferred_context_UpdateSubreso.patch
	patch_apply d3d11-Deferred_Context/0040-d3d11-Implement-restoring-of-state-after-executing-a.patch
	patch_apply d3d11-Deferred_Context/0041-d3d11-Allow-NULL-pointer-for-initial-count-in-d3d11_.patch
	(
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Add stub deferred rendering context.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Add wined3d_resource_map_info function.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Initial implementation for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement CSSetShader for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement CSSetConstantBuffers for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement Dispatch for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement CSSetUnorderedAccessViews for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement ClearRenderTargetView for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement Draw for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement ClearDepthStencilView for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement GSSetShader for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement GSSetConstantBuffers for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement CSSetShaderResources for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement GSSetShaderResources for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement HSSetShaderResources for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement VSSetShaderResources for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement CSSetSamplers for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement GSSetSamplers for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement HSSetSamplers for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement VSSetSamplers for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Kimmo Myllyvirta", "d3d11: Implement Begin and End for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement CopyResource for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement SetResourceMinLOD for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement CopySubresourceRegion for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement ResolveSubresource for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement CopyStructureCount for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement DrawAuto for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement DrawInstanced for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement DrawInstancedIndirect for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement DrawIndexedInstancedIndirect for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement ClearUnorderedAccessViewUint for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement ClearUnorderedAccessViewFloat for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement RsSetScissorRects for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement OMSetRenderTargetsAndUnorderedAccessViews for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement SOSetTargets for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement GenerateMips for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement DispatchIndirect for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Johannes Specht", "d3d11: Implement SetPredication for deferred contexts.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement d3d11_deferred_context_UpdateSubresource.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement restoring of state after executing a command list.", 1 },';
		printf '%s\n' '+    { "Steve Melenchuk", "d3d11: Allow NULL pointer for initial count in d3d11_deferred_context_CSSetUnorderedAccessViews.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d11-Depth_Bias
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43848] Implement support for depth bias clamping
# |
# | Modified files:
# |   *	dlls/d3d11/device.c, dlls/d3d11/tests/d3d11.c, dlls/dxgi/factory.c, dlls/wined3d/cs.c, dlls/wined3d/directx.c,
# | 	dlls/wined3d/state.c, dlls/wined3d/stateblock.c, dlls/wined3d/utils.c, dlls/wined3d/wined3d_gl.h, include/wine/wined3d.h
# |
if test "$enable_d3d11_Depth_Bias" -eq 1; then
	patch_apply d3d11-Depth_Bias/0002-d3d11-tests-Add-some-basic-depth-tests.patch
	patch_apply d3d11-Depth_Bias/0003-d3d11-Implement-depth-bias-and-slope.patch
	patch_apply d3d11-Depth_Bias/0004-d3d11-Add-support-for-SlopeScaledDepthBias-in-RSSetS.patch
	patch_apply d3d11-Depth_Bias/0005-d3d11-tests-Add-basic-test-for-depth-bias-clamping.patch
	patch_apply d3d11-Depth_Bias/0006-wined3d-Add-support-for-depth-bias-clamping.patch
	(
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Add some basic depth tests.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement depth bias and slope.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Add support for SlopeScaledDepthBias in RSSetState.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Add basic test for depth bias clamping.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Add support for depth bias clamping.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d11-ID3D11Texture1D
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	wined3d-1DTextures
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40976] Implement support for ID3D11Texture1D
# |
# | Modified files:
# |   *	dlls/d3d11/d3d11_private.h, dlls/d3d11/device.c, dlls/d3d11/tests/d3d11.c, dlls/d3d11/texture.c, dlls/d3d11/utils.c,
# | 	dlls/d3d11/view.c
# |
if test "$enable_d3d11_ID3D11Texture1D" -eq 1; then
	patch_apply d3d11-ID3D11Texture1D/0001-d3d11-Add-stub-ID3D11Texture2D-and-ID3D10Texture2D-i.patch
	patch_apply d3d11-ID3D11Texture1D/0002-d3d11-Create-a-texture-in-d3d_texture1d_init.patch
	patch_apply d3d11-ID3D11Texture1D/0003-d3d11-Create-a-private-store-in-d3d_texture1d_init.patch
	patch_apply d3d11-ID3D11Texture1D/0004-d3d11-Generate-dxgi-surface-in-d3d_texture1d_init.patch
	patch_apply d3d11-ID3D11Texture1D/0005-d3d11-Improve-d3d11_texture1d_GetDesc-by-obtaining-t.patch
	patch_apply d3d11-ID3D11Texture1D/0006-d3d11-Implement-d3d10_texture1d_-Un-map.patch
	patch_apply d3d11-ID3D11Texture1D/0007-d3d11-Implement-d3d10_texture1d_GetDesc.patch
	patch_apply d3d11-ID3D11Texture1D/0008-d3d11-Implement-d3d11_texture1d_-G-S-etPrivateData.patch
	patch_apply d3d11-ID3D11Texture1D/0009-d3d11-Add-d3d11_texture1d_SetPrivateDataInterface.patch
	patch_apply d3d11-ID3D11Texture1D/0010-d3d11-Add-a-hack-to-prevent-creation-of-1d-cube-text.patch
	patch_apply d3d11-ID3D11Texture1D/0011-d3d11-Add-support-for-1d-textures-in-normalize_srv_d.patch
	patch_apply d3d11-ID3D11Texture1D/0012-d3d11-Add-support-for-1d-textures-in-normalize_rtv_d.patch
	patch_apply d3d11-ID3D11Texture1D/0013-d3d11-tests-Add-support-for-1d-textures-in-check_srv.patch
	patch_apply d3d11-ID3D11Texture1D/0014-d3d11-tests-Add-support-for-1d-textures-in-check_rtv.patch
	patch_apply d3d11-ID3D11Texture1D/0015-d3d11-tests-Add-test-for-creating-1d-textures.patch
	patch_apply d3d11-ID3D11Texture1D/0016-d3d11-tests-Test-1d-texture-interfaces.patch
	patch_apply d3d11-ID3D11Texture1D/0017-d3d11-tests-Test-the-creation-of-1d-render-buffers-i.patch
	patch_apply d3d11-ID3D11Texture1D/0018-d3d11-tests-Test-the-creation-of-1d-shader-resource-.patch
	patch_apply d3d11-ID3D11Texture1D/0019-d3d11-tests-Prepare-test_texture-for-non-2d-textures.patch
	patch_apply d3d11-ID3D11Texture1D/0020-d3d11-tests-Prepare-test_texture-for-1d-textures.patch
	patch_apply d3d11-ID3D11Texture1D/0021-d3d11-tests-Add-some-basic-1d-texture-tests-in-test_.patch
	(
		printf '%s\n' '+    { "Michael Müller", "d3d11: Add stub ID3D11Texture2D and ID3D10Texture2D interfaces.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Create a texture in d3d_texture1d_init.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Create a private store in d3d_texture1d_init.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Generate dxgi surface in d3d_texture1d_init.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Improve d3d11_texture1d_GetDesc by obtaining the current width and format from wined3d.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement d3d10_texture1d_(Un)map.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement d3d10_texture1d_GetDesc.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement d3d11_texture1d_{G,S}etPrivateData.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Add d3d11_texture1d_SetPrivateDataInterface.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Add a hack to prevent creation of 1d cube textures.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Add support for 1d textures in normalize_srv_desc.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Add support for 1d textures in normalize_rtv_desc.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Add support for 1d textures in check_srv_desc_.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Add support for 1d textures in check_rtv_desc_.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Add test for creating 1d textures.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Test 1d texture interfaces.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Test the creation of 1d render buffers in test_create_rendertarget_view.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Test the creation of 1d shader resource views in test_create_shader_resource_view.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Prepare test_texture for non 2d textures.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Prepare test_texture for 1d textures.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Add some basic 1d texture tests in test_texture.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d11-Silence_FIXMEs
# |
# | Modified files:
# |   *	dlls/d3d11/device.c
# |
if test "$enable_d3d11_Silence_FIXMEs" -eq 1; then
	patch_apply d3d11-Silence_FIXMEs/0001-d3d11-Silence-ID3D11Device_GetDeviceRemovedReason.patch
	(
		printf '%s\n' '+    { "Michael Müller", "d3d11: Silence ID3D11Device_GetDeviceRemovedReason.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d8-ValidateShader
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40036] Improve stubs for Validate{Vertex,Pixel}Shader
# |
# | Modified files:
# |   *	dlls/d3d8/d3d8_main.c, dlls/d3d8/tests/device.c
# |
if test "$enable_d3d8_ValidateShader" -eq 1; then
	patch_apply d3d8-ValidateShader/0001-d3d8-Improve-ValidateVertexShader-stub.patch
	patch_apply d3d8-ValidateShader/0002-d3d8-Improve-ValidatePixelShader-stub.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "d3d8: Improve ValidateVertexShader stub.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "d3d8: Improve ValidatePixelShader stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d9-DesktopWindow
# |
# | Modified files:
# |   *	dlls/d3d10_1/tests/d3d10_1.c, dlls/d3d11/tests/d3d11.c, dlls/d3d9/tests/device.c, dlls/winex11.drv/opengl.c
# |
if test "$enable_d3d9_DesktopWindow" -eq 1; then
	patch_apply d3d9-DesktopWindow/0001-winex11.drv-Allow-changing-the-opengl-pixel-format-o.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winex11.drv: Allow changing the opengl pixel format on the desktop window.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3d9-Tests
# |
# | Modified files:
# |   *	dlls/d3d9/tests/device.c, dlls/d3d9/tests/visual.c
# |
if test "$enable_d3d9_Tests" -eq 1; then
	patch_apply d3d9-Tests/0001-d3d9-tests-Avoid-test-failures-on-specific-Nvidia-graphic-.patch
	patch_apply d3d9-Tests/0002-d3d9-tests-Avoid-crash-when-surface-and-texture-crea.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "d3d9/tests: Avoid test failures on specific Nvidia graphic cards.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "d3d9/tests: Avoid crash when surface and texture creation fails.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_25-ID3DXEffect
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#25138] Fix wrong version of ID3DXEffect interface for d3dx9_25
# |
# | Modified files:
# |   *	dlls/d3dx9_24/Makefile.in, dlls/d3dx9_25/Makefile.in, dlls/d3dx9_26/Makefile.in, dlls/d3dx9_27/Makefile.in,
# | 	dlls/d3dx9_28/Makefile.in, dlls/d3dx9_29/Makefile.in, dlls/d3dx9_30/Makefile.in, dlls/d3dx9_31/Makefile.in,
# | 	dlls/d3dx9_32/Makefile.in, dlls/d3dx9_33/Makefile.in, dlls/d3dx9_34/Makefile.in, dlls/d3dx9_35/Makefile.in,
# | 	dlls/d3dx9_36/Makefile.in, dlls/d3dx9_36/effect.c, dlls/d3dx9_37/Makefile.in, dlls/d3dx9_38/Makefile.in,
# | 	dlls/d3dx9_39/Makefile.in, dlls/d3dx9_40/Makefile.in, dlls/d3dx9_41/Makefile.in, dlls/d3dx9_42/Makefile.in,
# | 	dlls/d3dx9_43/Makefile.in, include/d3dx9effect.h
# |
if test "$enable_d3dx9_25_ID3DXEffect" -eq 1; then
	patch_apply d3dx9_25-ID3DXEffect/0001-d3dx9_-Adjust-ID3DXEffect-interface-based-on-DLL-ver.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "d3dx9_*: Adjust ID3DXEffect interface based on DLL version.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-32bpp_Alpha_Channel
# |
# | Modified files:
# |   *	dlls/d3dx9_36/surface.c, dlls/d3dx9_36/tests/surface.c
# |
if test "$enable_d3dx9_36_32bpp_Alpha_Channel" -eq 1; then
	patch_apply d3dx9_36-32bpp_Alpha_Channel/0001-d3dx9-Return-D3DFMT_A8R8G8B8-in-D3DXGetImageInfoFrom.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9: Return D3DFMT_A8R8G8B8 in D3DXGetImageInfoFromFileInMemory for 32 bpp BMP with alpha.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-BumpLuminance
# |
# | Modified files:
# |   *	dlls/d3dx9_36/surface.c, dlls/d3dx9_36/util.c
# |
if test "$enable_d3dx9_36_BumpLuminance" -eq 1; then
	patch_apply d3dx9_36-BumpLuminance/0001-d3dx9_36-Recognize-bump-luminance-X8L8V8U8-when-load.patch
	patch_apply d3dx9_36-BumpLuminance/0002-d3dx9_36-Add-format-description-for-X8L8V8U8-for-for.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Recognize bump luminance X8L8V8U8 when loading dds file.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Add format description for X8L8V8U8 for format conversions.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-CloneEffect
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3dx9_25-ID3DXEffect
# |
# | Modified files:
# |   *	dlls/d3dx9_36/effect.c
# |
if test "$enable_d3dx9_36_CloneEffect" -eq 1; then
	patch_apply d3dx9_36-CloneEffect/0001-d3dx9_36-Improve-stub-for-ID3DXEffectImpl_CloneEffec.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "d3dx9_36: Improve stub for ID3DXEffectImpl_CloneEffect.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-D3DXCreateTeapot
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#36884] Return a valid mesh in D3DXCreateTeapot
# |
# | Modified files:
# |   *	dlls/d3dx9_36/mesh.c
# |
if test "$enable_d3dx9_36_D3DXCreateTeapot" -eq 1; then
	patch_apply d3dx9_36-D3DXCreateTeapot/0001-d3dx9_36-Return-a-mesh-in-D3DXCreateTeapot.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "d3dx9_36: Return a mesh in D3DXCreateTeapot.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-GetShaderSemantics
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22682] Support for D3DXGetShaderInputSemantics
# |
# | Modified files:
# |   *	dlls/d3dx9_24/d3dx9_24.spec, dlls/d3dx9_25/d3dx9_25.spec, dlls/d3dx9_26/d3dx9_26.spec, dlls/d3dx9_27/d3dx9_27.spec,
# | 	dlls/d3dx9_28/d3dx9_28.spec, dlls/d3dx9_29/d3dx9_29.spec, dlls/d3dx9_30/d3dx9_30.spec, dlls/d3dx9_31/d3dx9_31.spec,
# | 	dlls/d3dx9_32/d3dx9_32.spec, dlls/d3dx9_33/d3dx9_33.spec, dlls/d3dx9_34/d3dx9_34.spec, dlls/d3dx9_35/d3dx9_35.spec,
# | 	dlls/d3dx9_36/d3dx9_36.spec, dlls/d3dx9_36/shader.c, dlls/d3dx9_36/tests/shader.c, dlls/d3dx9_37/d3dx9_37.spec,
# | 	dlls/d3dx9_38/d3dx9_38.spec, dlls/d3dx9_39/d3dx9_39.spec, dlls/d3dx9_40/d3dx9_40.spec, dlls/d3dx9_41/d3dx9_41.spec,
# | 	dlls/d3dx9_42/d3dx9_42.spec, dlls/d3dx9_43/d3dx9_43.spec, include/d3dx9shader.h
# |
if test "$enable_d3dx9_36_GetShaderSemantics" -eq 1; then
	patch_apply d3dx9_36-GetShaderSemantics/0001-d3dx9_36-Implement-D3DXGetShaderInputSemantics-tests.patch
	patch_apply d3dx9_36-GetShaderSemantics/0002-d3dx9_36-Implement-D3DXGetShaderOutputSemantics.-rev.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Implement D3DXGetShaderInputSemantics + tests.", 3 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "d3dx9_36: Implement D3DXGetShaderOutputSemantics.", 2 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-D3DXDisassembleShader
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3dx9_36-GetShaderSemantics
# |
# | Modified files:
# |   *	dlls/d3dx9_36/shader.c, dlls/d3dx9_36/tests/shader.c
# |
if test "$enable_d3dx9_36_D3DXDisassembleShader" -eq 1; then
	patch_apply d3dx9_36-D3DXDisassembleShader/0004-d3dx9_36-Implement-D3DXDisassembleShader.patch
	patch_apply d3dx9_36-D3DXDisassembleShader/0005-d3dx9_36-tests-Add-initial-tests-for-D3DXDisassemble.patch
	patch_apply d3dx9_36-D3DXDisassembleShader/0006-d3dx9_36-tests-Add-additional-tests-for-special-case.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Implement D3DXDisassembleShader.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "d3dx9_36/tests: Add initial tests for D3DXDisassembleShader.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36/tests: Add additional tests for special cases.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-D3DXOptimizeVertices
# |
# | Modified files:
# |   *	dlls/d3dx9_24/d3dx9_24.spec, dlls/d3dx9_25/d3dx9_25.spec, dlls/d3dx9_26/d3dx9_26.spec, dlls/d3dx9_27/d3dx9_27.spec,
# | 	dlls/d3dx9_28/d3dx9_28.spec, dlls/d3dx9_29/d3dx9_29.spec, dlls/d3dx9_30/d3dx9_30.spec, dlls/d3dx9_31/d3dx9_31.spec,
# | 	dlls/d3dx9_32/d3dx9_32.spec, dlls/d3dx9_33/d3dx9_33.spec, dlls/d3dx9_34/d3dx9_34.spec, dlls/d3dx9_35/d3dx9_35.spec,
# | 	dlls/d3dx9_36/d3dx9_36.spec, dlls/d3dx9_36/mesh.c, dlls/d3dx9_36/tests/mesh.c, dlls/d3dx9_37/d3dx9_37.spec,
# | 	dlls/d3dx9_38/d3dx9_38.spec, dlls/d3dx9_39/d3dx9_39.spec, dlls/d3dx9_40/d3dx9_40.spec, dlls/d3dx9_41/d3dx9_41.spec,
# | 	dlls/d3dx9_42/d3dx9_42.spec, dlls/d3dx9_43/d3dx9_43.spec
# |
if test "$enable_d3dx9_36_D3DXOptimizeVertices" -eq 1; then
	patch_apply d3dx9_36-D3DXOptimizeVertices/0001-d3dx9_36-tests-Remove-useless-n-within-some-ok-messa.patch
	patch_apply d3dx9_36-D3DXOptimizeVertices/0002-d3dx9_36-Add-semi-stub-for-D3DXOptimizeVertices.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36/tests: Remove useless \\n within some ok messages.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Add semi-stub for D3DXOptimizeVertices.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-D3DXStubs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38334] Add stub for D3DXFrameFind
# |   *	[#41697] Add stub for D3DXComputeTangent
# |
# | Modified files:
# |   *	dlls/d3dx9_24/d3dx9_24.spec, dlls/d3dx9_25/d3dx9_25.spec, dlls/d3dx9_26/d3dx9_26.spec, dlls/d3dx9_27/d3dx9_27.spec,
# | 	dlls/d3dx9_28/d3dx9_28.spec, dlls/d3dx9_29/d3dx9_29.spec, dlls/d3dx9_30/d3dx9_30.spec, dlls/d3dx9_31/d3dx9_31.spec,
# | 	dlls/d3dx9_32/d3dx9_32.spec, dlls/d3dx9_33/d3dx9_33.spec, dlls/d3dx9_34/d3dx9_34.spec, dlls/d3dx9_35/d3dx9_35.spec,
# | 	dlls/d3dx9_36/d3dx9_36.spec, dlls/d3dx9_36/mesh.c, dlls/d3dx9_37/d3dx9_37.spec, dlls/d3dx9_38/d3dx9_38.spec,
# | 	dlls/d3dx9_39/d3dx9_39.spec, dlls/d3dx9_40/d3dx9_40.spec, dlls/d3dx9_41/d3dx9_41.spec, dlls/d3dx9_42/d3dx9_42.spec,
# | 	dlls/d3dx9_43/d3dx9_43.spec
# |
if test "$enable_d3dx9_36_D3DXStubs" -eq 1; then
	patch_apply d3dx9_36-D3DXStubs/0001-d3dx9_36-Add-stub-for-D3DXComputeNormalMap.patch
	patch_apply d3dx9_36-D3DXStubs/0003-d3dx9-Implement-D3DXComputeTangent.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Add stub for D3DXComputeNormalMap.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "d3dx9: Implement D3DXComputeTangent.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-DDS
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#26898] Support for DDS file format in D3DXSaveTextureToFileInMemory
# |
# | Modified files:
# |   *	dlls/d3dx9_36/d3dx9_private.h, dlls/d3dx9_36/surface.c, dlls/d3dx9_36/texture.c
# |
if test "$enable_d3dx9_36_DDS" -eq 1; then
	patch_apply d3dx9_36-DDS/0001-d3dx9_36-Add-support-for-FOURCC-surface-to-save_dds_.patch
	patch_apply d3dx9_36-DDS/0002-d3dx9_36-Improve-D3DXSaveTextureToFile-to-save-simpl.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Add support for FOURCC surface to save_dds_surface_to_memory.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Improve D3DXSaveTextureToFile to save simple texture to dds file.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-DXTn
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#25486] Lego Stunt Rally requires DXTn software de/encoding support
# |   *	[#29586] Tumblebugs 2 requires DXTn software encoding support
# |   *	[#17913] Port Royale doesn't display ocean correctly
# |
# | Modified files:
# |   *	configure.ac, dlls/wined3d/Makefile.in, dlls/wined3d/dxtn.c, dlls/wined3d/surface.c, dlls/wined3d/wined3d.spec,
# | 	dlls/wined3d/wined3d_main.c, dlls/wined3d/wined3d_private.h, include/wine/wined3d.h
# |
if test "$enable_wined3d_DXTn" -eq 1; then
	patch_apply wined3d-DXTn/0001-wined3d-Add-support-for-DXTn-software-decoding-throu.patch
	patch_apply wined3d-DXTn/0002-wined3d-Improve-DXTn-support-and-export-conversion-f.patch
	patch_apply wined3d-DXTn/0003-wined3d-add-DXT1-to-B4G4R4A4-DXT1-to-B5G5R5A1-and-DX.patch
	patch_apply wined3d-DXTn/0004-wined3d-Load-dxtn-dylib-library-on-Mac-OS-X.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Add support for DXTn software decoding through libtxc_dxtn.", 3 },';
		printf '%s\n' '+    { "Christian Costa", "wined3d: Improve DXTn support and export conversion functions for d3dx9_36.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Add DXT1 to B4G4R4A4, DXT1 to B5G5R5A1 and DXT3 to B4G4R4A4 conversion.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Load dxtn dylib library on Mac OS X.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-DXTn
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3dx9_25-ID3DXEffect, wined3d-DXTn
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33768] Fix texture corruption in CSI: Fatal Conspiracy
# |   *	[#37391] Exception during start of fr-043 caused by missing DXTn support
# |   *	[#34692] Fix wrong colors in Wolfenstein (2009)
# |   *	[#24983] Fix crash in Space Rangers2 caused by missing DXTn support
# |
# | Modified files:
# |   *	dlls/d3dx9_24/Makefile.in, dlls/d3dx9_25/Makefile.in, dlls/d3dx9_26/Makefile.in, dlls/d3dx9_27/Makefile.in,
# | 	dlls/d3dx9_28/Makefile.in, dlls/d3dx9_29/Makefile.in, dlls/d3dx9_30/Makefile.in, dlls/d3dx9_31/Makefile.in,
# | 	dlls/d3dx9_32/Makefile.in, dlls/d3dx9_33/Makefile.in, dlls/d3dx9_34/Makefile.in, dlls/d3dx9_35/Makefile.in,
# | 	dlls/d3dx9_36/Makefile.in, dlls/d3dx9_36/surface.c, dlls/d3dx9_36/tests/surface.c, dlls/d3dx9_37/Makefile.in,
# | 	dlls/d3dx9_38/Makefile.in, dlls/d3dx9_39/Makefile.in, dlls/d3dx9_40/Makefile.in, dlls/d3dx9_41/Makefile.in,
# | 	dlls/d3dx9_42/Makefile.in, dlls/d3dx9_43/Makefile.in
# |
if test "$enable_d3dx9_36_DXTn" -eq 1; then
	patch_apply d3dx9_36-DXTn/0001-d3dx9_36-Add-dxtn-support.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Add dxtn support.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-DrawText
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24754] Support for ID3DXFont::DrawTextA/W
# |
# | Modified files:
# |   *	dlls/d3dx9_36/font.c, dlls/d3dx9_36/tests/core.c
# |
if test "$enable_d3dx9_36_DrawText" -eq 1; then
	patch_apply d3dx9_36-DrawText/0001-d3dx9_36-Implement-ID3DXFontImpl_DrawText.patch
	patch_apply d3dx9_36-DrawText/0002-d3dx9_36-Fix-horizontal-centering-in-ID3DXFont_DrawT.patch
	patch_apply d3dx9_36-DrawText/0003-d3dx9_36-Support-NULL-terminated-strings-in-ID3DXFon.patch
	patch_apply d3dx9_36-DrawText/0004-d3dx9_36-ID3DXFont_DrawText-calc_rect-can-be-null.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Implement ID3DXFontImpl_DrawText.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Fix horizontal centering in ID3DXFont_DrawText.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "d3dx9_36: Support NULL terminated strings in ID3DXFont_DrawText.", 1 },';
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "d3dx9_36: ID3DXFont_DrawText calc_rect can be null.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-Dummy_Skininfo
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33904] Return dummy ID3DXSkinInfo interface when skinning info not present
# |
# | Modified files:
# |   *	dlls/d3dx9_36/d3dx9_private.h, dlls/d3dx9_36/mesh.c, dlls/d3dx9_36/skin.c, dlls/d3dx9_36/tests/mesh.c
# |
if test "$enable_d3dx9_36_Dummy_Skininfo" -eq 1; then
	patch_apply d3dx9_36-Dummy_Skininfo/0001-d3dx9_36-Return-dummy-skininfo-interface-in-D3DXLoad.patch
	patch_apply d3dx9_36-Dummy_Skininfo/0002-d3dx9_36-tests-Add-initial-tests-for-dummy-skininfo-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "d3dx9_36: Return dummy skininfo interface in D3DXLoadSkinMeshFromXof when skin information is unavailable.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3dx9_36/tests: Add initial tests for dummy skininfo interface.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-Filter_Warnings
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33770] D3DCompileShader should filter specific warning messages
# |
# | Modified files:
# |   *	dlls/d3dx9_36/shader.c
# |
if test "$enable_d3dx9_36_Filter_Warnings" -eq 1; then
	patch_apply d3dx9_36-Filter_Warnings/0001-d3dx9_36-Filter-out-D3DCompile-warning-messages-that.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Filter out D3DCompile warning messages that are not present with D3DCompileShader.", 4 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-FindNextValidTechnique
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34101] Implement ID3DXEffect::FindNextValidTechnique
# |
# | Modified files:
# |   *	dlls/d3dx9_36/effect.c, dlls/d3dx9_36/tests/effect.c
# |
if test "$enable_d3dx9_36_FindNextValidTechnique" -eq 1; then
	patch_apply d3dx9_36-FindNextValidTechnique/0001-d3dx9_36-Implement-ID3DXEffect_FindNextValidTechniqu.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Implement ID3DXEffect_FindNextValidTechnique + add tests.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-Optimize_Inplace
# |
# | Modified files:
# |   *	dlls/d3dx9_36/mesh.c
# |
if test "$enable_d3dx9_36_Optimize_Inplace" -eq 1; then
	patch_apply d3dx9_36-Optimize_Inplace/0001-d3dx9_36-No-need-to-fail-if-we-don-t-support-vertice.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: No need to fail if we don'\''t support vertices reordering in D3DXMESHOPT_ATTRSORT.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-Tests
# |
# | Modified files:
# |   *	dlls/d3dx9_36/tests/math.c
# |
if test "$enable_d3dx9_36_Tests" -eq 1; then
	patch_apply d3dx9_36-Tests/0001-d3dx9_36-tests-Fix-some-test-failures.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "d3dx9_36/tests: Fix some test failures.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-Texture_Align
# |
# | Modified files:
# |   *	dlls/d3dx9_36/tests/texture.c, dlls/d3dx9_36/texture.c
# |
if test "$enable_d3dx9_36_Texture_Align" -eq 1; then
	patch_apply d3dx9_36-Texture_Align/0001-d3dx9_36-Align-texture-dimensions-to-block-size-for-.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Align texture dimensions to block size for compressed textures in D3DXCheckTextureRequirements.", 1 },';
	) >> "$patchlist"
fi

# Patchset d3dx9_36-UpdateSkinnedMesh
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32572] Support for ID3DXSkinInfoImpl_UpdateSkinnedMesh
# |
# | Modified files:
# |   *	dlls/d3dx9_36/skin.c, dlls/d3dx9_36/tests/mesh.c
# |
if test "$enable_d3dx9_36_UpdateSkinnedMesh" -eq 1; then
	patch_apply d3dx9_36-UpdateSkinnedMesh/0001-d3dx9_36-Implement-ID3DXSkinInfoImpl_UpdateSkinnedMe.patch
	(
		printf '%s\n' '+    { "Christian Costa", "d3dx9_36: Implement ID3DXSkinInfoImpl_UpdateSkinnedMesh.", 1 },';
	) >> "$patchlist"
fi

# Patchset dbghelp-Debug_Symbols
# |
# | Modified files:
# |   *	dlls/dbghelp/Makefile.in, dlls/dbghelp/elf_module.c
# |
if test "$enable_dbghelp_Debug_Symbols" -eq 1; then
	patch_apply dbghelp-Debug_Symbols/0001-dbghelp-Always-check-for-debug-symbols-in-BINDIR.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "dbghelp: Always check for debug symbols in BINDIR.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-D3DFINDDEVICERESULT
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/tests/d3d.c, include/d3dcaps.h
# |
if test "$enable_ddraw_D3DFINDDEVICERESULT" -eq 1; then
	patch_apply ddraw-D3DFINDDEVICERESULT/0001-ddraw-Accept-d3d1-and-d3d2-versions-of-D3DFINDDEVICE.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ddraw: Accept d3d1 and d3d2 versions of D3DFINDDEVICERESULT in IDirect3D_FindDevice.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Device_Caps
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#27002] Properly initialize caps->dwZBufferBitDepths in ddraw7_GetCaps
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/tests/ddraw1.c, dlls/ddraw/tests/ddraw2.c, dlls/ddraw/tests/ddraw4.c,
# | 	dlls/ddraw/tests/ddraw7.c
# |
if test "$enable_ddraw_Device_Caps" -eq 1; then
	patch_apply ddraw-Device_Caps/0001-ddraw-Don-t-set-HWTRANSFORMANDLIGHT-flag-on-d3d7-RGB.patch
	patch_apply ddraw-Device_Caps/0002-ddraw-Set-dwZBufferBitDepth-in-ddraw7_GetCaps.patch
	patch_apply ddraw-Device_Caps/0003-ddraw-Set-ddsOldCaps-correctly-in-ddraw7_GetCaps.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ddraw: Don'\''t set HWTRANSFORMANDLIGHT flag on d3d7 RGB device.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ddraw: Set dwZBufferBitDepth in ddraw7_GetCaps.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ddraw: Set ddsOldCaps correctly in ddraw7_GetCaps.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-EnumSurfaces
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#17233] Implement DDENUMSURFACES_CANBECREATED in IDirectDraw7::EnumSurfaces
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/tests/d3d.c
# |
if test "$enable_ddraw_EnumSurfaces" -eq 1; then
	patch_apply ddraw-EnumSurfaces/0001-ddraw-tests-Add-more-tests-for-IDirectDraw7-EnumSurf.patch
	patch_apply ddraw-EnumSurfaces/0003-ddraw-Implement-DDENUMSURFACES_CANBECREATED-flag-in-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ddraw/tests: Add more tests for IDirectDraw7::EnumSurfaces.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ddraw: Implement DDENUMSURFACES_CANBECREATED flag in ddraw7_EnumSurfaces.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Fix_Typos
# |
# | Modified files:
# |   *	dlls/ddraw/tests/dsurface.c
# |
if test "$enable_ddraw_Fix_Typos" -eq 1; then
	patch_apply ddraw-Fix_Typos/0001-ddraw-tests-Fix-function-name-in-multiple-ok-message.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ddraw/tests: Fix function name in multiple ok() messages.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-FlipToGDISurface
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30062] Implement ddraw7_FlipToGDISurface.
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/ddraw_private.h, dlls/ddraw/surface.c
# |
if test "$enable_ddraw_FlipToGDISurface" -eq 1; then
	patch_apply ddraw-FlipToGDISurface/0001-ddraw-Implement-ddraw7_FlipToGDISurface.patch
	(
		printf '%s\n' '+    { "Henri Verbeet", "ddraw: Implement ddraw7_FlipToGDISurface.", 2 },';
	) >> "$patchlist"
fi

# Patchset ddraw-IDirect3DTexture2_Load
# |
# | Modified files:
# |   *	dlls/ddraw/surface.c, dlls/ddraw/tests/d3d.c, dlls/ddraw/tests/ddraw2.c
# |
if test "$enable_ddraw_IDirect3DTexture2_Load" -eq 1; then
	patch_apply ddraw-IDirect3DTexture2_Load/0001-ddraw-Allow-size-and-format-conversions-in-IDirect3D.patch
	patch_apply ddraw-IDirect3DTexture2_Load/0002-ddraw-tests-Add-more-tests-for-IDirect3DTexture2-Loa.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ddraw: Allow size and format conversions in IDirect3DTexture2::Load.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ddraw/tests: Add more tests for IDirect3DTexture2::Load.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Rendering_Targets
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34906] Use video memory for rendering targets if possible
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/ddraw_private.h, dlls/ddraw/device.c, dlls/ddraw/surface.c
# |
if test "$enable_ddraw_Rendering_Targets" -eq 1; then
	patch_apply ddraw-Rendering_Targets/0001-ddraw-Create-rendering-targets-in-video-memory-if-po.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ddraw: Create rendering targets in video memory if possible.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Silence_FIXMEs
# |
# | Modified files:
# |   *	dlls/ddraw/executebuffer.c
# |
if test "$enable_ddraw_Silence_FIXMEs" -eq 1; then
	patch_apply ddraw-Silence_FIXMEs/0001-ddraw-Silence-noisy-FIXME-about-unimplemented-D3DPRO.patch
	(
		printf '%s\n' '+    { "Christian Costa", "ddraw: Silence noisy FIXME about unimplemented D3DPROCESSVERTICES_UPDATEEXTENTS.", 1 },';
	) >> "$patchlist"
fi

# Patchset ddraw-Write_Vtable
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39534] Make ddraw1 and ddraw_surface1 vtable as writable
# |
# | Modified files:
# |   *	dlls/ddraw/ddraw.c, dlls/ddraw/surface.c
# |
if test "$enable_ddraw_Write_Vtable" -eq 1; then
	patch_apply ddraw-Write_Vtable/0001-ddraw-Remove-const-from-ddraw1_vtbl-and-ddraw_surfac.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ddraw: Remove const from ddraw1_vtbl and ddraw_surface1_vtbl.", 1 },';
	) >> "$patchlist"
fi

# Patchset devenum-AudioCompressorCategory
# |
# | Modified files:
# |   *	dlls/devenum/Makefile.in, dlls/devenum/createdevenum.c
# |
if test "$enable_devenum_AudioCompressorCategory" -eq 1; then
	patch_apply devenum-AudioCompressorCategory/0001-devenum-Populate-AudioCompressorCategory.patch
	(
		printf '%s\n' '+    { "Michael Müller", "devenum: Populate AudioCompressorCategory.", 1 },';
	) >> "$patchlist"
fi

# Patchset dinput-Deadlock
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43356] Avoid possible deadlock in dinput when CS are acquired in different order
# |
# | Modified files:
# |   *	dlls/dinput/device.c, dlls/dinput/dinput_main.c, dlls/dinput/dinput_private.h
# |
if test "$enable_dinput_Deadlock" -eq 1; then
	patch_apply dinput-Deadlock/0001-dinput-Avoid-possible-deadlock-when-CS-are-acquired-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "dinput: Avoid possible deadlock when CS are acquired in different order.", 1 },';
	) >> "$patchlist"
fi

# Patchset dinput-Initialize
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#21403] Do not wait for hook thread startup in IDirectInput8::Initialize
# |
# | Modified files:
# |   *	dlls/dinput/dinput_main.c
# |
if test "$enable_dinput_Initialize" -eq 1; then
	patch_apply dinput-Initialize/0001-dinput-Do-not-wait-for-hook-thread-startup-in-IDirec.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "dinput: Do not wait for hook thread startup in IDirectInput8::Initialize.", 1 },';
	) >> "$patchlist"
fi

# Patchset dsound-Fast_Mixer
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30639] Audio stuttering and performance drops in multiple applications
# |
# | Modified files:
# |   *	dlls/dsound/dsound_main.c, dlls/dsound/dsound_private.h, dlls/dsound/mixer.c
# |
if test "$enable_dsound_Fast_Mixer" -eq 1; then
	patch_apply dsound-Fast_Mixer/0001-dsound-Add-a-linear-resampler-for-use-with-a-large-n.patch
	(
		printf '%s\n' '+    { "Alexander E. Patrakov", "dsound: Add a linear resampler for use with a large number of mixing buffers.", 2 },';
	) >> "$patchlist"
fi

# Patchset dsound-Revert_Cleanup
# |
# | Modified files:
# |   *	dlls/dsound/buffer.c, dlls/dsound/dsound.c, dlls/dsound/dsound_private.h
# |
if test "$enable_dsound_Revert_Cleanup" -eq 1; then
	patch_apply dsound-Revert_Cleanup/0001-Revert-dsound-Use-a-better-name-for-IDirectSoundBuff.patch
	patch_apply dsound-Revert_Cleanup/0002-Revert-dsound-Simplify-error-handling-when-creating-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "Revert \"dsound: Use a better name for IDirectSoundBufferImpl_Create().\".", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "Revert \"dsound: Simplify error handling when creating a sound buffer.\".", 1 },';
	) >> "$patchlist"
fi

# Patchset dsound-EAX
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	dsound-Fast_Mixer, dsound-Revert_Cleanup
# |
# | Modified files:
# |   *	dlls/dsound/Makefile.in, dlls/dsound/buffer.c, dlls/dsound/dsound.c, dlls/dsound/dsound_eax.h,
# | 	dlls/dsound/dsound_main.c, dlls/dsound/dsound_private.h, dlls/dsound/eax.c, dlls/dsound/mixer.c
# |
if test "$enable_dsound_EAX" -eq 1; then
	patch_apply dsound-EAX/0001-dsound-Apply-filters-before-sound-is-multiplied-to-s.patch
	patch_apply dsound-EAX/0002-dsound-Add-EAX-v1-constants-and-structs.patch
	patch_apply dsound-EAX/0003-dsound-Report-that-we-support-EAX-v1.patch
	patch_apply dsound-EAX/0004-dsound-Add-EAX-propset-stubs.patch
	patch_apply dsound-EAX/0005-dsound-Add-EAX-presets.patch
	patch_apply dsound-EAX/0006-dsound-Support-getting-and-setting-EAX-properties.patch
	patch_apply dsound-EAX/0007-dsound-Support-getting-and-setting-EAX-buffer-proper.patch
	patch_apply dsound-EAX/0008-dsound-Add-EAX-init-and-free-stubs.patch
	patch_apply dsound-EAX/0009-dsound-Feed-data-through-EAX-function.patch
	patch_apply dsound-EAX/0010-dsound-Allocate-EAX-delay-lines.patch
	patch_apply dsound-EAX/0011-dsound-Add-EAX-VerbPass-stub.patch
	patch_apply dsound-EAX/0012-dsound-Implement-EAX-lowpass-filter.patch
	patch_apply dsound-EAX/0013-dsound-Add-delay-line-EAX-functions.patch
	patch_apply dsound-EAX/0014-dsound-Implement-EAX-early-reflections.patch
	patch_apply dsound-EAX/0015-dsound-Implement-EAX-decorrelator.patch
	patch_apply dsound-EAX/0016-dsound-Implement-EAX-late-reverb.patch
	patch_apply dsound-EAX/0017-dsound-Implement-EAX-late-all-pass-filter.patch
	patch_apply dsound-EAX/0018-dsound-Various-improvements-to-EAX-support.patch
	patch_apply dsound-EAX/0019-dsound-Allow-disabling-of-EAX-support-in-the-registr.patch
	patch_apply dsound-EAX/0020-dsound-Add-stub-support-for-DSPROPSETID_EAX20_Listen.patch
	patch_apply dsound-EAX/0021-dsound-Add-stub-support-for-DSPROPSETID_EAX20_Buffer.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "dsound: Apply filters before sound is multiplied to speakers.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Add EAX v1 constants and structs.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Report that we support EAX.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Add EAX propset stubs.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Add EAX presets.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Support getting and setting EAX properties.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Support getting and setting EAX buffer properties.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Add EAX init and free stubs.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Feed data through EAX function.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Allocate EAX delay lines.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Add EAX VerbPass stub.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Implement EAX lowpass filter.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Add delay line EAX functions.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Implement EAX early reflections.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Implement EAX decorrelator.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Implement EAX late reverb.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "dsound: Implement EAX late all-pass filter.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "dsound: Various improvements to EAX support.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "dsound: Allow disabling of EAX support in the registry.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "dsound: Add stub support for DSPROPSETID_EAX20_ListenerProperties.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "dsound: Add stub support for DSPROPSETID_EAX20_BufferProperties.", 1 },';
	) >> "$patchlist"
fi

# Patchset dwmapi-DwmSetIcon
# |
# | Modified files:
# |   *	dlls/dwmapi/dwmapi.spec, dlls/dwmapi/dwmapi_main.c
# |
if test "$enable_dwmapi_DwmSetIcon" -eq 1; then
	patch_apply dwmapi-DwmSetIcon/0001-dwmapi-Add-stubs-for-DwmSetIconicLivePreviewBitmap-a.patch
	(
		printf '%s\n' '+    { "Michael Müller", "dwmapi: Add stubs for DwmSetIconicLivePreviewBitmap and DwmSetIconicThumbnail.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxdiag-dontskip
# |
# | Modified files:
# |   *	programs/dxdiag/main.c
# |
if test "$enable_dxdiag_dontskip" -eq 1; then
	patch_apply dxdiag-dontskip/0001-programs-dxdiag-Handle-dontskip-parameter.patch
	(
		printf '%s\n' '+    { "Michael Müller", "programs/dxdiag: Handle /dontskip parameter.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxdiagn-Display_Information
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34686] Return additional properties for display devices in dxdiagn
# |   *	[#42599] Application crashes because of missing properties in dxdiagn
# |
# | Modified files:
# |   *	dlls/dxdiagn/provider.c, dlls/dxdiagn/tests/container.c
# |
if test "$enable_dxdiagn_Display_Information" -eq 1; then
	patch_apply dxdiagn-Display_Information/0001-dxdiagn-Add-several-more-fields-for-DisplayDevices.patch
	(
		printf '%s\n' '+    { "Michael Müller", "dxdiagn: Add several more fields for DisplayDevices.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxdiagn-Enumerate_DirectSound
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32613] Implement enumeration of sound devices and basic properties to dxdiagn
# |
# | Modified files:
# |   *	dlls/dxdiagn/Makefile.in, dlls/dxdiagn/provider.c, dlls/dxdiagn/tests/container.c
# |
if test "$enable_dxdiagn_Enumerate_DirectSound" -eq 1; then
	patch_apply dxdiagn-Enumerate_DirectSound/0001-dxdiagn-Enumerate-DirectSound-devices-and-add-some-b.patch
	(
		printf '%s\n' '+    { "Michael Müller", "dxdiagn: Enumerate DirectSound devices and add some basic properties.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxdiagn-GetChildContainer_Leaf_Nodes
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	dxdiagn-Enumerate_DirectSound
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38014] Implement special handling for calling GetChildContainer with an empty string
# |
# | Modified files:
# |   *	dlls/dxdiagn/container.c, dlls/dxdiagn/tests/container.c
# |
if test "$enable_dxdiagn_GetChildContainer_Leaf_Nodes" -eq 1; then
	patch_apply dxdiagn-GetChildContainer_Leaf_Nodes/0001-dxdiagn-Calling-GetChildContainer-with-an-empty-stri.patch
	(
		printf '%s\n' '+    { "Michael Müller", "dxdiagn: Calling GetChildContainer with an empty string on a leaf container returns the object itself.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxgi-DXGI_PRESENT_TEST
# |
# | Modified files:
# |   *	dlls/dxgi/swapchain.c
# |
if test "$enable_dxgi_DXGI_PRESENT_TEST" -eq 1; then
	patch_apply dxgi-DXGI_PRESENT_TEST/0001-dxgi-Add-stub-implementation-for-DXGI_PRESENT_TEST.patch
	(
		printf '%s\n' '+    { "Kimmo Myllyvirta", "dxgi: Add stub implementation for DXGI_PRESENT_TEST.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxgi-GammaRamp
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43584] Implement DXGI GammaControl methods
# |
# | Modified files:
# |   *	dlls/dxgi/Makefile.in, dlls/dxgi/output.c, dlls/dxgi/tests/device.c
# |
if test "$enable_dxgi_GammaRamp" -eq 1; then
	patch_apply dxgi-GammaRamp/0001-dxgi-Implement-setting-and-querying-the-gamma-value-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "dxgi: Implement setting and querying the gamma value of an output.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxgi-MakeWindowAssociation
# |
# | Modified files:
# |   *	dlls/dxgi/dxgi_private.h, dlls/dxgi/factory.c
# |
if test "$enable_dxgi_MakeWindowAssociation" -eq 1; then
	patch_apply dxgi-MakeWindowAssociation/0001-dxgi-Improve-stubs-for-MakeWindowAssociation-and-Get.patch
	(
		printf '%s\n' '+    { "Michael Müller", "dxgi: Improve stubs for MakeWindowAssociation and GetWindowAssociation.", 1 },';
	) >> "$patchlist"
fi

# Patchset dxva2-Video_Decoder
# |
# | Modified files:
# |   *	configure.ac, dlls/dxva2/Makefile.in, dlls/dxva2/backend.idl, dlls/dxva2/devicemanager.c, dlls/dxva2/dxva2_private.h,
# | 	dlls/dxva2/genericdecoder.c, dlls/dxva2/main.c, dlls/dxva2/softwareprocessor.c, dlls/dxva2/tests/Makefile.in,
# | 	dlls/dxva2/tests/dxva2.c, dlls/dxva2/vaapi-h264.c, dlls/dxva2/vaapi-mpeg2.c, dlls/dxva2/vaapi.c,
# | 	dlls/dxva2/videoservices.c, include/Makefile.in, include/dxva.h, include/dxva2api.idl
# |
if test "$enable_dxva2_Video_Decoder" -eq 1; then
	patch_apply dxva2-Video_Decoder/0001-dxva2-Implement-semi-stub-for-Direct3DDeviceManager9.patch
	patch_apply dxva2-Video_Decoder/0002-dxva2-Implement-stubbed-interfaces-for-IDirectXVideo.patch
	patch_apply dxva2-Video_Decoder/0004-dxva2-Implement-stubbed-DirectX-Software-VideoProces.patch
	patch_apply dxva2-Video_Decoder/0005-include-Add-dxva.h-header-file.patch
	patch_apply dxva2-Video_Decoder/0006-dxva2-tests-Add-tests-for-dxva2-decoder.patch
	patch_apply dxva2-Video_Decoder/0007-dxva2-Initial-implementation-of-MPEG2-decoder-using-.patch
	patch_apply dxva2-Video_Decoder/0008-dxva2-Implement-h264-decoder.patch
	patch_apply dxva2-Video_Decoder/0009-dxva2-Add-DRM-mode-for-vaapi.patch
	patch_apply dxva2-Video_Decoder/0010-dxva2-Fill-h264-luma-and-chroma-weights-offsets-with.patch
	patch_apply dxva2-Video_Decoder/0011-dxva2-Always-destroy-buffers-when-calling-vaRenderPi.patch
	patch_apply dxva2-Video_Decoder/0012-dxva2-Only-declare-debug-channels-when-they-are-actu.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "dxva2: Implement semi-stub for Direct3DDeviceManager9 interface.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Implement stubbed interfaces for IDirectXVideo{Acceleration,Decoder,Processor}Service.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Implement stubbed DirectX Software VideoProcessor interface.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "include: Add dxva.h header file.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2/tests: Add tests for dxva2 decoder.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Initial implementation of MPEG2 decoder using vaapi backend.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Implement h264 decoder.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Add DRM mode for vaapi.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Fill h264 luma and chroma weights / offsets with default values in case they are not specified.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Always destroy buffers when calling vaRenderPicture.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxva2: Only declare debug channels when they are actually used.", 1 },';
	) >> "$patchlist"
fi

# Patchset explorer-Video_Registry_Key
# |
# | Modified files:
# |   *	dlls/advapi32/tests/registry.c, programs/explorer/desktop.c
# |
if test "$enable_explorer_Video_Registry_Key" -eq 1; then
	patch_apply explorer-Video_Registry_Key/0001-explorer-Create-CurrentControlSet-Control-Video-regi.patch
	(
		printf '%s\n' '+    { "Michael Müller", "explorer: Create CurrentControlSet\\Control\\Video registry key as non-volatile.", 1 },';
	) >> "$patchlist"
fi

# Patchset fonts-Missing_Fonts
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32323] Implement an Arial replacement font
# |   *	[#32342] Implement a Times New Roman replacement font
# |   *	[#20456] Implement a Courier New replacement font
# |   *	[#13829] Implement a Microsoft Yahei replacement font
# |
# | Modified files:
# |   *	COPYING.arial, COPYING.cour, COPYING.msyh, COPYING.times, LICENSE, fonts/Makefile.in, fonts/arial.sfd, fonts/arial.ttf,
# | 	fonts/cour.sfd, fonts/cour.ttf, fonts/msyh.sfd, fonts/msyh.ttf, fonts/times.sfd, fonts/times.ttf
# |
if test "$enable_fonts_Missing_Fonts" -eq 1; then
	patch_apply fonts-Missing_Fonts/0001-fonts-Add-Liberation-Sans-as-an-Arial-replacement.patch
	patch_apply fonts-Missing_Fonts/0002-fonts-Add-Liberation-Serif-as-an-Times-New-Roman-rep.patch
	patch_apply fonts-Missing_Fonts/0003-fonts-Add-Liberation-Mono-as-an-Courier-New-replacem.patch
	patch_apply fonts-Missing_Fonts/0004-fonts-Add-WenQuanYi-Micro-Hei-as-a-Microsoft-Yahei-r.patch
	patch_apply fonts-Missing_Fonts/0005-Add-licenses-for-fonts-as-separate-files.patch
	(
		printf '%s\n' '+    { "Torsten Kurbad", "fonts: Add Liberation Sans as an Arial replacement.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "fonts: Add Liberation Serif as an Times New Roman replacement.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "fonts: Add Liberation Mono as an Courier New replacement.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "fonts: Add WenQuanYi Micro Hei as a Microsoft Yahei replacement.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "Add licenses for fonts as separate files.", 1 },';
	) >> "$patchlist"
fi

# Patchset fonts-Tahoma
# |
# | Modified files:
# |   *	fonts/tahoma.sfd, fonts/tahoma.ttf
# |
if test "$enable_fonts_Tahoma" -eq 1; then
	patch_apply fonts-Tahoma/0001-fonts-tahoma.sfd-Add-glyphs-U-FB01-and-U-FB02.patch
	(
		printf '%s\n' '+    { "Michael Müller", "fonts/tahoma.sfd: Add glyphs U+FB01 and U+FB02.", 1 },';
	) >> "$patchlist"
fi

# Patchset fsutil-Stub_Program
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22749] Add stub for fsutil.exe hardlink command
# |
# | Modified files:
# |   *	configure.ac, programs/fsutil/Makefile.in, programs/fsutil/fsutil.rc, programs/fsutil/main.c,
# | 	programs/fsutil/resources.h
# |
if test "$enable_fsutil_Stub_Program" -eq 1; then
	patch_apply fsutil-Stub_Program/0001-fsutil-Add-fsutil-program-with-support-for-creating-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "fsutil: Add fsutil program with support for creating hard links.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdi32-GetCharacterPlacement
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42669] Treat lpResults as optional in gdi32.GetCharacterPlacement
# |
# | Modified files:
# |   *	dlls/gdi32/font.c, dlls/gdi32/tests/font.c
# |
if test "$enable_gdi32_GetCharacterPlacement" -eq 1; then
	patch_apply gdi32-GetCharacterPlacement/0001-gdi32-Treat-lpResults-as-optional-in-GetCharacterPla.patch
	(
		printf '%s\n' '+    { "Michael Müller", "gdi32: Treat lpResults as optional in GetCharacterPlacement.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdi32-Lazy_Font_Initialization
# |
# | Modified files:
# |   *	dlls/gdi32/dc.c, dlls/gdi32/freetype.c
# |
if test "$enable_gdi32_Lazy_Font_Initialization" -eq 1; then
	patch_apply gdi32-Lazy_Font_Initialization/0001-gdi32-Perform-lazy-initialization-of-fonts-to-improv.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "gdi32: Perform lazy initialization of fonts to improve startup performance.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdi32-MultiMonitor
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34978] Multiple applications need EnumDisplayDevicesW implementation
# |   *	[#37709] GetMonitorInfo returns the same name for all monitors
# |   *	[#41258] Return a more reasonable display DeviceID
# |
# | Modified files:
# |   *	dlls/gdi32/driver.c, dlls/user32/misc.c, dlls/user32/tests/monitor.c, dlls/winemac.drv/display.c,
# | 	dlls/winex11.drv/xinerama.c
# |
if test "$enable_gdi32_MultiMonitor" -eq 1; then
	patch_apply gdi32-MultiMonitor/0001-gdi32-Also-accept-.-DISPLAY-n-devices-names-with-n-o.patch
	patch_apply gdi32-MultiMonitor/0002-winex11-Make-GetMonitorInfo-give-a-different-device-.patch
	patch_apply gdi32-MultiMonitor/0003-user32-Implement-EnumDisplayDevicesW-based-on-EnumDi.patch
	patch_apply gdi32-MultiMonitor/0004-winemac-Make-GetMonitorInfo-give-a-different-device-.patch
	patch_apply gdi32-MultiMonitor/0005-user32-Return-a-more-reasonable-display-DeviceID.patch
	(
		printf '%s\n' '+    { "Ken Thomases", "gdi32: Also accept \"\\\\.\\DISPLAY<n>\" devices names with <n> other than 1 as display devices.", 1 },';
		printf '%s\n' '+    { "Ken Thomases", "winex11: Make GetMonitorInfo() give a different device name (\\.\\DISPLAY<n>) to each monitor.", 1 },';
		printf '%s\n' '+    { "Ken Thomases", "user32: Implement EnumDisplayDevicesW() based on EnumDisplayMonitors() and GetMonitorInfoW().", 1 },';
		printf '%s\n' '+    { "Ken Thomases", "winemac: Make GetMonitorInfo() give a different device name (\\\\.\\DISPLAY<n>) to each monitor.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Return a more reasonable display DeviceID.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdi32-Path_Metafile
# |
# | Modified files:
# |   *	dlls/gdi32/path.c, dlls/gdi32/tests/metafile.c
# |
if test "$enable_gdi32_Path_Metafile" -eq 1; then
	patch_apply gdi32-Path_Metafile/0001-gdi32-tests-Add-some-additional-tests-for-ExtExtOut-.patch
	patch_apply gdi32-Path_Metafile/0002-gdi32-ExtTextOut-on-a-path-with-bitmap-font-selected.patch
	patch_apply gdi32-Path_Metafile/0003-gdi32-tests-Explicitly-test-BeginPath-return-value-i.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdi32/tests: Add some additional tests for ExtExtOut on a path for an EMF DC.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdi32: ExtTextOut on a path with bitmap font selected shouldn'\''t fail.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdi32/tests: Explicitly test BeginPath() return value in the metafile path tests.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdi32-Symbol_Truetype_Font
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33117] Improve detection of symbol charset for old truetype fonts
# |
# | Modified files:
# |   *	dlls/gdi32/freetype.c
# |
if test "$enable_gdi32_Symbol_Truetype_Font" -eq 1; then
	patch_apply gdi32-Symbol_Truetype_Font/0001-gdi32-Improve-detection-of-symbol-charset-for-old-tr.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdi32: Improve detection of symbol charset for old truetype fonts.", 1 },';
	) >> "$patchlist"
fi

# Patchset gdiplus-Performance-Improvements
# |
# | Modified files:
# |   *	dlls/gdiplus/graphics.c
# |
if test "$enable_gdiplus_Performance_Improvements" -eq 1; then
	patch_apply gdiplus-Performance-Improvements/0001-gdiplus-Change-the-order-of-x-y-loops-in-the-scaler.patch
	patch_apply gdiplus-Performance-Improvements/0002-gdiplus-Change-multiplications-by-additions-in-the-x.patch
	patch_apply gdiplus-Performance-Improvements/0003-gdiplus-Remove-ceilf-floorf-calls-from-bilinear-scal.patch
	patch_apply gdiplus-Performance-Improvements/0004-gdiplus-Prefer-using-pre-multiplied-ARGB-data-in-the.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Change the order of x/y loops in the scaler.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Change multiplications by additions in the x/y scaler loops.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Remove ceilf/floorf calls from bilinear scaler.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Prefer using pre-multiplied ARGB data in the scaler.", 1 },';
	) >> "$patchlist"
fi

# Patchset hal-KeQueryPerformanceCounter
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39500] Implement hal.KeQueryPerformanceCounter
# |
# | Modified files:
# |   *	dlls/hal/hal.c, dlls/hal/hal.spec
# |
if test "$enable_hal_KeQueryPerformanceCounter" -eq 1; then
	patch_apply hal-KeQueryPerformanceCounter/0001-hal-Implement-KeQueryPerformanceCounter.patch
	(
		printf '%s\n' '+    { "Michael Müller", "hal: Implement KeQueryPerformanceCounter.", 1 },';
	) >> "$patchlist"
fi

# Patchset hnetcfg-INetFwAuthorizedApplication
# |
# | Modified files:
# |   *	dlls/hnetcfg/apps.c
# |
if test "$enable_hnetcfg_INetFwAuthorizedApplication" -eq 1; then
	patch_apply hnetcfg-INetFwAuthorizedApplication/0001-hnetcfg-Improve-INetFwAuthorizedApplication-get_Proc.patch
	(
		printf '%s\n' '+    { "Michael Müller", "hnetcfg: Improve INetFwAuthorizedApplication::get_ProcessImageFileName stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset ieframe-IViewObject-Draw
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30611] Fake success in IViewObject::Draw stub
# |
# | Modified files:
# |   *	dlls/ieframe/view.c
# |
if test "$enable_ieframe_IViewObject_Draw" -eq 1; then
	patch_apply ieframe-IViewObject-Draw/0001-ieframe-Return-S_OK-in-IViewObject-Draw-stub.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ieframe: Return S_OK in IViewObject::Draw stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset imagehlp-BindImageEx
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#3591] Support for BindImageEx
# |
# | Modified files:
# |   *	dlls/imagehlp/modify.c, dlls/imagehlp/tests/image.c
# |
if test "$enable_imagehlp_BindImageEx" -eq 1; then
	patch_apply imagehlp-BindImageEx/0001-imagehlp-Implement-parts-of-BindImageEx-to-make-free.patch
	(
		printf '%s\n' '+    { "Bernhard Reiter", "imagehlp: Implement parts of BindImageEx to make freezing Python scripts work.", 1 },';
	) >> "$patchlist"
fi

# Patchset imagehlp-Cleanup
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#23455] Properly implement imagehlp.ImageLoad and ImageUnload
# |
# | Modified files:
# |   *	dlls/imagehlp/access.c, dlls/imagehlp/modify.c, dlls/imagehlp/tests/integrity.c
# |
if test "$enable_imagehlp_Cleanup" -eq 1; then
	patch_apply imagehlp-Cleanup/0001-imagehlp-Catch-invalid-memory-access-in-CheckSumMapp.patch
	patch_apply imagehlp-Cleanup/0002-imagehlp-Fix-checksum-calculation-for-odd-sizes.patch
	patch_apply imagehlp-Cleanup/0003-imagehlp-Implement-ImageLoad-and-cleanup-ImageUnload.patch
	(
		printf '%s\n' '+    { "Michael Müller", "imagehlp: Catch invalid memory access in CheckSumMappedFile and add tests.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "imagehlp: Fix checksum calculation for odd sizes.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "imagehlp: Implement ImageLoad and cleanup ImageUnload.", 1 },';
	) >> "$patchlist"
fi

# Patchset imagehlp-ImageLoad
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	imagehlp-Cleanup
# |
# | Modified files:
# |   *	dlls/imagehlp/tests/image.c
# |
if test "$enable_imagehlp_ImageLoad" -eq 1; then
	patch_apply imagehlp-ImageLoad/0001-imagehlp-tests-Add-tests-for-ImageLoad-ImageUnload-G.patch
	patch_apply imagehlp-ImageLoad/0002-imagehlp-tests-msvc-compatibility-fixes.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "imagehlp/tests: Add tests for ImageLoad, ImageUnload, GetImageUnusedHeaderBytes.", 1 },';
		printf '%s\n' '+    { "Mark Jansen", "imagehlp/tests: Msvc compatibility fixes.", 1 },';
	) >> "$patchlist"
fi

# Patchset imm32-IMMDisableLegacyIME
# |
# | Modified files:
# |   *	dlls/imm32/imm.c, dlls/imm32/imm32.spec
# |
if test "$enable_imm32_IMMDisableLegacyIME" -eq 1; then
	patch_apply imm32-IMMDisableLegacyIME/0001-imm32-Add-stub-for-ImmDisableLegacyIME.patch
	(
		printf '%s\n' '+    { "Michael Müller", "imm32: Add stub for ImmDisableLegacyIME.", 1 },';
	) >> "$patchlist"
fi

# Patchset include-winsock
# |
# | Modified files:
# |   *	include/winsock.h
# |
if test "$enable_include_winsock" -eq 1; then
	patch_apply include-winsock/0001-include-Always-define-hton-ntoh-macros.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "include: Always define hton/ntoh macros.", 1 },';
	) >> "$patchlist"
fi

# Patchset inseng-Implementation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39456] Implement CIF reader and download functionality in inseng.dll
# |
# | Modified files:
# |   *	dlls/inseng/Makefile.in, dlls/inseng/icif.c, dlls/inseng/inf.c, dlls/inseng/inseng.spec, dlls/inseng/inseng_main.c,
# | 	dlls/inseng/inseng_private.h, include/inseng.idl
# |
if test "$enable_inseng_Implementation" -eq 1; then
	patch_apply inseng-Implementation/0001-inseng-Implement-CIF-reader-and-download-functions.patch
	(
		printf '%s\n' '+    { "Michael Müller", "inseng: Implement CIF reader and download functions.", 1 },';
	) >> "$patchlist"
fi

# Patchset iphlpapi-System_Ping
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8332] Fallback to system ping command when CAP_NET_RAW is not available
# |
# | Modified files:
# |   *	dlls/iphlpapi/icmp.c, dlls/iphlpapi/tests/iphlpapi.c
# |
if test "$enable_iphlpapi_System_Ping" -eq 1; then
	patch_apply iphlpapi-System_Ping/0001-iphlpapi-Fallback-to-system-ping-when-ICMP-permissio.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "iphlpapi: Fallback to system ping when ICMP permissions are not present.", 1 },';
	) >> "$patchlist"
fi

# Patchset iphlpapi-TCP_Table
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34372] Support for AllocateAndGetTcpExTableFromStack
# |
# | Modified files:
# |   *	dlls/iphlpapi/iphlpapi.spec, dlls/iphlpapi/ipstats.c, dlls/iphlpapi/ipstats.h
# |
if test "$enable_iphlpapi_TCP_Table" -eq 1; then
	patch_apply iphlpapi-TCP_Table/0001-iphlpapi-Implement-AllocateAndGetTcpExTableFromStack.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "iphlpapi: Implement AllocateAndGetTcpExTableFromStack.", 2 },';
	) >> "$patchlist"
fi

# Patchset server-File_Permissions
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38970] Improve mapping of DACL to file permissions
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, dlls/ntdll/tests/file.c, server/fd.c, server/file.c
# |
if test "$enable_server_File_Permissions" -eq 1; then
	patch_apply server-File_Permissions/0001-server-Improve-STATUS_CANNOT_DELETE-checks-for-direc.patch
	patch_apply server-File_Permissions/0002-server-Allow-to-open-files-without-any-permission-bi.patch
	patch_apply server-File_Permissions/0003-server-When-creating-new-directories-temporarily-giv.patch
	patch_apply server-File_Permissions/0004-advapi32-tests-Add-tests-for-ACL-inheritance-in-Crea.patch
	patch_apply server-File_Permissions/0005-advapi32-tests-Add-ACL-inheritance-tests-for-creatin.patch
	patch_apply server-File_Permissions/0006-ntdll-tests-Added-tests-for-open-behaviour-on-readon.patch
	patch_apply server-File_Permissions/0007-server-FILE_WRITE_ATTRIBUTES-should-succeed-for-read.patch
	patch_apply server-File_Permissions/0008-server-Improve-mapping-of-DACL-to-file-permissions.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Improve STATUS_CANNOT_DELETE checks for directory case.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Allow to open files without any permission bits.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: When creating new directories temporarily give read-permissions until they are opened.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "advapi32/tests: Add tests for ACL inheritance in CreateDirectoryA.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "advapi32/tests: Add ACL inheritance tests for creating subdirectories with NtCreateFile.", 1 },';
		printf '%s\n' '+    { "Qian Hong", "ntdll/tests: Added tests for open behaviour on readonly files.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: FILE_WRITE_ATTRIBUTES should succeed for readonly files.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Improve mapping of DACL to file permissions.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FileDispositionInformation
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-File_Permissions
# |
# | Modified files:
# |   *	dlls/ntdll/tests/file.c, server/fd.c
# |
if test "$enable_ntdll_FileDispositionInformation" -eq 1; then
	patch_apply ntdll-FileDispositionInformation/0001-ntdll-tests-Added-tests-to-set-disposition-on-file-w.patch
	patch_apply ntdll-FileDispositionInformation/0002-server-Do-not-allow-to-set-disposition-on-file-which.patch
	patch_apply ntdll-FileDispositionInformation/0003-server-When-combining-root-and-name-make-sure-there-.patch
	(
		printf '%s\n' '+    { "Qian Hong", "ntdll/tests: Added tests to set disposition on file which is mapped to memory.", 1 },';
		printf '%s\n' '+    { "Qian Hong", "server: Do not allow to set disposition on file which has a file mapping.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: When combining root and name, make sure there is only one slash.", 2 },';
	) >> "$patchlist"
fi

# Patchset kernel32-CopyFileEx
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-File_Permissions, ntdll-FileDispositionInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22692] Add support for CopyFileEx progress callback
# |   *	[#22690] Allow to cancel a file operation via progress callback
# |
# | Modified files:
# |   *	dlls/kernel32/path.c, dlls/kernel32/tests/file.c
# |
if test "$enable_kernel32_CopyFileEx" -eq 1; then
	patch_apply kernel32-CopyFileEx/0001-kernel32-Add-support-for-progress-callback-in-CopyFi.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernel32: Add support for progress callback in CopyFileEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Cwd_Startup_Info
# |
# | Modified files:
# |   *	dlls/kernel32/process.c
# |
if test "$enable_kernel32_Cwd_Startup_Info" -eq 1; then
	patch_apply kernel32-Cwd_Startup_Info/0001-kernel32-Allow-non-nullterminated-string-as-working-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "kernel32: Allow non-nullterminated string as working directory in create_startup_info.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Debugger
# |
# | Modified files:
# |   *	dlls/kernel32/except.c
# |
if test "$enable_kernel32_Debugger" -eq 1; then
	patch_apply kernel32-Debugger/0001-kernel32-Always-start-debugger-on-WinSta0.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "kernel32: Always start debugger on WinSta0.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-FindFirstFile
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22635] Strip invalid characters from mask in FindFirstFileExW
# |
# | Modified files:
# |   *	dlls/kernel32/file.c, dlls/kernel32/tests/file.c
# |
if test "$enable_kernel32_FindFirstFile" -eq 1; then
	patch_apply kernel32-FindFirstFile/0001-kernel32-Strip-invalid-characters-from-mask-in-FindF.patch
	patch_apply kernel32-FindFirstFile/0002-kernel32-tests-Add-tests-for-FindFirstFileA-with-inv.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernel32: Strip invalid characters from mask in FindFirstFileExW.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "kernel32/tests: Add tests for FindFirstFileA with invalid characters.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-GetShortPathName
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39355] Fix handling of wildcard paths in GetShortPathName and GetLongPathName
# |
# | Modified files:
# |   *	dlls/kernel32/path.c, dlls/kernel32/tests/path.c
# |
if test "$enable_kernel32_GetShortPathName" -eq 1; then
	patch_apply kernel32-GetShortPathName/0001-kernel32-tests-Add-some-tests-for-GetLongPathName-Ge.patch
	patch_apply kernel32-GetShortPathName/0002-kernel32-GetShortPathName-should-fail-when-called-wi.patch
	patch_apply kernel32-GetShortPathName/0003-kernel32-GetLongPathName-should-fail-when-called-wit.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32/tests: Add some tests for GetLongPathName/GetShortPathName called with a wildcard.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32: GetShortPathName should fail when called with a wildcard.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32: GetLongPathName should fail when called with a wildcard.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Job_Tests
# |
# | Modified files:
# |   *	dlls/kernel32/tests/process.c
# |
if test "$enable_kernel32_Job_Tests" -eq 1; then
	patch_apply kernel32-Job_Tests/0001-kernel32-tests-Add-tests-for-job-object-accounting.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "kernel32/tests: Add tests for job object accounting.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-K32GetPerformanceInfo
# |
# | Modified files:
# |   *	dlls/kernel32/cpu.c, server/process.c, server/protocol.def
# |
if test "$enable_kernel32_K32GetPerformanceInfo" -eq 1; then
	patch_apply kernel32-K32GetPerformanceInfo/0001-kernel32-Make-K32GetPerformanceInfo-faster.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernel32: Make K32GetPerformanceInfo faster.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-LocaleNameToLCID
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30076] Silence repeated LocaleNameToLCID/LCIDToLocaleName unsupported flags FIXMEs
# |
# | Modified files:
# |   *	dlls/kernel32/locale.c
# |
if test "$enable_kernel32_LocaleNameToLCID" -eq 1; then
	patch_apply kernel32-LocaleNameToLCID/0001-kernel32-Silence-repeated-LocaleNameToLCID-unsupport.patch
	(
		printf '%s\n' '+    { "Jarkko Korpi", "kernel32: Silence repeated LocaleNameToLCID unsupported flags message.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-MODULE_get_binary_info
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43217] Implement detection for position-independent executables
# |
# | Modified files:
# |   *	dlls/kernel32/module.c
# |
if test "$enable_kernel32_MODULE_get_binary_info" -eq 1; then
	patch_apply kernel32-MODULE_get_binary_info/0001-kernel32-Add-detection-for-position-independent-exec.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "kernel32: Add detection for position independent executables.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Misalign_Workaround
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24374] Fill stack with meaningful values in call_process_entry mis-align workaround
# |
# | Modified files:
# |   *	dlls/kernel32/process.c
# |
if test "$enable_kernel32_Misalign_Workaround" -eq 1; then
	patch_apply kernel32-Misalign_Workaround/0001-kernel32-Fill-stack-with-meaningful-values-in-call_p.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "kernel32: Fill stack with meaningful values in call_process_entry mis-align workaround.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-MoveFile
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#14901] MoveFile with source == dest should succeed.
# |
# | Modified files:
# |   *	dlls/appwiz.cpl/addons.c, dlls/kernel32/path.c, dlls/kernel32/tests/file.c, dlls/msvcp120/tests/msvcp120.c,
# | 	dlls/urlmon/tests/url.c, programs/cmd/tests/test_builtins.cmd.exp
# |
if test "$enable_kernel32_MoveFile" -eq 1; then
	patch_apply kernel32-MoveFile/0001-kernel32-tests-Fix-compilation-with-PSDK.patch
	patch_apply kernel32-MoveFile/0002-kernel32-tests-Fix-a-bunch-of-access-denied-errors-b.patch
	patch_apply kernel32-MoveFile/0003-kernel32-tests-Move-the-MoveFile-test-where-it-belon.patch
	patch_apply kernel32-MoveFile/0004-kernel32-MoveFile-source-source-should-succeed.patch
	patch_apply kernel32-MoveFile/0005-kernel32-MoveFile-should-make-sure-that-it-has-the-d.patch
	patch_apply kernel32-MoveFile/0006-urlmon-tests-Add-test-for-opening-cache-file-with-DE.patch
	patch_apply kernel32-MoveFile/0007-appwiz.cpl-Copy-addons-to-cache-instead-of-moving.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32/tests: Fix compilation with PSDK.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32/tests: Fix a bunch of access denied errors by using a dedicated TEMP directory.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32/tests: Move the MoveFile test where it belongs.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32: MoveFile(source, source) should succeed.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32: MoveFile should make sure that it has the delete access to the source file.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "urlmon/tests: Add test for opening cache file with DELETE access.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "appwiz.cpl: Copy addons to cache instead of moving.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-NeedCurrentDirectoryForExePath
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#23934] CreateProcess does not prioritize the working directory over the system search path
# |
# | Modified files:
# |   *	dlls/kernel32/path.c, dlls/kernel32/process.c, dlls/kernel32/tests/path.c
# |
if test "$enable_kernel32_NeedCurrentDirectoryForExePath" -eq 1; then
	patch_apply kernel32-NeedCurrentDirectoryForExePath/0001-kernel32-Add-SearchPath-test-demonstrating-the-prior.patch
	patch_apply kernel32-NeedCurrentDirectoryForExePath/0002-kernel32-NeedCurrentDirectoryForExePath-does-not-use.patch
	patch_apply kernel32-NeedCurrentDirectoryForExePath/0003-kernel32-Consider-the-working-directory-first-when-l.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "kernel32: Add SearchPath test demonstrating the priority of the working directory.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "kernel32: NeedCurrentDirectoryForExePath does not use the registry.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "kernel32: Consider the working directory first when launching executables with CreateProcess.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-PE_Loader_Fixes
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	kernel32-Misalign_Workaround
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42125] Various PE loader fixes for 8k demos
# |
# | Modified files:
# |   *	dlls/kernel32/process.c, dlls/kernel32/tests/loader.c, dlls/ntdll/virtual.c, server/mapping.c
# |
if test "$enable_kernel32_PE_Loader_Fixes" -eq 1; then
	patch_apply kernel32-PE_Loader_Fixes/0001-server-All-fields-up-to-CheckSum-are-mandatory-regar.patch
	patch_apply kernel32-PE_Loader_Fixes/0002-ntdll-If-PE-image-size-is-larger-than-the-backed-fil.patch
	patch_apply kernel32-PE_Loader_Fixes/0003-kernel32-On-process-entry-store-PEB-address-in-ebx.patch
	patch_apply kernel32-PE_Loader_Fixes/0005-kernel32-tests-Add-a-PE-test-image-that-resembles-fo.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "server: All fields up to CheckSum are mandatory regardless of SizeOfOptionalHeader value.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ntdll: If PE image size is larger than the backed file size then treat file as removable.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32: On process entry store PEB address in %ebx.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32/tests: Add a PE test image that resembles format of some of 8k demos.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Processor_Group
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	combase-RoApi, kernel32-UmsStubs, api-ms-win-Stub_DLLs
# |
# | Modified files:
# |   *	dlls/api-ms-win-core-kernel32-legacy-l1-1-0/api-ms-win-core-kernel32-legacy-l1-1-0.spec, dlls/kernel32/cpu.c,
# | 	dlls/kernel32/kernel32.spec, dlls/kernel32/tests/process.c, dlls/kernel32/thread.c, include/winnt.h
# |
if test "$enable_kernel32_Processor_Group" -eq 1; then
	patch_apply kernel32-Processor_Group/0001-kernel32-Implement-some-processor-group-functions.patch
	patch_apply kernel32-Processor_Group/0002-kernel32-Add-stub-for-SetThreadIdealProcessorEx.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernel32: Implement some processor group functions.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "kernel32: Add stub for SetThreadIdealProcessorEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Profile
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8036] Fix handling of empty section and key name for profile files.
# |   *	[#18099] Super Mario 3: Mario Forever fails to load keyboard mapping from profile files.
# |
# | Modified files:
# |   *	dlls/kernel32/profile.c, dlls/kernel32/tests/profile.c
# |
if test "$enable_kernel32_Profile" -eq 1; then
	patch_apply kernel32-Profile/0001-kernel32-Allow-empty-profile-section-and-key-name-st.patch
	(
		printf '%s\n' '+    { "Claudio Fontana", "kernel32: Allow empty profile section and key name strings.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-SCSI_Sysfs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#31592] Use sysfs to populate SCSI registry keys
# |
# | Modified files:
# |   *	dlls/kernel32/oldconfig.c
# |
if test "$enable_kernel32_SCSI_Sysfs" -eq 1; then
	patch_apply kernel32-SCSI_Sysfs/0001-kernel32-Convert-scsi-device-type-in-SCSI_getprocent.patch
	patch_apply kernel32-SCSI_Sysfs/0002-kernel32-Add-support-for-reading-scsi-devices-from-s.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernel32: Convert scsi device type in SCSI_getprocentry.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "kernel32: Add support for reading scsi devices from sysfs.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FileNameInformation
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_FileNameInformation" -eq 1; then
	patch_apply ntdll-FileNameInformation/0001-ntdll-Implement-querying-for-FileNameInformation-of-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement querying for FileNameInformation of named pipes in NtQueryInformationFile.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-SetFileCompletionNotificationModes
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-FileNameInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38960] Add support for kernel32.SetFileCompletionNotificationModes
# |
# | Modified files:
# |   *	dlls/kernel32/file.c, dlls/ntdll/file.c, dlls/ntdll/tests/file.c, dlls/ntdll/tests/pipe.c, dlls/ws2_32/socket.c,
# | 	dlls/ws2_32/tests/sock.c, server/async.c, server/fd.c, server/file.h, server/protocol.def
# |
if test "$enable_kernel32_SetFileCompletionNotificationModes" -eq 1; then
	patch_apply kernel32-SetFileCompletionNotificationModes/0001-ntdll-Implement-FileIoCompletionNotificationInformat.patch
	patch_apply kernel32-SetFileCompletionNotificationModes/0002-ntdll-Allow-to-query-file-IO-completion-notification.patch
	patch_apply kernel32-SetFileCompletionNotificationModes/0003-ws2_32-tests-Add-test-for-completion-notification-fl.patch
	patch_apply kernel32-SetFileCompletionNotificationModes/0004-ntdll-tests-Add-more-tests-for-FileIoCompletionNotif.patch
	patch_apply kernel32-SetFileCompletionNotificationModes/0005-ntdll-Do-not-require-unix-fd-for-FileIoCompletionNot.patch
	patch_apply kernel32-SetFileCompletionNotificationModes/0006-server-Skip-async-completion-when-possible.patch
	patch_apply kernel32-SetFileCompletionNotificationModes/0007-ws2_32-Don-t-skip-completion-in-AcceptEx.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Implement FileIoCompletionNotificationInformation info class.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Allow to query file IO completion notification mode.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32/tests: Add test for completion notification flags.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll/tests: Add more tests for FileIoCompletionNotificationInformation.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Do not require unix fd for FileIoCompletionNotificationInformation.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Skip async completion when possible.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32: Don'\''t skip completion in AcceptEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-TRUST_E_NOSIGNATURE
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43041] Add missing message string for TRUST_E_NOSIGNATURE
# |
# | Modified files:
# |   *	dlls/kernel32/tests/format_msg.c, dlls/kernel32/winerror.mc
# |
if test "$enable_kernel32_TRUST_E_NOSIGNATURE" -eq 1; then
	patch_apply kernel32-TRUST_E_NOSIGNATURE/0001-kernel32-add-message-resource-for-TRUST_E_NOSIGNATUR.patch
	(
		printf '%s\n' '+    { "Louis Lenders", "kernel32: Add message resource for TRUST_E_NOSIGNATURE.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-Tests
# |
# | Modified files:
# |   *	dlls/kernel32/tests/process.c
# |
if test "$enable_kernel32_Tests" -eq 1; then
	patch_apply kernel32-Tests/0001-kernel32-tests-Close-process-thread-handles.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "kernel32/tests: Close process / thread handles.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-TimezoneInformation_Registry
# |
# | Modified files:
# |   *	dlls/kernel32/kernel_main.c, dlls/kernel32/kernel_private.h, dlls/kernel32/time.c
# |
if test "$enable_kernel32_TimezoneInformation_Registry" -eq 1; then
	patch_apply kernel32-TimezoneInformation_Registry/0001-kernel32-Init-TimezoneInformation-registry.patch
	(
		printf '%s\n' '+    { "Qian Hong", "kernel32: Init TimezoneInformation registry.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernel32-VerifyVersionInfo
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#36143] Fix condition mask handling in RtlVerifyVersionInfo
# |
# | Modified files:
# |   *	dlls/kernel32/tests/version.c, dlls/ntdll/version.c
# |
if test "$enable_kernel32_VerifyVersionInfo" -eq 1; then
	patch_apply kernel32-VerifyVersionInfo/0001-kernel32-tests-Add-additional-tests-for-condition-ma.patch
	patch_apply kernel32-VerifyVersionInfo/0002-ntdll-Fix-condition-mask-handling-in-RtlVerifyVersio.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "kernel32/tests: Add additional tests for condition mask of VerifyVersionInfoA.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Fix condition mask handling in RtlVerifyVersionInfo.", 1 },';
	) >> "$patchlist"
fi

# Patchset kernelbase-PathCchCombineEx
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42474] Implement kernelbase.PathCchCombineEx
# |
# | Modified files:
# |   *	configure.ac, dlls/api-ms-win-core-path-l1-1-0/api-ms-win-core-path-l1-1-0.spec, dlls/kernelbase/Makefile.in,
# | 	dlls/kernelbase/kernelbase.spec, dlls/kernelbase/main.c, dlls/kernelbase/tests/Makefile.in,
# | 	dlls/kernelbase/tests/path.c, include/Makefile.in, include/pathcch.h
# |
if test "$enable_kernelbase_PathCchCombineEx" -eq 1; then
	patch_apply kernelbase-PathCchCombineEx/0001-kernelbase-Add-semi-stub-for-PathCchCombineEx.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernelbase: Add semi-stub for PathCchCombineEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset krnl386.exe16-GDT_LDT_Emulation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30237] Implement emulation of GDT and LDT access in Win98 mode
# |
# | Modified files:
# |   *	dlls/krnl386.exe16/instr.c
# |
if test "$enable_krnl386_exe16_GDT_LDT_Emulation" -eq 1; then
	patch_apply krnl386.exe16-GDT_LDT_Emulation/0001-krnl386.exe16-Emulate-GDT-and-LDT-access.patch
	(
		printf '%s\n' '+    { "Michael Müller", "krnl386.exe16: Emulate GDT and LDT access.", 1 },';
	) >> "$patchlist"
fi

# Patchset krnl386.exe16-Invalid_Console_Handles
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#7106] Translate all invalid console handles into usable DOS handles
# |
# | Modified files:
# |   *	dlls/krnl386.exe16/file.c
# |
if test "$enable_krnl386_exe16_Invalid_Console_Handles" -eq 1; then
	patch_apply krnl386.exe16-Invalid_Console_Handles/0001-krnl386.exe16-Really-translate-all-invalid-console-h.patch
	(
		printf '%s\n' '+    { "Michael Müller", "krnl386.exe16: Really translate all invalid console handles into usable DOS handles.", 1 },';
	) >> "$patchlist"
fi

# Patchset krnl386.exe16-_lclose16
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#19184] Do not reassign default handles after they got closed
# |
# | Modified files:
# |   *	dlls/krnl386.exe16/file.c
# |
if test "$enable_krnl386_exe16__lclose16" -eq 1; then
	patch_apply krnl386.exe16-_lclose16/0001-krnl386.exe16-Do-not-reassign-default-handles-after-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "krnl386.exe16: Do not reassign default handles after they got closed.", 1 },';
	) >> "$patchlist"
fi

# Patchset libs-Debug_Channel
# |
# | Modified files:
# |   *	libs/wine/debug.c
# |
if test "$enable_libs_Debug_Channel" -eq 1; then
	patch_apply libs-Debug_Channel/0001-libwine-Add-process-specific-debug-channels.patch
	(
		printf '%s\n' '+    { "Michael Müller", "libwine: Add process specific debug channels.", 1 },';
	) >> "$patchlist"
fi

# Patchset libs-Unicode_Collation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#10767] Fix comparison of punctuation characters in lstrcmp
# |   *	[#32490] Graphical issues in Inquisitor
# |
# | Modified files:
# |   *	dlls/kernel32/tests/locale.c, libs/wine/collation.c
# |
if test "$enable_libs_Unicode_Collation" -eq 1; then
	patch_apply libs-Unicode_Collation/0001-libs-Fix-most-problems-with-CompareString.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "libs: Fix most problems with CompareString.", 1 },';
	) >> "$patchlist"
fi

# Patchset loader-OSX_Preloader
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Staging, configure-Absolute_RPATH
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33159] Implement preloader for Mac OS
# |
# | Modified files:
# |   *	Makefile.in, configure.ac, dlls/ntdll/virtual.c, libs/wine/config.c, libs/wine/loader.c, loader/Makefile.in,
# | 	loader/main.c, loader/preloader.c
# |
if test "$enable_loader_OSX_Preloader" -eq 1; then
	patch_apply loader-OSX_Preloader/0001-libs-wine-Do-not-restrict-base-address-of-main-threa.patch
	patch_apply loader-OSX_Preloader/0002-loader-Implement-preloader-for-Mac-OS.patch
	(
		printf '%s\n' '+    { "Michael Müller", "libs/wine: Do not restrict base address of main thread on 64 bit mac os.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "loader: Implement preloader for Mac OS.", 1 },';
	) >> "$patchlist"
fi

# Patchset makedep-PARENTSPEC
# |
# | Modified files:
# |   *	tools/makedep.c
# |
if test "$enable_makedep_PARENTSPEC" -eq 1; then
	patch_apply makedep-PARENTSPEC/0001-makedep-Add-support-for-PARENTSPEC-Makefile-variable.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "makedep: Add support for PARENTSPEC Makefile variable.", 1 },';
	) >> "$patchlist"
fi

# Patchset mmsystem.dll16-MIDIHDR_Refcount
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40024] Fix multiple issues in mmsystem.dll16 when translating MIDI messages
# |
# | Modified files:
# |   *	dlls/mmsystem.dll16/message16.c
# |
if test "$enable_mmsystem_dll16_MIDIHDR_Refcount" -eq 1; then
	patch_apply mmsystem.dll16-MIDIHDR_Refcount/0001-mmsystem.dll16-Refcount-midihdr-to-work-around-buggy.patch
	patch_apply mmsystem.dll16-MIDIHDR_Refcount/0002-mmsystem.dll16-Translate-MidiIn-messages.patch
	(
		printf '%s\n' '+    { "Michael Müller", "mmsystem.dll16: Refcount midihdr to work around buggy application which unprepares buffer during a callback.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "mmsystem.dll16: Translate MidiIn messages.", 1 },';
	) >> "$patchlist"
fi

# Patchset mountmgr-DosDevices
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38235] Fix device paths in HKLM\SYSTEM\MountedDevices
# |
# | Modified files:
# |   *	dlls/mountmgr.sys/device.c, dlls/mountmgr.sys/mountmgr.c, dlls/mountmgr.sys/mountmgr.h
# |
if test "$enable_mountmgr_DosDevices" -eq 1; then
	patch_apply mountmgr-DosDevices/0001-mountmgr.sys-Write-usable-device-paths-into-HKLM-SYS.patch
	(
		printf '%s\n' '+    { "Michael Müller", "mountmgr.sys: Write usable device paths into HKLM\\SYSTEM\\MountedDevices.", 1 },';
	) >> "$patchlist"
fi

# Patchset mpr-WNetGetUniversalNameW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39452] Return WN_NOT_CONNECTED from WNetGetUniversalName REMOTE_NAME_INFO_LEVEL stub
# |
# | Modified files:
# |   *	dlls/mpr/tests/mpr.c, dlls/mpr/wnet.c
# |
if test "$enable_mpr_WNetGetUniversalNameW" -eq 1; then
	patch_apply mpr-WNetGetUniversalNameW/0001-mpr-Return-correct-error-code-for-non-network-paths-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "mpr: Return correct error code for non network paths and REMOTE_NAME_INFO_LEVEL in WNetGetUniversalName.", 1 },';
	) >> "$patchlist"
fi

# Patchset mscoree-CorValidateImage
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38662] Implement mscoree._CorValidateImage for mono runtime
# |
# | Modified files:
# |   *	dlls/mscoree/mscoree_main.c
# |
if test "$enable_mscoree_CorValidateImage" -eq 1; then
	patch_apply mscoree-CorValidateImage/0001-mscoree-Implement-_CorValidateImage.patch
	(
		printf '%s\n' '+    { "Michael Müller", "mscoree: Implement semi-stub for _CorValidateImage.", 1 },';
	) >> "$patchlist"
fi

# Patchset mshtml-HTMLLocation_put_hash
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32967] Add IHTMLLocation::hash property's getter implementation
# |
# | Modified files:
# |   *	dlls/mshtml/htmllocation.c, dlls/mshtml/tests/htmldoc.c
# |
if test "$enable_mshtml_HTMLLocation_put_hash" -eq 1; then
	patch_apply mshtml-HTMLLocation_put_hash/0001-mshtml-Add-IHTMLLocation-hash-property-s-getter-impl.patch
	(
		printf '%s\n' '+    { "Zhenbo Li", "mshtml: Add IHTMLLocation::hash property'\''s getter implementation.", 1 },';
	) >> "$patchlist"
fi

# Patchset msi-Dummy_Thread
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#18070] Workaround COM/MTA issues due to lack of separate msi custom action process
# |
# | Modified files:
# |   *	dlls/msi/action.c
# |
if test "$enable_msi_Dummy_Thread" -eq 1; then
	patch_apply msi-Dummy_Thread/0001-msi-Create-dummy-thread-to-initialize-COM-for-custom.patch
	(
		printf '%s\n' '+    { "Michael Müller", "msi: Create dummy thread to initialize COM for custom actions.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtAllocateUuids
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35910] Fix API signature of ntdll.NtAllocateUuids
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/om.c, dlls/ntoskrnl.exe/ntoskrnl.exe.spec, include/winternl.h
# |
if test "$enable_ntdll_NtAllocateUuids" -eq 1; then
	patch_apply ntdll-NtAllocateUuids/0001-ntdll-Improve-stub-for-NtAllocateUuids.patch
	(
		printf '%s\n' '+    { "Louis Lenders", "ntdll: Improve stub for NtAllocateUuids.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntoskrnl-Stubs
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Compiler_Warnings, ntdll-NtAllocateUuids
# |
# | Modified files:
# |   *	dlls/ntoskrnl.exe/ntoskrnl.c, dlls/ntoskrnl.exe/ntoskrnl.exe.spec, include/ddk/wdm.h, include/winnt.h
# |
if test "$enable_ntoskrnl_Stubs" -eq 1; then
	patch_apply ntoskrnl-Stubs/0003-ntoskrnl.exe-Add-stubs-for-ExAcquireFastMutexUnsafe-.patch
	patch_apply ntoskrnl-Stubs/0004-ntoskrnl.exe-Add-stubs-for-ObReferenceObjectByPointe.patch
	patch_apply ntoskrnl-Stubs/0005-ntoskrnl.exe-Improve-KeReleaseMutex-stub.patch
	patch_apply ntoskrnl-Stubs/0006-ntoskrnl.exe-Improve-KeInitializeSemaphore-stub.patch
	patch_apply ntoskrnl-Stubs/0007-ntoskrnl.exe-Improve-KeInitializeTimerEx-stub.patch
	patch_apply ntoskrnl-Stubs/0008-ntoskrnl.exe-Fix-IoReleaseCancelSpinLock-argument.patch
	patch_apply ntoskrnl-Stubs/0009-ntoskrnl.exe-Implement-MmMapLockedPages-and-MmUnmapL.patch
	patch_apply ntoskrnl-Stubs/0010-ntoskrnl.exe-Implement-KeInitializeMutex.patch
	patch_apply ntoskrnl-Stubs/0011-ntoskrnl.exe-Add-IoGetDeviceAttachmentBaseRef-stub.patch
	patch_apply ntoskrnl-Stubs/0012-ntoskrnl-Implement-ExInterlockedPopEntrySList.patch
	patch_apply ntoskrnl-Stubs/0013-ntoskrnl.exe-Implement-NtBuildNumber.patch
	patch_apply ntoskrnl-Stubs/0014-ntoskrnl.exe-Implement-ExInitializeNPagedLookasideLi.patch
	(
		printf '%s\n' '+    { "Alexander Morozov", "ntoskrnl.exe: Add stubs for ExAcquireFastMutexUnsafe and ExReleaseFastMutexUnsafe.", 1 },';
		printf '%s\n' '+    { "Alexander Morozov", "ntoskrnl.exe: Add stub for ObReferenceObjectByPointer.", 1 },';
		printf '%s\n' '+    { "Alexander Morozov", "ntoskrnl.exe: Improve KeReleaseMutex stub.", 1 },';
		printf '%s\n' '+    { "Alexander Morozov", "ntoskrnl.exe: Improve KeInitializeSemaphore stub.", 1 },';
		printf '%s\n' '+    { "Alexander Morozov", "ntoskrnl.exe: Improve KeInitializeTimerEx stub.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "ntoskrnl.exe: Fix IoReleaseCancelSpinLock argument.", 1 },';
		printf '%s\n' '+    { "Christian Costa", "ntoskrnl.exe: Implement MmMapLockedPages and MmUnmapLockedPages.", 1 },';
		printf '%s\n' '+    { "Alexander Morozov", "ntoskrnl.exe: Implement KeInitializeMutex.", 1 },';
		printf '%s\n' '+    { "Jarkko Korpi", "ntoskrnl.exe: Add IoGetDeviceAttachmentBaseRef stub.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntoskrnl: Implement ExInterlockedPopEntrySList.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntoskrnl.exe: Implement NtBuildNumber.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntoskrnl.exe: Implement ExInitializeNPagedLookasideList.", 1 },';
	) >> "$patchlist"
fi

# Patchset winedevice-Default_Drivers
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	dxva2-Video_Decoder
# |
# | Modified files:
# |   *	configure.ac, dlls/dxgkrnl.sys/Makefile.in, dlls/dxgkrnl.sys/dxgkrnl.sys.spec, dlls/dxgkrnl.sys/main.c,
# | 	dlls/dxgmms1.sys/Makefile.in, dlls/dxgmms1.sys/dxgmms1.sys.spec, dlls/dxgmms1.sys/main.c, dlls/win32k.sys/Makefile.in,
# | 	dlls/win32k.sys/main.c, dlls/win32k.sys/win32k.sys.spec, loader/wine.inf.in, programs/winedevice/device.c,
# | 	tools/make_specfiles
# |
if test "$enable_winedevice_Default_Drivers" -eq 1; then
	patch_apply winedevice-Default_Drivers/0001-win32k.sys-Add-stub-driver.patch
	patch_apply winedevice-Default_Drivers/0002-dxgkrnl.sys-Add-stub-driver.patch
	patch_apply winedevice-Default_Drivers/0003-dxgmms1.sys-Add-stub-driver.patch
	patch_apply winedevice-Default_Drivers/0004-programs-winedevice-Load-some-common-drivers-and-fix.patch
	(
		printf '%s\n' '+    { "Michael Müller", "win32k.sys: Add stub driver.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxgkrnl.sys: Add stub driver.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "dxgmms1.sys: Add stub driver.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "programs/winedevice: Load some common drivers and fix ldr order.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntoskrnl-DriverTest
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Compiler_Warnings, ntdll-NtAllocateUuids, ntoskrnl-Stubs, dxva2-Video_Decoder, winedevice-Default_Drivers
# |
# | Modified files:
# |   *	aclocal.m4, configure.ac, dlls/ntoskrnl.exe/ntoskrnl.exe.spec, dlls/ntoskrnl.exe/tests/Makefile.in,
# | 	dlls/ntoskrnl.exe/tests/driver.sys/Makefile.in, dlls/ntoskrnl.exe/tests/driver.sys/driver.c,
# | 	dlls/ntoskrnl.exe/tests/driver.sys/driver.h, dlls/ntoskrnl.exe/tests/driver.sys/driver.sys.spec,
# | 	dlls/ntoskrnl.exe/tests/driver.sys/test.c, dlls/ntoskrnl.exe/tests/driver.sys/test.h,
# | 	dlls/ntoskrnl.exe/tests/driver.sys/util.h, dlls/ntoskrnl.exe/tests/ntoskrnl.c, include/ddk/ntddk.h, include/wine/test.h,
# | 	tools/make_makefiles, tools/makedep.c
# |
if test "$enable_ntoskrnl_DriverTest" -eq 1; then
	patch_apply ntoskrnl-DriverTest/0001-ntoskrnl.exe-tests-Add-initial-driver-testing-framew.patch
	patch_apply ntoskrnl-DriverTest/0002-ntoskrnl.exe-tests-Add-kernel-compliant-test-functio.patch
	patch_apply ntoskrnl-DriverTest/0003-ntoskrnl.exe-tests-Add-tests-for-NtBuildNumber.patch
	patch_apply ntoskrnl-DriverTest/0004-ntoskrnl.exe-tests-Add-tests-for-ExInitializeNPagedL.patch
	patch_apply ntoskrnl-DriverTest/0005-ntoskrnl.exe-tests-Check-ldr-module-order-and-some-c.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntoskrnl.exe/tests: Add initial driver testing framework and corresponding changes to Makefile system.", 2 },';
		printf '%s\n' '+    { "Michael Müller", "ntoskrnl.exe/tests: Add kernel compliant test functions.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntoskrnl.exe/tests: Add tests for NtBuildNumber.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntoskrnl.exe/tests: Add tests for ExInitializeNPagedLookasideList.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntoskrnl.exe/tests: Check ldr module order and some common kernel drivers.", 1 },';
	) >> "$patchlist"
fi

# Patchset msi-MsiGetDatabaseState
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	Compiler_Warnings, ntdll-NtAllocateUuids, ntoskrnl-Stubs, dxva2-Video_Decoder, winedevice-Default_Drivers, ntoskrnl-
# | 	DriverTest
# |
# | Modified files:
# |   *	configure.ac, dlls/msi/database.c, dlls/msi/tests/Makefile.in, dlls/msi/tests/custom.dll/Makefile.in,
# | 	dlls/msi/tests/custom.dll/custom.spec, dlls/msi/tests/custom.dll/main.c, dlls/msi/tests/install.c
# |
if test "$enable_msi_MsiGetDatabaseState" -eq 1; then
	patch_apply msi-MsiGetDatabaseState/0001-msi-Always-return-MSIDBSTATE_ERROR-when-MsiGetDataba.patch
	patch_apply msi-MsiGetDatabaseState/0002-msi-tests-Add-custom-action-test-framework-and-check.patch
	(
		printf '%s\n' '+    { "Michael Müller", "msi: Always return MSIDBSTATE_ERROR when MsiGetDatabaseState is called from a custom action.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "msi/tests: Add custom action test framework and check MsiGetDatabaseState return value.", 1 },';
	) >> "$patchlist"
fi

# Patchset msi-msi_vcl_get_cost
# |
# | Modified files:
# |   *	dlls/msi/dialog.c
# |
if test "$enable_msi_msi_vcl_get_cost" -eq 1; then
	patch_apply msi-msi_vcl_get_cost/0001-msi-Do-not-sign-extend-after-multiplying.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "msi: Do not sign extend after multiplying.", 1 },';
	) >> "$patchlist"
fi

# Patchset msidb-Implementation
# |
# | Modified files:
# |   *	configure.ac, dlls/msi/database.c, dlls/msi/msipriv.h, dlls/msi/streams.c, dlls/msi/suminfo.c,
# | 	programs/msidb/Makefile.in, programs/msidb/main.c
# |
if test "$enable_msidb_Implementation" -eq 1; then
	patch_apply msidb-Implementation/0001-msidb-Add-stub-tool-for-manipulating-MSI-databases.patch
	patch_apply msidb-Implementation/0003-msidb-Add-support-for-importing-database-tables.patch
	patch_apply msidb-Implementation/0004-msidb-Add-support-for-adding-stream-cabinet-files-to.patch
	patch_apply msidb-Implementation/0005-msi-Add-support-for-deleting-streams-from-an-MSI-dat.patch
	patch_apply msidb-Implementation/0006-msidb-Add-support-for-removing-stream-cabinet-files-.patch
	patch_apply msidb-Implementation/0007-msidb-Add-support-for-extracting-stream-cabinet-file.patch
	patch_apply msidb-Implementation/0008-msidb-Add-support-for-exporting-database-tables.patch
	patch_apply msidb-Implementation/0009-msidb-Add-support-for-exporting-with-short-DOS-filen.patch
	patch_apply msidb-Implementation/0010-msi-Add-support-for-exporting-the-_SummaryInformatio.patch
	patch_apply msidb-Implementation/0011-msi-Break-out-field-exporting-into-a-separate-routin.patch
	patch_apply msidb-Implementation/0012-msi-Add-support-for-exporting-binary-streams-Binary-.patch
	patch_apply msidb-Implementation/0013-msidb-Add-support-for-wildcard-full-database-export.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "msidb: Add stub tool for manipulating MSI databases.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "msidb: Add support for importing database tables.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "msidb: Add support for adding stream/cabinet files to MSI databases.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "msi: Add support for deleting streams from an MSI database.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "msidb: Add support for removing stream/cabinet files from MSI databases.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "msidb: Add support for extracting stream/cabinet files from MSI databases.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "msidb: Add support for exporting database tables.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "msidb: Add support for exporting with short (DOS) filenames.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "msi: Add support for exporting the _SummaryInformation table.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "msi: Break out field exporting into a separate routine.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "msi: Add support for exporting binary streams (Binary/Icon tables).", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "msidb: Add support for wildcard (full database) export.", 1 },';
	) >> "$patchlist"
fi

# Patchset msvcr120-_SetWinRTOutOfMemoryExceptionCallback
# |
# | Modified files:
# |   *	dlls/msvcr120/msvcr120.spec, dlls/msvcr120_app/msvcr120_app.spec, dlls/msvcrt/misc.c
# |
if test "$enable_msvcr120__SetWinRTOutOfMemoryExceptionCallback" -eq 1; then
	patch_apply msvcr120-_SetWinRTOutOfMemoryExceptionCallback/0001-msvcr120-Add-stub-for-_SetWinRTOutOfMemoryExceptionC.patch
	(
		printf '%s\n' '+    { "Michael Müller", "msvcr120: Add stub for _SetWinRTOutOfMemoryExceptionCallback.", 1 },';
	) >> "$patchlist"
fi

# Patchset msvcrt-Math_Precision
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37149] Calculate msvcrt exponential math operations with higher precision
# |
# | Modified files:
# |   *	dlls/msvcrt/math.c
# |
if test "$enable_msvcrt_Math_Precision" -eq 1; then
	patch_apply msvcrt-Math_Precision/0001-msvcrt-Calculate-sinh-cosh-exp-pow-with-higher-preci.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "msvcrt: Calculate sinh/cosh/exp/pow with higher precision.", 2 },';
	) >> "$patchlist"
fi

# Patchset msvfw32-ICGetDisplayFormat
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#23175] Fix implementation of ICGetDisplayFormat
# |   *	[#25180] Fix rendering of Clonk Endeavour's intro video
# |   *	[#14695] Implement support for converting 16 bit depth to 24 bit in msvidc32
# |
# | Modified files:
# |   *	dlls/iccvid/iccvid.c, dlls/msvfw32/msvideo_main.c, dlls/msvfw32/tests/msvfw.c, dlls/msvidc32/msvideo1.c
# |
if test "$enable_msvfw32_ICGetDisplayFormat" -eq 1; then
	patch_apply msvfw32-ICGetDisplayFormat/0001-msvfw32-Try-different-formarts-in-ICGetDisplayFormat.patch
	patch_apply msvfw32-ICGetDisplayFormat/0002-msvfw32-Add-test-for-negative-width-height-values-pa.patch
	patch_apply msvfw32-ICGetDisplayFormat/0003-msvfw32-Set-biSizeImage-correctly-in-ICGetDisplayFor.patch
	patch_apply msvfw32-ICGetDisplayFormat/0004-msvfw32-Take-stride-into-account-and-ask-for-palette.patch
	patch_apply msvfw32-ICGetDisplayFormat/0005-iccvid-Fix-calculation-of-stride-and-size.patch
	patch_apply msvfw32-ICGetDisplayFormat/0006-msvidc32-Add-support-for-converting-16-bit-depth-to-.patch
	patch_apply msvfw32-ICGetDisplayFormat/0007-msvidc32-Fix-calculation-of-stride-and-size.patch
	(
		printf '%s\n' '+    { "Michael Müller", "msvfw32: Try different formarts in ICGetDisplayFormat.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "msvfw32: Add test for negative width/height values passed to ICGetDisplayFormat.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "msvfw32: Set biSizeImage correctly in ICGetDisplayFormat.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "msvfw32: Take stride into account and ask for palette in ICGetDisplayFormat.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "iccvid: Fix calculation of stride and size.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "msvidc32: Add support for converting 16 bit depth to 24 bit.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "msvidc32: Fix calculation of stride and size.", 1 },';
	) >> "$patchlist"
fi

# Patchset msxml3-Normalize_Data
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42468] Remove CRs in domtext_put_data and add them in domtext_get_xml
# |
# | Modified files:
# |   *	dlls/msxml3/tests/domdoc.c, dlls/msxml3/text.c
# |
if test "$enable_msxml3_Normalize_Data" -eq 1; then
	patch_apply msxml3-Normalize_Data/0001-msxml3-Remove-CRs-in-domtext_put_data-and-add-them-i.patch
	(
		printf '%s\n' '+    { "Alex Henrie", "msxml3: Remove CRs in domtext_put_data and add them in domtext_get_xml.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-APC_Performance
# |
# | Modified files:
# |   *	dlls/ntdll/file.c
# |
if test "$enable_ntdll_APC_Performance" -eq 1; then
	patch_apply ntdll-APC_Performance/0001-ntdll-Reuse-old-async-fileio-structures-if-possible.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Reuse old async fileio structures if possible.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Activation_Context
# |
# | Modified files:
# |   *	dlls/kernel32/tests/actctx.c, dlls/ntdll/actctx.c
# |
if test "$enable_ntdll_Activation_Context" -eq 1; then
	patch_apply ntdll-Activation_Context/0001-ntdll-Fix-return-value-for-missing-ACTIVATION_CONTEX.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Fix return value for missing ACTIVATION_CONTEXT_SECTION_ASSEMBLY_INFORMATION key.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ThreadTime
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#20230] Return correct values for GetThreadTimes function
# |
# | Modified files:
# |   *	dlls/ntdll/nt.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/process.c, dlls/ntdll/thread.c, server/protocol.def,
# | 	server/snapshot.c, server/thread.c, server/thread.h
# |
if test "$enable_ntdll_ThreadTime" -eq 1; then
	patch_apply ntdll-ThreadTime/0001-ntdll-Return-correct-values-in-GetThreadTimes-for-al.patch
	patch_apply ntdll-ThreadTime/0002-ntdll-Set-correct-thread-creation-time-for-SystemPro.patch
	patch_apply ntdll-ThreadTime/0003-ntdll-Fill-process-kernel-and-user-time.patch
	patch_apply ntdll-ThreadTime/0004-ntdll-Set-process-start-time.patch
	patch_apply ntdll-ThreadTime/0005-ntdll-Fill-out-thread-times-in-process-enumeration.patch
	patch_apply ntdll-ThreadTime/0006-ntdll-Fill-process-virtual-memory-counters-in-NtQuer.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Return correct values in GetThreadTimes() for all threads.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Set correct thread creation time for SystemProcessInformation in NtQuerySystemInformation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Fill process kernel and user time.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Set process start time.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Fill out thread times in process enumeration.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Fill process virtual memory counters in NtQuerySystemInformation.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ApiSetMap
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-ThreadTime
# |
# | Modified files:
# |   *	dlls/ntdll/thread.c, include/Makefile.in, include/apiset.h, include/winternl.h
# |
if test "$enable_ntdll_ApiSetMap" -eq 1; then
	patch_apply ntdll-ApiSetMap/0001-ntdll-Add-dummy-apiset-to-PEB.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Add dummy apiset to PEB.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ApiSetQueryApiSetPresence
# |
# | Modified files:
# |   *	dlls/api-ms-win-core-apiquery-l1-1-0/api-ms-win-core-apiquery-l1-1-0.spec, dlls/ntdll/misc.c, dlls/ntdll/ntdll.spec
# |
if test "$enable_ntdll_ApiSetQueryApiSetPresence" -eq 1; then
	patch_apply ntdll-ApiSetQueryApiSetPresence/0001-ntdll-Add-stub-for-ApiSetQueryApiSetPresence.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Add stub for ApiSetQueryApiSetPresence.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Attach_Process_DLLs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40714] Ensure process_attach callbacks are not executed too early
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c
# |
if test "$enable_ntdll_Attach_Process_DLLs" -eq 1; then
	patch_apply ntdll-Attach_Process_DLLs/0001-ntdll-Ensure-process-dlls-are-not-attached-too-early.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Ensure process dlls are not attached too early.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Hide_Wine_Exports
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Attach_Process_DLLs, ntdll-ThreadTime
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38656] Add support for hiding wine version information from applications
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c, dlls/ntdll/ntdll_misc.h
# |
if test "$enable_ntdll_Hide_Wine_Exports" -eq 1; then
	patch_apply ntdll-Hide_Wine_Exports/0001-ntdll-Add-support-for-hiding-wine-version-informatio.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add support for hiding wine version information from applications.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-x86_64_ExceptionInformation
# |
# | Modified files:
# |   *	dlls/ntdll/signal_x86_64.c, dlls/ntdll/virtual.c
# |
if test "$enable_ntdll_x86_64_ExceptionInformation" -eq 1; then
	patch_apply ntdll-x86_64_ExceptionInformation/0001-ntdll-Set-proper-ExceptionInformation-0-for-x86_64-e.patch
	patch_apply ntdll-x86_64_ExceptionInformation/0002-ntdll-Avoid-crash-when-trying-to-access-page-prot-of.patch
	patch_apply ntdll-x86_64_ExceptionInformation/0003-ntdll-Translate-icebp-instruction-to-EXCEPTION_SINGL.patch
	patch_apply ntdll-x86_64_ExceptionInformation/0004-ntdll-Correctly-handle-privileged-instructions-on-x8.patch
	patch_apply ntdll-x86_64_ExceptionInformation/0005-ntdll-Handle-interrupt-0x2c-on-x86_64.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Set proper ExceptionInformation[0] for x86_64 exceptions.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Avoid crash when trying to access page prot of address beyond address space limit.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Translate icebp instruction to EXCEPTION_SINGLE_STEP on x64.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Correctly handle privileged instructions on x86_64.", 1 },';
		printf '%s\n' '+    { "Andrew Wesie", "ntdll: Handle interrupt 0x2c on x86_64.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-User_Shared_Data
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Attach_Process_DLLs, ntdll-ThreadTime, ntdll-Hide_Wine_Exports, ntdll-x86_64_ExceptionInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29168] Update user shared data at realtime
# |
# | Modified files:
# |   *	dlls/kernel32/cpu.c, dlls/ntdll/loader.c, dlls/ntdll/ntdll.spec, dlls/ntdll/ntdll_misc.h, dlls/ntdll/tests/time.c,
# | 	dlls/ntdll/thread.c, dlls/ntdll/virtual.c, dlls/ntoskrnl.exe/instr.c
# |
if test "$enable_ntdll_User_Shared_Data" -eq 1; then
	patch_apply ntdll-User_Shared_Data/0001-ntdll-Move-code-to-update-user-shared-data-into-a-se.patch
	patch_apply ntdll-User_Shared_Data/0002-ntoskrnl-Update-USER_SHARED_DATA-before-accessing-me.patch
	patch_apply ntdll-User_Shared_Data/0003-ntdll-Create-thread-to-update-user_shared_data-time-.patch
	patch_apply ntdll-User_Shared_Data/0004-ntdll-tests-Test-updating-TickCount-in-user_shared_d.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Move code to update user shared data into a separate function.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntoskrnl: Update USER_SHARED_DATA before accessing memory.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Create thread to update user_shared_data time values when necessary.", 1 },';
		printf '%s\n' '+    { "Andrew Wesie", "ntdll/tests: Test updating TickCount in user_shared_data.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Builtin_Prot
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Attach_Process_DLLs, ntdll-ThreadTime, ntdll-Hide_Wine_Exports, ntdll-x86_64_ExceptionInformation, ntdll-
# | 	User_Shared_Data
# |
# | Modified files:
# |   *	dlls/ntdll/virtual.c, dlls/psapi/tests/psapi_main.c
# |
if test "$enable_ntdll_Builtin_Prot" -eq 1; then
	patch_apply ntdll-Builtin_Prot/0001-ntdll-Fix-holes-in-ELF-mappings.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Fix holes in ELF mappings.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-CLI_Images
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	mscoree-CorValidateImage, ntdll-APC_Start_Process
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38661] Implement proper handling of CLI .NET images in Wine library loader
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c
# |
if test "$enable_ntdll_CLI_Images" -eq 1; then
	patch_apply ntdll-CLI_Images/0001-ntdll-Load-CLI-.NET-images-in-the-same-way-as-Window.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Load CLI/.NET images in the same way as Windows XP and above.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-CriticalSection
# |
# | Modified files:
# |   *	dlls/ntdll/critsection.c, dlls/ntdll/heap.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/threadpool.c, include/wine/port.h
# |
if test "$enable_ntdll_CriticalSection" -eq 1; then
	patch_apply ntdll-CriticalSection/0001-include-Move-interlocked_inc-dec-to-port.h.patch
	patch_apply ntdll-CriticalSection/0002-ntdll-Add-inline-versions-of-RtlEnterCriticalSection.patch
	patch_apply ntdll-CriticalSection/0003-ntdll-Use-fast-CS-functions-for-heap-locking.patch
	patch_apply ntdll-CriticalSection/0004-ntdll-Use-fast-CS-functions-for-threadpool-locking.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "include: Move interlocked_inc/dec to port.h.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add inline versions of RtlEnterCriticalSection / RtlLeaveCriticalSections.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Use fast CS functions for heap locking.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Use fast CS functions for threadpool locking.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-DOS_Area
# |
# | Modified files:
# |   *	dlls/ntdll/virtual.c
# |
if test "$enable_ntdll_DOS_Area" -eq 1; then
	patch_apply ntdll-DOS_Area/0001-ntdll-Fix-code-to-make-DOS-area-accessible.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Fix code to make DOS area accessible.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-DOS_Attributes
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#9158] Support for DOS hidden/system file attributes
# |
# | Modified files:
# |   *	configure.ac, dlls/ntdll/directory.c, dlls/ntdll/file.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/tests/directory.c,
# | 	dlls/ntdll/tests/file.c, include/wine/port.h, libs/port/Makefile.in, libs/port/xattr.c
# |
if test "$enable_ntdll_DOS_Attributes" -eq 1; then
	patch_apply ntdll-DOS_Attributes/0001-ntdll-Implement-retrieving-DOS-attributes-in-NtQuery.patch
	patch_apply ntdll-DOS_Attributes/0002-ntdll-Implement-retrieving-DOS-attributes-in-NtQuery.patch
	patch_apply ntdll-DOS_Attributes/0003-ntdll-Implement-storing-DOS-attributes-in-NtSetInfor.patch
	patch_apply ntdll-DOS_Attributes/0004-ntdll-Implement-storing-DOS-attributes-in-NtCreateFi.patch
	patch_apply ntdll-DOS_Attributes/0005-libport-Add-support-for-Mac-OS-X-style-extended-attr.patch
	patch_apply ntdll-DOS_Attributes/0006-libport-Add-support-for-FreeBSD-style-extended-attri.patch
	patch_apply ntdll-DOS_Attributes/0007-ntdll-Perform-the-Unix-style-hidden-file-check-withi.patch
	patch_apply ntdll-DOS_Attributes/0008-ntdll-Always-store-SAMBA_XATTR_DOS_ATTRIB-when-path-.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Implement retrieving DOS attributes in NtQueryInformationFile.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Implement retrieving DOS attributes in NtQuery[Full]AttributesFile and NtQueryDirectoryFile.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Implement storing DOS attributes in NtSetInformationFile.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Implement storing DOS attributes in NtCreateFile.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "libport: Add support for Mac OS X style extended attributes.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "libport: Add support for FreeBSD style extended attributes.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Perform the Unix-style hidden file check within the unified file info grabbing routine.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Always store SAMBA_XATTR_DOS_ATTRIB when path could be interpreted as hidden.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Dealloc_Thread_Stack
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll_misc.h, dlls/ntdll/thread.c, dlls/ntdll/virtual.c
# |
if test "$enable_ntdll_Dealloc_Thread_Stack" -eq 1; then
	patch_apply ntdll-Dealloc_Thread_Stack/0001-ntdll-Do-not-allow-to-allocate-thread-stack-for-curr.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Do not allow to deallocate thread stack for current thread.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-DeviceType_Systemroot
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#36546] Return fake device type when systemroot is located on virtual disk
# |
# | Modified files:
# |   *	dlls/ntdll/file.c
# |
if test "$enable_ntdll_DeviceType_Systemroot" -eq 1; then
	patch_apply ntdll-DeviceType_Systemroot/0001-ntdll-Return-fake-device-type-when-systemroot-is-loc.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Return fake device type when systemroot is located on virtual disk.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-DllOverrides_WOW64
# |
# | Modified files:
# |   *	dlls/ntdll/loadorder.c
# |
if test "$enable_ntdll_DllOverrides_WOW64" -eq 1; then
	patch_apply ntdll-DllOverrides_WOW64/0001-ntdll-Always-use-64-bit-registry-view-on-WOW64-setup.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Always use 64-bit registry view on WOW64 setups.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Loader_Machine_Type
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38021] Check architecture before trying to load libraries
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c
# |
if test "$enable_ntdll_Loader_Machine_Type" -eq 1; then
	patch_apply ntdll-Loader_Machine_Type/0001-ntdll-Check-architecture-before-loading-module.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Check architecture before loading module.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-DllRedirects
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Attach_Process_DLLs, ntdll-DllOverrides_WOW64, ntdll-Loader_Machine_Type
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c, dlls/ntdll/loadorder.c, dlls/ntdll/ntdll_misc.h
# |
if test "$enable_ntdll_DllRedirects" -eq 1; then
	patch_apply ntdll-DllRedirects/0001-ntdll-Move-logic-to-determine-loadorder-HKCU-app-key.patch
	patch_apply ntdll-DllRedirects/0002-ntdll-Move-logic-to-read-loadorder-registry-values-i.patch
	patch_apply ntdll-DllRedirects/0003-ntdll-Move-code-to-determine-module-basename-into-se.patch
	patch_apply ntdll-DllRedirects/0004-ntdll-Implement-get_redirect-function.patch
	patch_apply ntdll-DllRedirects/0005-ntdll-Implement-loader-redirection-scheme.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Move logic to determine loadorder HKCU/app key into separate functions.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Move logic to read loadorder registry values into separate function.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Move code to determine module basename into separate function.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement get_redirect function.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement loader redirection scheme.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Exception
# |
# | Modified files:
# |   *	dlls/kernel32/debugger.c, dlls/ntdll/om.c, dlls/ntdll/tests/exception.c
# |
if test "$enable_ntdll_Exception" -eq 1; then
	patch_apply ntdll-Exception/0001-ntdll-Throw-exception-if-invalid-handle-is-passed-to.patch
	patch_apply ntdll-Exception/0002-ntdll-OutputDebugString-should-throw-the-exception-a.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Throw exception if invalid handle is passed to NtClose and debugger enabled.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: OutputDebugString should throw the exception a second time, if a debugger is attached.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FileFsFullSizeInformation
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_FileFsFullSizeInformation" -eq 1; then
	patch_apply ntdll-FileFsFullSizeInformation/0001-ntdll-Add-support-for-FileFsFullSizeInformation-clas.patch
	(
		printf '%s\n' '+    { "Jianqiu Zhang", "ntdll: Add support for FileFsFullSizeInformation class in NtQueryVolumeInformationFile.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-FileFsVolumeInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#21466] Add semi-stub for FileFsVolumeInformation information class
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_FileFsVolumeInformation" -eq 1; then
	patch_apply ntdll-FileFsVolumeInformation/0001-ntdll-Add-semi-stub-for-FileFsVolumeInformation-info.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add semi-stub for FileFsVolumeInformation information class.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Fix_Alignment
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33162] Ensure NtProtectVirtualMemory and NtCreateSection are on separate pages
# |
# | Modified files:
# |   *	dlls/ntdll/virtual.c
# |
if test "$enable_ntdll_Fix_Alignment" -eq 1; then
	patch_apply ntdll-Fix_Alignment/0001-ntdll-Move-NtProtectVirtualMemory-and-NtCreateSectio.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Move NtProtectVirtualMemory and NtCreateSection to separate pages on x86.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-LDR_MODULE
# |
# | Modified files:
# |   *	include/winternl.h
# |
if test "$enable_ntdll_LDR_MODULE" -eq 1; then
	patch_apply ntdll-LDR_MODULE/0002-include-Update-LDR_MODULE-to-more-recent-windows-ver.patch
	(
		printf '%s\n' '+    { "Michael Müller", "include: Update LDR_MODULE to more recent windows versions.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-HashLinks
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	mscoree-CorValidateImage, ntdll-APC_Start_Process, ntdll-CLI_Images, ntdll-LDR_MODULE
# |
# | Modified files:
# |   *	dlls/kernel32/tests/loader.c, dlls/ntdll/loader.c, include/winternl.h
# |
if test "$enable_ntdll_HashLinks" -eq 1; then
	patch_apply ntdll-HashLinks/0001-ntdll-Implement-HashLinks-field-in-LDR-module-data.patch
	patch_apply ntdll-HashLinks/0002-ntdll-Use-HashLinks-when-searching-for-a-dll-using-t.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement HashLinks field in LDR module data.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Use HashLinks when searching for a dll using the basename.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Heap_Improvements
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43224] Improvement for heap allocation performance
# |
# | Modified files:
# |   *	configure.ac, dlls/ntdll/heap.c
# |
if test "$enable_ntdll_Heap_Improvements" -eq 1; then
	patch_apply ntdll-Heap_Improvements/0001-ntdll-Add-helper-function-to-delete-free-blocks.patch
	patch_apply ntdll-Heap_Improvements/0002-ntdll-Improve-heap-allocation-performance.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add helper function to delete free blocks.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Improve heap allocation performance.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Interrupt-0x2e
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42647] Implement stub handler for int 0x2e
# |
# | Modified files:
# |   *	dlls/ntdll/signal_i386.c, include/wine/exception.h
# |
if test "$enable_ntdll_Interrupt_0x2e" -eq 1; then
	patch_apply ntdll-Interrupt-0x2e/0001-ntdll-Catch-windows-int-0x2e-syscall-on-i386.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Catch windows int 0x2e syscall on i386.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtQueryEaFile
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-FileNameInformation, kernel32-SetFileCompletionNotificationModes
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_NtQueryEaFile" -eq 1; then
	patch_apply ntdll-NtQueryEaFile/0001-ntdll-Improve-stub-of-NtQueryEaFile.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Improve stub of NtQueryEaFile.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Junction_Points
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-FileNameInformation, kernel32-SetFileCompletionNotificationModes, ntdll-NtQueryEaFile
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#12401] Support for Junction Points
# |
# | Modified files:
# |   *	dlls/kernel32/path.c, dlls/kernel32/volume.c, dlls/ntdll/file.c, dlls/ntdll/tests/file.c, include/Makefile.in,
# | 	include/ntifs.h
# |
if test "$enable_ntdll_Junction_Points" -eq 1; then
	patch_apply ntdll-Junction_Points/0001-ntdll-Add-support-for-junction-point-creation.patch
	patch_apply ntdll-Junction_Points/0002-ntdll-Add-support-for-reading-junction-points.patch
	patch_apply ntdll-Junction_Points/0003-ntdll-Add-support-for-deleting-junction-points.patch
	patch_apply ntdll-Junction_Points/0004-ntdll-Add-a-test-for-junction-point-advertisement.patch
	patch_apply ntdll-Junction_Points/0005-kernel32-ntdll-Add-support-for-deleting-junction-poi.patch
	patch_apply ntdll-Junction_Points/0006-kernel32-Advertise-junction-point-support.patch
	patch_apply ntdll-Junction_Points/0007-ntdll-tests-Add-test-for-deleting-junction-point-tar.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add support for junction point creation.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add support for reading junction points.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add support for deleting junction points.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll: Add a test for junction point advertisement.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "kernel32,ntdll: Add support for deleting junction points with RemoveDirectory.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "kernel32: Advertise junction point support.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ntdll/tests: Add test for deleting junction point target.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-LdrGetDllHandle
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c
# |
if test "$enable_ntdll_LdrGetDllHandle" -eq 1; then
	patch_apply ntdll-LdrGetDllHandle/0001-ntdll-Improve-speed-of-LdrGetDllHandle-when-searchin.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Improve speed of LdrGetDllHandle when searching for the basename of modules that are not loaded.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RtlQueryPackageIdentity
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/rtl.c, dlls/ntdll/tests/Makefile.in, dlls/ntdll/tests/rtl.c, include/shobjidl.idl
# |
if test "$enable_ntdll_RtlQueryPackageIdentity" -eq 1; then
	patch_apply ntdll-RtlQueryPackageIdentity/0001-ntdll-Add-stub-for-RtlQueryPackageIdentity.patch
	patch_apply ntdll-RtlQueryPackageIdentity/0002-include-Add-IApplicationActivationManager-interface-.patch
	patch_apply ntdll-RtlQueryPackageIdentity/0003-ntdll-tests-Add-basic-tests-for-RtlQueryPackageIdent.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Add stub for RtlQueryPackageIdentity.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "include: Add IApplicationActivationManager interface declaration.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll/tests: Add basic tests for RtlQueryPackageIdentity.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-LdrRegisterDllNotification
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	mscoree-CorValidateImage, ntdll-APC_Start_Process, ntdll-CLI_Images, ntdll-LDR_MODULE, ntdll-HashLinks, ntdll-
# | 	Attach_Process_DLLs, ntdll-ThreadTime, ntdll-Hide_Wine_Exports, ntdll-RtlQueryPackageIdentity
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c, dlls/ntdll/ntdll.spec, dlls/ntdll/tests/rtl.c, include/winternl.h
# |
if test "$enable_ntdll_LdrRegisterDllNotification" -eq 1; then
	patch_apply ntdll-LdrRegisterDllNotification/0001-ntdll-Implement-LdrRegisterDllNotification-and-LdrUn.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement LdrRegisterDllNotification and LdrUnregisterDllNotification.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtAccessCheck
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, dlls/ntdll/sec.c
# |
if test "$enable_ntdll_NtAccessCheck" -eq 1; then
	patch_apply ntdll-NtAccessCheck/0001-ntdll-Improve-invalid-paramater-handling-in-NtAccess.patch
	(
		printf '%s\n' '+    { "Qian Hong", "ntdll: Improve invalid paramater handling in NtAccessCheck.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtContinue
# |
# | Modified files:
# |   *	dlls/ntdll/exception.c, dlls/ntdll/ntdll.spec
# |
if test "$enable_ntdll_NtContinue" -eq 1; then
	patch_apply ntdll-NtContinue/0001-ntdll-Add-stub-for-NtContinue.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Add stub for NtContinue.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtCreateThreadEx
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/thread.c, include/winternl.h
# |
if test "$enable_ntdll_NtCreateThreadEx" -eq 1; then
	patch_apply ntdll-NtCreateThreadEx/0001-ntdll-Implement-NtCreateThreadEx.patch
	(
		printf '%s\n' '+    { "Andrew Wesie", "ntdll: Implement NtCreateThreadEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Pipe_SpecialCharacters
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#28995] Allow special characters in pipe names
# |
# | Modified files:
# |   *	dlls/kernel32/tests/pipe.c, dlls/ntdll/directory.c
# |
if test "$enable_ntdll_Pipe_SpecialCharacters" -eq 1; then
	patch_apply ntdll-Pipe_SpecialCharacters/0001-ntdll-Allow-special-characters-in-pipe-names.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Allow special characters in pipe names.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtDevicePath
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Pipe_SpecialCharacters
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37487] Resolve \\SystemRoot\\ prefix when opening files
# |
# | Modified files:
# |   *	dlls/ntdll/directory.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_NtDevicePath" -eq 1; then
	patch_apply ntdll-NtDevicePath/0001-ntdll-Implement-opening-files-through-nt-device-path.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement opening files through nt device paths.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtQuerySection
# |
# | Modified files:
# |   *	dlls/kernel32/tests/virtual.c
# |
if test "$enable_ntdll_NtQuerySection" -eq 1; then
	patch_apply ntdll-NtQuerySection/0002-kernel32-tests-Add-tests-for-NtQuerySection.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32/tests: Add tests for NtQuerySection.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtQueryVirtualMemory
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Pipe_SpecialCharacters, ntdll-NtDevicePath
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#23999] Implement MemorySectionName class in NtQueryVirtualMemory
# |
# | Modified files:
# |   *	dlls/kernel32/virtual.c, dlls/ntdll/directory.c, dlls/ntdll/loader.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/tests/info.c,
# | 	dlls/ntdll/virtual.c, dlls/psapi/tests/psapi_main.c, server/mapping.c, server/process.c, server/protocol.def
# |
if test "$enable_ntdll_NtQueryVirtualMemory" -eq 1; then
	patch_apply ntdll-NtQueryVirtualMemory/0001-server-Store-full-path-for-ntdll-kernel32-dll.patch
	patch_apply ntdll-NtQueryVirtualMemory/0002-ntdll-Split-logic-for-MemoryBasicInformation-into-a-.patch
	patch_apply ntdll-NtQueryVirtualMemory/0003-ntdll-Implement-NtQueryVirtualMemory-MemorySectionNa.patch
	patch_apply ntdll-NtQueryVirtualMemory/0004-ntdll-tests-Add-tests-for-NtQueryVirtualMemory-Memor.patch
	patch_apply ntdll-NtQueryVirtualMemory/0005-ntdll-tests-Add-test-to-ensure-section-name-is-full-.patch
	patch_apply ntdll-NtQueryVirtualMemory/0006-ntdll-Allow-to-query-section-names-from-other-proces.patch
	patch_apply ntdll-NtQueryVirtualMemory/0007-kernel32-Implement-K32GetMappedFileName.-v2.patch
	patch_apply ntdll-NtQueryVirtualMemory/0008-ntdll-Resolve-drive-symlinks-before-returning-sectio.patch
	patch_apply ntdll-NtQueryVirtualMemory/0009-ntdll-Fix-error-code-when-querying-too-large-memory-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Store full path for ntdll/kernel32 dll.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ntdll: Split logic for MemoryBasicInformation into a separate function.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ntdll: Implement NtQueryVirtualMemory(MemorySectionName).", 3 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ntdll/tests: Add tests for NtQueryVirtualMemory(MemorySectionName).", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll/tests: Add test to ensure section name is full path.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Allow to query section names from other processes.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "kernel32: Implement K32GetMappedFileName.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Resolve drive symlinks before returning section name.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Fix error code when querying too large memory address.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtSetInformationToken
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32907] Return success for TokenSessionId in NtSetInformationToken
# |
# | Modified files:
# |   *	dlls/ntdll/nt.c
# |
if test "$enable_ntdll_NtSetInformationToken" -eq 1; then
	patch_apply ntdll-NtSetInformationToken/0001-ntdll-Return-success-for-TokenSessionId-in-NtSetInfo.patch
	patch_apply ntdll-NtSetInformationToken/0002-ntdll-TokenIntegrityLevel-stub-in-NtSetInformationTo.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Return success for TokenSessionId in NtSetInformationToken.", 1 },';
		printf '%s\n' '+    { "Andrew Wesie", "ntdll: TokenIntegrityLevel stub in NtSetInformationToken.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtSetLdtEntries
# |
# | Modified files:
# |   *	dlls/kernel32/tests/thread.c, dlls/ntdll/nt.c, libs/wine/ldt.c
# |
if test "$enable_ntdll_NtSetLdtEntries" -eq 1; then
	patch_apply ntdll-NtSetLdtEntries/0001-ntdll-Implement-NtSetLdtEntries.patch
	patch_apply ntdll-NtSetLdtEntries/0002-libs-wine-Allow-to-modify-reserved-LDT-entries.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "ntdll: Implement NtSetLdtEntries.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "libs/wine: Allow to modify reserved LDT entries.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtSuspendProcess
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	kernel32-K32GetPerformanceInfo
# |
# | Modified files:
# |   *	dlls/ntdll/process.c, dlls/ntdll/tests/Makefile.in, dlls/ntdll/tests/process.c, server/protocol.def, server/thread.c
# |
if test "$enable_ntdll_NtSuspendProcess" -eq 1; then
	patch_apply ntdll-NtSuspendProcess/0001-ntdll-Implement-NtSuspendProcess-and-NtResumeProcess.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement NtSuspendProcess and NtResumeProcess.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-NtUnmapViewOfSection
# |
# | Modified files:
# |   *	dlls/ntdll/virtual.c
# |
if test "$enable_ntdll_NtUnmapViewOfSection" -eq 1; then
	patch_apply ntdll-NtUnmapViewOfSection/0001-ntdll-Don-t-fail-in-NtUnmapViewOfSection-when-trying.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Don'\''t fail in NtUnmapViewOfSection when trying to unmap builtin view.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ProcessImageFileNameWin32
# |
# | Modified files:
# |   *	dlls/kernel32/tests/process.c, dlls/ntdll/process.c, include/winternl.h
# |
if test "$enable_ntdll_ProcessImageFileNameWin32" -eq 1; then
	patch_apply ntdll-ProcessImageFileNameWin32/0001-ntdll-Implement-ProcessImageFileNameWin32-in-NtQuery.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement ProcessImageFileNameWin32 in NtQueryInformationProcess.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ProcessPriorityClass
# |
# | Modified files:
# |   *	dlls/ntdll/process.c, dlls/ntdll/tests/info.c
# |
if test "$enable_ntdll_ProcessPriorityClass" -eq 1; then
	patch_apply ntdll-ProcessPriorityClass/0001-ntdll-Implement-ProcessPriorityClass-in-NtQueryInfor.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement ProcessPriorityClass in NtQueryInformationProcess.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-ProcessQuotaLimits
# |
# | Modified files:
# |   *	dlls/ntdll/process.c
# |
if test "$enable_ntdll_ProcessQuotaLimits" -eq 1; then
	patch_apply ntdll-ProcessQuotaLimits/0001-ntdll-Add-fake-data-implementation-for-ProcessQuotaL.patch
	(
		printf '%s\n' '+    { "Qian Hong", "ntdll: Add fake data implementation for ProcessQuotaLimits class.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Purist_Mode
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Attach_Process_DLLs, ntdll-DllOverrides_WOW64, ntdll-Loader_Machine_Type, ntdll-DllRedirects
# |
# | Modified files:
# |   *	dlls/ntdll/loadorder.c
# |
if test "$enable_ntdll_Purist_Mode" -eq 1; then
	patch_apply ntdll-Purist_Mode/0001-ntdll-Add-dll-override-default-rule-for-purist-mode.patch
	(
		printf '%s\n' '+    { "Christian Costa", "ntdll: Add dll override default rule for purist mode.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RtlCaptureStackBackTrace
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40868] Silence FIXME in RtlCaptureStackBackTrace stub function
# |
# | Modified files:
# |   *	dlls/ntdll/signal_x86_64.c
# |
if test "$enable_ntdll_RtlCaptureStackBackTrace" -eq 1; then
	patch_apply ntdll-RtlCaptureStackBackTrace/0001-ntdll-Silence-FIXME-in-RtlCaptureStackBackTrace-stub.patch
	(
		printf '%s\n' '+    { "Jarkko Korpi", "ntdll: Silence FIXME in RtlCaptureStackBackTrace stub function.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RtlGetUnloadEventTraceEx
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-RtlQueryPackageIdentity
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/rtl.c
# |
if test "$enable_ntdll_RtlGetUnloadEventTraceEx" -eq 1; then
	patch_apply ntdll-RtlGetUnloadEventTraceEx/0001-ntdll-Add-stub-for-RtlGetUnloadEventTraceEx.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Add stub for RtlGetUnloadEventTraceEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RtlIpStringToAddress_Stubs
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/rtl.c, dlls/ntoskrnl.exe/ntoskrnl.exe.spec
# |
if test "$enable_ntdll_RtlIpStringToAddress_Stubs" -eq 1; then
	patch_apply ntdll-RtlIpStringToAddress_Stubs/0002-ntdll-Add-stub-for-RtlIpv6StringToAddressExW.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Add stub for RtlIpv6StringToAddressExW.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-RtlIpStringToAddress_Tests
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-RtlQueryPackageIdentity
# |
# | Modified files:
# |   *	dlls/ntdll/tests/rtl.c
# |
if test "$enable_ntdll_RtlIpStringToAddress_Tests" -eq 1; then
	patch_apply ntdll-RtlIpStringToAddress_Tests/0001-ntdll-tests-Tests-for-RtlIpv6StringToAddress-try-6.patch
	patch_apply ntdll-RtlIpStringToAddress_Tests/0002-ntdll-tests-Tests-for-RtlIpv6StringToAddressEx-try-6.patch
	patch_apply ntdll-RtlIpStringToAddress_Tests/0003-ntdll-tests-Tests-for-RtlIpv4StringToAddressEx-try-5.patch
	patch_apply ntdll-RtlIpStringToAddress_Tests/0004-ntdll-tests-Add-tests-for-RtlIpv6AddressToString-and.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "ntdll/tests: Tests for RtlIpv6StringToAddress.", 6 },';
		printf '%s\n' '+    { "Mark Jansen", "ntdll/tests: Tests for RtlIpv6StringToAddressEx.", 6 },';
		printf '%s\n' '+    { "Mark Jansen", "ntdll/tests: Tests for RtlIpv4StringToAddressEx (try 5, resend).", 1 },';
		printf '%s\n' '+    { "Mark Jansen", "ntdll/tests: Add tests for RtlIpv6AddressToString and RtlIpv6AddressToStringEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Serial_Port_Detection
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39793] Do a device check before returning a default serial port name
# |
# | Modified files:
# |   *	dlls/mountmgr.sys/device.c
# |
if test "$enable_ntdll_Serial_Port_Detection" -eq 1; then
	patch_apply ntdll-Serial_Port_Detection/0001-ntdll-Do-a-device-check-before-returning-a-default-s.patch
	(
		printf '%s\n' '+    { "Alex Henrie", "mountmgr.sys: Do a device check before returning a default serial port name.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-WRITECOPY
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Attach_Process_DLLs, ntdll-ThreadTime, ntdll-Hide_Wine_Exports, ntdll-x86_64_ExceptionInformation, ntdll-
# | 	User_Shared_Data
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29384] Voobly expects correct handling of WRITECOPY memory protection
# |   *	[#35561] MSYS2 expects correct handling of WRITECOPY memory protection
# |
# | Modified files:
# |   *	dlls/advapi32/crypt.c, dlls/advapi32/tests/security.c, dlls/ntdll/ntdll_misc.h, dlls/ntdll/server.c,
# | 	dlls/ntdll/signal_arm.c, dlls/ntdll/signal_arm64.c, dlls/ntdll/signal_i386.c, dlls/ntdll/signal_powerpc.c,
# | 	dlls/ntdll/signal_x86_64.c, dlls/ntdll/thread.c, dlls/ntdll/virtual.c
# |
if test "$enable_ntdll_WRITECOPY" -eq 1; then
	patch_apply ntdll-WRITECOPY/0001-ntdll-Trigger-write-watches-before-passing-userdata-.patch
	patch_apply ntdll-WRITECOPY/0002-advapi-Trigger-write-watches-before-passing-userdata.patch
	patch_apply ntdll-WRITECOPY/0003-ntdll-Setup-a-temporary-signal-handler-during-proces.patch
	patch_apply ntdll-WRITECOPY/0004-ntdll-Properly-handle-PAGE_WRITECOPY-protection.-try.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Trigger write watches before passing userdata pointer to wait_reply.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "advapi: Trigger write watches before passing userdata pointer to read syscall.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Setup a temporary signal handler during process startup to handle page faults.", 2 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Properly handle PAGE_WRITECOPY protection.", 5 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Signal_Handler
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Attach_Process_DLLs, ntdll-ThreadTime, ntdll-Hide_Wine_Exports, ntdll-x86_64_ExceptionInformation, ntdll-
# | 	User_Shared_Data, ntdll-WRITECOPY
# |
# | Modified files:
# |   *	dlls/ntdll/signal_i386.c
# |
if test "$enable_ntdll_Signal_Handler" -eq 1; then
	patch_apply ntdll-Signal_Handler/0001-ntdll-Avoid-stack-protector-frame-in-signal-handler-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Avoid stack protector frame in signal handler functions.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Stack_Guard_Page
# |
# | Modified files:
# |   *	dlls/ntdll/signal_i386.c, dlls/ntdll/signal_x86_64.c
# |
if test "$enable_ntdll_Stack_Guard_Page" -eq 1; then
	patch_apply ntdll-Stack_Guard_Page/0001-ntdll-Fix-a-bug-when-exception-handling-triggers-sta.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Fix a bug when exception handling triggers stack guard page.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Stack_Overflow
# |
# | Modified files:
# |   *	dlls/ntdll/signal_x86_64.c
# |
if test "$enable_ntdll_Stack_Overflow" -eq 1; then
	patch_apply ntdll-Stack_Overflow/0001-ntdll-Trigger-stack-overflow-exception-earlier-on-x8.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Trigger stack overflow exception earlier on x86_64.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Status_Mapping
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, dlls/ntdll/tests/file.c
# |
if test "$enable_ntdll_Status_Mapping" -eq 1; then
	patch_apply ntdll-Status_Mapping/0001-ntdll-Return-STATUS_INVALID_DEVICE_REQUEST-when-tryi.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Return STATUS_INVALID_DEVICE_REQUEST when trying to call NtReadFile on directory.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-SystemInterruptInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39123] Return buffer filled with random values from SystemInterruptInformation
# |
# | Modified files:
# |   *	dlls/ntdll/nt.c
# |
if test "$enable_ntdll_SystemInterruptInformation" -eq 1; then
	patch_apply ntdll-SystemInterruptInformation/0001-ntdll-Return-buffer-filled-with-random-values-from-S.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Return buffer filled with random values from SystemInterruptInformation.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-SystemRecommendedSharedDataAlignment
# |
# | Modified files:
# |   *	include/winternl.h
# |
if test "$enable_ntdll_SystemRecommendedSharedDataAlignment" -eq 1; then
	patch_apply ntdll-SystemRecommendedSharedDataAlignment/0001-include-Add-more-constants-to-SYSTEM_INFORMATION_CLA.patch
	(
		printf '%s\n' '+    { "Michael Müller", "include: Add more constants to SYSTEM_INFORMATION_CLASS.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-SystemRoot_Symlink
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Exception
# |
# | Modified files:
# |   *	dlls/ntdll/om.c
# |
if test "$enable_ntdll_SystemRoot_Symlink" -eq 1; then
	patch_apply ntdll-SystemRoot_Symlink/0001-ntdll-Add-special-handling-for-SystemRoot-to-satisfy.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add special handling for \\SystemRoot to satisfy MSYS2 case-insensitive system check.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Threading
# |
# | Modified files:
# |   *	dlls/ntdll/thread.c
# |
if test "$enable_ntdll_Threading" -eq 1; then
	patch_apply ntdll-Threading/0001-ntdll-Fix-race-condition-when-threads-are-killed-dur.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Fix race-condition when threads are killed during shutdown.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Wait_User_APC
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#14697] Do not allow interruption of system APC in server_select
# |
# | Modified files:
# |   *	dlls/kernel32/tests/sync.c, dlls/ntdll/server.c
# |
if test "$enable_ntdll_Wait_User_APC" -eq 1; then
	patch_apply ntdll-Wait_User_APC/0001-ntdll-Block-signals-while-executing-system-APCs.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Block signals while executing system APCs.", 2 },';
	) >> "$patchlist"
fi

# Patchset ntdll-Zero_mod_name
# |
# | Modified files:
# |   *	dlls/ntdll/loader.c
# |
if test "$enable_ntdll_Zero_mod_name" -eq 1; then
	patch_apply ntdll-Zero_mod_name/0001-ntdll-Initialize-mod_name-to-zero.patch
	(
		printf '%s\n' '+    { "Qian Hong", "ntdll: Initialize mod_name to zero.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-_aulldvrm
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42267] Implement ntdll._aulldvrm
# |
# | Modified files:
# |   *	dlls/ntdll/large_int.c, dlls/ntdll/ntdll.spec, dlls/ntdll/tests/large_int.c, dlls/ntoskrnl.exe/ntoskrnl.exe.spec
# |
if test "$enable_ntdll__aulldvrm" -eq 1; then
	patch_apply ntdll-_aulldvrm/0001-ntdll-Implement-_alldvrm-_aulldvrm-and-add-tests.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Implement _alldvrm/_aulldvrm and add tests.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-call_thread_func_wrapper
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40068] Reserve some more stack space in call_thread_func_wrapper
# |
# | Modified files:
# |   *	dlls/ntdll/signal_i386.c
# |
if test "$enable_ntdll_call_thread_func_wrapper" -eq 1; then
	patch_apply ntdll-call_thread_func_wrapper/0001-ntdll-Reserve-some-more-stack-space-in-call_thread_f.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "ntdll: Reserve some more stack space in call_thread_func_wrapper.", 1 },';
	) >> "$patchlist"
fi

# Patchset ntdll-set_full_cpu_context
# |
# | Modified files:
# |   *	dlls/ntdll/signal_i386.c
# |
if test "$enable_ntdll_set_full_cpu_context" -eq 1; then
	patch_apply ntdll-set_full_cpu_context/0001-ntdll-Add-back-SS-segment-prefixes-in-set_full_cpu_c.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Add back SS segment prefixes in set_full_cpu_context.", 1 },';
	) >> "$patchlist"
fi

# Patchset nvcuda-CUDA_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37664] MediaCoder needs CUDA for video encoding
# |
# | Modified files:
# |   *	configure.ac, dlls/nvcuda/Makefile.in, dlls/nvcuda/internal.c, dlls/nvcuda/nvcuda.c, dlls/nvcuda/nvcuda.h,
# | 	dlls/nvcuda/nvcuda.rc, dlls/nvcuda/nvcuda.spec, dlls/nvcuda/tests/Makefile.in, dlls/nvcuda/tests/nvcuda.c,
# | 	include/Makefile.in, include/cuda.h
# |
if test "$enable_nvcuda_CUDA_Support" -eq 1; then
	patch_apply nvcuda-CUDA_Support/0001-include-Add-cuda.h.h.patch
	patch_apply nvcuda-CUDA_Support/0002-nvcuda-Add-stub-dll.patch
	patch_apply nvcuda-CUDA_Support/0003-nvcuda-First-implementation.patch
	patch_apply nvcuda-CUDA_Support/0004-nvcuda-Implement-new-functions-added-in-CUDA-6.5.patch
	patch_apply nvcuda-CUDA_Support/0005-nvcuda-Properly-wrap-undocumented-ContextStorage-int.patch
	patch_apply nvcuda-CUDA_Support/0006-nvcuda-Emulate-two-d3d9-initialization-functions.patch
	patch_apply nvcuda-CUDA_Support/0007-nvcuda-Properly-wrap-stream-callbacks-by-forwarding-.patch
	patch_apply nvcuda-CUDA_Support/0008-nvcuda-Add-support-for-CUDA-7.0.patch
	patch_apply nvcuda-CUDA_Support/0009-nvcuda-Implement-cuModuleLoad-wrapper-function.patch
	patch_apply nvcuda-CUDA_Support/0010-nvcuda-Search-for-dylib-library-on-Mac-OS-X.patch
	patch_apply nvcuda-CUDA_Support/0011-nvcuda-Add-semi-stub-for-cuD3D10GetDevice.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "include: Add cuda.h.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "nvcuda: Add stub dll.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvcuda: First implementation.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "nvcuda: Implement new functions added in CUDA 6.5.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvcuda: Properly wrap undocumented '\''ContextStorage'\'' interface and add tests.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvcuda: Emulate two d3d9 initialization functions.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "nvcuda: Properly wrap stream callbacks by forwarding them to a worker thread.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "nvcuda: Add support for CUDA 7.0.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "nvcuda: Implement cuModuleLoad wrapper function.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvcuda: Search for dylib library on Mac OS X.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvcuda: Add semi stub for cuD3D10GetDevice.", 1 },';
	) >> "$patchlist"
fi

# Patchset nvapi-Stub_DLL
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	nvcuda-CUDA_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35062] Fix graphical corruption in FarCry 3 with NVIDIA drivers
# |   *	[#43862] CS:GO fails to start when nvapi cannot be initialized
# |
# | Modified files:
# |   *	configure.ac, dlls/d3d11/device.c, dlls/nvapi/Makefile.in, dlls/nvapi/nvapi.c, dlls/nvapi/nvapi.spec,
# | 	dlls/nvapi/tests/Makefile.in, dlls/nvapi/tests/nvapi.c, dlls/nvapi64/Makefile.in, dlls/nvapi64/nvapi64.spec,
# | 	include/Makefile.in, include/nvapi.h, include/wine/wined3d.h
# |
if test "$enable_nvapi_Stub_DLL" -eq 1; then
	patch_apply nvapi-Stub_DLL/0001-nvapi-First-implementation.patch
	patch_apply nvapi-Stub_DLL/0002-nvapi-Add-stubs-for-NvAPI_EnumLogicalGPUs-and-undocu.patch
	patch_apply nvapi-Stub_DLL/0003-nvapi-Add-NvAPI_GetPhysicalGPUsFromLogicalGPU.patch
	patch_apply nvapi-Stub_DLL/0004-nvapi-Add-stub-for-NvAPI_EnumPhysicalGPUs.patch
	patch_apply nvapi-Stub_DLL/0005-nvapi-Add-stubs-for-NvAPI_GPU_GetFullName.patch
	patch_apply nvapi-Stub_DLL/0006-nvapi-Explicity-return-NULL-for-0x33c7358c-and-0x593.patch
	patch_apply nvapi-Stub_DLL/0007-nvapi-Add-stub-for-NvAPI_DISP_GetGDIPrimaryDisplayId.patch
	patch_apply nvapi-Stub_DLL/0008-nvapi-Add-stub-for-EnumNvidiaDisplayHandle.patch
	patch_apply nvapi-Stub_DLL/0009-nvapi-Add-stub-for-NvAPI_SYS_GetDriverAndBranchVersi.patch
	patch_apply nvapi-Stub_DLL/0010-nvapi-Add-stub-for-NvAPI_Unload.patch
	patch_apply nvapi-Stub_DLL/0011-nvapi-Add-stub-for-NvAPI_D3D_GetCurrentSLIState.patch
	patch_apply nvapi-Stub_DLL/0012-nvapi-tests-Use-structure-to-list-imports.patch
	patch_apply nvapi-Stub_DLL/0013-nvapi-Add-stub-for-NvAPI_GetLogicalGPUFromDisplay.patch
	patch_apply nvapi-Stub_DLL/0014-nvapi-Add-stub-for-NvAPI_D3D_GetObjectHandleForResou.patch
	patch_apply nvapi-Stub_DLL/0015-nvapi-Add-stub-for-NvAPI_D3D9_RegisterResource.patch
	patch_apply nvapi-Stub_DLL/0016-nvapi-Improve-NvAPI_D3D_GetCurrentSLIState.patch
	patch_apply nvapi-Stub_DLL/0017-nvapi-Implement-NvAPI_GPU_Get-Physical-Virtual-Frame.patch
	patch_apply nvapi-Stub_DLL/0018-nvapi-Add-stub-for-NvAPI_GPU_GetGpuCoreCount.patch
	patch_apply nvapi-Stub_DLL/0019-nvapi-Implement-NvAPI_D3D11_SetDepthBoundsTest.patch
	patch_apply nvapi-Stub_DLL/0020-nvapi-Implement-NvAPI_D3D11_CreateDevice-and-NvAPI_D.patch
	(
		printf '%s\n' '+    { "Michael Müller", "nvapi: First implementation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stubs for NvAPI_EnumLogicalGPUs and undocumented equivalent.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add NvAPI_GetPhysicalGPUsFromLogicalGPU.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_EnumPhysicalGPUs.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stubs for NvAPI_GPU_GetFullName.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Explicity return NULL for 0x33c7358c and 0x593e8644.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_DISP_GetGDIPrimaryDisplayId.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for EnumNvidiaDisplayHandle.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_SYS_GetDriverAndBranchVersion.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_Unload.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_D3D_GetCurrentSLIState.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi/tests: Use structure to list imports.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_GetLogicalGPUFromDisplay.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_D3D_GetObjectHandleForResource.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_D3D9_RegisterResource.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Improve NvAPI_D3D_GetCurrentSLIState.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Implement NvAPI_GPU_Get{Physical,Virtual}FrameBufferSize.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Add stub for NvAPI_GPU_GetGpuCoreCount.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Implement NvAPI_D3D11_SetDepthBoundsTest.", 2 },';
		printf '%s\n' '+    { "Michael Müller", "nvapi: Implement NvAPI_D3D11_CreateDevice and NvAPI_D3D11_CreateDeviceAndSwapChain.", 1 },';
	) >> "$patchlist"
fi

# Patchset nvcuvid-CUDA_Video_Support
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	nvcuda-CUDA_Support, nvapi-Stub_DLL
# |
# | Modified files:
# |   *	configure.ac, dlls/nvcuvid/Makefile.in, dlls/nvcuvid/nvcuvid.c, dlls/nvcuvid/nvcuvid.spec, include/Makefile.in,
# | 	include/cuviddec.h, include/nvcuvid.h
# |
if test "$enable_nvcuvid_CUDA_Video_Support" -eq 1; then
	patch_apply nvcuvid-CUDA_Video_Support/0001-nvcuvid-First-implementation.patch
	(
		printf '%s\n' '+    { "Michael Müller", "nvcuvid: First implementation.", 2 },';
	) >> "$patchlist"
fi

# Patchset nvencodeapi-Video_Encoder
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	nvcuda-CUDA_Support, nvapi-Stub_DLL, nvcuvid-CUDA_Video_Support
# |
# | Modified files:
# |   *	configure.ac, dlls/nvencodeapi/Makefile.in, dlls/nvencodeapi/nvencodeapi.c, dlls/nvencodeapi/nvencodeapi.spec,
# | 	dlls/nvencodeapi64/Makefile.in, dlls/nvencodeapi64/nvencodeapi64.spec, include/Makefile.in, include/nvencodeapi.h
# |
if test "$enable_nvencodeapi_Video_Encoder" -eq 1; then
	patch_apply nvencodeapi-Video_Encoder/0001-nvencodeapi-First-implementation.patch
	patch_apply nvencodeapi-Video_Encoder/0002-nvencodeapi-Add-debian-specific-paths-to-native-libr.patch
	patch_apply nvencodeapi-Video_Encoder/0003-nvencodeapi-Add-support-for-version-6.0.patch
	(
		printf '%s\n' '+    { "Michael Müller", "nvencodeapi: First implementation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvencodeapi: Add debian specific paths to native library.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "nvencodeapi: Add support for version 6.0.", 1 },';
	) >> "$patchlist"
fi

# Patchset ole32-HGLOBALStream
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41738] Implement proper refcounting and locking for HGLOBAL based IStream
# |
# | Modified files:
# |   *	dlls/ole32/hglobalstream.c, dlls/ole32/tests/hglobalstream.c
# |
if test "$enable_ole32_HGLOBALStream" -eq 1; then
	patch_apply ole32-HGLOBALStream/0001-ole32-tests-Add-a-bunch-of-tests-for-HGLOBAL-based-I.patch
	patch_apply ole32-HGLOBALStream/0002-ole32-Add-a-check-for-hglobal-pointer-to-GetHGlobalF.patch
	patch_apply ole32-HGLOBALStream/0003-ole32-Add-a-wrapper-for-memory-block-managed-by-HGLO.patch
	patch_apply ole32-HGLOBALStream/0004-ole32-Set-DebugInfo-Spare-0-for-handle_wrapper-lock.patch
	patch_apply ole32-HGLOBALStream/0005-ole32-Allow-moving-a-being-reallocated-block-of-memo.patch
	patch_apply ole32-HGLOBALStream/0006-ole32-Improve-thread-safety-of-HGLOBALStreamImpl_Rea.patch
	patch_apply ole32-HGLOBALStream/0007-ole32-Improve-thread-safety-of-HGLOBALStreamImpl_Wri.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "ole32/tests: Add a bunch of tests for HGLOBAL based IStream::Clone.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ole32: Add a check for hglobal pointer to GetHGlobalFromStream.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ole32: Add a wrapper for memory block managed by HGLOBAL based IStream.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ole32: Set DebugInfo->Spare[0] for handle_wrapper lock.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "ole32: Allow moving a being reallocated block of memory managed by HGLOBAL based IStream.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ole32: Improve thread-safety of HGLOBALStreamImpl_Read.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ole32: Improve thread-safety of HGLOBALStreamImpl_Write.", 1 },';
	) >> "$patchlist"
fi

# Patchset ole32-STGPROP
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42046] Multiple fixes for ole32 property storage
# |
# | Modified files:
# |   *	dlls/ole32/enumx.c, dlls/ole32/enumx.h, dlls/ole32/stg_prop.c
# |
if test "$enable_ole32_STGPROP" -eq 1; then
	patch_apply ole32-STGPROP/0001-ole32-Correctly-parse-unicode-property-storage-dicti.patch
	patch_apply ole32-STGPROP/0002-ole32-Support-reading-VT_BOOL-VT_R8-and-VT_I8-into-p.patch
	patch_apply ole32-STGPROP/0003-ole32-Implement-returning-a-name-in-IEnumSTATPROPSTG.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ole32: Correctly parse unicode property storage dictionaries.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ole32: Support reading VT_BOOL, VT_R8 and VT_I8 into propery storage.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ole32: Implement returning a name in IEnumSTATPROPSTG.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-CreateTypeLib
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8780] Forward CreateTypeLib to CreateTypeLib2
# |
# | Modified files:
# |   *	dlls/oleaut32/typelib.c
# |
if test "$enable_oleaut32_CreateTypeLib" -eq 1; then
	patch_apply oleaut32-CreateTypeLib/0001-oleaut32-Implement-semi-stub-for-CreateTypeLib.patch
	(
		printf '%s\n' '+    { "Alistair Leslie-Hughes", "oleaut32: Implement semi-stub for CreateTypeLib.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-DispCallFunc
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40160] Fix calling function with instance and VARIANT return type in DispCallFunc
# |
# | Modified files:
# |   *	dlls/oleaut32/tests/typelib.c, dlls/oleaut32/typelib.c
# |
if test "$enable_oleaut32_DispCallFunc" -eq 1; then
	patch_apply oleaut32-DispCallFunc/0001-oleaut32-Fix-calling-function-with-instance-and-VARI.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Fix calling function with instance and VARIANT return type.", 2 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-ITypeInfo_fnInvoke
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41488] Accept DISP_E_PARAMNOTFOUND for missing optional param in typelib implementation
# |
# | Modified files:
# |   *	dlls/oleaut32/tests/tmarshal.c, dlls/oleaut32/typelib.c
# |
if test "$enable_oleaut32_ITypeInfo_fnInvoke" -eq 1; then
	patch_apply oleaut32-ITypeInfo_fnInvoke/0001-oleaut32-Accept-DISP_E_PARAMNOTFOUND-for-missing-opt.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Accept DISP_E_PARAMNOTFOUND for missing optional parameters in ITypeInfo::Invoke implementation.", 3 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-Load_Save_EMF
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40523] Implement support for loading and saving EMF to IPicture interface
# |
# | Modified files:
# |   *	dlls/oleaut32/olepicture.c, dlls/oleaut32/tests/olepicture.c
# |
if test "$enable_oleaut32_Load_Save_EMF" -eq 1; then
	patch_apply oleaut32-Load_Save_EMF/0001-oleaut32-tests-Add-some-tests-for-loading-and-saving.patch
	patch_apply oleaut32-Load_Save_EMF/0002-oleaut32-Add-support-for-loading-and-saving-EMF-to-I.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32/tests: Add some tests for loading and saving EMF using IPicture interface.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Add support for loading and saving EMF to IPicture interface.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-OLEPictureImpl_SaveAsFile
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	oleaut32-Load_Save_EMF
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8532] Implement a better stub for IPicture::SaveAsFile
# |
# | Modified files:
# |   *	dlls/oleaut32/olepicture.c, dlls/oleaut32/tests/olepicture.c
# |
if test "$enable_oleaut32_OLEPictureImpl_SaveAsFile" -eq 1; then
	patch_apply oleaut32-OLEPictureImpl_SaveAsFile/0002-oleaut32-Implement-a-better-stub-for-IPicture-SaveAs.patch
	patch_apply oleaut32-OLEPictureImpl_SaveAsFile/0003-oleaut32-Implement-SaveAsFile-for-PICTYPE_ENHMETAFIL.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Implement a better stub for IPicture::SaveAsFile.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "oleaut32: Implement SaveAsFile for PICTYPE_ENHMETAFILE.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-OleLoadPicture
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39474] Create DIB section in OleLoadPicture
# |
# | Modified files:
# |   *	dlls/oleaut32/olepicture.c, dlls/oleaut32/tests/olepicture.c
# |
if test "$enable_oleaut32_OleLoadPicture" -eq 1; then
	patch_apply oleaut32-OleLoadPicture/0001-oleaut32-OleLoadPicture-should-create-a-DIB-section-.patch
	patch_apply oleaut32-OleLoadPicture/0002-oleaut32-Make-OleLoadPicture-load-DIBs-using-WIC-dec.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: OleLoadPicture should create a DIB section for a being loaded bitmap.", 3 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Make OleLoadPicture load DIBs using WIC decoder.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-OleLoadPictureFile
# |
# | Modified files:
# |   *	dlls/oleaut32/olepicture.c, dlls/oleaut32/tests/olepicture.c
# |
if test "$enable_oleaut32_OleLoadPictureFile" -eq 1; then
	patch_apply oleaut32-OleLoadPictureFile/0001-oleaut32-Do-not-reimplement-OleLoadPicture-in-OleLoa.patch
	patch_apply oleaut32-OleLoadPictureFile/0002-oleaut32-Factor-out-stream-creation-from-OleLoadPict.patch
	patch_apply oleaut32-OleLoadPictureFile/0003-oleaut32-Implement-OleLoadPictureFile.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Do not reimplement OleLoadPicture in OleLoadPicturePath.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Factor out stream creation from OleLoadPicturePath.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Implement OleLoadPictureFile.", 2 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-TKIND_COCLASS
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#19016] Implement marshalling for TKIND_COCLASS
# |
# | Modified files:
# |   *	dlls/oleaut32/tests/tmarshal.c, dlls/oleaut32/tmarshal.c, dlls/oleaut32/typelib.c
# |
if test "$enable_oleaut32_TKIND_COCLASS" -eq 1; then
	patch_apply oleaut32-TKIND_COCLASS/0001-oleaut32-Pass-a-HREFTYPE-to-get_iface_guid.patch
	patch_apply oleaut32-TKIND_COCLASS/0002-oleaut32-Implement-ITypeInfo_fnInvoke-for-TKIND_COCL.patch
	patch_apply oleaut32-TKIND_COCLASS/0003-oleaut32-Handle-TKIND_COCLASS-in-proxy-stub-marshall.patch
	patch_apply oleaut32-TKIND_COCLASS/0004-oleaut32-tests-Add-a-test-for-TKIND_COCLASS-in-proxy.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "oleaut32: Pass a HREFTYPE to get_iface_guid.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "oleaut32: Implement ITypeInfo_fnInvoke for TKIND_COCLASS in arguments.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "oleaut32: Handle TKIND_COCLASS in proxy/stub marshalling.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "oleaut32/tests: Add a test for TKIND_COCLASS in proxy/stub marshalling.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-Vtable_Offset
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35268] Extend a vtable offset before calling 64-bit DispCallFunc() for a 32-bit typelib
# |
# | Modified files:
# |   *	dlls/oleaut32/typelib.c
# |
if test "$enable_oleaut32_Vtable_Offset" -eq 1; then
	patch_apply oleaut32-Vtable_Offset/0001-oleaut32-Extend-a-vtable-offset-before-calling-64-bi.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Extend a vtable offset before calling 64-bit DispCallFunc() for a 32-bit typelib.", 1 },';
	) >> "$patchlist"
fi

# Patchset oleaut32-x86_64_Marshaller
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#26768] Implement stubless proxies on x86_64
# |
# | Modified files:
# |   *	dlls/oleaut32/tmarshal.c, dlls/oleaut32/typelib.c, dlls/oleaut32/typelib.h
# |
if test "$enable_oleaut32_x86_64_Marshaller" -eq 1; then
	patch_apply oleaut32-x86_64_Marshaller/0001-oleaut32-Initial-preparation-to-make-marshalling-com.patch
	patch_apply oleaut32-x86_64_Marshaller/0002-oleaut32-Implement-TMStubImpl_Invoke-on-x86_64.patch
	patch_apply oleaut32-x86_64_Marshaller/0003-oleaut32-Implement-asm-proxys-for-x86_64.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "oleaut32: Initial preparation to make marshalling compatible with x86_64.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "oleaut32: Implement TMStubImpl_Invoke on x86_64.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "oleaut32: Implement asm proxys for x86_64.", 1 },';
	) >> "$patchlist"
fi

# Patchset opengl32-Revert_Disable_Ext
# |
# | Modified files:
# |   *	dlls/opengl32/wgl.c
# |
if test "$enable_opengl32_Revert_Disable_Ext" -eq 1; then
	patch_apply opengl32-Revert_Disable_Ext/0001-Revert-opengl32-Return-a-NULL-pointer-for-functions-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "Revert \"opengl32: Return a NULL pointer for functions requiring unsupported or disabled extensions.\".", 1 },';
	) >> "$patchlist"
fi

# Patchset opengl32-glDebugMessageCallback
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38402] Fix calling convention of glDebugMessageCallback callback function
# |
# | Modified files:
# |   *	dlls/opengl32/make_opengl, dlls/opengl32/opengl_ext.c, dlls/opengl32/tests/opengl.c, dlls/opengl32/wgl.c
# |
if test "$enable_opengl32_glDebugMessageCallback" -eq 1; then
	patch_apply opengl32-glDebugMessageCallback/0002-opengl32-Add-wrappers-for-glDebugMessageCallback-to-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "opengl32: Add wrappers for glDebugMessageCallback to handle calling convention differences.", 1 },';
	) >> "$patchlist"
fi

# Patchset opengl32-wglChoosePixelFormat
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43638] Treat invalid pixel types as PFD_TYPE_RGBA in wglChoosePixelFormat
# |
# | Modified files:
# |   *	dlls/opengl32/tests/opengl.c, dlls/opengl32/wgl.c
# |
if test "$enable_opengl32_wglChoosePixelFormat" -eq 1; then
	patch_apply opengl32-wglChoosePixelFormat/0001-opengl32-Treat-invalid-pixel-types-as-PFD_TYPE_RGBA-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "opengl32: Treat invalid pixel types as PFD_TYPE_RGBA in wglChoosePixelFormat.", 1 },';
	) >> "$patchlist"
fi

# Patchset packager-DllMain
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43472] Prefer native version of packager.dll
# |
# | Modified files:
# |   *	dlls/packager/packager_main.c
# |
if test "$enable_packager_DllMain" -eq 1; then
	patch_apply packager-DllMain/0001-packager-Prefer-native-version.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "packager: Prefer native version.", 1 },';
	) >> "$patchlist"
fi

# Patchset quartz-MediaSeeking_Positions
# |
# | Modified files:
# |   *	dlls/quartz/filtergraph.c, dlls/strmbase/pospass.c
# |
if test "$enable_quartz_MediaSeeking_Positions" -eq 1; then
	patch_apply quartz-MediaSeeking_Positions/0001-strmbase-Fix-MediaSeekingPassThru_GetPositions-retur.patch
	patch_apply quartz-MediaSeeking_Positions/0002-quartz-Include-the-stream-position-in-addition-to-th.patch
	patch_apply quartz-MediaSeeking_Positions/0003-quartz-Implement-MediaSeeking_GetCurrentPosition-on-.patch
	patch_apply quartz-MediaSeeking_Positions/0004-quartz-Implement-MediaSeeking_GetStopPosition-on-top.patch
	patch_apply quartz-MediaSeeking_Positions/0005-quartz-Remove-unused-cache-of-MediaSeeking-stop-posi.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "strmbase: Fix MediaSeekingPassThru_GetPositions return when the pins are unconnected.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "quartz: Include the stream position in addition to the reference clock offset in the time returned by MediaSeeking_GetPositions.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "quartz: Implement MediaSeeking_GetCurrentPosition on top of MediaSeeking_GetPositions.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "quartz: Implement MediaSeeking_GetStopPosition on top of MediaSeeking_GetPositions.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "quartz: Remove unused cache of MediaSeeking stop position.", 1 },';
	) >> "$patchlist"
fi

# Patchset quartz-Silence_FIXMEs
# |
# | Modified files:
# |   *	dlls/quartz/parser.c
# |
if test "$enable_quartz_Silence_FIXMEs" -eq 1; then
	patch_apply quartz-Silence_FIXMEs/0001-quartz-Don-t-print-FIXME-for-IAMFilterMiscFlags-in-p.patch
	(
		printf '%s\n' '+    { "Christian Costa", "quartz: Don'\''t print FIXME for IAMFilterMiscFlags in parsers.", 1 },';
	) >> "$patchlist"
fi

# Patchset rasapi32-RasGetConnectionStatistics
# |
# | Modified files:
# |   *	dlls/rasapi32/rasapi.c, dlls/rasapi32/rasapi32.spec, include/raserror.h
# |
if test "$enable_rasapi32_RasGetConnectionStatistics" -eq 1; then
	patch_apply rasapi32-RasGetConnectionStatistics/0001-rasapi32-Add-stub-for-RasGetConnectionStatistics.patch
	(
		printf '%s\n' '+    { "Stanislav Motylkov", "rasapi32: Add stub for RasGetConnectionStatistics.", 1 },';
	) >> "$patchlist"
fi

# Patchset riched20-Class_Tests
# |
# | Modified files:
# |   *	dlls/riched20/tests/editor.c
# |
if test "$enable_riched20_Class_Tests" -eq 1; then
	patch_apply riched20-Class_Tests/0001-riched20-tests-Add-a-test-to-see-what-richedit-class.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "riched20/tests: Add a test to see what richedit class flavours should be available.", 1 },';
	) >> "$patchlist"
fi

# Patchset riched20-IText_Interface
# |
# | Modified files:
# |   *	dlls/riched20/richole.c, dlls/riched20/run.c, dlls/riched20/tests/richole.c
# |
if test "$enable_riched20_IText_Interface" -eq 1; then
	patch_apply riched20-IText_Interface/0001-riched20-Implement-IText-Selection-Range-Set-Start-E.patch
	patch_apply riched20-IText_Interface/0002-riched20-Stub-for-ITextFont-interface-and-implement-.patch
	patch_apply riched20-IText_Interface/0003-riched20-Stub-for-ITextPara-interface-and-implement-.patch
	patch_apply riched20-IText_Interface/0004-riched20-Fix-ME_RunOfsFromCharOfs-when-nCharOfs-strl.patch
	patch_apply riched20-IText_Interface/0005-riched20-Implement-ITextRange-GetText.patch
	patch_apply riched20-IText_Interface/0006-riched20-Implement-ITextRange-SetRange.patch
	patch_apply riched20-IText_Interface/0007-riched20-Implement-ITextRange-IsEqual.patch
	patch_apply riched20-IText_Interface/0008-riched20-Implement-ITextRange-GetStoryLength.patch
	patch_apply riched20-IText_Interface/0009-riched20-Implement-ITextSelection-GetStoryLength.patch
	patch_apply riched20-IText_Interface/0010-riched20-Silence-repeated-FIXMEs-triggered-by-Adobe-.patch
	(
		printf '%s\n' '+    { "Jactry Zeng", "riched20: Implement IText{Selection, Range}::Set{Start, End}.", 1 },';
		printf '%s\n' '+    { "Jactry Zeng", "riched20: Stub for ITextFont interface and implement ITextRange::GetFont and ITextSelection::GetFont.", 1 },';
		printf '%s\n' '+    { "Jactry Zeng", "riched20: Stub for ITextPara interface and implement ITextRange::GetPara.", 1 },';
		printf '%s\n' '+    { "Jactry Zeng", "riched20: Fix ME_RunOfsFromCharOfs() when nCharOfs > strlen().", 1 },';
		printf '%s\n' '+    { "Jactry Zeng", "riched20: Implement ITextRange::GetText.", 1 },';
		printf '%s\n' '+    { "Jactry Zeng", "riched20: Implement ITextRange::SetRange.", 1 },';
		printf '%s\n' '+    { "Jactry Zeng", "riched20: Implement ITextRange::IsEqual.", 1 },';
		printf '%s\n' '+    { "Jactry Zeng", "riched20: Implement ITextRange::GetStoryLength.", 1 },';
		printf '%s\n' '+    { "Jactry Zeng", "riched20: Implement ITextSelection::GetStoryLength.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "riched20: Silence repeated FIXMEs triggered by Adobe Reader.", 1 },';
	) >> "$patchlist"
fi

# Patchset rpcrt4-Race_Condition
# |
# | Modified files:
# |   *	dlls/rpcrt4/rpc_server.c
# |
if test "$enable_rpcrt4_Race_Condition" -eq 1; then
	patch_apply rpcrt4-Race_Condition/0001-rpcrt4-Hold-CS-while-iterating-through-protseqs-list.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "rpcrt4: Hold CS while iterating through protseqs list.", 1 },';
	) >> "$patchlist"
fi

# Patchset secur32-Zero_Buffer_Length
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40271] Set buffer size to zero when InitializeSecurityContextW returns no data
# |
# | Modified files:
# |   *	dlls/secur32/schannel.c, dlls/secur32/tests/schannel.c
# |
if test "$enable_secur32_Zero_Buffer_Length" -eq 1; then
	patch_apply secur32-Zero_Buffer_Length/0001-secur32-Set-output-buffer-size-to-zero-during-handsh.patch
	(
		printf '%s\n' '+    { "Michael Müller", "secur32: Set output buffer size to zero during handshake when no data needs to be sent.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-ClipCursor
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38791] Fix handling of cursor position clipping
# |
# | Modified files:
# |   *	dlls/user32/tests/input.c, server/queue.c
# |
if test "$enable_server_ClipCursor" -eq 1; then
	patch_apply server-ClipCursor/0001-server-Fix-handling-of-cursor-position-clipping.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Improve handling of cursor position clipping for empty rectangle.", 2 },';
	) >> "$patchlist"
fi

# Patchset server-Desktop_Refcount
# |
# | Modified files:
# |   *	dlls/user32/tests/winstation.c, dlls/user32/winstation.c, include/winuser.h, programs/explorer/desktop.c,
# | 	server/async.c, server/atom.c, server/change.c, server/clipboard.c, server/completion.c, server/console.c,
# | 	server/debugger.c, server/device.c, server/directory.c, server/event.c, server/fd.c, server/file.c, server/handle.c,
# | 	server/handle.h, server/hook.c, server/mailslot.c, server/mapping.c, server/mutex.c, server/named_pipe.c,
# | 	server/object.c, server/object.h, server/process.c, server/queue.c, server/registry.c, server/request.c,
# | 	server/semaphore.c, server/serial.c, server/signal.c, server/snapshot.c, server/sock.c, server/symlink.c,
# | 	server/thread.c, server/timer.c, server/token.c, server/winstation.c
# |
if test "$enable_server_Desktop_Refcount" -eq 1; then
	patch_apply server-Desktop_Refcount/0001-server-Introduce-a-new-alloc_handle-object-callback..patch
	patch_apply server-Desktop_Refcount/0002-server-Track-desktop-handle-count-more-correctly.patch
	patch_apply server-Desktop_Refcount/0003-user32-Implement-CWF_CREATE_ONLY-flag-for-CreateWind.patch
	patch_apply server-Desktop_Refcount/0004-server-Assign-random-name-when-no-name-was-passed-to.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Introduce a new alloc_handle object callback.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Track desktop handle count more correctly.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Implement CWF_CREATE_ONLY flag for CreateWindowStation.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Assign random name when no name was passed to create_winstation.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-FileEndOfFileInformation
# |
# | Modified files:
# |   *	dlls/ntdll/file.c, server/fd.c, server/protocol.def
# |
if test "$enable_server_FileEndOfFileInformation" -eq 1; then
	patch_apply server-FileEndOfFileInformation/0001-ntdll-Set-EOF-on-file-which-has-a-memory-mapping-sho.patch
	patch_apply server-FileEndOfFileInformation/0002-server-Growing-files-which-are-mapped-to-memory-shou.patch
	(
		printf '%s\n' '+    { "Qian Hong", "ntdll: Set EOF on file which has a memory mapping should fail.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Growing files which are mapped to memory should still work.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Stored_ACLs
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-DOS_Attributes, server-File_Permissions
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33576] Support for stored file ACLs
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, include/wine/port.h, server/change.c, server/file.c, server/file.h, server/object.c,
# | 	server/object.h
# |
if test "$enable_server_Stored_ACLs" -eq 1; then
	patch_apply server-Stored_ACLs/0001-server-Unify-the-storage-of-security-attributes-for-.patch
	patch_apply server-Stored_ACLs/0002-server-Unify-the-retrieval-of-security-attributes-fo.patch
	patch_apply server-Stored_ACLs/0003-server-Add-a-helper-function-set_sd_from_token_inter.patch
	patch_apply server-Stored_ACLs/0004-server-Temporarily-store-the-full-security-descripto.patch
	patch_apply server-Stored_ACLs/0005-server-Store-file-security-attributes-with-extended-.patch
	patch_apply server-Stored_ACLs/0006-server-Convert-return-of-file-security-masks-with-ge.patch
	patch_apply server-Stored_ACLs/0007-server-Retrieve-file-security-attributes-with-extend.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "server: Unify the storage of security attributes for files and directories.", 7 },';
		printf '%s\n' '+    { "Erich E. Hoover", "server: Unify the retrieval of security attributes for files and directories.", 7 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Add a helper function set_sd_from_token_internal to merge two security descriptors.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Temporarily store the full security descriptor for file objects.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "server: Store file security attributes with extended file attributes.", 8 },';
		printf '%s\n' '+    { "Erich E. Hoover", "server: Convert return of file security masks with generic access mappings.", 7 },';
		printf '%s\n' '+    { "Erich E. Hoover", "server: Retrieve file security attributes with extended file attributes.", 7 },';
	) >> "$patchlist"
fi

# Patchset server-Inherited_ACLs
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-DOS_Attributes, server-File_Permissions, server-Stored_ACLs
# |
# | Modified files:
# |   *	dlls/advapi32/tests/security.c, server/file.c
# |
if test "$enable_server_Inherited_ACLs" -eq 1; then
	patch_apply server-Inherited_ACLs/0001-server-Inherit-security-attributes-from-parent-direc.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "server: Inherit security attributes from parent directories on creation.", 7 },';
	) >> "$patchlist"
fi

# Patchset server-Key_State
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#31899] Implement locking and synchronization of key states
# |   *	[#35907] Fix caps lock state issues with multiple processes
# |
# | Modified files:
# |   *	server/queue.c
# |
if test "$enable_server_Key_State" -eq 1; then
	patch_apply server-Key_State/0001-server-Introduce-a-helper-function-to-update-the-thr.patch
	patch_apply server-Key_State/0002-server-Implement-locking-and-synchronization-of-keys.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Introduce a helper function to update the thread_input key state.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Implement locking and synchronization of keystate buffer.", 3 },';
	) >> "$patchlist"
fi

# Patchset server-Map_EXDEV_Error
# |
# | Modified files:
# |   *	server/file.c
# |
if test "$enable_server_Map_EXDEV_Error" -eq 1; then
	patch_apply server-Map_EXDEV_Error/0001-server-Map-EXDEV-to-STATUS_NOT_SAME_DEVICE.patch
	(
		printf '%s\n' '+    { "Qian Hong", "server: Map EXDEV to STATUS_NOT_SAME_DEVICE.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-PeekMessage
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#28884] GetMessage should remove already seen messages with higher priority
# |
# | Modified files:
# |   *	dlls/user32/tests/msg.c, server/queue.c
# |
if test "$enable_server_PeekMessage" -eq 1; then
	patch_apply server-PeekMessage/0001-server-Fix-handling-of-GetMessage-after-previous-Pee.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Fix handling of GetMessage after previous PeekMessage call.", 3 },';
	) >> "$patchlist"
fi

# Patchset server-Signal_Thread
# |
# | Modified files:
# |   *	server/thread.c, server/thread.h
# |
if test "$enable_server_Signal_Thread" -eq 1; then
	patch_apply server-Signal_Thread/0001-server-Do-not-signal-thread-until-it-is-really-gone.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Do not signal thread until it is really gone.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Shared_Memory
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Threading, server-ClipCursor, server-Key_State, server-PeekMessage, server-Signal_Thread
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll_misc.h, dlls/ntdll/server.c, dlls/ntdll/thread.c, dlls/ntdll/virtual.c, dlls/user32/focus.c,
# | 	dlls/user32/input.c, dlls/user32/message.c, dlls/user32/user_private.h, include/wine/server.h, include/winternl.h,
# | 	server/fd.c, server/file.h, server/main.c, server/mapping.c, server/protocol.def, server/queue.c, server/thread.c,
# | 	server/thread.h
# |
if test "$enable_server_Shared_Memory" -eq 1; then
	patch_apply server-Shared_Memory/0001-ntdll-Implement-virtual_map_shared_memory.patch
	patch_apply server-Shared_Memory/0002-server-Implement-support-for-global-and-local-shared.patch
	patch_apply server-Shared_Memory/0003-user32-Get-rid-of-wineserver-call-for-GetInputState.patch
	patch_apply server-Shared_Memory/0004-user32-Avoid-unnecessary-wineserver-calls-in-PeekMes.patch
	patch_apply server-Shared_Memory/0005-user32-Get-rid-of-wineserver-call-for-GetLastInputIn.patch
	patch_apply server-Shared_Memory/0006-ntdll-Only-enable-wineserver-shared-memory-communica.patch
	patch_apply server-Shared_Memory/0007-server-Store-a-list-of-associated-queues-for-each-th.patch
	patch_apply server-Shared_Memory/0008-user32-Get-rid-of-wineserver-call-for-GetActiveWindo.patch
	patch_apply server-Shared_Memory/0009-user32-Cache-the-result-of-GetForegroundWindow.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Implement virtual_map_shared_memory.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Implement support for global and local shared memory blocks based on memfd.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Get rid of wineserver call for GetInputState.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Avoid unnecessary wineserver calls in PeekMessage/GetMessage.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "user32: Get rid of wineserver call for GetLastInputInfo.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ntdll: Only enable wineserver shared memory communication when a special environment variable is set.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Store a list of associated queues for each thread input.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Get rid of wineserver call for GetActiveWindow, GetFocus, GetCapture.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Cache the result of GetForegroundWindow.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Object_Types
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-Misc_ACL, ntdll-Threading, server-ClipCursor, server-Key_State, server-PeekMessage, server-Signal_Thread, server-
# | 	Shared_Memory
# |
# | Modified files:
# |   *	dlls/ntdll/nt.c, dlls/ntdll/om.c, dlls/ntdll/tests/info.c, dlls/ntdll/tests/om.c, include/winternl.h,
# | 	server/completion.c, server/directory.c, server/event.c, server/file.c, server/handle.c, server/mailslot.c,
# | 	server/main.c, server/mapping.c, server/mutex.c, server/named_pipe.c, server/object.c, server/object.h,
# | 	server/process.c, server/protocol.def, server/registry.c, server/semaphore.c, server/symlink.c, server/thread.c,
# | 	server/timer.c, server/token.c, server/winstation.c
# |
if test "$enable_server_Object_Types" -eq 1; then
	patch_apply server-Object_Types/0001-ntdll-Implement-SystemExtendedHandleInformation-in-N.patch
	patch_apply server-Object_Types/0002-ntdll-Implement-ObjectTypesInformation-in-NtQueryObj.patch
	patch_apply server-Object_Types/0003-server-Register-types-during-startup.patch
	patch_apply server-Object_Types/0004-server-Rename-ObjectType-to-Type.patch
	patch_apply server-Object_Types/0005-server-Add-type-Token.patch
	patch_apply server-Object_Types/0006-server-Add-type-Process.patch
	patch_apply server-Object_Types/0007-server-Add-type-Thread.patch
	patch_apply server-Object_Types/0008-ntdll-Set-TypeIndex-for-ObjectTypeInformation-in-NtQ.patch
	patch_apply server-Object_Types/0009-ntdll-Set-object-type-for-System-Extended-HandleInfo.patch
	patch_apply server-Object_Types/0010-ntdll-Mimic-object-type-behavior-for-different-windo.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement SystemExtendedHandleInformation in NtQuerySystemInformation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement ObjectTypesInformation in NtQueryObject.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Register types during startup.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Rename ObjectType to Type.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Add type Token.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Add type Process.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "server: Add type Thread.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Set TypeIndex for ObjectTypeInformation in NtQueryObject.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Set object type for System(Extended)HandleInformation in NtQuerySystemInformation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Mimic object type behavior for different windows versions.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Pipe_ObjectName
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-Desktop_Refcount
# |
# | Modified files:
# |   *	dlls/ntdll/tests/om.c, server/named_pipe.c, server/object.c, server/object.h
# |
if test "$enable_server_Pipe_ObjectName" -eq 1; then
	patch_apply server-Pipe_ObjectName/0001-server-Store-a-reference-to-the-parent-object-for-pi.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Store a reference to the parent object for pipe servers.", 2 },';
	) >> "$patchlist"
fi

# Patchset server-Realtime_Priority
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-ThreadTime
# |
# | Modified files:
# |   *	server/Makefile.in, server/main.c, server/scheduler.c, server/thread.c, server/thread.h
# |
if test "$enable_server_Realtime_Priority" -eq 1; then
	patch_apply server-Realtime_Priority/0001-wineserver-Draft-to-implement-priority-levels-throug.patch
	(
		printf '%s\n' '+    { "Joakim Hernberg", "wineserver: Draft to implement priority levels through POSIX scheduling policies on linux.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Registry_Notifications
# |
# | Modified files:
# |   *	dlls/ntdll/tests/reg.c, server/registry.c
# |
if test "$enable_server_Registry_Notifications" -eq 1; then
	patch_apply server-Registry_Notifications/0001-server-Allow-multiple-registry-notifications-for-the.patch
	patch_apply server-Registry_Notifications/0002-server-Introduce-refcounting-for-registry-notificati.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Allow multiple registry notifications for the same key.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "server: Introduce refcounting for registry notifications.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-Timestamp_Compat
# |
# | Modified files:
# |   *	server/registry.c
# |
if test "$enable_server_Timestamp_Compat" -eq 1; then
	patch_apply server-Timestamp_Compat/0001-server-Compatibility-with-Wine-Staging-format-for-hi.patch
	(
		printf '%s\n' '+    { "Michael Müller", "server: Compatibility with Wine Staging format for high precision registry timestamps.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-device_manager_destroy
# |
# | Modified files:
# |   *	server/device.c
# |
if test "$enable_server_device_manager_destroy" -eq 1; then
	patch_apply server-device_manager_destroy/0001-server-Fix-crash-when-a-device-driver-segfaults-duri.patch
	(
		printf '%s\n' '+    { "Michael Müller", "server: Fix crash when a device driver segfaults during an open file request.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-free_async_queue
# |
# | Modified files:
# |   *	server/async.c
# |
if test "$enable_server_free_async_queue" -eq 1; then
	patch_apply server-free_async_queue/0001-server-Avoid-crash-when-async_terminate-destroys-asy.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "server: Avoid crash when async_terminate destroys async object in free_async_queue.", 1 },';
	) >> "$patchlist"
fi

# Patchset server-send_hardware_message
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43102] Improve handling of hooks for normal (non-injected) hardware messages
# |
# | Modified files:
# |   *	server/queue.c
# |
if test "$enable_server_send_hardware_message" -eq 1; then
	patch_apply server-send_hardware_message/0001-server-Improve-handling-of-hooks-for-normal-non-inje.patch
	(
		printf '%s\n' '+    { "Michael Müller", "server: Improve handling of hooks for normal (non-injected) hardware messages.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-CM_Get_Parent
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43831] Return CR_NO_SUCH_DEVNODE from CM_Get_Parent stub
# |
# | Modified files:
# |   *	dlls/setupapi/stubs.c
# |
if test "$enable_setupapi_CM_Get_Parent" -eq 1; then
	patch_apply setupapi-CM_Get_Parent/0001-setupapi-Return-CR_NO_SUCH_DEVNODE-from-CM_Get_Paren.patch
	(
		printf '%s\n' '+    { "Tim Wanders", "setupapi: Return CR_NO_SUCH_DEVNODE from CM_Get_Parent stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-DiskSpaceList
# |
# | Modified files:
# |   *	dlls/setupapi/diskspace.c, dlls/setupapi/queue.c, dlls/setupapi/setupapi.spec, dlls/setupapi/setupapi_private.h,
# | 	dlls/setupapi/stubs.c, dlls/setupapi/tests/diskspace.c, include/setupapi.h
# |
if test "$enable_setupapi_DiskSpaceList" -eq 1; then
	patch_apply setupapi-DiskSpaceList/0001-setupapi-Rewrite-DiskSpaceList-logic-using-lists.patch
	patch_apply setupapi-DiskSpaceList/0002-setupapi-Implement-SetupAddToDiskSpaceList.patch
	patch_apply setupapi-DiskSpaceList/0003-setupapi-Implement-SetupQueryDrivesInDiskSpaceList.patch
	patch_apply setupapi-DiskSpaceList/0004-setupapi-Ignore-deletion-of-added-files-in-SetupAddT.patch
	patch_apply setupapi-DiskSpaceList/0005-setupapi-ImplementSetupAddSectionToDiskSpaceList.patch
	patch_apply setupapi-DiskSpaceList/0006-setupapi-Implement-SetupAddInstallSectionToDiskSpace.patch
	(
		printf '%s\n' '+    { "Michael Müller", "setupapi: Rewrite DiskSpaceList logic using lists.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi: Implement SetupAddToDiskSpaceList.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi: Implement SetupQueryDrivesInDiskSpaceList.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi: Ignore deletion of added files in SetupAddToDiskSpaceList.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi: ImplementSetupAddSectionToDiskSpaceList.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi: Implement SetupAddInstallSectionToDiskSpaceList.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-Display_Device
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35345] Fix enumeration of display driver properties using setupapi
# |
# | Modified files:
# |   *	dlls/setupapi/devinst.c, dlls/setupapi/tests/devinst.c, loader/wine.inf.in
# |
if test "$enable_setupapi_Display_Device" -eq 1; then
	patch_apply setupapi-Display_Device/0001-setupapi-Create-registry-keys-for-display-devices-an.patch
	patch_apply setupapi-Display_Device/0002-setupapi-Handle-the-case-that-a-full-driver-path-is-.patch
	patch_apply setupapi-Display_Device/0003-setupapi-Also-create-HardwareId-registry-key-for-dis.patch
	(
		printf '%s\n' '+    { "Michael Müller", "setupapi: Create registry keys for display devices and display drivers.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi: Handle the case that a full driver path is passed to SetupDiGetClassDevs.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "setupapi: Also create HardwareId registry key for display devices.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-HSPFILEQ_Check_Type
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#12332] Check handle type for HSPFILEQ handles
# |
# | Modified files:
# |   *	dlls/setupapi/queue.c
# |
if test "$enable_setupapi_HSPFILEQ_Check_Type" -eq 1; then
	patch_apply setupapi-HSPFILEQ_Check_Type/0001-setupapi-Check-handle-type-for-HSPFILEQ-handles.patch
	(
		printf '%s\n' '+    { "Michael Müller", "setupapi: Check handle type for HSPFILEQ handles.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-SPFILENOTIFY_FILEINCABINET
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42827] Fix Param2 in SPFILENOTIFY_FILEINCABINET handler
# |
# | Modified files:
# |   *	dlls/setupapi/setupcab.c, dlls/setupapi/tests/setupcab.c
# |
if test "$enable_setupapi_SPFILENOTIFY_FILEINCABINET" -eq 1; then
	patch_apply setupapi-SPFILENOTIFY_FILEINCABINET/0001-setupapi-tests-Add-more-tests-for-SPFILENOTIFY_FILEI.patch
	patch_apply setupapi-SPFILENOTIFY_FILEINCABINET/0002-setupapi-Fix-CabinetName-passed-to-SPFILENOTIFY_CABI.patch
	patch_apply setupapi-SPFILENOTIFY_FILEINCABINET/0003-setupapi-tests-Add-tests-for-cabinet-name-passed-to-.patch
	patch_apply setupapi-SPFILENOTIFY_FILEINCABINET/0004-setupapi-Fix-parameters-of-SPFILENOTIFY_FILEINCABINE.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "setupapi/tests: Add more tests for SPFILENOTIFY_FILEINCABINET handler.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "setupapi: Fix CabinetName passed to SPFILENOTIFY_CABINETINFO handler.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "setupapi/tests: Add tests for cabinet name passed to SPFILENOTIFY_FILEEXTRACTED.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "setupapi: Fix parameters of SPFILENOTIFY_FILEINCABINET handler.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-SP_COPY_IN_USE_NEEDS_REBOOT
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#36059] Implement support for SP_COPY_IN_USE_NEEDS_REBOOT in do_file_copyW
# |
# | Modified files:
# |   *	dlls/setupapi/queue.c
# |
if test "$enable_setupapi_SP_COPY_IN_USE_NEEDS_REBOOT" -eq 1; then
	patch_apply setupapi-SP_COPY_IN_USE_NEEDS_REBOOT/0001-setupapi-Implement-SP_COPY_IN_USE_NEEDS_REBOOT.patch
	(
		printf '%s\n' '+    { "Michael Müller", "setupapi: Implement SP_COPY_IN_USE_NEEDS_REBOOT.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-SetupDiGetDeviceInterfaceDetail
# |
# | Modified files:
# |   *	dlls/setupapi/devinst.c, dlls/setupapi/setupapi.spec, dlls/setupapi/tests/devinst.c
# |
if test "$enable_setupapi_SetupDiGetDeviceInterfaceDetail" -eq 1; then
	patch_apply setupapi-SetupDiGetDeviceInterfaceDetail/0001-setupapi-Add-spec-file-stub-entry-for-SetupDiInstall.patch
	patch_apply setupapi-SetupDiGetDeviceInterfaceDetail/0002-setupapi-SetupDiGetDeviceInterfaceDetail-should-fill.patch
	(
		printf '%s\n' '+    { "Michael Müller", "setupapi: Add spec file stub entry for SetupDiInstallDeviceInterfaces and SetupDiRegisterCoDeviceInstallers.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi: SetupDiGetDeviceInterfaceDetail should fill out DeviceInfoData even if the buffer for DeviceInterfaceData is too small.", 1 },';
	) >> "$patchlist"
fi

# Patchset setupapi-SetupPromptForDisk
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#20465] Wine ignores IDF_CHECKFIRST flag in SetupPromptForDisk
# |
# | Modified files:
# |   *	dlls/setupapi/dialog.c, dlls/setupapi/tests/Makefile.in, dlls/setupapi/tests/dialog.c
# |
if test "$enable_setupapi_SetupPromptForDisk" -eq 1; then
	patch_apply setupapi-SetupPromptForDisk/0001-setupapi-Add-support-for-IDF_CHECKFIRST-flag-in-Setu.patch
	patch_apply setupapi-SetupPromptForDisk/0002-setupapi-tests-Add-test-for-IDF_CHECKFIRST-and-Setup.patch
	patch_apply setupapi-SetupPromptForDisk/0003-setupapi-tests-Determine-path-to-system32-directory-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "setupapi: Add support for IDF_CHECKFIRST flag in SetupPromptForDiskW.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "setupapi/tests: Add test for IDF_CHECKFIRST and SetupPromptForDiskA/W.", 1 },';
		printf '%s\n' '+    { "Hermes Belusca-Maito", "setupapi/tests: Determine path to system32 directory at runtime.", 1 },';
	) >> "$patchlist"
fi

# Patchset sfc-SfcGetNextProtectedFile
# |
# | Modified files:
# |   *	dlls/sfc_os/sfc_os.c
# |
if test "$enable_sfc_SfcGetNextProtectedFile" -eq 1; then
	patch_apply sfc-SfcGetNextProtectedFile/0001-sfc_os-Set-an-error-code-in-SfcGetNextProtectedFile-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "sfc_os: Set an error code in SfcGetNextProtectedFile stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset shdocvw-ParseURLFromOutsideSource_Tests
# |
# | Modified files:
# |   *	dlls/shdocvw/shdocvw_main.c, dlls/shdocvw/tests/shdocvw.c
# |
if test "$enable_shdocvw_ParseURLFromOutsideSource_Tests" -eq 1; then
	patch_apply shdocvw-ParseURLFromOutsideSource_Tests/0001-shdocvw-Check-precisely-ParseURLFromOutsideSourceX-r.patch
	(
		printf '%s\n' '+    { "Christian Costa", "shdocvw: Check precisely ParseURLFromOutsideSourceX returned values in tests and make code clearer about that.", 3 },';
	) >> "$patchlist"
fi

# Patchset shell32-File_Property_Dialog
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40426] Implement general tab for file property dialog
# |
# | Modified files:
# |   *	dlls/shell32/shell32.rc, dlls/shell32/shlview_cmenu.c, dlls/shell32/shresdef.h
# |
if test "$enable_shell32_File_Property_Dialog" -eq 1; then
	patch_apply shell32-File_Property_Dialog/0001-shell32-Add-general-tab-in-file-property-dialog.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Add general tab in file property dialog.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-SHFileOperation_Move
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#25207] SHFileOperation with FO_MOVE should create new directory on Vista+
# |
# | Modified files:
# |   *	dlls/shell32/shlfileop.c, dlls/shell32/tests/shlfileop.c
# |
if test "$enable_shell32_SHFileOperation_Move" -eq 1; then
	patch_apply shell32-SHFileOperation_Move/0001-shell32-Fix-SHFileOperation-FO_MOVE-for-creating-sub.patch
	(
		printf '%s\n' '+    { "Zhenbo Li", "shell32: Fix SHFileOperation(FO_MOVE) for creating subdirectories.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Progress_Dialog
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-File_Permissions, ntdll-FileDispositionInformation, kernel32-CopyFileEx, shell32-SHFileOperation_Move
# |
# | Modified files:
# |   *	dlls/shell32/shell32.rc, dlls/shell32/shlfileop.c, dlls/shell32/shresdef.h
# |
if test "$enable_shell32_Progress_Dialog" -eq 1; then
	patch_apply shell32-Progress_Dialog/0001-shell32-Correct-indentation-in-shfileop.c.patch
	patch_apply shell32-Progress_Dialog/0002-shell32-Pass-FILE_INFORMATION-into-SHNotify-function.patch
	patch_apply shell32-Progress_Dialog/0003-shell32-Implement-file-operation-progress-dialog.patch
	patch_apply shell32-Progress_Dialog/0004-shell32-Show-animation-during-SHFileOperation.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Correct indentation in shfileop.c.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Pass FILE_INFORMATION into SHNotify* functions.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Implement file operation progress dialog.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Show animation during SHFileOperation.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-ACE_Viewer
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	shell32-File_Property_Dialog, server-File_Permissions, ntdll-FileDispositionInformation, kernel32-CopyFileEx,
# | 	shell32-SHFileOperation_Move, shell32-Progress_Dialog
# |
# | Modified files:
# |   *	dlls/aclui/Makefile.in, dlls/aclui/aclui.rc, dlls/aclui/aclui_main.c, dlls/aclui/resource.h, dlls/aclui/user_icons.bmp,
# | 	dlls/shell32/Makefile.in, dlls/shell32/shell32.rc, dlls/shell32/shlview_cmenu.c, dlls/shell32/shresdef.h
# |
if test "$enable_shell32_ACE_Viewer" -eq 1; then
	patch_apply shell32-ACE_Viewer/0001-aclui-Add-basic-ACE-viewer.patch
	patch_apply shell32-ACE_Viewer/0002-shell32-Add-security-property-tab.patch
	(
		printf '%s\n' '+    { "Michael Müller", "aclui: Add basic ACE viewer.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Add security property tab.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Context_Menu
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34319] Add support for Paste in context menu
# |   *	[#34322] Fix implementation of Cut file operation
# |   *	[#34321] Fix Cut/Copy/Paste keyboard shortcuts in Total Commander
# |
# | Modified files:
# |   *	dlls/shell32/clipboard.c, dlls/shell32/dataobject.c, dlls/shell32/recyclebin.c, dlls/shell32/shell32.rc,
# | 	dlls/shell32/shell32_main.h, dlls/shell32/shellfolder.h, dlls/shell32/shfldr_fs.c, dlls/shell32/shfldr_unixfs.c,
# | 	dlls/shell32/shlview.c, dlls/shell32/shlview_cmenu.c
# |
if test "$enable_shell32_Context_Menu" -eq 1; then
	patch_apply shell32-Context_Menu/0001-shell32-Fix-copying-of-files-when-using-a-context-me.patch
	patch_apply shell32-Context_Menu/0002-shell32-Set-return-value-correctly-in-DoPaste.patch
	patch_apply shell32-Context_Menu/0003-shell32-Implement-insert-paste-for-item-context-menu.patch
	patch_apply shell32-Context_Menu/0005-shell32-Add-support-for-setting-getting-PREFERREDDRO.patch
	patch_apply shell32-Context_Menu/0006-shell32-Add-parameter-to-ISFHelper-DeleteItems-to-al.patch
	patch_apply shell32-Context_Menu/0007-shell32-Remove-source-files-when-using-cut-in-the-co.patch
	patch_apply shell32-Context_Menu/0008-shell32-Recognize-cut-copy-paste-string-verbs-in-ite.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Fix copying of files when using a context menu.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Set return value correctly in DoPaste.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Implement insert/paste for item context menus.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Add support for setting/getting PREFERREDDROPEFFECT in IDataObject.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Add parameter to ISFHelper::DeleteItems to allow deleting files without confirmation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Remove source files when using cut in the context menu.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Recognize cut/copy/paste string verbs in item menu context menu.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Icons
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24721] Support for extra large and jumbo icon lists in shell32
# |
# | Modified files:
# |   *	dlls/shell32/iconcache.c, dlls/shell32/shell32_main.h, dlls/shell32/shellord.c, dlls/shell32/tests/shelllink.c
# |
if test "$enable_shell32_Icons" -eq 1; then
	patch_apply shell32-Icons/0001-shell32-Add-support-for-extra-large-and-jumbo-icon-l.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Add support for extra large and jumbo icon lists.", 2 },';
	) >> "$patchlist"
fi

# Patchset shell32-Microsoft_Windows_Themes
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34910] Create Microsoft\Windows\Themes directory during Wineprefix creation
# |
# | Modified files:
# |   *	dlls/shell32/shellpath.c
# |
if test "$enable_shell32_Microsoft_Windows_Themes" -eq 1; then
	patch_apply shell32-Microsoft_Windows_Themes/0001-shell32-Create-Microsoft-Windows-Themes-directory-du.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "shell32: Create Microsoft\\Windows\\Themes directory during Wineprefix creation.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-NewMenu_Interface
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24812] Implement shell32 NewMenu class with new folder item
# |
# | Modified files:
# |   *	dlls/shell32/Makefile.in, dlls/shell32/shell32_classes.idl, dlls/shell32/shell32_main.h, dlls/shell32/shellnew.c,
# | 	dlls/shell32/shellole.c, include/shlguid.h
# |
if test "$enable_shell32_NewMenu_Interface" -eq 1; then
	patch_apply shell32-NewMenu_Interface/0001-shell32-Implement-NewMenu-with-new-folder-item.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Implement NewMenu with new folder item.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Placeholder_Icons
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30185] Add shell32 placeholder icons to match offsets with Windows
# |
# | Modified files:
# |   *	dlls/shell32/placeholder.ico, dlls/shell32/shell32.rc, dlls/shell32/shresdef.h
# |
if test "$enable_shell32_Placeholder_Icons" -eq 1; then
	patch_apply shell32-Placeholder_Icons/0001-shell32-Add-placeholder-icons-to-match-icon-offset-w.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Add placeholder icons to match icon offset with XP.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-RunDLL_CallEntry16
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#23033] Use manual relay for RunDLL_CallEntry16 in shell32
# |
# | Modified files:
# |   *	dlls/shell32/control.c, dlls/shell32/shell32.spec
# |
if test "$enable_shell32_RunDLL_CallEntry16" -eq 1; then
	patch_apply shell32-RunDLL_CallEntry16/0001-shell32-Use-manual-redirection-for-RunDLL_CallEntry1.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Use manual redirection for RunDLL_CallEntry16.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-SFGAO_HASSUBFOLDER
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24851] Only set SFGAO_HASSUBFOLDER when there are really subfolders
# |
# | Modified files:
# |   *	dlls/shell32/shfldr_unixfs.c, dlls/shell32/shlfolder.c
# |
if test "$enable_shell32_SFGAO_HASSUBFOLDER" -eq 1; then
	patch_apply shell32-SFGAO_HASSUBFOLDER/0001-shell32-Set-SFGAO_HASSUBFOLDER-correctly-for-unixfs.patch
	patch_apply shell32-SFGAO_HASSUBFOLDER/0002-shell32-Set-SFGAO_HASSUBFOLDER-correctly-for-normal-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Set SFGAO_HASSUBFOLDER correctly for unixfs.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "shell32: Set SFGAO_HASSUBFOLDER correctly for normal shellfolders.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-SHCreateSessionKey
# |
# | Modified files:
# |   *	dlls/shell32/shellreg.c, dlls/shell32/tests/shellole.c
# |
if test "$enable_shell32_SHCreateSessionKey" -eq 1; then
	patch_apply shell32-SHCreateSessionKey/0001-shell32-Implement-SHCreateSessionKey.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "shell32: Implement SHCreateSessionKey.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-SHELL_execute
# |
# | Modified files:
# |   *	dlls/shell32/shlexec.c, dlls/shell32/tests/shlexec.c
# |
if test "$enable_shell32_SHELL_execute" -eq 1; then
	patch_apply shell32-SHELL_execute/0001-shell32-Properly-fail-when-a-data-object-cannot-be-i.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "shell32: Properly fail when a data object cannot be instantiated and expand environment strings in ShellExecute.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-SHFileOperation_Win9x
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-File_Permissions, ntdll-FileDispositionInformation, kernel32-CopyFileEx, shell32-SHFileOperation_Move,
# | 	shell32-Progress_Dialog
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37916] Anno 1602 installer depends on Windows 98 behavior of SHFileOperationW
# |
# | Modified files:
# |   *	dlls/shell32/shlfileop.c
# |
if test "$enable_shell32_SHFileOperation_Win9x" -eq 1; then
	patch_apply shell32-SHFileOperation_Win9x/0001-shell32-Choose-return-value-for-SHFileOperationW-dep.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Choose return value for SHFileOperationW depending on windows version.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-Toolbar_Bitmaps
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40236] Add missing resources for IE6 buttons
# |
# | Modified files:
# |   *	dlls/shell32/Makefile.in, dlls/shell32/ietoolbar.bmp, dlls/shell32/ietoolbar.svg, dlls/shell32/ietoolbar_small.bmp,
# | 	dlls/shell32/ietoolbar_small.svg, dlls/shell32/shell32.rc
# |
if test "$enable_shell32_Toolbar_Bitmaps" -eq 1; then
	patch_apply shell32-Toolbar_Bitmaps/0001-shell32-Add-toolbar-bitmaps-compatible-with-IE6.patch
	patch_apply shell32-Toolbar_Bitmaps/0002-shell32-Add-more-Tango-icons-to-the-IE-toolbar.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "shell32: Add toolbar bitmaps compatible with IE6.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "shell32: Add more Tango icons to the IE toolbar.", 1 },';
	) >> "$patchlist"
fi

# Patchset shell32-UnixFS
# |
# | Modified files:
# |   *	dlls/shell32/shfldr_desktop.c, dlls/shell32/tests/shlfolder.c
# |
if test "$enable_shell32_UnixFS" -eq 1; then
	patch_apply shell32-UnixFS/0001-shell32-Do-not-use-unixfs-for-devices-without-mountp.patch
	(
		printf '%s\n' '+    { "Michael Müller", "shell32: Do not use unixfs for devices without mountpoint.", 1 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-AssocGetPerceivedType
# |
# | Modified files:
# |   *	dlls/shlwapi/assoc.c, dlls/shlwapi/tests/assoc.c
# |
if test "$enable_shlwapi_AssocGetPerceivedType" -eq 1; then
	patch_apply shlwapi-AssocGetPerceivedType/0001-shlwapi-tests-Add-tests-for-AssocGetPerceivedType.patch
	patch_apply shlwapi-AssocGetPerceivedType/0002-shlwapi-Implement-AssocGetPerceivedType.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "shlwapi/tests: Add tests for AssocGetPerceivedType.", 1 },';
		printf '%s\n' '+    { "Mark Jansen", "shlwapi: Implement AssocGetPerceivedType.", 2 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-PathUnExpandEnvStrings
# |
# | Modified files:
# |   *	dlls/shlwapi/path.c, dlls/shlwapi/tests/path.c
# |
if test "$enable_shlwapi_PathUnExpandEnvStrings" -eq 1; then
	patch_apply shlwapi-PathUnExpandEnvStrings/0001-shlwapi-Don-t-attempt-to-unexpand-ComputerName-in-Pa.patch
	(
		printf '%s\n' '+    { "Katayama Hirofumi MZ", "shlwapi: Don'\''t attempt to unexpand ComputerName in PathUnExpandEnvStrings.", 1 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-SHAddDataBlock
# |
# | Modified files:
# |   *	dlls/shlwapi/clist.c, dlls/shlwapi/tests/clist.c
# |
if test "$enable_shlwapi_SHAddDataBlock" -eq 1; then
	patch_apply shlwapi-SHAddDataBlock/0001-shlwapi-Fix-the-return-value-of-SHAddDataBlock.patch
	(
		printf '%s\n' '+    { "Hermès BÉLUSCA-MAÏTO", "shlwapi: Fix the return value of SHAddDataBlock.", 1 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-SHMapHandle
# |
# | Modified files:
# |   *	dlls/shlwapi/ordinal.c, dlls/shlwapi/tests/ordinal.c
# |
if test "$enable_shlwapi_SHMapHandle" -eq 1; then
	patch_apply shlwapi-SHMapHandle/0002-shlwapi-SHMapHandle-should-not-set-error-when-NULL-i.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "shlwapi: SHMapHandle should not set error when NULL is passed as hShared.", 1 },';
	) >> "$patchlist"
fi

# Patchset shlwapi-UrlCombine
# |
# | Modified files:
# |   *	dlls/shlwapi/tests/url.c, dlls/shlwapi/url.c
# |
if test "$enable_shlwapi_UrlCombine" -eq 1; then
	patch_apply shlwapi-UrlCombine/0001-shlwapi-tests-Add-additional-tests-for-UrlCombine-and-.patch
	patch_apply shlwapi-UrlCombine/0002-shlwapi-UrlCombineW-workaround-for-relative-paths.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "shlwapi/tests: Add additional tests for UrlCombine and UrlCanonicalize.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "shlwapi: UrlCombineW workaround for relative paths.", 1 },';
	) >> "$patchlist"
fi

# Patchset stdole32.idl-Typelib
# |
# | Modified files:
# |   *	dlls/stdole32.tlb/std_ole_v1.idl, include/Makefile.in, include/stdole32.idl
# |
if test "$enable_stdole32_idl_Typelib" -eq 1; then
	patch_apply stdole32.idl-Typelib/0001-include-Make-stdole32.idl-a-public-component.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "include: Make stdole32.idl a public component.", 1 },';
	) >> "$patchlist"
fi

# Patchset widl-SLTG_Typelib_Support
# |
# | Modified files:
# |   *	dlls/oleaut32/typelib.c, dlls/oleaut32/typelib.h, tools/widl/Makefile.in, tools/widl/typelib.c, tools/widl/typelib.h,
# | 	tools/widl/widl.c, tools/widl/widl.h, tools/widl/write_sltg.c
# |
if test "$enable_widl_SLTG_Typelib_Support" -eq 1; then
	patch_apply widl-SLTG_Typelib_Support/0001-widl-Add-initial-implementation-of-SLTG-typelib-gene.patch
	patch_apply widl-SLTG_Typelib_Support/0002-widl-Add-support-for-structures.patch
	patch_apply widl-SLTG_Typelib_Support/0003-widl-Properly-align-name-table-entries.patch
	patch_apply widl-SLTG_Typelib_Support/0004-widl-More-accurately-report-variable-descriptions-da.patch
	patch_apply widl-SLTG_Typelib_Support/0005-widl-Calculate-size-of-instance-for-structures.patch
	patch_apply widl-SLTG_Typelib_Support/0006-widl-Write-correct-typekind-to-the-SLTG-typeinfo-blo.patch
	patch_apply widl-SLTG_Typelib_Support/0007-widl-Write-SLTG-blocks-according-to-the-index-order.patch
	patch_apply widl-SLTG_Typelib_Support/0008-widl-Write-correct-syskind-by-SLTG-typelib-generator.patch
	patch_apply widl-SLTG_Typelib_Support/0009-widl-Add-support-for-VT_VOID-and-VT_VARIANT-to-SLTG-.patch
	patch_apply widl-SLTG_Typelib_Support/0010-widl-Add-support-for-VT_USERDEFINED-to-SLTG-typelib-.patch
	patch_apply widl-SLTG_Typelib_Support/0011-widl-Factor-out-SLTG-tail-initialization.patch
	patch_apply widl-SLTG_Typelib_Support/0012-widl-Add-support-for-recursive-type-references-to-SL.patch
	patch_apply widl-SLTG_Typelib_Support/0013-widl-Add-support-for-interfaces-to-SLTG-typelib-gene.patch
	patch_apply widl-SLTG_Typelib_Support/0014-widl-Add-support-for-inherited-interfaces-to-SLTG-ty.patch
	patch_apply widl-SLTG_Typelib_Support/0015-widl-Make-automatic-dispid-generation-scheme-better-.patch
	patch_apply widl-SLTG_Typelib_Support/0016-widl-Create-library-block-index-right-after-the-Comp.patch
	patch_apply widl-SLTG_Typelib_Support/0017-widl-Fix-generation-of-resources-containing-an-old-t.patch
	patch_apply widl-SLTG_Typelib_Support/0018-widl-Add-oldtlb-switch-in-usage-message.patch
	patch_apply widl-SLTG_Typelib_Support/0019-widl-Avoid-relying-on-side-effects-when-marking-func.patch
	patch_apply widl-SLTG_Typelib_Support/0020-widl-Set-the-lowest-bit-in-the-param-name-to-indicat.patch
	patch_apply widl-SLTG_Typelib_Support/0021-oleaut32-Fix-logic-for-deciding-whether-type-descrip.patch
	patch_apply widl-SLTG_Typelib_Support/0022-widl-Add-support-for-function-parameter-flags-to-SLT.patch
	patch_apply widl-SLTG_Typelib_Support/0023-oleaut32-Implement-decoding-of-SLTG-help-strings.patch
	patch_apply widl-SLTG_Typelib_Support/0024-oleaut32-Add-support-for-decoding-SLTG-function-help.patch
	patch_apply widl-SLTG_Typelib_Support/0025-oleaut32-Add-support-for-decoding-SLTG-variable-help.patch
	patch_apply widl-SLTG_Typelib_Support/0026-widl-Minor-cosmetic-clean-up.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add initial implementation of SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for structures.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Properly align name table entries.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: More accurately report variable descriptions data size.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Calculate size of instance for structures.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Write correct typekind to the SLTG typeinfo block.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Write SLTG blocks according to the index order.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Write correct syskind by SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for VT_VOID and VT_VARIANT to SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for VT_USERDEFINED to SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Factor out SLTG tail initialization.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for recursive type references to SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for interfaces to SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for inherited interfaces to SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Make automatic dispid generation scheme better match what midl does.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Create library block index right after the CompObj one.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Fix generation of resources containing an old typelib.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "widl: Add --oldtlb switch in usage message.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Avoid relying on side effects when marking function index as the last one.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Set the lowest bit in the param name to indicate whether type description follows the name.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Fix logic for deciding whether type description follows the name.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Add support for function parameter flags to SLTG typelib generator.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Implement decoding of SLTG help strings.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Add support for decoding SLTG function help strings.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "oleaut32: Add support for decoding SLTG variable help strings.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "widl: Minor/cosmetic clean up.", 1 },';
	) >> "$patchlist"
fi

# Patchset stdole32.tlb-SLTG_Typelib
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	widl-SLTG_Typelib_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#3689] Compile stdole32.tlb in SLTG typelib format
# |
# | Modified files:
# |   *	dlls/stdole32.tlb/Makefile.in
# |
if test "$enable_stdole32_tlb_SLTG_Typelib" -eq 1; then
	patch_apply stdole32.tlb-SLTG_Typelib/0020-stdole32.tlb-Compile-typelib-with-oldtlb.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "stdole32.tlb: Compile typelib with --oldtlb.", 1 },';
	) >> "$patchlist"
fi

# Patchset taskmgr-Memory_Usage
# |
# | Modified files:
# |   *	dlls/ntdll/nt.c, programs/taskmgr/font.bmp, programs/taskmgr/graph.c, programs/taskmgr/resource.h,
# | 	programs/taskmgr/taskmgr.c, programs/taskmgr/taskmgr.rc
# |
if test "$enable_taskmgr_Memory_Usage" -eq 1; then
	patch_apply taskmgr-Memory_Usage/0002-ntdll-Report-system-information-SystemPerformanceInf.patch
	patch_apply taskmgr-Memory_Usage/0003-taskmgr-Use-system-font-instead-of-special-bitmap-fo.patch
	patch_apply taskmgr-Memory_Usage/0004-taskmgr-Use-different-units-depending-on-memory-usag.patch
	patch_apply taskmgr-Memory_Usage/0005-ntdll-Implement-basic-IO-stats-for-SystemPerformance.patch
	(
		printf '%s\n' '+    { "Michael Müller", "ntdll: Report system information SystemPerformanceInformation info class.", 2 },';
		printf '%s\n' '+    { "Michael Müller", "taskmgr: Use system font instead of special bitmap font.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "taskmgr: Use different units depending on memory usage.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "ntdll: Implement basic IO stats for SystemPerformanceInformation in NtQuerySystemInformation.", 1 },';
	) >> "$patchlist"
fi

# Patchset user.exe16-CONTAINING_RECORD
# |
# | Modified files:
# |   *	dlls/user.exe16/user.c
# |
if test "$enable_user_exe16_CONTAINING_RECORD" -eq 1; then
	patch_apply user.exe16-CONTAINING_RECORD/0001-user.exe16-Don-t-open-code-CONTAINING_RECORD.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "user.exe16: Don'\''t open code CONTAINING_RECORD.", 1 },';
	) >> "$patchlist"
fi

# Patchset user.exe16-DlgDirList
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#18734] Fix handling of DDL_DRIVES flag in user.exe16.DlgDirList
# |
# | Modified files:
# |   *	dlls/user.exe16/dialog.c
# |
if test "$enable_user_exe16_DlgDirList" -eq 1; then
	patch_apply user.exe16-DlgDirList/0001-user.exe16-Fix-handling-of-DDL_DRIVES-flag-in-DlgDir.patch
	(
		printf '%s\n' '+    { "Alex Villacís Lasso", "user.exe16: Fix handling of DDL_DRIVES flag in DlgDirList.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Auto_Radio_Button
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42010] Move the auto radio button group logic from BM_SETCHECK to WM_LBUTTONUP handler
# |   *	[#16845] Add support for navigating a group of radio buttons using a keyboard.
# |
# | Modified files:
# |   *	dlls/user32/button.c, dlls/user32/dialog.c, dlls/user32/tests/msg.c, dlls/user32/tests/resource.rc
# |
if test "$enable_user32_Auto_Radio_Button" -eq 1; then
	patch_apply user32-Auto_Radio_Button/0001-user32-Move-the-auto-radio-button-group-logic-from-B.patch
	patch_apply user32-Auto_Radio_Button/0002-user32-tests-Add-a-message-test-for-group-of-radio-b.patch
	patch_apply user32-Auto_Radio_Button/0003-user32-tests-Simplify-the-test-for-BM_CLICK-on-autor.patch
	patch_apply user32-Auto_Radio_Button/0004-user32-tests-Add-a-test-for-navigating-a-group-of-bu.patch
	patch_apply user32-Auto_Radio_Button/0005-user32-Add-support-for-navigating-a-group-of-radio-b.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Move the auto radio button group logic from BM_SETCHECK to WM_LBUTTONUP handler.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32/tests: Add a message test for group of radio buttons.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32/tests: Simplify the test for BM_CLICK on autoradio button by using a dialog.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32/tests: Add a test for navigating a group of buttons using keyboard events.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Add support for navigating a group of radio buttons using a keyboard.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Combobox_WM_SIZE
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41404] Don't force a combobox repaint on WM_SIZE
# |
# | Modified files:
# |   *	dlls/user32/combo.c
# |
if test "$enable_user32_Combobox_WM_SIZE" -eq 1; then
	patch_apply user32-Combobox_WM_SIZE/0001-user32-Don-t-force-a-combobox-repaint-on-WM_SIZE.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Don'\''t force a combobox repaint on WM_SIZE.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-DM_SETDEFID
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22764] Use root dialog for DM_SETDEFID/DM_GETDEFID in DefDlgProc
# |
# | Modified files:
# |   *	dlls/user32/defdlg.c, dlls/user32/dialog.c, dlls/user32/tests/win.c
# |
if test "$enable_user32_DM_SETDEFID" -eq 1; then
	patch_apply user32-DM_SETDEFID/0001-user32-Do-not-initialize-dialog-info-for-every-windo.patch
	patch_apply user32-DM_SETDEFID/0002-user32-Use-root-dialog-for-DM_SETDEFID-DM_GETDEFID-i.patch
	patch_apply user32-DM_SETDEFID/0003-user32-tests-Add-a-bunch-of-tests-for-DM_SETDEFID-DM.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Do not initialize dialog info for every window passed to DefDlgProc.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Use root dialog for DM_SETDEFID/DM_GETDEFID in DefDlgProc.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32/tests: Add a bunch of tests for DM_SETDEFID/DM_GETDEFID handling by a DefDlgProc.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Dialog_Focus
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#5402] Set focus to dialog itself when it has no controls
# |
# | Modified files:
# |   *	dlls/user32/dialog.c, dlls/user32/tests/msg.c
# |
if test "$enable_user32_Dialog_Focus" -eq 1; then
	patch_apply user32-Dialog_Focus/0001-user32-tests-Add-a-focus-test-for-an-empty-dialog-th.patch
	patch_apply user32-Dialog_Focus/0002-user32-If-there-is-no-dialog-controls-to-set-focus-t.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32/tests: Add a focus test for an empty dialog that returns TRUE in WM_INITDIALOG.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: If there is no dialog controls to set focus to then set focus to dialog itself.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Dialog_Paint_Event
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#35652] Send WM_PAINT event during dialog creation
# |
# | Modified files:
# |   *	dlls/user32/dialog.c
# |
if test "$enable_user32_Dialog_Paint_Event" -eq 1; then
	patch_apply user32-Dialog_Paint_Event/0001-user32-Call-UpdateWindow-during-DIALOG_CreateIndirec.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Call UpdateWindow() during DIALOG_CreateIndirect.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-DrawMenuItem
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40704] Add a check if the menu text is a valid string in MENU_DrawMenuItem
# |
# | Modified files:
# |   *	dlls/user32/menu.c
# |
if test "$enable_user32_DrawMenuItem" -eq 1; then
	patch_apply user32-DrawMenuItem/0001-user32-Add-a-check-if-the-menu-text-is-a-valid-strin.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Add a check if the menu text is a valid string.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-DrawTextExW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22109] Fix handling of invert_y in DrawTextExW
# |
# | Modified files:
# |   *	dlls/user32/text.c
# |
if test "$enable_user32_DrawTextExW" -eq 1; then
	patch_apply user32-DrawTextExW/0001-user32-Fix-handling-of-invert_y-in-DrawTextExW.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Fix handling of invert_y in DrawTextExW.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-FlashWindowEx
# |
# | Modified files:
# |   *	dlls/user32/tests/win.c, dlls/user32/win.c
# |
if test "$enable_user32_FlashWindowEx" -eq 1; then
	patch_apply user32-FlashWindowEx/0001-user32-Improve-FlashWindowEx-message-and-return-valu.patch
	(
		printf '%s\n' '+    { "James Coonradt", "user32: Improve FlashWindowEx message and return value.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-GetAutoRotationState
# |
# | Modified files:
# |   *	dlls/user32/sysparams.c, dlls/user32/tests/sysparams.c
# |
if test "$enable_user32_GetAutoRotationState" -eq 1; then
	patch_apply user32-GetAutoRotationState/0001-user32-Add-semi-stub-for-GetAutoRotationState.patch
	(
		printf '%s\n' '+    { "Michael Müller", "user32: Add semi-stub for GetAutoRotationState.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-GetSystemMetrics
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#18732] Make it possible to change media center / tablet pc status
# |
# | Modified files:
# |   *	dlls/user32/sysparams.c
# |
if test "$enable_user32_GetSystemMetrics" -eq 1; then
	patch_apply user32-GetSystemMetrics/0001-user32-Allow-changing-the-tablet-media-center-status.patch
	(
		printf '%s\n' '+    { "Michael Müller", "user32: Allow changing the tablet / media center status via wine registry key.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Groupbox_Rectangle
# |
# | Modified files:
# |   *	dlls/user32/button.c
# |
if test "$enable_user32_Groupbox_Rectangle" -eq 1; then
	patch_apply user32-Groupbox_Rectangle/0001-user32-Always-restore-previously-selected-font-in-th.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Always restore previously selected font in the button painting helpers.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Invalidate_Key_State
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29871] Globally invalidate key state on changes in other threads
# |
# | Modified files:
# |   *	dlls/user32/input.c
# |
if test "$enable_user32_Invalidate_Key_State" -eq 1; then
	patch_apply user32-Invalidate_Key_State/0001-user32-Globally-invalidate-key-state-on-changes-in-o.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Globally invalidate key state on changes in other threads.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-LR_LOADFROMFILE
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#24963] Workaround for Windows 3.1 apps which call LoadImage(LR_LOADFROMFILE) with a resource id
# |
# | Modified files:
# |   *	dlls/user32/cursoricon.c
# |
if test "$enable_user32_LR_LOADFROMFILE" -eq 1; then
	patch_apply user32-LR_LOADFROMFILE/0001-user32-Add-a-workaround-for-Windows-3.1-apps-which-c.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Add a workaround for Windows 3.1 apps which call LoadImage(LR_LOADFROMFILE) with a resource id.", 2 },';
	) >> "$patchlist"
fi

# Patchset user32-ListBox_Size
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38142] Fix calculation of listbox size when horizontal scrollbar is present
# |
# | Modified files:
# |   *	dlls/user32/listbox.c
# |
if test "$enable_user32_ListBox_Size" -eq 1; then
	patch_apply user32-ListBox_Size/0001-user32-Fix-calculation-of-listbox-size-when-horizont.patch
	(
		printf '%s\n' '+    { "Michael Müller", "user32: Fix calculation of listbox size when horizontal scrollbar is present.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-lpCreateParams
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40303] Fix pointer to custom dialog control data
# |
# | Modified files:
# |   *	dlls/user32/dialog.c, dlls/user32/tests/dialog.c, dlls/user32/tests/resource.rc, tools/wrc/genres.c
# |
if test "$enable_user32_lpCreateParams" -eq 1; then
	patch_apply user32-lpCreateParams/0001-user32-tests-Add-a-test-for-custom-dialog-control-da.patch
	patch_apply user32-lpCreateParams/0002-tools-wrc-Fix-generation-of-custom-dialog-control-da.patch
	patch_apply user32-lpCreateParams/0003-user32-Fix-the-pointer-to-custom-dialog-control-data.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32/tests: Add a test for custom dialog control data.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "tools/wrc: Fix generation of custom dialog control data.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Fix the pointer to custom dialog control data.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-MessageBox_WS_EX_TOPMOST
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	user32-lpCreateParams
# |
# | Modified files:
# |   *	dlls/user32/msgbox.c, dlls/user32/tests/dialog.c
# |
if test "$enable_user32_MessageBox_WS_EX_TOPMOST" -eq 1; then
	patch_apply user32-MessageBox_WS_EX_TOPMOST/0001-user32-tests-Add-some-tests-to-see-when-MessageBox-g.patch
	patch_apply user32-MessageBox_WS_EX_TOPMOST/0002-user32-MessageBox-should-be-topmost-when-MB_SYSTEMMO.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32/tests: Add some tests to see when MessageBox gains WS_EX_TOPMOST style.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: MessageBox should be topmost when MB_SYSTEMMODAL style is set.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Mouse_Message_Hwnd
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#22458] Fix issues with inserting symbols by clicking on center in Word 2007 & 2010
# |   *	[#12007] Fix issues with dragging layers between images in Adobe Photoshop 7.0
# |   *	[#9512] Make sure popups don't block access to objects underneath in DVDPro
# |
# | Modified files:
# |   *	dlls/user32/message.c, dlls/user32/tests/input.c, dlls/winex11.drv/bitblt.c, server/protocol.def, server/window.c
# |
if test "$enable_user32_Mouse_Message_Hwnd" -eq 1; then
	patch_apply user32-Mouse_Message_Hwnd/0001-user32-Try-harder-to-find-a-target-for-mouse-message.patch
	patch_apply user32-Mouse_Message_Hwnd/0002-user32-tests-Add-tests-for-clicking-through-layered-.patch
	patch_apply user32-Mouse_Message_Hwnd/0003-user32-tests-Add-tests-for-window-region-of-layered-.patch
	patch_apply user32-Mouse_Message_Hwnd/0004-user32-tests-Add-tests-for-DC-region.patch
	patch_apply user32-Mouse_Message_Hwnd/0005-server-Add-support-for-a-layered-window-region.-v2.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Try harder to find a target for mouse messages.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32/tests: Add tests for clicking through layered window.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32/tests: Add tests for window region of layered windows.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "user32/tests: Add tests for DC region.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "server: Add support for a layered window region.", 3 },';
	) >> "$patchlist"
fi

# Patchset user32-PNG_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38959] Add support for loading PNG icon files
# |
# | Modified files:
# |   *	dlls/user32/Makefile.in, dlls/user32/cursoricon.c
# |
if test "$enable_user32_PNG_Support" -eq 1; then
	patch_apply user32-PNG_Support/0001-user32-Add-support-for-PNG-icons.-v4.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Add support for PNG icons.", 5 },';
	) >> "$patchlist"
fi

# Patchset user32-Refresh_MDI_Menus
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#21855] Refresh MDI menus when DefMDIChildProc(WM_SETTEXT) is called
# |
# | Modified files:
# |   *	dlls/user32/mdi.c
# |
if test "$enable_user32_Refresh_MDI_Menus" -eq 1; then
	patch_apply user32-Refresh_MDI_Menus/0001-user32-Refresh-MDI-menus-when-DefMDIChildProcW-WM_SE.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "user32: Refresh MDI menus when DefMDIChildProc(WM_SETTEXT) is called.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Revert_ListBox_Height
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43643] Revert patch to fix listbox popup height
# |
# | Modified files:
# |   *	dlls/user32/combo.c, dlls/user32/tests/combo.c
# |
if test "$enable_user32_Revert_ListBox_Height" -eq 1; then
	patch_apply user32-Revert_ListBox_Height/0001-Revert-user32-combo-Set-listbox-popup-height-correct.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "Revert \"user32/combo: Set listbox popup height correctly and add tests.\".", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-ScrollWindowEx
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37706] Fix return value of ScrollWindowEx for invisible windows
# |
# | Modified files:
# |   *	dlls/user32/painting.c
# |
if test "$enable_user32_ScrollWindowEx" -eq 1; then
	patch_apply user32-ScrollWindowEx/0001-user32-Fix-return-value-of-ScrollWindowEx-for-invisi.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Fix return value of ScrollWindowEx for invisible windows.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-ShowWindow
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39731] Fix handling of ShowWindow when window is already visible
# |
# | Modified files:
# |   *	dlls/user32/winpos.c
# |
if test "$enable_user32_ShowWindow" -eq 1; then
	patch_apply user32-ShowWindow/0001-user32-ShowWindow-should-not-send-message-when-windo.patch
	(
		printf '%s\n' '+    { "Kimmo Myllyvirta", "user32: ShowWindow should not send message when window is already visible.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-WM_MEASUREITEM
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37025] Pass correct itemData to WM_MEASUREITEM when inserting an item to an owner-drawn listbox
# |
# | Modified files:
# |   *	dlls/user32/listbox.c, dlls/user32/tests/msg.c
# |
if test "$enable_user32_WM_MEASUREITEM" -eq 1; then
	patch_apply user32-WM_MEASUREITEM/0001-user32-tests-Add-a-test-for-WM_MEASUREITEM-when-inse.patch
	patch_apply user32-WM_MEASUREITEM/0002-user32-Pass-correct-itemData-to-WM_MEASUREITEM-when-.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32/tests: Add a test for WM_MEASUREITEM when inserting an item to an owner-drawn listbox.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Pass correct itemData to WM_MEASUREITEM when inserting an item to an owner-drawn listbox.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-Sorted_Listbox
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	user32-WM_MEASUREITEM
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42602] Multiple fixes for owner-drawn and sorted listbox
# |
# | Modified files:
# |   *	dlls/user32/listbox.c, dlls/user32/tests/msg.c
# |
if test "$enable_user32_Sorted_Listbox" -eq 1; then
	patch_apply user32-Sorted_Listbox/0001-user32-tests-Add-a-message-test-for-an-owner-drawn-s.patch
	patch_apply user32-Sorted_Listbox/0002-user32-tests-Add-some-message-tests-for-not-an-owner.patch
	patch_apply user32-Sorted_Listbox/0003-user32-Fix-order-of-items-passed-in-WM_COMPAREITEM-d.patch
	patch_apply user32-Sorted_Listbox/0004-user32-Fix-the-listbox-sorting-algorithm.patch
	patch_apply user32-Sorted_Listbox/0005-user32-For-an-owner-drawn-listbox-without-strings-WM.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32/tests: Add a message test for an owner-drawn sorted listbox.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32/tests: Add some message tests for not an owner-drawn listbox.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Fix order of items passed in WM_COMPAREITEM data.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Fix the listbox sorting algorithm.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: For an owner-drawn listbox without strings WM_MEASUREITEM still needs correct itemData.", 1 },';
	) >> "$patchlist"
fi

# Patchset user32-WindowDisplayAffinity
# |
# | Modified files:
# |   *	dlls/ext-ms-win-ntuser-uicontext-ext-l1-1-0/ext-ms-win-ntuser-uicontext-ext-l1-1-0.spec, dlls/ext-ms-win-ntuser-
# | 	window-l1-1-1/ext-ms-win-ntuser-window-l1-1-1.spec, dlls/user32/tests/win.c, dlls/user32/user32.spec, dlls/user32/win.c,
# | 	include/winuser.h
# |
if test "$enable_user32_WindowDisplayAffinity" -eq 1; then
	patch_apply user32-WindowDisplayAffinity/0001-user32-Add-stubs-for-GetWindowDisplayAffinity-and-Se.patch
	(
		printf '%s\n' '+    { "Michael Müller", "user32: Add stubs for GetWindowDisplayAffinity and SetWindowDisplayAffinity.", 1 },';
	) >> "$patchlist"
fi

# Patchset uxtheme-CloseThemeClass
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41729] Protect CloseThemeData() from invalid input
# |
# | Modified files:
# |   *	dlls/uxtheme/msstyles.c, dlls/uxtheme/msstyles.h, dlls/uxtheme/tests/system.c
# |
if test "$enable_uxtheme_CloseThemeClass" -eq 1; then
	patch_apply uxtheme-CloseThemeClass/0001-uxtheme-Protect-CloseThemeData-from-invalid-input.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "uxtheme: Protect CloseThemeData() from invalid input.", 1 },';
	) >> "$patchlist"
fi

# Patchset uxtheme-GTK_Theming
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Attach_Process_DLLs, ntdll-DllOverrides_WOW64, ntdll-Loader_Machine_Type, ntdll-DllRedirects
# |
# | Modified files:
# |   *	aclocal.m4, configure.ac, dlls/uxtheme-gtk/Makefile.in, dlls/uxtheme-gtk/button.c, dlls/uxtheme-gtk/combobox.c, dlls
# | 	/uxtheme-gtk/edit.c, dlls/uxtheme-gtk/header.c, dlls/uxtheme-gtk/listbox.c, dlls/uxtheme-gtk/listview.c, dlls/uxtheme-
# | 	gtk/menu.c, dlls/uxtheme-gtk/rebar.c, dlls/uxtheme-gtk/status.c, dlls/uxtheme-gtk/tab.c, dlls/uxtheme-gtk/toolbar.c,
# | 	dlls/uxtheme-gtk/trackbar.c, dlls/uxtheme-gtk/uxtheme-gtk.spec, dlls/uxtheme-gtk/uxtheme.c, dlls/uxtheme-
# | 	gtk/uxthemegtk.h, dlls/uxtheme-gtk/version.rc, dlls/uxtheme-gtk/window.c
# |
if test "$enable_uxtheme_GTK_Theming" -eq 1; then
	patch_apply uxtheme-GTK_Theming/0001-uxthemegtk-Add-configure-check-and-stub-dll.patch
	patch_apply uxtheme-GTK_Theming/0002-uxthemegtk-Initial-implementation.patch
	patch_apply uxtheme-GTK_Theming/0003-uxthemegtk-Implement-enumeration-of-themes-color-and.patch
	patch_apply uxtheme-GTK_Theming/0004-uxthemegtk-Correctly-render-buttons-with-GTK-3.14.0.patch
	patch_apply uxtheme-GTK_Theming/0005-uxthemegtk-Print-class-name-before-calling-vtable-fu.patch
	patch_apply uxtheme-GTK_Theming/0006-uxthemegtk-Reset-FPU-flags-before-calling-GTK3-funct.patch
	patch_apply uxtheme-GTK_Theming/0007-uxthemegtk-Add-export-for-OpenThemeDataEx.patch
	patch_apply uxtheme-GTK_Theming/0008-uxthemegtk-Fix-some-incorrect-error-codes.patch
	patch_apply uxtheme-GTK_Theming/0009-uxthemegtk-Validate-theme-handles-before-accessing-p.patch
	(
		printf '%s\n' '+    { "Michael Müller", "uxthemegtk: Add configure check and stub dll.", 1 },';
		printf '%s\n' '+    { "Ivan Akulinchev", "uxthemegtk: Initial implementation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "uxthemegtk: Implement enumeration of themes, color and sizes.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "uxthemegtk: Correctly render buttons with GTK >= 3.14.0.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "uxthemegtk: Print class name before calling vtable functions.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "uxthemegtk: Reset FPU flags before calling GTK3 functions.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "uxthemegtk: Add export for OpenThemeDataEx.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "uxthemegtk: Fix some incorrect error codes.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "uxthemegtk: Validate theme handles before accessing private data.", 1 },';
	) >> "$patchlist"
fi

# Patchset version-GetFileVersionInfoSizeExW
# |
# | Modified files:
# |   *	dlls/version/version.c
# |
if test "$enable_version_GetFileVersionInfoSizeExW" -eq 1; then
	patch_apply version-GetFileVersionInfoSizeExW/0001-version-Return-ERROR_FILE_NOT_FOUND-for-Win-9X-when-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "version: Return ERROR_FILE_NOT_FOUND for Win 9X when a file was not found in GetFileVersionInfoSizeEx.", 1 },';
	) >> "$patchlist"
fi

# Patchset version-VerFindFileA
# |
# | Modified files:
# |   *	dlls/version/tests/Makefile.in, dlls/version/tests/install.c, dlls/version/version.c
# |
if test "$enable_version_VerFindFileA" -eq 1; then
	patch_apply version-VerFindFileA/0001-version-Correctly-return-VFF_CURNEDEST-in-VerFindFil.patch
	(
		printf '%s\n' '+    { "Michael Müller", "version: Correctly return VFF_CURNEDEST in VerFindFileA.", 1 },';
	) >> "$patchlist"
fi

# Patchset version-VerQueryValue
# |
# | Modified files:
# |   *	dlls/version/tests/info.c
# |
if test "$enable_version_VerQueryValue" -eq 1; then
	patch_apply version-VerQueryValue/0001-version-Test-for-VerQueryValueA-try-2.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "version: Test for VerQueryValueA.", 2 },';
	) >> "$patchlist"
fi

# Patchset virtdisk-GetStorageDependencyInformation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42577] Add stub for virtdisk.GetStorageDependencyInformation
# |
# | Modified files:
# |   *	dlls/virtdisk/virtdisk.spec, dlls/virtdisk/virtdisk_main.c, include/Makefile.in, include/virtdisk.h
# |
if test "$enable_virtdisk_GetStorageDependencyInformation" -eq 1; then
	patch_apply virtdisk-GetStorageDependencyInformation/0001-include-add-headerfile-virtdisk.h.patch
	patch_apply virtdisk-GetStorageDependencyInformation/0002-virtdisk-Add-GetStorageDependencyInformation-stub.patch
	(
		printf '%s\n' '+    { "Louis Lenders", "include: Add headerfile virtdisk.h.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "virtdisk: Add GetStorageDependencyInformation stub.", 1 },';
	) >> "$patchlist"
fi

# Patchset vulkan-Vulkan_Implementation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40164] Implement support for Vulkan
# |
# | Modified files:
# |   *	configure.ac, dlls/vulkan-1/Makefile.in, dlls/vulkan-1/vulkan-1.spec, dlls/vulkan/Makefile.in, dlls/vulkan/vulkan.spec,
# | 	dlls/vulkan/vulkan_main.c, dlls/vulkan/vulkan_private.h, dlls/vulkan/vulkan_thunks.c
# |
if test "$enable_vulkan_Vulkan_Implementation" -eq 1; then
	patch_apply vulkan-Vulkan_Implementation/0001-vulkan-Initial-implementation.patch
	patch_apply vulkan-Vulkan_Implementation/0002-vulkan-Implement-vkGetPhysicalDeviceWin32Presentatio.patch
	patch_apply vulkan-Vulkan_Implementation/0003-vulkan-Use-binary-search-to-lookup-function-in-is_nu.patch
	patch_apply vulkan-Vulkan_Implementation/0004-vulkan-Try-to-load-libvulkan.so.1.patch
	patch_apply vulkan-Vulkan_Implementation/0005-vulkan-Enumerate-VK_KHR_win32_surface-only-one-time-.patch
	patch_apply vulkan-Vulkan_Implementation/0006-vulkan-Update-to-spec-version-1.0.30-no-VK_EXT_debug.patch
	patch_apply vulkan-Vulkan_Implementation/0007-vulkan-Improve-vkGetPhysicalDeviceWin32PresentationS.patch
	patch_apply vulkan-Vulkan_Implementation/0008-vulkan-Only-convert-VkDescriptor-Image-Buffer-Info-w.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "vulkan: Initial implementation.", 2 },';
		printf '%s\n' '+    { "Michael Müller", "vulkan: Implement vkGetPhysicalDeviceWin32PresentationSupportKHR.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "vulkan: Use binary search to lookup function in is_null_func.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "vulkan: Try to load libvulkan.so.1.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "vulkan: Enumerate VK_KHR_win32_surface only one time in vkEnumerateInstanceExtensionProperties.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "vulkan: Update to spec version 1.0.30 (no VK_EXT_debug_marker support yet).", 1 },';
		printf '%s\n' '+    { "Michael Müller", "vulkan: Improve vkGetPhysicalDeviceWin32PresentationSupportKHR and vkCreateWin32SurfaceKHR.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "vulkan: Only convert VkDescriptor{Image,Buffer}Info when type is valid.", 1 },';
	) >> "$patchlist"
fi

# Patchset wbemdisp-ISWbemSecurity
# |
# | Modified files:
# |   *	dlls/wbemdisp/locator.c
# |
if test "$enable_wbemdisp_ISWbemSecurity" -eq 1; then
	patch_apply wbemdisp-ISWbemSecurity/0001-wbemdisp-Add-ISWbemSecurity-stub-interface.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wbemdisp: Add ISWbemSecurity stub interface.", 1 },';
	) >> "$patchlist"
fi

# Patchset wbemprox-Printer
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40539] Provide DeviceID, Location and PortName for printers
# |
# | Modified files:
# |   *	dlls/wbemprox/builtin.c
# |
if test "$enable_wbemprox_Printer" -eq 1; then
	patch_apply wbemprox-Printer/0001-wbemprox-Provide-DeviceID-Location-and-PortName-for-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wbemprox: Provide DeviceID, Location and PortName for printers.", 1 },';
	) >> "$patchlist"
fi

# Patchset wbemprox-Win32_OperatingSystem
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43357] Add FreePhysicalMemory to Win32_OperatingSystem
# |
# | Modified files:
# |   *	dlls/wbemprox/builtin.c
# |
if test "$enable_wbemprox_Win32_OperatingSystem" -eq 1; then
	patch_apply wbemprox-Win32_OperatingSystem/0001-wbemprox-Add-FreePhysicalMemory-to-Win32_OperatingSy.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wbemprox: Add FreePhysicalMemory to Win32_OperatingSystem.", 1 },';
	) >> "$patchlist"
fi

# Patchset wbemprox-Win32_VideoController
# |
# | Modified files:
# |   *	dlls/wbemprox/builtin.c
# |
if test "$enable_wbemprox_Win32_VideoController" -eq 1; then
	patch_apply wbemprox-Win32_VideoController/0001-wbemprox-Add-ConfigManagerErrorCode-for-Win32_VideoC.patch
	patch_apply wbemprox-Win32_VideoController/0002-wbemprox-Add-Status-for-Win32_VideoController.patch
	patch_apply wbemprox-Win32_VideoController/0003-wbemprox-Add-InstalledDisplayDrivers-for-Win32_Video.patch
	patch_apply wbemprox-Win32_VideoController/0004-wbemprox-Add-DriverDate-for-Win32_VideoController.patch
	patch_apply wbemprox-Win32_VideoController/0005-wbemprox-Add-Vendor-field-in-Win32_ComputerSystemPro.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wbemprox: Add ConfigManagerErrorCode for Win32_VideoController.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wbemprox: Add Status for Win32_VideoController.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wbemprox: Add InstalledDisplayDrivers for Win32_VideoController.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wbemprox: Add DriverDate for Win32_VideoController.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wbemprox: Add Vendor field in Win32_ComputerSystemProduct.", 1 },';
	) >> "$patchlist"
fi

# Patchset wevtapi-EvtNext
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42170] Add stub for wevtapi.EvtNext
# |
# | Modified files:
# |   *	dlls/wevtapi/main.c, dlls/wevtapi/wevtapi.spec
# |
if test "$enable_wevtapi_EvtNext" -eq 1; then
	patch_apply wevtapi-EvtNext/0001-wevtapi-Add-stub-for-EvtNext.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wevtapi: Add stub for EvtNext.", 1 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-Palette_Images
# |
# | Modified files:
# |   *	dlls/windowscodecs/bmpdecode.c, dlls/windowscodecs/bmpencode.c, dlls/windowscodecs/imgfactory.c,
# | 	dlls/windowscodecs/info.c, dlls/windowscodecs/pngformat.c, dlls/windowscodecs/regsvr.c,
# | 	dlls/windowscodecs/tests/converter.c, dlls/windowscodecs/tests/pngformat.c, dlls/windowscodecs/tiffformat.c
# |
if test "$enable_windowscodecs_Palette_Images" -eq 1; then
	patch_apply windowscodecs-Palette_Images/0012-windowscodecs-tests-Add-tests-for-encoding-2bpp-4bpp.patch
	patch_apply windowscodecs-Palette_Images/0013-windowscodecs-Use-V_UI1-instead-of-V_UNION-to-assign.patch
	patch_apply windowscodecs-Palette_Images/0014-windowscodecs-Add-support-for-palette-image-formats-.patch
	patch_apply windowscodecs-Palette_Images/0015-windowscodecs-Write-the-image-bits-as-a-bottom-top-a.patch
	patch_apply windowscodecs-Palette_Images/0016-windowscodecs-Limit-number-of-colors-in-a-palette-in.patch
	patch_apply windowscodecs-Palette_Images/0017-windowscodecs-Add-support-for-palette-image-formats-.patch
	patch_apply windowscodecs-Palette_Images/0020-windowscodecs-find_decoder-should-return-an-error-it.patch
	patch_apply windowscodecs-Palette_Images/0021-windowscodecs-PNG-decoder-should-return-WINCODEC_ERR.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs/tests: Add tests for encoding 2bpp/4bpp images with a palette.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Use V_UI1() instead of V_UNION() to assign a VT_UI1 variant member.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for palette image formats to TIFF encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Write the image bits as a bottom-top array in BMP encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Limit number of colors in a palette in BMP decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for palette image formats to BMP encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Find_decoder() should return an error it received from the decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: PNG decoder should return WINCODEC_ERR_UNKNOWNIMAGEFORMAT when image loading fails.", 1 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-GIF_Encoder
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	windowscodecs-Palette_Images
# |
# | Modified files:
# |   *	dlls/gdiplus/image.c, dlls/gdiplus/tests/image.c, dlls/windowscodecs/bmpencode.c, dlls/windowscodecs/clsfactory.c,
# | 	dlls/windowscodecs/converter.c, dlls/windowscodecs/gifformat.c, dlls/windowscodecs/info.c,
# | 	dlls/windowscodecs/jpegformat.c, dlls/windowscodecs/pngformat.c, dlls/windowscodecs/regsvr.c,
# | 	dlls/windowscodecs/tests/converter.c, dlls/windowscodecs/tiffformat.c, dlls/windowscodecs/wincodecs_private.h,
# | 	dlls/windowscodecs/windowscodecs_wincodec.idl
# |
if test "$enable_windowscodecs_GIF_Encoder" -eq 1; then
	patch_apply windowscodecs-GIF_Encoder/0001-windowscodecs-Implement-IWICBitmapEncoder-GetEncoder.patch
	patch_apply windowscodecs-GIF_Encoder/0002-windowscodecs-Implement-IWICBitmapEncoderInfo-GetFil.patch
	patch_apply windowscodecs-GIF_Encoder/0004-windowscodecs-Implement-IWICBitmapEncoder-GetEncoder.patch
	patch_apply windowscodecs-GIF_Encoder/0005-windowscodecs-Avoid-crashing-if-no-IPropertyBag2-was.patch
	patch_apply windowscodecs-GIF_Encoder/0006-windowscodecs-Implement-IWICBitmapEncoder-GetEncoder.patch
	patch_apply windowscodecs-GIF_Encoder/0007-windowscodecs-Avoid-crashing-if-no-IPropertyBag2-was.patch
	patch_apply windowscodecs-GIF_Encoder/0008-windowscodecs-Add-initial-implementation-of-the-GIF-.patch
	patch_apply windowscodecs-GIF_Encoder/0009-gdiplus-Fix-a-typo-in-GIF-container-format-passed-to.patch
	patch_apply windowscodecs-GIF_Encoder/0010-windowscodecs-Initialize-empty-property-bag-in-GIF-e.patch
	patch_apply windowscodecs-GIF_Encoder/0011-windowscodecs-Add-registration-for-GUID_WICPixelForm.patch
	patch_apply windowscodecs-GIF_Encoder/0012-windowscodecs-Implement-IWICBitmapDecoder-GetMetadat.patch
	patch_apply windowscodecs-GIF_Encoder/0014-windowscodecs-Fix-the-buffer-size-check-in-the-TIFF-.patch
	patch_apply windowscodecs-GIF_Encoder/0015-windowscodecs-Add-support-for-converting-to-8bppInde.patch
	patch_apply windowscodecs-GIF_Encoder/0016-windowscodecs-WICConvertBitmapSource-should-ask-IWIC.patch
	patch_apply windowscodecs-GIF_Encoder/0017-windowscodecs-Implement-IWICBitmapEncoder-GetEncoder.patch
	patch_apply windowscodecs-GIF_Encoder/0018-windowscodecs-Implement-IWICBitmapEncoder-GetEncoder.patch
	patch_apply windowscodecs-GIF_Encoder/0019-windowscodecs-Improve-stub-for-IWICBitmapDecoder-Get.patch
	patch_apply windowscodecs-GIF_Encoder/0020-windowscodecs-Add-registration-of-the-GIF-encoder.patch
	patch_apply windowscodecs-GIF_Encoder/0021-windowscodecs-Fix-IWICBitmapDecoder-CopyPalette-for-.patch
	patch_apply windowscodecs-GIF_Encoder/0022-windowscodecs-Better-follow-the-GIF-spec-and-don-t-s.patch
	patch_apply windowscodecs-GIF_Encoder/0023-windowscodecs-Fix-behaviour-of-format-converter-for-.patch
	patch_apply windowscodecs-GIF_Encoder/0024-windowscodecs-tests-Add-a-bunch-of-new-tests-for-ind.patch
	patch_apply windowscodecs-GIF_Encoder/0025-windowscodecs-tests-Add-some-tests-for-converting-24.patch
	patch_apply windowscodecs-GIF_Encoder/0026-windowscodecs-tests-Add-the-tests-for-GIF-encoder-an.patch
	patch_apply windowscodecs-GIF_Encoder/0027-windowscodecs-tests-Add-a-missing-check-for-IWICBitm.patch
	patch_apply windowscodecs-GIF_Encoder/0028-windowscodecs-Correctly-indicate-that-the-global-inf.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Implement IWICBitmapEncoder::GetEncoderInfo in BMP encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Implement IWICBitmapEncoderInfo::GetFileExtensions.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Implement IWICBitmapEncoder::GetEncoderInfo in JPEG encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Avoid crashing if no IPropertyBag2 was passed to IWICBitmapEncoder::CreateNewFrame in JPEG encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Implement IWICBitmapEncoder::GetEncoderInfo in TIFF encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Avoid crashing if no IPropertyBag2 was passed to IWICBitmapEncoder::CreateNewFrame in TIFF encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add initial implementation of the GIF encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Fix a typo in GIF container format passed to encode_image_wic().", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Initialize empty property bag in GIF encoder'\''s CreateNewFrame implementation.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add registration for GUID_WICPixelFormat32bppGrayFloat pixel format.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Implement IWICBitmapDecoder::GetMetadataQueryReader in the TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Fix the buffer size check in the TIFF decoder'\''s IWICBitmapFrameDecode::CopyPixels implementation.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for converting to 8bppIndexed format to IWICFormatConverter.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: WICConvertBitmapSource should ask IWICFormatConverter::Initialize to use an optimized palette.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Implement IWICBitmapEncoder::GetEncoderInfo in the JPEG encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Implement IWICBitmapEncoder::GetEncoderInfo in the PNG encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Improve stub for IWICBitmapDecoder::GetMetadataQueryReader in the PNG decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add registration of the GIF encoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Fix IWICBitmapDecoder::CopyPalette for a not initialized case in the GIF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Better follow the GIF spec and don'\''t specify the local color table size if there is no local palette.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Fix behaviour of format converter for indexed formats when NULL or empty palette has been provided.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs/tests: Add a bunch of new tests for indexed format conversions.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs/tests: Add some tests for converting 24bppBGR to 8bppIndexed format.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs/tests: Add the tests for GIF encoder and decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs/tests: Add a missing check for IWICBitmapFrameDecode::GetPixelFormat return value.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Correctly indicate that the global info was written even without the global palette.", 1 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-IWICPalette_InitializeFromBitmap
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39890] Implement IWICPalette::InitializeFromBitmap
# |
# | Modified files:
# |   *	dlls/gdiplus/gdiplus.spec, dlls/gdiplus/image.c, dlls/gdiplus/tests/image.c, dlls/windowscodecs/palette.c,
# | 	dlls/windowscodecs/tests/palette.c, include/gdiplusflat.h
# |
if test "$enable_windowscodecs_IWICPalette_InitializeFromBitmap" -eq 1; then
	patch_apply windowscodecs-IWICPalette_InitializeFromBitmap/0001-windowscodecs-tests-Add-some-tests-for-IWICPalette-I.patch
	patch_apply windowscodecs-IWICPalette_InitializeFromBitmap/0002-windowscodecs-Implement-IWICPalette-InitializeFromBi.patch
	patch_apply windowscodecs-IWICPalette_InitializeFromBitmap/0003-gdiplus-Implement-GdipInitializePalette.-v2.patch
	patch_apply windowscodecs-IWICPalette_InitializeFromBitmap/0004-gdiplus-tests-Add-some-tests-for-GdipInitializePalet.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs/tests: Add some tests for IWICPalette::InitializeFromBitmap.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Implement IWICPalette::InitializeFromBitmap.", 5 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Implement GdipInitializePalette.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus/tests: Add some tests for GdipInitializePalette.", 2 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-TIFF_Support
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	windowscodecs-Palette_Images, windowscodecs-GIF_Encoder, windowscodecs-IWICPalette_InitializeFromBitmap
# |
# | Modified files:
# |   *	dlls/gdiplus/image.c, dlls/gdiplus/tests/image.c, dlls/windowscodecs/metadatahandler.c, dlls/windowscodecs/regsvr.c,
# | 	dlls/windowscodecs/tests/tiffformat.c, dlls/windowscodecs/tiffformat.c, include/wincodec.idl
# |
if test "$enable_windowscodecs_TIFF_Support" -eq 1; then
	patch_apply windowscodecs-TIFF_Support/0001-windowscodecs-tests-Add-a-test-for-8bpp-indexed-TIFF.patch
	patch_apply windowscodecs-TIFF_Support/0002-windowscodecs-tests-Make-the-test-for-8bpp-indexed-T.patch
	patch_apply windowscodecs-TIFF_Support/0003-windowscodecs-Fix-the-SupportsTransparency-flag-valu.patch
	patch_apply windowscodecs-TIFF_Support/0004-windowscodecs-Fail-earlier-in-TIFF-decoder-s-Initial.patch
	patch_apply windowscodecs-TIFF_Support/0005-windowscodecs-Avoid-redundant-checks-when-reading-a-.patch
	patch_apply windowscodecs-TIFF_Support/0006-windowscodecs-Add-support-for-16bppGray-and-32bppGra.patch
	patch_apply windowscodecs-TIFF_Support/0007-windowscodecs-Add-support-for-3bps-RGB-format-to-TIF.patch
	patch_apply windowscodecs-TIFF_Support/0008-windowscodecs-Add-support-for-12bpp-RGB-format-to-TI.patch
	patch_apply windowscodecs-TIFF_Support/0009-windowscodecs-Add-support-for-128bppRGBAFloat-format.patch
	patch_apply windowscodecs-TIFF_Support/0011-windowscodecs-Add-support-for-32bppCMYK-and-64bppCMY.patch
	patch_apply windowscodecs-TIFF_Support/0012-windowscodecs-Add-support-for-4bpp-RGBA-format-to-TI.patch
	patch_apply windowscodecs-TIFF_Support/0013-windowscodecs-Add-support-for-16bpp-RGBA-format-to-T.patch
	patch_apply windowscodecs-TIFF_Support/0014-windowscodecs-Add-some-tests-for-various-TIFF-color-.patch
	patch_apply windowscodecs-TIFF_Support/0015-windowscodecs-Tolerate-partial-reads-in-the-IFD-meta.patch
	patch_apply windowscodecs-TIFF_Support/0016-gdiplus-Add-support-for-more-image-color-formats.patch
	patch_apply windowscodecs-TIFF_Support/0017-gdiplus-tests-Add-some-tests-for-loading-TIFF-images.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs/tests: Add a test for 8bpp indexed TIFF format.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs/tests: Make the test for 8bpp indexed TIFF format run under XP.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Fix the SupportsTransparency flag value for various pixel formats.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Fail earlier in TIFF decoder'\''s Initialize method for unsupported pixel formats.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Avoid redundant checks when reading a TIFF tile.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 16bppGray and 32bppGrayFloat formats to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 3bps RGB format to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 12bpp RGB format to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 128bppRGBAFloat format to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 32bppCMYK and 64bppCMYK formats to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 4bpp RGBA format to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 16bpp RGBA format to TIFF decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add some tests for various TIFF color formats.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Tolerate partial reads in the IFD metadata loader.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus: Add support for more image color formats.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdiplus/tests: Add some tests for loading TIFF images in various color formats.", 1 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-32bppPRGBA
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	windowscodecs-Palette_Images, windowscodecs-GIF_Encoder, windowscodecs-IWICPalette_InitializeFromBitmap, windowscodecs-
# | 	TIFF_Support
# |
# | Modified files:
# |   *	dlls/windowscodecs/converter.c, dlls/windowscodecs/info.c, dlls/windowscodecs/regsvr.c,
# | 	dlls/windowscodecs/tests/converter.c
# |
if test "$enable_windowscodecs_32bppPRGBA" -eq 1; then
	patch_apply windowscodecs-32bppPRGBA/0001-windowscodecs-Add-support-for-32bppRGB-32bppRGBA-and.patch
	patch_apply windowscodecs-32bppPRGBA/0002-windowscodecs-Fix-32bppRGB-to-32bppRGBA-conversion.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for 32bppRGB, 32bppRGBA and 32bppPRGBA to format converter.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Fix 32bppRGB to 32bppRGBA conversion.", 1 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-IMILBitmapSource
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34764] Improve compatibility of IMILBitmapSource interface
# |
# | Modified files:
# |   *	dlls/windowscodecs/bitmap.c, dlls/windowscodecs/scaler.c, dlls/windowscodecs/wincodecs_private.h
# |
if test "$enable_windowscodecs_IMILBitmapSource" -eq 1; then
	patch_apply windowscodecs-IMILBitmapSource/0001-windowscodecs-Improve-compatibility-of-IMILBitmapSou.patch
	patch_apply windowscodecs-IMILBitmapSource/0002-windowscodecs-Add-support-for-IMILBitmapScaler-inter.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Improve compatibility of IMILBitmapSource interface.", 3 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for IMILBitmapScaler interface.", 2 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-JPEG_Decoder
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43520] Fix JPEG decoder and implement support for CMYK to BGR conversion
# |
# | Modified files:
# |   *	dlls/windowscodecs/converter.c, dlls/windowscodecs/jpegformat.c
# |
if test "$enable_windowscodecs_JPEG_Decoder" -eq 1; then
	patch_apply windowscodecs-JPEG_Decoder/0002-windowscodecs-Fix-stride-calculation-in-JPEG-decoder.patch
	patch_apply windowscodecs-JPEG_Decoder/0003-windowscodecs-Move-additional-processing-out-of-the-.patch
	patch_apply windowscodecs-JPEG_Decoder/0004-windowscodecs-Move-JPEG-frame-image-data-initializat.patch
	patch_apply windowscodecs-JPEG_Decoder/0005-windowscodecs-Add-support-for-CMYK-to-BGR-conversion.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Fix stride calculation in JPEG decoder.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Move additional processing out of the JPEG decoding loop.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Move JPEG frame image data initialization from Frame::CopyPixels to Decoder::Initialize.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Add support for CMYK to BGR conversion.", 1 },';
	) >> "$patchlist"
fi

# Patchset windowscodecs-WICCreateBitmapFromSection
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40273] Implement windowscodecs.WICCreateBitmapFromSection(Ex)
# |
# | Modified files:
# |   *	dlls/windowscodecs/bitmap.c, dlls/windowscodecs/imgfactory.c, dlls/windowscodecs/windowscodecs.spec,
# | 	include/wincodec.idl
# |
if test "$enable_windowscodecs_WICCreateBitmapFromSection" -eq 1; then
	patch_apply windowscodecs-WICCreateBitmapFromSection/0001-windowscodecs-Implement-WICCreateBitmapFromSection-E.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "windowscodecs: Implement WICCreateBitmapFromSection(Ex).", 2 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-Directory_ContextMenuHandlers
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29523] Add 'New' context menu handler entry for directories
# |
# | Modified files:
# |   *	loader/wine.inf.in
# |
if test "$enable_wine_inf_Directory_ContextMenuHandlers" -eq 1; then
	patch_apply wine.inf-Directory_ContextMenuHandlers/0001-wine.inf-Add-New-context-menu-handler-entry-for-dire.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wine.inf: Add '\''New'\'' context menu handler entry for directories.", 1 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-Dummy_CA_Certificate
# |
# | Modified files:
# |   *	loader/wine.inf.in
# |
if test "$enable_wine_inf_Dummy_CA_Certificate" -eq 1; then
	patch_apply wine.inf-Dummy_CA_Certificate/0001-wine.inf.in-Add-invalid-dummy-certificate-to-CA-cert.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wine.inf.in: Add invalid dummy certificate to CA certificate store.", 1 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-Performance
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33661] Add performance library registry keys needed by MS SQL Server Management Studio Express 2008 R2
# |
# | Modified files:
# |   *	dlls/advapi32/tests/registry.c, loader/wine.inf.in
# |
if test "$enable_wine_inf_Performance" -eq 1; then
	patch_apply wine.inf-Performance/0001-wine.inf-Add-registry-keys-for-Windows-Performance-L.patch
	patch_apply wine.inf-Performance/0002-wine.inf-Add-Counters-to-the-perflib-key-as-an-alias.patch
	patch_apply wine.inf-Performance/0003-advapi32-tests-Add-test-for-perflib-registry-key.patch
	(
		printf '%s\n' '+    { "Daniel Jelinski", "wine.inf: Add registry keys for Windows Performance Library.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "wine.inf: Add '\''Counters'\'' to the perflib key as an alias for '\''Counter'\''.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "advapi32/tests: Add test for perflib registry key.", 1 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-ProfileList_UserSID
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#15670] Add a ProfileList\<UserSID> registry subkey
# |   *	[#42249] Add a ProfileImagePath key with users profile directory
# |
# | Modified files:
# |   *	loader/wine.inf.in
# |
if test "$enable_wine_inf_ProfileList_UserSID" -eq 1; then
	patch_apply wine.inf-ProfileList_UserSID/0001-wine.inf-Add-a-ProfileList-UserSID-registry-subkey.patch
	patch_apply wine.inf-ProfileList_UserSID/0002-wine.inf-Add-ProfileImagePath-with-the-user-s-profil.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wine.inf: Add a ProfileList\\<UserSID> registry subkey.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "wine.inf: Add \"ProfileImagePath\" with the user'\''s profile directory under ProfileList key.", 1 },';
	) >> "$patchlist"
fi

# Patchset wine.inf-WMP_12
# |
# | Modified files:
# |   *	loader/wine.inf.in
# |
if test "$enable_wine_inf_WMP_12" -eq 1; then
	patch_apply wine.inf-WMP_12/0001-wine.inf-Add-WMP-12-as-installed-windows-feature.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wine.inf: Add WMP 12 as installed windows feature.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineboot-DriveSerial
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#17823] Assign a drive serial number during prefix creation/update
# |
# | Modified files:
# |   *	programs/wineboot/wineboot.c
# |
if test "$enable_wineboot_DriveSerial" -eq 1; then
	patch_apply wineboot-DriveSerial/0001-wineboot-Assign-a-drive-serial-number-during-prefix-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wineboot: Assign a drive serial number during prefix creation/update.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineboot-HKEY_DYN_DATA
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#7115] Need for Speed 3 installer requires devices in HKEY_DYN_DATA
# |
# | Modified files:
# |   *	programs/wineboot/wineboot.c
# |
if test "$enable_wineboot_HKEY_DYN_DATA" -eq 1; then
	patch_apply wineboot-HKEY_DYN_DATA/0001-wineboot-Add-some-generic-hardware-in-HKEY_DYN_DATA-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wineboot: Add some generic hardware in HKEY_DYN_DATA\\Config Manager\\Enum.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineboot-drivers_etc_Stubs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#12076] Create stub files for system32/drivers/etc/{services,hosts,networks,protocol}
# |
# | Modified files:
# |   *	programs/wineboot/wineboot.c
# |
if test "$enable_wineboot_drivers_etc_Stubs" -eq 1; then
	patch_apply wineboot-drivers_etc_Stubs/0001-wineboot-Init-system32-drivers-etc-host-networks-pro.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wineboot: Init system32/drivers/etc/{host,networks,protocol,services}.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineboot-ProxySettings
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	wineboot-DriveSerial, wineboot-drivers_etc_Stubs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42024] Create ProxyEnable key on wineprefix update
# |
# | Modified files:
# |   *	programs/wineboot/Makefile.in, programs/wineboot/wineboot.c
# |
if test "$enable_wineboot_ProxySettings" -eq 1; then
	patch_apply wineboot-ProxySettings/0001-wineboot-Initialize-proxy-settings-registry-key.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wineboot: Initialize proxy settings registry key.", 1 },';
	) >> "$patchlist"
fi

# Patchset winebuild-Fake_Dlls
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	ntdll-Attach_Process_DLLs, ntdll-ThreadTime, ntdll-Hide_Wine_Exports, ntdll-x86_64_ExceptionInformation, ntdll-
# | 	User_Shared_Data
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42741] Various improvements for fake dlls
# |
# | Modified files:
# |   *	dlls/dbghelp/cpu_i386.c, dlls/kernel32/tests/loader.c, dlls/krnl386.exe16/kernel.c,
# | 	dlls/krnl386.exe16/kernel16_private.h, dlls/krnl386.exe16/ne_module.c, dlls/krnl386.exe16/ne_segment.c,
# | 	dlls/krnl386.exe16/task.c, dlls/krnl386.exe16/thunk.c, dlls/krnl386.exe16/wowthunk.c, dlls/ntdll/signal_i386.c,
# | 	dlls/ntdll/signal_x86_64.c, dlls/ntdll/tests/exception.c, dlls/ntdll/thread.c, dlls/system.drv16/system.c,
# | 	dlls/toolhelp.dll16/toolhelp.c, dlls/user.exe16/message.c, dlls/user.exe16/user.c, dlls/user.exe16/window.c,
# | 	include/winternl.h, libs/wine/loader.c, tools/winebuild/build.h, tools/winebuild/import.c, tools/winebuild/parser.c,
# | 	tools/winebuild/relay.c, tools/winebuild/res32.c, tools/winebuild/spec16.c, tools/winebuild/spec32.c,
# | 	tools/winebuild/utils.c
# |
if test "$enable_winebuild_Fake_Dlls" -eq 1; then
	patch_apply winebuild-Fake_Dlls/0001-kernel32-tests-Add-basic-tests-for-fake-dlls.patch
	patch_apply winebuild-Fake_Dlls/0002-krnl386.exe16-Do-not-abuse-WOW32Reserved-field-for-1.patch
	patch_apply winebuild-Fake_Dlls/0003-winebuild-Generate-syscall-thunks-for-ntdll-exports.patch
	patch_apply winebuild-Fake_Dlls/0004-winebuild-Use-multipass-label-system-to-generate-fak.patch
	patch_apply winebuild-Fake_Dlls/0005-winebuild-Add-stub-functions-in-fake-dlls.patch
	patch_apply winebuild-Fake_Dlls/0006-winebuild-Add-syscall-thunks-in-fake-dlls.patch
	patch_apply winebuild-Fake_Dlls/0007-winebuild-Fix-size-of-relocation-information-in-fake.patch
	patch_apply winebuild-Fake_Dlls/0008-winebuild-Try-to-make-sure-RVA-matches-between-fake-.patch
	patch_apply winebuild-Fake_Dlls/0009-libs-wine-Use-same-file-alignment-for-fake-and-built.patch
	patch_apply winebuild-Fake_Dlls/0010-tools-winebuild-Add-syscall-thunks-for-64-bit.patch
	(
		printf '%s\n' '+    { "Michael Müller", "kernel32/tests: Add basic tests for fake dlls.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "krnl386.exe16: Do not abuse WOW32Reserved field for 16-bit stack address.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winebuild: Generate syscall thunks for ntdll exports.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winebuild: Use multipass label system to generate fake dlls.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winebuild: Add stub functions in fake dlls.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winebuild: Add syscall thunks in fake dlls.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winebuild: Fix size of relocation information in fake dlls.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winebuild: Try to make sure RVA matches between fake and builtin DLLs.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "libs/wine: Use same file alignment for fake and builtin DLLs.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "tools/winebuild: Add syscall thunks for 64 bit.", 1 },';
	) >> "$patchlist"
fi

# Patchset winecfg-Libraries
# |
# | Modified files:
# |   *	programs/winecfg/libraries.c
# |
if test "$enable_winecfg_Libraries" -eq 1; then
	patch_apply winecfg-Libraries/0001-winecfg-Double-click-in-dlls-list-to-edit-item-s-ove.patch
	(
		printf '%s\n' '+    { "Hao Peng", "winecfg: Double click in dlls list to edit item'\''s overides.", 3 },';
	) >> "$patchlist"
fi

# Patchset winecfg-Staging
# |
# | Modified files:
# |   *	programs/winecfg/Makefile.in, programs/winecfg/about.c, programs/winecfg/main.c, programs/winecfg/resource.h,
# | 	programs/winecfg/staging.c, programs/winecfg/winecfg.h, programs/winecfg/winecfg.rc
# |
if test "$enable_winecfg_Staging" -eq 1; then
	patch_apply winecfg-Staging/0001-winecfg-Add-staging-tab-for-CSMT.patch
	patch_apply winecfg-Staging/0002-winecfg-Add-checkbox-to-enable-disable-vaapi-GPU-dec.patch
	patch_apply winecfg-Staging/0003-winecfg-Add-checkbox-to-enable-disable-EAX-support.patch
	patch_apply winecfg-Staging/0004-winecfg-Add-checkbox-to-enable-disable-HideWineExpor.patch
	patch_apply winecfg-Staging/0005-winecfg-Add-option-to-enable-disable-GTK3-theming.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winecfg: Add staging tab for CSMT.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "winecfg: Add checkbox to enable/disable vaapi GPU decoder.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winecfg: Add checkbox to enable/disable EAX support.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "winecfg: Add checkbox to enable/disable HideWineExports registry key.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "winecfg: Add option to enable/disable GTK3 theming.", 1 },';
	) >> "$patchlist"
fi

# Patchset winecfg-Unmounted_Devices
# |
# | Modified files:
# |   *	programs/winecfg/drive.c, programs/winecfg/drivedetect.c, programs/winecfg/driveui.c
# |
if test "$enable_winecfg_Unmounted_Devices" -eq 1; then
	patch_apply winecfg-Unmounted_Devices/0001-winecfg-Show-unmounted-devices-and-allow-changing-th.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winecfg: Show unmounted devices and allow changing the device value.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Accounting
# |
# | Modified files:
# |   *	dlls/d3d9/tests/device.c, dlls/wined3d/device.c, dlls/wined3d/directx.c, dlls/wined3d/wined3d_gl.h
# |
if test "$enable_wined3d_Accounting" -eq 1; then
	patch_apply wined3d-Accounting/0001-wined3d-Use-real-values-for-memory-accounting-on-NVI.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Use real values for memory accounting on NVIDIA cards.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Copy_Resource_Typeless
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3d11-Depth_Bias, wined3d-1DTextures
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43264] Implement copying resources between compatible formats
# |   *	[#42099] Implement copying resources between compatible formats
# |
# | Modified files:
# |   *	dlls/d3d11/tests/d3d11.c, dlls/wined3d/cs.c, dlls/wined3d/device.c, dlls/wined3d/directx.c, dlls/wined3d/utils.c,
# | 	dlls/wined3d/wined3d_gl.h, dlls/wined3d/wined3d_private.h
# |
if test "$enable_wined3d_Copy_Resource_Typeless" -eq 1; then
	patch_apply wined3d-Copy_Resource_Typeless/0001-d3d11-tests-Add-more-advanced-CopySubresourceRegion-.patch
	patch_apply wined3d-Copy_Resource_Typeless/0002-wined3d-Add-WINED3DFMT_R8G8B8A8_SNORM-to-WINED3DFMT_.patch
	patch_apply wined3d-Copy_Resource_Typeless/0003-wined3d-Implement-copying-sub-resources-between-comp.patch
	patch_apply wined3d-Copy_Resource_Typeless/0004-wined3d-Use-wined3d_cs_emit_copy_sub_resource-also-f.patch
	(
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Add more advanced CopySubresourceRegion tests.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Add WINED3DFMT_R8G8B8A8_SNORM to WINED3DFMT_R8G8B8A8_TYPELESS group.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement copying sub resources between compatible formats.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Use wined3d_cs_emit_copy_sub_resource also for wined3d_device_copy_resource.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Core_Context
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3d11-Depth_Bias
# |
# | Modified files:
# |   *	dlls/dxgi/factory.c, dlls/wined3d/directx.c, include/wine/wined3d.h
# |
if test "$enable_wined3d_Core_Context" -eq 1; then
	patch_apply wined3d-Core_Context/0001-wined3d-Use-OpenGL-core-context-for-D3D10-11-when-ne.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Use OpenGL core context for D3D10/11 when necessary.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Viewports
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3d11-Depth_Bias, wined3d-Core_Context
# |
# | Modified files:
# |   *	dlls/d3d11/tests/d3d11.c, dlls/d3d8/directx.c, dlls/d3d9/directx.c, dlls/ddraw/ddraw_private.h, dlls/wined3d/state.c,
# | 	include/wine/wined3d.h
# |
if test "$enable_wined3d_Viewports" -eq 1; then
	patch_apply wined3d-Viewports/0001-wined3d-Allow-arbitrary-viewports-for-d3d11.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Allow arbitrary viewports for d3d11.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Dual_Source_Blending
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3d11-Depth_Bias, wined3d-Core_Context, wined3d-Viewports
# |
# | Modified files:
# |   *	dlls/d3d11/tests/d3d11.c, dlls/wined3d/context.c, dlls/wined3d/directx.c, dlls/wined3d/glsl_shader.c,
# | 	dlls/wined3d/shader.c, dlls/wined3d/state.c, dlls/wined3d/wined3d_private.h
# |
if test "$enable_wined3d_Dual_Source_Blending" -eq 1; then
	patch_apply wined3d-Dual_Source_Blending/0001-wined3d-Unroll-glsl-pixel-shader-output.patch
	patch_apply wined3d-Dual_Source_Blending/0002-d3d11-tests-Add-basic-dual-source-blend-test.patch
	patch_apply wined3d-Dual_Source_Blending/0003-wined3d-Implement-dual-source-blending.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Unroll glsl pixel shader output.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Add basic dual source blend test.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement dual source blending.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-GenerateMips
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3d11-Depth_Bias, wined3d-1DTextures, wined3d-Copy_Resource_Typeless, wined3d-Core_Context, wined3d-Viewports, wined3d-
# | 	Dual_Source_Blending
# |
# | Modified files:
# |   *	dlls/d3d11/device.c, dlls/d3d11/tests/d3d11.c, dlls/wined3d/cs.c, dlls/wined3d/device.c, dlls/wined3d/texture.c,
# | 	dlls/wined3d/wined3d.spec, dlls/wined3d/wined3d_private.h, include/wine/wined3d.h
# |
if test "$enable_wined3d_GenerateMips" -eq 1; then
	patch_apply wined3d-GenerateMips/0001-d3d11-tests-Add-basic-test-for-mipmap-level-generati.patch
	patch_apply wined3d-GenerateMips/0002-wined3d-Implement-generation-of-mip-maps-for-shader-.patch
	patch_apply wined3d-GenerateMips/0003-d3d11-Implement-d3d10_device_GenerateMips.patch
	(
		printf '%s\n' '+    { "Michael Müller", "d3d11/tests: Add basic test for mipmap level generation.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement generation of mip maps for shader resource views.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d11: Implement d3d10_device_GenerateMips.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-QUERY_Stubs
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#20776] Add stubs for QUERY_TYPE_SO_STATISTICS and QUERY_TYPE_SO_OVERFLOW
# |
# | Modified files:
# |   *	dlls/d3d10core/tests/device.c, dlls/d3d11/tests/d3d11.c, dlls/wined3d/query.c
# |
if test "$enable_wined3d_QUERY_Stubs" -eq 1; then
	patch_apply wined3d-QUERY_Stubs/0001-wined3d-Add-stubs-for-QUERY_TYPE_SO_STATISTICS-and-Q.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Add stubs for QUERY_TYPE_SO_STATISTICS and QUERY_TYPE_SO_OVERFLOW.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Revert_Buffer_Upload
# |
# | Modified files:
# |   *	dlls/wined3d/buffer.c, dlls/wined3d/cs.c, dlls/wined3d/wined3d_private.h
# |
if test "$enable_wined3d_Revert_Buffer_Upload" -eq 1; then
	patch_apply wined3d-Revert_Buffer_Upload/0001-Revert-wined3d-Implement-wined3d_buffer_upload_data-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "Revert \"wined3d: Implement wined3d_buffer_upload_data() on top of wined3d_buffer_upload_ranges().\".", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Silence_FIXMEs
# |
# | Modified files:
# |   *	dlls/wined3d/resource.c, dlls/wined3d/surface.c, dlls/wined3d/swapchain.c, dlls/wined3d/texture.c
# |
if test "$enable_wined3d_Silence_FIXMEs" -eq 1; then
	patch_apply wined3d-Silence_FIXMEs/0003-wined3d-Silence-repeated-resource_check_usage-FIXME.patch
	patch_apply wined3d-Silence_FIXMEs/0004-wined3d-Print-FIXME-only-once-in-surface_cpu_blt.patch
	patch_apply wined3d-Silence_FIXMEs/0005-wined3d-Silence-repeated-wined3d_swapchain_present-F.patch
	patch_apply wined3d-Silence_FIXMEs/0006-wined3d-Silence-extremely-noisy-FIXME-in-wined3d_tex.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "wined3d: Silence repeated resource_check_usage FIXME.", 2 },';
		printf '%s\n' '+    { "Christian Costa", "wined3d: Print FIXME only once in surface_cpu_blt.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "wined3d: Silence repeated wined3d_swapchain_present FIXME.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "wined3d: Silence extremely noisy FIXME in wined3d_texture_add_dirty_region.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-UAV_Counters
# |
# | Modified files:
# |   *	dlls/d3d11/device.c, dlls/wined3d/cs.c, dlls/wined3d/device.c
# |
if test "$enable_wined3d_UAV_Counters" -eq 1; then
	patch_apply wined3d-UAV_Counters/0001-wined3d-Remaining-UAV-counter-changes.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wined3d: Remaining UAV counter changes.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-CSMT_Helper
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3d11-ResolveSubresource, wined3d-1DTextures, d3d11-Deferred_Context, d3d9-Tests, makedep-PARENTSPEC, ntdll-
# | 	Attach_Process_DLLs, ntdll-DllOverrides_WOW64, ntdll-Loader_Machine_Type, ntdll-DllRedirects, wined3d-Accounting,
# | 	d3d11-Depth_Bias, wined3d-Copy_Resource_Typeless, wined3d-DXTn, wined3d-Core_Context, wined3d-Viewports, wined3d-
# | 	Dual_Source_Blending, wined3d-GenerateMips, wined3d-QUERY_Stubs, wined3d-Revert_Buffer_Upload, wined3d-Silence_FIXMEs,
# | 	wined3d-UAV_Counters
# |
# | Modified files:
# |   *	configure.ac, dlls/wined3d-csmt/Makefile.in, dlls/wined3d-csmt/version.rc
# |
if test "$enable_wined3d_CSMT_Helper" -eq 1; then
	patch_apply wined3d-CSMT_Helper/0001-wined3d-Add-second-dll-with-STAGING_CSMT-definition-.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wined3d: Add second dll with STAGING_CSMT definition set.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-GTX_560M
# |
# | Modified files:
# |   *	dlls/wined3d/directx.c, dlls/wined3d/wined3d_private.h
# |
if test "$enable_wined3d_GTX_560M" -eq 1; then
	patch_apply wined3d-GTX_560M/0001-wined3d-Recognize-GTX-560M-card-with-NVIDIA-driver.patch
	(
		printf '%s\n' '+    { "Christian Costa", "wined3d: Recognize GTX 560M card with NVIDIA driver.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-WINED3D_RS_COLORWRITEENABLE
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3d11-Depth_Bias
# |
# | Modified files:
# |   *	dlls/d3d11/device.c, dlls/d3d11/state.c, dlls/wined3d/context.c, dlls/wined3d/device.c, dlls/wined3d/drawprim.c,
# | 	dlls/wined3d/state.c, dlls/wined3d/stateblock.c, dlls/wined3d/surface.c, dlls/wined3d/utils.c,
# | 	dlls/wined3d/wined3d_private.h, include/wine/wined3d.h
# |
if test "$enable_wined3d_WINED3D_RS_COLORWRITEENABLE" -eq 1; then
	patch_apply wined3d-WINED3D_RS_COLORWRITEENABLE/0001-wined3d-Implement-all-8-d3d11-color-write-masks.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement all 8 d3d11 color write masks.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Indexed_Vertex_Blending
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3d11-Depth_Bias, wined3d-WINED3D_RS_COLORWRITEENABLE
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39057] Support for indexed vertex blending
# |
# | Modified files:
# |   *	dlls/d3d9/tests/visual.c, dlls/wined3d/device.c, dlls/wined3d/directx.c, dlls/wined3d/drawprim.c,
# | 	dlls/wined3d/glsl_shader.c, dlls/wined3d/utils.c, dlls/wined3d/vertexdeclaration.c, dlls/wined3d/wined3d_private.h
# |
if test "$enable_wined3d_Indexed_Vertex_Blending" -eq 1; then
	patch_apply wined3d-Indexed_Vertex_Blending/0001-d3d9-tests-Add-test-for-indexed-vertex-blending.patch
	patch_apply wined3d-Indexed_Vertex_Blending/0002-wined3d-Implement-hardware-indexed-vertex-blending-w.patch
	patch_apply wined3d-Indexed_Vertex_Blending/0003-d3d9-tests-Test-normal-calculation-when-indexed-vert.patch
	patch_apply wined3d-Indexed_Vertex_Blending/0004-wined3d-Fix-calculation-of-normal-when-vertex-blendi.patch
	patch_apply wined3d-Indexed_Vertex_Blending/0005-wined3d-Move-matrix-inversion-functions-into-utils.c.patch
	patch_apply wined3d-Indexed_Vertex_Blending/0006-wined3d-Implement-software-processing-for-indexed-ve.patch
	patch_apply wined3d-Indexed_Vertex_Blending/0007-d3d9-tests-Check-MaxVertexBlendMatrixIndex-capabilit.patch
	patch_apply wined3d-Indexed_Vertex_Blending/0008-wined3d-Report-correct-number-of-blend-matrices-when.patch
	patch_apply wined3d-Indexed_Vertex_Blending/0009-wined3d-Track-updates-of-vertex-blend-matrices-separ.patch
	(
		printf '%s\n' '+    { "Paul Gofman", "d3d9/tests: Add test for indexed vertex blending.", 1 },';
		printf '%s\n' '+    { "Paul Gofman", "wined3d: Implement hardware indexed vertex blending with 9 matrices.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d9/tests: Test normal calculation when indexed vertex blending is enabled.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Fix calculation of normal when vertex blending is enabled.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Move matrix inversion functions into utils.c.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement software processing for indexed vertex blending.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "d3d9/tests: Check MaxVertexBlendMatrixIndex capability.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Report correct number of blend matrices when software vertex processing is used.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "wined3d: Track updates of vertex blend matrices separately.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Limit_Vram
# |
# | Modified files:
# |   *	dlls/wined3d/directx.c
# |
if test "$enable_wined3d_Limit_Vram" -eq 1; then
	patch_apply wined3d-Limit_Vram/0001-wined3d-Limit-the-vram-memory-to-LONG_MAX-only-on-32.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Limit the vram memory to LONG_MAX only on 32 bit.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-Revert_Surface_Blt
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43627] Revert patch which causes rendering issue in AoE2
# |
# | Modified files:
# |   *	dlls/wined3d/surface.c
# |
if test "$enable_wined3d_Revert_Surface_Blt" -eq 1; then
	patch_apply wined3d-Revert_Surface_Blt/0001-Revert-wined3d-Drop-the-special-case-for-converted-s.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "Revert \"wined3d: Drop the special case for \"converted\" surfaces in wined3d_surface_blt().\".", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-WINED3DFMT_R32G32_UINT
# |
# | Modified files:
# |   *	dlls/wined3d/utils.c
# |
if test "$enable_wined3d_WINED3DFMT_R32G32_UINT" -eq 1; then
	patch_apply wined3d-WINED3DFMT_R32G32_UINT/0002-wined3d-Add-hack-for-WINED3DFMT_R24_UNORM_X8_TYPELES.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Add hack for WINED3DFMT_R24_UNORM_X8_TYPELESS.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-buffer_create
# |
# | Modified files:
# |   *	dlls/wined3d/buffer.c
# |
if test "$enable_wined3d_buffer_create" -eq 1; then
	patch_apply wined3d-buffer_create/0001-wined3d-Do-not-pin-large-buffers.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Do not pin large buffers.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-dxgi_swapchain_Present
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	dxgi-DXGI_PRESENT_TEST, wined3d-Silence_FIXMEs
# |
# | Modified files:
# |   *	dlls/d3d8/swapchain.c, dlls/d3d9/device.c, dlls/d3d9/swapchain.c, dlls/dxgi/swapchain.c, dlls/wined3d/cs.c,
# | 	dlls/wined3d/surface.c, dlls/wined3d/swapchain.c, dlls/wined3d/wined3d.spec, dlls/wined3d/wined3d_private.h,
# | 	include/wine/wined3d.h
# |
if test "$enable_wined3d_dxgi_swapchain_Present" -eq 1; then
	patch_apply wined3d-dxgi_swapchain_Present/0001-wined3d-Implement-updating-swap-interval-through-win.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Implement updating swap interval through wined3d_swapchain_present.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-sample_c_lz
# |
# | Modified files:
# |   *	dlls/wined3d/glsl_shader.c
# |
if test "$enable_wined3d_sample_c_lz" -eq 1; then
	patch_apply wined3d-sample_c_lz/0001-wined3d-Emulate-sample_c_lz-using-textureGradOffset-.patch
	patch_apply wined3d-sample_c_lz/0002-wined3d-Emulate-textureLod-samplerCubeShadow-.-using.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wined3d: Emulate sample_c_lz using textureGradOffset for sampler2DArrayShadow.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Emulate textureLod(samplerCubeShadow, ...) using shadowCubeGrad.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-wined3d_guess_gl_vendor
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42538] Add check for GL_VENDOR = "Brian Paul" to detect Mesa
# |
# | Modified files:
# |   *	dlls/wined3d/directx.c
# |
if test "$enable_wined3d_wined3d_guess_gl_vendor" -eq 1; then
	patch_apply wined3d-wined3d_guess_gl_vendor/0001-wined3d-Also-check-for-Brian-Paul-to-detect-Mesa-gl_.patch
	(
		printf '%s\n' '+    { "Jarkko Korpi", "wined3d: Also check for '\''Brian Paul'\'' to detect Mesa gl_vendor.", 1 },';
	) >> "$patchlist"
fi

# Patchset wined3d-CSMT_Main
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	d3d11-ResolveSubresource, wined3d-1DTextures, d3d11-Deferred_Context, d3d9-Tests, makedep-PARENTSPEC, ntdll-
# | 	Attach_Process_DLLs, ntdll-DllOverrides_WOW64, ntdll-Loader_Machine_Type, ntdll-DllRedirects, wined3d-Accounting,
# | 	d3d11-Depth_Bias, wined3d-Copy_Resource_Typeless, wined3d-DXTn, wined3d-Core_Context, wined3d-Viewports, wined3d-
# | 	Dual_Source_Blending, wined3d-GenerateMips, wined3d-QUERY_Stubs, wined3d-Revert_Buffer_Upload, wined3d-Silence_FIXMEs,
# | 	wined3d-UAV_Counters, wined3d-CSMT_Helper
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#11674] Support for CSMT (command stream) to increase graphic performance
# |
# | Modified files:
# |   *	dlls/wined3d/buffer.c, dlls/wined3d/cs.c, dlls/wined3d/device.c, dlls/wined3d/surface.c, dlls/wined3d/swapchain.c,
# | 	dlls/wined3d/texture.c, dlls/wined3d/view.c, dlls/wined3d/wined3d_main.c, dlls/wined3d/wined3d_private.h
# |
if test "$enable_wined3d_CSMT_Main" -eq 1; then
	patch_apply wined3d-CSMT_Main/9999-IfDefined.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wined3d: Add additional synchronization CS ops.", 1 },';
		printf '%s\n' '+    { "Stefan Dösinger", "wined3d: Send blits through the command stream.", 1 },';
		printf '%s\n' '+    { "Stefan Dösinger", "wined3d: Wrap GL BOs in a structure.", 1 },';
		printf '%s\n' '+    { "Stefan Dösinger", "wined3d: Don'\''t call glFinish before swapping.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "wined3d: Reset context before destruction.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Improve wined3d_cs_emit_update_sub_resource.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wined3d: Discard buffer during upload when replacing complete content.", 1 },';
	) >> "$patchlist"
fi

# Patchset winedbg-Process_Arguments
# |
# | Modified files:
# |   *	programs/winedbg/info.c
# |
if test "$enable_winedbg_Process_Arguments" -eq 1; then
	patch_apply winedbg-Process_Arguments/0001-programs-winedbg-Print-process-arguments-in-info-thr.patch
	(
		printf '%s\n' '+    { "Michael Müller", "programs/winedbg: Print process arguments in info threads.", 1 },';
	) >> "$patchlist"
fi

# Patchset winedevice-Fix_Relocation
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#28254] Fix crash of winedevice when relocation entry crosses page boundary
# |
# | Modified files:
# |   *	programs/winedevice/device.c
# |
if test "$enable_winedevice_Fix_Relocation" -eq 1; then
	patch_apply winedevice-Fix_Relocation/0001-winedevice-Avoid-invalid-memory-access-when-relocati.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winedevice: Avoid invalid memory access when relocation block addresses memory outside of the current page.", 1 },';
	) >> "$patchlist"
fi

# Patchset winemenubuilder-Desktop_Icon_Path
# |
# | Modified files:
# |   *	programs/winemenubuilder/Makefile.in, programs/winemenubuilder/winemenubuilder.c
# |
if test "$enable_winemenubuilder_Desktop_Icon_Path" -eq 1; then
	patch_apply winemenubuilder-Desktop_Icon_Path/0001-winemenubuilder-Create-desktop-shortcuts-with-absolu.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winemenubuilder: Create desktop shortcuts with absolute wine path.", 1 },';
	) >> "$patchlist"
fi

# Patchset winemp3.acm-MPEG3_StreamOpen
# |
# | Modified files:
# |   *	dlls/l3codeca.acm/mpegl3.c, dlls/msacm32/tests/msacm.c
# |
if test "$enable_winemp3_acm_MPEG3_StreamOpen" -eq 1; then
	patch_apply winemp3.acm-MPEG3_StreamOpen/0001-winemp3.acm-Check-input-format-in-MPEG3_StreamOpen.patch
	(
		printf '%s\n' '+    { "Michael Müller", "l3codeca.acm: Check input format in MPEG3_StreamOpen.", 1 },';
	) >> "$patchlist"
fi

# Patchset wineps.drv-PostScript_Fixes
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#4836] Various improvements for wineps.drv for Adobe PageMaker compatibility
# |
# | Modified files:
# |   *	dlls/gdi32/printdrv.c, dlls/gdi32/tests/dc.c, dlls/wineps.drv/download.c, dlls/wineps.drv/escape.c,
# | 	dlls/wineps.drv/psdrv.h
# |
if test "$enable_wineps_drv_PostScript_Fixes" -eq 1; then
	patch_apply wineps.drv-PostScript_Fixes/0001-gdi32-tests-Add-a-simple-test-for-printing-to-a-Post.patch
	patch_apply wineps.drv-PostScript_Fixes/0002-gdi32-Trace-full-contents-of-DOCINFO-in-StartDoc.patch
	patch_apply wineps.drv-PostScript_Fixes/0003-wineps.drv-Add-stubs-for-escapes-required-by-Adobe-P.patch
	patch_apply wineps.drv-PostScript_Fixes/0004-wineps.drv-Add-support-for-GETFACENAME-and-DOWNLOADF.patch
	patch_apply wineps.drv-PostScript_Fixes/0005-wineps.drv-PostScript-header-should-be-written-by-St.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdi32/tests: Add a simple test for printing to a PostScript device.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "gdi32: Trace full contents of DOCINFO in StartDoc.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "wineps.drv: Add stubs for escapes required by Adobe PageMaker.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "wineps.drv: Add support for GETFACENAME and DOWNLOADFACE escapes.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "wineps.drv: PostScript header should be written by StartDoc instead of StartPage.", 1 },';
	) >> "$patchlist"
fi

# Patchset winepulse-PulseAudio_Support
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37042] Implement exclusive mode in PulseAudio backend
# |
# | Modified files:
# |   *	dlls/mmdevapi/tests/render.c, dlls/winepulse.drv/Makefile.in, dlls/winepulse.drv/mmdevdrv.c
# |
if test "$enable_winepulse_PulseAudio_Support" -eq 1; then
	patch_apply winepulse-PulseAudio_Support/0001-winepulse.drv-Use-a-separate-mainloop-and-ctx-for-pu.patch
	patch_apply winepulse-PulseAudio_Support/0002-winepulse-expose-audio-devices-directly-to-programs.patch
	patch_apply winepulse-PulseAudio_Support/0003-winepulse-implement-exclusive-mode.patch
	patch_apply winepulse-PulseAudio_Support/0004-winepulse-fix-segfault-in-pulse_rd_loop.patch
	patch_apply winepulse-PulseAudio_Support/0005-winepulse-implement-GetPropValue.patch
	patch_apply winepulse-PulseAudio_Support/0006-winepulse-fetch-actual-program-name-if-possible.patch
	patch_apply winepulse-PulseAudio_Support/0007-winepulse-return-PKEY_AudioEndpoint_PhysicalSpeakers.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winepulse.drv: Use a separate mainloop and ctx for pulse_test_connect.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winepulse: Expose audio devices directly to programs.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winepulse: Implement exclusive mode.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winepulse: Fix segfault in pulse_rd_loop.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winepulse: Implement GetPropValue.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winepulse: Fetch actual program name if possible.", 1 },';
		printf '%s\n' '+    { "Mark Harmstone", "winepulse: Return PKEY_AudioEndpoint_PhysicalSpeakers device prop.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-CandidateWindowPos
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#30938] Update a XIM candidate position when cursor location changes
# |
# | Modified files:
# |   *	dlls/user32/caret.c, dlls/user32/driver.c, dlls/user32/user_private.h, dlls/winex11.drv/winex11.drv.spec,
# | 	dlls/winex11.drv/xim.c
# |
if test "$enable_winex11_CandidateWindowPos" -eq 1; then
	patch_apply winex11-CandidateWindowPos/0001-winex11.drv-Update-a-candidate-window-s-position-wit.patch
	(
		printf '%s\n' '+    { "Felix Yan", "winex11.drv: Update a candidate window'\''s position with over-the-spot style.", 2 },';
	) >> "$patchlist"
fi

# Patchset winex11-ClipCursor
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#38087] Fix multithreading issues with fullscreen clipping
# |
# | Modified files:
# |   *	dlls/winex11.drv/mouse.c
# |
if test "$enable_winex11_ClipCursor" -eq 1; then
	patch_apply winex11-ClipCursor/0001-winex11-Forward-all-clipping-requests-to-the-right-t.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winex11: Forward all clipping requests to the right thread (including fullscreen clipping).", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-DefaultDisplayFrequency
# |
# | Modified files:
# |   *	dlls/winex11.drv/settings.c, dlls/winex11.drv/x11drv.h, dlls/winex11.drv/x11drv_main.c
# |
if test "$enable_winex11_DefaultDisplayFrequency" -eq 1; then
	patch_apply winex11-DefaultDisplayFrequency/0001-winex11.drv-Allow-to-select-default-display-frequenc.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winex11.drv: Allow to select default display frequency in registry key.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-MWM_Decorations
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42117] Avoid double captions observed under some WMs
# |
# | Modified files:
# |   *	dlls/winex11.drv/window.c
# |
if test "$enable_winex11_MWM_Decorations" -eq 1; then
	patch_apply winex11-MWM_Decorations/0001-winex11.drv-Don-t-use-MWM_DECOR_RESIZEH-window-resiz.patch
	patch_apply winex11-MWM_Decorations/0002-winex11.drv-Don-t-add-MWM_DECOR_BORDER-to-windows-wi.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "winex11.drv: Don'\''t use MWM_DECOR_RESIZEH, window resizing is controlled by MWM_FUNC_RESIZE.", 1 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "winex11.drv: Don'\''t add MWM_DECOR_BORDER to windows without a caption.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-SC_KEYMENU
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#21918] Send SC_KEYMENU on managed windows
# |
# | Modified files:
# |   *	dlls/user32/tests/msg.c, dlls/winex11.drv/window.c
# |
if test "$enable_winex11_SC_KEYMENU" -eq 1; then
	patch_apply winex11-SC_KEYMENU/0001-winex11-Send-SC_KEYMENU-on-managed-windows.patch
	(
		printf '%s\n' '+    { "Alex Henrie", "winex11: Send SC_KEYMENU on managed windows.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-UpdateLayeredWindow
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#33943] Fix alpha blending in X11DRV_UpdateLayeredWindow
# |
# | Modified files:
# |   *	dlls/winex11.drv/window.c
# |
if test "$enable_winex11_UpdateLayeredWindow" -eq 1; then
	patch_apply winex11-UpdateLayeredWindow/0001-winex11-Fix-alpha-blending-in-X11DRV_UpdateLayeredWi.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winex11: Fix alpha blending in X11DRV_UpdateLayeredWindow.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-_NET_ACTIVE_WINDOW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#2155] Forward activate window requests to WM using _NET_ACTIVE_WINDOW
# |
# | Modified files:
# |   *	dlls/user32/driver.c, dlls/user32/focus.c, dlls/user32/user_private.h, dlls/winex11.drv/event.c,
# | 	dlls/winex11.drv/window.c, dlls/winex11.drv/winex11.drv.spec, dlls/winex11.drv/x11drv.h, dlls/winex11.drv/x11drv_main.c
# |
if test "$enable_winex11__NET_ACTIVE_WINDOW" -eq 1; then
	patch_apply winex11-_NET_ACTIVE_WINDOW/0001-winex11.drv-Add-support-for-_NET_ACTIVE_WINDOW.patch
	patch_apply winex11-_NET_ACTIVE_WINDOW/0002-user32-Before-asking-a-WM-to-activate-a-window-make-.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "winex11.drv: Add support for _NET_ACTIVE_WINDOW.", 2 },';
		printf '%s\n' '+    { "Dmitry Timoshkov", "user32: Before asking a WM to activate a window make sure that the window is in foreground and not minimized.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-WM_WINDOWPOSCHANGING
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	winex11-_NET_ACTIVE_WINDOW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#34594] Fix handling of WM_WINDOWPOS{CHANGING,CHANGED} for deactivated topmost window
# |
# | Modified files:
# |   *	dlls/winex11.drv/event.c
# |
if test "$enable_winex11_WM_WINDOWPOSCHANGING" -eq 1; then
	patch_apply winex11-WM_WINDOWPOSCHANGING/0001-winex11.drv-Send-WM_WINDOWPOSCHANGING-WM_WINDOWPOSCH.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "winex11.drv: Send WM_WINDOWPOSCHANGING/WM_WINDOWPOSCHANGED messages to a being deactivated topmost window.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-Window_Groups
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#32699] Prevent window managers from grouping all wine programs together
# |
# | Modified files:
# |   *	dlls/winex11.drv/window.c
# |
if test "$enable_winex11_Window_Groups" -eq 1; then
	patch_apply winex11-Window_Groups/0001-winex11-Prevent-window-managers-from-grouping-all-wi.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winex11: Prevent window managers from grouping all wine programs together.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-Window_Style
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37876] Fix handling of window attributes for WS_EX_LAYERED | WS_EX_COMPOSITED
# |
# | Modified files:
# |   *	dlls/winex11.drv/window.c
# |
if test "$enable_winex11_Window_Style" -eq 1; then
	patch_apply winex11-Window_Style/0001-winex11-Fix-handling-of-window-attributes-for-WS_EX_.patch
	(
		printf '%s\n' '+    { "Dmitry Timoshkov", "winex11: Fix handling of window attributes for WS_EX_LAYERED | WS_EX_COMPOSITED.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-XEMBED
# |
# | Modified files:
# |   *	dlls/winex11.drv/event.c
# |
if test "$enable_winex11_XEMBED" -eq 1; then
	patch_apply winex11-XEMBED/0001-winex11-Enable-disable-windows-when-they-are-un-mapped.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winex11: Enable/disable windows when they are (un)mapped by foreign applications.", 1 },';
	) >> "$patchlist"
fi

# Patchset winex11-wglShareLists
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#11436] Do not fail when a used context is passed to wglShareLists
# |   *	[#25419] Fix broken textures in XIII Century: Death or Glory
# |
# | Modified files:
# |   *	dlls/opengl32/tests/opengl.c, dlls/winex11.drv/opengl.c
# |
if test "$enable_winex11_wglShareLists" -eq 1; then
	patch_apply winex11-wglShareLists/0001-winex11.drv-Only-warn-about-used-contexts-in-wglShar.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winex11.drv: Only warn about used contexts in wglShareLists.", 1 },';
	) >> "$patchlist"
fi

# Patchset winhlp32-Flex_Workaround
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42132] Workaround a bug present in the current versions of Flex
# |
# | Modified files:
# |   *	programs/winhlp32/macro.lex.l
# |
if test "$enable_winhlp32_Flex_Workaround" -eq 1; then
	patch_apply winhlp32-Flex_Workaround/0001-winhlp32-Workaround-a-bug-in-Flex.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winhlp32: Workaround a bug in Flex.", 1 },';
	) >> "$patchlist"
fi

# Patchset winhttp-Accept_Headers
# |
# | Modified files:
# |   *	dlls/winhttp/request.c, dlls/winhttp/session.c, dlls/winhttp/winhttp_private.h
# |
if test "$enable_winhttp_Accept_Headers" -eq 1; then
	patch_apply winhttp-Accept_Headers/0001-winhttp-Fix-handling-of-Accept-headers.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "winhttp: Fix handling of Accept headers.", 1 },';
	) >> "$patchlist"
fi

# Patchset winhttp-System_Proxy_Autoconfig
# |
# | Modified files:
# |   *	dlls/wininet/internet.c
# |
if test "$enable_winhttp_System_Proxy_Autoconfig" -eq 1; then
	patch_apply winhttp-System_Proxy_Autoconfig/0002-wininet-Silence-wininet-no-support-on-this-platform-.patch
	(
		printf '%s\n' '+    { "Jarkko Korpi", "wininet: Silence wininet no support on this platform message.", 1 },';
	) >> "$patchlist"
fi

# Patchset wininet-Cleanup
# |
# | Modified files:
# |   *	dlls/wininet/http.c, dlls/wininet/tests/http.c
# |
if test "$enable_wininet_Cleanup" -eq 1; then
	patch_apply wininet-Cleanup/0001-wininet-tests-Add-more-tests-for-cookies.patch
	patch_apply wininet-Cleanup/0002-wininet-tests-Test-auth-credential-reusage-with-host.patch
	patch_apply wininet-Cleanup/0003-wininet-tests-Check-cookie-behaviour-when-overriding.patch
	patch_apply wininet-Cleanup/0004-wininet-Strip-filename-if-no-path-is-set-in-cookie.patch
	patch_apply wininet-Cleanup/0005-wininet-Replacing-header-fields-should-fail-if-they-.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wininet/tests: Add more tests for cookies.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wininet/tests: Test auth credential reusage with host override.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wininet/tests: Check cookie behaviour when overriding host.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wininet: Strip filename if no path is set in cookie.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wininet: Replacing header fields should fail if they do not exist yet.", 1 },';
	) >> "$patchlist"
fi

# Patchset wininet-Http_Decoding
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42374] Allow to set INTERNET_OPTION_HTTP_DECODING on wininet sessions and connections
# |
# | Modified files:
# |   *	dlls/wininet/http.c, dlls/wininet/internet.c, dlls/wininet/internet.h, dlls/wininet/tests/http.c
# |
if test "$enable_wininet_Http_Decoding" -eq 1; then
	patch_apply wininet-Http_Decoding/0001-wininet-Allow-to-set-INTERNET_OPTION_HTTP_DECODING-o.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wininet: Allow to set INTERNET_OPTION_HTTP_DECODING on sessions and connections.", 1 },';
	) >> "$patchlist"
fi

# Patchset wininet-InternetCrackUrlW
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#40598] Resize buffer when call to InternetCanonicalizeUrlW fails in InternetCrackUrlW
# |
# | Modified files:
# |   *	dlls/wininet/internet.c, dlls/wininet/tests/url.c
# |
if test "$enable_wininet_InternetCrackUrlW" -eq 1; then
	patch_apply wininet-InternetCrackUrlW/0002-wininet-Resize-buffer-when-call-to-InternetCanonical.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wininet: Resize buffer when call to InternetCanonicalizeUrlW fails in InternetCrackUrlW.", 1 },';
	) >> "$patchlist"
fi

# Patchset wininet-Internet_Settings
# |
# | Modified files:
# |   *	dlls/wininet/internet.c, dlls/wininet/tests/internet.c
# |
if test "$enable_wininet_Internet_Settings" -eq 1; then
	patch_apply wininet-Internet_Settings/0001-wininet-Allow-INTERNET_OPTION_SETTINGS_CHANGED-on-co.patch
	patch_apply wininet-Internet_Settings/0002-wininet-Add-support-for-INTERNET_OPTION_SETTINGS_CHA.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wininet: Allow INTERNET_OPTION_SETTINGS_CHANGED on connections.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wininet: Add support for INTERNET_OPTION_SETTINGS_CHANGED in InternetSetOption.", 1 },';
	) >> "$patchlist"
fi

# Patchset wininet-ParseX509EncodedCertificateForListBoxEntry
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29842] Add stub for wininet.ParseX509EncodedCertificateForListBoxEntry
# |
# | Modified files:
# |   *	dlls/wininet/dialogs.c, dlls/wininet/wininet.spec, include/winineti.h
# |
if test "$enable_wininet_ParseX509EncodedCertificateForListBoxEntry" -eq 1; then
	patch_apply wininet-ParseX509EncodedCertificateForListBoxEntry/0001-wininet-add-ParseX509EncodedCertificateForListBoxEnt.patch
	(
		printf '%s\n' '+    { "Austin English", "wininet: Add ParseX509EncodedCertificateForListBoxEntry stub.", 2 },';
	) >> "$patchlist"
fi

# Patchset wininet-Redirect
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	wininet-Cleanup
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#41398] Return failure when handling http redirect without hostname
# |
# | Modified files:
# |   *	dlls/wininet/tests/http.c
# |
if test "$enable_wininet_Redirect" -eq 1; then
	patch_apply wininet-Redirect/0001-wininet-Return-failure-when-handling-http-redirect-w.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wininet: Return failure when handling http redirect without hostname.", 1 },';
	) >> "$patchlist"
fi

# Patchset winmm-Delay_Import_Depends
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37983] Jedi Knight: Dark Forces II crashes with winmm set to native
# |
# | Modified files:
# |   *	dlls/winmm/Makefile.in
# |
if test "$enable_winmm_Delay_Import_Depends" -eq 1; then
	patch_apply winmm-Delay_Import_Depends/0001-winmm-Delay-import-ole32-msacm32-to-workaround-bug-w.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winmm: Delay import ole32 msacm32 to workaround bug when loading multiple winmm versions.", 1 },';
	) >> "$patchlist"
fi

# Patchset winmm-mciSendCommandA
# |
# | Modified files:
# |   *	dlls/winmm/mci.c
# |
if test "$enable_winmm_mciSendCommandA" -eq 1; then
	patch_apply winmm-mciSendCommandA/0001-winmm-Do-not-crash-in-Win-9X-mode-when-an-invalid-de.patch
	(
		printf '%s\n' '+    { "Michael Müller", "winmm: Do not crash in Win 9X mode when an invalid device ptr is passed to MCI_OPEN.", 1 },';
	) >> "$patchlist"
fi

# Patchset wintrust-WinVerifyTrust
# |
# | Modified files:
# |   *	dlls/wintrust/softpub.c, dlls/wintrust/tests/softpub.c
# |
if test "$enable_wintrust_WinVerifyTrust" -eq 1; then
	patch_apply wintrust-WinVerifyTrust/0001-wintrust-tests-Add-tests-for-WinVerifyTrust.-v2.patch
	patch_apply wintrust-WinVerifyTrust/0002-wintrust-tests-Add-some-additional-tests.patch
	patch_apply wintrust-WinVerifyTrust/0003-wintrust-Verify-image-hash-in-WinVerifyTrust.patch
	patch_apply wintrust-WinVerifyTrust/0004-wintrust-use-enhanced-crypto-provider-in-VerifyImage.patch
	(
		printf '%s\n' '+    { "Mark Jansen", "wintrust/tests: Add tests for WinVerifyTrust.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "wintrust/tests: Add some additional tests.", 1 },';
		printf '%s\n' '+    { "Mark Jansen", "wintrust: Verify image hash in WinVerifyTrust.", 2 },';
		printf '%s\n' '+    { "Marko Friedemann", "wintrust: Use enhanced crypto provider in VerifyImageHash.", 1 },';
	) >> "$patchlist"
fi

# Patchset wpcap-Several_Fixes
# |
# | Modified files:
# |   *	dlls/wpcap/wpcap.c, dlls/wpcap/wpcap.spec
# |
if test "$enable_wpcap_Several_Fixes" -eq 1; then
	patch_apply wpcap-Several_Fixes/0001-wpcap-Implement-pcap_dump_open-and-pcap_dump.patch
	(
		printf '%s\n' '+    { "Jianqiu Zhang", "wpcap: Implement pcap_dump_open and pcap_dump.", 1 },';
	) >> "$patchlist"
fi

# Patchset wpcap-Dynamic_Linking
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	wpcap-Several_Fixes
# |
# | Modified files:
# |   *	configure.ac, dlls/wpcap/Makefile.in, dlls/wpcap/wpcap.c
# |
if test "$enable_wpcap_Dynamic_Linking" -eq 1; then
	patch_apply wpcap-Dynamic_Linking/0001-wpcap-Load-libpcap-dynamically.patch
	(
		printf '%s\n' '+    { "André Hentschel", "wpcap: Load libpcap dynamically.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-APC_Performance
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c
# |
if test "$enable_ws2_32_APC_Performance" -eq 1; then
	patch_apply ws2_32-APC_Performance/0001-ws2_32-Reuse-old-async-ws2_async_io-structures-if-po.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32: Reuse old async ws2_async_io structures if possible.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-Connect_Time
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c, server/protocol.def, server/sock.c
# |
if test "$enable_ws2_32_Connect_Time" -eq 1; then
	patch_apply ws2_32-Connect_Time/0001-ws2_32-Implement-returning-the-proper-time-with-SO_C.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32: Implement returning the proper time with SO_CONNECT_TIME.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-Tests
# |
# | Modified files:
# |   *	dlls/ws2_32/tests/sock.c
# |
if test "$enable_ws2_32_Tests" -eq 1; then
	patch_apply ws2_32-Tests/0001-ws2_32-tests-Hide-random-test-failures-in-socket-tests.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32/tests: Hide random test failures in socket tests.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-TransmitFile
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-Desktop_Refcount
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c, include/winsock.h, server/protocol.def, server/sock.c
# |
if test "$enable_ws2_32_TransmitFile" -eq 1; then
	patch_apply ws2_32-TransmitFile/0001-ws2_32-Add-support-for-TF_DISCONNECT-to-TransmitFile.patch
	patch_apply ws2_32-TransmitFile/0002-ws2_32-Add-support-for-TF_REUSE_SOCKET-to-TransmitFi.patch
	(
		printf '%s\n' '+    { "Erich E. Hoover", "ws2_32: Add support for TF_DISCONNECT to TransmitFile.", 1 },';
		printf '%s\n' '+    { "Erich E. Hoover", "ws2_32: Add support for TF_REUSE_SOCKET to TransmitFile.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-WSACleanup
# |
# | This patchset has the following (direct or indirect) dependencies:
# |   *	server-Desktop_Refcount
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#18670] Properly close sockets when WSACleanup is called
# |
# | Modified files:
# |   *	dlls/ntdll/ntdll.spec, dlls/ntdll/server.c, dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c, include/wine/server.h,
# | 	server/protocol.def, server/sock.c
# |
if test "$enable_ws2_32_WSACleanup" -eq 1; then
	patch_apply ws2_32-WSACleanup/0001-ws2_32-Proper-WSACleanup-implementation-using-winese.patch
	patch_apply ws2_32-WSACleanup/0002-ws2_32-Invalidate-client-side-file-descriptor-cache-.patch
	(
		printf '%s\n' '+    { "Matt Durgavich", "ws2_32: Proper WSACleanup implementation using wineserver function.", 2 },';
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32: Invalidate client-side file descriptor cache in WSACleanup.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-getaddrinfo
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c
# |
if test "$enable_ws2_32_getaddrinfo" -eq 1; then
	patch_apply ws2_32-getaddrinfo/0001-ws2_32-Fix-handling-of-empty-string-in-WS_getaddrinf.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32: Fix handling of empty string in WS_getaddrinfo.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-getsockopt
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#8606] Divide values returned by SO_RCVBUF and SO_SNDBUF getsockopt options by two
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, dlls/ws2_32/tests/sock.c
# |
if test "$enable_ws2_32_getsockopt" -eq 1; then
	patch_apply ws2_32-getsockopt/0001-ws2_32-Divide-values-returned-by-SO_RCVBUF-and-SO_SN.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "ws2_32: Divide values returned by SO_RCVBUF and SO_SNDBUF getsockopt options by two.", 1 },';
	) >> "$patchlist"
fi

# Patchset ws2_32-setsockopt
# |
# | Modified files:
# |   *	dlls/ws2_32/socket.c, include/winsock.h
# |
if test "$enable_ws2_32_setsockopt" -eq 1; then
	patch_apply ws2_32-setsockopt/0001-w2_32-Ignore-setting-several-port-assignment-related.patch
	(
		printf '%s\n' '+    { "Michael Müller", "w2_32: Ignore setting several port assignment related socket options.", 1 },';
	) >> "$patchlist"
fi

# Patchset wtsapi32-EnumerateProcesses
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#29903] Support for WTSEnumerateProcessesW
# |
# | Modified files:
# |   *	dlls/wtsapi32/tests/wtsapi.c, dlls/wtsapi32/wtsapi32.c
# |
if test "$enable_wtsapi32_EnumerateProcesses" -eq 1; then
	patch_apply wtsapi32-EnumerateProcesses/0001-wtsapi32-Partial-implementation-of-WTSEnumerateProce.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wtsapi32: Partial implementation of WTSEnumerateProcessesW.", 1 },';
	) >> "$patchlist"
fi

# Patchset wtsapi32-WTSQueryUserToken
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#39663] Improve WTSQueryUserToken stub to make GOG Galaxy happy
# |
# | Modified files:
# |   *	dlls/wtsapi32/wtsapi32.c
# |
if test "$enable_wtsapi32_WTSQueryUserToken" -eq 1; then
	patch_apply wtsapi32-WTSQueryUserToken/0001-wtsapi32-Improve-WTSQueryUserToken-stub.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "wtsapi32: Improve WTSQueryUserToken stub.", 2 },';
	) >> "$patchlist"
fi

# Patchset wuauserv-Dummy_Service
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#37781] Implement wuauserv dummy service
# |
# | Modified files:
# |   *	configure.ac, loader/wine.inf.in, programs/wuauserv/Makefile.in, programs/wuauserv/main.c
# |
if test "$enable_wuauserv_Dummy_Service" -eq 1; then
	patch_apply wuauserv-Dummy_Service/0001-wuauserv-Add-dummy-service.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wuauserv: Add dummy service.", 1 },';
	) >> "$patchlist"
fi

# Patchset wusa-MSU_Package_Installer
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#26757] Initial implementation of wusa.exe (MSU package installer)
# |
# | Modified files:
# |   *	programs/wusa/Makefile.in, programs/wusa/main.c, programs/wusa/manifest.c, programs/wusa/wusa.h
# |
if test "$enable_wusa_MSU_Package_Installer" -eq 1; then
	patch_apply wusa-MSU_Package_Installer/0001-wusa-Implement-basic-installation-logic.patch
	patch_apply wusa-MSU_Package_Installer/0002-wusa-Ignore-systemProtection-subkey-of-registry-key.patch
	patch_apply wusa-MSU_Package_Installer/0003-wusa-Treat-empty-update-list-as-error.patch
	patch_apply wusa-MSU_Package_Installer/0004-wusa-Implement-WOW64-support.patch
	patch_apply wusa-MSU_Package_Installer/0005-wusa-Add-workaround-to-be-compatible-with-Vista-pack.patch
	patch_apply wusa-MSU_Package_Installer/0006-wusa-Improve-tracing-of-installation-process.patch
	patch_apply wusa-MSU_Package_Installer/0007-wusa-Print-warning-when-encountering-msdelta-compres.patch
	(
		printf '%s\n' '+    { "Michael Müller", "wusa: Implement basic installation logic.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wusa: Ignore systemProtection subkey of registry key.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wusa: Treat empty update list as error.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wusa: Implement WOW64 support.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "wusa: Add workaround to be compatible with Vista packages.", 1 },';
		printf '%s\n' '+    { "Sebastian Lackner", "wusa: Improve tracing of installation process.", 1 },';
		printf '%s\n' '+    { "Michael Müller", "wusa: Print warning when encountering msdelta compressed files.", 1 },';
	) >> "$patchlist"
fi

# Patchset xaudio2-get_al_format
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#42414] Add support for xaudio2 float formats with more than 2 channels
# |
# | Modified files:
# |   *	dlls/xaudio2_7/xaudio_dll.c
# |
if test "$enable_xaudio2_get_al_format" -eq 1; then
	patch_apply xaudio2-get_al_format/0001-xaudio2-Add-support-for-float-formats-with-more-than.patch
	(
		printf '%s\n' '+    { "Kimmo Myllyvirta", "xaudio2: Add support for float formats with more than 2 channels.", 1 },';
	) >> "$patchlist"
fi

# Patchset xaudio2_7-OnVoiceProcessingPassStart
# |
# | This patchset fixes the following Wine bugs:
# |   *	[#43358] Use assembly wrapper to call OnVoiceProcessingPassStart callback
# |
# | Modified files:
# |   *	dlls/xaudio2_7/xaudio_dll.c
# |
if test "$enable_xaudio2_7_OnVoiceProcessingPassStart" -eq 1; then
	patch_apply xaudio2_7-OnVoiceProcessingPassStart/0001-xaudio2_7-Use-assembly-wrapper-to-call-OnVoiceProces.patch
	(
		printf '%s\n' '+    { "Sebastian Lackner", "xaudio2_7: Use assembly wrapper to call OnVoiceProcessingPassStart callback.", 1 },';
	) >> "$patchlist"
fi


if test "$enable_patchlist" -eq 1; then

	# Generate a temporary patch containing the patchlist and apply it
	patch_data=$(cat "$patchlist" | sort)
	if test ! -z "$patch_data"; then
		patch_lines=$(printf '%s\n' "$patch_data" | wc -l)
		patch_lines=$((${patch_lines}+21))
		cat > "$patchlist" <<EOF
From: Wine Staging Team <webmaster@fds-team.de>
Subject: Autogenerated patch list.

diff --git a/libs/wine/config.c b/libs/wine/config.c
index 5262c76..0a3182f 100644
--- a/libs/wine/config.c
+++ b/libs/wine/config.c
@@ -478,10 +478,${patch_lines} @@ const char *wine_get_version(void)
     return PACKAGE_VERSION;
 }
 
+static const struct
+{
+    const char *author;
+    const char *subject;
+    int revision;
+}
+wine_patch_data[] =
+{
${patch_data}
+    { NULL, NULL, 0 }
+};
+
 /* return the applied non-standard patches */
 const void *wine_get_patches(void)
 {
-    return NULL;
+    return &wine_patch_data[0];
 }
 
 /* return the build id string */
EOF
		patch_apply_file "$patchlist"
	fi
	rm "$patchlist"
fi

if test "$enable_autoconf" -eq 1; then
	if ! update_configure; then
		abort "'autoreconf -f' failed."
	fi
	if ! update_protocol; then
		abort "'./tools/make_requests' failed."
	fi
fi
# Success
exit 0
