/*
 * Decompiled with CFR 0.152.
 */
package vash;

import vash.Options;

public class OutputParameters {
    private static final int MINIMUM_SIZE = 4;
    private final String filename;
    private final String imageType;
    private final int width;
    private final int height;

    public OutputParameters(Options options) {
        this(options.getOutput(), options.getOutputFormat(), options.getWidth(), options.getHeight());
    }

    public OutputParameters(String string, int n, int n2) {
        this(string, OutputParameters.guessFormat(string), n, n2);
    }

    public OutputParameters(String string, String string2, int n, int n2) {
        if (string2 == null) {
            string2 = OutputParameters.guessFormat(string);
        }
        if (!(string2.equals("png") || string2.equals("jpeg") || string2.equals("bmp"))) {
            throw new IllegalArgumentException("Unknown output format: '" + string2 + "'");
        }
        if (n < 4 || n2 < 4) {
            throw new IllegalArgumentException("Width and Height must both be at least 4.");
        }
        this.filename = string;
        this.imageType = string2;
        this.width = n;
        this.height = n2;
    }

    public static String guessFormat(String string) {
        String string2 = string.toLowerCase();
        if (string2.endsWith(".png")) {
            return "png";
        }
        if (string2.endsWith(".jpg")) {
            return "jpeg";
        }
        if (string2.endsWith(".bmp")) {
            return "bmp";
        }
        if (string2.equals("-")) {
            return "png";
        }
        throw new IllegalArgumentException("Unknown media type for given extension: \"" + string2.subSequence(string.length() - 4, string.length()) + "\"");
    }

    public String getFilename() {
        return this.filename;
    }

    public String getImageType() {
        return this.imageType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

