/*
 * Decompiled with CFR 0.152.
 */
package vash;

import ec.util.MersenneTwisterFast;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import vash.InvalidAlgorithmException;
import vash.SeedProviderHVAC;

public class Seed {
    private final String algorithm;
    private Random linear_congruent;
    private MersenneTwisterFast twister;
    private SeedProviderHVAC hvac;
    public static final int SALT_SIZE = 64;
    private int usedEntropy = 0;

    public static int getSaltSizeForAlgorithm(String string) {
        if (string.equals("1-fast") || string.equals("1")) {
            return 64;
        }
        if (string.equals("1.1")) {
            return 64;
        }
        throw new InvalidAlgorithmException("Unrecognized seed algorithm: " + string);
    }

    public Seed(String string, byte[] byArray, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        this.algorithm = string;
        if (string.equals("1-fast")) {
            this.init1Fast(byArray, inputStream);
        } else if (string.equals("1")) {
            this.init1(byArray, inputStream);
        } else if (string.equals("1.1")) {
            this.initHVAC(byArray, inputStream);
        } else {
            throw new InvalidAlgorithmException("Unknown seed algorithm: " + string);
        }
    }

    private void init1Fast(byte[] byArray, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        if (byArray != null) {
            messageDigest.update(byArray);
        }
        int n = 0;
        byte[] byArray2 = new byte[4096];
        while (n != -1 && (n = inputStream.read(byArray2)) != -1) {
            messageDigest.update(byArray2, 0, n);
        }
        byte[] byArray3 = messageDigest.digest();
        long l = ((long)byArray3[0] & 0xFFL) << 40 | ((long)byArray3[1] & 0xFFL) << 32 | ((long)byArray3[2] & 0xFFL) << 24 | ((long)byArray3[3] & 0xFFL) << 16 | ((long)byArray3[4] & 0xFFL) << 8 | (long)byArray3[5] & 0xFFL;
        this.linear_congruent = new Random(l);
    }

    private void init1(byte[] byArray, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
        if (byArray != null) {
            messageDigest.update(byArray, 0, 64);
        }
        int n = 0;
        byte[] byArray2 = new byte[4096];
        while (n != -1 && (n = inputStream.read(byArray2)) != -1) {
            messageDigest.update(byArray2, 0, n);
        }
        byte[] byArray3 = messageDigest.digest();
        int[] nArray = new int[16];
        for (int i = 0; i < 16; ++i) {
            nArray[i] = (byArray3[i * 4 + 0] & 0xFF) << 24 | (byArray3[i * 4 + 1] & 0xFF) << 16 | (byArray3[i * 4 + 2] & 0xFF) << 8 | byArray3[i * 4 + 3] & 0xFF;
        }
        this.twister = new MersenneTwisterFast(nArray);
    }

    private void initHVAC(byte[] byArray, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        this.hvac = new SeedProviderHVAC(byArray, inputStream);
    }

    public double nextDouble() {
        double d = 0.0;
        d = this.hvac != null ? this.hvac.nextDouble() : (this.twister != null ? this.twister.nextDouble() : this.linear_congruent.nextDouble());
        this.usedEntropy += 53;
        return d;
    }

    public int nextInt(int n) {
        int n2 = this.hvac != null ? this.hvac.nextInt(n) : (this.twister != null ? this.twister.nextInt(n) : this.linear_congruent.nextInt(n));
        this.usedEntropy += 31;
        return n2;
    }

    public int getBitsOfEntropyUsed() {
        return this.usedEntropy;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}

