/*
 * Decompiled with CFR 0.152.
 */
package vash.operation;

import vash.ImageParameters;
import vash.Plane;
import vash.Seed;
import vash.operation.OperationNode;
import vash.value.Bounded;
import vash.value.Position;
import vash.value.Wrapping;

public class RadialGradient
extends OperationNode {
    private static final double MIN_SIZE = 0.1;
    private static final double MAX_SIZE = 0.8;
    private static final double MIN_ANGLE = 0.0;
    private static final double MAX_ANGLE = 360.0;
    private final Position center;
    private final Bounded width;
    private final Bounded height;
    private final Wrapping angle;

    private RadialGradient(Position position, Bounded bounded, Bounded bounded2, Wrapping wrapping) {
        super(4, 0);
        assert (bounded.hasBounds(0.1, 0.8));
        assert (bounded2.hasBounds(0.1, 0.8));
        assert (wrapping.hasBounds(0.0, 360.0));
        this.center = position;
        this._values[0] = this.center;
        this.width = bounded;
        this._values[1] = this.width;
        this.height = bounded2;
        this._values[2] = this.height;
        this.angle = wrapping;
        this._values[3] = this.angle;
    }

    public RadialGradient(double d, double d2, double d3, double d4, double d5) {
        this(new Position(d, d2), new Bounded(d3, 0.1, 0.8), new Bounded(d4, 0.1, 0.8), new Wrapping(d5, 0.0, 360.0));
    }

    public RadialGradient(Seed seed) {
        this(new Position(seed), new Bounded(seed, 0.1, 0.8), new Bounded(seed, 0.1, 0.8), new Wrapping(seed, 0.0, 360.0));
    }

    public OperationNode clone() {
        return new RadialGradient(this.center.clone(), this.width.clone(), this.height.clone(), this.angle.clone());
    }

    public Plane compute(ImageParameters imageParameters) {
        float[] fArray = imageParameters.getXValues();
        float[] fArray2 = imageParameters.getYValues();
        float f = (float)this.center.getX();
        float f2 = (float)this.center.getY();
        float f3 = (float)this.width.getV();
        float f4 = (float)this.height.getV();
        float f5 = (float)this.angle.getV();
        float f6 = (float)(2.0 / Math.sqrt(2.0));
        Plane plane = imageParameters.getPlane();
        float f7 = (float)Math.cos((double)f5 * Math.PI / 180.0 - 1.5707963267948966);
        float f8 = (float)Math.sin((double)f5 * Math.PI / 180.0 - 1.5707963267948966);
        for (int i = 0; i < imageParameters.getH(); ++i) {
            float f9 = fArray2[i] - f2;
            for (int j = 0; j < imageParameters.getW(); ++j) {
                float f10 = fArray[j] - f;
                float f11 = f10 * f7 - f9 * f8;
                float f12 = f10 * f8 + f9 * f7;
                float f13 = f11 / f3;
                float f14 = f12 / f4;
                float f15 = -((float)Math.sqrt(f13 * f13 + f14 * f14)) * f6 + 1.0f;
                plane.data[j][i] = OperationNode.clampf(f15, -1.0f, 1.0f);
            }
        }
        return plane;
    }
}

