#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.consts import LOCALHOST
from winswitch.net.conch_channels import ExecChannel
from winswitch.util.simple_logger import Logger
from conch_test_common import make_factory
from winswitch.util.main_loop import loop_init, loop_run, connectTCP
logger = Logger("conch_exec_test")


def ssh_exec(host, port, command):
	factory = make_factory(host, port)
	echo_channel = lambda connection : ExecChannel(command, connection)
	factory.channel_constructors.append(echo_channel)
	loop_init(False)
	connectTCP(host, port, factory)
	try:
		loop_run()
	except Exception, e:
		logger.serr(None, e, host, port, command)
	logger.slog("ended", host, port, command)


def main():
	ssh_exec(LOCALHOST, 22, "winswitch_server_portinfo")

if __name__ == "__main__":
	main()
