#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3


from winswitch.util.simple_logger import Logger
from winswitch.util.load_desktop_menus import load_start_menu, load_menu_files, load_menu_file
from winswitch.consts import DEFAULT_IGNORED_CATEGORIES, DEFAULT_IGNORED_ONLYSHOWNIN, DEFAULT_DISABLED_CATEGORIES
from winswitch.util.common import csv_list
from winswitch.objects.server_command import ServerCommand

logger=Logger("load_desktop_menus_test", log_colour=Logger.RED, _debug=True)

APP_DIR="/usr/share/applications"

def test_load_start_menu_categories():
	(cmds, dirs) = load_start_menu([], ["*"])
	logger.slog("commands=%s" % csv_list(cmds))
	logger.slog("dirs=%s" % csv_list(dirs))
	for d in dirs:
		d.lookup_icon_data()
		logger.slog("category(%s)=%s, icon_names=%s" % (d.filename, d, d.icon_names))

def test_load_start_menu():
	(cmds, dirs) = load_start_menu([], ["*"])
	logger.slog("commands=%s" % csv_list(cmds))
	logger.slog("dirs=%s" % csv_list(dirs))
	for cmd in cmds:
		logger.slog("command(%s)=%s" % (cmd.filename, cmd))

def test_load_menu_files():
	cmds = load_menu_files(APP_DIR, ".desktop", True, [], ["*"], ignored_directories=DEFAULT_IGNORED_CATEGORIES)
	logger.slog("commands=%s" % csv_list(cmds))
	for cmd in cmds:
		logger.slog("command(%s)=%s" % (cmd.filename, cmd))

def do_load_menu_file(name):
	cmd = load_menu_file(APP_DIR, name, None, ignored_commands=None, whitelist_commands=["*"],
				ignored_in=DEFAULT_IGNORED_ONLYSHOWNIN,
				skipped=[],
				disabled_categories=DEFAULT_DISABLED_CATEGORIES,
				file_type=ServerCommand.COMMAND)
	logger.slog("=%s" % cmd, name)
	return	cmd

def test_load_menu_file():
	from winswitch.util import load_desktop_menus
	load_desktop_menus.logger = Logger("load_desktop_menus", log_colour=Logger.HIGHLIGHTED_BLUE, _debug=True)
	do_load_menu_file("evince.desktop")

def test_sound_enabled():
	totem = do_load_menu_file("totem.desktop")
	assert totem.uses_sound_out
	totem = do_load_menu_file("vlc.desktop")
	assert totem.uses_sound_out

def test_run_once_only():
	firefox = do_load_menu_file("mozilla-firefox.desktop")
	logger.slog("firefox.run_once_only=%s" % firefox.run_once_only) 
	assert firefox.run_once_only

def test_sound_out_not_in():
	(cmds, dirs) = load_start_menu([], ["*"])
	logger.slog("commands=%s" % csv_list(cmds))
	logger.slog("dirs=%s" % csv_list(dirs))
	found = []
	for cmd in cmds:
		if not cmd.uses_sound_out:
			continue
		if not cmd.uses_sound_in:
			found.append(cmd)
	logger.slog("test_sound_out_not_in() found %s commands that use soundout but no soundin: %s" % (len(found), [x.name for x in found]))
	assert len(found)>0

def test_mines_sound():
	mines = do_load_menu_file("gnome-gnomine.desktop")
	logger.slog("mines.uses_sound_out=%s, mines.uses_sound_in=%s" % (mines.uses_sound_out, mines.uses_sound_in)) 
	assert mines.uses_sound_out
	assert not mines.uses_sound_in
	
def test_vlc_video():
	vlc = do_load_menu_file("vlc.desktop")
	logger.slog("vlc.uses_video=%s" % (vlc.uses_video)) 
	assert vlc.uses_video
	

def main():
	test_load_start_menu_categories()
	test_load_start_menu()
	test_load_menu_files()
	test_load_menu_file()
	test_sound_enabled()
	test_run_once_only()
	test_sound_out_not_in()
	test_mines_sound()
	test_vlc_video()

if __name__ == "__main__":
	main()