#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import sys

def main():
	def start_loop(fn):
		from winswitch.util.main_loop import loop_init, loop_run, loop_exit, callLater
		loop_init(False)
		def timeout(*args):
			loop_exit()
		callLater(120, timeout)
		callLater(0, fn)
		loop_run()

	cmd = ""
	if len(sys.argv)>1:
		cmd = sys.argv[1]
	if cmd=="start" and len(sys.argv)==4:
		def done(*args):
			print "done!"
		def start():
			from winswitch.virt.ard_control import start_ARD
			start_ARD(sys.argv[2], sys.argv[3], done)
		start_loop(start)
	elif cmd=="stop" and len(sys.argv)==3:
		def stop():
			from winswitch.virt.ard_control import stop_ARD
			stop_ARD(sys.argv[2])
		start_loop(stop)
	else:
		print "usage: %s start system_sudo_password vnc_password" % sys.argv[0]
		print "usage: %s stop system_sudo_password" % sys.argv[0]

if __name__ == "__main__":
	main()
