#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import sys

def usage():
	print("Usage: %s" % sys.argv[0])
	print("")
	print("  -h, --help         This information")
	print("  -v, --verbose      Turn on verbose logging")
	print("")
	print(" Any other arguments are ignored")
	print("")
	print("This program is not meant to be used directly by users.")
	print("It is used by remote clients to connect to local servers.")

if "-h" in sys.argv or "--help" in sys.argv:
	usage()
	sys.exit(0)

""" dont log any internal logging messages to tty unless verbose mode is on """
verbose = "-v" in sys.argv or "--verbose" in sys.argv
from winswitch.util.simple_logger import set_log_to_tty
set_log_to_tty(verbose)

from winswitch.util.main_loop import loop_init, loop_run, loop_exit, connectUNIX
loop_init(False)

from winswitch.client.stdio_client_common import WinSwitchClientFactory, StdioClient, StdIO
from winswitch.util.file_io import get_local_server_socket
from winswitch.globals import USER_ID


def main(args):
	socket_filename = get_local_server_socket(USER_ID==0)
	StdIO(StdioClient())
	print("OK 'connecting to %s'" % socket_filename)
	factory = WinSwitchClientFactory(loop_exit)
	connectUNIX(socket_filename, factory, timeout=2)
	loop_run()

if __name__ == "__main__":
	main(sys.argv)
