#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import os

from winswitch.util.simple_logger import Logger

import gtk
import wnck

class wnck_wm:
	def __init__(self, windows_modified_callback = None):
		Logger(self, log_colour=Logger.HIGHLIGHTED_CRIMSON)
		self.is_screensaver_running = None
		self.windows_modified_callback = None
		self.get_modifiers_set = None
		self.screen = wnck.screen_get_default()
		self.screen.connect("window_opened", self.window_opened)
		self.screen.connect("window_closed", self.window_closed)


	def window_opened(self, screen, window):
		self.sdebug(None, screen, window)
		self.window_event(True, screen, window)
		return	False

	def window_closed(self, screen, window):
		self.sdebug(None, screen, window)
		self.window_event(False, screen, window)
		return	False
	
	def window_event(self, mapped, screen, window):
		if window.is_skip_pager() or window.is_skip_tasklist():
			return
		#type = window.get_window_type()
		#self.log("window_event(%s,%s,%s) type=%r" % (open, screen, window, type))
		#WnckWindowType:
		#  WNCK_WINDOW_NORMAL,       /* document/app window */
		#  WNCK_WINDOW_DESKTOP,      /* desktop background */
		#  WNCK_WINDOW_DOCK,         /* panel */
		#  WNCK_WINDOW_DIALOG,       /* dialog */
		#  WNCK_WINDOW_TOOLBAR,      /* tearoff toolbar */
		#  WNCK_WINDOW_MENU,         /* tearoff menu */
		#  WNCK_WINDOW_UTILITY,      /* palette/toolbox window */
		#  WNCK_WINDOW_SPLASHSCREEN  /* splash screen */
		pid = None
		if mapped:	#can only get pids for open windows
			pid = window.get_pid()
			if pid and pid==os.getpid():
				self.sdebug("this is one of our windows - not firing events", mapped, screen, window)

	
	def get_event_time(self):
		t = gtk.get_current_event_time()
		if t == 0:
			t = 1
		return	t

	def close_callback(self, window, pid, name):
		self.sdebug(None, window, pid, name)
		window.close(self.get_event_time())
	
	def close_windows(self, pids):
		self.sdebug(None, str(pids))
		self.for_matching_pids(pids, self.close_callback)

	def minimize_callback(self, window, pid, name):
		self.sdebug(None, window, pid, name)
		window.minimize()

	def minimize_windows(self, pids):
		self.sdebug(None, str(pids))
		self.for_matching_pids(pids, self.minimize_callback)

	def raise_callback(self, window, pid, name):
		self.sdebug(None, window, pid, name)
		window.activate(self.get_event_time())

	def raise_windows(self, pids):
		self.sdebug(None, str(pids))
		self.for_matching_pids(pids, self.raise_callback)


	def for_matching_pids(self, pids, callback):
		screen = wnck.screen_get_default()
		while gtk.events_pending():
			gtk.main_iteration()
		windows = screen.get_windows()
		for window in windows:
			window_pid = window.get_pid()
			if window_pid in pids:
				application = window.get_application()
				name = application.get_name()
				callback(window, window_pid, name)
