#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import gtk

from winswitch.globals import LINUX
from winswitch.virt.ssh_client_base import SSHClientBase
from winswitch.virt.client_options_base import ClientOptionsBase
from winswitch.virt.options_common import COMPRESSION
from winswitch.objects.server_command import ServerCommand


class	SSHClientUtil(SSHClientBase, ClientOptionsBase):
	""" adds compression options widget to SSHClientBase """

	def	__init__(self, update_session_status, notify_callback, ask_callback):
		SSHClientBase.__init__(self, update_session_status, notify_callback, ask_callback)


	def get_compression_widget(self, server_command, options, change_cb):
		""" A combo box where users can select compression	"""
		cb = gtk.combo_box_new_text()
		#find the current value:
		current_compression_value = -1
		if options and COMPRESSION in options:
			try:
				current_compression_value = int(options[COMPRESSION])
			except:
				pass
		#populate drop down:
		cb.append_text("Disabled")
		cb.append_text("1 (Low)")
		for i in xrange(8):
			cb.append_text("%s" % (i+1))
		cb.append_text("9 (High)")
		if current_compression_value>=-1:
			cb.set_active(current_compression_value+1)
		self.setup_combo_callback(cb, COMPRESSION, change_cb, use_index=True)
		return cb

	def is_openssh(self):
		#FIXME: we should actually test with "ssh --help"
		return	LINUX

	def get_options_widgets(self, server, server_command, shadowed_session=None, current_options=None, default_options=None, change_cb=None):
		""" ssh option: compression (only with openssh) """
		options = self.get_options(current_options, default_options)
		widgets = []
		if self.is_openssh():
			widgets.append(("Compression", self.get_compression_widget(server_command, options, change_cb)))
		#not in edit mode and must be a full desktop:
		if default_options is not None and server_command is not None and server_command.type==ServerCommand.DESKTOP:
			self.add_screen_size_widget(widgets, server, server_command, shadowed_session, options, change_cb)
		return	widgets
