/*
 * Decompiled with CFR 0.152.
 */
package vash;

import java.util.LinkedList;
import vash.Plane;

public class ImageParameters {
    private final int w;
    private final int h;
    private final float[] X;
    private final float[] Y;
    private final LinkedList<Plane> cache;
    private long _puts = 0L;
    private long _gets = 0L;
    private static final long MAX_CACHE_SIZE = 0x4000000L;
    private static final boolean DEBUG = false;

    public ImageParameters(int n, int n2) {
        this.w = n;
        this.h = n2;
        this.cache = new LinkedList();
        this.X = new float[n];
        this.Y = new float[n2];
        float f = 2.0f / (float)n;
        float f2 = 2.0f / (float)n2;
        int n3 = 0;
        float f3 = 1.0f - f2 / 2.0f;
        while (n3 < n2) {
            this.Y[n3] = f3;
            ++n3;
            f3 -= f2;
        }
        int n4 = 0;
        float f4 = -1.0f + f / 2.0f;
        while (n4 < n) {
            this.X[n4] = f4;
            ++n4;
            f4 += f;
        }
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public float[] getXValues() {
        return this.X;
    }

    public float[] getYValues() {
        return this.Y;
    }

    public Plane getPlane() {
        ++this._gets;
        if (this.cache.size() > 0) {
            return this.cache.removeFirst();
        }
        return new Plane(this.w, this.h);
    }

    public void putPlane(Plane plane) {
        ++this._puts;
        long l = (this._gets - this._puts + (long)this.cache.size()) * (long)(this.w * this.h * 4);
        if (l < 0x4000000L) {
            this.cache.addFirst(plane);
        }
    }

    public Plane getYXPlane() {
        return new Plane(this.h, this.w);
    }

    public void putYXPlane(Plane plane) {
    }
}

