/*
 * Decompiled with CFR 0.152.
 */
package vash;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.BitSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import vash.InvalidSaltException;

class SeedProviderHVAC {
    private static final String XTR_ALGORITHM = "HmacSHA512";
    private static final int XTR_SIZE = 64;
    private static final String PRF_ALGORITHM = "HmacSHA256";
    private static final int PRF_SIZE = 32;
    public static final int SALT_SIZE = 64;
    private static final byte[] DEFAULT_SALT = new byte[]{-55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47, 41, 2, 78, 8, -118, 103, -52, 116, 2, 11, -66, -90, 59, 19, -101, 34, 81, 74, 8, 121, -114, 52, 4, -35, -17, -107, 25, -77, -51, 58, 67, 27, 48, 43, 10, 109, -14, 95, 20, 55, 79, -31, 53, 109, 109, 81, -62, 69};
    private static final byte[] INFO = "20110719 terrence@thevash.com VASH/hmacExpandInfoBytes".getBytes();
    private final Mac hmacExpand;
    private byte[] Tcurrent;
    private int Toffset;
    private final BitSet Tbits;
    private int Tbitpos;

    SeedProviderHVAC(byte[] byArray, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        if (byArray != null && byArray.length != 64) {
            throw new InvalidSaltException("The salt for algorithm 2 must be 64 bytes long.");
        }
        Mac mac = Mac.getInstance(XTR_ALGORITHM);
        if (byArray == null) {
            byArray = DEFAULT_SALT;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, XTR_ALGORITHM);
        try {
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidSaltException(invalidKeyException.toString());
        }
        int n = 0;
        byte[] byArray2 = new byte[4096];
        while (n != -1 && (n = inputStream.read(byArray2)) != -1) {
            mac.update(byArray2, 0, n);
        }
        byte[] byArray3 = mac.doFinal();
        SecretKeySpec secretKeySpec2 = new SecretKeySpec(byArray3, 0, 32, PRF_ALGORITHM);
        this.hmacExpand = Mac.getInstance(PRF_ALGORITHM);
        try {
            this.hmacExpand.init(secretKeySpec2);
        }
        catch (InvalidKeyException invalidKeyException) {
            System.err.println(invalidKeyException.toString());
            System.exit(1);
        }
        this.Tbits = new BitSet(256);
        this.Tbitpos = 0;
        this.Tcurrent = new byte[32];
        this.Toffset = 0;
        this.nextT();
    }

    private void nextT() {
        int n;
        byte[] byArray = new byte[32 + INFO.length + 4];
        System.arraycopy(this.Tcurrent, 0, byArray, 0, 32);
        System.arraycopy(INFO, 0, byArray, 32, INFO.length);
        int n2 = 32 + INFO.length;
        for (n = 3; n >= 0; --n) {
            byArray[n2 + (3 - n)] = (byte)(this.Toffset >> n * 8 & 0xFF);
        }
        this.Tcurrent = this.hmacExpand.doFinal(byArray);
        ++this.Toffset;
        this.Tbitpos = 0;
        for (n2 = 0; n2 < 32; ++n2) {
            byte by = this.Tcurrent[n2];
            for (n = 7; n >= 0; --n) {
                boolean bl = (by >> n & 1) == 1;
                int n3 = n2 * 8 + (7 - n);
                this.Tbits.set(n3, bl);
            }
        }
    }

    double nextDouble() {
        long l = this.nextBits(26);
        long l2 = this.nextBits(27);
        return (double)((l << 27) + l2) / 9.007199254740992E15;
    }

    int nextInt(int n) {
        int n2;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * this.nextBits(31) >> 31);
        }
        while ((n3 = (int)this.nextBits(31)) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    private long nextBits(int n) {
        assert (n <= 64);
        long l = 0L;
        for (int i = n - 1; i >= 0; --i) {
            long l2 = this.Tbits.get(this.Tbitpos) ? 1L : 0L;
            ++this.Tbitpos;
            l |= l2 << i;
            if (this.Tbitpos != this.Tbits.size()) continue;
            this.nextT();
        }
        return l;
    }
}

