/*
 * Decompiled with CFR 0.152.
 */
package vash.operation;

import vash.ImageParameters;
import vash.Plane;
import vash.Seed;
import vash.operation.OperationNode;
import vash.value.Bounded;

public class Const
extends OperationNode {
    private static final double MIN_VALUE = -1.0;
    private static final double MAX_VALUE = 1.0;
    private final Bounded v;

    private Const(Bounded bounded) {
        super(1, 0);
        assert (bounded.hasBounds(-1.0, 1.0));
        this.v = bounded;
        this._values[0] = this.v;
    }

    public Const(double d) {
        this(new Bounded(d, -1.0, 1.0));
    }

    public Const(Seed seed) {
        this(new Bounded(seed, -1.0, 1.0));
    }

    public Const clone() {
        return new Const(this.v.clone());
    }

    public Plane compute(ImageParameters imageParameters) {
        int n = imageParameters.getW();
        int n2 = imageParameters.getH();
        float f = (float)this.v.getV();
        Plane plane = imageParameters.getPlane();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                plane.data[j][i] = f;
            }
        }
        return plane;
    }
}

