/*
 * Decompiled with CFR 0.152.
 */
package vash.operation;

import vash.ImageParameters;
import vash.Plane;
import vash.Seed;
import vash.operation.OperationNode;
import vash.value.Bounded;
import vash.value.Position;

public class Ellipse
extends OperationNode {
    private final Position f0;
    private final Position f1;
    private final Bounded size;
    private static final double MIN_SIZE = 0.1;
    private static final double MAX_SIZE = 1.0;
    private static final double MIN_POSITION = -1.0;
    private static final double MAX_POSITION = 1.0;

    private Ellipse(Position position, Position position2, Bounded bounded) {
        super(3, 0);
        assert (position.hasBounds(-1.0, -1.0, 1.0, 1.0));
        assert (position2.hasBounds(-1.0, -1.0, 1.0, 1.0));
        assert (bounded.hasBounds(0.1, 1.0));
        this.f0 = position;
        this._values[0] = this.f0;
        this.f1 = position2;
        this._values[1] = this.f1;
        this.size = bounded;
        this._values[2] = this.size;
    }

    public Ellipse(double d, double d2, double d3, double d4, double d5) {
        this(new Position(d, d2), new Position(d3, d4), new Bounded(d5, 0.1, 1.0));
    }

    public Ellipse(Seed seed) {
        this(new Position(seed), new Position(seed), new Bounded(seed, 0.1, 1.0));
    }

    public OperationNode clone() {
        return new Ellipse(this.f0.clone(), this.f1.clone(), this.size.clone());
    }

    public Plane compute(ImageParameters imageParameters) {
        float[] fArray = imageParameters.getXValues();
        float[] fArray2 = imageParameters.getYValues();
        float f = (float)this.f0.getX();
        float f2 = (float)this.f0.getY();
        float f3 = (float)this.f1.getX();
        float f4 = (float)this.f1.getY();
        float f5 = Ellipse.distance(f, f2, f3, f4);
        float f6 = (float)this.size.getV();
        float f7 = f5 + f6 * f5;
        float f8 = fArray[2] - fArray[0];
        Plane plane = imageParameters.getPlane();
        for (int i = 0; i < imageParameters.getH(); ++i) {
            float f9 = fArray2[i];
            for (int j = 0; j < imageParameters.getW(); ++j) {
                float f10 = fArray[j];
                float f11 = Ellipse.distance(f10, f9, f, f2) + Ellipse.distance(f10, f9, f3, f4);
                plane.data[j][i] = f11 < f7 ? 1.0f : (f11 < f7 + f8 ? 1.0f - (f11 - f7) / f8 * 2.0f : -1.0f);
            }
        }
        return plane;
    }
}

