/*
 * Decompiled with CFR 0.152.
 */
package vash.operation;

import vash.ImageParameters;
import vash.Plane;
import vash.Seed;
import vash.operation.OperationNode;
import vash.value.Position;
import vash.value.Wrapping;

public class PolarTheta
extends OperationNode {
    private final Position center;
    private final Wrapping angle;

    private PolarTheta(Position position, Wrapping wrapping) {
        super(2, 0);
        assert (this.center.hasBounds(-1.0, -1.0, 1.0, 1.0));
        assert (this.angle.hasBounds(-1.0, 1.0));
        this.center = position;
        this._values[0] = this.center;
        this.angle = wrapping;
        this._values[1] = this.angle;
    }

    public PolarTheta(double d, double d2, double d3) {
        this(new Position(d, d2), new Wrapping(d3, -1.0, 1.0));
    }

    public PolarTheta(Seed seed) {
        super(2, 0);
        this.center = new Position(seed);
        this._values[0] = this.center;
        this.angle = new Wrapping(seed, -1.0, 1.0);
        this._values[1] = this.angle;
    }

    public OperationNode clone() {
        return new PolarTheta(this.center.clone(), this.angle.clone());
    }

    public Plane compute(ImageParameters imageParameters) {
        float f = (float)this.angle.getV();
        float f2 = (float)Math.cos((double)f * Math.PI);
        float f3 = (float)Math.sin((double)f * Math.PI);
        float f4 = (float)this.center.getX();
        float f5 = (float)this.center.getY();
        float[] fArray = imageParameters.getXValues();
        float[] fArray2 = imageParameters.getYValues();
        float f6 = imageParameters.getW();
        float f7 = imageParameters.getH();
        Plane plane = imageParameters.getPlane();
        int n = 0;
        while ((float)n < f7) {
            float f8 = fArray2[n] - f5;
            int n2 = 0;
            while ((float)n2 < f6) {
                float f9 = fArray[n2] - f4;
                float f10 = f9 * f2 - f8 * f3;
                float f11 = f9 * f3 + f8 * f2;
                plane.data[n2][n] = (float)(Math.atan2(f11, f10) / Math.PI);
                ++n2;
            }
            ++n;
        }
        return plane;
    }
}

