/*
 * Decompiled with CFR 0.152.
 */
package vash.operation;

import vash.ImageParameters;
import vash.Plane;
import vash.Seed;
import vash.operation.OperationNode;
import vash.value.Bounded;
import vash.value.Position;

public class Spiral
extends OperationNode {
    private static final double MIN_N = 0.0;
    private static final double MAX_N = 10.0;
    private static final double MIN_B = -1.0;
    private static final double MAX_B = 1.0;
    private final Position center;
    private final Bounded n;
    private final Bounded b;

    private Spiral(Position position, Bounded bounded, Bounded bounded2, OperationNode operationNode) {
        super(3, 1);
        assert (bounded.hasBounds(0.0, 10.0));
        assert (bounded2.hasBounds(-1.0, 1.0));
        this.center = position;
        this._values[0] = this.center;
        this.n = bounded;
        this._values[1] = this.n;
        this.b = bounded2;
        this._values[2] = this.b;
        this._children[0] = operationNode;
    }

    public Spiral(double d, double d2, double d3, double d4, OperationNode operationNode) {
        this(new Position(d, d2), new Bounded(d3, 0.0, 10.0), new Bounded(d4, -1.0, 1.0), operationNode);
    }

    public Spiral(Seed seed) {
        this(new Position(seed), new Bounded(seed, 0.0, 10.0), new Bounded(seed, -1.0, 1.0), null);
    }

    public OperationNode clone() {
        return new Spiral(this.center.clone(), this.n.clone(), this.b.clone(), this._children[0].clone());
    }

    public Plane compute(ImageParameters imageParameters) {
        float[] fArray = imageParameters.getXValues();
        float[] fArray2 = imageParameters.getYValues();
        float f = (float)(2.0 / Math.sqrt(2.0));
        float f2 = (float)this.center.getX();
        float f3 = (float)this.center.getY();
        float f4 = (float)Math.floor(this.n.getV());
        float f5 = (float)this.b.getV();
        Plane plane = this._children[0].compute(imageParameters);
        Plane plane2 = imageParameters.getPlane();
        for (int i = 0; i < imageParameters.getH(); ++i) {
            float f6 = fArray2[i] - f3;
            for (int j = 0; j < imageParameters.getW(); ++j) {
                float f7;
                float f8 = fArray[j] - f2;
                float f9 = (f8 * f8 + f6 * f6) * f - 1.0f;
                float f10 = (float)(Math.atan2(f6, f8) / Math.PI);
                for (f7 = plane.data[j][i] - f9 + f5 * (float)Math.pow(f10, f4); f7 > 1.0f; f7 -= 1.0f) {
                }
                while (f7 < -1.0f) {
                    f7 += 1.0f;
                }
                f7 = (float)Math.abs((double)Math.abs(f7) - 0.5);
                plane2.data[j][i] = 4.0f * f7 - 1.0f;
            }
        }
        imageParameters.putPlane(plane);
        return plane2;
    }
}

