#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import gobject

from winswitch.util.simple_logger import Logger
from winswitch.ui.tray_util import setup_tray
from winswitch.util.main_loop import loop_init, loop_run

logger = Logger("tray_util_test")

tray = None

def test_tray():
	loop_init(True)
	def popup_menu(*args):
		logger.slog(None, *args)
	def activate_menu(*args):
		logger.slog(None, *args)
	def exit_if_unclean(*args):
		logger.slog(None, *args)
	def ask_quit(*args):
		logger.slog(None, *args)
	def handle_session_event(*args):
		logger.slog(None, *args)

	def start_tray(*args):
		global tray
		logger.slog(None, *args)
		try:
			tray = setup_tray(False, popup_menu, activate_menu, exit_if_unclean, ask_quit, handle_session_event, "winswitch_indicator")
			import pygtk
			pygtk.require("2.0")
			import gtk
			# create a menu (appindicator does not show without one!)
			menu = gtk.Menu()
			for i in xrange(2):
				item = gtk.MenuItem("Test-%d" % i)
				menu.append(item)
			menu.show_all()
			tray.set_menu(menu)
		except Exception, e:
			logger.serr(None, e, *args)
		logger.slog("tray=%s" % tray, *args)
	
	def request_attention():
		global tray
		tray.request_attention("hello", 10)
	
	def ready():
		global tray
		tray.ready()
	
	gobject.idle_add(start_tray)
	gobject.timeout_add(1000*5, ready)
	gobject.timeout_add(1000*10, request_attention)
	loop_run()

if __name__ == "__main__":
	test_tray()
