#!/usr/bin/env python

import argparse
import gobject
import gtk
import os

from winswitch.objects.client_session import ClientSession
from winswitch.util.main_loop import loop_init, loop_run, loop_exit
from winswitch.util.simple_logger import Logger
from winswitch.util.paths import WINSWITCH_SHARE_DIR
from winswitch.objects.global_settings import get_settings
from winswitch.objects.server_config import ServerConfig

logger=Logger("launch_session", log_colour=Logger.CYAN)

class LauncherSession(ClientSession):
	PERSIST = [ 'host', 'port', 'session_type' ]

	def __init(self):
		ClientSession.__init__(self)
		self.host = ""				#ie: "localhost"
		self.port = -1				#ie: 5901
		self.session_type = ""		#ie: "vnc"
		logger.slog("init")


class LauncherClient:

	def __init__(self):
		self.exit_requested = False

	def dummy_update(self, server, session, status):
		print "Update", (server, session, status)
		if status == "available" and not self.exit_requested:
			loop_exit()
			self.exit_requested = True

	def dummy_notify(self, *args):
		print "Notify", args

	def get_client_util(self, session_type, settings):
		from winswitch.consts import XPRA_TYPE, NX_TYPE, VNC_TYPE, SSH_TYPE, X11_TYPE, SCREEN_TYPE, LIBVIRT_TYPE, WINDOWS_TYPE, OSX_TYPE, GSTVIDEO_TYPE
		from winswitch.virt.xpra_client_util import XpraClientUtil
		from winswitch.virt.nx_client_util import NXClientUtil
		from winswitch.virt.vnc_client_util import VNCClientUtil
		from winswitch.virt.rdp_client_util import RDPClientUtil
		from winswitch.virt.ssh_client_util import SSHClientUtil
		from winswitch.virt.gstvideo_client_util import GSTVideoClientUtil
		from winswitch.virt.screen_client_util import ScreenClientUtil

		type_to_util = {XPRA_TYPE:		(settings.supports_xpra,	lambda : XpraClientUtil(self.dummy_update, self.dummy_notify)), 
						NX_TYPE:		(settings.supports_nx,		lambda : NXClientUtil(self.dummy_update, self.dummy_notify)),
						VNC_TYPE:		(settings.supports_vnc,		lambda : VNCClientUtil(self.dummy_update, self.dummy_notify)),
						WINDOWS_TYPE:	(settings.supports_vnc,		lambda : RDPClientUtil(self.dummy_update, self.dummy_notify)),
						OSX_TYPE:		(settings.supports_vnc,		lambda : VNCClientUtil(self.dummy_update, self.dummy_notify)),
						LIBVIRT_TYPE:	(settings.supports_vnc,		lambda : VNCClientUtil(self.dummy_update, self.dummy_notify)),
						SSH_TYPE:		(settings.supports_ssh,		lambda : SSHClientUtil(self.dummy_update, self.dummy, self.dummy_notify)),
						X11_TYPE:		(settings.supports_nx,		lambda : NXClientUtil(self.dummy_update, self.dummy_notify)),
						GSTVIDEO_TYPE:	(settings.supports_gstvideo,lambda : GSTVideoClientUtil(self.dummy_update, self.dummy_notify)),
						SCREEN_TYPE:	(settings.supports_screen,	lambda : ScreenClientUtil(self.dummy_update, self.dummy_notify))
		}

	
		enabled = None
		try:
			(enabled, constructor) = type_to_util[session_type]
		except KeyError:
			logger.serror("Selected session type is unknown (invalid key) ", session_type)
			for k in type_to_util.iterkeys():
				logger.slog(k)

		if not enabled:
			logger.serror("Session type", session_type, "is not enabled!")
			exit(1)

		client_util = constructor()
		return client_util

def launch_session(params):
	from winswitch.util.file_io import load_object_from_properties
	session = load_object_from_properties(params.file, LauncherSession, ["host", "port", "session_type"])
	if not session:
		logger.serror("Unable to load session parameters")
		exit(1)
		return False

	settings = get_settings(True)
	server = ServerConfig()

	client = LauncherClient()
	client_util = client.get_client_util(session.session_type, settings)

	client_util.attach(server, session, session.host, session.port)

	return False

def splash():
	splash = gtk.Window(gtk.WINDOW_TOPLEVEL);
	splash.set_title("Winswitch session launcher")
	splash.set_border_width(0)
	splash.set_decorated(False)
	splash.set_resizable(False)
	splash.set_position(gtk.WIN_POS_CENTER)

	img = gtk.Image()
	bg = os.path.join(WINSWITCH_SHARE_DIR, "splash.jpg")
	img.set_from_file(bg)
	splash.add(img)

	splash.show_all()
	gobject.timeout_add(2000, splash.hide_all)

def main():
	logger.slog("Winswitch session launcher")
	parser = argparse.ArgumentParser(description='Winswitch session launcher.')
	parser.add_argument('--version', action="store_const", const=1, help="Display Winswitch version and exit")
	parser.add_argument('file', help="Session file to load (.winsess)")
	params = parser.parse_args()

	if params.version == 1:
		from winswitch.util.version_info import print_version_info
		print_version_info()
		return

	splash()

	loop_init(False)

	gobject.timeout_add(1, launch_session, params)

	loop_run()

if __name__ == "__main__":
	main()
