#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import sys
import time

from winswitch.util.simple_logger import Logger, set_log_to_file, set_log_to_tty

logger=Logger("tunnel_monitor", log_colour=Logger.CYAN)

LIVE="live"

QUERY="query"
EXIT="exit"

def main():
	#disable logging so all we get is the port:
	set_log_to_file(False)
	set_log_to_tty(False)

	while True:
		sys.stdout.write("%s\n" % LIVE)
		sys.stdout.flush()
		time.sleep(1)
		ask = sys.stdin.readline().rstrip()
		if ask == EXIT:
			break
		if ask != QUERY:
			time.sleep(5)

if __name__ == "__main__":
	main()