/*
 * Decompiled with CFR 0.152.
 */
package vash;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import util.Base64;
import vash.AnimationMode;
import vash.Seed;
import vash.Vash;

public class Options {
    private static final String HELP_TEXT = "Vash -- the visual hash function\n\nUsage: java -jar Vash.jar [options]\n\nHelp:\n  --help                Show this help text\n  -V,--version          Show the Vash version\n  --known-algorithms    Show the options you can pass to --algorithm\n\nRequired Options:\n  -a,--algorithm\n              [String]  Select the image generator algorithm to use\n  -d,--data   [String]  The data to hash, as a string\n  -f,--file   [String]  The data, read from a file (use - to read from stdin)\n  -s,--salt   [String]  Provide a salt to the hashing algorithm.  This value\n                        should be encoded in base64 and will be normalized to\n                        the correct length for the algorithm, by appending 0's\n  -S,--salt-file\n              [String]  Provide the salt with bytes from a file.  Only as many\n                        bytes will be read as the selected algorithm requires\n                        (use - to read from stdin)\n\nOutput Options:\n  -w,--width  [Integer] The output image width\n  -h,--height [Integer] The output image height\n  -o,--output [String]  The filename to write to (use - to write to stdout)\n                        (default: \"output.png\")\n  -F,--format [String]  One of 'bmp', 'jpeg', or 'png'.  If not set this will\n                        be guessed from the extension of the output option.\n";
    public static final String[] KNOWN_ALGORITHMS = new String[]{"1.1", "1", "1-fast"};
    public static final String[] DEPRECATED_ALGORITHMS = new String[]{"1", "1-fast"};
    private String algorithm;
    private InputStream data;
    private byte[] salt;
    private String output = "output.png";
    private String outputFormat = null;
    private int width = 128;
    private int height = 128;
    private AnimationMode animationMode = AnimationMode.WRAP;
    private double duration = 15.0;
    private double period = 15.0;
    private double frameRate = 30.0;
    private final HashSet<String> debugFlags = new HashSet();

    public InputStream getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = new ByteArrayInputStream(byArray);
    }

    public void setData(String string) {
        if (string.equals("-")) {
            this.data = System.in;
        } else {
            try {
                this.data = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.getLocalizedMessage());
                System.exit(1);
            }
        }
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public static byte[] normalizeSaltBytes(String string, byte[] byArray) {
        int n = Seed.getSaltSizeForAlgorithm(string);
        if (n == 0) {
            System.err.format("The algorithm '%s' does not take a salt.%n", string);
            System.exit(1);
        }
        byte[] byArray2 = new byte[n];
        int n2 = Math.min(byArray2.length, byArray.length);
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] loadSaltFromFile(String string, InputStream inputStream) {
        int n = Seed.getSaltSizeForAlgorithm(string);
        if (n == 0) {
            System.err.format("The algorithm '%s' does not take a salt.%n", string);
            System.exit(1);
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        try {
            while (n2 != -1 && n3 < byArray.length) {
                n2 = inputStream.read(byArray, n3, byArray.length - n3);
                if (n2 == -1) continue;
                n3 += n2;
            }
        }
        catch (IOException iOException) {
            System.err.format("Reading salt file failed: %s%n", iOException.getLocalizedMessage());
            System.exit(1);
        }
        return byArray;
    }

    public void setSalt(String string, byte[] byArray) {
        this.salt = Options.normalizeSaltBytes(string, byArray);
    }

    public void setSalt(String string, String string2) {
        InputStream inputStream = null;
        if (string2.equals("-")) {
            inputStream = System.in;
        } else {
            try {
                inputStream = new BufferedInputStream(new FileInputStream(string2));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.getLocalizedMessage());
                System.exit(1);
            }
        }
        this.salt = this.loadSaltFromFile(string, inputStream);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String string) {
        this.outputFormat = string;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public AnimationMode getAnimationMode() {
        return this.animationMode;
    }

    public void setAnimationMode(AnimationMode animationMode) {
        this.animationMode = animationMode;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double d) {
        this.duration = d;
    }

    public double getPeriod() {
        return this.period;
    }

    public void setPeriod(double d) {
        this.period = d;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double d) {
        this.frameRate = d;
    }

    public void setDebugFlag(String string) {
        this.debugFlags.add(string);
    }

    public boolean hasDebugFlag(String string) {
        return this.debugFlags.contains(string);
    }

    public boolean hasADebugFlagSet(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.hasDebugFlag(string)) continue;
            return true;
        }
        return false;
    }

    public static void showKnownAlgorithms() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : DEPRECATED_ALGORITHMS) {
            hashSet.add(string);
        }
        System.out.println("Known Algorithms:");
        for (String string : KNOWN_ALGORITHMS) {
            System.out.format("\t%s", string);
            if (hashSet.contains(string)) {
                System.out.print("\t(deprecated)");
            }
            System.out.println("");
        }
    }

    public Options() {
    }

    /*
     * WARNING - void declaration
     */
    public Options(String[] stringArray) throws IllegalArgumentException {
        void var7_11;
        if (stringArray.length == 1 && stringArray[0].equals("-h")) {
            System.out.println("Warning: -h is short of --height; use --help instead\n");
            System.out.println(HELP_TEXT);
            System.exit(0);
        }
        String[] stringArray2 = new String[]{"--algorithm", "-a", "--data", "-d", "--file", "-f", "--salt", "-s", "--salt-file", "-S", "--output", "-o", "--format", "-F", "--width", "-w", "--height", "-h", "--animate-mode", "-A", "--duration", "-D", "--period", "-P", "--frame-rate", "-R"};
        HashSet<String> hashSet = new HashSet<String>(stringArray2.length);
        for (String object2 : stringArray2) {
            hashSet.add(object2);
        }
        int n = 0;
        int n2 = 0;
        String string = null;
        Object var7_10 = null;
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            String string3 = null;
            if (hashSet.contains(stringArray3)) {
                if (++i == stringArray.length) {
                    throw new IllegalArgumentException("The option '" + stringArray3.toString() + "' requires an argument.");
                }
                string3 = stringArray[i];
            }
            if (stringArray3.equals("--help")) {
                System.out.println(HELP_TEXT);
                System.exit(0);
                continue;
            }
            if (stringArray3.equals("--version") || stringArray3.equals("-V")) {
                System.out.println(Vash.VERSION);
                System.exit(0);
                continue;
            }
            if (stringArray3.equals("--known-algorithms")) {
                Options.showKnownAlgorithms();
                System.exit(0);
                continue;
            }
            if (stringArray3.equals("--algorithm") || stringArray3.equals("-a")) {
                this.setAlgorithm(string3);
                continue;
            }
            if (stringArray3.equals("--data") || stringArray3.equals("-d")) {
                this.setData(string3.getBytes());
                ++n;
                continue;
            }
            if (stringArray3.equals("--file") || stringArray3.equals("-f")) {
                this.setData(string3);
                string = string3;
                ++n2;
                continue;
            }
            if (stringArray3.equals("--salt") || stringArray3.equals("-s")) {
                try {
                    byte[] byArray = Base64.decode(string3);
                    continue;
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Failed to decode base64 salt.");
                }
            }
            if (stringArray3.equals("--salt-file") || stringArray3.equals("-S")) {
                string2 = string3;
                continue;
            }
            if (stringArray3.equals("--output") || stringArray3.equals("-o")) {
                this.setOutput(string3);
                continue;
            }
            if (stringArray3.equals("--format") || stringArray3.equals("-F")) {
                this.setOutputFormat(string3);
                continue;
            }
            if (stringArray3.equals("--width") || stringArray3.equals("-w")) {
                this.setWidth(Integer.decode(string3));
                continue;
            }
            if (stringArray3.equals("--height") || stringArray3.equals("-h")) {
                this.setHeight(Integer.decode(string3));
                continue;
            }
            if (stringArray3.equals("--animate-mode") || stringArray3.equals("-A")) {
                this.setAnimationMode(AnimationMode.parseAnimationMode(string3));
                continue;
            }
            if (stringArray3.equals("--duration") || stringArray3.equals("-D")) {
                this.setDuration(Double.parseDouble(string3));
                continue;
            }
            if (stringArray3.equals("--period") || stringArray3.equals("-P")) {
                this.setPeriod(Double.parseDouble(string3));
                continue;
            }
            if (stringArray3.equals("--frame-rate") || stringArray3.equals("-R")) {
                this.setFrameRate(Double.parseDouble(string3));
                continue;
            }
            if (stringArray3.equals("--debug-tree")) {
                this.setDebugFlag("TREE");
                continue;
            }
            if (stringArray3.equals("--debug-entropy")) {
                this.setDebugFlag("ENTROPY");
                continue;
            }
            throw new IllegalArgumentException(String.format("The option \"%s\" is not recognized.", new Object[]{stringArray3}));
        }
        if (n > 1) {
            throw new IllegalArgumentException("-d/--data must only be set once.");
        }
        if (n2 > 1) {
            throw new IllegalArgumentException("-f/--file must only be set once.");
        }
        if (n > 0 && n2 > 0) {
            throw new IllegalArgumentException("-d/--data and -f/--file must not both be set.");
        }
        if (this.getData() == null) {
            throw new IllegalArgumentException("The option -d or --data must be set.");
        }
        if (this.getAlgorithm() == null) {
            throw new IllegalArgumentException("The option -a or --algorithm must be set.");
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string4 : KNOWN_ALGORITHMS) {
            hashSet2.add(string4);
        }
        if (!hashSet2.contains(this.getAlgorithm())) {
            throw new IllegalArgumentException("Unknown seed algorithm: \"" + this.algorithm + "\"");
        }
        if (string2 != null && string != null && string2.equals(string)) {
            throw new IllegalArgumentException("Salt and Data may not be specified from the same file.");
        }
        if (string2 != null && var7_11 != null) {
            throw new IllegalArgumentException("A salt file and salt literal must not both be specified.");
        }
        if (string2 != null) {
            this.setSalt(this.getAlgorithm(), string2);
        } else if (var7_11 != null) {
            this.setSalt(this.getAlgorithm(), (byte[])var7_11);
        }
    }
}

