/*
 * Decompiled with CFR 0.152.
 */
package vash;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import vash.ImageParameters;
import vash.Seed;
import vash.TreeParameters;
import vash.operation.ColorNode;
import vash.operation.Operation;
import vash.operation.OperationFactory;
import vash.operation.OperationNode;
import vash.value.Value;

public class Tree {
    private static final Operation[] TOPS = new Operation[]{Operation.RGB};
    private static final Operation[] NODES = new Operation[]{Operation.ABSOLUTE, Operation.INVERT, Operation.ADD, Operation.DIVIDE, Operation.EXPONENTIATE, Operation.MODULUS, Operation.MULTIPLY, Operation.SINC, Operation.SINE, Operation.SPIRAL, Operation.SQUIRCLE};
    private static final Operation[] LEAFS = new Operation[]{Operation.CONST, Operation.ELLIPSE, Operation.FLOWER, Operation.GRADIENT_LINEAR, Operation.GRADIENT_RADIAL, Operation.POLAR_THETA};
    private static final Operation[] NODES_AND_LEAFS = Tree.concat(NODES, LEAFS);
    private final TreeParameters params;
    private final ColorNode tree;
    private final ArrayList<Value> values = new ArrayList();
    private ImageParameters ip;

    private static Operation[] concat(Operation[] operationArray, Operation[] operationArray2) {
        Operation[] operationArray3 = new Operation[operationArray.length + operationArray2.length];
        System.arraycopy(operationArray, 0, operationArray3, 0, operationArray.length);
        System.arraycopy(operationArray2, 0, operationArray3, operationArray.length, operationArray2.length);
        return operationArray3;
    }

    public Tree(TreeParameters treeParameters) {
        this.params = treeParameters;
        this.tree = this._buildToplevel();
        this.tree.accumulateValues(this.values);
    }

    public static boolean[] __buildChannelMask(Seed seed, int n) {
        switch (n) {
            case 3: {
                return new boolean[]{true, true, true};
            }
            case 2: {
                switch (seed.nextInt(3)) {
                    case 0: {
                        return new boolean[]{false, true, true};
                    }
                    case 1: {
                        return new boolean[]{true, false, true};
                    }
                    case 2: {
                        return new boolean[]{true, true, false};
                    }
                }
            }
            case 1: {
                switch (seed.nextInt(3)) {
                    case 0: {
                        return new boolean[]{true, false, false};
                    }
                    case 1: {
                        return new boolean[]{false, true, false};
                    }
                    case 2: {
                        return new boolean[]{false, false, true};
                    }
                }
            }
            case 0: {
                return new boolean[]{false, false, false};
            }
        }
        throw new IllegalArgumentException("BuildChannelMask needs count in [0..3]");
    }

    public static int __getChannelExclusionCount(Seed seed, double d) {
        if (d <= 0.0) {
            return 3;
        }
        if (d > 0.0 && d < 1.0) {
            if (seed.nextDouble() > d) {
                return 3;
            }
            return 2;
        }
        if (d == 1.0) {
            return 2;
        }
        if (d > 1.0 && d < 2.0) {
            if (seed.nextDouble() > d - 1.0) {
                return 2;
            }
            return 1;
        }
        if (d == 2.0) {
            return 1;
        }
        if (d > 2.0 && d < 3.0) {
            if (seed.nextDouble() > d - 2.0) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private void _setupChannelExclusions(ChannelParameters[] channelParametersArray) {
        Seed seed = this.params.getSeed();
        for (Operation operation : NODES_AND_LEAFS) {
            double d = this.params.getOperationChannels(operation);
            int n = Tree.__getChannelExclusionCount(seed, d);
            boolean[] blArray = Tree.__buildChannelMask(seed, n);
            for (int i = 0; i < 3; ++i) {
                if (!blArray[i]) continue;
                channelParametersArray[i].addExclude(operation);
            }
        }
    }

    private ColorNode _buildToplevel() {
        if (this.params.getSeed().getAlgorithm().equals("1.1")) {
            ColorNode colorNode = (ColorNode)this._selectAndCreateOp(0, new ChannelParameters());
            ChannelParameters[] channelParametersArray = new ChannelParameters[]{new ChannelParameters(), new ChannelParameters(), new ChannelParameters()};
            this._setupChannelExclusions(channelParametersArray);
            OperationNode operationNode = this._buildNode(1, channelParametersArray[0]);
            OperationNode operationNode2 = this._buildNode(1, channelParametersArray[1]);
            OperationNode operationNode3 = this._buildNode(1, channelParametersArray[2]);
            colorNode.setChild(0, operationNode);
            colorNode.setChild(1, operationNode2);
            colorNode.setChild(2, operationNode3);
            return colorNode;
        }
        return (ColorNode)this._buildNode(0, new ChannelParameters());
    }

    private OperationNode _buildNode(int n, ChannelParameters channelParameters) {
        OperationNode operationNode = this._selectAndCreateOp(n, channelParameters);
        for (int i = 0; i < operationNode.getChildCount(); ++i) {
            OperationNode operationNode2 = this._buildNode(n + 1, channelParameters);
            operationNode.setChild(i, operationNode2);
        }
        return operationNode;
    }

    private Operation _selectOp(int n, ChannelParameters channelParameters) {
        Operation[] operationArray = n == 0 ? TOPS : (n <= this.params.getMinDepth() ? NODES : (n >= this.params.getMaxDepth() ? LEAFS : NODES_AND_LEAFS));
        double d = 0.0;
        for (Operation operation : operationArray) {
            if (channelParameters.isExcluded(operation)) continue;
            d += this.params.getOperationRatio(operation);
        }
        double d2 = this.params.getSeed().nextDouble() * d;
        double d3 = 0.0;
        for (Operation operation : operationArray) {
            if (channelParameters.isExcluded(operation) || !((d3 += this.params.getOperationRatio(operation)) > d2)) continue;
            return operation;
        }
        throw new RuntimeException("Overflowed our OperationytecodeTable somehow at level: " + Integer.toString(n));
    }

    private OperationNode _selectAndCreateOp(int n, ChannelParameters channelParameters) {
        return OperationFactory.createNode(this._selectOp(n, channelParameters), this.params.getSeed());
    }

    public void show(String string) throws IOException {
        OutputStream outputStream = string.equals("-") ? System.out : new FileOutputStream(string);
        this.tree.show(outputStream, 0);
        outputStream.close();
    }

    public void setGenerationParameters(ImageParameters imageParameters) {
        this.ip = imageParameters;
    }

    void setTime(double d, double d2) {
        for (Value value : this.values) {
            value.setTime(d, d2);
        }
    }

    public byte[] generateCurrentFrame() {
        if (this.ip == null) {
            throw new IllegalArgumentException("setGenerationParameters must be called to set ImageParameters");
        }
        return this.tree.compute(this.ip, true);
    }

    class ChannelParameters {
        HashSet<Operation> exclude = new HashSet();

        ChannelParameters() {
        }

        void addExclude(Operation operation) {
            this.exclude.add(operation);
        }

        boolean isExcluded(Operation operation) {
            return this.exclude.contains((Object)operation);
        }
    }
}

